/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

import java.util.ArrayList;
import java.util.Locale;
import oracle.dbtools.data.formattors.DataTypeFormatterRegistry;
import oracle.dbtools.data.formattors.ITypeFormattor;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.db.DBUtil;

public class LoadSql {
    private Locale _locale;
    private boolean _useQuotedNames = true;
    private String _schemaName;
    private String _tableName;

    public LoadSql(String schemaName, String tableName) {
        this(schemaName, tableName, null);
    }

    public LoadSql(String schemaName, String tableName, Locale locale) {
        this._schemaName = schemaName;
        this._tableName = tableName;
        this._locale = locale;
    }

    public void useQuotedNames(boolean useQuotedNames) {
        this._useQuotedNames = useQuotedNames;
    }

    public void setSchemaName(String schemaName) {
        this._schemaName = schemaName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }

    public String getDeleteStatement() {
        return "delete from " + this.addUser(this.addTableName(this._tableName));
    }

    public String getTruncateStatement() {
        return "truncate table " + this.addUser(this.addTableName(this._tableName));
    }

    public String getInsertStatement(Column[] cols, Object[] row, INSERT_FORMAT insertFormat) {
        int i;
        boolean isPrepare = false;
        boolean isError = false;
        StringBuffer insert = new StringBuffer();
        if (insertFormat != INSERT_FORMAT.SCRIPT) {
            if (insertFormat == INSERT_FORMAT.PREPARE) {
                isPrepare = true;
            } else if (insertFormat == INSERT_FORMAT.ERROR) {
                isError = true;
            } else {
                insert.append("--");
            }
        }
        insert.append("INSERT INTO ");
        insert.append(this.addUser(this.addTableName(this._tableName)));
        insert.append("(");
        ArrayList<Object> orderedRowList = new ArrayList<Object>();
        for (int i2 = 0; i2 < cols.length; ++i2) {
            if (i2 < row.length) {
                orderedRowList.add(row[cols[i2].getSourceColID()]);
                continue;
            }
            orderedRowList.add("");
        }
        Object[] orderedRow = orderedRowList.toArray();
        ITypeFormattor fmtor = null;
        for (i = 0; i < cols.length; ++i) {
            if (i != 0) {
                insert.append(",");
            }
            if (this._useQuotedNames) {
                insert.append(DBUtil.addDoubleQuote(cols[i].getName()));
                continue;
            }
            insert.append(cols[i].getName());
        }
        if (insertFormat == INSERT_FORMAT.COMMENT) {
            insert.append(")\n-- VALUES ");
        } else if (isPrepare) {
            insert.append(") VALUES ");
        } else {
            insert.append(")\nVALUES ");
        }
        if (!isError) {
            insert.append("(");
            for (i = 0; i < orderedRow.length; ++i) {
                if (i != 0) {
                    insert.append(",");
                }
                if (isPrepare) {
                    insert.append("?");
                    continue;
                }
                fmtor = DataTypeFormatterRegistry.getInstance().getFormattor(cols[i].getType());
                if (fmtor == null) {
                    fmtor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
                }
                fmtor.setLocale(this._locale);
                insert.append(fmtor.formatData(orderedRow[i], cols[i]));
            }
        }
        if (!isError) {
            insert.append(")");
        }
        if (!isError && !isPrepare) {
            insert.append(";");
        }
        return insert.toString();
    }

    private String addUser(String name) {
        return this._schemaName != null && this._schemaName.length() > 0 ? DBUtil.addDoubleQuote(this._schemaName) + "." + name : name;
    }

    protected String addTableName(String name) {
        if (this._useQuotedNames) {
            String[] qName = name.split("@");
            String tName = DBUtil.addDoubleQuote(qName[0]);
            if (qName.length > 1) {
                tName = tName + "@" + qName[1];
            }
            return tName;
        }
        return name;
    }

    protected String addDoubleQuote(String name) {
        if (this._useQuotedNames) {
            return DBUtil.addDoubleQuote(name);
        }
        return name;
    }

    public static enum INSERT_FORMAT {
        SCRIPT,
        PREPARE,
        ERROR,
        COMMENT;

    }
}

