/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.ParseNode;

class Successor
extends Attribute {
    String ref;

    public Successor(String name) {
        this.name = name;
        this.ref = Successor.referredTo(name);
    }

    @Override
    Set<Tuple> eval(Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root) {
        int nameCol = attributePositions.get(this.name);
        int refCol = attributePositions.get(this.ref);
        for (Tuple t : candidates) {
            if (t.values[refCol] == null) continue;
            t.values[nameCol] = t.values[refCol].parent();
            if (t.values[nameCol] == null) continue;
            t.values[nameCol] = Successor.getSuccessor(t.values[refCol], t.values[nameCol]);
        }
        return candidates;
    }

    @Override
    Attribute referredTo(Map<String, Attribute> varDefs) {
        return varDefs.get(this.ref);
    }
}

