/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.IdentedPredicate;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

class AncestorDescendantNodes
extends IdentedPredicate {
    String a;
    String d;
    boolean isStrict;

    public AncestorDescendantNodes(String ancestor, String descendant, boolean isStrict) {
        this.a = ancestor;
        this.d = descendant;
        this.isStrict = isStrict;
    }

    @Override
    public boolean eval(Map<String, Integer> attributePositions, ParseNode[] tuple, List<LexerToken> src) {
        ParseNode nodeA = this.getNode(this.a, attributePositions, tuple);
        if (nodeA == null) {
            return false;
        }
        ParseNode nodeD = this.getNode(this.d, attributePositions, tuple);
        if (nodeD == null) {
            return false;
        }
        if (this.isStrict) {
            return nodeA.from <= nodeD.from && nodeD.to <= nodeA.to && (nodeA.from != nodeD.from || nodeD.to != nodeA.to);
        }
        return nodeA.from <= nodeD.from && nodeD.to <= nodeA.to;
    }

    public String toString() {
        if (this.isStrict) {
            return this.a + " < " + this.d;
        }
        return this.a + " <= " + this.d;
    }

    @Override
    public void variables(Set<String> ret, boolean optimizeEqs) {
        if (optimizeEqs) {
            AncestorDescendantNodes.variables(this.a + "<" + (!this.isStrict ? "=" : "") + this.d, ret);
        } else {
            AncestorDescendantNodes.variables(this.a, ret);
            AncestorDescendantNodes.variables(this.d, ret);
        }
    }

    @Override
    public void signature(Set<String> ret) {
        AncestorDescendantNodes.variables(this.a, ret);
        AncestorDescendantNodes.variables(this.d, ret);
    }

    @Override
    public Predicate isRelated(String var1, String var2, Map<String, Attribute> varDefs) {
        Attribute attr1 = varDefs.get(this.a);
        Attribute attr2 = varDefs.get(this.d);
        if (attr1.isDependent(var1, varDefs) && attr2.isDependent(var2, varDefs) || attr2.isDependent(var1, varDefs) && attr1.isDependent(var2, varDefs)) {
            return this;
        }
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        int pos = this.a.indexOf(46);
        if (0 < pos) {
            ret.put(this.a.substring(0, pos), true);
        }
        if (0 < (pos = this.d.indexOf(46))) {
            ret.put(this.d.substring(0, pos), true);
        }
        return ret;
    }

    Set<Tuple> innerLoop(ParseNode node, MaterializedPredicate anc) {
        if (1 < anc.arity()) {
            throw new AssertionError((Object)"1 < anc.arity()");
        }
        TreeSet<Tuple> ret = new TreeSet<Tuple>();
        if (node != null && this.isStrict) {
            node = node.parent();
        }
        while (node != null) {
            Tuple candidate = new Tuple(new ParseNode[]{node});
            if (anc.getTuples().contains(candidate)) {
                ret.add(candidate);
            }
            node = node.parent();
        }
        return ret;
    }
}

