/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.util.Service;

public class XML2Table
extends Program {
    static String currentDir = "/oracle/dbtools/app/";
    private static Earley xmlParser = null;
    private static String dir = "/oracle/dbtools/parser/";
    private Parsed prg;
    boolean debug = false;

    public static void main(String[] args) throws Exception {
        String program = Service.readFile(XML2Table.class, currentDir + "xml2table.prg");
        XML2Table xmlProgram = new XML2Table(program);
        String input = Service.readFile(XML2Table.class, currentDir + "xml.txt");
        xmlProgram.run(input, null, xmlProgram);
    }

    public static Earley xmlParser() throws IOException {
        if (xmlParser != null) {
            return xmlParser;
        }
        Parsed xmlGrammar = new Parsed(Service.readFile(Grammar.class, dir + "xml.grammar"), Grammar.bnfParser(), "grammar");
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        Grammar.grammar(xmlGrammar.getRoot(), xmlGrammar.getSrc(), rules);
        xmlParser = new Earley(rules){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                if (symbol != this.identifier) {
                    return false;
                }
                LexerToken token = src.get(y);
                if (token.type == Token.DQUOTED_STRING) {
                    return true;
                }
                return token.type == Token.IDENTIFIER;
            }
        };
        return xmlParser;
    }

    public XML2Table(String arboriProgram) throws IOException {
        super(XML2Table.xmlParser());
        this.compile(arboriProgram);
    }

    public XML2Table() throws IOException {
        this(Service.readFile(XML2Table.class, currentDir + "xml2table.prg"));
    }

    public Map<String, MaterializedPredicate> run(String input, List<LexerToken> src, Object callback) throws IOException {
        if (src == null) {
            src = LexerToken.parse(input);
        }
        Parsed target = new Parsed(input, src, XML2Table.xmlParser(), (String)null);
        if (this.debug) {
            target.getRoot().printTree();
        }
        Map<String, MaterializedPredicate> predicateVectors = this.eval(target, callback);
        return predicateVectors;
    }

    void tupleNodes(Parsed target, Map<String, ParseNode> tuple) {
        System.out.println("**tupleNodes(): **" + MaterializedPredicate.tupleMnemonics(tuple, target.getSrc()));
    }

    void values(Parsed target, Map<String, ParseNode> tuple) {
        System.out.println("**values(): **" + MaterializedPredicate.tupleMnemonics(tuple, target.getSrc(), true));
    }
}

