/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.app.Obfuscator;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class SqlRecognizer {
    static final String path = "/oracle/dbtools/app/";

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(SqlRecognizer.class, "test.sql");
        SqlRecognizer.test(input);
    }

    private static void test(String input) {
        System.out.println(SqlRecognizer.getTables(input));
    }

    public Map<String, Set<Long>> recognize(String input, List<LexerToken> src) {
        return this.recognize(input, src, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Set<Long>> recognize(String input, List<LexerToken> src, String extraSymbol) {
        try {
            Program.debug = false;
            String recognitionPrg = Service.readFile(Obfuscator.class, "/oracle/dbtools/app/recognize.prg");
            if (extraSymbol != null) {
                List<LexerToken> tmp = LexerToken.parse(recognitionPrg);
                boolean found = false;
                for (LexerToken t : tmp) {
                    if (!t.content.equals(extraSymbol)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    recognitionPrg = recognitionPrg + "\n\"" + extraSymbol + "\": [" + extraSymbol + ") " + extraSymbol + ";";
                }
            }
            Map<String, MaterializedPredicate> predicateVectors = new SqlProgram(recognitionPrg).run(input);
            TreeMap<String, Set<Long>> ret = new TreeMap<String, Set<Long>>();
            Iterator<Object> i$ = predicateVectors.keySet().iterator();
            while (true) {
                if (!i$.hasNext()) {
                    return ret;
                }
                String key = (String)i$.next();
                if (!key.startsWith("\"")) continue;
                String unquotedPredicateName = key.substring(1, key.length() - 1);
                this.fetch(unquotedPredicateName, src, predicateVectors, ret);
            }
        }
        catch (SyntaxError e) {
            throw e;
        }
        catch (AssertionError e) {
            System.err.println(((Throwable)((Object)e)).getMessage());
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void fetch(String predicate, List<LexerToken> src, Map<String, MaterializedPredicate> predicateVectors, Map<String, Set<Long>> ret) {
        MaterializedPredicate symbols = predicateVectors.get("\"" + predicate + "\"");
        HashSet<Long> intervals = new HashSet<Long>();
        if (null == symbols.getAttribute(predicate)) {
            return;
        }
        ret.put(predicate, intervals);
        for (Tuple t : symbols.getTuples()) {
            ParseNode pc = symbols.getAttribute(t, predicate);
            LexerToken f = src.get(pc.from);
            LexerToken t_1 = src.get(pc.to - 1);
            intervals.add(Service.lPair(f.begin, t_1.end));
        }
    }

    public static Map<Integer, String> fragmentAtLocation(String input, String targetSymbol) {
        List<LexerToken> src = LexerToken.parse(input);
        SqlRecognizer o = new SqlRecognizer();
        TreeMap<Integer, String> ret = new TreeMap<Integer, String>();
        Map<String, Set<Long>> output = o.recognize(input, src, targetSymbol);
        for (String symbol : output.keySet()) {
            if (!targetSymbol.equals(symbol)) continue;
            for (Long interval : output.get(symbol)) {
                int from = Service.lX(interval);
                int to = Service.lY(interval);
                ret.put(from, input.substring(from, to));
            }
        }
        return ret;
    }

    public static List<String> getList(String input, String targetSymbol) {
        Map<Integer, String> tmp = SqlRecognizer.fragmentAtLocation(input, targetSymbol);
        LinkedList<String> ret = new LinkedList<String>();
        int lastPos = -1;
        for (int pos : tmp.keySet()) {
            if (pos <= lastPos) {
                throw new AssertionError((Object)"pos <= lastPos");
            }
            ret.add(tmp.get(pos));
            lastPos = pos;
        }
        return ret;
    }

    public static List<String> getColumns(String input) {
        return SqlRecognizer.getList(input, "columnSelect");
    }

    public static List<String> getTables(String input) {
        return SqlRecognizer.getList(input, "tableFrom");
    }

    public static List<String> getPredicates(String input) {
        return SqlRecognizer.getList(input, "predicateWhere");
    }

    public static List<String> getOrderBy(String input) {
        return SqlRecognizer.getList(input, "orderBy");
    }

    public static List<String> getGroupBy(String input) {
        return SqlRecognizer.getList(input, "groupBy");
    }

    public static List<String> getStatements(String input) {
        input = SqlRecognizer.massage(input);
        return SqlRecognizer.getList(input, "sql_statement");
    }

    public static List<String> getAssignedBinds(String input) {
        input = SqlRecognizer.massage(input);
        return SqlRecognizer.getList(input, "assignedBind");
    }

    private static String massage(String input) {
        if (2 < (input = input.trim()).length() && input.startsWith("{") && input.endsWith("}")) {
            input = input.substring(1, input.length() - 1);
        }
        return input;
    }

    public static Map<Integer, String> getUserOrRole(String input) {
        Map<Integer, String> ret = SqlRecognizer.fragmentAtLocation(input, "role");
        if (0 < ret.size()) {
            return ret;
        }
        return SqlRecognizer.fragmentAtLocation(input, "user");
    }
}

