/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.app.Format;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class FormattingPreferences {
    public static boolean debug = false;
    public static String breakOnSubqueries = "breakOnSubqueries";
    public static String breakAnsiiJoin = "breakAnsiiJoin";
    public static String breakParenCondition = "breakParenCondition";

    public static void invokeAllGuessMethods(String sample) {
        List<LexerToken> src = LexerToken.parse(sample);
        SqlEarley earley = SqlEarley.getInstance();
        Matrix matrix = new Matrix(earley);
        ParseNode root = earley.parse(src);
        Parsed target = null;
        if (Format.programInstance == null) {
            try {
                Format.programInstance = new SqlProgram(Service.readFile(Format.class, "/oracle/dbtools/app/format.prg"));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        target = new Parsed(sample, src, root);
        Map<String, MaterializedPredicate> rels = Format.programInstance.eval(target);
        for (Method m : FormattingPreferences.class.getDeclaredMethods()) {
            if (!m.getName().startsWith("guess") || !Modifier.isPublic(m.getModifiers())) continue;
            try {
                m.invoke(null, sample, src, root, rels);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static void guessSingleLineComments(String sample, List<LexerToken> srcDummy, ParseNode rootDummy, Map<String, MaterializedPredicate> rels) {
        int slComments = 0;
        int mlComments = 0;
        List<LexerToken> src = LexerToken.parse(sample, true);
        for (LexerToken t : src) {
            if (t.type == Token.COMMENT) {
                ++mlComments;
                continue;
            }
            if (t.type != Token.LINE_COMMENT) continue;
            ++slComments;
        }
        if (debug) {
            System.out.println("==================SingleLineComments==================");
            System.out.println("slComments=" + slComments);
            System.out.println("mlComments=" + mlComments);
        }
        if (3 < slComments && mlComments * 20 < slComments) {
            Format.options.put(Format.singleLineComments, (Object)Format.InlineComments.SingleLine);
        } else if (3 < mlComments && slComments * 20 < mlComments) {
            Format.options.put(Format.singleLineComments, (Object)Format.InlineComments.MultiLine);
        } else {
            Format.options.put(Format.singleLineComments, (Object)Format.InlineComments.CommentsUnchanged);
        }
    }

    public static void guessKwCase(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        FormattingPreferences.guessCase(sample, src, root, true);
    }

    public static void guessIdCase(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        FormattingPreferences.guessCase(sample, src, root, false);
    }

    private static void guessCase(String sample, List<LexerToken> src, ParseNode root, boolean isKw) {
        int cntUpper = 0;
        int cntLower = 0;
        int cntInitcap = 0;
        for (ParseNode desc : root.descendants()) {
            String word;
            if (desc.from + 1 != desc.to || desc.contains(SqlEarley.getInstance().identifier) == isKw || !Character.isLetter((word = src.get((int)desc.from).content).charAt(0)) || word.length() < 2) continue;
            if (Character.isUpperCase(word.charAt(0)) && Character.isUpperCase(word.charAt(1))) {
                ++cntUpper;
                continue;
            }
            if (Character.isUpperCase(word.charAt(0)) && Character.isLowerCase(word.charAt(1))) {
                ++cntInitcap;
                continue;
            }
            if (!Character.isLowerCase(word.charAt(0)) || !Character.isLowerCase(word.charAt(1))) continue;
            ++cntLower;
        }
        Format.Case ret = Format.Case.NoCaseChange;
        if (cntLower * 9 < cntUpper && cntInitcap * 10 < cntUpper) {
            ret = Format.Case.UPPER;
        }
        if (cntUpper * 9 < cntLower && cntInitcap * 10 < cntLower) {
            ret = Format.Case.lower;
        }
        if (cntLower * 9 < cntInitcap && cntUpper * 10 < cntInitcap) {
            ret = Format.Case.InitCap;
        }
        if (debug) {
            System.out.println("==================" + (isKw ? "keywords" : "identifiers") + "==================");
            System.out.println("Upper=" + cntUpper);
            System.out.println("Lower=" + cntLower);
            System.out.println("Initcap=" + cntInitcap);
        }
        Format.options.put(isKw ? Format.kwCase : Format.idCase, (Object)ret);
    }

    public static void guessSpaces(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        int[] idents = new int[200];
        StringTokenizer st = new StringTokenizer(sample, "\n");
        int priorFullIndent = -1;
        LinkedList<Integer> priorRelativeIndents = new LinkedList<Integer>();
        while (st.hasMoreTokens()) {
            Integer tmp;
            int ident;
            String token = st.nextToken();
            token = token.replace("\r", "");
            if ((token = token.replace("\t", "")).length() == 0) continue;
            for (ident = 0; ident < token.length() && token.charAt(ident) == ' '; ++ident) {
            }
            if (priorFullIndent == -1) {
                priorFullIndent = ident;
                priorRelativeIndents.add(ident);
                continue;
            }
            int index = ident - priorFullIndent;
            if (index == 0 && (tmp = (Integer)priorRelativeIndents.getLast()) != 0) {
                index = tmp;
            }
            if (index < 0) {
                index = -index;
                priorRelativeIndents.removeLast();
            } else if (priorFullIndent < ident) {
                priorRelativeIndents.add(index);
            }
            if (index != 0) {
                int n = index;
                idents[n] = idents[n] + 1;
            }
            priorFullIndent = ident;
        }
        if (debug) {
            System.out.println("==================spaces==================");
            for (int i = 0; i < idents.length; ++i) {
                if (idents[i] == 0) continue;
                System.out.println("idents[" + i + "]=" + idents[i]);
            }
        }
        int ret = 1;
        for (int i = 1; i < idents.length; ++i) {
            if (idents[ret] >= idents[i]) continue;
            ret = i;
        }
        Format.options.put(Format.identSpaces, ret);
    }

    private static void guessAlign(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels, String idSymbol, String id1Symbol, String scopeSymbol, String formatOpt) {
        int aligned = 0;
        int misaligned = 0;
        TreeMap<ParseNode, LinkedList<Integer>> offsets = new TreeMap<ParseNode, LinkedList<Integer>>();
        MaterializedPredicate idsInTheScope = rels.get("paddedIdsInScope");
        for (Tuple t : idsInTheScope.getTuples()) {
            ParseNode id = idsInTheScope.getAttribute(t, "id");
            ParseNode id1 = idsInTheScope.getAttribute(t, "id+1");
            ParseNode scope = idsInTheScope.getAttribute(t, "scope");
            if (idSymbol != null && !id.contains(idSymbol) || id1Symbol != null && !id1.contains(id1Symbol) || scopeSymbol != null && !scope.contains(scopeSymbol)) continue;
            int nlPos = sample.substring(0, src.get((int)id.from).begin).lastIndexOf(10);
            LinkedList<Integer> localOffsets = (LinkedList<Integer>)offsets.get(scope);
            if (localOffsets == null) {
                localOffsets = new LinkedList<Integer>();
                offsets.put(scope, localOffsets);
            }
            localOffsets.add(src.get((int)id1.from).begin - nlPos);
        }
        for (ParseNode scope : offsets.keySet()) {
            List localOffsets = (List)offsets.get(scope);
            Integer prior = null;
            Iterator i$ = localOffsets.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                if (prior == null) {
                    prior = i;
                    continue;
                }
                if (prior == i) {
                    ++aligned;
                } else {
                    ++misaligned;
                }
                prior = i;
            }
        }
        if (debug) {
            System.out.println("==================" + formatOpt + "==================");
            System.out.println("aligned=" + aligned);
            System.out.println("misaligned=" + misaligned);
        }
        if (0 < aligned || 0 < misaligned) {
            Format.options.put(formatOpt, 2 < aligned && misaligned * 5 < aligned);
        }
    }

    public static void guessAlignTypeDecl(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        FormattingPreferences.guessAlign(sample, src, root, rels, null, "datatype", null, Format.alignTypeDecl);
        FormattingPreferences.guessAlign(sample, src, root, rels, "decl_id", null, null, Format.alignTypeDecl);
    }

    public static void guessAlignNamedArgs(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        FormattingPreferences.guessAlign(sample, src, root, rels, "sim_expr", "'='", "paren_expr_list", Format.alignNamedArgs);
    }

    public static void guessAlignAssignments(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        FormattingPreferences.guessAlign(sample, src, root, rels, "name", "':'", null, Format.alignAssignments);
    }

    public static void guessAlignEquality(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        FormattingPreferences.guessAlign(sample, src, root, rels, "column", "'='", "where_clause", Format.alignEquality);
    }

    public static void guessUseTab(String sample, List<LexerToken> srcDummy, ParseNode root, Map<String, MaterializedPredicate> rels) {
        int tabNo = 0;
        int spaceNo = 0;
        StringTokenizer st = new StringTokenizer(sample, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ((token = token.replace("\r", "")).startsWith("\t")) {
                ++tabNo;
            }
            if (!token.startsWith(" ")) continue;
            ++spaceNo;
        }
        if (debug) {
            System.out.println("==================UseTab==================");
            System.out.println("tabNo=" + tabNo);
            System.out.println("spaceNo=" + spaceNo);
        }
        Format.options.put(Format.useTab, spaceNo < tabNo);
    }

    private static void guessBreaks(String sample, String symbol, String fmtOption) {
        int before = 0;
        int after = 0;
        int noBreak = 0;
        StringTokenizer st = new StringTokenizer(sample, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            token = token.replace("\r", "");
            token = token.replace("\t", "");
            if ((token = token.replace(" ", "")).startsWith(symbol)) {
                ++before;
            }
            if (token.endsWith(symbol)) {
                ++after;
            }
            if (token.indexOf(symbol) == token.lastIndexOf(symbol)) continue;
            ++noBreak;
        }
        if (debug) {
            System.out.println("==================" + fmtOption + "==================");
            System.out.println("before=" + before);
            System.out.println("after=" + after);
            System.out.println("noBreak=" + noBreak);
        }
        if (before > after && before > noBreak) {
            Format.options.put(Format.breaksComma, (Object)Format.Breaks.Before);
        } else if (before < after && noBreak < after) {
            Format.options.put(Format.breaksComma, (Object)Format.Breaks.After);
        } else if (before < noBreak && after < noBreak) {
            Format.options.put(Format.breaksComma, (Object)Format.Breaks.None);
        }
    }

    public static void guessBreaksComma(String sample, List<LexerToken> srcDummy, ParseNode root, Map<String, MaterializedPredicate> rels) {
        FormattingPreferences.guessBreaks(sample, ",", Format.breaksComma);
    }

    public static void guessBreaksConcat(String sample, List<LexerToken> srcDummy, ParseNode root, Map<String, MaterializedPredicate> rels) {
        FormattingPreferences.guessBreaks(sample, "||", Format.breaksConcat);
    }

    private static boolean matchesSyntax(ParseNode node, String syntax) {
        if (node == null) {
            return false;
        }
        if (node.contains(syntax)) {
            return true;
        }
        ParseNode child = node.parent();
        return FormattingPreferences.matchesSyntax(child, syntax);
    }

    private static long balanceOfBreaksAfterToken(String sample, List<LexerToken> src, ParseNode root, String symbol, String syntax) {
        return FormattingPreferences.balanceOfBreaksAroundToken(sample, src, root, symbol, syntax, true);
    }

    private static long balanceOfBreaksAroundToken(String sample, List<LexerToken> src, ParseNode root, String symbol, String syntax, boolean after) {
        int total = 0;
        int matches = 0;
        int pos = -1;
        LexerToken prior = null;
        for (LexerToken t : src) {
            ++pos;
            if (symbol.equalsIgnoreCase(t.content)) {
                if (sample.length() < t.end + 2) break;
                if (!FormattingPreferences.matchesSyntax(root.leafAtPos(pos), syntax)) continue;
                ++total;
                String tmp = sample.substring(t.end, t.end + 2);
                if (!after) {
                    if (prior == null) continue;
                    tmp = sample.substring(prior.end, prior.end + 2);
                }
                if (tmp.startsWith("\n")) {
                    ++matches;
                } else if (tmp.startsWith("\r\n")) {
                    ++matches;
                }
            }
            prior = t;
        }
        if (debug) {
            System.out.println("==================balanceOfBreaks " + (after ? "After" : "Before") + " Token " + symbol + "==================");
            System.out.println("matches=" + matches);
            System.out.println("total=" + total);
        }
        return Service.lPair(matches, total);
    }

    public static void guessBreaksAroundLogicalConjunctions(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "OR", "condition");
        int matches = Service.lX(pair);
        int total = Service.lY(pair);
        pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "AND", "condition");
        matches += Service.lX(pair);
        total += Service.lY(pair);
        pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "OR", "pls_expr");
        matches += Service.lX(pair);
        total += Service.lY(pair);
        pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "AND", "pls_expr");
        int matchesAfter = matches += Service.lX(pair);
        int totalAfter = total += Service.lY(pair);
        pair = FormattingPreferences.balanceOfBreaksAroundToken(sample, src, root, "OR", "condition", false);
        matches = Service.lX(pair);
        total = Service.lY(pair);
        pair = FormattingPreferences.balanceOfBreaksAroundToken(sample, src, root, "AND", "condition", false);
        matches += Service.lX(pair);
        total += Service.lY(pair);
        pair = FormattingPreferences.balanceOfBreaksAroundToken(sample, src, root, "OR", "pls_expr", false);
        matches += Service.lX(pair);
        total += Service.lY(pair);
        if (0 < totalAfter & 0 < (total += Service.lY(pair = FormattingPreferences.balanceOfBreaksAroundToken(sample, src, root, "AND", "pls_expr", false))) && totalAfter < matchesAfter * 2 & total < (matches += Service.lX(pair)) * 2) {
            Format.options.put(Format.breaksAroundLogicalConjunctions, (Object)Format.Breaks.BeforeAndAfter);
            return;
        }
        if (0 < totalAfter && totalAfter < matchesAfter * 2) {
            Format.options.put(Format.breaksAroundLogicalConjunctions, (Object)Format.Breaks.After);
            return;
        }
        if (0 < total && total < matches * 2) {
            Format.options.put(Format.breaksAroundLogicalConjunctions, (Object)Format.Breaks.Before);
            return;
        }
        if (0 < totalAfter & 0 < total) {
            Format.options.put(Format.breaksAroundLogicalConjunctions, (Object)Format.Breaks.None);
        }
    }

    public static void guessBreaksAfterSelect(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "SELECT", "query_block");
        int matches = Service.lX(pair);
        int total = Service.lY(pair);
        if (0 < total) {
            Format.options.put(Format.breaksAfterSelect, 0 < matches);
        }
    }

    public static void guessBreaksAfterFrom(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "FROM", "query_block");
        int matches = Service.lX(pair);
        int total = Service.lY(pair);
        if (0 < total) {
            Format.options.put(Format.breaksAfterFrom, 0 < matches);
        }
    }

    public static void guessBreaksAfterWhere(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "WHERE", "query_block");
        int matches = Service.lX(pair);
        int total = Service.lY(pair);
        if (0 < total) {
            Format.options.put(Format.breaksAfterWhere, 0 < matches);
        }
    }

    public static void guessBreakAfterCase(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "CASE", "case_expression");
        int matches = Service.lX(pair);
        int total = Service.lY(pair);
        pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "CASE", "case_expr");
        matches += Service.lX(pair);
        total = Service.lY(pair);
        if (0 < total) {
            Format.options.put(Format.breakAfterCase, 0 < matches);
        }
    }

    public static void guessBreakAfterWhen(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "WHEN", "case_expression");
        int matches = Service.lX(pair);
        int total = Service.lY(pair);
        pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "WHEN", "case_expr");
        matches += Service.lX(pair);
        total = Service.lY(pair);
        if (0 < total) {
            Format.options.put(Format.breakAfterWhen, 0 < matches);
        }
    }

    public static void guessBreakAfterThen(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "THEN", "case_expression");
        int matches = Service.lX(pair);
        int total = Service.lY(pair);
        pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "THEN", "case_expr");
        matches += Service.lX(pair);
        total = Service.lY(pair);
        if (0 < total) {
            Format.options.put(Format.breakAfterThen, 0 < matches);
        }
    }

    public static void guessBreakAfterElse(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "ELSE", "case_expression");
        int matches = Service.lX(pair);
        int total = Service.lY(pair);
        pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "ELSE", "case_expr");
        matches += Service.lX(pair);
        total = Service.lY(pair);
        if (0 < total) {
            Format.options.put(Format.breakAfterElse, 0 < matches);
        }
    }

    public static void guessBreakAfterIf(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "IF", "if_stmt");
        int matches = Service.lX(pair);
        int total = Service.lY(pair);
        if (0 < total) {
            Format.options.put(Format.breakAfterIf, 0 < matches);
        }
    }

    public static void guessBreakAfterElseif(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "ELSIF", "if_stmt");
        int matches = Service.lX(pair);
        int total = Service.lY(pair);
        if (0 < total) {
            Format.options.put(Format.breakAfterElseif, 0 < matches);
        }
    }

    public static void guessBreakAfterWhile(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = FormattingPreferences.balanceOfBreaksAfterToken(sample, src, root, "WHILE", "iteration_scheme");
        int matches = Service.lX(pair);
        int total = Service.lY(pair);
        if (0 < total) {
            Format.options.put(Format.breakAfterWhile, 0 < matches);
        }
    }

    public static void guessCommasPerLine(String sample, List<LexerToken> srcDummy, ParseNode root, Map<String, MaterializedPredicate> rels) {
        int lines = 0;
        int commas = 0;
        boolean foundComma = false;
        StringTokenizer st = new StringTokenizer(sample, "\n,", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("\n".equals(token)) {
                if (foundComma) {
                    ++lines;
                }
                foundComma = false;
                continue;
            }
            if (!",".equals(token)) continue;
            foundComma = true;
            ++commas;
        }
        if (debug) {
            System.out.println("==================commasPerLine==================");
            System.out.println("lines=" + lines);
            System.out.println("commas=" + commas);
        }
        Format.options.put(Format.commasPerLine, (commas + 1) / (lines + 1));
    }

    public static void guessMaxCharLineSize(String sample, List<LexerToken> srcDummy, ParseNode root, Map<String, MaterializedPredicate> rels) {
        int maxLen = 0;
        StringTokenizer st = new StringTokenizer(sample, "\n,", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (maxLen >= token.length()) continue;
            maxLen = token.length();
        }
        if (debug) {
            System.out.println("==================MaxCharLineSize==================");
            System.out.println("maxLen=" + maxLen);
        }
        if (maxLen > 128) {
            Format.options.put(Format.maxCharLineSize, maxLen);
        }
    }

    public static void guessBreakOnSubqueries(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        FormattingPreferences.decideBreakOn(sample, src, new String[]{"subquery"}, new String[0], rels, Format.breakOnSubqueries);
    }

    public static void guessBreakAnsiiJoin(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        FormattingPreferences.decideBreakOn(sample, src, new String[]{"table_reference", "condition"}, new String[]{"on_using_condition", "\"inner_cross_join_clause\"", "cross_outer_apply_clause"}, rels, Format.breakAnsiiJoin);
    }

    public static void guessBreakParenCondition(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        FormattingPreferences.decideBreakOn(sample, src, new String[]{"'('"}, new String[]{"compound_condition"}, rels, Format.breakParenCondition);
    }

    private static void decideBreakOn(String sample, List<LexerToken> src, String[] nodeConditions, String[] parentConditions, Map<String, MaterializedPredicate> rels, String param) {
        int yes = 0;
        int no = 0;
        MaterializedPredicate formattedNodes = rels.get("indentedNodes1");
        for (Tuple t : formattedNodes.getTuples()) {
            ParseNode node = formattedNodes.getAttribute(t, "node");
            boolean proceed = nodeConditions.length == 0;
            for (String nodeCondition : nodeConditions) {
                if (!node.contains(nodeCondition)) continue;
                proceed = true;
                break;
            }
            if (!proceed) continue;
            proceed = parentConditions.length == 0;
            for (String parentCondition : parentConditions) {
                if (node.parent() == null || !node.parent().contains(parentCondition)) continue;
                proceed = true;
                break;
            }
            if (!proceed || node.from == 0) continue;
            int from = src.get((int)(node.from - 1)).end;
            int to = src.get((int)node.from).begin;
            String padding = sample.substring(from, to);
            if (0 < padding.indexOf(10)) {
                ++yes;
                continue;
            }
            ++no;
        }
        if (debug) {
            System.out.println("==================BreakOn " + nodeConditions[0] + "==================");
            System.out.println("yes=" + yes);
            System.out.println("no=" + no);
        }
        if (0 < yes || no < 0) {
            Format.options.put(param, no < yes);
        }
    }

    public static void guessForceLinebreaksBeforeComment(String sample, List<LexerToken> srcDummy, ParseNode root, Map<String, MaterializedPredicate> rels) {
        int yes = 0;
        int no = 0;
        List<LexerToken> src = LexerToken.parse(sample, true);
        LexerToken prior = null;
        for (LexerToken t : src) {
            if (prior != null && (t.type == Token.COMMENT || t.type == Token.LINE_COMMENT)) {
                int from = prior.end;
                int to = t.begin;
                String padding = sample.substring(from, to);
                if (padding.indexOf(10) != padding.lastIndexOf(10)) {
                    ++yes;
                    continue;
                }
                ++no;
                continue;
            }
            if (t.type == Token.WS) continue;
            prior = t;
        }
        if (debug) {
            System.out.println("==================ForceLinebreaksBeforeComment==================");
            System.out.println("yes=" + yes);
            System.out.println("no=" + no);
        }
        if (0 < yes || no < 0) {
            Format.options.put(Format.forceLinebreaksBeforeComment, no < yes);
        }
    }

    public static void guessExtraLinesAfterSignificantStatements(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        int yes = 0;
        int no = 0;
        MaterializedPredicate extraLines = rels.get("extraLines");
        for (Tuple t : extraLines.getTuples()) {
            ParseNode node = extraLines.getAttribute(t, "node");
            if (node.to < src.size()) {
                int from = src.get((int)(node.to - 1)).end;
                int to = src.get((int)node.to).begin;
                String padding = sample.substring(from, to);
                if (padding.indexOf(10) != padding.lastIndexOf(10)) {
                    ++yes;
                    continue;
                }
                ++no;
                continue;
            }
            ++no;
        }
        if (debug) {
            System.out.println("==================ExtraLinesAfterSignificantStatements==================");
            System.out.println("yes=" + yes);
            System.out.println("no=" + no);
        }
        if (0 < yes || no < 0) {
            Format.options.put(Format.extraLinesAfterSignificantStatements, (Object)(no < yes ? Format.BreaksX2.X2 : Format.BreaksX2.X1));
        }
    }

    private static long spaceAroundToken(String sample, List<LexerToken> src, ParseNode root, String symbol) {
        int before = 0;
        int after = 0;
        int cnt = 0;
        for (ParseNode node : root.descendants()) {
            if (!node.contains(symbol) || src.get((int)(node.to - 1)).end < sample.length() && sample.charAt(src.get((int)(node.to - 1)).end) == '\n' || src.get((int)(node.to - 1)).end < sample.length() && sample.charAt(src.get((int)(node.to - 1)).end) == '\r') continue;
            if (0 < src.get((int)node.from).begin && sample.charAt(src.get((int)node.from).begin - 1) == ' ') {
                ++before;
            }
            if (src.get((int)(node.to - 1)).end < sample.length() && sample.charAt(src.get((int)(node.to - 1)).end) == ' ') {
                ++after;
            }
            ++cnt;
        }
        if (debug) {
            System.out.println("================== spaceAfterToken " + symbol + " ==================");
            System.out.println("before=" + before);
            System.out.println("after=" + after);
            System.out.println("cnt=" + cnt);
        }
        return Service.lPair(cnt, Service.pair(before, after));
    }

    public static void guessSpaceAroundOperators(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long cba = FormattingPreferences.spaceAroundToken(sample, src, root, "relal_op");
        int cnt = Service.lX(cba);
        int ba = Service.lY(cba);
        int before = Service.X(ba);
        int after = Service.Y(ba);
        cba = FormattingPreferences.spaceAroundToken(sample, src, root, "cmp_op");
        ba = Service.lY(cba);
        before += Service.X(ba);
        after += Service.Y(ba);
        if (0 < (cnt += Service.lX(cba))) {
            Format.options.put(Format.spaceAroundOperators, before * 3 >= cnt * 2 && after * 3 >= cnt * 2);
        }
    }

    public static void guessSpaceAfterCommas(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long cba = FormattingPreferences.spaceAroundToken(sample, src, root, "','");
        int cnt = Service.lX(cba);
        int ba = Service.lY(cba);
        int after = Service.Y(ba);
        if (0 < cnt) {
            Format.options.put(Format.spaceAfterCommas, after * 3 >= cnt * 2);
        }
    }

    public static void guessSpaceAroundBrackets(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long cba1 = FormattingPreferences.spaceAroundToken(sample, src, root, "'('");
        int cnt1 = Service.lX(cba1);
        int ba1 = Service.lY(cba1);
        int before1 = Service.X(ba1);
        int after1 = Service.Y(ba1);
        long cba2 = FormattingPreferences.spaceAroundToken(sample, src, root, "')'");
        int cnt2 = Service.lX(cba2);
        int ba2 = Service.lY(cba2);
        int before2 = Service.X(ba2);
        int after2 = Service.Y(ba2);
        Format.Space o = Format.Space.NoSpace;
        if ((before1 + after2) * 3 >= (cnt1 + cnt2) * 2) {
            o = Format.Space.Outside;
        }
        if ((before2 + after1) * 3 >= (cnt1 + cnt2) * 2) {
            o = Format.Space.Inside;
        }
        if (0 < cnt1 + cnt2) {
            Format.options.put(Format.spaceAroundBrackets, (Object)o);
        }
    }

    public static void main(String[] args) throws Exception {
        debug = true;
        String input = Service.readFile(FormattingPreferences.class, "usergrantshelpertest1_b.testsql");
        input = Service.readFile(FormattingPreferences.class, "test.sql");
        FormattingPreferences.invokeAllGuessMethods(input);
    }
}

