/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.uninstall;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.util.MetaClass;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.osgi.boot.api.Platform;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.deferredupdate.task.DeleteExtraInfoTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.webupdate.CustomTypeDefinition;
import oracle.ideimpl.webupdate.CustomUpdateType;
import oracle.ideimpl.webupdate.Directories;
import oracle.ideimpl.webupdate.InstallProgressMonitor;
import oracle.ideimpl.webupdate.InstallProgressPanel;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateHandlerHook;
import oracle.ideimpl.webupdate.UpdateHelper;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateInstaller;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.UpdateTool;
import oracle.ideimpl.webupdate.commandline.PreInstaller;
import oracle.ideimpl.webupdate.uninstall.CFUBundlesExtraInfo;
import oracle.javatools.dialogs.ExceptionDialog;
import org.osgi.framework.Bundle;

public class ManageInstalledUpdates {
    private Directories _directories = UpdateManager.getInstance().getDirectories();

    public List<UpdateInfo> getInstalledUpdates() {
        ArrayList<UpdateInfo> installedUpdates = new ArrayList<UpdateInfo>();
        List<String> bundlesInfoFile = this.readBundlesExtrasFile();
        for (String line : bundlesInfoFile) {
            UpdateInfo updateInfo = CFUBundlesExtraInfo.createFromLineInExtras(line);
            if (updateInfo == null || !ManageInstalledUpdates.isUpdateInstalled(updateInfo)) continue;
            installedUpdates.add(updateInfo);
        }
        return installedUpdates;
    }

    public List<UpdateInfo> getUpdatesToBeInstalled() {
        ArrayList<UpdateInfo> installedUpdates = new ArrayList<UpdateInfo>();
        List<String> bundlesInfoFile = this.readBundlesExtrasFile();
        for (String line : bundlesInfoFile) {
            UpdateInfo updateInfo = CFUBundlesExtraInfo.createFromLineInExtras(line);
            if (updateInfo == null || !ManageInstalledUpdates.isUpdateInstalled(updateInfo)) continue;
            installedUpdates.add(updateInfo);
        }
        return installedUpdates;
    }

    public static boolean isUpdateInstalled(UpdateInfo update) {
        if (!update.getType().equals((Object)UpdateInfo.Type.CUSTOM)) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
            Extension extension = extensionRegistry.findExtension(update.getID());
            return extension != null;
        }
        if (update.getCustomType().equals("osgi")) {
            Bundle bundle = oracle.ide.osgi.Platform.getBundleRegistry().findBundle(update.getID());
            return bundle != null;
        }
        if (Platform.getPlatform() == Platform.PlatformType.ptMac) {
            return false;
        }
        CustomTypeDefinition ctd = UpdateHandlerHook.getCustomTypeDefinition();
        List<CustomUpdateType> cuts = ctd.getCustomUpdateTypes();
        boolean isInstalled = false;
        for (CustomUpdateType t : cuts) {
            if (!t.getType().equals(update.getCustomType())) continue;
            UpdateHelper uh = t.getUpdateHelper();
            if (uh == null || !uh.isInstalled(update.getID())) break;
            isInstalled = true;
            break;
        }
        return isInstalled;
    }

    File findBundlesInfoFile() {
        File file;
        File bundlesHome = new File(this._directories.getBundlesInfoHome());
        if (!bundlesHome.exists()) {
            bundlesHome.mkdirs();
        }
        if (!(file = new File(bundlesHome, "cfu_bundles.extras")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                file = null;
            }
        }
        return file;
    }

    private List<String> readBundlesExtrasFile() {
        return this.readPropertyStyleTypeFile(this.findBundlesInfoFile());
    }

    public List<String> readDeferredUpdatesFile() {
        return this.readPropertyStyleTypeFile(UpdateManager.getInstance().getDeferredUpdatesFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readPropertyStyleTypeFile(File bundlesInfoFile) {
        BufferedReader reader = null;
        ArrayList<String> lines = new ArrayList<String>();
        if (bundlesInfoFile != null && bundlesInfoFile.exists()) {
            try {
                String line;
                reader = new BufferedReader(new FileReader(bundlesInfoFile));
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return lines;
    }

    public void seedUnInstaller(Set<UpdateInfo> updates) {
        HashMap<MetaClass<UpdateInstaller>, ArrayList<UpdateInfo>> noRestartUninstalls = new HashMap<MetaClass<UpdateInstaller>, ArrayList<UpdateInfo>>();
        ArrayList<String> uninstallTasks = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        for (UpdateInfo updateInfo : updates) {
            if (!updateInfo.getType().equals((Object)UpdateInfo.Type.CUSTOM) || updateInfo.getCustomType().equals("osgi")) continue;
            CustomTypeDefinition ctd = UpdateHandlerHook.getCustomTypeDefinition();
            List<CustomUpdateType> cuts = ctd.getCustomUpdateTypes();
            for (CustomUpdateType t : cuts) {
                MetaClass<UpdateInstaller> ui;
                UpdateTool ut;
                if (!t.getType().equals(updateInfo.getCustomType()) || (ut = t.getUpdateTool()) == null || !ut.isExtensionManaged() || !ut.isUninstallSupported() || (ui = ut.getUpdateInstallerMetaClass()) == null) continue;
                ArrayList<UpdateInfo> v = (ArrayList<UpdateInfo>)noRestartUninstalls.get(ui);
                if (v == null) {
                    v = new ArrayList<UpdateInfo>();
                }
                v.add(updateInfo);
                noRestartUninstalls.put(ui, v);
            }
        }
        if (!noRestartUninstalls.isEmpty()) {
            final HashMap<UpdateInstaller, List<UpdateInfo>> uninstalls = new HashMap<UpdateInstaller, List<UpdateInfo>>();
            if (!noRestartUninstalls.isEmpty()) {
                for (MetaClass mcui : noRestartUninstalls.keySet()) {
                    UpdateInstaller ui = PreInstaller.getUpdateInstaller((MetaClass<UpdateInstaller>)mcui);
                    if (ui == null) continue;
                    uninstalls.put(ui, (List<UpdateInfo>)noRestartUninstalls.get(mcui));
                }
            }
            JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)IdeUtil.getMainWindow(), (String)UpdateArb.getString(233), (int)0);
            final InstallProgressPanel ipp = new InstallProgressPanel(jEWTDialog, uninstalls, null);
            jEWTDialog.setContent((Component)ipp);
            jEWTDialog.pack();
            jEWTDialog.setPreferredSize(900, 450);
            jEWTDialog.setResizable(true);
            final InstallProgressMonitor ipm = new InstallProgressMonitor(ipp);
            ipp.setProgressMonitor(ipm);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (!uninstalls.isEmpty()) {
                        for (UpdateInstaller ui : uninstalls.keySet()) {
                            try {
                                if (!ipm.isCancelled()) {
                                    ui.uninstall((List)uninstalls.get(ui), ipm);
                                    if (ipm.isCancelled()) continue;
                                    for (UpdateInfo update : (List)uninstalls.get(ui)) {
                                        ManageInstalledUpdates.deleteFromCFUExtras(update);
                                    }
                                    continue;
                                }
                                for (UpdateInfo update : (List)uninstalls.get(ui)) {
                                    ipm.setStatus(update.getID(), InstallProgressMonitor.InstallStatus.CANCELLED, "");
                                }
                            }
                            catch (Throwable th) {
                                Logger.getLogger("global").log(Level.SEVERE, "Error uninstalling update(s) for " + ui.getInstallerName() + ": " + th.getMessage());
                                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)th);
                            }
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JPanel cards = ipp.getButtonCards();
                            CardLayout cl = (CardLayout)cards.getLayout();
                            cl.show(cards, UpdateArb.getString(224));
                        }
                    });
                }
            });
            t.start();
            jEWTDialog.runDialog();
        }
        for (UpdateInfo updateInfo : updates) {
            buf.setLength(0);
            if (updateInfo.getType() == UpdateInfo.Type.EXTENSION) {
                buf.append("DeinstallExtensionTask=");
                buf.append(updateInfo.getID());
                buf.append(',');
                buf.append(updateInfo.getVersion().toString());
            } else if (updateInfo.getType() == UpdateInfo.Type.CUSTOM) {
                if (updateInfo.getCustomType().equals("osgi")) {
                    Bundle osgiBundle = oracle.ide.osgi.Platform.getBundleRegistry().findBundle(updateInfo.getID());
                    buf.append("DeinstallExtensionTask=");
                    buf.append(updateInfo.getID());
                    buf.append(',');
                    buf.append(osgiBundle.getVersion().toString());
                } else {
                    boolean taskCreated = false;
                    CustomTypeDefinition ctd = UpdateHandlerHook.getCustomTypeDefinition();
                    List<CustomUpdateType> cuts = ctd.getCustomUpdateTypes();
                    for (CustomUpdateType t : cuts) {
                        if (!t.getType().equals(updateInfo.getCustomType())) continue;
                        UpdateTool ut = t.getUpdateTool();
                        if (ut == null || ut.isExtensionManaged() || !ut.isUninstallSupported()) break;
                        buf.append("DeinstallCustomUpdateTask=");
                        buf.append(ut.getPath() + (Platform.getPlatform() == Platform.PlatformType.ptWindows ? ".bat" : ""));
                        for (String a : ut.getUninstallArgs()) {
                            buf.append(";").append(a);
                        }
                        buf.append(";").append(t.getUpdateHelper().getInternalId(updateInfo.getID()));
                        buf.append(',');
                        buf.append(updateInfo.getID());
                        buf.append(',');
                        if (updateInfo.getVersion() != null) {
                            buf.append(updateInfo.getVersion().toString());
                        } else {
                            buf.append("");
                        }
                        taskCreated = true;
                        break;
                    }
                    if (!taskCreated) continue;
                }
            }
            uninstallTasks.add(buf.toString());
        }
        if (!uninstallTasks.isEmpty()) {
            this.write(uninstallTasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(List<String> uninstallTasks) {
        File duFile = UpdateManager.getInstance().getDeferredUpdatesFile();
        if (!duFile.exists()) {
            ArrayList<String> dirList = new ArrayList<String>();
            UpdateManager.getInstance().getDirectories().save(dirList);
            uninstallTasks.addAll(0, dirList);
        }
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(duFile, duFile.exists()));
                for (String line : uninstallTasks) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ioe);
        }
    }

    public static void deleteFromCFUExtras(UpdateInfo update) {
        DeleteExtraInfoTask deleteExtraInfoTask = new DeleteExtraInfoTask(update.getID());
        try {
            deleteExtraInfoTask.perform(new TaskContext(){

                public oracle.ideimpl.deferredupdate.Directories getDirectories() {
                    LinkedHashMap<String, ArrayList<String>> properties = new LinkedHashMap<String, ArrayList<String>>();
                    ArrayList<String> dirList = new ArrayList<String>();
                    UpdateManager.getInstance().getDirectories().save(dirList);
                    for (String dir : dirList) {
                        int index = dir.indexOf(61);
                        if (index <= 0) continue;
                        String propertyName = dir.substring(0, index);
                        ArrayList<String> details = (ArrayList<String>)properties.get(propertyName);
                        if (details == null) {
                            details = new ArrayList<String>();
                            properties.put(propertyName, details);
                        }
                        details.add(dir.substring(index + 1));
                    }
                    return new oracle.ideimpl.deferredupdate.Directories(properties);
                }

                public boolean confirmOverwrite(File file) {
                    return true;
                }
            });
        }
        catch (TaskFailedException tfe) {
            Logger.getLogger("global").log(Level.SEVERE, "Error deleting from cfu extras file: " + tfe.getMessage());
        }
    }
}

