/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.commandline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ide.extension.ExtensionRegistry;
import oracle.ideimpl.webupdate.CheckForUpdatesPreferences;
import oracle.ideimpl.webupdate.CheckMasterListRunnable;
import oracle.ideimpl.webupdate.CheckUpdatesRunnable;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateHook;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.WebUpdateAddin;

public class CheckForCompatiableUpdates {
    private List _masterList;
    private Collection<UpdateInfo> updates;
    private static final CheckForCompatiableUpdates _instance = new CheckForCompatiableUpdates();
    private boolean verbose;
    CheckMasterListRunnable masterListCheck = null;

    public static synchronized CheckForCompatiableUpdates getInstance() {
        return _instance;
    }

    private CheckForCompatiableUpdates() {
    }

    public UpdateInfo getUpdateInfo(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (UpdateInfo info : this.getUpdates()) {
            if (!id.equals(info.getID())) continue;
            return info;
        }
        return null;
    }

    public Collection<UpdateInfo> getUpdates() {
        if (this.updates == null) {
            this.checkUpdates();
        }
        return this.updates;
    }

    public List getMasterList() {
        if (this.updates == null) {
            this.checkUpdates();
        }
        return this._masterList;
    }

    private void checkUpdates() {
        this.trace("Get MasterList of sites...");
        this.masterListCheck = new CheckMasterListRunnable(UpdateManager.getInstance().getMasterServerURL()){
            private boolean failedDefaultProxy;

            @Override
            protected void failed(Throwable exception) {
                CheckForCompatiableUpdates.this.trace("Failed getting MasterList -> " + exception.getMessage());
                CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
                prefs.setLastErrorType("generic");
                prefs.setLastError(exception.getMessage());
                System.err.println("Failed to get master list");
                System.exit(1);
            }

            protected void finished(List masterList) {
                boolean foundInternal = false;
                CheckForCompatiableUpdates.this.trace("MasterList retrieved successfully");
                for (UpdateCenter center : masterList) {
                    if (center.getMasterId().startsWith("oracle.ide.webupdate.internal")) {
                        foundInternal = true;
                    }
                    CheckForCompatiableUpdates.this.trace("Update Center: " + center.getName() + " :" + center.getMasterId());
                }
                if (!foundInternal) {
                    System.err.println("Internal Update Center not found, please check Proxy Settings");
                }
                ArrayList<UpdateCenter> centers = new ArrayList<UpdateCenter>(masterList);
                UpdateHook updateHook = (UpdateHook)ExtensionRegistry.getExtensionRegistry().getHook(UpdateHook.ELEMENT);
                centers.addAll(updateHook.getUpdateCenters());
                for (UpdateCenter c : centers) {
                    c.setEnabled(true);
                }
                CheckForCompatiableUpdates.this.checkForUpdates(masterList);
            }
        };
        this.masterListCheck.run();
    }

    private void checkForUpdates(List masterList) {
        this._masterList = masterList;
        MyCheckUpdatesRunnable r = new MyCheckUpdatesRunnable(masterList);
        r.run();
        this.updates = r.getUpdates();
    }

    void setVerbose(boolean b) {
        this.verbose = b;
    }

    public static void main(String[] args) {
        CheckForCompatiableUpdates command = new CheckForCompatiableUpdates();
        command.checkUpdates();
    }

    private void trace(String s) {
        if (this.verbose) {
            System.out.println(s);
        }
    }

    private class MyCheckUpdatesRunnable
    extends CheckUpdatesRunnable {
        private Collection updates;

        MyCheckUpdatesRunnable(List updateCenters) {
            super(updateCenters);
        }

        @Override
        protected void updateCenterError(UpdateCenter center, Throwable exception) {
            CheckForCompatiableUpdates.this.trace("Get List of Updates from:" + center.getName() + " Failed: " + exception.getMessage());
            CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
            prefs.setLastErrorType("generic");
            prefs.setLastError(exception.getMessage());
        }

        @Override
        protected void finished(Collection<UpdateInfo> updates) {
            CheckForCompatiableUpdates.this.trace("Received list of updates successfully");
            this.updates = Collections.unmodifiableCollection(updates);
        }

        @Override
        protected void stopped() {
        }

        public Collection getUpdates() {
            System.out.println("Get List of Updates from Servers...");
            return this.updates;
        }
    }
}

