/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.sqlserver;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.sqlserver.DMSQLServerConnectionPanel;
import oracle.dbtools.thirdparty.sqlserver.Messages;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.PlatformUtils;

class DMSQLServerBasicPanel
extends JPanel
implements CDComponentView {
    private static final long serialVersionUID = 428751755326227573L;
    private final DMSQLServerConnectionPanel _basicPanel;
    private JLabel _hostLbl = new JLabel();
    protected JTextField tfdHost = new JTextField(15);
    private JLabel _portLbl = new JLabel();
    protected JTextField tfdPort = new JTextField(15);
    private JCheckBox _autoPasswordCheck = new JCheckBox();
    private JCheckBox _windowsAuthenticate = new JCheckBox();
    private JLabel _domainLbl = new JLabel();
    protected JTextField tfdDomain = new JTextField(15);
    private boolean isWindows = true;

    public DMSQLServerBasicPanel(DMSQLServerConnectionPanel panel) {
        this._basicPanel = panel;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void clear() {
        this.tfdHost.setText("");
        this.tfdPort.setText("");
    }

    public void generateProperties(Properties cd) {
        String url = "";
        cd.setProperty("hostname", this.tfdHost.getText().trim());
        cd.setProperty("port", this.tfdPort.getText().trim());
        try {
            ClassLoader cl = RaptorClassLoader.findClassLoader((String)"net.sourceforge.jtds.jdbc.Driver");
            if (cl != null) {
                cl.loadClass("net.sourceforge.jtds.jdbc.Driver");
                url = "jdbc:jtds:sqlserver://" + this.tfdHost.getText().trim() + ":" + this.tfdPort.getText().trim() + "/";
            }
        }
        catch (Exception e) {
            url = "jdbc:sqlserver://" + this.tfdHost.getText().trim() + ":" + this.tfdPort.getText().trim();
        }
        cd.setProperty("customUrl", url);
    }

    private void jbInit() throws Exception {
        this._autoPasswordCheck.setText(Messages.getString("BasicPanel.10"));
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this._windowsAuthenticate, (String)Messages.getString("WINDOWS_AUTHENTICATION"));
        ResourceUtils.resLabel((JLabel)this._hostLbl, (Component)this.tfdHost, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_HOST"));
        ResourceUtils.resLabel((JLabel)this._portLbl, (Component)this.tfdPort, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_PORT"));
        ResourceUtils.resLabel((JLabel)this._domainLbl, (Component)this.tfdDomain, (String)Messages.getString("DOMAIN_NAME"));
        this.tfdDomain.setEditable(false);
        this.tfdDomain.setBackground(Color.LIGHT_GRAY);
        this.isWindows = PlatformUtils.isWindows();
        this._autoPasswordCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DMSQLServerBasicPanel.this.setDefaultPasswordSelected(e.getStateChange() == 1);
            }
        });
        this._windowsAuthenticate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DMSQLServerBasicPanel.this.setWindowsAuthSelected(e.getStateChange() == 1);
            }
        });
        this.add((Component)this._autoPasswordCheck, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this._windowsAuthenticate, new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this._hostLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdHost, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this._portLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdPort, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.tfdHost.setText("localhost");
        this.tfdPort.setText("1433");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 1;
        GridBagConstraints gridBagConstraint = new GridBagConstraints();
        gridBagConstraint.fill = 2;
        gridBagConstraint.insets = new Insets(10, 0, 0, 0);
        gridBagConstraint.anchor = 11;
        gridBagConstraint.gridy = 5;
        gridBagConstraint.gridx = 0;
    }

    public JCheckBox get_autoPasswordCheck() {
        return this._autoPasswordCheck;
    }

    public void set_autoPasswordCheck(JCheckBox passwordCheck) {
        this._autoPasswordCheck = passwordCheck;
    }

    public JCheckBox get_windowsAuthenticate() {
        return this._windowsAuthenticate;
    }

    public void set_windowsAuthenticate(boolean value) {
        this._windowsAuthenticate.setSelected(value);
    }

    public boolean get_isWindows() {
        return this.isWindows;
    }

    public JTextField getTfdDomain() {
        return this.tfdDomain;
    }

    public void setDomain(String domain) {
        this.tfdDomain.setText(domain);
    }

    void setDefaultPasswordSelected(boolean selected) {
        this.isWindows = PlatformUtils.isWindows();
        this._autoPasswordCheck.setSelected(selected);
        if (selected || this.isWindows && this._windowsAuthenticate.isSelected()) {
            this._basicPanel.getDialog().usePassword(false);
        } else {
            this._basicPanel.getDialog().usePassword(true);
        }
    }

    void setWindowsAuthSelected(boolean selected) {
        this.isWindows = PlatformUtils.isWindows();
        this._windowsAuthenticate.setSelected(selected);
        if (selected && !this.isWindows) {
            this._basicPanel.getDialog().useUserName(true);
            this._basicPanel.getDialog().usePassword(true);
            this._autoPasswordCheck.setEnabled(true);
            this.add((Component)this._domainLbl, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.add((Component)this.tfdDomain, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
            this.revalidate();
            this.tfdDomain.setEditable(true);
            this.tfdDomain.setBackground(Color.WHITE);
        } else if (selected && this.isWindows) {
            this._autoPasswordCheck.setEnabled(false);
            this._basicPanel.getDialog().useUserName(false);
            this._basicPanel.getDialog().usePassword(false);
        } else {
            this._basicPanel.getDialog().useUserName(true);
            if (!this._autoPasswordCheck.isSelected()) {
                this._basicPanel.getDialog().usePassword(true);
            } else {
                this._basicPanel.getDialog().usePassword(false);
            }
            this._autoPasswordCheck.setEnabled(true);
            this.remove(this._domainLbl);
            this.remove(this.tfdDomain);
            this.revalidate();
        }
    }

    public void setDefaultPrompts() {
        this.tfdHost.setText("localhost");
        this.tfdPort.setText("1433");
    }

    public void updatePrompts(Properties cd) {
        String hostname = cd.getProperty("hostname");
        this.tfdHost.setText(hostname);
        String port = cd.getProperty("port");
        this.tfdPort.setText(port != null ? port : "1433");
        boolean windowsAuth = Boolean.parseBoolean(cd.getProperty(DMSQLServerConnectionPanel.SQLSERVER_WINDOWS_AUTHENTICATION, "false"));
        this.setWindowsAuthSelected(windowsAuth);
        boolean defaultPassword = Boolean.parseBoolean(cd.getProperty(DMSQLServerConnectionPanel.SQLSERVER_DEFAULT_PASSWORD, "false"));
        this.setDefaultPasswordSelected(defaultPassword);
        this.setDomain(cd.getProperty(DMSQLServerConnectionPanel.SQLSERVER_DOMAIN, ""));
    }
}

