/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.TabbedPaneUI;
import oracle.dbtools.crest.util.gui.swing.CloseListener;
import oracle.dbtools.crest.util.gui.swing.CloseTabbedPaneEnhancedUI;
import oracle.dbtools.crest.util.gui.swing.CloseTabbedPaneUI;
import oracle.dbtools.crest.util.gui.swing.RightPopupListener;

public class JCloseTabbedPane
extends JTabbedPane {
    private int overTabIndex = -1;
    private CloseTabbedPaneUI paneUI;

    public JCloseTabbedPane() {
        super.setTabLayoutPolicy(1);
        this.paneUI = new CloseTabbedPaneEnhancedUI();
        super.setUI(this.paneUI);
    }

    public int getOverTabIndex() {
        return this.overTabIndex;
    }

    public boolean isCloseEnabled() {
        return this.paneUI.isCloseEnabled();
    }

    @Override
    public void setTabLayoutPolicy(int tabLayoutPolicy) {
    }

    @Override
    public void setTabPlacement(int tabPlacement) {
    }

    @Override
    public void setUI(TabbedPaneUI ui) {
    }

    public void setCloseIcon(boolean b) {
        this.paneUI.setCloseIcon(b);
    }

    public void detachTab(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return;
        }
        final JFrame frame = new JFrame();
        Window parentWindow = SwingUtilities.windowForComponent(this);
        final int tabIndex = index;
        final JComponent c = (JComponent)this.getComponentAt(tabIndex);
        final Icon icon = this.getIconAt(tabIndex);
        final String title = this.getTitleAt(tabIndex);
        final String toolTip = this.getToolTipTextAt(tabIndex);
        final Border border = c.getBorder();
        this.removeTabAt(index);
        c.setPreferredSize(c.getSize());
        frame.setTitle(title);
        frame.getContentPane().add(c);
        frame.setLocation(parentWindow.getLocation());
        frame.pack();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                frame.dispose();
                JCloseTabbedPane.this.insertTab(title, icon, c, toolTip, Math.min(tabIndex, JCloseTabbedPane.this.getTabCount()));
                c.setBorder(border);
                JCloseTabbedPane.this.setSelectedComponent(c);
            }
        });
        WindowFocusListener windowFocusListener = new WindowFocusListener(){
            long start;
            long end;

            @Override
            public void windowGainedFocus(WindowEvent e) {
                this.start = System.currentTimeMillis();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                this.end = System.currentTimeMillis();
                long elapsed = this.end - this.start;
                if (elapsed < 100L) {
                    frame.toFront();
                }
                frame.removeWindowFocusListener(this);
            }
        };
        frame.addWindowFocusListener(windowFocusListener);
        frame.show();
        frame.toFront();
    }

    public synchronized void addRightPopupListener(RightPopupListener l) {
        this.listenerList.add(RightPopupListener.class, l);
    }

    public synchronized void removeRightPopupListener(RightPopupListener l) {
        this.listenerList.remove(RightPopupListener.class, l);
    }

    public synchronized void addCloseListener(CloseListener l) {
        this.listenerList.add(CloseListener.class, l);
    }

    public synchronized void removeCloseListener(CloseListener l) {
        this.listenerList.remove(CloseListener.class, l);
    }

    public void fireCloseTabEvent(MouseEvent e, int overTabIndex) {
        this.overTabIndex = overTabIndex;
        EventListener[] closeListeners = this.getListeners(CloseListener.class);
        for (int i = 0; i < closeListeners.length; ++i) {
            ((CloseListener)closeListeners[i]).closeOperation(e);
        }
    }

    public void fireRightPopupTabEvent(MouseEvent e) {
        this.overTabIndex = -1;
        EventListener[] popupListeners = this.getListeners(RightPopupListener.class);
        for (int i = 0; i < popupListeners.length; ++i) {
            ((RightPopupListener)popupListeners[i]).popupOperation(e);
        }
    }
}

