/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.dmweb;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.dmweb.DiagramToSVG;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class DiagramToJSON {
    public static void main(String[] args) {
    }

    private static void addAttribute(String name, String value, Writer sb) {
        DiagramToJSON.addAttribute(name, value, sb, false);
    }

    private static void addAttribute(String name, String value, Writer sb, boolean first) {
        DiagramToJSON.addAttribute(name, value, sb, first, false);
    }

    private static void addAttribute(String name, String value, Writer sb, boolean first, boolean numOrbool) {
        try {
            String code = name;
            if (!first) {
                sb.write(44);
            }
            sb.write("\n\"");
            sb.write(code);
            if (!numOrbool) {
                sb.write("\":\"");
                sb.write(value);
                sb.write("\"");
            } else {
                sb.write("\":");
                sb.write(value);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private static void addOpenTag(String tagname, Writer sb) {
        try {
            String code = tagname;
            sb.write("{\"");
            sb.write(code);
            sb.write("\":");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addObjectTagAndOpen(String tagname, Writer sb, boolean first) {
        try {
            if (!first) {
                sb.write(44);
            }
            String code = tagname;
            sb.write("\n\"");
            sb.write(code);
            sb.write("\":{");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addOpenObjectChar(Writer sb, boolean first) {
        try {
            if (!first) {
                sb.write(44);
            }
            sb.write("\n{");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addObjectName(String tagname, Writer sb, boolean first) {
        try {
            String code = tagname;
            if (!first) {
                sb.write(44);
            }
            sb.write("\n");
            sb.write("\"");
            sb.write(code);
            sb.write("\":{");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addKeyValueObject(String key, String value, Writer sb, boolean first) {
        try {
            if (!first) {
                sb.write(44);
            }
            sb.write("\n");
            sb.write("{\"");
            sb.write(StringUtilities.encodeAttributeValueJSON(key));
            sb.write("\":\"");
            sb.write(StringUtilities.encodeAttributeValueJSON(value));
            sb.write("\"}");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private static void addCollectionOpenTag(String tagname, Writer sb, boolean first) {
        try {
            String code = tagname;
            if (!first) {
                sb.write(44);
            }
            sb.write("\n\"");
            sb.write(code);
            sb.write("\":[");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addCloseChar(Writer sb) {
        try {
            sb.write("}");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addCollectionCloseChar(Writer sb) {
        try {
            sb.write("\n]");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void DPV_ToJSON(DPVRelational dpv, Writer sb) {
        RelationalDesign rd = (RelationalDesign)dpv.getDesignPart();
        DiagramToJSON.addOpenObjectChar(sb, true);
        DiagramToJSON.addCollectionOpenTag("items", sb, true);
        boolean first = !DiagramToJSON.processT_V_shapes(dpv, sb);
        DiagramToJSON.processTVConnector(dpv, sb, first);
        DiagramToJSON.addCollectionCloseChar(sb);
        try {
            sb.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DiagramToJSON.addCloseChar(sb);
    }

    public static boolean processT_V_shapes(DPVRelational dpv, Writer sb) {
        boolean processed = false;
        boolean first = true;
        try {
            Iterator it = dpv.getTVTablesAndTVViews().iterator();
            while (it.hasNext()) {
                boolean lfirst = true;
                TopView tv = (TopView)it.next();
                Table table = null;
                ContainerObject co = (ContainerObject)tv.getModel();
                DiagramToJSON.addOpenObjectChar(sb, first);
                first = false;
                String name = co.getName();
                String schema = co.getSchema();
                String type = "TABLE";
                if (co instanceof TableView) {
                    type = "VIEW";
                } else if (co instanceof Table) {
                    table = (Table)co;
                }
                DiagramToJSON.addAttribute("name", name, sb, lfirst);
                lfirst = false;
                DiagramToJSON.addAttribute("schema", schema, sb, lfirst);
                DiagramToJSON.addAttribute("type", type, sb, lfirst);
                if (table != null) {
                    if (table.isMaterializedQueryTable()) {
                        DiagramToJSON.addAttribute("materializedView", "true", sb, false, true);
                    } else {
                        StorageDesign sd = table.getRelationalModel().getStorageDesign();
                        if (sd.isOpen() && sd instanceof StorageDesignOracle) {
                            TableProxyOracle tp = (TableProxyOracle)sd.getStorageObject(table.getObjectID());
                            if (tp != null && "EXTERNAL".equalsIgnoreCase(tp.getOrganization())) {
                                DiagramToJSON.addAttribute("externalTable", "true", sb, false, true);
                            } else {
                                DiagramToJSON.addAttribute("externalTable", "false", sb, false, true);
                            }
                        } else {
                            DiagramToJSON.addAttribute("externalTable", "false", sb, false, true);
                        }
                    }
                }
                DiagramToJSON.addAttribute("viewID", tv.getViewID(), sb, lfirst);
                DiagramToJSON.addAttribute("viewNum", String.valueOf(tv.getViewNumber()), sb, false, true);
                DiagramToJSON.addAttribute("useCustomFormat", String.valueOf(tv.useCustomFormat()), sb, false, true);
                DiagramToJSON.addAttribute("useDefaultColor", String.valueOf(tv.useDefaultColor()), sb, false, true);
                Color bgcol = DiagramToSVG.getBackgroundColor(co, tv);
                Color fgcol = DiagramToSVG.getTableForegroundColor(co, tv);
                DiagramToJSON.addAttribute("bgColor", String.valueOf(bgcol.getRGB()), sb, false, true);
                DiagramToJSON.addAttribute("fgColor", String.valueOf(fgcol.getRGB()), sb, false, true);
                Rectangle bounds = null;
                bounds = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tv.getBounds();
                if (bounds != null) {
                    DiagramToJSON.addObjectTagAndOpen("bounds", sb, lfirst);
                    DiagramToJSON.addAttribute("x", String.valueOf(bounds.getX()), sb, true, true);
                    DiagramToJSON.addAttribute("y", String.valueOf(bounds.getY()), sb, false, true);
                    DiagramToJSON.addAttribute("width", String.valueOf(bounds.getWidth()), sb, false, true);
                    DiagramToJSON.addAttribute("height", String.valueOf(bounds.getHeight()), sb, false, true);
                    DiagramToJSON.addCloseChar(sb);
                }
                DiagramToJSON.addCloseChar(sb);
                processed = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processed;
    }

    public static boolean processTVConnector(DPVRelational dpv, Writer sb, boolean first) {
        boolean processed = false;
        try {
            Iterator it = dpv.getTVConnectors().iterator();
            while (it.hasNext()) {
                boolean lfirst = true;
                TVConnector tv = (TVConnector)it.next();
                ConnectionInterface ci = (ConnectionInterface)((Object)tv.getModel());
                DesignObject so = ci.getSourceObject();
                DesignObject to = ci.getTargetObject();
                if (so == null || to == null) continue;
                DesignObject co = tv.getModel();
                TopView stv = tv.getSourceTopView();
                TopView ttv = tv.getTargetTopView();
                DiagramToJSON.addOpenObjectChar(sb, first);
                first = false;
                processed = true;
                String name = co.getName();
                String type = "RELATION";
                DiagramToJSON.addAttribute("name", name, sb, lfirst);
                lfirst = false;
                DiagramToJSON.addAttribute("type", type, sb, lfirst);
                DiagramToJSON.addAttribute("sourceID", so.getLongName(), sb, lfirst);
                DiagramToJSON.addAttribute("targetID", to.getLongName(), sb, lfirst);
                DiagramToJSON.addAttribute("sourceViewID", stv.getViewID(), sb, lfirst);
                DiagramToJSON.addAttribute("targetViewID", ttv.getViewID(), sb, lfirst);
                List list = tv.getActualPoints();
                DiagramToJSON.addCollectionOpenTag("vertices", sb, false);
                if (list.size() > 2) {
                    boolean pfirst = true;
                    for (int i = 1; i < list.size() - 1; ++i) {
                        Point2D p = (Point2D)list.get(i);
                        DiagramToJSON.addOpenObjectChar(sb, pfirst);
                        pfirst = false;
                        DiagramToJSON.addAttribute("x", String.valueOf((int)p.getX()), sb, true, true);
                        DiagramToJSON.addAttribute("y", String.valueOf((int)p.getY()), sb, false, true);
                        DiagramToJSON.addCloseChar(sb);
                    }
                }
                DiagramToJSON.addCollectionCloseChar(sb);
                if (list.size() >= 2) {
                    Point2D p = (Point2D)list.get(0);
                    DiagramToJSON.addObjectTagAndOpen("sourcePort", sb, false);
                    DiagramToJSON.addAttribute("x", String.valueOf((int)p.getX()), sb, true, true);
                    DiagramToJSON.addAttribute("y", String.valueOf((int)p.getY()), sb, false, true);
                    DiagramToJSON.addCloseChar(sb);
                    p = (Point2D)list.get(list.size() - 1);
                    DiagramToJSON.addObjectTagAndOpen("targetPort", sb, false);
                    DiagramToJSON.addAttribute("x", String.valueOf((int)p.getX()), sb, true, true);
                    DiagramToJSON.addAttribute("y", String.valueOf((int)p.getY()), sb, false, true);
                    DiagramToJSON.addCloseChar(sb);
                }
                DiagramToJSON.addCloseChar(sb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNewID(Connection con) {
        Statement st = null;
        try {
            st = con.createStatement();
            String sql = "SELECT osddmw_diagrams_id_SEQAI.NEXTVAL from dual";
            ResultSet rs = st.executeQuery(sql);
            if (rs != null && rs.next()) {
                String val = rs.getString(1);
                rs.close();
                String string = val;
                return string;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            String string = e.getMessage();
            return string;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean diagramsTableExists(Connection con) {
        String sql = "select 1 from user_tables where table_name = 'OSDDMW_DIAGRAMS'";
        Statement st = null;
        try {
            st = con.createStatement();
            ResultSet rs = null;
            rs = st.executeQuery(sql);
            if (rs != null && rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateDiagram(Connection con, DesignPartView dpv, String layout, PreparedStatement ps) {
        String upd_sql = "update osddmw_diagrams set last_update=systimestamp,design_name=?,model_name=?,subview_name=?, layout =? where design_id = ? and subview_id = ?";
        try {
            DesignPart dp = dpv.getDesignPart();
            Design des = dp.getDesign();
            String name = dpv.getName();
            String descr = dpv.getComment();
            if (descr != null && descr.length() > 3990) {
                descr = descr.substring(0, 3990);
            }
            if (dp.getMainView() == dpv && (descr = dp.getComment()) != null && descr.length() > 3990) {
                descr = descr.substring(0, 3990);
            }
            ps.setString(1, des.getName());
            ps.setString(2, dp.getName());
            ps.setString(3, dpv.getName());
            ps.setCharacterStream(4, (Reader)new StringReader(layout), layout.length());
            ps.setString(5, des.getObjectID());
            ps.setString(6, dpv.getDPVId());
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String insertDiagram(Connection con, DesignPartView dpv, String id, String layout, PreparedStatement ps) {
        String res = null;
        try {
            DesignPart dp = dpv.getDesignPart();
            Design des = dp.getDesign();
            String pid = null;
            String type = "SVP";
            boolean md = false;
            String name = dpv.getName();
            String descr = dpv.getComment();
            if (descr != null && descr.length() > 3990) {
                descr = descr.substring(0, 3990);
            }
            if (dp.getMainView() == dpv) {
                type = "MDP";
                descr = dp.getComment();
                if (descr != null && descr.length() > 3990) {
                    descr = descr.substring(0, 3990);
                }
                md = true;
            }
            if (!dpv.isMasterDPV()) {
                pid = dpv.getMasterDPV().getDPVId();
                if (!md) {
                    type = "SVD";
                }
            } else if (!md) {
                type = "SVP";
            }
            long lid = Long.valueOf(id);
            ps.setLong(1, lid);
            ps.setString(2, name);
            ps.setString(3, descr);
            ps.setString(4, des.getObjectID());
            ps.setString(5, des.getName());
            ps.setString(6, dp.getObjectID());
            ps.setString(7, dp.getName());
            ps.setString(8, dpv.getDPVId());
            ps.setString(9, dpv.getName());
            ps.setString(10, pid);
            ps.setString(11, type);
            ps.setCharacterStream(12, (Reader)new StringReader(layout), layout.length());
            ps.execute();
        }
        catch (SQLException e) {
            res = e.getMessage();
            e.printStackTrace();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createDiagramsTable(Connection con) {
        String res = "ok";
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE osddmw_diagrams \n");
        sb.append("  ( \n");
        sb.append("    id          NUMBER NOT NULL , \n");
        sb.append("    name        VARCHAR2 (70) , \n");
        sb.append("    description VARCHAR2 (4000) , \n");
        sb.append("    last_update TIMESTAMP , \n");
        sb.append("    global_ID VARCHAR2 (70) , \n");
        sb.append("    Design_ID VARCHAR2 (70) , \n");
        sb.append("    Design_Name VARCHAR2 (256) , ");
        sb.append("    model_ID VARCHAR2 (70) , \n");
        sb.append("    model_Name VARCHAR2 (256) , ");
        sb.append("    subview_ID VARCHAR2 (70) , \n");
        sb.append("    subview_Name VARCHAR2 (256) , ");
        sb.append("    parent_ID VARCHAR2 (70) , \n");
        sb.append("    diagram_type VARCHAR2 (10) , \n");
        sb.append("    layout CLOB \n");
        sb.append("  ) ");
        String tsql = sb.toString();
        Statement st = null;
        try {
            try {
                st = con.createStatement();
            }
            catch (SQLException e) {
                e.printStackTrace();
                String string = e.getMessage();
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
                return string;
            }
            try {
                st.execute(tsql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                String string = e.getMessage();
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e3) {
                        e3.printStackTrace();
                    }
                }
                return string;
            }
            String sql = new StringBuffer().append("ALTER TABLE osddmw_diagrams ADD CONSTRAINT osddmw_diagrams_PK PRIMARY KEY ( id )").toString();
            try {
                st.execute(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                String string = e.getMessage();
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e4) {
                        e4.printStackTrace();
                    }
                }
                return string;
            }
            sql = new StringBuffer().append("create unique index osddmw_diagrams_desdix on osddmw_diagrams ( Design_ID, subview_ID )").toString();
            try {
                st.execute(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                String string = e.getMessage();
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e5) {
                        e5.printStackTrace();
                    }
                }
                return string;
            }
            sql = new StringBuffer().append("CREATE SEQUENCE osddmw_diagrams_id_SEQAI START WITH 1 NOCACHE ").toString();
            try {
                st.execute(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
                String string = e.getMessage();
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e6) {
                        e6.printStackTrace();
                    }
                }
                return string;
            }
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wriiteDiagramsToCloud(DesignPart dp, List list) {
        Connection con;
        if (list.size() > 0 && (con = DiagramToJSON.getConnection(dp)) != null) {
            if (!DiagramToJSON.diagramsTableExists(con)) {
                DiagramToJSON.createDiagramsTable(con);
            }
            Statement ins_ps = null;
            Statement upd_ps = null;
            try {
                String ins_sql = "insert into osddmw_diagrams (id, name, description, last_update,design_id,design_name,model_id,model_name,subview_id,subview_name,parent_id,diagram_type, layout) values(?,?,?,systimestamp,?,?,?,?,?,?,?,?,?)";
                String upd_sql = "update osddmw_diagrams set last_update=systimestamp,design_name=?,model_name=?,subview_name=?, layout =? where design_id = ? and subview_id = ?";
                for (DPVRelational dpv : list) {
                    String err;
                    StringWriter sb = new StringWriter();
                    DiagramToJSON.DPV_ToJSON(dpv, sb);
                    String layout = sb.toString();
                    String id = DiagramToJSON.getNewID(con);
                    if (ins_ps == null) {
                        ins_ps = con.prepareStatement(ins_sql);
                    }
                    if ((err = DiagramToJSON.insertDiagram(con, dpv, id, layout, (PreparedStatement)ins_ps)) == null || err.indexOf("ORA-00001") <= -1 || err.indexOf("OSDDMW_DIAGRAMS_DESDIX") <= -1) continue;
                    if (upd_ps == null) {
                        upd_ps = con.prepareStatement(upd_sql);
                    }
                    DiagramToJSON.updateDiagram(con, dpv, layout, (PreparedStatement)upd_ps);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (ins_ps != null) {
                    try {
                        ins_ps.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (upd_ps != null) {
                    try {
                        upd_ps.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static Connection getConnection(ModelIDObject obj) {
        RelationalDesign rd;
        List<DBConnectionStamp> list;
        Connection conn = null;
        String cname = obj.getSourceConnName();
        if (cname != null && cname.isEmpty() && obj instanceof RelationalDesign && (list = (rd = (RelationalDesign)obj).getImportConnectionStamps()).size() > 0) {
            cname = list.get(0).getConnName();
        }
        if (cname != null && !cname.isEmpty()) {
            try {
                conn = DatabaseConnections.getInstance().getUniqueConnection(cname);
            }
            catch (ConnectionException e) {
                e.printStackTrace();
            }
        }
        return conn;
    }
}

