/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerationDialog;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportConfiguration;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportConfigurationsPersistence;
import oracle.dbtools.crest.util.CustomDialogML;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.ToStringComparator;

public class StandardReportsConfigurationDialog
extends CustomDialogML {
    private static final String TEMPLATE_NAME = "Standard Report Configuration";
    private ToStringComparator toStringComparator = new ToStringComparator();
    private JDialog dialog;
    private boolean result = false;
    private DefaultListModel standardReportsModel;
    private JList standardReportConfigurationsList;
    private int cgCounter = 0;
    private JButton btnSubviewAdd;
    private JButton btnSubviewRemove;
    private JButton btnSave = new JButton(Messages.getString("StandardReportsConfigurationDialog.Save"));
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnCancel;
    private JButton btnRemove;
    private JRadioButton rbIncludeAll;
    private JRadioButton rbChooseObjects;
    private JTextField subviewsFilter;
    private JTextField objectsFilter;
    private SelectedSubViewsModel selectedSubviewsListModel;
    private FilteredSubViewsJList subviewsList;
    private JList selectedSubviewsList;
    private JButton btnSelectAll;
    private JButton btnDeselectAll;
    private JScrollPane subviewsSPane;
    private JScrollPane standardReportSP;
    private JScrollPane selectedSubviewsSPane;
    private ObjectsModel objecstModel;
    private JTable objectsTable;
    private List<ReportsGenerationDialog.ReportObject> initialObjectsList = new ArrayList<ReportsGenerationDialog.ReportObject>();
    private boolean isLD;
    private JTextField txtName;
    private JTextArea taDescription;
    private List<ReportsGenerationDialog.ReportObject> currentObjectsList;
    private boolean isSaved = true;
    private StandardReportsConfigurationDialog srd;
    private StandardReportConfigsListSelectionListener rcListHandler;
    private StandardReportConfigurationsPersistence standardReportPersistence;
    private List<StandardReportConfiguration> allConfigurationsList;
    private Object allAvailableSubViewsList;
    private List currentNonSelectedSubViewsList = new ArrayList();
    private String designObjId;
    private String modelObjId;
    private ReportsGenerationDialog parent;
    private TableRowSorter<ObjectsModel> objectsSorter;
    private JPanel subviewsPanel;
    private JScrollPane objectsScrollPane;
    private Class clazz;
    private GUIConfiguration guiConfiguration;
    private JPanel westPanel;
    private JPanel eastPanel;
    private JPanel buttonsPanel;
    private RadioButtonListener radioButtonListener;
    private StandardReportConfiguration currentSRC;
    private StandardReportConfiguration backupSRC;
    private static final Logger LOGGER = new Logger(StandardReportsConfigurationDialog.class);

    public StandardReportsConfigurationDialog(ApplicationView appView, Class clazz, HashMap extraParams) {
        super(appView);
        this.clazz = clazz;
        this.parent = (ReportsGenerationDialog)extraParams.get("parent");
        this.allAvailableSubViewsList = extraParams.get("subviews");
        this.designObjId = (String)extraParams.get("design_id");
        this.modelObjId = (String)extraParams.get("model_id");
        this.initialObjectsList = (List)extraParams.get("objects_list");
        this.isLD = (Boolean)extraParams.get("loaded_designs");
        this.srd = this;
        this.allConfigurationsList = appView.getStandardReportConfigurations();
        this.standardReportPersistence = (StandardReportConfigurationsPersistence)extraParams.get("srp_persistence");
        this.guiConfiguration = GUIConfiguration.getInstance();
        this.initWestPanel();
        this.initEestPanel();
        this.initButtonsPanel();
        this.loadReportConfigurations();
        this.add((Component)this.westPanel, new CC().minWidth("180").growY());
        this.add((Component)this.eastPanel, new CC().minWidth("480").grow());
        this.add((Component)this.buttonsPanel, new CC().height("30").dockSouth());
    }

    private void initWestPanel() {
        this.westPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        this.westPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportsConfigurationDialog.Configurations")));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        this.btnAdd = new JButton(this.guiConfiguration.getIcon("ADD_ICON", 16));
        this.btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new AddAction());
        this.btnAdd.setMnemonic(65);
        this.btnAdd.setToolTipText(Messages.getString("ReportTemplatesDialog.Add"));
        this.btnEdit = new JButton(this.guiConfiguration.getIcon("EDIT_ICON", 16));
        this.btnEdit.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnEdit.setEnabled(false);
        this.btnEdit.addActionListener(new EditAction());
        this.btnEdit.setMnemonic(69);
        this.btnEdit.setToolTipText(Messages.getString("ReportTemplatesDialog.Edit"));
        this.btnCancel = new JButton(this.guiConfiguration.getIcon("CANCEL_ICON", 16));
        this.btnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnCancel.setEnabled(false);
        this.btnCancel.addActionListener(new CancelAction());
        this.btnCancel.setMnemonic(67);
        this.btnCancel.setToolTipText(Messages.getString("StandardReportsConfigurationDialog.Cancel"));
        this.btnRemove = new JButton(this.guiConfiguration.getIcon("REMOVE_ICON", 16));
        this.btnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new RemoveAction());
        this.btnRemove.setMnemonic(82);
        this.btnRemove.setToolTipText(Messages.getString("ReportTemplatesDialog.Remove"));
        this.btnSave = new JButton(this.guiConfiguration.getIcon("SAVE_ICON", 16));
        this.btnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSave.setEnabled(false);
        this.btnSave.addActionListener(new SaveAction());
        this.btnSave.setMnemonic(83);
        this.btnSave.setToolTipText(Messages.getString("ReportTemplatesDialog.Save"));
        toolBar.add(this.btnAdd);
        toolBar.add(this.btnEdit);
        toolBar.add(this.btnCancel);
        toolBar.add(this.btnRemove);
        toolBar.add(this.btnSave);
        this.standardReportsModel = new DefaultListModel();
        this.standardReportConfigurationsList = new JList(this.standardReportsModel);
        this.rcListHandler = new StandardReportConfigsListSelectionListener();
        this.standardReportConfigurationsList.addListSelectionListener(this.rcListHandler);
        this.standardReportConfigurationsList.setCellRenderer(new ReportsConfigurationRenderer());
        this.standardReportConfigurationsList.setSelectionMode(0);
        this.standardReportSP = new JScrollPane(this.standardReportConfigurationsList);
        this.westPanel.add((Component)toolBar, new CC().dockNorth());
        this.westPanel.add((Component)this.standardReportSP, new CC().grow());
    }

    private void initEestPanel() {
        this.eastPanel = new JPanel((LayoutManager)new MigLayout("fill", "[]", "0[]0[]0[]0"));
        this.eastPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportsConfigurationDialog.ConfigurationDetails")));
        JPanel northPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[80!]0[]0", "0[]0[]0"));
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[]0", "0[grow]0[grow]0"));
        JPanel subviewsPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[grow]0[]0[grow]0", "0[]0"));
        subviewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportsConfigurationDialog.SubViews")));
        JPanel objectsPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[grow]0", "0[grow]0"));
        objectsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportsConfigurationDialog.Objects")));
        JLabel lblName = new JLabel(Messages.getString("StandardReportsConfigurationDialog.Name"));
        this.txtName = new JTextField();
        this.txtName.setEnabled(false);
        this.txtName.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                StandardReportsConfigurationDialog.this.isSaved = false;
                StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            }
        });
        this.taDescription = new JTextArea();
        this.taDescription.setEnabled(false);
        this.taDescription.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                StandardReportsConfigurationDialog.this.isSaved = false;
                StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            }
        });
        this.taDescription.setLineWrap(true);
        this.taDescription.setWrapStyleWord(true);
        JScrollPane descriptionScrollPane = new JScrollPane(this.taDescription);
        descriptionScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportsConfigurationDialog.Description")));
        this.rbIncludeAll = new JRadioButton(Messages.getString("StandardReportsConfigurationDialog.INcludeAllObjects"));
        this.rbIncludeAll.setEnabled(false);
        this.rbChooseObjects = new JRadioButton(Messages.getString("StandardReportsConfigurationDialog.ChooseSWObjects"));
        this.rbChooseObjects.setEnabled(false);
        this.radioButtonListener = new RadioButtonListener();
        this.rbIncludeAll.addItemListener(this.radioButtonListener);
        this.rbChooseObjects.addItemListener(this.radioButtonListener);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbIncludeAll);
        group.add(this.rbChooseObjects);
        JPanel rbPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[]0", "0[]0"));
        rbPanel.add((Component)this.rbIncludeAll, new CC().wrap());
        rbPanel.add((Component)this.rbChooseObjects, new CC().wrap());
        northPanel.add(lblName);
        northPanel.add((Component)this.txtName, new CC().growX().wrap());
        northPanel.add((Component)descriptionScrollPane, new CC().minHeight("60").spanX(2).grow().wrap());
        northPanel.add((Component)rbPanel, new CC().spanX().wrap());
        JPanel allSubviewsPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[grow]0", "2[grow]0"));
        allSubviewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportsConfigurationDialog.All")));
        this.subviewsList = new FilteredSubViewsJList();
        this.subviewsList.setCellRenderer(new AllSubviewsRenderer());
        this.subviewsSPane = new JScrollPane(this.subviewsList);
        this.subviewsList.setEnabled(false);
        this.subviewsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (StandardReportsConfigurationDialog.this.subviewsList.getSelectedIndex() == -1) {
                    StandardReportsConfigurationDialog.this.btnSubviewAdd.setEnabled(false);
                } else {
                    StandardReportsConfigurationDialog.this.btnSubviewAdd.setEnabled(true);
                }
            }
        });
        this.subviewsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    StandardReportsConfigurationDialog.this.btnSubviewAdd.doClick();
                }
            }
        });
        JPanel subviewsFilterPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[80!]0[]0", "0[]0[]0"));
        JLabel subviewsFilterLabel = new JLabel(Messages.getString("StandardReportsConfigurationDialog.Filter"));
        this.subviewsFilter = new JTextField();
        this.subviewsFilter.setEnabled(false);
        this.subviewsFilter.getDocument().addDocumentListener(new SubViewsFilterListener());
        subviewsFilterPanel.add((Component)subviewsFilterLabel, new CC().width("80!"));
        subviewsFilterPanel.add((Component)this.subviewsFilter, new CC().growX());
        allSubviewsPanel.add((Component)subviewsFilterPanel, new CC().dockNorth());
        allSubviewsPanel.add((Component)this.subviewsSPane, new CC().grow());
        this.btnSubviewAdd = new JButton(this.guiConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.btnSubviewAdd.addActionListener(new AddSubviewActionListener());
        this.btnSubviewAdd.setEnabled(false);
        this.btnSubviewAdd.setPreferredSize(new Dimension(32, 32));
        this.btnSubviewRemove = new JButton(this.guiConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.btnSubviewRemove.addActionListener(new RemoveSubviewActionListener());
        this.btnSubviewRemove.setEnabled(false);
        this.btnSubviewRemove.setPreferredSize(new Dimension(32, 32));
        JPanel jpButtons = new JPanel();
        jpButtons.setLayout(new BoxLayout(jpButtons, 3));
        jpButtons.add(this.btnSubviewAdd);
        jpButtons.add(this.btnSubviewRemove);
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(jpButtons);
        verticalBox.add(Box.createVerticalGlue());
        JPanel selectedSubviewsPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[grow]0", "0[]0"));
        selectedSubviewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("StandardReportsConfigurationDialog.Selected")));
        this.selectedSubviewsListModel = new SelectedSubViewsModel();
        this.selectedSubviewsList = new JList(this.selectedSubviewsListModel);
        this.selectedSubviewsList.setCellRenderer(new SelectedSubviewsRenderer());
        this.selectedSubviewsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (StandardReportsConfigurationDialog.this.selectedSubviewsList.getSelectedIndex() == -1) {
                    StandardReportsConfigurationDialog.this.btnSubviewRemove.setEnabled(false);
                } else {
                    StandardReportsConfigurationDialog.this.btnSubviewRemove.setEnabled(true);
                }
            }
        });
        this.selectedSubviewsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    StandardReportsConfigurationDialog.this.btnSubviewRemove.doClick();
                }
            }
        });
        this.selectedSubviewsSPane = new JScrollPane(this.selectedSubviewsList);
        this.selectedSubviewsList.setEnabled(false);
        selectedSubviewsPanel.add((Component)this.selectedSubviewsSPane, new CC().grow());
        subviewsPanel.add((Component)allSubviewsPanel, new CC().width("200:200:").grow());
        subviewsPanel.add((Component)verticalBox, new CC().width("30!"));
        subviewsPanel.add((Component)selectedSubviewsPanel, new CC().width("200:200:").grow());
        this.currentObjectsList = new ArrayList<ReportsGenerationDialog.ReportObject>();
        this.objecstModel = new ObjectsModel();
        this.objectsSorter = new TableRowSorter<ObjectsModel>(this.objecstModel);
        this.objectsTable = new JTable(this.objecstModel);
        this.objectsTable.setEnabled(false);
        TableColumn col1 = this.objectsTable.getColumnModel().getColumn(1);
        col1.setCellRenderer(new CheckBoxRenderer());
        col1.setWidth(50);
        col1.setMaxWidth(50);
        this.objectsScrollPane = new JScrollPane(this.objectsTable);
        JPanel objectsFilterPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[80!]0[100::][23!]0[23!]0", "0[]0"));
        JLabel selectedObjectsFilterLabel = new JLabel(Messages.getString("StandardReportsConfigurationDialog.Filter"));
        this.objectsFilter = new JTextField();
        this.objectsFilter.setEnabled(false);
        this.objectsFilter.getDocument().addDocumentListener(new FilterObjectListener());
        this.btnSelectAll = new JButton(this.guiConfiguration.getIcon("SELECT_ALL"));
        this.btnSelectAll.setEnabled(false);
        this.btnSelectAll.setMnemonic(83);
        this.btnSelectAll.setToolTipText(Messages.getString("StandardReportsConfigurationDialog.SelectAll"));
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardReportsConfigurationDialog.this.checkAll(StandardReportsConfigurationDialog.this.objectsTable, StandardReportsConfigurationDialog.this.currentObjectsList, true);
                StandardReportsConfigurationDialog.this.objectsTable.updateUI();
                StandardReportsConfigurationDialog.this.isSaved = false;
            }
        });
        this.btnDeselectAll = new JButton(this.guiConfiguration.getIcon("DESELECT_ALL"));
        this.btnDeselectAll.setEnabled(false);
        this.btnDeselectAll.setMnemonic(68);
        this.btnDeselectAll.setToolTipText(Messages.getString("StandardReportsConfigurationDialog.DeselectAll"));
        this.btnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardReportsConfigurationDialog.this.checkAll(StandardReportsConfigurationDialog.this.objectsTable, StandardReportsConfigurationDialog.this.currentObjectsList, false);
                StandardReportsConfigurationDialog.this.objectsTable.updateUI();
                StandardReportsConfigurationDialog.this.isSaved = false;
            }
        });
        objectsFilterPanel.add(selectedObjectsFilterLabel);
        objectsFilterPanel.add((Component)this.objectsFilter, new CC().growX());
        objectsFilterPanel.add((Component)this.btnSelectAll, new CC().width("23!"));
        objectsFilterPanel.add((Component)this.btnDeselectAll, new CC().width("23!"));
        objectsPanel.add((Component)objectsFilterPanel, new CC().dockNorth());
        objectsPanel.add((Component)this.objectsScrollPane, new CC().grow());
        centerPanel.add((Component)subviewsPanel, new CC().minHeight("200").grow().wrap());
        centerPanel.add((Component)objectsPanel, new CC().minHeight("250").grow());
        this.eastPanel.add((Component)northPanel, new CC().dockNorth());
        this.eastPanel.add((Component)centerPanel, new CC().grow());
    }

    private void initButtonsPanel() {
        this.buttonsPanel = new JPanel((LayoutManager)new MigLayout("fill", "center", ""));
        JButton btnClose = new JButton(Messages.getString("StandardReportsConfigurationDialog.Close"));
        btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnClose.addActionListener(new CloseAction());
        btnClose.setMnemonic(67);
        JButton btnHelp = new JButton(this.getHelpAction());
        btnHelp.setMnemonic(72);
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JPanel bPanel = new JPanel();
        bPanel.add(btnClose);
        bPanel.add(btnHelp);
        this.buttonsPanel.add(bPanel);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("StandardReportsConfigurationDialog.StandardReportConfiguration"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(true);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = StandardReportsConfigurationDialog.this.dialog.getWidth();
                    int h = StandardReportsConfigurationDialog.this.dialog.getHeight();
                    w = Math.max(StandardReportsConfigurationDialog.this.getMinimumWidth(), w);
                    h = Math.max(StandardReportsConfigurationDialog.this.getMinimumHeight(), h);
                    StandardReportsConfigurationDialog.this.dialog.setSize(w, h);
                }
            });
            Settings.DialogSettings ds = this.getApplicationView().getSettings().getDialogSettings(this.getClass().getName());
            if (ds == null) {
                int w = this.getMinimumWidth();
                int h = this.getMinimumHeight();
                this.dialog.setSize(w, h);
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                int w = Math.max(this.getMinimumWidth(), (int)ds.rec.getSize().getWidth());
                int h = Math.max(this.getMinimumHeight(), (int)ds.rec.getSize().getHeight());
                this.dialog.setSize(w, h);
                this.dialog.setLocation(ds.rec.getLocation());
            }
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        Rectangle rectangle = new Rectangle(this.getLocation(), this.getSize());
        this.getApplicationView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "REPORTS_CONFIGURATIONS_DIALOG";
    }

    boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    private DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                String s1 = list.get(i).toString();
                String s2 = list.get(i - 1).toString();
                if (s1.toString().compareTo(s2.toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private DefaultListModel sortSRC(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                String s1 = ((StandardReportConfiguration)list.get(i)).getName().toString();
                String s2 = ((StandardReportConfiguration)list.get(i - 1)).getName().toString();
                if (s1.toString().compareTo(s2.toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private void newFilter(JTextField filterText, JTable currentTable) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), 0);
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    private void reloadSubViews() {
        SubViewsFilterModel subViewsFilterModel = (SubViewsFilterModel)this.subviewsList.getModel();
        subViewsFilterModel.clear();
        this.selectedSubviewsListModel.clear();
        List<String> selectedSW = this.currentSRC.getSubviews();
        if (selectedSW.size() > 0) {
            Iterator allSWIt = null;
            if (this.isLD) {
                allSWIt = ((SubViewObjectSet)this.allAvailableSubViewsList).iterator();
                while (allSWIt.hasNext()) {
                    DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)allSWIt.next();
                    Iterator<String> selectedSWIt = selectedSW.iterator();
                    boolean found = false;
                    while (selectedSWIt.hasNext()) {
                        String swID = selectedSWIt.next();
                        if (!ph.getObjectID().equals(swID)) continue;
                        this.selectedSubviewsListModel.addElement(ph);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    subViewsFilterModel.addElement(ph);
                }
            } else {
                for (ReportsGenerationDialog.RSchemaSubView rs : (List)this.allAvailableSubViewsList) {
                    Iterator<String> selectedSWIt = selectedSW.iterator();
                    boolean found = false;
                    while (selectedSWIt.hasNext()) {
                        String swID = selectedSWIt.next();
                        if (!rs.getObjectOVID().equals(swID)) continue;
                        this.selectedSubviewsListModel.addElement(rs);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    subViewsFilterModel.addElement(rs);
                }
            }
        } else if (this.isLD) {
            Iterator it0 = ((SubViewObjectSet)this.allAvailableSubViewsList).iterator();
            while (it0.hasNext()) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it0.next();
                subViewsFilterModel.addElement(ph);
            }
        } else {
            for (ReportsGenerationDialog.RSchemaSubView rs : (List)this.allAvailableSubViewsList) {
                subViewsFilterModel.addElement(rs);
            }
        }
        subViewsFilterModel.setInitialState();
    }

    private void reloadObjects() {
        try {
            this.objectsTable.setRowSorter(null);
            this.objectsTable.setAutoCreateRowSorter(false);
            this.currentObjectsList.clear();
            ArrayList<ReportsGenerationDialog.ReportObject> objectsFromsubviewsList = new ArrayList<ReportsGenerationDialog.ReportObject>();
            if (this.rbIncludeAll.isSelected()) {
                this.addAllObjects();
            }
            if (this.rbChooseObjects.isSelected()) {
                if (this.selectedSubviewsList.getModel().getSize() > 0) {
                    for (int i = 0; i < this.selectedSubviewsList.getModel().getSize(); ++i) {
                        Object currentSubView = this.selectedSubviewsList.getModel().getElementAt(i);
                        if (currentSubView instanceof DesignPartViewPlaceHolder) {
                            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)currentSubView;
                            for (TopView tv : ph.getDesignPartView().getTopviewsList()) {
                                DesignObject desObj = tv.getModel();
                                for (ReportsGenerationDialog.ReportObject ro : this.initialObjectsList) {
                                    if (!desObj.getObjectID().equals(ro.getObjectUniqueIdentifier()) || objectsFromsubviewsList.contains(ro)) continue;
                                    objectsFromsubviewsList.add(ro);
                                }
                            }
                            continue;
                        }
                        if (!(currentSubView instanceof ReportsGenerationDialog.RSchemaSubView)) continue;
                        ReportsGenerationDialog.RSchemaSubView sw = (ReportsGenerationDialog.RSchemaSubView)currentSubView;
                        for (ReportsGenerationDialog.ReportObject ro : this.initialObjectsList) {
                            if (!sw.getObjectOVID().equals(ro.getSubviewUniqueIdentifier()) || objectsFromsubviewsList.contains(ro)) continue;
                            objectsFromsubviewsList.add(ro);
                        }
                    }
                    for (ReportsGenerationDialog.ReportObject ro : objectsFromsubviewsList) {
                        boolean found = false;
                        for (String id : this.currentSRC.getObjects()) {
                            if (!ro.getObjectUniqueIdentifier().equals(id)) continue;
                            ro.setInReport(true);
                            found = true;
                            break;
                        }
                        if (!found) {
                            ro.setInReport(false);
                        }
                        this.currentObjectsList.add(ro);
                    }
                } else {
                    this.addAllObjects();
                }
            }
            if (this.currentObjectsList.size() > 0) {
                this.objectsTable.setRowSorter(this.objectsSorter);
                this.objectsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.objectsTable, 0);
                Collections.sort(this.currentObjectsList, new ReportObjectsComparator());
            }
            this.objectsTable.updateUI();
        }
        catch (Exception ex) {
            LOGGER.error(" Standard Report Config dialog - reload objects ", ex);
        }
    }

    private void addAllObjects() {
        for (ReportsGenerationDialog.ReportObject ro : this.initialObjectsList) {
            boolean found = false;
            for (String id : this.currentSRC.getObjects()) {
                if (!ro.getObjectUniqueIdentifier().equals(id)) continue;
                ro.setInReport(true);
                found = true;
                break;
            }
            if (!found) {
                ro.setInReport(false);
            }
            if (this.isLD) {
                this.currentObjectsList.add(ro);
                continue;
            }
            if (!ro.getDiagramType().equals("MainView")) continue;
            this.currentObjectsList.add(ro);
        }
    }

    @Override
    protected boolean canClose() {
        if (!this.isSaved) {
            String s1 = "Yes";
            String s2 = "No";
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("StandardReportsConfigurationDialog.NotSaved"), Messages.getString("StandardReportsConfigurationDialog.ClosConfirmation"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    private String generateName() {
        String name = TEMPLATE_NAME;
        int newNumber = 0;
        int lastNumber = this.standardReportsModel.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String nName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.nameExistsInModel(nName, null)) {
            newNumber = ++this.cgCounter;
            nName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return nName;
    }

    private boolean nameExistsInModel(String name, StandardReportConfiguration current) {
        for (int i = 0; i < this.standardReportsModel.size(); ++i) {
            StandardReportConfiguration rc = (StandardReportConfiguration)this.standardReportsModel.get(i);
            if (rc == current || !rc.getModelID().equals(this.modelObjId) || !rc.getDesignID().equals(this.designObjId) || rc.getClazz() != this.clazz || !name.equalsIgnoreCase(rc.getName())) continue;
            return true;
        }
        return false;
    }

    private void loadReportConfigurations() {
        this.standardReportsModel.clear();
        for (StandardReportConfiguration sr : this.allConfigurationsList) {
            if (!this.designObjId.equals(sr.getDesignID()) || !this.modelObjId.equals(sr.getModelID()) || sr.getClazz() != this.clazz) continue;
            this.standardReportsModel.addElement(sr);
        }
        this.sortSRC(this.standardReportsModel);
        if (this.standardReportsModel.getSize() > 0) {
            this.standardReportConfigurationsList.setSelectedIndex(0);
        }
    }

    private void showDetails() {
        this.currentSRC = (StandardReportConfiguration)this.standardReportsModel.get(this.standardReportConfigurationsList.getSelectedIndex());
        this.txtName.setText(this.currentSRC.getName());
        this.taDescription.setText(this.currentSRC.getDescription());
        this.rbIncludeAll.removeItemListener(this.radioButtonListener);
        this.rbChooseObjects.removeItemListener(this.radioButtonListener);
        if (this.currentSRC.getSubviews().size() > 0) {
            this.rbChooseObjects.setSelected(true);
        } else {
            this.rbIncludeAll.setSelected(true);
        }
        this.rbIncludeAll.addItemListener(this.radioButtonListener);
        this.rbChooseObjects.addItemListener(this.radioButtonListener);
        this.reloadSubViews();
        this.reloadObjects();
    }

    private void checkAll(JTable table, List<ReportsGenerationDialog.ReportObject> objects, boolean checked) {
        int[] selected = table.getSelectedRows();
        if (selected.length > 0) {
            for (int i = selected.length - 1; i >= 0; --i) {
                ReportsGenerationDialog.ReportObject obj = this.currentObjectsList.get(table.convertRowIndexToModel(selected[i]));
                obj.setInReport(checked);
            }
        } else {
            this.selectAll(table, objects, checked);
        }
        table.updateUI();
    }

    private void selectAll(JTable table, List<ReportsGenerationDialog.ReportObject> objects, boolean selected) {
        if (selected) {
            this.selectAll(table, objects);
        } else {
            this.deselectAll(table, objects);
        }
    }

    private void selectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                ReportsGenerationDialog.ReportObject o = (ReportsGenerationDialog.ReportObject)list.get(index);
                this.setSelected(o, true);
            }
        } else {
            for (ReportsGenerationDialog.ReportObject o : list) {
                this.setSelected(o, true);
            }
        }
    }

    private void deselectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                ReportsGenerationDialog.ReportObject o = (ReportsGenerationDialog.ReportObject)list.get(index);
                this.setSelected(o, false);
            }
        } else {
            for (ReportsGenerationDialog.ReportObject o : list) {
                this.setSelected(o, false);
            }
        }
    }

    private void setSelected(ReportsGenerationDialog.ReportObject obj, boolean selected) {
        if (obj != null) {
            obj.setInReport(selected);
        }
    }

    private static boolean match(String string, String regex) {
        if ("*".equalsIgnoreCase(regex)) {
            return true;
        }
        if (regex.indexOf(42) > -1) {
            regex = regex.replaceAll("\\*", "\\.*");
        }
        Pattern p = null;
        try {
            p = Pattern.compile(regex, 2);
            Matcher m = p.matcher(string);
            return m.find();
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    @Override
    protected int getMinimumWidth() {
        return 720;
    }

    @Override
    protected int getMinimumHeight() {
        return 690;
    }

    class ReportObjectsComparator
    implements Comparator {
        ReportObjectsComparator() {
        }

        public int compare(Object o1, Object o2) {
            ReportsGenerationDialog.ReportObject ro1 = (ReportsGenerationDialog.ReportObject)o1;
            ReportsGenerationDialog.ReportObject ro2 = (ReportsGenerationDialog.ReportObject)o2;
            return ro1.getObjectName().compareTo(ro2.getObjectName());
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int icol = StandardReportsConfigurationDialog.this.objectsTable.getEditingColumn();
            int irow = StandardReportsConfigurationDialog.this.objectsTable.getEditingRow();
            if (icol > -1 && irow > -1) {
                StandardReportsConfigurationDialog.this.objectsTable.getCellEditor(irow, icol).stopCellEditing();
            }
            StandardReportsConfigurationDialog.this.objectsTable.clearSelection();
            StandardReportsConfigurationDialog.this.objectsTable.setRowSorter(null);
            StandardReportsConfigurationDialog.this.objectsTable.setAutoCreateRowSorter(false);
            StandardReportsConfigurationDialog.this.objectsTable.updateUI();
            StandardReportsConfigurationDialog.this.objectsTable.updateUI();
            StandardReportsConfigurationDialog.this.currentSRC.setName(StandardReportsConfigurationDialog.this.backupSRC.getName());
            StandardReportsConfigurationDialog.this.currentSRC.setDescription(StandardReportsConfigurationDialog.this.backupSRC.getDescription());
            StandardReportsConfigurationDialog.this.currentSRC.getSubviews().clear();
            StandardReportsConfigurationDialog.this.currentSRC.getSubviews().addAll(StandardReportsConfigurationDialog.this.backupSRC.getSubviews());
            StandardReportsConfigurationDialog.this.currentSRC.getObjects().clear();
            StandardReportsConfigurationDialog.this.currentSRC.getObjects().addAll(StandardReportsConfigurationDialog.this.backupSRC.getObjects());
            StandardReportsConfigurationDialog.this.txtName.setEnabled(false);
            StandardReportsConfigurationDialog.this.taDescription.setEnabled(false);
            StandardReportsConfigurationDialog.this.rbIncludeAll.setEnabled(false);
            StandardReportsConfigurationDialog.this.rbIncludeAll.setSelected(false);
            StandardReportsConfigurationDialog.this.rbChooseObjects.setEnabled(false);
            StandardReportsConfigurationDialog.this.objectsTable.setEnabled(false);
            StandardReportsConfigurationDialog.this.objectsFilter.setEnabled(false);
            StandardReportsConfigurationDialog.this.subviewsFilter.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnSelectAll.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnDeselectAll.setEnabled(false);
            StandardReportsConfigurationDialog.this.subviewsList.clearSelection();
            StandardReportsConfigurationDialog.this.subviewsList.setEnabled(false);
            StandardReportsConfigurationDialog.this.selectedSubviewsList.clearSelection();
            StandardReportsConfigurationDialog.this.selectedSubviewsList.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnSave.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnAdd.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnEdit.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnRemove.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnCancel.setEnabled(false);
            StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setEnabled(true);
            StandardReportsConfigurationDialog.this.standardReportConfigurationsList.clearSelection();
            StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setSelectedValue(StandardReportsConfigurationDialog.this.currentSRC, true);
            StandardReportsConfigurationDialog.this.backupSRC = null;
            StandardReportsConfigurationDialog.this.isSaved = true;
        }
    }

    private class SelectedSubViewsModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();

        private SelectedSubViewsModel() {
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        private List getItems() {
            return this.items;
        }

        @Override
        public Object getElementAt(int index) {
            return this.items.get(index);
        }

        private void clear() {
            this.items.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private boolean contains(Object element) {
            return this.items.contains(element);
        }

        private void addElement(Object o) {
            this.items.add(o);
            this.fireIntervalAdded(this, 0, this.getSize());
        }

        private void removeElement(Object o) {
            this.items.remove(o);
            this.fireIntervalRemoved(this, 0, this.getSize());
        }
    }

    private class SubViewsFilterModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();
        ArrayList filterItems = new ArrayList();

        @Override
        public Object getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filterItems.size();
        }

        private void add(Object o) {
            this.filterItems.add(o);
            StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.add(o);
            this.fireIntervalAdded(this, 0, this.getSize());
            Collections.sort(this.filterItems, StandardReportsConfigurationDialog.this.toStringComparator);
        }

        private void remove(Object o) {
            this.filterItems.remove(o);
            StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.remove(o);
            this.fireIntervalRemoved(this, 0, this.getSize());
        }

        private void refilter() {
            this.filterItems.clear();
            String term = StandardReportsConfigurationDialog.this.subviewsFilter.getText();
            for (int i = 0; i < StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.size(); ++i) {
                String name = "";
                name = StandardReportsConfigurationDialog.this.isLD ? ((DesignPartViewPlaceHolder)StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.get(i)).getName() : ((ReportsGenerationDialog.RSchemaSubView)StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.get(i)).getName();
                if (StandardReportsConfigurationDialog.match(name, term)) {
                    this.filterItems.add(StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.get(i));
                }
                this.fireContentsChanged(this, 0, this.getSize());
            }
            Collections.sort(this.filterItems, StandardReportsConfigurationDialog.this.toStringComparator);
        }

        public Object getObjectByID(String id) {
            for (Object obj : this.filterItems) {
                String objID = "";
                if (obj instanceof DesignPartViewPlaceHolder) {
                    DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)obj;
                    objID = ph.getObjectID();
                } else if (obj instanceof ReportsGenerationDialog.RSchemaSubView) {
                    ReportsGenerationDialog.RSchemaSubView rs = (ReportsGenerationDialog.RSchemaSubView)obj;
                    objID = rs.getObjectOVID();
                }
                if (!objID.equals(id)) continue;
                return obj;
            }
            return "";
        }

        private void setInitialState() {
            this.filterItems.addAll(this.items);
            Collections.sort(this.filterItems, StandardReportsConfigurationDialog.this.toStringComparator);
            StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.addAll(this.items);
        }

        private void addElement(Object o) {
            this.items.add(o);
        }

        private void clear() {
            this.items.clear();
            this.filterItems.clear();
            StandardReportsConfigurationDialog.this.currentNonSelectedSubViewsList.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private boolean contains(Object element) {
            return this.filterItems.contains(element);
        }
    }

    class FilteredSubViewsJList
    extends JList {
        public FilteredSubViewsJList() {
            this.setModel((ListModel)new SubViewsFilterModel());
        }

        public void setModel(ListModel m) {
            if (!(m instanceof SubViewsFilterModel)) {
                throw new IllegalArgumentException();
            }
            super.setModel(m);
        }
    }

    private class StandardReportConfigsListSelectionListener
    implements ListSelectionListener {
        private StandardReportConfigsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int selected = StandardReportsConfigurationDialog.this.standardReportConfigurationsList.getSelectedIndex();
                if (selected == -1) {
                    StandardReportsConfigurationDialog.this.btnAdd.setEnabled(true);
                    StandardReportsConfigurationDialog.this.btnEdit.setEnabled(false);
                    StandardReportsConfigurationDialog.this.btnRemove.setEnabled(false);
                    StandardReportsConfigurationDialog.this.btnSave.setEnabled(false);
                    StandardReportsConfigurationDialog.this.subviewsList.setEnabled(false);
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.setEnabled(false);
                } else {
                    StandardReportsConfigurationDialog.this.btnAdd.setEnabled(true);
                    StandardReportsConfigurationDialog.this.btnEdit.setEnabled(true);
                    StandardReportsConfigurationDialog.this.btnRemove.setEnabled(true);
                    StandardReportsConfigurationDialog.this.btnSave.setEnabled(false);
                    StandardReportsConfigurationDialog.this.showDetails();
                }
            } else {
                StandardReportsConfigurationDialog.this.txtName.setText("");
                StandardReportsConfigurationDialog.this.taDescription.setText("");
                SubViewsFilterModel subViewsFilterModel = (SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel();
                subViewsFilterModel.clear();
                StandardReportsConfigurationDialog.this.selectedSubviewsListModel.clear();
                StandardReportsConfigurationDialog.this.currentObjectsList.clear();
                StandardReportsConfigurationDialog.this.objectsTable.updateUI();
            }
        }
    }

    private class SelectedSubviewsRenderer
    extends JLabel
    implements ListCellRenderer {
        private SelectedSubviewsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DesignPartViewPlaceHolder) {
                this.setText(((DesignPartViewPlaceHolder)value).getName());
            } else if (value instanceof ReportsGenerationDialog.RSchemaSubView) {
                this.setText(((ReportsGenerationDialog.RSchemaSubView)value).getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class AllSubviewsRenderer
    extends JLabel
    implements ListCellRenderer {
        private AllSubviewsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DesignPartViewPlaceHolder) {
                this.setText(((DesignPartViewPlaceHolder)value).getName());
            } else if (value instanceof ReportsGenerationDialog.RSchemaSubView) {
                this.setText(((ReportsGenerationDialog.RSchemaSubView)value).getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class ReportsConfigurationRenderer
    extends JLabel
    implements ListCellRenderer {
        private ReportsConfigurationRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            StandardReportConfiguration r = (StandardReportConfiguration)value;
            this.setText(r.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class EditAction
    implements ActionListener {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardReportsConfigurationDialog.this.backupSRC = new StandardReportConfiguration(StandardReportsConfigurationDialog.this.clazz, StandardReportsConfigurationDialog.this.currentSRC.getName(), StandardReportsConfigurationDialog.this.currentSRC.getDescription(), StandardReportsConfigurationDialog.this.currentSRC.getDesignID(), StandardReportsConfigurationDialog.this.currentSRC.getModelID(), StandardReportsConfigurationDialog.this.currentSRC.isIncludeDuplicates(), StandardReportsConfigurationDialog.this.currentSRC.getSubviews(), StandardReportsConfigurationDialog.this.currentSRC.getObjects(), StandardReportsConfigurationDialog.this.currentSRC.getReportTemplateId());
            StandardReportsConfigurationDialog.this.taDescription.setEnabled(true);
            StandardReportsConfigurationDialog.this.txtName.setEnabled(true);
            StandardReportsConfigurationDialog.this.rbIncludeAll.setEnabled(true);
            StandardReportsConfigurationDialog.this.rbChooseObjects.setEnabled(true);
            StandardReportsConfigurationDialog.this.objectsFilter.setEnabled(true);
            StandardReportsConfigurationDialog.this.objectsTable.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnSelectAll.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnDeselectAll.setEnabled(true);
            StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnAdd.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnEdit.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnRemove.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnCancel.setEnabled(true);
            if (StandardReportsConfigurationDialog.this.rbChooseObjects.isSelected()) {
                StandardReportsConfigurationDialog.this.subviewsFilter.setEnabled(true);
                StandardReportsConfigurationDialog.this.subviewsList.setEnabled(true);
                StandardReportsConfigurationDialog.this.selectedSubviewsList.setEnabled(true);
            } else {
                StandardReportsConfigurationDialog.this.subviewsFilter.setEnabled(false);
                StandardReportsConfigurationDialog.this.subviewsList.clearSelection();
                StandardReportsConfigurationDialog.this.subviewsList.setEnabled(false);
                StandardReportsConfigurationDialog.this.selectedSubviewsList.clearSelection();
                StandardReportsConfigurationDialog.this.selectedSubviewsList.setEnabled(false);
            }
            StandardReportsConfigurationDialog.this.objectsSorter.setSortsOnUpdates(true);
            if (StandardReportsConfigurationDialog.this.currentObjectsList.size() > 0) {
                StandardReportsConfigurationDialog.this.objectsTable.setRowSorter(StandardReportsConfigurationDialog.this.objectsSorter);
                StandardReportsConfigurationDialog.this.objectsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(StandardReportsConfigurationDialog.this.objectsTable, 0);
            }
            StandardReportsConfigurationDialog.this.isSaved = false;
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (StandardReportsConfigurationDialog.this.txtName.getText().equals("")) {
                    JOptionPane.showMessageDialog(StandardReportsConfigurationDialog.this.srd, Messages.getString("StandardReportsConfigurationDialog.NameCanNotBeEmpty"), Messages.getString("StandardReportsConfigurationDialog.Error"), 0);
                    StandardReportsConfigurationDialog.this.txtName.requestFocus();
                } else {
                    StandardReportsConfigurationDialog.this.currentSRC = (StandardReportConfiguration)StandardReportsConfigurationDialog.this.standardReportsModel.get(StandardReportsConfigurationDialog.this.standardReportConfigurationsList.getSelectedIndex());
                    String name = StandardReportsConfigurationDialog.this.txtName.getText();
                    int counter = 0;
                    while (StandardReportsConfigurationDialog.this.nameExistsInModel(name, StandardReportsConfigurationDialog.this.currentSRC)) {
                        name = StandardReportsConfigurationDialog.this.txtName.getText().concat("_").concat(Integer.toString(++counter));
                    }
                    StandardReportsConfigurationDialog.this.currentSRC.setName(name);
                    StandardReportsConfigurationDialog.this.currentSRC.setDescription(StandardReportsConfigurationDialog.this.taDescription.getText());
                    List<String> subviews = StandardReportsConfigurationDialog.this.currentSRC.getSubviews();
                    subviews.clear();
                    for (Object sw : StandardReportsConfigurationDialog.this.selectedSubviewsListModel.getItems()) {
                        String id = "";
                        if (sw instanceof DesignPartViewPlaceHolder) {
                            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)sw;
                            id = ph.getObjectID();
                        } else if (sw instanceof ReportsGenerationDialog.RSchemaSubView) {
                            ReportsGenerationDialog.RSchemaSubView rs = (ReportsGenerationDialog.RSchemaSubView)sw;
                            id = rs.getObjectOVID();
                        }
                        subviews.add(id);
                    }
                    List objs = StandardReportsConfigurationDialog.this.currentSRC.getObjects();
                    objs.clear();
                    for (ReportsGenerationDialog.ReportObject ro : StandardReportsConfigurationDialog.this.currentObjectsList) {
                        if (!ro.isInReport()) continue;
                        objs.add(ro.getObjectUniqueIdentifier());
                    }
                    boolean found = false;
                    for (StandardReportConfiguration rcf : StandardReportsConfigurationDialog.this.allConfigurationsList) {
                        if (!StandardReportsConfigurationDialog.this.currentSRC.getModelID().equals(rcf.getModelID()) || !StandardReportsConfigurationDialog.this.currentSRC.getDesignID().equals(rcf.getDesignID()) || StandardReportsConfigurationDialog.this.currentSRC.getClazz() != StandardReportsConfigurationDialog.this.clazz || !StandardReportsConfigurationDialog.this.currentSRC.getName().equalsIgnoreCase(rcf.getName())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        StandardReportsConfigurationDialog.this.allConfigurationsList.add(StandardReportsConfigurationDialog.this.currentSRC);
                    }
                    StandardReportsConfigurationDialog.this.standardReportPersistence.saveStandardReportConfigurations();
                    StandardReportsConfigurationDialog.this.parent.reloadReportConfigurations(StandardReportsConfigurationDialog.this.isLD);
                    StandardReportsConfigurationDialog.this.txtName.setEnabled(false);
                    StandardReportsConfigurationDialog.this.taDescription.setEnabled(false);
                    StandardReportsConfigurationDialog.this.rbIncludeAll.setEnabled(false);
                    StandardReportsConfigurationDialog.this.rbIncludeAll.setSelected(false);
                    StandardReportsConfigurationDialog.this.rbChooseObjects.setEnabled(false);
                    StandardReportsConfigurationDialog.this.objectsTable.setEnabled(false);
                    StandardReportsConfigurationDialog.this.objectsFilter.setEnabled(false);
                    StandardReportsConfigurationDialog.this.subviewsFilter.setEnabled(false);
                    StandardReportsConfigurationDialog.this.btnSelectAll.setEnabled(false);
                    StandardReportsConfigurationDialog.this.btnDeselectAll.setEnabled(false);
                    StandardReportsConfigurationDialog.this.subviewsList.clearSelection();
                    StandardReportsConfigurationDialog.this.subviewsList.setEnabled(false);
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.clearSelection();
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.setEnabled(false);
                    StandardReportsConfigurationDialog.this.btnSave.setEnabled(false);
                    StandardReportsConfigurationDialog.this.btnAdd.setEnabled(true);
                    StandardReportsConfigurationDialog.this.btnEdit.setEnabled(true);
                    StandardReportsConfigurationDialog.this.btnRemove.setEnabled(true);
                    StandardReportsConfigurationDialog.this.btnCancel.setEnabled(false);
                    StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setEnabled(true);
                    StandardReportsConfigurationDialog.this.sortSRC(StandardReportsConfigurationDialog.this.standardReportsModel);
                    StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setSelectedValue(StandardReportsConfigurationDialog.this.currentSRC, true);
                    StandardReportsConfigurationDialog.this.objectsTable.setRowSorter(null);
                    StandardReportsConfigurationDialog.this.objectsTable.setAutoCreateRowSorter(false);
                    StandardReportsConfigurationDialog.this.objectsTable.updateUI();
                    StandardReportsConfigurationDialog.this.backupSRC = null;
                }
                StandardReportsConfigurationDialog.this.isSaved = true;
            }
            catch (Exception ex) {
                LOGGER.error(" Standard Report Config dialog - Error when save ", ex);
            }
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardReportsConfigurationDialog.this.currentSRC = (StandardReportConfiguration)StandardReportsConfigurationDialog.this.standardReportsModel.get(StandardReportsConfigurationDialog.this.standardReportConfigurationsList.getSelectedIndex());
            int result = JOptionPane.showConfirmDialog(StandardReportsConfigurationDialog.this, MessageFormat.format(Messages.getString("CustomizableReportsTemplatesDialog.AreYouSure"), StandardReportsConfigurationDialog.this.currentSRC.getName()), Messages.getString("CustomizableReportsTemplatesDialog.SelectAnOption"), 0);
            if (result == 0) {
                StandardReportsConfigurationDialog.this.standardReportsModel.remove(StandardReportsConfigurationDialog.this.standardReportConfigurationsList.getSelectedIndex());
                for (StandardReportConfiguration rc : StandardReportsConfigurationDialog.this.allConfigurationsList) {
                    if (rc.getReportTemplateId() != StandardReportsConfigurationDialog.this.currentSRC.getReportTemplateId()) continue;
                    StandardReportsConfigurationDialog.this.allConfigurationsList.remove(rc);
                    StandardReportsConfigurationDialog.this.standardReportPersistence.saveStandardReportConfigurations();
                    StandardReportsConfigurationDialog.this.parent.reloadReportConfigurations(StandardReportsConfigurationDialog.this.isLD);
                    break;
                }
                if (StandardReportsConfigurationDialog.this.standardReportConfigurationsList.getModel().getSize() > 0) {
                    StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setSelectedIndex(0);
                }
            }
            StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setEnabled(true);
            StandardReportsConfigurationDialog.this.txtName.setEnabled(false);
            StandardReportsConfigurationDialog.this.taDescription.setEnabled(false);
            StandardReportsConfigurationDialog.this.rbChooseObjects.setEnabled(false);
            StandardReportsConfigurationDialog.this.rbIncludeAll.setEnabled(false);
            StandardReportsConfigurationDialog.this.objectsFilter.setEnabled(false);
            StandardReportsConfigurationDialog.this.objectsTable.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnSelectAll.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnDeselectAll.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnCancel.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnSave.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnAdd.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnEdit.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnRemove.setEnabled(true);
            StandardReportsConfigurationDialog.this.isSaved = true;
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = StandardReportsConfigurationDialog.this.generateName();
            ArrayList<String> objectIDs = new ArrayList<String>();
            for (ReportsGenerationDialog.ReportObject ro : StandardReportsConfigurationDialog.this.initialObjectsList) {
                objectIDs.add(ro.getObjectUniqueIdentifier());
            }
            StandardReportConfiguration report = new StandardReportConfiguration(StandardReportsConfigurationDialog.this.clazz, name, "", StandardReportsConfigurationDialog.this.designObjId, StandardReportsConfigurationDialog.this.modelObjId, true, new ArrayList(), objectIDs, null);
            StandardReportsConfigurationDialog.this.standardReportsModel.addElement(report);
            StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setSelectedValue(report, true);
            StandardReportsConfigurationDialog.this.standardReportConfigurationsList.setEnabled(false);
            StandardReportsConfigurationDialog.this.objectsTable.setEnabled(true);
            StandardReportsConfigurationDialog.this.objectsTable.updateUI();
            StandardReportsConfigurationDialog.this.objectsFilter.setEnabled(true);
            StandardReportsConfigurationDialog.this.txtName.setEnabled(true);
            StandardReportsConfigurationDialog.this.taDescription.setText("");
            StandardReportsConfigurationDialog.this.taDescription.setEnabled(true);
            StandardReportsConfigurationDialog.this.rbIncludeAll.setEnabled(true);
            StandardReportsConfigurationDialog.this.rbIncludeAll.setSelected(true);
            StandardReportsConfigurationDialog.this.rbChooseObjects.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnSelectAll.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnDeselectAll.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnAdd.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnEdit.setEnabled(false);
            StandardReportsConfigurationDialog.this.btnRemove.setEnabled(true);
            StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            StandardReportsConfigurationDialog.this.objectsSorter.setSortsOnUpdates(true);
            if (StandardReportsConfigurationDialog.this.currentObjectsList.size() > 0) {
                StandardReportsConfigurationDialog.this.objectsTable.setRowSorter(StandardReportsConfigurationDialog.this.objectsSorter);
                StandardReportsConfigurationDialog.this.objectsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(StandardReportsConfigurationDialog.this.objectsTable, 0);
            }
            StandardReportsConfigurationDialog.this.isSaved = false;
        }
    }

    private class FilterObjectListener
    implements DocumentListener {
        private FilterObjectListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            StandardReportsConfigurationDialog.this.newFilter(StandardReportsConfigurationDialog.this.objectsFilter, StandardReportsConfigurationDialog.this.objectsTable);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            StandardReportsConfigurationDialog.this.newFilter(StandardReportsConfigurationDialog.this.objectsFilter, StandardReportsConfigurationDialog.this.objectsTable);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            StandardReportsConfigurationDialog.this.newFilter(StandardReportsConfigurationDialog.this.objectsFilter, StandardReportsConfigurationDialog.this.objectsTable);
        }
    }

    private class SubViewsFilterListener
    implements DocumentListener {
        private SubViewsFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ((SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel()).refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ((SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel()).refilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ((SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel()).refilter();
        }
    }

    public class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean val = (Boolean)value;
            this.setSelected(val);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private class RadioButtonListener
    implements ItemListener {
        private RadioButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (StandardReportsConfigurationDialog.this.rbIncludeAll.isSelected()) {
                    StandardReportsConfigurationDialog.this.subviewsList.clearSelection();
                    StandardReportsConfigurationDialog.this.subviewsList.setEnabled(false);
                    StandardReportsConfigurationDialog.this.subviewsFilter.setEnabled(false);
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.setEnabled(false);
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.clearSelection();
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.removeAll();
                }
                if (StandardReportsConfigurationDialog.this.rbChooseObjects.isSelected()) {
                    StandardReportsConfigurationDialog.this.subviewsList.setEnabled(true);
                    StandardReportsConfigurationDialog.this.subviewsFilter.setEnabled(true);
                    StandardReportsConfigurationDialog.this.selectedSubviewsList.setEnabled(true);
                }
                StandardReportsConfigurationDialog.this.reloadObjects();
            }
            StandardReportsConfigurationDialog.this.isSaved = false;
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StandardReportsConfigurationDialog.this.canClose()) {
                StandardReportsConfigurationDialog.this.close();
            }
        }
    }

    private class RemoveSubviewActionListener
    implements ActionListener {
        private RemoveSubviewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ArrayList removalList = new ArrayList();
                ArrayList selectedObjects = new ArrayList();
                int[] selectedSubviewsIndices = StandardReportsConfigurationDialog.this.selectedSubviewsList.getSelectedIndices();
                for (int i = 0; i < selectedSubviewsIndices.length; ++i) {
                    Object o = StandardReportsConfigurationDialog.this.selectedSubviewsList.getModel().getElementAt(selectedSubviewsIndices[i]);
                    selectedObjects.add(o);
                    if (((SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel()).contains(o)) continue;
                    ((SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel()).add(o);
                    removalList.add(o);
                }
                Iterator it = removalList.iterator();
                while (it.hasNext()) {
                    StandardReportsConfigurationDialog.this.selectedSubviewsListModel.removeElement(it.next());
                }
                StandardReportsConfigurationDialog.this.reloadObjects();
                StandardReportsConfigurationDialog.this.isSaved = false;
                StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            }
            catch (Exception ex) {
                LOGGER.error(" Standard Report Config dialog - Error when deselecting subview ", ex);
            }
        }
    }

    private class AddSubviewActionListener
    implements ActionListener {
        private AddSubviewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ArrayList selectedObjects = new ArrayList();
                ArrayList removalList = new ArrayList();
                int[] selectedSubviewsIndices = StandardReportsConfigurationDialog.this.subviewsList.getSelectedIndices();
                for (int i = 0; i < selectedSubviewsIndices.length; ++i) {
                    Object o = StandardReportsConfigurationDialog.this.subviewsList.getModel().getElementAt(selectedSubviewsIndices[i]);
                    selectedObjects.add(o);
                    if (StandardReportsConfigurationDialog.this.selectedSubviewsListModel.contains(o)) continue;
                    StandardReportsConfigurationDialog.this.selectedSubviewsListModel.addElement(o);
                    removalList.add(o);
                }
                SubViewsFilterModel subViewsFilterModel = (SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel();
                Iterator it = removalList.iterator();
                while (it.hasNext()) {
                    subViewsFilterModel.remove(it.next());
                }
                if (((SubViewsFilterModel)StandardReportsConfigurationDialog.this.subviewsList.getModel()).getSize() > 0) {
                    StandardReportsConfigurationDialog.this.subviewsList.setSelectedIndex(-1);
                    Object o = StandardReportsConfigurationDialog.this.subviewsList.getModel().getElementAt(selectedSubviewsIndices[0]);
                    if (o == null) {
                        StandardReportsConfigurationDialog.this.subviewsList.setSelectedIndex(selectedSubviewsIndices[0] - 1);
                    } else {
                        StandardReportsConfigurationDialog.this.subviewsList.setSelectedIndex(selectedSubviewsIndices[0]);
                    }
                } else {
                    StandardReportsConfigurationDialog.this.btnSubviewAdd.setEnabled(false);
                }
                StandardReportsConfigurationDialog.this.reloadObjects();
                StandardReportsConfigurationDialog.this.isSaved = false;
                StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            }
            catch (Exception ex) {
                LOGGER.error(" Standard Report Config dialog - Error when selecting subview ", ex);
            }
        }
    }

    private class ObjectsModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("StandardReportsConfigurationDialog.ObjectName"), Messages.getString("StandardReportsConfigurationDialog.Use")};

        private ObjectsModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public int getRowCount() {
            return StandardReportsConfigurationDialog.this.currentObjectsList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        public void add(ReportsGenerationDialog.ReportObject reportObject) {
            StandardReportsConfigurationDialog.this.currentObjectsList.add(reportObject);
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return ReportsGenerationDialog.ReportObject.class;
            }
            if (c == 1) {
                return Boolean.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ReportsGenerationDialog.ReportObject o = (ReportsGenerationDialog.ReportObject)StandardReportsConfigurationDialog.this.currentObjectsList.get(rowIndex);
            if (columnIndex == 0) {
                return o.getObjectName();
            }
            if (columnIndex == 1) {
                return o.isInReport();
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ReportsGenerationDialog.ReportObject o = (ReportsGenerationDialog.ReportObject)StandardReportsConfigurationDialog.this.currentObjectsList.get(row);
            if (col == 1) {
                o.setInReport((Boolean)value);
                StandardReportsConfigurationDialog.this.isSaved = false;
                StandardReportsConfigurationDialog.this.btnSave.setEnabled(true);
            }
        }
    }
}

