/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerationDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class SelectGlossaryDialog
extends CustomDialog {
    private static final long serialVersionUID = -2774925804241895401L;
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    private int result = 0;
    private JDialog dialog;
    private JPanel mainPanel;
    private ReportsGenerationDialog parent;
    public JButton bnClose;
    public JButton bnOK;
    private JScrollPane availableObjectsSP;
    private List availableGlossariesList;
    private Connection connection;
    private JTable glossariesTable;
    private static final Logger LOGGER = new Logger(SelectGlossaryDialog.class);

    public SelectGlossaryDialog(ApplicationView appView, ReportsGenerationDialog parent, Connection connection) {
        super(appView);
        this.parent = parent;
        this.connection = connection;
        this.init();
        this.initGlossariesPanel();
        this.initButtonsPanel();
        this.loadGlossaries();
    }

    private void init() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(350, 500));
        this.add((Component)this.mainPanel, "Center");
    }

    private void initGlossariesPanel() {
        JPanel objectdPanel = new JPanel(new BorderLayout());
        this.availableGlossariesList = new ArrayList();
        this.glossariesTable = new JTable(new GlossariesTableModel());
        this.glossariesTable.setSelectionMode(0);
        this.glossariesTable.getColumnModel().removeColumn(this.glossariesTable.getColumnModel().getColumn(2));
        this.availableObjectsSP = new JScrollPane(this.glossariesTable);
        this.availableObjectsSP.setPreferredSize(new Dimension(340, 460));
        objectdPanel.add(this.availableObjectsSP);
        this.glossariesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SelectGlossaryDialog.this.glossariesTable.getSelectedRow() == -1) {
                    SelectGlossaryDialog.this.bnOK.setEnabled(false);
                } else {
                    SelectGlossaryDialog.this.bnOK.setEnabled(true);
                }
            }
        });
        this.mainPanel.add((Component)objectdPanel, "North");
    }

    private void initButtonsPanel() {
        JPanel bp = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(Messages.getString("ReportsGenerationDialog.OK"));
        this.bnOK.setEnabled(false);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.addActionListener(new OKAction());
        bp.add(this.bnOK);
        this.bnClose = new JButton(Messages.getString("ReportsGenerationDialog.Close"));
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.addActionListener(new CloseAction());
        bp.add(this.bnClose);
        this.mainPanel.add((Component)bp, "South");
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectGlossaryDialog.SelectGlossary"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    private boolean loadGlossaries() {
        boolean result;
        block9: {
            result = false;
            try {
                if (this.connection == null) break block9;
                try {
                    float vers = SchemaFactory.schemaVersion(this.connection);
                    if (vers != 0.0f) {
                        String query = "SELECT  TO_CHAR(date_published,'dd.mm.yyyy hh24:mi:ss'), glossary_name, glossary_ovid FROM  dmrs_glossaries ORDER BY glossary_name, date_published";
                        try {
                            Statement stmt = this.connection.createStatement();
                            ResultSet rset = stmt.executeQuery(query);
                            while (rset.next()) {
                                GlossaryObject go = new GlossaryObject();
                                go.setDatePublished(rset.getString(1));
                                go.setGlossaryObjName(rset.getString(2));
                                go.setGlossaryObjOVID(rset.getString(3));
                                this.availableGlossariesList.add(go);
                            }
                            stmt.close();
                            result = true;
                        }
                        catch (SQLException e) {
                            LOGGER.error("SelectGlossaryDialog.loadDesigns()", e);
                        }
                        break block9;
                    }
                    MessageDialogs.showMessage(Messages.getString("SelectGlossaryDialog.ReportingRepositoryNotExisting"));
                }
                catch (DifferentVersionException dve) {
                    MessageDialogs.showWarningMessage(Messages.getString("SelectGlossaryDialog.DBSchemaOutOfDate"));
                }
                catch (Exception e) {
                    LOGGER.error("SelectGlossaryDialog.loadDesigns()", e);
                    MessageDialogs.showErrorMessage(Messages.getString("SelectGlossaryDialog.UnableToLoadDesigns"), true);
                }
            }
            catch (Exception e) {
                LOGGER.error("SelectGlossaryDialog.loadDesigns()", e);
                MessageDialogs.showErrorMessage(Messages.getString("SelectGlossaryDialog.UnableToLoadDesigns"));
            }
        }
        return result;
    }

    public int showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    private class GlossariesTableModel
    extends AbstractTableModel {
        private GlossariesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SelectGlossaryDialog.this.availableGlossariesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SelectGlossaryDialog.GlossaryName");
            }
            if (column == 1) {
                return Messages.getString("SelectGlossaryDialog.GlossaryDP");
            }
            if (column == 2) {
                return "OVID";
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            GlossaryObject obj = (GlossaryObject)SelectGlossaryDialog.this.availableGlossariesList.get(row);
            if (col == 0) {
                return obj.getGlossaryObjName();
            }
            if (col == 1) {
                return obj.getDatePublished();
            }
            if (col == 2) {
                return obj.getGlossaryObjOVID();
            }
            return new Integer(row * col);
        }
    }

    private class GlossaryObject {
        private String glossaryObjName;
        private String datePublished;
        private String glossaryObjOVID;

        private GlossaryObject() {
        }

        public String getGlossaryObjName() {
            return this.glossaryObjName;
        }

        public void setGlossaryObjName(String glossaryObjName) {
            this.glossaryObjName = glossaryObjName;
        }

        public String getDatePublished() {
            return this.datePublished;
        }

        public void setDatePublished(String datePublished) {
            this.datePublished = datePublished;
        }

        public String getGlossaryObjOVID() {
            return this.glossaryObjOVID;
        }

        public void setGlossaryObjOVID(String glossaryObjOVID) {
            this.glossaryObjOVID = glossaryObjOVID;
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectGlossaryDialog.this.parent.setSelectedGlossaryOVID((String)SelectGlossaryDialog.this.glossariesTable.getModel().getValueAt(SelectGlossaryDialog.this.glossariesTable.getSelectedRow(), 2));
            SelectGlossaryDialog.this.close();
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectGlossaryDialog.this.close();
        }
    }
}

