/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;

public class HTMLReportSeparateFiles {
    private static final Logger LOGGER = new Logger(HTMLReportSeparateFiles.class);

    public static StringBuffer createHTMLIndexPage(String TOCFileName, String reportFileName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        buffer.append("\n");
        buffer.append("<head>");
        buffer.append("\n");
        buffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>");
        buffer.append("\n");
        buffer.append("<title>" + reportFileName.substring(0, reportFileName.indexOf(".")) + "</title>");
        buffer.append("\n");
        buffer.append("</head>");
        buffer.append("\n");
        buffer.append("<frameset cols=\"20%,80%\">");
        buffer.append("\n");
        buffer.append("<frame name=\"toc\" src=\"" + TOCFileName + "\">");
        buffer.append("\n");
        buffer.append("<frame name=\"details\" src=\"" + reportFileName + "\"></frameset>");
        buffer.append("\n");
        buffer.append("</html>");
        return buffer;
    }

    public static StringBuffer createHTMLTOCPage(String reportFileName, List objects, Settings settings, List diagramsNamesList, boolean isRepositoryReport) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        buffer.append("\n");
        buffer.append("\t<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/></head>");
        buffer.append("\n");
        buffer.append("\t<link rel=\"stylesheet\" type=\"text/css\" href=\"./css/osddm_main.css\">");
        buffer.append("\n");
        buffer.append("\t<link rel=\"stylesheet\" type=\"text/css\" href=\"./css/osddm_vs.css\">");
        buffer.append("\n");
        buffer.append("\t<link rel=\"stylesheet\" type=\"text/css\" href=\"./css/osddm_toc_tree.css\">");
        buffer.append("\n");
        buffer.append("\n");
        buffer.append("\t").append("<script src=\"./js/toc_filter.js\"></script>");
        buffer.append("\n");
        buffer.append("\t<body>");
        buffer.append("\n");
        buffer.append("\t\t\t\t").append("<div class=\"t_item\">");
        buffer.append("\n");
        if (objects != null && objects.size() > 1) {
            buffer.append("\t\t<div id=\"toc_list\">");
            buffer.append("<table id=\"toc_table\" width=\"100%\" style=\"empty-cells:show; font-family:Tahoma; font-size:small; text-align:left; vertical-align:top; word-wrap:break-word;\">");
            buffer.append("\n");
            buffer.append("\n");
            buffer.append("<tr><td style=\"color:navy; font-family:Tahoma; font-size:small; font-style:italic; font-weight:bold;\"><input type=\"text\" style=\"width: 180px; margin-top: 5px;\" onkeyup=\"$d_Find('toc_list',this.value,'a')\"/></td></tr>");
            buffer.append("\n");
            buffer.append("<tr><td>&nbsp;</td></tr>");
            buffer.append("\n");
            buffer.append("</table>");
            if (settings.isGroupBySchemaNameInReports()) {
                Object o;
                List oList;
                ArrayList noSchemaObjects;
                HashMap schemasMap = new HashMap();
                schemasMap.put("NoSchemaObjects", new ArrayList());
                if (objects.get(0) instanceof String) {
                    for (final String objLongName : objects) {
                        if (objLongName.contains(".")) {
                            String schemaName = objLongName.substring(0, objLongName.indexOf(".") - 1);
                            List oList2 = (List)schemasMap.get(schemaName);
                            if (oList2 != null) {
                                oList2.add(objLongName);
                                continue;
                            }
                            schemasMap.put(schemaName, new ArrayList(){
                                {
                                    this.add(objLongName);
                                }
                            });
                            continue;
                        }
                        ((List)schemasMap.get("NoSchemaObjects")).add(objLongName);
                    }
                    if (schemasMap.size() > 0) {
                        buffer.append("\t\t\t\t<div>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t<ol class=\"tree\">");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t\t<li>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t\t\t<label for=\"objects\">Objects</label>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t\t\t<input type=\"checkbox\" id=\"objects\"/>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t\t\t<ol>");
                        noSchemaObjects = new ArrayList();
                        for (Map.Entry pair : schemasMap.entrySet()) {
                            oList = (List)pair.getValue();
                            o = pair.getKey();
                            if (!o.equals("NoSchemaObjects")) {
                                String schemaName = (String)o;
                                buffer.append("\n");
                                buffer.append("\t\t\t\t\t\t\t\t<li>");
                                buffer.append("\n");
                                buffer.append("\t\t\t\t\t\t\t\t<label for=\"" + schemaName + "\">" + schemaName + "</label>");
                                buffer.append("\n");
                                buffer.append("\t\t\t\t\t\t\t\t<input type=\"checkbox\" id=\"" + schemaName + "\"/>");
                                buffer.append("\n");
                                buffer.append("\t\t\t\t\t\t\t\t<ol>");
                                for (String objLongName : oList) {
                                    String objectName = objLongName.substring(objLongName.indexOf(".") + 1, objLongName.length());
                                    buffer.append("\n");
                                    buffer.append("\t\t\t\t\t\t\t\t\t<li class=\"obj\"><a href=\"" + reportFileName + "#" + objLongName + "\" target=\"details\">" + objectName + "</a></li>");
                                }
                                buffer.append("\n");
                                buffer.append("\t\t\t\t\t\t\t\t</ol>");
                                buffer.append("\n");
                                buffer.append("\t\t\t\t\t\t\t\t</li>");
                                continue;
                            }
                            noSchemaObjects.addAll(oList);
                        }
                        for (String objName : noSchemaObjects) {
                            buffer.append("\n");
                            buffer.append("\t\t\t\t\t\t\t\t<li class=\"obj\"><a href=\"" + reportFileName + "#" + objName + "\" target=\"details\">" + objName + "</a></li>");
                        }
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t\t\t</ol>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t\t</li>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t</ol>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t</div>");
                        buffer.append("\n");
                    } else {
                        for (Object obj : objects) {
                            buffer.append("\n");
                            buffer.append("\t\t\t\t").append("<div><a href=\"" + reportFileName + "#" + (String)obj + "\" target=\"details\">" + (String)obj + "</a></div>");
                        }
                    }
                } else {
                    for (DesignObject dObj : objects) {
                        if (dObj instanceof Table || dObj instanceof TableView) {
                            final ContainerObject co = (ContainerObject)dObj;
                            SchemaObject so = co.getSchemaObject();
                            if (so != null) {
                                oList = (List)schemasMap.get(so);
                                if (oList != null) {
                                    oList.add(co);
                                    continue;
                                }
                                schemasMap.put(so, new ArrayList(){
                                    {
                                        this.add(co);
                                    }
                                });
                                continue;
                            }
                            ((List)schemasMap.get("NoSchemaObjects")).add(co);
                            continue;
                        }
                        ((List)schemasMap.get("NoSchemaObjects")).add(dObj);
                    }
                    if (schemasMap.size() > 0) {
                        buffer.append("\t\t\t\t<div>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t<ol class=\"tree\">");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t\t<li>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t\t\t<label for=\"objects\">Objects</label>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t\t\t<input type=\"checkbox\" id=\"objects\"/>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t\t\t<ol>");
                        noSchemaObjects = new ArrayList();
                        for (Map.Entry pair : schemasMap.entrySet()) {
                            oList = (List)pair.getValue();
                            o = pair.getKey();
                            if (o instanceof SchemaObject) {
                                SchemaObject so = (SchemaObject)o;
                                String schemaName = so.getName();
                                buffer.append("\n");
                                buffer.append("\t\t\t\t\t\t\t\t<li>");
                                buffer.append("\n");
                                buffer.append("\t\t\t\t\t\t\t\t<label for=\"" + schemaName + "\">" + schemaName + "</label>");
                                buffer.append("\n");
                                buffer.append("\t\t\t\t\t\t\t\t<input type=\"checkbox\" id=\"" + schemaName + "\"/>");
                                buffer.append("\n");
                                buffer.append("\t\t\t\t\t\t\t\t<ol>");
                                for (ContainerObject co : oList) {
                                    buffer.append("\n");
                                    buffer.append("\t\t\t\t\t\t\t\t\t<li class=\"obj\"><a href=\"" + reportFileName + "#" + co.getLongName() + "\" target=\"details\">" + co.getName() + "</a></li>");
                                }
                                buffer.append("\n");
                                buffer.append("\t\t\t\t\t\t\t\t</ol>");
                                buffer.append("\n");
                                buffer.append("\t\t\t\t\t\t\t\t</li>");
                                continue;
                            }
                            noSchemaObjects.addAll(oList);
                        }
                        for (DesignObject dObj : noSchemaObjects) {
                            buffer.append("\n");
                            buffer.append("\t\t\t\t\t\t\t\t<li class=\"obj\"><a href=\"" + reportFileName + "#" + dObj.getLongName() + "\" target=\"details\">" + dObj.getName() + "</a></li>");
                        }
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t\t\t</ol>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t\t</li>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t</ol>");
                        buffer.append("\n");
                        buffer.append("\t\t\t\t</div>");
                        buffer.append("\n");
                    } else {
                        for (Object obj : objects) {
                            buffer.append("\n");
                            buffer.append("\t\t\t\t").append("<div><a href=\"" + reportFileName + "#" + ((ModelObject)obj).getLongName() + "\" target=\"details\">" + ((ModelObject)obj).getLongName() + "</a></div>");
                        }
                    }
                }
            } else {
                if (settings.isEmbedDiagramsInReports() && diagramsNamesList.size() > 0) {
                    buffer.append("\t\t\t\t<div>");
                    buffer.append("\n");
                    buffer.append("\t\t\t\t\t<ol class=\"tree\">");
                    buffer.append("\n");
                    buffer.append("\t\t\t\t\t\t<li>");
                    buffer.append("\n");
                    buffer.append("\t\t\t\t\t\t\t<label for=\"objects\">Objects</label>");
                    buffer.append("\n");
                    buffer.append("\t\t\t\t\t\t\t<input type=\"checkbox\" id=\"objects\"/>");
                    buffer.append("\n");
                    buffer.append("\t\t\t\t\t\t\t<ol>");
                }
                if (objects.get(0) instanceof String) {
                    for (String objName : objects) {
                        buffer.append("\n");
                        buffer.append("\t\t\t\t\t\t\t\t<li class=\"obj\"><a href=\"" + reportFileName + "#" + objName + "\" target=\"details\">" + objName + "</a></li>");
                    }
                } else {
                    for (ModelIDObject obj : objects) {
                        buffer.append("\n");
                        buffer.append("\t\t\t\t").append("<div><a href=\"" + reportFileName + "#" + obj.getLongName() + "\" target=\"details\">" + obj.getLongName() + "</a></div>");
                    }
                }
                if (settings.isEmbedDiagramsInReports() && diagramsNamesList.size() > 0) {
                    buffer.append("\n");
                    buffer.append("\t\t\t\t\t\t\t</ol>");
                    buffer.append("\n");
                    buffer.append("\t\t\t\t\t\t</li>");
                    buffer.append("\n");
                    buffer.append("\t\t\t\t\t</ol>");
                    buffer.append("\n");
                    buffer.append("\t\t\t\t</div>");
                    buffer.append("\n");
                }
            }
            if (settings.isEmbedDiagramsInReports() && diagramsNamesList.size() > 0) {
                buffer.append("\n");
                buffer.append("\t\t\t\t<div>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t<ol class=\"tree\">");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t<li>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t\t<label for=\"diagrams\">Diagrams</label>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t\t<input type=\"checkbox\" id=\"diagrams\"/>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t\t<ol>");
                for (String diagramName : diagramsNamesList) {
                    if (isRepositoryReport) {
                        diagramName = diagramName.substring(diagramName.indexOf("/") + 1, diagramName.lastIndexOf("."));
                    }
                    buffer.append("\n");
                    buffer.append("\t\t\t\t\t\t\t\t<li class=\"obj\"><a href=\"" + reportFileName + "#" + diagramName + "\" target=\"details\">" + diagramName + "</a></li>");
                }
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t\t</ol>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t</li>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t</ol>");
                buffer.append("\n");
                buffer.append("\t\t\t\t</div>");
                buffer.append("\n");
            }
        }
        buffer.append("\t\t\t\t").append("</div>");
        buffer.append("\t\t</div");
        buffer.append("\n");
        buffer.append("\t</body>");
        buffer.append("</html>");
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editHTMLDataPage(File htmlFile, String SVGDiagrams, List diagramsNamesList, Settings settings, boolean isRepositoryReport) {
        if (settings.isEmbedDiagramsInReports()) {
            StringBuffer buffer = new StringBuffer();
            StringBuffer originalHTMLFile = HTMLReportSeparateFiles.getHTMLContents(htmlFile, settings, diagramsNamesList, isRepositoryReport);
            StringBuffer tempBuffer2 = new StringBuffer(originalHTMLFile.substring(0, originalHTMLFile.indexOf("</body>")));
            buffer.append(tempBuffer2);
            buffer.append("\n");
            if (SVGDiagrams != null && SVGDiagrams != null && !SVGDiagrams.isEmpty()) {
                buffer.append(SVGDiagrams);
                buffer.append("\n");
            }
            if (isRepositoryReport) {
                for (String diagramName : diagramsNamesList) {
                    buffer.append("\n");
                    String dName = diagramName.substring(diagramName.indexOf("/") + 1, diagramName.lastIndexOf("."));
                    buffer.append("<p><a name=" + dName + ">" + dName + "</a></p>");
                    buffer.append("\n");
                    buffer.append("<object data=\"" + diagramName + "\" type=\"application/pdf\" width=\"900\" height=\"500\">");
                    buffer.append("alt : <a href=\"" + diagramName + "\">test.pdf</a>");
                    buffer.append("</object>");
                }
            }
            buffer.append("</body>");
            buffer.append("\n");
            buffer.append("</html>");
            OutputStreamWriter osw = null;
            try {
                FileOutputStream fos = new FileOutputStream(htmlFile);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                osw.write(buffer.toString());
                osw.close();
            }
            catch (Exception e) {
                LOGGER.error("HTMLReportSeparateFiles. Unable to write to file: ", e);
            }
            finally {
                if (osw != null) {
                    try {
                        osw.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("HTMLReportSeparateFiles. Unable to write to file: ", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuffer getHTMLContents(File htmlFile, Settings settings, List diagramsNamesList, boolean isRepositoryReport) {
        if (htmlFile != null) {
            StringBuffer contents = new StringBuffer((int)htmlFile.length());
            try (Scanner sc = null;){
                sc = new Scanner(htmlFile, "UTF-8");
                String lineSeparator = System.getProperty("line.separator");
                while (sc.hasNextLine()) {
                    if (isRepositoryReport && settings.isEmbedDiagramsInReports()) {
                        String line = sc.nextLine().toString();
                        if (diagramsNamesList.size() > 0) {
                            for (String diagramName : diagramsNamesList) {
                                String dName = diagramName.substring(diagramName.indexOf("/") + 1, diagramName.lastIndexOf("."));
                                line = line.replaceAll(diagramName, htmlFile.getName() + "#" + dName);
                            }
                        }
                        contents.append(line + lineSeparator);
                        continue;
                    }
                    contents.append(sc.nextLine() + lineSeparator);
                }
                sc.close();
                StringBuffer stringBuffer = contents;
                return stringBuffer;
            }
        }
        return new StringBuffer();
    }
}

