/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.exports.reports.GlossaryHandler;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.wizards.metadata.ColorTableCellRenderer;
import oracle.dbtools.crest.swingui.wizards.metadata.DMConnectionModel;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.FCPConnectionDialog;
import oracle.dbtools.crest.swingui.wizards.reports.DeleteDesignsDialog;
import oracle.dbtools.crest.swingui.wizards.reports.DeleteGlossaryDialog;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class ExportReportsDialog
extends CustomDialog
implements AbstractEditorConstants {
    private JDialog dialog;
    private JPanel buttonPanel;
    private JTextArea taComments;
    private boolean result = false;
    private JTable tbConnections;
    private JButton bnOK;
    private JButton bnTest;
    private JButton bnProps;
    private JButton bnRemove;
    private JButton bnImport;
    private Connection connection = null;
    private JCheckBox chbExportDiagramsAsPDF;
    private JCheckBox chbClearDiagrams;
    private JButton bnDrop;
    private JButton bnDeleteDesigns;
    private JButton bnExportGlossary;
    private JButton bnDeleteGlossary;
    private JButton bnEnableIndexes;
    private JButton bnDisableIndexes;
    private static File lastFolder = null;
    private static final Logger LOGGER = new Logger(ExportReportsDialog.class);

    public ExportReportsDialog(ApplicationView appView) {
        super(appView);
        this.add((Component)this.getGeneralPanel(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    protected JPanel getGeneralPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.tbConnections = new JTable(new DMConnectionModel(DatabaseConnections.getInstance(), true));
        this.tbConnections.setSelectionMode(0);
        this.tbConnections.setDefaultRenderer(Object.class, new ColorTableCellRenderer());
        this.tbConnections.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ExportReportsDialog.this.showConnectionProperties();
                } else {
                    boolean enabled = ExportReportsDialog.this.tbConnections.getSelectedRow() > -1;
                    ExportReportsDialog.this.bnOK.setEnabled(enabled);
                    ExportReportsDialog.this.bnTest.setEnabled(enabled);
                    ExportReportsDialog.this.bnProps.setEnabled(enabled);
                    ExportReportsDialog.this.bnRemove.setEnabled(enabled);
                    ExportReportsDialog.this.bnDrop.setEnabled(enabled);
                    ExportReportsDialog.this.bnDeleteDesigns.setEnabled(enabled);
                    ExportReportsDialog.this.bnExportGlossary.setEnabled(enabled);
                    ExportReportsDialog.this.bnDeleteGlossary.setEnabled(enabled);
                    ExportReportsDialog.this.bnEnableIndexes.setEnabled(enabled);
                    ExportReportsDialog.this.bnDisableIndexes.setEnabled(enabled);
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.tbConnections);
        sp.setPreferredSize(new Dimension(400, 180));
        jpanel.add((Component)sp, "Center");
        JPanel pnConnections = new JPanel(new BorderLayout());
        pnConnections.add((Component)new JLabel(Messages.getString("ExportReportsDialog.Connections")), "North");
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(200, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.bnProps = new JButton(configuration.getIcon("EDIT_ICON", 16));
        this.bnProps.setToolTipText(Messages.getString("ExportReportsDialog.ConnectionProperties"));
        this.bnProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportReportsDialog.this.showConnectionProperties();
            }
        });
        this.bnProps.setEnabled(false);
        JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", 16));
        btnAdd.setToolTipText(Messages.getString("ExportReportsDialog.AddConnection"));
        btnAdd.addActionListener(new AddAction());
        this.bnRemove = new JButton(configuration.getIcon("REMOVE_ICON", 16));
        this.bnRemove.setToolTipText(Messages.getString("ExportReportsDialog.RemvoeConnection"));
        this.bnRemove.addActionListener(new RemoveAction());
        this.bnRemove.setEnabled(false);
        this.bnImport = new JButton(configuration.getIcon("DB_CONNECT_ICON", 16));
        this.bnImport.setToolTipText(Messages.getString("ExportReportsDialog.ImportSQLDeveloperConn"));
        this.bnImport.setMnemonic(73);
        this.bnImport.addActionListener(new ImportAction());
        this.bnTest = new JButton(configuration.getIcon("DESIGN_RULES_ICON", 16));
        this.bnTest.setToolTipText(Messages.getString("ExportReportsDialog.TestConnection"));
        this.bnTest.addActionListener(new TestAction());
        this.bnTest.setEnabled(false);
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(this.bnProps);
        toolBar.addSeparator();
        toolBar.add(btnAdd);
        toolBar.add(this.bnRemove);
        toolBar.addSeparator();
        toolBar.add(this.bnImport);
        toolBar.addSeparator();
        toolBar.add(this.bnTest);
        buttonGeneral.add(toolBar);
        pnConnections.add((Component)buttonGeneral, "Center");
        jpanel.add((Component)pnConnections, "North");
        JPanel pnComments = new JPanel(new BorderLayout());
        pnComments.add((Component)new JLabel(Messages.getString("ExportReportsDialog.Comments")), "North");
        this.taComments = new JTextArea();
        JScrollPane spComments = new JScrollPane(this.taComments);
        spComments.setPreferredSize(new Dimension(400, 100));
        pnComments.add((Component)spComments, "Center");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setPreferredSize(new Dimension(420, 110));
        JPanel pnOptions = new JPanel(new SpringLayout());
        this.chbExportDiagramsAsPDF = new JCheckBox(Messages.getString("ExportReportsDialog.ExsportDiagramsAsPDF"));
        this.chbExportDiagramsAsPDF.setMnemonic(80);
        CommonUtil.setObjectConstraints((SpringLayout)pnOptions.getLayout(), this.chbExportDiagramsAsPDF, 10, 5);
        pnOptions.add(this.chbExportDiagramsAsPDF);
        this.chbClearDiagrams = new JCheckBox(Messages.getString("ReportsGenerationDialog.ClearDiagrams"));
        this.chbClearDiagrams.setToolTipText(Messages.getString("ExportReportsDialog.ClearDiagramsForDesign"));
        this.chbClearDiagrams.setMnemonic(67);
        CommonUtil.setObjectConstraints((SpringLayout)pnOptions.getLayout(), this.chbClearDiagrams, 10, 33);
        pnOptions.add(this.chbClearDiagrams);
        tabbedPane.add(Messages.getString("ExportReportsDialog.Options"), pnOptions);
        JPanel pnMaintenance = new JPanel(new SpringLayout());
        tabbedPane.add(Messages.getString("ExportReportsDialog.Maintenance"), pnMaintenance);
        this.bnDrop = new JButton(Messages.getString("ExportReportsDialog.DropRepository"));
        this.bnDrop.setMnemonic(82);
        this.bnDrop.addActionListener(new DropAction());
        this.bnDrop.setEnabled(false);
        this.bnDrop.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        pnMaintenance.add(this.bnDrop);
        CommonUtil.setObjectConstraints((SpringLayout)pnMaintenance.getLayout(), this.bnDrop, 10, 5);
        this.bnDeleteDesigns = new JButton(Messages.getString("ExportReportsDialog.DeleteDesigns"));
        this.bnDeleteDesigns.setMnemonic(69);
        this.bnDeleteDesigns.addActionListener(new DeleteDesignsAction());
        this.bnDeleteDesigns.setEnabled(false);
        this.bnDeleteDesigns.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        pnMaintenance.add(this.bnDeleteDesigns);
        CommonUtil.setObjectConstraints((SpringLayout)pnMaintenance.getLayout(), this.bnDeleteDesigns, 210, 5);
        this.bnEnableIndexes = new JButton(Messages.getString("ExportReportsDialog.EnableIndexes"));
        this.bnEnableIndexes.setMnemonic(73);
        this.bnEnableIndexes.addActionListener(new EnableIndexesAction());
        this.bnEnableIndexes.setEnabled(false);
        this.bnEnableIndexes.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        pnMaintenance.add(this.bnEnableIndexes);
        CommonUtil.setObjectConstraints((SpringLayout)pnMaintenance.getLayout(), this.bnEnableIndexes, 10, 33);
        this.bnDisableIndexes = new JButton(Messages.getString("ExportReportsDialog.DisableIndexes"));
        this.bnDisableIndexes.setMnemonic(88);
        this.bnDisableIndexes.addActionListener(new DisableIndexesAction());
        this.bnDisableIndexes.setEnabled(false);
        this.bnDisableIndexes.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        pnMaintenance.add(this.bnDisableIndexes);
        CommonUtil.setObjectConstraints((SpringLayout)pnMaintenance.getLayout(), this.bnDisableIndexes, 210, 33);
        JPanel pnGlossary = new JPanel();
        tabbedPane.add(Messages.getString("ExportReportsDialog.Glossary"), pnGlossary);
        this.bnExportGlossary = new JButton(Messages.getString("ExportReportsDialog.ExportGlossary"));
        this.bnExportGlossary.setMnemonic(88);
        this.bnExportGlossary.addActionListener(new ExportGlossaryAction());
        this.bnExportGlossary.setEnabled(false);
        this.bnExportGlossary.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        pnGlossary.add(this.bnExportGlossary);
        pnGlossary.add(new JPanel());
        this.bnDeleteGlossary = new JButton(Messages.getString("ExportReportsDialog.DeleteGlossary"));
        this.bnDeleteGlossary.setMnemonic(76);
        this.bnDeleteGlossary.addActionListener(new DeleteGlossaryAction());
        this.bnDeleteGlossary.setEnabled(false);
        this.bnDeleteGlossary.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        pnGlossary.add(this.bnDeleteGlossary);
        pnComments.add((Component)tabbedPane, "South");
        jpanel.add((Component)pnComments, "South");
        this.updateConnections();
        return jpanel;
    }

    private Properties getSelectedConnectionProperties() {
        Properties cd = null;
        try {
            cd = ((DMConnectionModel)this.tbConnections.getModel()).getRowData(this.tbConnections.getSelectedRow());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cd;
    }

    private void showConnectionProperties() {
        Properties cd = this.getSelectedConnectionProperties();
        if (cd != null) {
            String connName = ConnectionInfo.getConnectionName(cd);
            FCPConnectionDialog.showConnectionDialog(connName, true);
            this.updateConnections();
        }
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (Exception e) {
                LOGGER.error("Unable to close the connection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initConnection() {
        block5: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.closeConnection();
                Properties cd = this.getSelectedConnectionProperties();
                if (cd == null) break block5;
                try {
                    this.connection = DatabaseConnections.getInstance().getConnection(cd);
                }
                catch (Exception e) {
                    MessageDialogs.showErrorMessage(e.getLocalizedMessage());
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return this.connection != null;
    }

    private void updateConnections() {
        ((DMConnectionModel)this.tbConnections.getModel()).reReadConnections();
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            this.bnOK = new JButton(Messages.getString("ExportReportsDialog.OK"));
            this.bnOK.setMnemonic(79);
            this.bnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportReportsDialog.this.result = false;
                    if (ExportReportsDialog.this.initConnection()) {
                        ExportReportsDialog.this.result = true;
                    }
                    if (ExportReportsDialog.this.connection != null) {
                        String user = ConnectionInfo.getConnectionUserName(ExportReportsDialog.this.getSelectedConnectionProperties());
                        if ("sys".equalsIgnoreCase(user) || "system".equalsIgnoreCase(user)) {
                            MessageDialogs.showErrorMessage(Messages.getString("ExportReportsDialog.ExportingToSystemNotSuporrted"));
                        } else {
                            ExportReportsDialog.this.close();
                        }
                    }
                }
            });
            this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.bnOK.setEnabled(false);
            this.buttonPanel.add(this.bnOK);
            JButton cancel = new JButton(Messages.getString("ExportReportsDialog.Close"));
            cancel.setMnemonic(67);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportReportsDialog.this.result = false;
                    ExportReportsDialog.this.close();
                }
            });
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            JButton btnHelp = new JButton(this.getHelpAction());
            btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            btnHelp.setMnemonic(72);
            this.buttonPanel.add(cancel);
            this.buttonPanel.add(btnHelp);
        }
        return this.buttonPanel;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ExportReportsDialog.ExportToReportingSchema"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    @Override
    protected String getHelpIndex() {
        return "EXPORT_TO_REPORTING_SCHEMA_DIALOG";
    }

    public String getComments() {
        String comments = this.taComments.getText();
        if (comments == null) {
            comments = "";
        }
        return comments;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean exportDiagramsAsPDF() {
        return this.chbExportDiagramsAsPDF.isSelected();
    }

    public boolean clearDiagrams() {
        return this.chbClearDiagrams.isSelected();
    }

    private class DisableIndexesAction
    implements ActionListener {
        private DisableIndexesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ExportReportsDialog.this.getSelectedConnectionProperties() != null && ExportReportsDialog.this.initConnection()) {
                try {
                    if (ExportReportsDialog.this.initConnection()) {
                        ExportReportsDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                        SchemaFactory.disableIndexes(ExportReportsDialog.this.connection);
                    }
                }
                finally {
                    ExportReportsDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    private class EnableIndexesAction
    implements ActionListener {
        private EnableIndexesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ExportReportsDialog.this.getSelectedConnectionProperties() != null && ExportReportsDialog.this.initConnection()) {
                try {
                    if (ExportReportsDialog.this.initConnection()) {
                        ExportReportsDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                        SchemaFactory.enableIndexes(ExportReportsDialog.this.connection);
                    }
                }
                finally {
                    ExportReportsDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    private class TestAction
    implements ActionListener {
        private TestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FCPConnectionDialog.testConnection(ExportReportsDialog.this.getSelectedConnectionProperties());
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Properties cd = ExportReportsDialog.this.getSelectedConnectionProperties();
            if (cd != null) {
                try {
                    String connName = ConnectionInfo.getConnectionName(cd);
                    int result = JOptionPane.showConfirmDialog(ExportReportsDialog.this, MessageFormat.format(Messages.getString("ExportReportsDialog.SureToDelete"), connName), Messages.getString("ExportReportsDialog.SelectOption"), 0);
                    if (result == 0) {
                        DatabaseConnections.getInstance().removeConnection(connName);
                        ExportReportsDialog.this.updateConnections();
                        ExportReportsDialog.this.tbConnections.clearSelection();
                        ExportReportsDialog.this.bnOK.setEnabled(false);
                        ExportReportsDialog.this.bnTest.setEnabled(false);
                        ExportReportsDialog.this.bnProps.setEnabled(false);
                        ExportReportsDialog.this.bnRemove.setEnabled(false);
                        ExportReportsDialog.this.bnDrop.setEnabled(false);
                        ExportReportsDialog.this.bnDeleteDesigns.setEnabled(false);
                        ExportReportsDialog.this.bnExportGlossary.setEnabled(false);
                        ExportReportsDialog.this.bnDeleteGlossary.setEnabled(false);
                        ExportReportsDialog.this.bnEnableIndexes.setEnabled(false);
                        ExportReportsDialog.this.bnDisableIndexes.setEnabled(false);
                    }
                }
                catch (ConnectionException e1) {
                    LOGGER.error("Unable to delete connection", e1);
                    MessageDialogs.showMessage(ApplicationView.frame, "Unable to delete connection");
                }
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FCPConnectionDialog.showConnectionDialog(true);
                ExportReportsDialog.this.updateConnections();
            }
            catch (Exception e1) {
                LOGGER.error(e1);
            }
        }
    }

    private class ImportAction
    implements ActionListener {
        private ImportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FCPConnectionDialog.importConnections();
            ExportReportsDialog.this.updateConnections();
        }
    }

    private class DeleteGlossaryAction
    implements ActionListener {
        private DeleteGlossaryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ExportReportsDialog.this.getSelectedConnectionProperties() != null && ExportReportsDialog.this.initConnection()) {
                DeleteGlossaryDialog.showDialog(ExportReportsDialog.this.getApplicationView().getFrame(), ExportReportsDialog.this.connection);
            }
        }
    }

    private class ExportGlossaryAction
    implements ActionListener {
        private ExportGlossaryAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (ExportReportsDialog.this.getSelectedConnectionProperties() != null) {
                Glossary glossary;
                block16: {
                    glossary = null;
                    try {
                        File file;
                        URLFilter ddlFilter = new URLFilter(){

                            public boolean accept(URL url) {
                                File file = new File(url.getPath());
                                return file.getName().toLowerCase().endsWith(".glossary") || file.isDirectory();
                            }

                            public String toString() {
                                return Messages.getString("GlossaryDialog.CWDGlossaryFiles");
                            }
                        };
                        URLFileChooser fileChooser = new URLFileChooser();
                        fileChooser.clearChooseableURLFilters();
                        fileChooser.setSelectionScope(0);
                        fileChooser.setSelectionMode(0);
                        fileChooser.setShowJarsAsDirs(false);
                        fileChooser.setURLFilter(ddlFilter);
                        fileChooser.setPathContext("dataModeler_OpenDesign");
                        if (lastFolder != null) {
                            fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
                        } else {
                            String lastDir = ExportReportsDialog.this.getApplicationView().getSettings().getDefaultReportsPath();
                            if (lastDir != null && lastDir.length() > 0) {
                                fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                            } else {
                                URL url = ExportReportsDialog.this.getApplicationView().getUserHomeDirectory();
                                if (url != null) {
                                    fileChooser.setSelectedURL(url);
                                }
                            }
                        }
                        int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("GlossaryDialog.InputFile"));
                        if (status != 0 || (file = new File(fileChooser.getSelectedURL().getPath())) == null) break block16;
                        lastFolder = file.getParentFile();
                        try {
                            String fname = file.getName().toLowerCase();
                            if (!fname.endsWith(".glossary")) {
                                file = fname.endsWith(".") ? new File(file.getPath() + "glossary") : new File(file.getPath() + ".glossary");
                            }
                            if (!(glossary = new Glossary(file)).isLoaded()) {
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{MessageFormat.format(Messages.getString("GlossaryDialog.InputFileError"), file)}, Messages.getString("GlossaryDialog.Error"), 0);
                            }
                        }
                        finally {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                    catch (Exception error) {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("GlossaryDialog.UnexpectedError"), error.getMessage()}, Messages.getString("GlossaryDialog.Error"), 0);
                    }
                }
                if (glossary != null && glossary.isLoaded()) {
                    int result;
                    if (glossary.isDirty() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("GlossaryDialog.Modified"), glossary.getName()), Messages.getString("GlossaryDialog.Warning"), 0, 3, ExportReportsDialog.this.getConfiguration().getIcon("SAVE_ICON", 32))) == 0) {
                        glossary.save();
                        glossary.clearDirtyFlag();
                    }
                    if (ExportReportsDialog.this.initConnection()) {
                        GlossaryHandler handler = new GlossaryHandler(ExportReportsDialog.this.getApplicationView(), ExportReportsDialog.this.connection, ExportReportsDialog.this.getComments(), glossary);
                        handler.export();
                    }
                }
            }
        }
    }

    private class DeleteDesignsAction
    implements ActionListener {
        private DeleteDesignsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ExportReportsDialog.this.getSelectedConnectionProperties() != null && ExportReportsDialog.this.initConnection()) {
                DeleteDesignsDialog.showDialog(ExportReportsDialog.this.getApplicationView().getFrame(), ExportReportsDialog.this.connection);
            }
        }
    }

    private class DropAction
    implements ActionListener {
        private DropAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int result;
            if (ExportReportsDialog.this.getSelectedConnectionProperties() != null && (result = JOptionPane.showConfirmDialog(ExportReportsDialog.this, Messages.getString("ExportReportsDialog.SureToDropRepository"), Messages.getString("ExportReportsDialog.SelectAnOpiton"), 0)) == 0) {
                try {
                    if (ExportReportsDialog.this.initConnection()) {
                        ExportReportsDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                        SchemaFactory.dropRepository(ExportReportsDialog.this.connection);
                    }
                }
                finally {
                    ExportReportsDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }
}

