/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSynonymOracle;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;
import oracle.dbtools.crest.swingui.wizards.metadata.oracle.ImportDBOptionsOracle;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class AbstractDBMExtractionWizardImpl {
    public static final String DATABASE = "DATABASE";
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    public static final String LOGIN = "LOGIN";
    public static final String USER = "USER";
    public static final String ROLE = "ROLE";
    public static final String RULE = "RULE";
    public static final String DEFAULT = "DEFAULT";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String TRIGGER = "TRIGGER";
    public static final String DATATYPE = "DATATYPE";
    public static final String ALIAS = "ALIAS";
    public static final String BUFFERPOOL = "BUFFERPOOL";
    public static final String NODEGROUP = "NODEGROUP";
    public static final String OWNER = "OWNER";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String USERGROUP = "USERGROUP";
    public static final String TABLESPACE = "TABLESPACE";
    public static final String AUX_TABLE = "AUX TABLE";
    public static final String STORAGE_GROUP = "STORAGE GROUP";
    public static final String VCAT = "VCAT";
    public static final String VOLUME = "VOLUME";
    protected JTabbedPane tpane;
    protected JTable tbSchemas;
    protected List lsSchemas;
    protected JTextField secondTabFilterText = new JTextField();
    protected JTextField thirdTabFilterText = new JTextField();
    protected JTable tbTables;
    protected JTable tbViews;
    protected List lsTables = new ArrayList();
    protected List lsViews = new ArrayList();
    protected DBMExtractionWizard wizard;
    public JCheckBox chAllSelected;
    private RelationalDesign relationalDesign;
    private RDBMSSite rdbmsSite;
    private final Map filterMap = new HashMap();
    protected static final Logger LOGGER = new Logger(AbstractDBMExtractionWizardImpl.class);

    public AbstractDBMExtractionWizardImpl(DBMExtractionWizard wizard) {
        this.wizard = wizard;
    }

    protected abstract List getCurrentList();

    protected abstract void addTabs();

    protected abstract void updateTables();

    public abstract List getSelectedObjects();

    protected abstract void clearAll();

    protected abstract void initSpecificObjects(List var1);

    public void setSelected(DBObject dbObj, boolean selected) {
        if (dbObj != null) {
            dbObj.setSelected(selected);
        }
    }

    protected List getObjectsByType(List dbObjects, String type) {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dbo : dbObjects) {
            if (!dbo.getType().equalsIgnoreCase(type)) continue;
            list.add(dbo);
        }
        return list;
    }

    protected JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane(3);
        }
        return this.tpane;
    }

    protected JTable getCurrentTable() {
        Component comp = this.getTabbedPane().getSelectedComponent();
        if (comp != null && comp instanceof JPanel) {
            JPanel p = (JPanel)comp;
            for (int i = 0; i < p.getComponentCount(); ++i) {
                if (!(p.getComponent(i) instanceof JScrollPane)) continue;
                comp = p.getComponent(i);
                break;
            }
        }
        if (comp != null && comp instanceof JScrollPane) {
            JScrollPane sp = (JScrollPane)comp;
            int count = sp.getComponentCount();
            for (int i = 0; i < count; ++i) {
                JViewport jvp;
                Component table;
                Component vp = sp.getComponent(i);
                if (!(vp instanceof JViewport) || !((table = (jvp = (JViewport)vp).getComponent(0)) instanceof JTable)) continue;
                return (JTable)table;
            }
        }
        return null;
    }

    public List getTables() {
        ArrayList<Component> list = new ArrayList<Component>();
        int k = this.getTabbedPane().getComponentCount();
        for (int j = 0; j < k; ++j) {
            Component comp = this.getTabbedPane().getComponent(j);
            if (comp == null || !(comp instanceof JScrollPane)) continue;
            JScrollPane sp = (JScrollPane)comp;
            int count = sp.getComponentCount();
            for (int i = 0; i < count; ++i) {
                JViewport jvp;
                Component table;
                Component vp = sp.getComponent(i);
                if (!(vp instanceof JViewport) || !((table = (jvp = (JViewport)vp).getComponent(0)) instanceof JTable)) continue;
                list.add(table);
            }
        }
        return list;
    }

    public JPanel getSecondTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.lsSchemas = new ArrayList();
        this.tbSchemas = new JTable(new SchemasModel());
        this.tbSchemas.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.tbSchemas);
        TableColumn column = this.tbSchemas.getColumnModel().getColumn(1);
        column.setPreferredWidth(300);
        JScrollPane sp = new JScrollPane(this.tbSchemas);
        jpanel.add((Component)sp, "Center");
        JPanel pn1 = new JPanel(new FlowLayout(0));
        JButton bnSelectAll = AbstractDBMExtractionWizardImpl.createSelectAllButton();
        bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBMExtractionWizardImpl.this.checkAll(AbstractDBMExtractionWizardImpl.this.tbSchemas, AbstractDBMExtractionWizardImpl.this.lsSchemas, true);
            }
        });
        JButton bnDeselectAll = AbstractDBMExtractionWizardImpl.createDeselectAllButton();
        bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBMExtractionWizardImpl.this.checkAll(AbstractDBMExtractionWizardImpl.this.tbSchemas, AbstractDBMExtractionWizardImpl.this.lsSchemas, false);
            }
        });
        pn1.add(this.createFilterPanel(this.secondTabFilterText, this.tbSchemas, bnSelectAll, bnDeselectAll));
        this.chAllSelected = new JCheckBox(Messages.getString("AbstractDBMExtractionWizardImpl.AllSelected"));
        this.chAllSelected.setSelected(AbstractDBMExtractionHandler.isAllSelected());
        this.chAllSelected.setToolTipText(Messages.getString("AbstractDBMExtractionWizardImpl.DefaultSelectionStatusOfListedObjects"));
        this.chAllSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBMExtractionHandler.setAllSelected(AbstractDBMExtractionWizardImpl.this.chAllSelected.isSelected());
            }
        });
        pn1.add(this.chAllSelected);
        if (this.wizard.getSelectedConnectionType() == 1) {
            JButton btnOptions = new JButton(Messages.getString("AbstractDBMExtractionWizardImpl.Options"));
            btnOptions.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            btnOptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean partitions = AbstractDBMExtractionWizardImpl.this.wizard.getController().isPartitions(AbstractDBMExtractionWizardImpl.this.wizard.getSelectedConnectionType());
                    boolean triggers = AbstractDBMExtractionWizardImpl.this.wizard.getController().isTriggers(AbstractDBMExtractionWizardImpl.this.wizard.getSelectedConnectionType());
                    boolean strucTypes = AbstractDBMExtractionWizardImpl.this.wizard.getController().isStructuredTypesScan(AbstractDBMExtractionWizardImpl.this.wizard.getSelectedConnectionType());
                    boolean spatial = AbstractDBMExtractionWizardImpl.this.wizard.getController().isSpatialProperties(AbstractDBMExtractionWizardImpl.this.wizard.getSelectedConnectionType());
                    boolean secondaryTables = AbstractDBMExtractionWizardImpl.this.wizard.getController().isSecondaryTables(AbstractDBMExtractionWizardImpl.this.wizard.getSelectedConnectionType());
                    AbstractDBMExtractionHandler handler = AbstractDBMExtractionWizardImpl.this.wizard.getController().getDBMExtractionHandler(AbstractDBMExtractionWizardImpl.this.wizard.getSelectedConnectionType());
                    ImportDBOptionsOracle idb = new ImportDBOptionsOracle(ApplicationView.getInstance(), partitions, triggers, strucTypes, spatial, secondaryTables, handler.getShowList());
                    idb.getDialog().setVisible(true);
                    if (idb.isOKPressed()) {
                        AbstractDBMExtractionWizardImpl.this.wizard.getController().setSecondaryTables(AbstractDBMExtractionWizardImpl.this.wizard.getSelectedConnectionType(), idb.isProcessSecondaryTables());
                        AbstractDBMExtractionWizardImpl.this.wizard.getController().setSpatialProperties(AbstractDBMExtractionWizardImpl.this.wizard.getSelectedConnectionType(), idb.isProcessSpatial());
                        AbstractDBMExtractionWizardImpl.this.wizard.getController().setPartitions(AbstractDBMExtractionWizardImpl.this.wizard.getSelectedConnectionType(), idb.isProcessPartitions());
                        AbstractDBMExtractionWizardImpl.this.wizard.getController().setTriggers(AbstractDBMExtractionWizardImpl.this.wizard.getSelectedConnectionType(), idb.isProcessTriggers());
                        AbstractDBMExtractionWizardImpl.this.wizard.getController().setStructuredTypesScan(AbstractDBMExtractionWizardImpl.this.wizard.getSelectedConnectionType(), idb.isProcessUsedStructuredTypes());
                        handler.setShowList(idb.getShowList());
                    }
                }
            });
            pn1.add(btnOptions);
        }
        jpanel.add((Component)pn1, "South");
        return jpanel;
    }

    public static JButton createSelectAllButton() {
        JButton bnSelectAll = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL"));
        bnSelectAll.setMnemonic(83);
        bnSelectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        bnSelectAll.setToolTipText(Messages.getString("AbstractDBMExtractionWizardImpl.SelectAll"));
        return bnSelectAll;
    }

    public static JButton createDeselectAllButton() {
        JButton bnDeselectAll = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL"));
        bnDeselectAll.setMnemonic(68);
        bnDeselectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        bnDeselectAll.setToolTipText(Messages.getString("AbstractDBMExtractionWizardImpl.DeselectAll"));
        return bnDeselectAll;
    }

    public JPanel getThirdTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.tpane = null;
        jpanel.add((Component)this.getTabbedPane(), "Center");
        this.getTabbedPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTable c = AbstractDBMExtractionWizardImpl.this.getCurrentTable();
                if (c != null) {
                    String txt = (String)AbstractDBMExtractionWizardImpl.this.filterMap.get(c);
                    if (txt == null) {
                        txt = "";
                    }
                    AbstractDBMExtractionWizardImpl.this.thirdTabFilterText.setText(txt);
                }
            }
        });
        this.addTabs();
        JButton bnSelectAll = AbstractDBMExtractionWizardImpl.createSelectAllButton();
        bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBMExtractionWizardImpl.this.checkAll(AbstractDBMExtractionWizardImpl.this.getCurrentTable(), AbstractDBMExtractionWizardImpl.this.getCurrentList(), true);
            }
        });
        JButton bnDeselectAll = AbstractDBMExtractionWizardImpl.createDeselectAllButton();
        bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBMExtractionWizardImpl.this.checkAll(AbstractDBMExtractionWizardImpl.this.getCurrentTable(), AbstractDBMExtractionWizardImpl.this.getCurrentList(), false);
            }
        });
        jpanel.add((Component)this.createFilterPanel(this.thirdTabFilterText, null, bnSelectAll, bnDeselectAll), "South");
        return jpanel;
    }

    private void selectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                DBObject dbo;
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size() || (dbo = (DBObject)list.get(index)).getStatus().equals(DBObject.NAME_EXIST)) continue;
                this.setSelected(dbo, true);
            }
        } else {
            for (DBObject dbo : list) {
                if (dbo.getStatus().equals(DBObject.NAME_EXIST)) continue;
                this.setSelected(dbo, true);
            }
        }
    }

    private void deselectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                DBObject dbo = (DBObject)list.get(index);
                this.setSelected(dbo, false);
            }
        } else {
            for (DBObject dbo : list) {
                this.setSelected(dbo, false);
            }
        }
    }

    protected JPanel createFilterPanel(final JTextField filterText, final JTable tableForFiltering, JButton bnSelectAll, JButton bnDeselectAll) {
        JLabel flabel = new JLabel(Messages.getString("AbstractDBMExtractionWizardImpl.Filter"));
        filterText.setPreferredSize(new Dimension(150, MessageDialogs.BUTTON_SIZE_EX.height));
        filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractDBMExtractionWizardImpl.this.newFilter(filterText, tableForFiltering);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractDBMExtractionWizardImpl.this.newFilter(filterText, tableForFiltering);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractDBMExtractionWizardImpl.this.newFilter(filterText, tableForFiltering);
            }
        });
        flabel.setLabelFor(filterText);
        JPanel pn1 = new JPanel(new FlowLayout(0));
        pn1.add(bnSelectAll);
        pn1.add(bnDeselectAll);
        pn1.add(new JPanel());
        pn1.add(flabel);
        pn1.add(filterText);
        return pn1;
    }

    private void newFilter(JTextField filterText, JTable currentTable) {
        RowFilter rf = null;
        if (currentTable == null) {
            currentTable = this.getCurrentTable();
        }
        if (currentTable != null) {
            String txt = filterText.getText();
            if (txt != null) {
                this.filterMap.put(currentTable, txt);
            } else {
                this.filterMap.remove(currentTable);
            }
            if (!"".equals(txt)) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), this.getFilterColumn(currentTable));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    protected int getFilterColumn(JTable table) {
        TableModel model = table.getModel();
        if (model instanceof ObjectModel) {
            return ((ObjectModel)model).getFilterColumn();
        }
        if (model instanceof SchemasModel) {
            return ((SchemasModel)model).getFilterColumn();
        }
        return table.getColumnModel().getColumn(1).getModelIndex();
    }

    public void clearSecondTabFilter() {
        this.clearFilter(this.secondTabFilterText);
    }

    public void clearThirdTabFilter() {
        this.clearFilter(this.thirdTabFilterText);
    }

    public void clearFilter(JTextField filterText) {
        if (filterText != null) {
            for (JTable table : this.getTables()) {
                if (table.getRowCount() != table.getModel().getRowCount()) {
                    if (!"".equals(filterText.getText())) {
                        filterText.setText("");
                    }
                    table.clearSelection();
                    ((DefaultRowSorter)table.getRowSorter()).setRowFilter(null);
                    continue;
                }
                if ("".equals(filterText.getText())) continue;
                filterText.setText("");
            }
        }
    }

    protected JTable addTab(JTable table, List list, String name) {
        return this.addTab(table, list, name, true);
    }

    protected JTable addTab(JTable table, List list, String name, boolean showTab) {
        table = new JTable(new ObjectModel(list));
        table.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(table);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(60);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(60);
        JScrollPane sp = new JScrollPane(table);
        if (showTab) {
            this.getTabbedPane().addTab(name, sp);
        }
        return table;
    }

    /*
     * Exception decompiling
     */
    protected boolean getSchemas(boolean next) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected boolean getDBObjects(boolean next) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RelationalDesign getRelationalDesign() {
        return this.relationalDesign;
    }

    public void setRelationalDesign(RelationalDesign relationalDesign) {
        this.relationalDesign = relationalDesign;
    }

    public RDBMSSite getRdbmsSite() {
        return this.rdbmsSite;
    }

    public void setRdbmsSite(RDBMSSite rdbmsSite) {
        this.rdbmsSite = rdbmsSite;
    }

    public void applySelectionForExisting(StorageDesign sd, List dbObjects) {
        for (DBObject dbo : dbObjects) {
            boolean hasSchema;
            String type = dbo.getType();
            RelationalObjectProxy obj = null;
            String schema = dbo.getSchema();
            String name = dbo.getName();
            boolean bl = hasSchema = schema != null && !"".equals(schema);
            if (hasSchema) {
                if (type.equalsIgnoreCase(TABLE)) {
                    obj = sd.getTableProxySet().getByUserSchemaAndName(schema, name);
                    if (obj == null) {
                        obj = sd.getTableProxySet().getBySchemaRelAndName(schema, name);
                    }
                } else if (type.equalsIgnoreCase(VIEW)) {
                    obj = sd.getTableViewProxySet().getBySchemaAndName(schema, name);
                }
            }
            if (obj == null) continue;
            dbo.setSelected(true);
        }
    }

    public void applySelectionForExisting(RelationalDesign rd, RDBMSSite site, List dbObjects) {
        Iterator it = dbObjects.iterator();
        if (rd != null) {
            StorageDesign sd = null;
            if (site != null) {
                sd = rd.getStorageDesign(site);
            }
            if (sd != null && sd.isOpen()) {
                this.applySelectionForExisting(sd, dbObjects);
            } else {
                while (it.hasNext()) {
                    TableView view;
                    DBObject dbo = (DBObject)it.next();
                    String type = dbo.getType();
                    boolean hasSchema = dbo.getSchema() != null && !"".equals(dbo.getSchema());
                    if (!hasSchema) continue;
                    if (type.equalsIgnoreCase(TABLE)) {
                        Table table = null;
                        table = rd.getTableSet().getBySchemaAndName(dbo.getSchema(), dbo.getName());
                        if (table == null) {
                            table = (Table)rd.getTableSet().getByName(dbo.getName());
                        }
                        if (table == null) continue;
                        dbo.setSelected(true);
                        continue;
                    }
                    if (!type.equalsIgnoreCase(VIEW) || (view = (TableView)rd.getTableViewSet().getBySchemaAndName(dbo.getSchema(), dbo.getName())) == null) continue;
                    dbo.setSelected(true);
                }
            }
        }
    }

    protected void checkAll(JTable table, List<DBObject> objects, boolean checked) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            this.selectAll(table, objects, checked);
        } else {
            for (int i = 0; i < objects.size(); ++i) {
                if (!selectionModel.isSelectedIndex(table.convertRowIndexToView(i))) continue;
                objects.get(i).setSelected(checked);
            }
        }
        table.updateUI();
    }

    protected void selectAll(JTable table, List<DBObject> objects, boolean selected) {
        if (selected) {
            this.selectAll(table, objects);
        } else {
            this.deselectAll(table, objects);
        }
    }

    public void clearFilterMap() {
        this.filterMap.clear();
    }

    public class ObjectModel
    extends AbstractTableModel {
        protected List list;

        public ObjectModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractDBMExtractionWizardImpl.Selected");
            }
            if (column == 1) {
                return Messages.getString("AbstractDBMExtractionWizardImpl.Schema");
            }
            if (column == 2) {
                return Messages.getString("AbstractDBMExtractionWizardImpl.ObjectName");
            }
            return "";
        }

        public int getFilterColumn() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < this.list.size()) {
                DBObject dbo = (DBObject)this.list.get(row);
                switch (col) {
                    case 0: {
                        return dbo.isSelected();
                    }
                    case 1: {
                        if ("SYNONYM".equalsIgnoreCase(dbo.getType())) {
                            String owner = MOHSynonymOracle.getSynonymObjectOwner(dbo);
                            String schema = dbo.getSchema() + " / " + owner;
                            return schema;
                        }
                        return dbo.getSchema();
                    }
                    case 2: {
                        if ("SYNONYM".equalsIgnoreCase(dbo.getType())) {
                            String oname = MOHSynonymOracle.getSynonymObjectName(dbo);
                            String name = dbo.getName() + " / " + oname;
                            return name;
                        }
                        return dbo.getName();
                    }
                }
                return new Integer(row * col);
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                DBObject dbo = (DBObject)this.list.get(rowIndex);
                AbstractDBMExtractionWizardImpl.this.setSelected(dbo, (Boolean)aValue);
            }
        }
    }

    class SchemasModel
    extends AbstractTableModel {
        SchemasModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AbstractDBMExtractionWizardImpl.this.lsSchemas.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractDBMExtractionWizardImpl.Selected");
            }
            if (column == 1) {
                return Messages.getString("AbstractDBMExtractionWizardImpl.Schema");
            }
            return "";
        }

        public int getFilterColumn() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < AbstractDBMExtractionWizardImpl.this.lsSchemas.size()) {
                DBObject dbo = (DBObject)AbstractDBMExtractionWizardImpl.this.lsSchemas.get(row);
                switch (col) {
                    case 0: {
                        return dbo.isSelected();
                    }
                    case 1: {
                        return dbo.getName();
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                DBObject dbo = (DBObject)AbstractDBMExtractionWizardImpl.this.lsSchemas.get(rowIndex);
                AbstractDBMExtractionWizardImpl.this.setSelected(dbo, (Boolean)aValue);
            }
        }
    }
}

