/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TypesToDomainsDialog
extends CustomDialog {
    private JDialog dialog;
    private String title;
    private Design design;
    private List<DesignWrapper> designs = new ArrayList<DesignWrapper>();
    private JTable table;
    private JCheckBox chbCreateNewDomains;
    private DomainFactory domainFactory = new DomainFactory();
    private static final Logger LOGGER = new Logger(TypesToDomainsDialog.class);

    public TypesToDomainsDialog(ApplicationView appView, String title) {
        super(appView);
        this.design = appView.getCurrentDesign();
        this.title = title;
        JPanel generalPanel = new JPanel(new BorderLayout());
        JScrollPane scrollpane = new JScrollPane(this.createTable());
        scrollpane.setPreferredSize(new Dimension(500, 410));
        generalPanel.add((Component)scrollpane, "Center");
        this.chbCreateNewDomains = new JCheckBox(Messages.getString("TypesToDomainsDialog.CreateNewDomains"));
        this.chbCreateNewDomains.setSelected(true);
        generalPanel.add((Component)this.chbCreateNewDomains, "South");
        this.add((Component)generalPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private JTable createTable() {
        this.readDesigns();
        this.table = new JTable(new TableModel());
        TableColumn tc = this.table.getColumnModel().getColumn(0);
        tc.setPreferredWidth(50);
        tc.setMaxWidth(60);
        tc.setMinWidth(50);
        tc = this.table.getColumnModel().getColumn(1);
        tc.setPreferredWidth(90);
        tc.setMaxWidth(100);
        tc.setMinWidth(50);
        return this.table;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.title);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setResizable(true);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "TYPES_TO_DOMAINS_WIZARD";
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton ok = new JButton(Messages.getString("TypesToDomainsDialog.OK"));
        ok.setMnemonic(79);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TypesToDomainsDialog.this.convertTypesToDomains();
                    MessageDialogs.showMessage(Messages.getString("TypesToDomainsDialog.DomainsCreatedOK"));
                }
                catch (Exception ex) {
                    MessageDialogs.showMessage(Messages.getString("TypesToDomainsDialog.DomainsNOTCreatedOK"));
                    LOGGER.error("Error when creating domains", ex);
                }
                TypesToDomainsDialog.this.close();
            }
        });
        JButton cancel = new JButton(Messages.getString("TypesToDomainsDialog.Cancel"));
        cancel.setMnemonic(67);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypesToDomainsDialog.this.close();
            }
        });
        ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JButton btnHelp = new JButton(this.getHelpAction());
        btnHelp.setMnemonic(72);
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        buttonPanel.add(btnHelp);
        return buttonPanel;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    private void readDesigns() {
        this.designs.add(new DesignWrapper(this.design.getLogicalDesign()));
        Iterator it = this.design.getRelationalDesigns().iterator();
        while (it.hasNext()) {
            this.designs.add(new DesignWrapper((RelationalDesign)it.next()));
        }
    }

    private void convertTypesToDomains() {
        for (DesignWrapper designWrapper : this.designs) {
            if (!designWrapper.selected) continue;
            if (designWrapper.designPart instanceof LogicalDesign) {
                this.convertTypesToDomains((LogicalDesign)designWrapper.designPart);
                continue;
            }
            this.convertTypesToDomains((RelationalDesign)designWrapper.designPart);
        }
    }

    private void convertTypesToDomains(LogicalDesign design) {
        Iterator attributeSetIterator = design.getAttributeSet().iterator();
        while (attributeSetIterator.hasNext()) {
            Attribute attribute = (Attribute)attributeSetIterator.next();
            if (attribute.getUse() != 1 || attribute.isFKAttribute()) continue;
            attribute.setDomain(this.getDomain(attribute));
            attribute.setUse((short)0);
            attribute.setDirty(true);
        }
    }

    private void convertTypesToDomains(RelationalDesign design) {
        Iterator columnSetIterator = design.getColumnSet().iterator();
        while (columnSetIterator.hasNext()) {
            Column column = (Column)columnSetIterator.next();
            if (column.getUse() != 1 || column.isFKColumn()) continue;
            column.setDomain(this.getDomain(column));
            column.setUse((short)0);
            column.setDirty(true);
        }
    }

    private Domain getDomain(ContainedObjectWithDomain containedObject) {
        if (this.chbCreateNewDomains.isSelected()) {
            return this.createDomain(containedObject, false);
        }
        Domain domain = this.getCorrespondingDomain(containedObject);
        return domain != null ? domain : this.createDomain(containedObject, true);
    }

    private Domain getCorrespondingDomain(ContainedObjectWithDomain containedObject) {
        DomainSet domainSet = this.design.getDomainSet();
        if (!domainSet.isEmpty()) {
            String scale;
            String precision;
            LogicalDatatype logicalDatatype = containedObject.getLogicalDatatype();
            String size = containedObject.getSize();
            if (!StringUtilities.isNotEmpty(size)) {
                // empty if block
            }
            if (!StringUtilities.isNotEmpty(precision = containedObject.getPrecision())) {
                // empty if block
            }
            if (!StringUtilities.isNotEmpty(scale = containedObject.getScale())) {
                // empty if block
            }
            String defValue = containedObject.getDefaultValue();
            Iterator domainSetIterator = domainSet.iterator();
            while (domainSetIterator.hasNext()) {
                Domain domain = (Domain)domainSetIterator.next();
                if (!domain.getLogicalDatatype().equals(logicalDatatype) || !domain.getSize().equals(size) || !domain.getPrecision().equals(precision) || !domain.getScale().equals(scale) || domain.getValueList() != null || domain.getCheck() != null || !domain.getAVTList().isEmpty() || !"".equals(domain.getDefaultValue()) && !defValue.equals(domain.getDefaultValue())) continue;
                return domain;
            }
        }
        return null;
    }

    private Domain createDomain(ContainedObjectWithDomain containedObject, boolean variant) {
        DomainSet domainSet;
        LogicalDatatype logicalDatatype = containedObject.getLogicalDatatype();
        String[] parameters = new String[]{containedObject.getPrecision(), containedObject.getScale(), containedObject.getSize()};
        String domainName = DomainFactory.createDomainName(logicalDatatype, parameters);
        if ((variant || containedObject.getOwnValueList() != null || containedObject.getCheck() != null || !containedObject.getAVTList().isEmpty()) && (domainSet = this.design.getDomainSet()).containsName(domainName)) {
            domainName = domainSet.createNameVariant(domainName);
        }
        Domain newDomain = this.domainFactory.getInstance(containedObject.getDesign(), logicalDatatype, null, 1, parameters, domainName);
        boolean constraints = false;
        if (containedObject.getValueList() != null) {
            newDomain.setValueList(containedObject.getValueList());
            constraints = true;
        }
        if (containedObject.getCheck() != null) {
            newDomain.setCheck(containedObject.getCheck());
            constraints = true;
        }
        if (!containedObject.getAVTList().isEmpty()) {
            newDomain.applyAVTList(containedObject.getAVTList());
            constraints = true;
        }
        if (!"".equals(containedObject.getDefaultValue())) {
            newDomain.setDefaultValue(containedObject.getDefaultValue());
        }
        if (constraints) {
            containedObject.setUseDomainConstraints(true);
        }
        return newDomain;
    }

    private class DesignWrapper {
        private DesignPart designPart;
        private boolean selected;

        DesignWrapper(DesignPart designPart) {
            this.designPart = designPart;
        }
    }

    private class TableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("TypesToDomainsDialog.Selected"), Messages.getString("TypesToDomainsDialog.ModelType"), Messages.getString("TypesToDomainsDialog.Model")};

        private TableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return TypesToDomainsDialog.this.designs.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex <= 0;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignWrapper designWrapper = (DesignWrapper)TypesToDomainsDialog.this.designs.get(row);
            DesignPart design = designWrapper.designPart;
            if (col == 1) {
                return design instanceof LogicalDesign ? Messages.getString("TypesToDomainsDialog.Logical") : Messages.getString("TypesToDomainsDialog.Relational");
            }
            if (col == 2) {
                return design.getName();
            }
            if (col == 0) {
                return designWrapper.selected;
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                ((DesignWrapper)TypesToDomainsDialog.this.designs.get(rowIndex)).selected = (Boolean)aValue;
            }
        }
    }
}

