/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class IndexHashPartitionDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private IndexHashPartitionOraclev10g partition;
    private JComboBox cbTableSpace;
    private JComboBox cbIOTOverflowTablespace;

    public IndexHashPartitionDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.partition = (IndexHashPartitionOraclev10g)object;
        this.setHeight(150);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexHashPartitionDialogOraclev10g.IndexHashPartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTableSpace();
        this.initIOTOverflowTablespace();
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("IndexHashPartitionDialogOraclev10g.TableSpace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbTableSpace, 50);
    }

    private void initIOTOverflowTablespace() {
        JLabel label = new JLabel(Messages.getString("IndexHashPartitionDialogOraclev10g.IOTTablespace"));
        this.general.add(label);
        this.cbIOTOverflowTablespace = new JComboBox();
        this.setBG(this.cbIOTOverflowTablespace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbIOTOverflowTablespace);
        }
        this.cbIOTOverflowTablespace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIOTOverflowTablespace);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbIOTOverflowTablespace, 80);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.partition.getName());
        this.tfName.setText(this.partition.getName());
        this.selectObject(this.cbTableSpace, this.partition.getTableSpace());
        this.selectObject(this.cbIOTOverflowTablespace, this.partition.getOverflowTableSpace());
        this.getCommentsList().insert(this.partition.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.partition != null) {
            this.partition.setName(this.tfName.getText());
            Object selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOracle) {
                this.partition.setTableSpace((TableSpaceOracle)selected);
            } else {
                this.partition.setTableSpace(null);
            }
            this.partition.setOverflowTableSpace((TableSpaceOracle)this.cbIOTOverflowTablespace.getSelectedItem());
            this.partition.setComment(this.getCommentsList().getText());
        }
    }
}

