/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class HierarchyPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private HierarchyOracle hierarchy;
    private DefaultListModel allLevelsModel;
    private DefaultListModel selectedLevelsModel;
    private JList allLevelsList;
    private JList selectedLevelsList;
    private JButton bnLevelAdd;
    private JButton bnLevelRemove;
    private JPanel joins;
    private JList joinList;
    private DefaultListModel joinListModel;
    private JButton btnAdd;
    private JButton btnRemove;
    private JComboBox cbLevel;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private JButton bnColumnAdd;
    private JButton bnColumnRemove;

    public HierarchyPropertyDialogOracle(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.hierarchy = (HierarchyOracle)object;
        this.setHeight(400);
        this.initCommentsView();
        this.pack();
        this.setResizable(false);
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("HierarchyPropertyDialogOracle.HierarchyProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initAllLevelsList();
        this.initSelectedLevelsList();
        this.initButtons();
    }

    @Override
    protected void addTabs() {
        this.initJoinView();
    }

    private void initJoinView() {
        this.joins = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("HierarchyPropertyDialogOracle.JoinClause"), this.joins);
        this.initJoinClause();
    }

    private void initJoinClause() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
        this.initLevel();
        this.initJoinButtons();
        this.initJoinList();
    }

    private void initJoinList() {
        JLabel label = new JLabel(Messages.getString("HierarchyPropertyDialogOracle.Joins"));
        this.joins.add(label);
        this.joinListModel = new DefaultListModel();
        this.joinList = new JList(this.joinListModel);
        this.joinList.setSelectionMode(0);
        this.joinList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (HierarchyPropertyDialogOracle.this.joinList.getSelectedValue() != null) {
                    HierarchyPropertyDialogOracle.this.btnRemove.setEnabled(HierarchyPropertyDialogOracle.this.isEditable());
                } else {
                    HierarchyPropertyDialogOracle.this.btnRemove.setEnabled(false);
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.joinList);
        sp.setPreferredSize(new Dimension(395, 130));
        this.joins.add(sp);
        this.setLabelConstraints(this.getJoinsLayout(), label, 12, 210);
        this.setObjectConstraints(this.getJoinsLayout(), sp, 10, 230);
    }

    private String getReferencedLevel(LevelOracle level) {
        ListModel lm = this.selectedLevelsList.getModel();
        TableProxy tp = level.getLevelTable();
        if (lm.getSize() > 1) {
            for (int i = 0; i < lm.getSize() - 1; ++i) {
                if (lm.getElementAt(i) != level) continue;
                for (int j = i; j < lm.getSize() - 1; ++j) {
                    LevelOracle lo = (LevelOracle)lm.getElementAt(j + 1);
                    if (tp == lo.getLevelTable()) continue;
                    return lo.getName();
                }
                return "#none#";
            }
        }
        return "";
    }

    protected void initJoinButtons() {
        this.btnAdd = new JButton(Messages.getString("HierarchyPropertyDialogOracle.AddJoin"));
        this.btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        this.btnAdd.setMnemonic(65);
        this.btnAdd.setEnabled(this.isEditable());
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelOracle level = (LevelOracle)HierarchyPropertyDialogOracle.this.cbLevel.getSelectedItem();
                Object[] selectedColumns = HierarchyPropertyDialogOracle.this.selectedColumnsModel.toArray();
                if (level != null && selectedColumns.length > 0) {
                    StringBuffer join = new StringBuffer("JOIN KEY ");
                    for (int i = 0; i < selectedColumns.length; ++i) {
                        ColumnProxyOracle selectedColumn;
                        TableProxyOracle tableProxy;
                        if (selectedColumns.length > 1 && i == 0) {
                            join.append('(');
                        }
                        if (i > 0) {
                            join.append(", ");
                        }
                        if ((tableProxy = (selectedColumn = (ColumnProxyOracle)selectedColumns[i]).getTableProxy()) != null) {
                            join.append(HierarchyPropertyDialogOracle.this.storageDesign.getFormatedLongNameDDL(tableProxy));
                            join.append('.');
                        }
                        join.append(HierarchyPropertyDialogOracle.this.storageDesign.getFormatedName(selectedColumn));
                    }
                    if (selectedColumns.length > 1) {
                        join.append(')');
                    }
                    join.append(" REFERENCES ");
                    String refLevel = HierarchyPropertyDialogOracle.this.getReferencedLevel(level);
                    join.append(HierarchyPropertyDialogOracle.this.storageDesign.getFormatedName(refLevel));
                    String jointext = join.toString();
                    if (refLevel.equalsIgnoreCase("#none#")) {
                        jointext = Messages.getString("HierarchyPropertyDialogOracle.JoinText");
                    }
                    HierarchyPropertyDialogOracle.this.joinListModel.addElement(jointext);
                    HierarchyPropertyDialogOracle.this.joinList.setSelectedValue(jointext, true);
                    HierarchyPropertyDialogOracle.this.btnRemove.setEnabled(true);
                }
            }
        });
        this.joins.add(this.btnAdd);
        this.setObjectConstraints(this.getJoinsLayout(), this.btnAdd, 70, 170);
        this.btnRemove = new JButton(Messages.getString("HierarchyPropertyDialogOracle.RemoveJoin"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String join = (String)HierarchyPropertyDialogOracle.this.joinList.getSelectedValue();
                if (join != null) {
                    HierarchyPropertyDialogOracle.this.joinListModel.removeElement(join);
                }
            }
        });
        this.btnRemove.setMnemonic(82);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setPreferredSize(this.btnAdd.getPreferredSize());
        this.joins.add(this.btnRemove);
        this.setObjectConstraints(this.getJoinsLayout(), this.btnRemove, 255, 170);
    }

    private void initLevel() {
        JLabel label = new JLabel(Messages.getString("HierarchyPropertyDialogOracle.Level"));
        this.joins.add(label);
        this.cbLevel = new JComboBox();
        this.setBG(this.cbLevel);
        this.cbLevel.addActionListener(new LevelListener());
        this.cbLevel.setPreferredSize(this.tfName.getPreferredSize());
        this.joins.add(this.cbLevel);
        this.setLabelConstraints(this.getJoinsLayout(), label, 12, 140);
        this.setObjectConstraints(this.getJoinsLayout(), this.cbLevel, 140);
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("HierarchyPropertyDialogOracle.AllColumns"));
        this.joins.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(144, 100));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.joins.add(sp);
        this.setLabelConstraints(this.getJoinsLayout(), label, 12, 14);
        this.setObjectConstraints(this.getJoinsLayout(), sp, 10, 32);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("HierarchyPropertyDialogOracle.SelectedColumns"));
        this.joins.add(label);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(145, 100));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.joins.add(sp);
        this.setLabelConstraints(this.getJoinsLayout(), label, 292, 14);
        this.setObjectConstraints(this.getJoinsLayout(), sp, 290, 32);
    }

    private void initColumnsButtons() {
        this.bnColumnAdd = new JButton(Messages.getString("HierarchyPropertyDialogOracle.Add"));
        this.bnColumnAdd.addActionListener(new AddColumnsActionListener());
        this.bnColumnAdd.setEnabled(false);
        this.joins.add(this.bnColumnAdd);
        this.setObjectConstraints(this.getJoinsLayout(), this.bnColumnAdd, 175, 55);
        this.bnColumnRemove = new JButton(Messages.getString("HierarchyPropertyDialogOracle.Remove"));
        this.bnColumnRemove.setEnabled(false);
        this.bnColumnRemove.addActionListener(new RemoveColumnsActionListener());
        this.joins.add(this.bnColumnRemove);
        this.setObjectConstraints(this.getJoinsLayout(), this.bnColumnRemove, 175, 85);
        HierarchyPropertyDialogOracle.equalizeButtonSizes(this.bnColumnAdd, this.bnColumnRemove);
    }

    private void initAllLevelsList() {
        JLabel label = new JLabel(Messages.getString("HierarchyPropertyDialogOracle.AllLevels"));
        this.general.add(label);
        this.allLevelsModel = new DefaultListModel();
        this.allLevelsList = new JList(this.allLevelsModel);
        ListSelectionModel listSelectionModel = this.allLevelsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allLevelsList);
        sp.setPreferredSize(new Dimension(144, 280));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(sp);
        this.setLabelConstraints(this.getLevelsLayout(), label, 12, 64);
        this.setObjectConstraints(this.getLevelsLayout(), sp, 10, 82);
    }

    private void initSelectedLevelsList() {
        JLabel label = new JLabel(Messages.getString("HierarchyPropertyDialogOracle.CHILDOFRelation"));
        this.general.add(label);
        this.selectedLevelsModel = new DefaultListModel();
        this.selectedLevelsList = new JList(this.selectedLevelsModel);
        ListSelectionModel listSelectionModel = this.selectedLevelsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedLevelsList);
        sp.setPreferredSize(new Dimension(145, 280));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(sp);
        this.setLabelConstraints(this.getLevelsLayout(), label, 292, 64);
        this.setObjectConstraints(this.getLevelsLayout(), sp, 290, 82);
    }

    private void initButtons() {
        this.bnLevelAdd = new JButton(Messages.getString("HierarchyPropertyDialogOracle.Add"));
        this.bnLevelAdd.addActionListener(new AddLevelsActionListener());
        this.bnLevelAdd.setEnabled(false);
        this.general.add(this.bnLevelAdd);
        this.setObjectConstraints(this.getLevelsLayout(), this.bnLevelAdd, 175, 185);
        this.bnLevelRemove = new JButton(Messages.getString("HierarchyPropertyDialogOracle.Remove"));
        this.bnLevelRemove.setEnabled(false);
        this.bnLevelRemove.addActionListener(new RemoveLevelsActionListener());
        this.general.add(this.bnLevelRemove);
        this.setObjectConstraints(this.getLevelsLayout(), this.bnLevelRemove, 175, 215);
        HierarchyPropertyDialogOracle.equalizeButtonSizes(this.bnLevelAdd, this.bnLevelRemove);
    }

    protected SpringLayout getLevelsLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    protected SpringLayout getJoinsLayout() {
        return (SpringLayout)this.joins.getLayout();
    }

    private void updateLevelCombo() {
        Object[] obs = this.selectedLevelsModel.toArray();
        this.cbLevel.removeAllItems();
        if (obs.length > 1) {
            for (int i = 0; i < obs.length - 1; ++i) {
                this.cbLevel.addItem(obs[i]);
            }
        }
    }

    @Override
    public void initProperties() {
        this.initCaption(this.hierarchy.getName());
        ArrayList<LevelOracle> list = new ArrayList<LevelOracle>();
        Object[] levelSet = this.hierarchy.getDimension().getLevelSet();
        for (int i = 0; i < levelSet.length; ++i) {
            LevelOracle level = (LevelOracle)levelSet[i];
            if (!this.hierarchy.getLevelSet().contains(level.getName()) && !this.hierarchy.getLevelSet().contains(level.getObjectID())) {
                this.allLevelsModel.addElement(level);
                continue;
            }
            list.add(level);
        }
        for (String id : this.hierarchy.getLevelSet()) {
            LevelOracle level = this.getLevelByID(list, id);
            if (level == null) continue;
            this.selectedLevelsModel.addElement(level);
        }
        Iterator it = this.hierarchy.getJoinSet().iterator();
        while (it.hasNext()) {
            this.joinListModel.addElement(it.next());
        }
        this.tfName.setText(this.hierarchy.getName());
        this.updateLevelCombo();
        this.getCommentsList().insert(this.hierarchy.getComment(), 0);
    }

    private LevelOracle getLevelByID(List<LevelOracle> list, String id) {
        if (id != null) {
            for (LevelOracle level : list) {
                if (!id.equalsIgnoreCase(level.getObjectID())) continue;
                return level;
            }
        }
        return null;
    }

    @Override
    protected void setProperties() {
        if (this.hierarchy != null) {
            this.hierarchy.setName(this.tfName.getText());
            Object[] levelSet = this.selectedLevelsModel.toArray();
            this.hierarchy.clearLevels();
            for (int i = 0; i < levelSet.length; ++i) {
                Object ob = levelSet[i];
                if (!(ob instanceof LevelOracle)) continue;
                this.hierarchy.setLevels(((LevelOracle)ob).getObjectID());
            }
            Object[] joinSet = this.joinListModel.toArray();
            this.hierarchy.clearJoins();
            for (int i = 0; i < joinSet.length; ++i) {
                String join = (String)joinSet[i];
                this.hierarchy.setJoins(join);
            }
            this.hierarchy.setComment(this.getCommentsList().getText());
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (HierarchyPropertyDialogOracle.this.isEditable() && !e.getValueIsAdjusting()) {
                if (HierarchyPropertyDialogOracle.this.selectedColumnsList.getSelectedIndex() == -1) {
                    HierarchyPropertyDialogOracle.this.bnColumnRemove.setEnabled(false);
                } else {
                    HierarchyPropertyDialogOracle.this.bnColumnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (HierarchyPropertyDialogOracle.this.isEditable() && !e.getValueIsAdjusting()) {
                if (HierarchyPropertyDialogOracle.this.allColumnsList.getSelectedIndex() == -1) {
                    HierarchyPropertyDialogOracle.this.bnColumnAdd.setEnabled(false);
                } else {
                    HierarchyPropertyDialogOracle.this.bnColumnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!HierarchyPropertyDialogOracle.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = HierarchyPropertyDialogOracle.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (HierarchyPropertyDialogOracle.this.allColumnsModel.contains(ob)) continue;
                    HierarchyPropertyDialogOracle.this.allColumnsModel.addElement(ob);
                    HierarchyPropertyDialogOracle.this.selectedColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!HierarchyPropertyDialogOracle.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = HierarchyPropertyDialogOracle.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (HierarchyPropertyDialogOracle.this.selectedColumnsModel.contains(ob)) continue;
                    HierarchyPropertyDialogOracle.this.selectedColumnsModel.addElement(ob);
                    HierarchyPropertyDialogOracle.this.allColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (HierarchyPropertyDialogOracle.this.isEditable() && !e.getValueIsAdjusting()) {
                if (HierarchyPropertyDialogOracle.this.selectedLevelsList.getSelectedIndex() == -1) {
                    HierarchyPropertyDialogOracle.this.bnLevelRemove.setEnabled(false);
                } else {
                    HierarchyPropertyDialogOracle.this.bnLevelRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (HierarchyPropertyDialogOracle.this.isEditable() && !e.getValueIsAdjusting()) {
                if (HierarchyPropertyDialogOracle.this.allLevelsList.getSelectedIndex() == -1) {
                    HierarchyPropertyDialogOracle.this.bnLevelAdd.setEnabled(false);
                } else {
                    HierarchyPropertyDialogOracle.this.bnLevelAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveLevelsActionListener
    implements ActionListener {
        private RemoveLevelsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!HierarchyPropertyDialogOracle.this.selectedLevelsModel.isEmpty()) {
                Object[] selectedObjects = HierarchyPropertyDialogOracle.this.selectedLevelsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (HierarchyPropertyDialogOracle.this.allLevelsModel.contains(ob)) continue;
                    HierarchyPropertyDialogOracle.this.allLevelsModel.addElement(ob);
                    HierarchyPropertyDialogOracle.this.selectedLevelsModel.removeElement(ob);
                }
                HierarchyPropertyDialogOracle.this.updateLevelCombo();
            }
        }
    }

    private class AddLevelsActionListener
    implements ActionListener {
        private AddLevelsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!HierarchyPropertyDialogOracle.this.allLevelsModel.isEmpty()) {
                Object[] selectedObjects = HierarchyPropertyDialogOracle.this.allLevelsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (HierarchyPropertyDialogOracle.this.selectedLevelsModel.contains(ob)) continue;
                    HierarchyPropertyDialogOracle.this.selectedLevelsModel.addElement(ob);
                    HierarchyPropertyDialogOracle.this.allLevelsModel.removeElement(ob);
                }
                HierarchyPropertyDialogOracle.this.updateLevelCombo();
            }
        }
    }

    private class LevelListener
    implements ActionListener {
        private LevelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (HierarchyPropertyDialogOracle.this.cbLevel.getSelectedItem() != null) {
                LevelOracle level = (LevelOracle)HierarchyPropertyDialogOracle.this.cbLevel.getSelectedItem();
                HierarchyPropertyDialogOracle.this.allColumnsModel.removeAllElements();
                HierarchyPropertyDialogOracle.this.selectedColumnsModel.removeAllElements();
                TableProxy table = level.getLevelTable();
                if (table != null) {
                    ColumnProxy[] columnSet = table.getColumnProxies();
                    for (int i = 0; i < columnSet.length; ++i) {
                        ColumnProxyOracle col = (ColumnProxyOracle)columnSet[i];
                        HierarchyPropertyDialogOracle.this.allColumnsModel.addElement(col);
                    }
                }
            } else {
                HierarchyPropertyDialogOracle.this.allColumnsModel.removeAllElements();
                HierarchyPropertyDialogOracle.this.selectedColumnsModel.removeAllElements();
            }
        }
    }
}

