/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ColumnsPermissionsDialogOracle
extends CustomDialog {
    private StorageDesignOracle storageDesign;
    private Object userRole;
    private JButton bnOK;
    private JButton bnApply;
    private JButton bnCancel;
    private JButton buttonColumnAdd;
    private JButton buttonColumnRemove;
    private JButton buttonPrivilegeAdd;
    private JButton buttonPrivilegeRemove;
    private final JPanel generalPanel;
    private JPanel allColumnsPanel;
    private JPanel privilegedColumnsPanel;
    private JPanel userRolePrivilegesListPanel;
    private JPanel privilegesPanel;
    private JPanel grantedUserRolePrivilegesPanel;
    private JDialog dialog;
    private List<Object> privilegedColumnsContainerList;
    private List<Privilege> containerListPrivileges;
    private JTable privilegedColumnsTable;
    private JTable privilegedUserRolePrivilegesTable;
    private PrivilegedObject currentPrivilegedObject;
    private JScrollPane availablePrivilegesScrollPane;
    private DefaultListModel availablePrivilegesModel;
    private DefaultListModel allColumnsPanelListModel;
    private JList availablePrivilegesList;
    private JList allColumnsPanelList;
    private Privilege currentPrivilege;
    private GrantedPrivilegessModel grantedPrivilegessModel;
    private ArrayList objWithRevokedPrivs = new ArrayList();
    private TableProxyOracle table;

    public ColumnsPermissionsDialogOracle(ApplicationView appView, StorageDesign storageDesign, Object userRole, TableProxyOracle table) {
        super(appView);
        this.storageDesign = (StorageDesignOracle)storageDesign;
        this.userRole = userRole;
        this.table = table;
        this.generalPanel = new JPanel(new BorderLayout());
        this.initLeftPanel(this.generalPanel);
        this.initColumnsAddRemoveButtons(this.generalPanel);
        this.initRightPanel(this.generalPanel);
        this.initBottomPanel(this.generalPanel);
        this.add((Component)this.generalPanel, "Center");
        this.generalPanel.setPreferredSize(new Dimension(600, 500));
    }

    private void initLeftPanel(JPanel panel) {
        this.allColumnsPanel = new JPanel(new BorderLayout());
        this.allColumnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ColumnsPermissionsDialogOracle.AllColumns")));
        this.allColumnsPanelListModel = new DefaultListModel();
        this.allColumnsPanelList = new JList(this.allColumnsPanelListModel);
        JScrollPane columnsScrollPane = new JScrollPane(this.allColumnsPanelList);
        columnsScrollPane.setPreferredSize(new Dimension(180, 432));
        this.allColumnsPanel.add(columnsScrollPane);
        this.allColumnsPanelList.getSelectionModel().addListSelectionListener(new allColumnsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ColumnsPermissionsDialogOracle.this.allColumnsPanelList.getSelectedIndex() == -1) {
                    ColumnsPermissionsDialogOracle.this.buttonColumnAdd.setEnabled(false);
                } else {
                    ColumnsPermissionsDialogOracle.this.buttonColumnAdd.setEnabled(true);
                }
            }
        });
        panel.add((Component)this.allColumnsPanel, "West");
    }

    private void initRightPanel(JPanel panel) {
        this.privilegedColumnsPanel = new JPanel(new BorderLayout());
        this.privilegedColumnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ColumnsPermissionsDialogOracle.PrivilegedColumns")));
        this.privilegedColumnsPanel.setPreferredSize(new Dimension(370, 400));
        this.initPrivilegedColumns();
        this.initAvailablePrivileges();
        this.initGrantedUserRoleProvileges();
        this.loadAllColumns();
        panel.add((Component)this.privilegedColumnsPanel, "East");
    }

    private void loadAllColumns() {
        Iterator<ColumnProxy> itColumns = Arrays.asList(this.table.getColumnProxies()).iterator();
        while (itColumns.hasNext()) {
            this.checkPermissions(itColumns.next());
        }
    }

    private void refreshGrantedUserRoleProvileges() {
        if (this.userRole instanceof RoleOracle) {
            this.grantedPrivilegessModel.columnsVisible[1] = false;
            this.grantedPrivilegessModel.fireTableStructureChanged();
            TableColumn col0 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(0);
            if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() == 1) {
                col0.setWidth(214);
                col0.setMaxWidth(214);
            } else if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() > 1) {
                col0.setWidth(162);
                col0.setMaxWidth(162);
                TableColumn col1 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(1);
                col1.setWidth(52);
                col1.setMaxWidth(52);
            }
        } else if (this.userRole instanceof UserOracle) {
            this.grantedPrivilegessModel.columnsVisible[1] = true;
            this.grantedPrivilegessModel.fireTableStructureChanged();
            TableColumn col0 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(0);
            TableColumn col1 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(1);
            if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() <= 2) {
                col0.setWidth(152);
                col0.setMaxWidth(152);
                col1.setWidth(40);
                col1.setMaxWidth(40);
            } else if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() > 2) {
                col0.setWidth(100);
                col0.setMaxWidth(100);
            }
        }
        this.grantedUserRolePrivilegesPanel.updateUI();
    }

    private void initGrantedUserRoleProvileges() {
        this.grantedUserRolePrivilegesPanel = new JPanel(new BorderLayout());
        this.grantedUserRolePrivilegesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.GrantedPrivileges")));
        this.containerListPrivileges = new ArrayList<Privilege>();
        this.grantedPrivilegessModel = new GrantedPrivilegessModel();
        this.privilegedUserRolePrivilegesTable = new JTable(this.grantedPrivilegessModel);
        this.privilegedUserRolePrivilegesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRow() == -1) {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(false);
                } else {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(true);
                    ColumnsPermissionsDialogOracle.this.currentPrivilege = (Privilege)ColumnsPermissionsDialogOracle.this.containerListPrivileges.get(ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRow());
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.privilegedUserRolePrivilegesTable);
        scrollPane.setPreferredSize(new Dimension(192, 100));
        this.grantedUserRolePrivilegesPanel.add(scrollPane, "East", 0);
        this.userRolePrivilegesListPanel.add((Component)this.grantedUserRolePrivilegesPanel, "East");
        this.privilegedColumnsPanel.add((Component)this.userRolePrivilegesListPanel, "Center");
    }

    private void initAvailablePrivileges() {
        this.userRolePrivilegesListPanel = new JPanel(new BorderLayout());
        this.userRolePrivilegesListPanel.setPreferredSize(new Dimension(100, 400));
        this.privilegesPanel = new JPanel(new BorderLayout());
        JPanel availablePrivilegesListPanel = new JPanel(new BorderLayout());
        availablePrivilegesListPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.AvailablePrivileges")));
        this.availablePrivilegesModel = new DefaultListModel();
        this.availablePrivilegesList = new JList(this.availablePrivilegesModel);
        this.availablePrivilegesScrollPane = new JScrollPane(this.availablePrivilegesList);
        this.availablePrivilegesScrollPane.setPreferredSize(new Dimension(110, 200));
        availablePrivilegesListPanel.add(this.availablePrivilegesScrollPane);
        this.privilegesPanel.add((Component)availablePrivilegesListPanel, "West");
        this.userRolePrivilegesListPanel.add((Component)this.privilegesPanel, "West");
        this.initPrivilegesAddRemoveButtons();
        this.availablePrivilegesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ColumnsPermissionsDialogOracle.this.availablePrivilegesList.getSelectedIndex() == -1) {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(false);
                } else {
                    ColumnsPermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(true);
                }
            }
        });
        this.sort(this.availablePrivilegesModel);
    }

    private void initPrivilegedColumns() {
        JPanel pColumnsPanel = new JPanel(new BorderLayout());
        this.privilegedColumnsContainerList = new ArrayList<Object>();
        this.privilegedColumnsTable = new JTable(new PriviligedColumnsModel());
        this.privilegedColumnsTable.setSelectionMode(0);
        TableColumn col0 = this.privilegedColumnsTable.getColumnModel().getColumn(0);
        col0.setWidth(148);
        col0.setMaxWidth(148);
        TableColumn col1 = this.privilegedColumnsTable.getColumnModel().getColumn(1);
        col1.setWidth(210);
        col1.setMaxWidth(210);
        this.privilegedColumnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getSelectedRow() == -1) {
                    ColumnsPermissionsDialogOracle.this.buttonColumnRemove.setEnabled(false);
                } else {
                    ColumnsPermissionsDialogOracle.this.buttonColumnRemove.setEnabled(true);
                    PrivilegedObject selected = (PrivilegedObject)ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.get(ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getSelectedRow());
                    ColumnsPermissionsDialogOracle.this.containerListPrivileges = new ArrayList();
                    ColumnsPermissionsDialogOracle.this.currentPrivilegedObject = selected;
                    ColumnsPermissionsDialogOracle.this.refreshGrantedUserRoleProvileges();
                    ColumnsPermissionsDialogOracle.this.containerListPrivileges.clear();
                    ArrayList grantedPrivileges = ColumnsPermissionsDialogOracle.this.loadGrantedObjectProvileges(selected);
                    ColumnsPermissionsDialogOracle.this.loadAvailableObjectPrivileges(grantedPrivileges);
                    ColumnsPermissionsDialogOracle.this.availablePrivilegesList.getSelectionModel().setSelectionInterval(0, 0);
                    ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
                    ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.privilegedColumnsTable);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        pColumnsPanel.add((Component)scrollPane, "North");
        this.privilegedColumnsPanel.add((Component)pColumnsPanel, "North");
    }

    private ArrayList<Object> loadGrantedObjectProvileges(PrivilegedObject obj) {
        this.containerListPrivileges.clear();
        ArrayList<Privilege> privileges = obj.getPrivileges();
        Iterator<Privilege> it = privileges.iterator();
        ArrayList<Object> trimmedPrivileges = new ArrayList<Object>();
        while (it.hasNext()) {
            Privilege current = it.next();
            this.containerListPrivileges.add(current);
            trimmedPrivileges.add(current.getObject());
        }
        return trimmedPrivileges;
    }

    private void loadAvailableObjectPrivileges(ArrayList<Object> grantedPrivileges) {
        String[] availablePrivileges = null;
        availablePrivileges = PermissionsOracle.getColumnPermissionsValues();
        this.availablePrivilegesModel.clear();
        if (availablePrivileges != null) {
            Iterator<String> it = Arrays.asList(availablePrivileges).iterator();
            while (it.hasNext()) {
                String current = it.next().trim();
                if (grantedPrivileges.size() != 0 && grantedPrivileges.contains(current)) continue;
                this.availablePrivilegesModel.addElement(current);
            }
        }
    }

    private void initPrivilegesAddRemoveButtons() {
        JPanel buttonPanel1 = new JPanel(new GridLayout(3, 1));
        JPanel jp11 = new JPanel();
        JPanel jpButtons1 = new JPanel(new BorderLayout());
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.buttonPrivilegeAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonPrivilegeAdd.addActionListener(new AddPrivilegeActionListener());
        this.buttonPrivilegeAdd.setEnabled(false);
        this.buttonPrivilegeAdd.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Add"));
        this.buttonPrivilegeRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonPrivilegeRemove.setEnabled(false);
        this.buttonPrivilegeRemove.addActionListener(new RemovePrivilegeActionListener());
        this.buttonPrivilegeRemove.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Remove"));
        this.buttonPrivilegeAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonPrivilegeRemove.setPreferredSize(this.buttonPrivilegeAdd.getPreferredSize());
        jpButtons1.add((Component)this.buttonPrivilegeAdd, "North");
        jpButtons1.add((Component)this.buttonPrivilegeRemove, "Center");
        jp11.add(jpButtons1);
        buttonPanel1.add(new JPanel());
        buttonPanel1.add(jp11);
        buttonPanel1.add(new JPanel());
        this.privilegesPanel.add((Component)buttonPanel1, "East");
    }

    private void checkPermissions(Object ob) {
        PermissionsOracle permissionsOracle = this.getPermissionPerObject((StorageObject)this.userRole, (ColumnProxyOracle)ob);
        if (permissionsOracle == null) {
            this.allColumnsPanelListModel.addElement(ob);
        } else if (permissionsOracle != null) {
            this.privilegedUserRolePrivilegesTable.updateUI();
            PrivilegedObject po = new PrivilegedObject(ob);
            ArrayList<Privilege> pPrivilege = new ArrayList<Privilege>();
            StringTokenizer st = new StringTokenizer(permissionsOracle.getPrivs((ColumnProxyOracle)ob), ",");
            while (st.hasMoreTokens()) {
                String item = st.nextToken().trim();
                Privilege p = new Privilege(item.trim());
                p.setName(item);
                pPrivilege.add(p);
            }
            StringTokenizer st1 = new StringTokenizer(permissionsOracle.getPrivsWithGrantOption((ColumnProxyOracle)ob), ",");
            while (st1.hasMoreTokens()) {
                String item1 = st1.nextToken().trim();
                Privilege p = new Privilege(item1.trim());
                p.setName(item1);
                p.setGrantOption(true);
                pPrivilege.add(p);
            }
            po.setPrivileges(pPrivilege);
            this.privilegedColumnsContainerList.add(po);
        }
    }

    private PermissionsOracle getPermissionPerObject(StorageObject type, ColumnProxyOracle column) {
        for (PermissionsOracle perm : this.storageDesign.getPermissionsSet()) {
            if (perm.getUser() != type && perm.getRole() != type || perm.getColumnsTable() == null || !perm.getColumnsTable().getObjectID().equals(column.getTableProxy().getObjectID()) || !perm.getColumns().contains(column.getName()) && !perm.getColumnsWithGrantOption().contains(column.getName())) continue;
            return perm;
        }
        return null;
    }

    private void initBottomPanel(JPanel panel) {
        JPanel bPanel = new JPanel();
        bPanel.setBorder(BorderFactory.createEtchedBorder());
        this.bnOK = new JButton(Messages.getString("ObjectPermissionsDialogOracle.OK"));
        this.bnOK.addActionListener(new OKAction());
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bPanel.add(this.bnOK);
        this.bnApply = new JButton(Messages.getString("ObjectPermissionsDialogOracle.Apply"));
        this.bnApply.addActionListener(new ApplyAction());
        this.bnApply.setMnemonic(65);
        this.bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bPanel.add(this.bnApply);
        this.bnCancel = new JButton(Messages.getString("ObjectPermissionsDialogOracle.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bPanel.add(this.bnCancel);
        panel.add((Component)bPanel, "South");
    }

    private void initColumnsAddRemoveButtons(JPanel panel) {
        JPanel buttonPanel = new JPanel(new GridLayout(4, 1));
        buttonPanel.setPreferredSize(new Dimension(35, 500));
        JPanel jp1 = new JPanel();
        JPanel jpButtons = new JPanel(new BorderLayout());
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.buttonColumnAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonColumnAdd.addActionListener(new AddColumnActionListener());
        this.buttonColumnAdd.setEnabled(false);
        this.buttonColumnAdd.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Add"));
        this.buttonColumnRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonColumnRemove.setEnabled(false);
        this.buttonColumnRemove.addActionListener(new RemoveColumnsActionActionListener());
        this.buttonColumnRemove.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Remove"));
        this.buttonColumnAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonColumnRemove.setPreferredSize(this.buttonColumnAdd.getPreferredSize());
        jpButtons.add((Component)this.buttonColumnAdd, "North");
        jpButtons.add((Component)this.buttonColumnRemove, "Center");
        jp1.add(jpButtons);
        buttonPanel.add(new JPanel());
        buttonPanel.add(jp1);
        buttonPanel.add(new JPanel());
        buttonPanel.add(new JPanel());
        panel.add((Component)buttonPanel, "Center");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ColumnsPermissionsDialogOracle.ColumnsPermissions"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    public DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                if (list.get(i).toString().compareTo(list.get(i - 1).toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    protected void savePermissions() {
        PermissionsOracle perm = null;
        PermissionsSetOracle ps = this.storageDesign.getPermissionsSet();
        for (int i = 0; i < this.privilegedColumnsTable.getRowCount(); ++i) {
            PrivilegedObject obj = (PrivilegedObject)this.privilegedColumnsContainerList.get(i);
            ColumnProxyOracle column = (ColumnProxyOracle)obj.getObject();
            perm = this.getPermissionPerObject((StorageObject)this.userRole, column);
            if (perm == null) {
                perm = ps.createPermissions();
                perm.setColumnsTable(column.getTableProxy());
                if (this.userRole instanceof UserOracle) {
                    perm.setUser((UserOracle)this.userRole);
                } else if (this.userRole instanceof RoleOracle) {
                    perm.setRole((RoleOracle)this.userRole);
                }
            } else if (perm != null) {
                perm.clearColPermissions();
            }
            String columnPrivileges = "";
            columnPrivileges = columnPrivileges.concat(column.getName());
            String columnWithGrantOptionPrivileges = "";
            columnWithGrantOptionPrivileges = columnWithGrantOptionPrivileges.concat(column.getName());
            for (Privilege p : obj.getPrivileges()) {
                if (p.getGrantOption()) {
                    columnWithGrantOptionPrivileges = columnWithGrantOptionPrivileges.concat(", ").concat((String)p.getObject());
                    continue;
                }
                columnPrivileges = columnPrivileges.concat(", ").concat((String)p.getObject());
            }
            if (columnPrivileges.indexOf(",") > -1) {
                perm.setColumnList(columnPrivileges);
            }
            if (columnWithGrantOptionPrivileges.indexOf(",") <= -1) continue;
            perm.setColumnListWithGrantOption(columnWithGrantOptionPrivileges);
        }
        Iterator it = this.objWithRevokedPrivs.iterator();
        while (it.hasNext()) {
            ColumnProxyOracle column = (ColumnProxyOracle)((PrivilegedObject)it.next()).getObject();
            PermissionsOracle currentObjectPermission = this.getPermissionPerObject((StorageObject)this.userRole, column);
            ps.remove(currentObjectPermission);
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnsPermissionsDialogOracle.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnsPermissionsDialogOracle.this.savePermissions();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnsPermissionsDialogOracle.this.savePermissions();
            ColumnsPermissionsDialogOracle.this.close();
        }
    }

    class PrivilegedObject {
        Object obj = null;
        ArrayList<Privilege> privileges = new ArrayList();
        ArrayList<Privilege> privilegesWithGrantOption = new ArrayList();

        PrivilegedObject(Object object) {
            this.obj = object;
        }

        void addPrivilege(Privilege privilege) {
            this.privileges.add(privilege);
        }

        void removePrivilege(Privilege privilege) {
            this.privileges.remove(privilege);
        }

        Object getObject() {
            return this.obj;
        }

        ArrayList<Privilege> getPrivileges() {
            return this.privileges;
        }

        void setPrivileges(ArrayList<Privilege> privs) {
            this.privileges = privs;
        }

        void addPrivilegeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.add(privilege);
        }

        void removeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.remove(privilege);
        }

        ArrayList<Privilege> getPrivilegeWithGrantOption() {
            return this.privilegesWithGrantOption;
        }
    }

    class Privilege {
        Object obj = null;
        String name = "";
        boolean grantOption = false;
        boolean hierarchy = false;

        Privilege(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        void setGrantOption(boolean grantOption) {
            this.grantOption = grantOption;
        }

        boolean getGrantOption() {
            return this.grantOption;
        }

        void setHierarchy(boolean hierarchy) {
            this.hierarchy = hierarchy;
        }

        boolean getHierarchy() {
            return this.hierarchy;
        }
    }

    private class RemovePrivilegeActionListener
    implements ActionListener {
        private RemovePrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRows();
            ArrayList<Privilege> tempList = new ArrayList<Privilege>();
            for (int i = 0; i < selected.length; ++i) {
                Privilege currentPrivilege = (Privilege)ColumnsPermissionsDialogOracle.this.containerListPrivileges.get(selected[i]);
                Object current = currentPrivilege.getObject();
                tempList.add(currentPrivilege);
                if (ColumnsPermissionsDialogOracle.this.availablePrivilegesModel.contains(current)) continue;
                ColumnsPermissionsDialogOracle.this.availablePrivilegesModel.addElement(current);
                ColumnsPermissionsDialogOracle.this.currentPrivilegedObject.removePrivilege(currentPrivilege);
                ColumnsPermissionsDialogOracle.this.sort(ColumnsPermissionsDialogOracle.this.availablePrivilegesModel);
                ColumnsPermissionsDialogOracle.this.availablePrivilegesList.setSelectedValue(current, true);
            }
            ColumnsPermissionsDialogOracle.this.containerListPrivileges.removeAll(tempList);
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
        }
    }

    private class AddPrivilegeActionListener
    implements ActionListener {
        private AddPrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = ColumnsPermissionsDialogOracle.this.availablePrivilegesList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                Privilege current = new Privilege(selected[i]);
                if (ColumnsPermissionsDialogOracle.this.containerListPrivileges.contains(current)) continue;
                ColumnsPermissionsDialogOracle.this.containerListPrivileges.add(current);
                ColumnsPermissionsDialogOracle.this.availablePrivilegesModel.removeElement(selected[i]);
                ColumnsPermissionsDialogOracle.this.currentPrivilegedObject.addPrivilege(current);
            }
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectionModel().setSelectionInterval(ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getRowCount() - 1, ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getRowCount() - 1);
        }
    }

    private class RemoveColumnsActionActionListener
    implements ActionListener {
        private RemoveColumnsActionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnsPermissionsDialogOracle.this.objWithRevokedPrivs.clear();
            int[] selectedPrivilegedObjects = ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getSelectedRows();
            for (int i = 0; i < selectedPrivilegedObjects.length; ++i) {
                PrivilegedObject selectedObject = (PrivilegedObject)ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.get(selectedPrivilegedObjects[i]);
                Object current = selectedObject.getObject();
                ColumnsPermissionsDialogOracle.this.objWithRevokedPrivs.add(selectedObject);
                if (ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel.contains(current)) continue;
                ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel.addElement(current);
                ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.remove(selectedObject);
                ColumnsPermissionsDialogOracle.this.sort(ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel);
                ColumnsPermissionsDialogOracle.this.allColumnsPanelList.setSelectedValue(current, true);
            }
            ColumnsPermissionsDialogOracle.this.availablePrivilegesModel.clear();
            ColumnsPermissionsDialogOracle.this.containerListPrivileges.clear();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.clearSelection();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
            ColumnsPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
        }
    }

    private class AddColumnActionListener
    implements ActionListener {
        private AddColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selectedColumns = ColumnsPermissionsDialogOracle.this.allColumnsPanelList.getSelectedValues();
            for (int i = 0; i < selectedColumns.length; ++i) {
                PrivilegedObject privilegedObject = new PrivilegedObject(selectedColumns[i]);
                if (ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.contains(privilegedObject)) continue;
                ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.add(privilegedObject);
                ColumnsPermissionsDialogOracle.this.allColumnsPanelListModel.removeElement(selectedColumns[i]);
            }
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.updateUI();
            ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getSelectionModel().setSelectionInterval(ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getRowCount() - 1, ColumnsPermissionsDialogOracle.this.privilegedColumnsTable.getRowCount() - 1);
        }
    }

    private class allColumnsPanelSelectionListener
    implements ListSelectionListener {
        private allColumnsPanelSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
        }
    }

    private class PriviligedColumnsModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("ColumnsPermissionsDialogOracle.Column"), Messages.getString("ColumnsPermissionsDialogOracle.Privilegepermission")};

        private PriviligedColumnsModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            PrivilegedObject po = (PrivilegedObject)ColumnsPermissionsDialogOracle.this.privilegedColumnsContainerList.get(row);
            if (col == 0) {
                return po.getObject();
            }
            if (col == 1) {
                String pr = "";
                ArrayList<Privilege> p = po.getPrivileges();
                Iterator<Privilege> it = p.iterator();
                while (it.hasNext()) {
                    pr = pr + "," + it.next().getObject();
                }
                return po.getPrivileges().size() == 0 ? "" : pr.substring(1, pr.length());
            }
            return "";
        }
    }

    private class GrantedPrivilegessModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2441829494099422701L;
        final String[] COL_NAMES = new String[]{Messages.getString("ObjectPermissionsDialogOracle.Privilege"), Messages.getString("ObjectPermissionsDialogOracle.Grant")};
        boolean[] columnsVisible = new boolean[3];

        public GrantedPrivilegessModel() {
            this.columnsVisible[0] = true;
            this.columnsVisible[1] = false;
        }

        @Override
        public int getColumnCount() {
            int n = 0;
            for (int i = 0; i < this.COL_NAMES.length; ++i) {
                if (!this.columnsVisible[i]) continue;
                ++n;
            }
            return n;
        }

        protected int getNumber(int col) {
            int n = col;
            int i = 0;
            do {
                if (this.columnsVisible[i]) continue;
                ++n;
            } while (++i < n);
            while (!this.columnsVisible[n]) {
                ++n;
            }
            return n;
        }

        @Override
        public int getRowCount() {
            return ColumnsPermissionsDialogOracle.this.containerListPrivileges.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[this.getNumber(column)];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Object o = null;
            int col = this.getNumber(columnIndex);
            if (col == 0) {
                return false;
            }
            return col == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            int col = this.getNumber(column);
            Privilege privilege = (Privilege)ColumnsPermissionsDialogOracle.this.containerListPrivileges.get(row);
            if (value instanceof Boolean && col == 1) {
                privilege.setGrantOption((Boolean)value);
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            int col = this.getNumber(column);
            Privilege p = (Privilege)ColumnsPermissionsDialogOracle.this.containerListPrivileges.get(row);
            if (col == 0) {
                return ((String)p.getObject()).trim();
            }
            if (col == 1) {
                return new Boolean(p.grantOption);
            }
            return "";
        }
    }
}

