/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_TableView;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.relational.ViewIndexSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.undo.relational.TableViewUpdateEdit;
import oracle.dbtools.crest.model.design.undo.relational.memento.ViewIndexMemento;
import oracle.dbtools.crest.model.designrules.DRViewCaseType;
import oracle.dbtools.crest.model.designrules.DRViewMaxNameLength;
import oracle.dbtools.crest.model.designrules.DRViewValidCharacters;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.IndexesCellRenderer;
import oracle.dbtools.crest.swingui.editor.TFCellEditor;
import oracle.dbtools.crest.swingui.editor.relational.FKColumnsCellEditor;
import oracle.dbtools.crest.swingui.editor.relational.FKColumnsTableModel;
import oracle.dbtools.crest.swingui.editor.relational.FKTableModel;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.relational.ForeignKeyPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.editor.relational.PKViewColumnsPanel;
import oracle.dbtools.crest.swingui.editor.relational.UKViewColumnsPanel;
import oracle.dbtools.crest.swingui.editor.relational.ViewIndexesTable;
import oracle.dbtools.crest.swingui.editor.relational.ViewUniqueKeysTableModel;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QBUtils;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QueryBuilderPanel;
import oracle.dbtools.crest.swingui.editor.viewbuilder.ViewBuilder;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.DMSQLQueryTester;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.ResultTesterComponent;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.TreeUtils;
import oracle.dbtools.crest.util.gui.swing.LNComboTableCellRenderer;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.db.DatabaseConnections;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class TableViewPropertiesDialogEx
extends AbstractPropertiesDialog {
    private static final String FOREIGN_KEY_TAB_NAME = Messages.getString("TablePropertiesDialogEx.ForeignKeys");
    private static final String UNIQUE_KEYS_TAB_NAME = Messages.getString("TablePropertiesDialogEx.UniqueConstraints");
    private static final String PRIMARY_KEY_TAB_NAME = Messages.getString("TablePropertiesDialogEx.PrimaryKeyTabTitle");
    private static final String NAME = Messages.getString("TablePropertiesDialogEx.Name");
    private static final String ORDS_TAB_NAME = Messages.getString("SchemaPropertiesDialogEx.ORDS");
    private TableView tableView;
    private TableView oldTableView;
    private JButton btnQueryBuilder;
    private JComboBox cbBaseOnStructuredType;
    private JDialog builder;
    private StructuredType st_type;
    private JPanel pnElementComments;
    private JTable tbElements;
    private List lsElements;
    private JCheckBox chTypeSubst;
    private JTextField tfOIDColumns;
    private JTree tree;
    private JComboBox cbSchemaObject;
    private JCheckBox chIncludeSchemaNameInQuery;
    private JCheckBox chAutoJoin;
    private JComboBox cbSubViews;
    private JButton btnTestQuery;
    private int currentElement;
    private JCheckBox chMarkGenerate;
    private RSyntaxTextArea taColumnComments;
    private RSyntaxTextArea taColumnNotes;
    private RSyntaxTextArea taColumnCommentsInRDBMS;
    private JCheckBox chbDeprecated;
    private JCheckBox chbPK;
    private JCheckBox chbFK;
    private JCheckBox chbMandatory;
    private ActionListener chbPKActionListener;
    private JPanel pnPrimaryKey;
    private JTextField tfPrimaryKeyName;
    private PKViewColumnsPanel primaryKeyColumnsPanel;
    private RSyntaxTextArea taPrimaryKeyNotes;
    private RSyntaxTextArea taPrimaryKeyComments;
    private ViewIndex primaryKey;
    private JCheckBox chPrimaryKeyEngineer;
    private JCheckBox chPrimaryKeyGenerate;
    private JCheckBox chbPKDeprecated;
    private JButton btnPKRemove;
    private List<ViewIndex> allIndexesList;
    private List<ViewIndex> indexesForUpdate;
    private List<ViewIndex> uniqueKeys;
    private JPanel pnUniqueKeys;
    private JTable tbUniqueKeys;
    private UKViewColumnsPanel uniqueKeysColumnsPanel;
    private RSyntaxTextArea taUniqueKeyNotes;
    private RSyntaxTextArea taUniqueKeyComments;
    private ViewIndex selectedUniqueKey;
    private JPanel pnForeignKeys;
    private List<ViewIndex> foreignKeys;
    private JTable tbForeignKeys;
    private List<FKIndexAssociation.FKMemento> fkList;
    private JButton btnFKProperties;
    private JButton btnFKRemove;
    private RSyntaxTextArea taFKComments;
    private RSyntaxTextArea taFKNotes;
    private JCheckBox chFKMandatory;
    private JCheckBox chFKTransferable;
    private JCheckBox chFKInArc;
    private FKTableModel fkModel;
    private FKColumnsTableModel fkColumnsTableModel;
    private FKColumnsCellEditor fkColumnsCellEditor;
    private JComboBox cbReferencedTable;
    private JComboBox cbReferencedConstraint;
    private FKIndexAssociation.FKMemento selectedFK;
    private boolean fkPropertiesEnabled;
    private List<FKIndexAssociation.FKMemento> fkListForUpdate = new ArrayList<FKIndexAssociation.FKMemento>();
    private List<FKIndexAssociation.FKMemento> fkListForCreate = new ArrayList<FKIndexAssociation.FKMemento>();
    private List<FKIndexAssociation.FKMemento> fkListForRemove = new ArrayList<FKIndexAssociation.FKMemento>();
    private boolean initializingSelectedFK;
    private JTable tbForeignKeyColumnsTable;
    private Set<FKIndexAssociation.FKMemento> dirtyMementos = new HashSet<FKIndexAssociation.FKMemento>();
    private boolean stealthChange = false;
    private boolean firstInit = true;
    private static FKMementoNameComparator FKMEMENTO_COMARATOR = new FKMementoNameComparator();
    private JPanel pnORDS;
    private JCheckBox chbORDSEnable;
    private JCheckBox chbORDSAuth;
    private JTextField tfORDSAlias;
    private JPanel pnQuery;
    private RSyntaxTextArea taQueryText;
    private String savedUserDefinedSQL = "";

    public TableViewPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public TableViewPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    @Override
    protected int getMinimumHeight() {
        return 500;
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableViewPropertiesDialogEx.ViewProperties");
    }

    private List getStructuredTypes() {
        ArrayList<StructuredType> result = new ArrayList<StructuredType>();
        Iterator it = this.tableView.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (!st.isInstantiable()) continue;
            result.add(st);
        }
        return result;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof TableView) {
            object.updateFromRemoteObject(false);
            this.oldTableView = (TableView)object;
            DesignPartView dpv = this.getAppView().getCurrentDPV();
            if (dpv != null && dpv.getDesignPart() != object.getDesignPart() || dpv == null) {
                dpv = object.getDesignPart().getMainView();
            }
            this.tableView = new TableView(this.oldTableView.getDesignPart());
            this.oldTableView.backupTo(this.tableView);
            this.oldTableView.backupFKeysTO(this.tableView, dpv);
            this.initDefaults();
            this.fillComboItems(this.getStructuredTypes().toArray(), this.cbBaseOnStructuredType, true);
            this.cbBaseOnStructuredType.setSelectedItem(this.tableView.getBasedOnStructuredType());
            if (this.tableView.isBST()) {
                this.st_type = this.tableView.getBasedOnStructuredType();
                this.tfOIDColumns.setText(this.tableView.getOidText());
            }
            this.chTypeSubst.setSelected(this.tableView.isAllowTypeSubstitution());
            if (!this.tableView.isBST() || this.tableView.isBST() && this.tableView.getSubTypeSubstitutions().size() > 0) {
                this.chTypeSubst.setEnabled(false);
            }
            this.enablePanels(this.st_type != null);
            this.savedUserDefinedSQL = this.tableView.getUserDefinedSQL();
            this.taQueryText.setText(this.savedUserDefinedSQL);
            this.taQueryText.setCaretPosition(0);
            this.updateElementsList();
            this.enableQueryPanelFields(this.isEditable());
            this.chIncludeSchemaNameInQuery.setSelected(this.tableView.includeSchemaNameInQuery());
            if (this.firstInit) {
                this.firstInit = false;
                FKIndexAssociation[] fkeys = this.tableView.getFKAssociations();
                for (int i = 0; i < fkeys.length; ++i) {
                    if (fkeys[i].isDialogVisible()) {
                        this.fkList.add(((ForeignKeyPropertiesDialogEx)fkeys[i].getPropertiesDialog()).getFKMemento());
                        continue;
                    }
                    this.fkList.add(fkeys[i].getFKMemento(dpv));
                }
                Collections.sort(this.fkList, FKMEMENTO_COMARATOR);
            }
            this.addIndexes((ViewIndex[])this.tableView.getKeys(), this.tableView);
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.initPrimaryKeyProperties();
            this.initSelectedUniqueKeyProperties();
            this.taBeforeDrop.setText(this.tableView.getBeforeDrop());
            this.taBeforeCreate.setText(this.tableView.getBeforeCreate());
            this.taAfterCreate.setText(this.tableView.getAfterCreate());
            this.taEndOfScript.setText(this.tableView.getEndOfScript());
            this.chGenerateScript.setSelected(this.tableView.getShouldGenerateScript());
            this.taBeforeDrop.setCaretPosition(0);
            this.taBeforeCreate.setCaretPosition(0);
            this.taAfterCreate.setCaretPosition(0);
            this.taEndOfScript.setCaretPosition(0);
            this.fillComboItems(((RelationalDesign)this.tableView.getDesignPart()).getSchemaObjectSet().toArray(), this.cbSchemaObject, true);
            this.cbSchemaObject.setSelectedItem(this.tableView.getSchemaObject());
            String useObjectsFrom = this.tableView.getUseObjectsOnlyFrom();
            DesignPartView usedDPV = null;
            this.cbSubViews.addItem(this.tableView.getDesignPart().getMainView());
            Iterator svit = this.tableView.getDesignPart().getDesignSubviews().iterator();
            while (svit.hasNext()) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)svit.next();
                DesignPartView designPartView = ph.getDesignPartView();
                this.cbSubViews.addItem(designPartView);
                if (useObjectsFrom.length() <= 0 || !designPartView.getDPVId().equalsIgnoreCase(useObjectsFrom)) continue;
                usedDPV = designPartView;
            }
            if (usedDPV != null) {
                this.cbSubViews.setSelectedItem(usedDPV);
            }
            CompareTreeNavigationDesign treeDesign = new CompareTreeNavigationDesign(new ImpA_TableView(this.tableView, null));
            ImpactTreeRenderer renderer = new ImpactTreeRenderer();
            this.tree.setModel(treeDesign);
            this.tree.setCellRenderer(renderer);
            this.initDynamicProperties();
            this.chMarkGenerate.setSelected(this.tableView.isMarkedGenerate());
            this.chbDeprecated.setSelected(this.tableView.isDeprecated());
            this.chbORDSEnable.setSelected(this.tableView.isORDSEnable());
            this.chbORDSAuth.setSelected(this.tableView.isORDSAuth());
            this.tfORDSAlias.setText(this.tableView.getORDSAliasNotEmpty());
        }
    }

    private void updateElementsList() {
        this.currentElement = -1;
        this.taColumnComments.setText("");
        this.taColumnComments.setEnabled(false);
        this.taColumnCommentsInRDBMS.setText("");
        this.taColumnCommentsInRDBMS.setEnabled(false);
        this.taColumnNotes.setText("");
        this.taColumnNotes.setEnabled(false);
        FKElement[] elements = (FKElement[])this.tableView.getElements();
        List<FKElement> tempList = Arrays.asList(elements);
        for (int i = this.lsElements.size() - 1; i >= 0; --i) {
            ElementHelper helper = (ElementHelper)this.lsElements.get(i);
            if (tempList.contains(helper.getElement())) continue;
            this.lsElements.remove(i);
        }
        int k = -1;
        for (AbstractViewElement abstractViewElement : tempList) {
            boolean found = false;
            for (int i = ++k; i < this.lsElements.size(); ++i) {
                ElementHelper helper = (ElementHelper)this.lsElements.get(i);
                if (helper.getElement() != abstractViewElement) continue;
                if (i > k) {
                    this.lsElements.remove(i);
                    this.lsElements.add(k, helper);
                }
                found = true;
                break;
            }
            if (found) continue;
            ElementHelper helper = new ElementHelper(abstractViewElement);
            this.lsElements.add(k, helper);
        }
        this.tbElements.updateUI();
        this.tbElements.clearSelection();
    }

    @Override
    protected void showComponent(Component component) {
        this.setPreviousSelectedElement();
        String componentName = component.getName();
        if (componentName.equals(PRIMARY_KEY_TAB_NAME)) {
            this.primaryKeyColumnsPanel.init(this.getColumnList());
        } else if (componentName.equals(UNIQUE_KEYS_TAB_NAME)) {
            if (!this.selectFirstRow(this.tbUniqueKeys, this.uniqueKeys)) {
                this.uniqueKeysColumnsPanel.init(this.getColumnList());
            }
        } else if (componentName.equals(FOREIGN_KEY_TAB_NAME)) {
            this.selectFirstRow(this.tbForeignKeys, this.fkList);
        }
        super.showComponent(component);
    }

    protected boolean selectFirstRow(JTable table, List tableContents) {
        if (table.getSelectedRow() == -1 && tableContents.size() > 0) {
            table.updateUI();
            table.changeSelection(0, 1, false, false);
            table.requestFocus();
            return true;
        }
        return false;
    }

    @Override
    protected void setProperties() {
        TableViewPropertiesDialogEx.stopCellEditing(this.tbElements);
        TableViewPropertiesDialogEx.stopCellEditing(this.tbForeignKeys);
        TableViewPropertiesDialogEx.stopCellEditing(this.tbUniqueKeys);
        this.tableView.setSchemaObject((SchemaObject)this.cbSchemaObject.getSelectedItem());
        this.tableView.setName(this.tfName.getText());
        this.tableView.setComment(this.taComments.getText());
        this.tableView.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.tableView.setNotes(this.taNotes.getText());
        this.tableView.setBasedOnStructuredType((StructuredType)this.cbBaseOnStructuredType.getSelectedItem());
        if (this.tableView.isBST()) {
            this.tableView.setOidText(this.tfOIDColumns.getText().trim());
        }
        this.tableView.setAllowTypeSubstitution(this.chTypeSubst.isSelected());
        this.tableView.setIncludeSchemaNameInQuery(this.chIncludeSchemaNameInQuery.isSelected());
        if (this.cbSubViews.getSelectedIndex() > 0) {
            this.tableView.setUseObjectsOnlyFrom(((DesignPartView)this.cbSubViews.getSelectedItem()).getDPVId());
        } else {
            this.tableView.setUseObjectsOnlyFrom("");
        }
        this.indexesForUpdate = new ArrayList<ViewIndex>(this.allIndexesList);
        ViewIndex[] inds = (ViewIndex[])this.tableView.getKeySet().toArray();
        for (int i = 0; i < inds.length; ++i) {
            ViewIndex ind = inds[i];
            if (this.allIndexesList.contains(ind) || this.foreignKeys.contains(ind) || ind.isOidKey() || ind.isFK()) continue;
            ContainedObject[] cols = ind.getElements();
            for (int k = 0; k < cols.length; ++k) {
                ContainedObject col = cols[k];
                if (!(col instanceof AbstractViewElement)) continue;
                ind.remove((AbstractViewElement)col);
            }
            this.tableView.remove(ind);
            this.indexesForUpdate.remove(ind);
        }
        for (ViewIndex index : this.allIndexesList) {
            if (this.tableView.getKeySet().contains(index)) continue;
            this.tableView.add(index);
            index.getIndexMemento().setID(index.getObjectID());
        }
        for (ViewIndex index : this.indexesForUpdate) {
            index.restoreFromMemento((ViewIndexMemento)index.getIndexMemento(false));
        }
        String queryText = this.taQueryText.getText();
        this.tableView.setUserDefinedSQL(queryText);
        if (this.queryTextChanged(queryText)) {
            this.tableView.setParsed(false);
            boolean failed = false;
            try {
                QueryBuilder queryBuilder = new QueryBuilder(true);
                QBUtils.initMetadata(this.tableView.getDesignPart(), queryBuilder, null, false);
                this.tableView.parseOlderStyleView(queryBuilder, null);
            }
            catch (QueryBuilderException e) {
                e.printStackTrace();
                failed = true;
            }
            if (!failed) {
                this.tableView.setParsed(true);
                if (this.applyMode) {
                    this.updateElementsList();
                }
            }
        }
        this.setMeasurements(this.tableView);
        this.setChangeRequests(this.tableView);
        this.setResponsibleParties(this.tableView);
        this.setDocuments(this.tableView);
        this.tableView.setBeforeDrop(this.taBeforeDrop.getText());
        this.tableView.setBeforeCreate(this.taBeforeCreate.getText());
        this.tableView.setAfterCreate(this.taAfterCreate.getText());
        this.tableView.setEndOfScript(this.taEndOfScript.getText());
        this.tableView.setShouldGenerateScript(this.chGenerateScript.isSelected());
        for (ColumnView cv : this.tableView.getElementsCollection()) {
            String name = cv.getPresentationName();
            if (name.equals(cv.getName())) continue;
            cv.setName(name);
        }
        this.checkNamingOptions();
        TableViewPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.tableView.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.tableView.setProperty(dp.getName(), dp.getValue());
        }
        this.tableView.setMarkedGenerate(this.chMarkGenerate.isSelected());
        this.tableView.setDeprecated(this.chbDeprecated.isSelected());
        this.tableView.setORDSEnable(this.chbORDSEnable.isSelected());
        this.tableView.setORDSAuth(this.chbORDSAuth.isSelected());
        this.tableView.setORDSAlias(this.tfORDSAlias.getText());
        this.applyElementsComments();
        ArrayList<ViewIndex> orderedIndexesList = new ArrayList<ViewIndex>();
        if (this.primaryKey != null) {
            orderedIndexesList.add(this.primaryKey);
        }
        orderedIndexesList.addAll(this.uniqueKeys);
        ((ViewIndexSet)this.tableView.getKeySet()).addAndApplyOrderFromList(orderedIndexesList);
        this.savePrimaryKeyProperties();
        if (this.primaryKey != null) {
            this.primaryKey.restoreFromMemento((ViewIndexMemento)this.primaryKey.getIndexMemento(false));
        }
        this.fkListForCreate.removeAll(this.fkListForRemove);
        this.fkListForUpdate = new ArrayList<FKIndexAssociation.FKMemento>(this.fkList);
        this.fkListForUpdate.removeAll(this.fkListForCreate);
        this.fkListForUpdate.removeAll(this.fkListForRemove);
        if (this.oldTableView.showForFirstTime()) {
            ((RelationalDesign)this.oldTableView.getDesignPart()).postTableViewCreateEdit(this.oldTableView);
        }
        if (this.stealthChange || !this.oldTableView.getAppView().getXMLTransformationManager().equal(this.oldTableView, this.tableView, false) || this.fkChanges()) {
            this.applyTableViewUpdates();
        } else {
            this.oldTableView.setMarkedGenerate(this.chMarkGenerate.isSelected());
            Iterator it = this.tableView.getKeySet().iterator();
            while (it.hasNext()) {
                ViewIndex index = (ViewIndex)it.next();
                KeyObject origIndex = this.oldTableView.getIndexByID(index.getObjectID());
                if (origIndex == null) continue;
                origIndex.setMarkedGenerate(index.isMarkedGenerate());
            }
        }
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
        this.dirtyMementos.clear();
        this.stealthChange = false;
        this.oldTableView.updateRemoteObjectListeners();
    }

    private boolean fkChanges() {
        return !this.fkListForUpdate.isEmpty() || !this.fkListForCreate.isEmpty() || !this.fkListForRemove.isEmpty();
    }

    private void applyTableViewUpdates() {
        TableViewUpdateEdit edit = new TableViewUpdateEdit(this.oldTableView, this.tableView, this.indexesForUpdate, this.fkListForUpdate, this.fkListForCreate, this.fkListForRemove);
        this.oldTableView.getDesignPart().postUndoableEdit(edit);
        this.oldTableView.getDesignPart().getUndoManager().setLocked(true);
        try {
            edit.applyUpdates();
        }
        finally {
            this.oldTableView.getDesignPart().getUndoManager().setLocked(false);
        }
    }

    protected void checkNamingOptions() {
        this.checkDesignRule(new DRViewMaxNameLength(), this.tableView);
        this.checkDesignRule(new DRViewCaseType(), this.tableView);
        this.checkDesignRule(new DRViewValidCharacters(), this.tableView);
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getElementsPanel());
        this.addToTree(root, this.getQueryPanel());
        this.addToTree(root, this.getPrimaryKeyPanel());
        this.addToTree(root, this.getUniqueKeysPanel());
        this.addToTree(root, this.getForeignKeysPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getCommentsInRDBMSPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getImpactAnalysisPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getScriptPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getORDSPanel());
        this.addToTree(root, this.getSummaryPanel());
        this.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath oldLeadSelectionPath = e.getOldLeadSelectionPath();
                if (oldLeadSelectionPath != null) {
                    String selectedTabName = ((JPanel)((DefaultMutableTreeNode)oldLeadSelectionPath.getLastPathComponent()).getUserObject()).getName();
                    if (selectedTabName.equals(UNIQUE_KEYS_TAB_NAME)) {
                        TableViewPropertiesDialogEx.this.saveSelectedUniqueKeyProperties();
                    }
                    String newSelectedTabName = ((JPanel)((DefaultMutableTreeNode)e.getNewLeadSelectionPath().getLastPathComponent()).getUserObject()).getName();
                    if (TableViewPropertiesDialogEx.this.isEditable() && newSelectedTabName.equals(PRIMARY_KEY_TAB_NAME)) {
                        TableViewPropertiesDialogEx.this.btnPKRemove.setEnabled(TableViewPropertiesDialogEx.this.primaryKey != null);
                    }
                }
            }
        });
    }

    @Override
    protected String getHelpIndex() {
        return "VIEW_PROPERTIES_DIALOG";
    }

    public JDialog getBuilder() {
        if (this.builder == null) {
            this.builder = new ViewBuilder(this.tableView).getDialog(this.getAppView());
            return this.builder;
        }
        return this.builder;
    }

    private void enablePanels(boolean enable) {
    }

    @Override
    protected int getMinimumTreeWidth() {
        return 210;
    }

    private void initGeneral() {
        JLabel lbBaseOnStructuredType = new JLabel(LB_BASED_ON_STRUCTURED_TYPE);
        lbBaseOnStructuredType.setPreferredSize(this.getDefaultSize());
        this.cbBaseOnStructuredType = new JComboBox();
        this.cbBaseOnStructuredType.setPreferredSize(this.getDefaultSize());
        this.cbBaseOnStructuredType.setMaximumRowCount(8);
        this.cbBaseOnStructuredType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = TableViewPropertiesDialogEx.this.cbBaseOnStructuredType.getSelectedItem();
                TableViewPropertiesDialogEx.this.st_type = (StructuredType)obj;
                if (TableViewPropertiesDialogEx.this.btnQueryBuilder != null) {
                    TableViewPropertiesDialogEx.this.btnQueryBuilder.setEnabled(TableViewPropertiesDialogEx.this.isEditable());
                }
                TableViewPropertiesDialogEx.this.enablePanels(TableViewPropertiesDialogEx.this.st_type != null);
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbBaseOnStructuredType, this.cbBaseOnStructuredType));
        JLabel lbIdentValue = new JLabel(LB_OID_COLUMNS);
        lbIdentValue.setPreferredSize(this.getDefaultSize());
        this.tfOIDColumns = new JTextField();
        this.tfOIDColumns.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbIdentValue, this.tfOIDColumns));
        JLabel lbSchemaObject = new JLabel(SCHEMA);
        lbSchemaObject.setPreferredSize(this.getDefaultSize());
        this.cbSchemaObject = new JComboBox();
        this.cbSchemaObject.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSchemaObject, this.cbSchemaObject));
        JLabel lbTypeSubst = new JLabel(Messages.getString("TableViewPropertiesDialogEx.AllowTypeSubstitution"));
        lbTypeSubst.setPreferredSize(this.getDefaultSize());
        this.chTypeSubst = new JCheckBox();
        this.chTypeSubst.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbTypeSubst, this.chTypeSubst));
        JLabel lbMarkGenerate = new JLabel(Messages.getString("TablePropertiesDialogEx.GenerateInDDL"));
        lbMarkGenerate.setPreferredSize(this.getDefaultSize());
        this.chMarkGenerate = new JCheckBox();
        this.chMarkGenerate.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbMarkGenerate, this.chMarkGenerate));
        JLabel lbDeprecated = new JLabel(Messages.getString("TablePropertiesDialogEx.Deprecated"));
        lbDeprecated.setPreferredSize(this.getDefaultSize());
        this.chbDeprecated = new JCheckBox();
        this.chbDeprecated.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDeprecated, this.chbDeprecated));
    }

    private Database getDatabase() {
        Object[] sourceStamps = this.tableView.getRelationalModel().getImportConnectionStamps().toArray();
        for (int i = 0; i < sourceStamps.length; ++i) {
            DBConnectionStamp dbStamp = (DBConnectionStamp)sourceStamps[i];
            try {
                Database db = DatabaseConnections.getInstance().getDatabase(dbStamp.getConnName());
                if (db == null) continue;
                return db;
            }
            catch (DBException e) {
                // empty catch block
            }
        }
        return null;
    }

    private void setElementSelected() {
        int row;
        if (this.currentElement > -1) {
            this.setPreviousSelectedElement();
        }
        if ((row = this.tbElements.getSelectedRow()) != -1 && this.lsElements.size() > 0 && row < this.lsElements.size()) {
            this.currentElement = row;
            ElementHelper helper = (ElementHelper)this.lsElements.get(row);
            this.chbMandatory.setSelected(helper.isMandatory());
            this.chbPK.setSelected(helper.isPKElement());
            this.chbPK.setEnabled(true);
            this.chbFK.setSelected(helper.isFKElement());
            this.taColumnComments.setText(helper.getComments());
            this.taColumnComments.setEnabled(true);
            this.taColumnCommentsInRDBMS.setText(helper.getCommentsInRDBMS());
            this.taColumnCommentsInRDBMS.setEnabled(true);
            this.taColumnNotes.setText(helper.getNotes());
            this.taColumnNotes.setEnabled(true);
        }
    }

    protected JPanel getElementsPanel() {
        if (this.pnElementComments == null) {
            this.currentElement = -1;
            this.pnElementComments = this.createPage(PANEL_COLUMNS);
            this.tbElements = new JTable(new ElementsModel());
            this.tbElements.setSelectionMode(0);
            this.tbElements.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TableViewPropertiesDialogEx.this.setElementSelected();
                }
            });
            this.tbElements.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (TableViewPropertiesDialogEx.this.lsElements.isEmpty()) {
                        TableViewPropertiesDialogEx.this.chbPK.setEnabled(false);
                        TableViewPropertiesDialogEx.this.taColumnComments.setText("");
                        TableViewPropertiesDialogEx.this.taColumnComments.setEnabled(false);
                        TableViewPropertiesDialogEx.this.taColumnCommentsInRDBMS.setText("");
                        TableViewPropertiesDialogEx.this.taColumnCommentsInRDBMS.setEnabled(false);
                        TableViewPropertiesDialogEx.this.taColumnNotes.setText("");
                        TableViewPropertiesDialogEx.this.taColumnNotes.setEnabled(false);
                    } else {
                        TableViewPropertiesDialogEx.this.taColumnComments.setEnabled(true);
                        TableViewPropertiesDialogEx.this.taColumnCommentsInRDBMS.setEnabled(true);
                        TableViewPropertiesDialogEx.this.taColumnNotes.setEnabled(true);
                        TableViewPropertiesDialogEx.this.setElementSelected();
                    }
                }
            });
            this.lsElements = new ArrayList();
            JScrollPane sp = new JScrollPane(this.tbElements);
            sp.setPreferredSize(new Dimension(200, 200));
            this.pnElementComments.add((Component)sp, "North");
            JPanel jpanel = new JPanel(new BorderLayout());
            JPanel pnKeys = new JPanel(new GridLayout(0, 1));
            pnKeys.setBorder(BorderFactory.createTitledBorder(""));
            pnKeys.add(new JPanel());
            jpanel.add((Component)pnKeys, "North");
            this.chbPK = new JCheckBox(Messages.getString("TablePropertiesDialogEx.PK"));
            this.chbPK.setEnabled(false);
            this.chbPKActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TableViewPropertiesDialogEx.this.currentElement > -1) {
                        ElementHelper helper = (ElementHelper)TableViewPropertiesDialogEx.this.lsElements.get(TableViewPropertiesDialogEx.this.currentElement);
                        AbstractViewElement selectedColumn = helper.element;
                        if (selectedColumn != null) {
                            TableViewPropertiesDialogEx.this.updatePKStatus(selectedColumn, TableViewPropertiesDialogEx.this.chbPK.isSelected(), TableViewPropertiesDialogEx.this.tfName.getText().trim(), "", null);
                            if (TableViewPropertiesDialogEx.this.chbPK.isSelected()) {
                                TableViewPropertiesDialogEx.this.chbMandatory.setSelected(true);
                                TableViewPropertiesDialogEx.this.chbMandatory.setEnabled(false);
                            }
                        }
                    }
                }
            };
            this.chbPK.addActionListener(this.chbPKActionListener);
            this.chbFK = new JCheckBox(Messages.getString("TablePropertiesDialogEx.FK"));
            this.chbFK.setEnabled(false);
            this.chbMandatory = new JCheckBox(Messages.getString("TablePropertiesDialogEx.Mandatory"));
            this.chbMandatory.setEnabled(false);
            JPanel pn1 = new JPanel(new GridLayout(1, 0));
            pn1.add(this.chbPK);
            pn1.add(this.chbFK);
            pn1.add(this.chbMandatory);
            JLabel lbEmpty = new JLabel("");
            Dimension dim = new Dimension(60, 20);
            lbEmpty.setPreferredSize(dim);
            pnKeys.add(this.createRow(lbEmpty, pn1));
            pnKeys.add(new JPanel());
            JTabbedPane tpComments = new JTabbedPane();
            this.taColumnComments = new RSyntaxTextArea();
            this.taColumnComments.setLineWrap(true);
            this.taColumnComments.setWrapStyleWord(true);
            this.taColumnComments.setBorder(null);
            this.taColumnComments.setAntiAliasingEnabled(true);
            this.taColumnComments.setFont(this.tfName.getFont());
            this.taColumnNotes = new RSyntaxTextArea();
            this.taColumnNotes.setLineWrap(true);
            this.taColumnNotes.setWrapStyleWord(true);
            this.taColumnNotes.setBorder(null);
            this.taColumnNotes.setAntiAliasingEnabled(true);
            this.taColumnNotes.setFont(this.tfName.getFont());
            this.taColumnCommentsInRDBMS = new RSyntaxTextArea();
            this.taColumnCommentsInRDBMS.setLineWrap(true);
            this.taColumnCommentsInRDBMS.setWrapStyleWord(true);
            this.taColumnCommentsInRDBMS.setBorder(null);
            this.taColumnCommentsInRDBMS.setAntiAliasingEnabled(true);
            this.taColumnCommentsInRDBMS.setFont(this.tfName.getFont());
            tpComments.addTab(Messages.getString("TableViewPropertiesDialogEx.Comments"), new JScrollPane((Component)this.taColumnComments));
            tpComments.addTab(Messages.getString("TableViewPropertiesDialogEx.CommentsInRDBMS"), new JScrollPane((Component)this.taColumnCommentsInRDBMS));
            tpComments.addTab(Messages.getString("TableViewPropertiesDialogEx.Notes"), new JScrollPane((Component)this.taColumnNotes));
            jpanel.add((Component)tpComments, "Center");
            this.pnElementComments.add((Component)jpanel, "Center");
        }
        return this.pnElementComments;
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel pnImpact = this.createPage(Messages.getString("TableViewPropertiesDialogEx.ImpactAnalysis"));
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                Object last;
                if (e.getClickCount() == 2 && (last = (path = TableViewPropertiesDialogEx.this.tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject obj = ((ModelIdObjectSelection)last).getObject();
                    if (obj != null) {
                        e.consume();
                        obj.showPropertyDialog();
                    } else {
                        if (TableViewPropertiesDialogEx.this.tree.isCollapsed(path)) {
                            TableViewPropertiesDialogEx.this.tree.expandPath(path);
                        } else {
                            TableViewPropertiesDialogEx.this.tree.collapsePath(path);
                        }
                        e.consume();
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        pnImpact.add((Component)scrollPane, "Center");
        return pnImpact;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private void setPreviousSelectedElement() {
        if (this.currentElement > -1) {
            ElementHelper helper = (ElementHelper)this.lsElements.get(this.currentElement);
            helper.setPKElement(this.chbPK.isSelected());
            helper.setComments(this.taColumnComments.getText());
            helper.setCommentsInRDBMS(this.taColumnCommentsInRDBMS.getText());
            helper.setNotes(this.taColumnNotes.getText());
        }
    }

    private void applyElementsComments() {
        this.setPreviousSelectedElement();
        for (ElementHelper helper : this.lsElements) {
            helper.applyComments();
            helper.applyCommentsInRDBMS();
            helper.applyNotes();
        }
    }

    protected JPanel getPrimaryKeyPanel() {
        if (this.pnPrimaryKey == null) {
            this.pnPrimaryKey = this.createPage(PRIMARY_KEY_TAB_NAME);
            this.allIndexesList = new ArrayList<ViewIndex>();
            JPanel primaryKeysPanel = new JPanel(new BorderLayout(10, 10));
            primaryKeysPanel.add(this.createPrimaryKeyContentsPanel());
            primaryKeysPanel.add((Component)this.createPrimaryKeyToolbarPanel(this.primaryKey), "North");
            this.pnPrimaryKey.add(primaryKeysPanel);
        }
        return this.pnPrimaryKey;
    }

    private JPanel createPrimaryKeyContentsPanel() {
        JPanel pnMain = new JPanel(new BorderLayout());
        boolean showDesc = this.getDesignObject().getDesignPart().getSelectedRDBMSType() == StorageDesignSqlServerv2k.RDBMS_TYPE || this.getDesignObject().getDesignPart().getSelectedRDBMSType() == StorageDesignSqlServerv2k5.RDBMS_TYPE;
        this.primaryKeyColumnsPanel = new PKViewColumnsPanel((ViewIndex)((TableView)this.getDesignObject()).getPK(), this.isEditable(), this.getPreferredIconSize(), showDesc){

            @Override
            public void onAddColumn(FKElement column) {
                String tableName = TableViewPropertiesDialogEx.this.tfName.getText().trim();
                String tableAbbreviation = TableViewPropertiesDialogEx.this.tableView.getAbbreviation();
                String primaryKeyName = TableViewPropertiesDialogEx.this.tfPrimaryKeyName.getText();
                if (TableViewPropertiesDialogEx.this.primaryKey == null) {
                    if (StringUtilities.isNotEmpty(primaryKeyName)) {
                        TableViewPropertiesDialogEx.this.primaryKey = TableViewPropertiesDialogEx.this.createAndAddIndex(AbstractEditorConstants.PRIMARY_CONSTRAINT, primaryKeyName);
                    } else {
                        TableViewPropertiesDialogEx.this.primaryKey = TableViewPropertiesDialogEx.this.createAndAddIndex(AbstractEditorConstants.PRIMARY_CONSTRAINT, tableName, tableAbbreviation);
                        TableViewPropertiesDialogEx.this.tfPrimaryKeyName.setText(TableViewPropertiesDialogEx.this.primaryKey.getName());
                    }
                }
                TableViewPropertiesDialogEx.this.updatePKStatus(column, true, tableName, tableAbbreviation, TableViewPropertiesDialogEx.this.primaryKey.getName());
                TableViewPropertiesDialogEx.this.updatePKCheckBox(column, true);
            }

            @Override
            public void onRemoveColumn(FKElement column) {
                TableViewPropertiesDialogEx.this.updatePKStatus(column, false, TableViewPropertiesDialogEx.this.tableView.getName(), TableViewPropertiesDialogEx.this.tableView.getAbbreviation(), null);
                TableViewPropertiesDialogEx.this.updatePKCheckBox(column, false);
            }
        };
        pnMain.add((Component)this.primaryKeyColumnsPanel, "North");
        JPanel checkBoxesPanel = new JPanel(new GridLayout(1, 0));
        this.chPrimaryKeyEngineer = new JCheckBox();
        this.chPrimaryKeyEngineer.setPreferredSize(this.getDefaultSize());
        this.chPrimaryKeyEngineer.setText(Messages.getString("TablePropertiesDialogEx.Engineer"));
        this.chPrimaryKeyEngineer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableViewPropertiesDialogEx.this.stealthChange = true;
            }
        });
        checkBoxesPanel.add(this.chPrimaryKeyEngineer);
        this.chPrimaryKeyGenerate = new JCheckBox();
        this.chPrimaryKeyGenerate.setPreferredSize(this.getDefaultSize());
        this.chPrimaryKeyGenerate.setText(Messages.getString("TablePropertiesDialogEx.Generate"));
        this.chPrimaryKeyGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableViewPropertiesDialogEx.this.stealthChange = true;
            }
        });
        checkBoxesPanel.add(this.chPrimaryKeyGenerate);
        this.chbPKDeprecated = new JCheckBox();
        this.chbPKDeprecated.setPreferredSize(this.getDefaultSize());
        this.chbPKDeprecated.setText(Messages.getString("TablePropertiesDialogEx.Deprecated"));
        this.chbPKDeprecated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableViewPropertiesDialogEx.this.stealthChange = true;
            }
        });
        checkBoxesPanel.add(this.chbPKDeprecated);
        this.taPrimaryKeyNotes = new RSyntaxTextArea();
        this.taPrimaryKeyNotes.setEditable(this.isEditable());
        this.taPrimaryKeyNotes.setLineWrap(true);
        this.taPrimaryKeyNotes.setWrapStyleWord(true);
        this.taPrimaryKeyNotes.setBorder(null);
        this.taPrimaryKeyNotes.setAntiAliasingEnabled(true);
        this.taPrimaryKeyNotes.setFont(this.tfName.getFont());
        this.taPrimaryKeyComments = new RSyntaxTextArea();
        this.taPrimaryKeyComments.setEditable(this.isEditable());
        this.taPrimaryKeyComments.setLineWrap(true);
        this.taPrimaryKeyComments.setWrapStyleWord(true);
        this.taPrimaryKeyComments.setBorder(null);
        this.taPrimaryKeyComments.setAntiAliasingEnabled(true);
        this.taPrimaryKeyComments.setFont(this.tfName.getFont());
        JPanel pnBottom = new JPanel(new BorderLayout());
        pnBottom.add(this.createNotesCommentsTabbedPane(this.taPrimaryKeyNotes, this.taPrimaryKeyComments, null, true));
        pnBottom.add((Component)checkBoxesPanel, "North");
        pnMain.add(pnBottom);
        JPanel pnContents = new JPanel(new BorderLayout());
        this.tfPrimaryKeyName = new JTextField();
        this.tfPrimaryKeyName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (TableViewPropertiesDialogEx.this.primaryKey != null) {
                    TableViewPropertiesDialogEx.this.primaryKey.setName(TableViewPropertiesDialogEx.this.tfPrimaryKeyName.getText());
                }
            }
        });
        this.addRowToPanel(pnContents, NAME, this.tfPrimaryKeyName, null, "North");
        pnContents.add(pnMain);
        return pnContents;
    }

    private ViewIndex createAndAddIndex(String indexState, String tableName, String tableAbbreviation) {
        String indexName = this.generateIndexName(indexState, tableName, tableAbbreviation);
        return this.createAndAddIndex(indexState, indexName);
    }

    private ViewIndex createAndAddIndex(String indexState, String indexName) {
        ViewIndex index = new ViewIndex(this.tableView.getDesignPart());
        index.setName(indexName);
        this.tableView.add(index);
        if (PRIMARY_CONSTRAINT.equals(indexState)) {
            index.setPK(true);
            this.addIndex(index);
        } else if (UNIQUE_CONSTRAINT.equals(indexState)) {
            index.setUnique(true);
            this.addIndex(index);
            TableViewPropertiesDialogEx.stopCellEditing(this.tbUniqueKeys);
            this.tbUniqueKeys.updateUI();
            this.tbUniqueKeys.changeSelection(this.uniqueKeys.size() - 1, 1, false, false);
            this.tbUniqueKeys.requestFocus();
        }
        return index;
    }

    private boolean hasInd_Name(Object[] objects, String name) {
        for (int i = 0; i < objects.length; ++i) {
            if (!(objects[i] instanceof DesignObject) || !((DesignObject)objects[i]).getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private String generateIndexName(String indexState, String tableName, String tableAbbreviation) {
        String indexName;
        if (PRIMARY_CONSTRAINT.equals(indexState)) {
            indexName = ApplyNamingStandards.createPK_Name(tableName, this.tableView.getDesign().getDesignLevelSettings().getNamingStandardRule(), this.tableView.getDesignPart().getName(), tableAbbreviation);
        } else {
            Object[] inds = this.uniqueKeys.toArray();
            int count = inds.length;
            String lastGeneratedIndexName = null;
            while (!(indexName = ApplyNamingStandards.createUK_Name(null, count, this.tableView.getDesign().getDesignLevelSettings().getNamingStandardRule(), this.tableView.getDesignPart().getName(), tableName, tableAbbreviation)).equals(lastGeneratedIndexName)) {
                lastGeneratedIndexName = indexName;
                ++count;
                if (this.hasInd_Name(inds, indexName)) continue;
            }
        }
        return indexName;
    }

    protected JPanel createPrimaryKeyToolbarPanel(ViewIndex primaryKey) {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        if (this.isEditable()) {
            this.btnPKRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.btnPKRemove.setToolTipText(BTN_REMOVE);
            this.btnPKRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableViewPropertiesDialogEx.this.deleteSelectedIndex(AbstractEditorConstants.PRIMARY_CONSTRAINT);
                }
            });
            this.btnPKRemove.setEnabled(false);
            toolBar.addSeparator();
            toolBar.add(this.btnPKRemove);
        }
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        buttonGeneral.add(toolBar);
        return buttonGeneral;
    }

    private void deleteSelectedIndex(String indexState) {
        this.deleteIndexes(indexState, false);
    }

    private void deleteIndexes(String indexState, boolean deleteAll) {
        if (PRIMARY_CONSTRAINT.equals(indexState)) {
            if (this.primaryKey != null) {
                for (int i = 0; i < this.lsElements.size(); ++i) {
                    ElementHelper helper = (ElementHelper)this.lsElements.get(i);
                    helper.setPKElement(false);
                }
                this.chbPK.setSelected(false);
                this.removeIndex(this.primaryKey);
                this.initPrimaryKeyProperties();
            }
        } else {
            TableViewPropertiesDialogEx.stopCellEditing(this.tbUniqueKeys);
            if (deleteAll) {
                for (ViewIndex index : this.uniqueKeys) {
                    this.removeIndex(index);
                }
            } else {
                this.removeIndex(this.uniqueKeys.get(this.tbUniqueKeys.getSelectedRow()));
            }
            this.tbUniqueKeys.clearSelection();
            this.tbUniqueKeys.updateUI();
        }
    }

    private void removeIndex(ViewIndex index) {
        this.allIndexesList.remove(index);
        if (index.isPK()) {
            this.primaryKey = null;
            this.btnPKRemove.setEnabled(false);
        } else if (index.isUnique()) {
            this.uniqueKeys.remove(index);
        }
    }

    private ViewIndex getPKIndex() {
        for (ViewIndex ind : this.allIndexesList) {
            if (!ind.isPK()) continue;
            return ind;
        }
        return null;
    }

    private void updatePKStatus(FKElement column, boolean belongstoPK, String tableName, String tableAbbreviation, String pkName) {
        ViewIndex ind;
        if (belongstoPK && column.isInOptionalFK()) {
            int result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("TablePropertiesDialogEx.TheColumnBelongsToOptionalFK"), Messages.getString("TablePropertiesDialogEx.ColumnInOptionalFK"), 0);
            if (result != 0) {
                return;
            }
            for (FKIndexAssociation fk : column.getAllFKs()) {
                if (fk.isMandatory()) continue;
                fk.setMandatory(true);
                fk.resetEdgeParams();
            }
        }
        if ((ind = this.getPKIndex()) == null && belongstoPK) {
            ind = this.createAndAddIndex(PRIMARY_CONSTRAINT, tableName, tableAbbreviation);
            if (!StringUtilities.isNotEmpty(pkName)) {
                pkName = ApplyNamingStandards.createPK_Name(tableName, this.tableView.getDesign().getDesignLevelSettings().getNamingStandardRule(), this.tableView.getDesignPart().getName(), tableAbbreviation);
            }
            ind.setName(pkName);
        }
        if (ind != null) {
            if (!belongstoPK) {
                ind.remove(column);
            } else {
                if (!ind.contains(column)) {
                    ind.add(column);
                }
                if (column.getNullsAllowed()) {
                    column.setNullsAllowed(false);
                }
            }
        }
        this.initPrimaryKeyProperties();
    }

    private void updatePKCheckBox(FKElement column, boolean isPK) {
        for (int i = 0; i < this.lsElements.size(); ++i) {
            ElementHelper helper = (ElementHelper)this.lsElements.get(i);
            if (helper.getElement() != column) continue;
            helper.setPKElement(isPK);
            if (this.tbElements.getSelectedRow() != i) break;
            this.chbPK.setSelected(isPK);
            break;
        }
    }

    protected JTabbedPane createNotesCommentsTabbedPane(RSyntaxTextArea taNotes, RSyntaxTextArea taComments, RSyntaxTextArea taCommentsInRDBMS) {
        return this.createNotesCommentsTabbedPane(taNotes, taComments, taCommentsInRDBMS, false);
    }

    protected JTabbedPane createNotesCommentsTabbedPane(RSyntaxTextArea taNotes, RSyntaxTextArea taComments, RSyntaxTextArea taCommentsInRDBMS, boolean enabled) {
        JTabbedPane tpNotesComments = new JTabbedPane();
        if (taNotes != null) {
            taNotes.setLineWrap(true);
            taNotes.setWrapStyleWord(true);
            tpNotesComments.addTab(Messages.getString("TablePropertiesDialogEx.Notes"), new JScrollPane((Component)taNotes));
        }
        if (taComments != null) {
            taComments.setLineWrap(true);
            taComments.setWrapStyleWord(true);
            tpNotesComments.addTab(Messages.getString("TablePropertiesDialogEx.Comments"), new JScrollPane((Component)taComments));
        }
        if (taCommentsInRDBMS != null) {
            taCommentsInRDBMS.setLineWrap(true);
            taCommentsInRDBMS.setWrapStyleWord(true);
            tpNotesComments.addTab(Messages.getString("TablePropertiesDialogEx.CommentsInRDBMS"), new JScrollPane((Component)taCommentsInRDBMS));
        }
        return tpNotesComments;
    }

    private void addIndex(ViewIndex index) {
        this.allIndexesList.add(index);
        if (index.isPK()) {
            this.primaryKey = index;
            if (this.isEditable()) {
                this.btnPKRemove.setEnabled(true);
            }
        } else if (index.isUnique()) {
            this.uniqueKeys.add(index);
        } else if (index.isFK()) {
            this.foreignKeys.add(index);
        }
    }

    private void addIndexes(ViewIndex[] indexes, TableView view) {
        for (ViewIndex index : indexes) {
            this.addIndex(index);
        }
    }

    private List<FKElement> getColumnList() {
        ArrayList<FKElement> list = new ArrayList<FKElement>();
        for (ElementHelper helper : this.lsElements) {
            list.add(helper.element);
        }
        return list;
    }

    private void initPrimaryKeyProperties() {
        if (this.primaryKey != null) {
            this.primaryKeyColumnsPanel.init(this.primaryKey, this.getColumnList());
            this.tfPrimaryKeyName.setText(this.primaryKey.getName());
            this.tfPrimaryKeyName.setEnabled(!this.primaryKey.isNameFixed());
            if (this.primaryKey.isNameFixed()) {
                this.tfPrimaryKeyName.setToolTipText(NAME_IS_FROZEN);
            } else {
                this.tfPrimaryKeyName.setToolTipText(null);
            }
            this.chPrimaryKeyEngineer.setSelected(this.primaryKey.getShouldEngineer());
            this.chPrimaryKeyGenerate.setSelected(this.primaryKey.isMarkedGenerate());
            this.chbPKDeprecated.setSelected(this.primaryKey.isDeprecated());
            this.taPrimaryKeyNotes.setText(this.primaryKey.getNotes());
            this.taPrimaryKeyComments.setText(this.primaryKey.getComment());
        } else {
            this.primaryKeyColumnsPanel.clearSelectedColumns();
            this.primaryKeyColumnsPanel.init(this.getColumnList());
            this.tfPrimaryKeyName.setText(null);
            this.chPrimaryKeyEngineer.setSelected(false);
            this.chPrimaryKeyGenerate.setSelected(false);
            this.chbPKDeprecated.setSelected(false);
            this.taPrimaryKeyNotes.setText(null);
            this.taPrimaryKeyComments.setText(null);
        }
    }

    private void savePrimaryKeyProperties() {
        if (this.primaryKey != null) {
            this.primaryKey.setName(this.tfPrimaryKeyName.getText());
            ViewIndexMemento selectedIndexMemento = (ViewIndexMemento)this.primaryKey.getIndexMemento();
            selectedIndexMemento.columns.clear();
            for (FKElement column : this.primaryKeyColumnsPanel.getSelectedColumns()) {
                List<ViewIndexMemento.ColWr> list = selectedIndexMemento.columns;
                ViewIndexMemento viewIndexMemento = selectedIndexMemento;
                viewIndexMemento.getClass();
                list.add(viewIndexMemento.new ViewIndexMemento.ColWr(column.getObjectID(), this.primaryKey.getColumnSortOrder(column)));
            }
            selectedIndexMemento.engineer = this.chPrimaryKeyEngineer.isSelected();
            selectedIndexMemento.generate_in_DDL = this.chPrimaryKeyGenerate.isSelected();
            selectedIndexMemento.deprecated = this.chbPKDeprecated.isSelected();
            selectedIndexMemento.notes = this.taPrimaryKeyNotes.getText();
            selectedIndexMemento.comments = this.taPrimaryKeyComments.getText();
        }
    }

    protected JPanel getUniqueKeysPanel() {
        if (this.pnUniqueKeys == null) {
            this.uniqueKeys = new ArrayList<ViewIndex>();
            this.tbUniqueKeys = new ViewIndexesTable(new ViewUniqueKeysTableModel(this.uniqueKeys, (Component)Ide.getMainWindow())){

                @Override
                public void onDeleteKeyPressed() {
                    TableViewPropertiesDialogEx.this.deleteSelectedIndex(AbstractEditorConstants.UNIQUE_CONSTRAINT);
                }

                @Override
                public void onSelectionChanged() {
                    TableViewPropertiesDialogEx.this.saveSelectedUniqueKeyProperties();
                    TableViewPropertiesDialogEx.this.initSelectedUniqueKeyProperties();
                }
            };
            TableColumn column = this.tbUniqueKeys.getColumnModel().getColumn(1);
            column.setPreferredWidth(100);
            column = this.tbUniqueKeys.getColumnModel().getColumn(2);
            column.setCellEditor(new StealthCBCellEditor());
            column.setPreferredWidth(40);
            column = this.tbUniqueKeys.getColumnModel().getColumn(3);
            column.setCellEditor(new StealthCBCellEditor());
            column.setPreferredWidth(40);
            this.pnUniqueKeys = this.createPage(UNIQUE_KEYS_TAB_NAME);
            JPanel uniqueKeysPanel = new JPanel(new BorderLayout());
            uniqueKeysPanel.add(this.createUKContentsPanel());
            uniqueKeysPanel.add((Component)this.createIndexToolbarPanel(UNIQUE_CONSTRAINT, this.uniqueKeys, this.tbUniqueKeys), "North");
            this.pnUniqueKeys.add(uniqueKeysPanel);
        }
        return this.pnUniqueKeys;
    }

    private void saveSelectedUniqueKeyProperties() {
        if (this.selectedUniqueKey != null) {
            ViewIndexMemento selectedUniqueKeyMemento = (ViewIndexMemento)this.selectedUniqueKey.getIndexMemento();
            selectedUniqueKeyMemento.columns.clear();
            selectedUniqueKeyMemento.expression = "";
            for (FKElement column : this.uniqueKeysColumnsPanel.getSelectedColumns()) {
                List<ViewIndexMemento.ColWr> list = selectedUniqueKeyMemento.columns;
                ViewIndexMemento viewIndexMemento = selectedUniqueKeyMemento;
                viewIndexMemento.getClass();
                list.add(viewIndexMemento.new ViewIndexMemento.ColWr(column.getObjectID(), this.selectedUniqueKey.getColumnSortOrder(column)));
            }
            selectedUniqueKeyMemento.notes = this.taUniqueKeyNotes.getText();
            selectedUniqueKeyMemento.comments = this.taUniqueKeyComments.getText();
        }
    }

    private void initSelectedUniqueKeyProperties() {
        boolean hasSelectedRow;
        this.selectedUniqueKey = this.getSelectedUniqueKey();
        this.uniqueKeysColumnsPanel.init(this.selectedUniqueKey, this.getColumnList());
        boolean bl = hasSelectedRow = this.selectedUniqueKey != null;
        if (hasSelectedRow) {
            ViewIndexMemento selectedUniqueKeyMemento = (ViewIndexMemento)this.selectedUniqueKey.getIndexMemento();
            this.taUniqueKeyNotes.setText(selectedUniqueKeyMemento.notes);
            this.taUniqueKeyComments.setText(selectedUniqueKeyMemento.comments);
        }
    }

    private ViewIndex getSelectedUniqueKey() {
        int row = this.tbUniqueKeys.getSelectedRow();
        if (row != -1 && this.uniqueKeys.size() > 0 && row < this.uniqueKeys.size()) {
            return this.uniqueKeys.get(row);
        }
        return null;
    }

    private JPanel createUKContentsPanel() {
        JPanel pnMain = new JPanel(new BorderLayout());
        boolean showDesc = this.getDesignObject().getDesignPart().getSelectedRDBMSType() == StorageDesignSqlServerv2k.RDBMS_TYPE || this.getDesignObject().getDesignPart().getSelectedRDBMSType() == StorageDesignSqlServerv2k5.RDBMS_TYPE;
        this.uniqueKeysColumnsPanel = new UKViewColumnsPanel(null, this.isEditable(), this.getPreferredIconSize(), showDesc);
        pnMain.add((Component)this.uniqueKeysColumnsPanel, "North");
        this.taUniqueKeyNotes = new RSyntaxTextArea();
        this.taColumnComments.setLineWrap(true);
        this.taColumnComments.setWrapStyleWord(true);
        this.taColumnComments.setBorder(null);
        this.taColumnComments.setAntiAliasingEnabled(true);
        this.taColumnComments.setFont(this.tfName.getFont());
        this.taUniqueKeyComments = new RSyntaxTextArea();
        this.taUniqueKeyComments.setLineWrap(true);
        this.taUniqueKeyComments.setWrapStyleWord(true);
        this.taUniqueKeyComments.setBorder(null);
        this.taUniqueKeyComments.setAntiAliasingEnabled(true);
        this.taUniqueKeyComments.setFont(this.tfName.getFont());
        JPanel pnContents = new JPanel(new BorderLayout());
        pnContents.add((Component)new JScrollPane(this.tbUniqueKeys), "North");
        pnContents.add(pnMain);
        return pnContents;
    }

    protected JPanel createIndexToolbarPanel(final String indexState, final List<ViewIndex> items, final JTable table) {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        if (this.isEditable()) {
            MoveUpDownListJTable upDown = new MoveUpDownListJTable(items, table);
            JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            btnAdd.setToolTipText(BTN_ADD);
            btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TableViewPropertiesDialogEx.this.createAndAddIndex(indexState, TableViewPropertiesDialogEx.this.tfName.getText(), "");
                }
            });
            final JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            btnRemove.setToolTipText(BTN_REMOVE);
            btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableViewPropertiesDialogEx.this.deleteSelectedIndex(indexState);
                    btnRemove.setEnabled(false);
                }
            });
            JButton btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
            btnUp.setToolTipText(BTN_MOVE_UP);
            btnUp.addActionListener(new MoveUpDownListJTable.MoveUpAction(upDown));
            JButton btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
            btnDown.setToolTipText(BTN_MOVE_DOWN);
            btnDown.addActionListener(new MoveUpDownListJTable.MoveDownAction(upDown));
            table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (items.isEmpty()) {
                        btnRemove.setEnabled(false);
                    } else {
                        int ind = table.getSelectedRow();
                        if (ind > -1 && ind < items.size()) {
                            KeyObject key = (KeyObject)items.get(ind);
                            if (key.isOidKey()) {
                                btnRemove.setEnabled(false);
                            } else {
                                btnRemove.setEnabled(true);
                            }
                        }
                    }
                }
            });
            table.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (items.isEmpty()) {
                        btnRemove.setEnabled(false);
                    } else {
                        btnRemove.setEnabled(TableViewPropertiesDialogEx.this.isEditable());
                    }
                }
            });
            toolBar.addSeparator();
            toolBar.add(btnAdd);
            toolBar.add(btnRemove);
            toolBar.add(btnUp);
            toolBar.add(btnDown);
        }
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        buttonGeneral.add(toolBar);
        return buttonGeneral;
    }

    @Override
    protected boolean canExit() {
        TableViewPropertiesDialogEx.stopCellEditing(this.tbElements);
        TableViewPropertiesDialogEx.stopCellEditing(this.tbForeignKeys);
        TableViewPropertiesDialogEx.stopCellEditing(this.tbUniqueKeys);
        this.saveSelectedFKProperties();
        this.saveSelectedUniqueKeyProperties();
        this.savePrimaryKeyProperties();
        if (super.canExit()) {
            if (this.primaryKey != null && (!StringUtilities.isNotEmpty(this.primaryKey.getName()) || this.primaryKeyColumnsPanel.getSelectedColumns().isEmpty())) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("TablePropertiesDialogEx.IncompletePKDefinition"), PRIMARY_KEY_TAB_NAME, 0);
                return false;
            }
            if (this.fkPropertiesEnabled) {
                for (FKIndexAssociation.FKMemento fkMemento : this.fkList) {
                    if (FKUtilities.checkRequiredProperties((Component)Ide.getMainWindow(), FKUtilities.getFKColumns(fkMemento, this.getColumnList()), fkMemento.fk, fkMemento.mandatory, fkMemento.transferable)) continue;
                    return false;
                }
            }
            Pattern p = Pattern.compile("\\p{Lower}([[\\p{Lower}\\p{Digit}]#$_])*$");
            Matcher m = p.matcher(this.tfORDSAlias.getText().toString());
            boolean identOK = true;
            if (!m.matches()) {
                MessageDialog.error((Component)this, (Object)MessageFormat.format(Messages.getString("SchemaPropertiesDialogEx.INVALID_ALIAS"), this.tfORDSAlias.getText().toString()), (String)Messages.getString("SchemaPropertiesDialogEx.INVALID_ALIAS_TITLE"), null);
                identOK = false;
            }
            if (!identOK) {
                String[] names = new String[]{"", ORDS_TAB_NAME};
                TreePath tp = TreeUtils.findByName(this.getTree(), names);
                if (tp != null) {
                    this.getTree().setSelectionPath(tp);
                }
                this.tfORDSAlias.requestFocus();
                return false;
            }
            return this.checkRequiredProperties();
        }
        return false;
    }

    protected boolean checkRequiredProperties() {
        for (ViewIndex uniqueKey : this.uniqueKeys) {
            if (!uniqueKey.getIndexMemento().getColumns().isEmpty()) continue;
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TablePropertiesDialogEx.IncompleteUKDefinition"), uniqueKey.getName()), Messages.getString("TablePropertiesDialogEx.UKColumnsAssignment"), 0);
            return false;
        }
        return true;
    }

    protected JPanel getForeignKeysPanel() {
        if (this.pnForeignKeys == null) {
            this.pnForeignKeys = this.createPage(FOREIGN_KEY_TAB_NAME);
            this.foreignKeys = new ArrayList<ViewIndex>();
            this.fkList = new ArrayList<FKIndexAssociation.FKMemento>();
            JPanel pnMain = new JPanel(new BorderLayout());
            pnMain.add((Component)this.createFKContentsPanel(), "Center");
            pnMain.add((Component)this.createFKToolbarPanel(), "North");
            this.pnForeignKeys.add(pnMain);
        }
        return this.pnForeignKeys;
    }

    private JPanel createFKContentsPanel() {
        JPanel pnForeignKeysContents = new JPanel(new BorderLayout(10, 10));
        JPanel pnMain = new JPanel(new BorderLayout(10, 10));
        pnMain.add((Component)this.createFKTopPanel(), "North");
        pnMain.add((Component)this.createFKBottomPanel(), "Center");
        pnForeignKeysContents.add((Component)pnMain, "Center");
        return pnForeignKeysContents;
    }

    private JPanel createFKTopPanel() {
        JPanel pnTop = new JPanel(new BorderLayout(10, 10));
        pnTop.add((Component)this.createFKNamesTable(), "North");
        pnTop.add((Component)this.createFKPropertiesPanel(), "Center");
        return pnTop;
    }

    private JPanel createFKBottomPanel() {
        JPanel pnColumnsNotesTable = new JPanel(new GridLayout(1, 2, 10, 10));
        this.fkColumnsTableModel = new FKColumnsTableModel();
        this.tbForeignKeyColumnsTable = new JTable(this.fkColumnsTableModel);
        this.tbForeignKeyColumnsTable.getColumnModel().getColumn(2).setMinWidth(30);
        this.tbForeignKeyColumnsTable.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.tbForeignKeyColumnsTable.getColumnModel().getColumn(2).setMaxWidth(90);
        if (!this.isEditable()) {
            this.tbForeignKeyColumnsTable.setEnabled(false);
        }
        this.fkColumnsCellEditor = new FKColumnsCellEditor(){

            @Override
            public void onSelectedColumnChanged(FKElement newSelection) {
                newSelection.setNullsAllowed(!((TableViewPropertiesDialogEx)TableViewPropertiesDialogEx.this).selectedFK.mandatory);
            }
        };
        JComboBox fkColumnsCellEditorComponent = (JComboBox)this.fkColumnsCellEditor.getComponent();
        fkColumnsCellEditorComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                TableViewPropertiesDialogEx.stopCellEditing(TableViewPropertiesDialogEx.this.tbForeignKeyColumnsTable);
            }
        });
        fkColumnsCellEditorComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TableViewPropertiesDialogEx.this.initializingSelectedFK) {
                    TableViewPropertiesDialogEx.this.dirtyMementos.add(TableViewPropertiesDialogEx.this.selectedFK);
                }
            }
        });
        this.tbForeignKeyColumnsTable.getColumnModel().getColumn(1).setCellEditor(this.fkColumnsCellEditor);
        this.tbForeignKeyColumnsTable.setPreferredScrollableViewportSize(new Dimension(80, 80));
        pnColumnsNotesTable.add(new JScrollPane(this.tbForeignKeyColumnsTable));
        this.taFKComments = new RSyntaxTextArea();
        this.taFKComments.setEditable(this.isEditable());
        this.taFKComments.setLineWrap(true);
        this.taFKComments.setWrapStyleWord(true);
        this.taFKComments.setBorder(null);
        this.taFKComments.setAntiAliasingEnabled(true);
        this.taFKComments.setFont(this.tfName.getFont());
        this.taFKComments.addFocusListener(new FocusListener(){
            String oldComments = "";

            @Override
            public void focusGained(FocusEvent e) {
                this.oldComments = TableViewPropertiesDialogEx.this.taFKComments.getText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!this.oldComments.equals(TableViewPropertiesDialogEx.this.taFKComments.getText())) {
                    TableViewPropertiesDialogEx.this.stealthChange = true;
                }
            }
        });
        this.taFKNotes = new RSyntaxTextArea();
        this.taFKNotes.setEditable(this.isEditable());
        this.taFKNotes.setLineWrap(true);
        this.taFKNotes.setWrapStyleWord(true);
        this.taFKNotes.setBorder(null);
        this.taFKNotes.setAntiAliasingEnabled(true);
        this.taFKNotes.setFont(this.tfName.getFont());
        this.taFKNotes.addFocusListener(new FocusListener(){
            String oldNotes = "";

            @Override
            public void focusGained(FocusEvent e) {
                this.oldNotes = TableViewPropertiesDialogEx.this.taFKNotes.getText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!this.oldNotes.equals(TableViewPropertiesDialogEx.this.taFKNotes.getText())) {
                    TableViewPropertiesDialogEx.this.stealthChange = true;
                }
            }
        });
        pnColumnsNotesTable.add(this.createNotesCommentsTabbedPane(this.taFKNotes, this.taFKComments, null));
        return pnColumnsNotesTable;
    }

    private JPanel createFKToolbarPanel() {
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnFKProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        this.btnFKProperties.setToolTipText(BTN_PROPERTIES);
        this.btnFKProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableViewPropertiesDialogEx.this.saveSelectedFKProperties();
                TableViewPropertiesDialogEx.this.showFKPropertiesDialog();
            }
        });
        this.btnFKProperties.setEnabled(false);
        if (this.isEditable()) {
            this.tbForeignKeys.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    TableViewPropertiesDialogEx.this.changeFKButtonsStatus();
                }
            });
        }
        JButton btnFKAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        btnFKAdd.setToolTipText(BTN_ADD);
        btnFKAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableViewPropertiesDialogEx.this.addFKColumn(e);
            }
        });
        this.btnFKRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        this.btnFKRemove.setToolTipText(BTN_REMOVE);
        this.btnFKRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TableViewPropertiesDialogEx.this.removeFKColumn();
            }
        });
        this.btnFKRemove.setEnabled(false);
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(this.btnFKProperties);
        if (this.isEditable()) {
            toolBar.addSeparator();
            toolBar.add(btnFKAdd);
            toolBar.add(this.btnFKRemove);
        }
        buttonGeneral.add(toolBar);
        return buttonGeneral;
    }

    private JScrollPane createFKNamesTable() {
        this.fkModel = new FKTableModel(this.fkList);
        this.tbForeignKeys = new ForeignKeyTable(this.fkModel);
        this.tbForeignKeys.setSelectionMode(0);
        if (!this.isEditable()) {
            this.tbForeignKeys.setEnabled(false);
        }
        TableColumn column = this.tbForeignKeys.getColumnModel().getColumn(0);
        column.setPreferredWidth(30);
        column.setMaxWidth(30);
        column = this.tbForeignKeys.getColumnModel().getColumn(1);
        column.setCellEditor(new TFCellEditor(new JTextField()));
        column.setPreferredWidth(200);
        column = this.tbForeignKeys.getColumnModel().getColumn(2);
        column.setPreferredWidth(200);
        column = this.tbForeignKeys.getColumnModel().getColumn(3);
        column.setCellEditor(new FKDeleteRuleCB());
        column.setPreferredWidth(100);
        column = this.tbForeignKeys.getColumnModel().getColumn(4);
        column.setCellEditor(new StealthCBCellEditor());
        column.setPreferredWidth(40);
        this.tbForeignKeys.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && TableViewPropertiesDialogEx.this.btnFKProperties.isEnabled()) {
                    TableViewPropertiesDialogEx.this.showFKPropertiesDialog();
                }
            }
        });
        this.tbForeignKeys.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (!TableViewPropertiesDialogEx.this.fkPropertiesEnabled) {
                        if (TableViewPropertiesDialogEx.this.isEditable()) {
                            TableViewPropertiesDialogEx.this.setFKPropertiesEnabled(true);
                        } else {
                            TableViewPropertiesDialogEx.this.setFKPropertiesEnabled(false);
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.addAll(Arrays.asList(((RelationalDesign)TableViewPropertiesDialogEx.this.getDesignObject().getDesignPart()).getTableSet().toArray()));
                            list.addAll(Arrays.asList(((RelationalDesign)TableViewPropertiesDialogEx.this.getDesignObject().getDesignPart()).getTableViewSet().toArray()));
                            TableViewPropertiesDialogEx.this.fillComboItems(list.toArray(), TableViewPropertiesDialogEx.this.cbReferencedTable, true);
                        }
                    }
                    TableViewPropertiesDialogEx.this.saveSelectedFKProperties();
                    TableViewPropertiesDialogEx.this.fkModel.fireTableCellUpdated(e.getFirstIndex(), 2);
                    TableViewPropertiesDialogEx.this.fkModel.fireTableCellUpdated(e.getLastIndex(), 2);
                    TableViewPropertiesDialogEx.this.selectedFK = TableViewPropertiesDialogEx.this.initSelectedFKOptions();
                }
            }
        });
        this.fkColumnsTableModel = new FKColumnsTableModel();
        this.tbForeignKeys.setPreferredScrollableViewportSize(new Dimension(500, 80));
        JScrollPane scrollPane = new JScrollPane(this.tbForeignKeys);
        return scrollPane;
    }

    private JPanel createFKPropertiesPanel() {
        JPanel pnFKProperties = new JPanel(new GridLayout(0, 1, 10, 10));
        this.cbReferencedTable = new JComboBox();
        this.cbReferencedTable.setPreferredSize(this.getDefaultSize());
        this.cbReferencedTable.setMaximumRowCount(8);
        this.cbReferencedTable.setEnabled(false);
        this.cbReferencedTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKContainer remoteTable = (FKContainer)TableViewPropertiesDialogEx.this.cbReferencedTable.getSelectedItem();
                if (remoteTable != null) {
                    List indexes = remoteTable.getPKandUKConstraints();
                    if (indexes != null) {
                        TableViewPropertiesDialogEx.this.fillComboItems(indexes.toArray(), TableViewPropertiesDialogEx.this.cbReferencedConstraint, false);
                    } else {
                        TableViewPropertiesDialogEx.this.cbReferencedConstraint.removeAllItems();
                    }
                    if (!TableViewPropertiesDialogEx.this.initializingSelectedFK && TableViewPropertiesDialogEx.this.selectedFK != null) {
                        TableViewPropertiesDialogEx.stopCellEditing(TableViewPropertiesDialogEx.this.tbForeignKeys);
                        ((TableViewPropertiesDialogEx)TableViewPropertiesDialogEx.this).selectedFK.name = FKUtilities.generateFKName((FKContainer)TableViewPropertiesDialogEx.this.tableView, remoteTable, TableViewPropertiesDialogEx.this.fkList);
                        TableViewPropertiesDialogEx.this.fkModel.fireTableCellUpdated(TableViewPropertiesDialogEx.this.tbForeignKeys.getSelectedRow(), 1);
                    }
                } else {
                    TableViewPropertiesDialogEx.this.cbReferencedConstraint.removeAllItems();
                    TableViewPropertiesDialogEx.this.cbReferencedConstraint.setSelectedItem(null);
                    if (!TableViewPropertiesDialogEx.this.initializingSelectedFK && TableViewPropertiesDialogEx.this.selectedFK != null) {
                        TableViewPropertiesDialogEx.stopCellEditing(TableViewPropertiesDialogEx.this.tbForeignKeys);
                        ((TableViewPropertiesDialogEx)TableViewPropertiesDialogEx.this).selectedFK.name = FKUtilities.generateFKName((FKContainer)TableViewPropertiesDialogEx.this.tableView, null, TableViewPropertiesDialogEx.this.fkList);
                        TableViewPropertiesDialogEx.this.fkModel.fireTableCellUpdated(TableViewPropertiesDialogEx.this.tbForeignKeys.getSelectedRow(), 1);
                    }
                }
                if (!TableViewPropertiesDialogEx.this.initializingSelectedFK) {
                    TableViewPropertiesDialogEx.this.saveSelectedFKProperties();
                    TableViewPropertiesDialogEx.this.dirtyMementos.add(TableViewPropertiesDialogEx.this.selectedFK);
                }
            }
        });
        this.addRowToPanel(pnFKProperties, Messages.getString("TablePropertiesDialogEx.ReferencedTable"), this.cbReferencedTable);
        this.cbReferencedConstraint = new JComboBox();
        this.cbReferencedConstraint.setPreferredSize(this.getDefaultSize());
        this.cbReferencedConstraint.setMaximumRowCount(8);
        this.cbReferencedConstraint.setEnabled(false);
        this.cbReferencedConstraint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TableViewPropertiesDialogEx.this.initializingSelectedFK) {
                    TableViewPropertiesDialogEx.this.refreshFKColumnsTableData();
                    TableViewPropertiesDialogEx.this.dirtyMementos.add(TableViewPropertiesDialogEx.this.selectedFK);
                }
            }
        });
        this.cbReferencedConstraint.setRenderer(new IndexesCellRenderer());
        this.addRowToPanel(pnFKProperties, Messages.getString("TablePropertiesDialogEx.ReferencedConstraint"), this.cbReferencedConstraint);
        pnFKProperties.add(this.createCheckboxesPanel());
        return pnFKProperties;
    }

    private void saveSelectedFKProperties() {
        if (this.selectedFK != null) {
            KeyObject remoteKey;
            this.selectedFK.remoteTable = (FKContainer)this.cbReferencedTable.getSelectedItem();
            this.selectedFK.remoteKey = remoteKey = (KeyObject)this.cbReferencedConstraint.getSelectedItem();
            if (remoteKey != null) {
                this.selectedFK.remoteKeyID = remoteKey.getObjectID();
            }
            this.selectedFK.columns.clear();
            FKElement[] fkColumns = this.fkColumnsTableModel.getFkColumns();
            if (fkColumns != null) {
                for (int i = 0; i < fkColumns.length; ++i) {
                    this.selectedFK.columns.add(fkColumns[i] != null ? fkColumns[i].getObjectID() : null);
                }
            }
            this.selectedFK.mandatory = this.chFKMandatory.isSelected();
            this.selectedFK.transferable = this.chFKTransferable.isSelected();
            this.selectedFK.notes = this.taFKNotes.getText();
            this.selectedFK.comments = this.taFKComments.getText();
        }
    }

    private void showFKPropertiesDialog() {
        if (!this.dirtyMementos.contains(this.selectedFK)) {
            int row = this.tbForeignKeys.getSelectedRow();
            if (row != -1 && !this.fkList.isEmpty() && row < this.fkList.size()) {
                TableViewPropertiesDialogEx.stopCellEditing(this.tbForeignKeys);
                FKIndexAssociation.FKMemento fkMemento = this.fkList.get(row);
                FKIndexAssociation fk = fkMemento.fk;
                if (!fk.isDialogVisible()) {
                    fk.showModal = this.tableView.showModal;
                    if (fk.showPropertyDialog(fkMemento, this)) {
                        this.tbForeignKeys.updateUI();
                        this.initSelectedFKOptions();
                    }
                }
            }
        } else {
            String messageKey = FKUtilities.containsEmptyColumns(this.selectedFK) ? "TablePropertiesDialogEx.IncompleteFKdefinition" : "TablePropertiesDialogEx.FKModified";
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), FKUtilities.formatMessage(messageKey, this.selectedFK.name), FKUtilities.formatMessage("TablePropertiesDialogEx.FKColumnsAssignment", this.selectedFK.name), 0);
        }
    }

    private void changeFKButtonsStatus() {
        int selectedRow = this.tbForeignKeys.getSelectedRow();
        boolean enabled = selectedRow < this.fkList.size() && selectedRow != -1;
        this.btnFKProperties.setEnabled(enabled);
        this.btnFKRemove.setEnabled(enabled);
    }

    private void addFKColumn(ActionEvent e) {
        TableViewPropertiesDialogEx.stopCellEditing(this.tbForeignKeys);
        FKIndexAssociation fkAssociation = new FKIndexAssociation(this.tableView);
        fkAssociation.setName(FKUtilities.generateFKName((FKContainer)this.oldTableView, null, this.fkList));
        FKIndexAssociation.FKMemento fkMemento = fkAssociation.getFKMemento(null);
        this.fkList.add(fkMemento);
        this.fkListForCreate.add(fkMemento);
        this.tbForeignKeys.updateUI();
        this.tbForeignKeys.changeSelection(this.fkList.size() - 1, 1, false, false);
        this.tbForeignKeys.requestFocus();
        this.dirtyMementos.add(fkMemento);
    }

    private void removeFKColumn() {
        FKIndexAssociation.FKMemento selectedFK = this.fkList.get(this.tbForeignKeys.getSelectedRow());
        if (!this.fkListForCreate.remove(selectedFK)) {
            this.fkListForRemove.add(selectedFK);
        }
        this.fkList.remove(this.tbForeignKeys.getSelectedRow());
        this.dirtyMementos.remove(selectedFK);
        selectedFK = null;
        this.tbForeignKeys.clearSelection();
        this.tbForeignKeys.updateUI();
        this.setFKPropertiesEnabled(false);
    }

    private void setFKPropertiesEnabled(boolean enabled) {
        this.cbReferencedTable.setEnabled(enabled);
        this.cbReferencedConstraint.setEnabled(enabled);
        this.chFKMandatory.setEnabled(enabled);
        this.chFKTransferable.setEnabled(enabled);
        this.taFKComments.setEnabled(enabled);
        this.taFKNotes.setEnabled(enabled);
        if (enabled) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.addAll(Arrays.asList(((RelationalDesign)this.getDesignObject().getDesignPart()).getTableSet().toArray()));
            list.addAll(Arrays.asList(((RelationalDesign)this.getDesignObject().getDesignPart()).getTableViewSet().toArray()));
            this.fillComboItems(list.toArray(), this.cbReferencedTable, true);
        } else {
            this.cbReferencedTable.setSelectedItem(null);
        }
        this.fkPropertiesEnabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FKIndexAssociation.FKMemento initSelectedFKOptions() {
        try {
            this.initializingSelectedFK = true;
            int row = this.tbForeignKeys.getSelectedRow();
            if (row != -1 && this.fkList.size() > 0 && row < this.fkList.size()) {
                FKIndexAssociation.FKMemento fkMemento = this.fkList.get(row);
                KeyObject remoteKey = fkMemento.remoteKey;
                FKContainer remoteTable = fkMemento.remoteTable;
                if (remoteTable != null) {
                    int remoteKeyColCount;
                    FKElement[] fkColumns = FKUtilities.getFKColumns(fkMemento, this.getColumnList());
                    if (remoteKey != null && (remoteKeyColCount = remoteKey.getElementsCollection().size()) != fkColumns.length) {
                        FKElement[] oldFKColumns = fkColumns;
                        fkColumns = new AbstractViewElement[remoteKeyColCount];
                        for (int i = 0; i < remoteKeyColCount && i < oldFKColumns.length; ++i) {
                            fkColumns[i] = oldFKColumns[i];
                        }
                    }
                    this.fkColumnsTableModel.init(fkColumns, remoteKey, this.chFKMandatory);
                    this.fkColumnsCellEditor.init(fkColumns, remoteKey, this.getColumnList());
                } else {
                    this.fkColumnsTableModel.init(null, null, this.chFKMandatory);
                    this.fkColumnsCellEditor.init(null, null, this.getColumnList());
                }
                this.fkColumnsTableModel.fireTableDataChanged();
                this.cbReferencedTable.setSelectedItem(remoteTable);
                this.cbReferencedConstraint.setSelectedItem(remoteKey);
                this.chFKMandatory.setSelected(fkMemento.mandatory);
                this.chFKTransferable.setSelected(fkMemento.transferable);
                this.chFKInArc.setSelected(fkMemento.arc != null);
                this.taFKNotes.setText(fkMemento.notes);
                this.taFKComments.setText(fkMemento.comments);
                FKIndexAssociation.FKMemento fKMemento = fkMemento;
                return fKMemento;
            }
            FKIndexAssociation.FKMemento fKMemento = null;
            return fKMemento;
        }
        finally {
            this.initializingSelectedFK = false;
        }
    }

    private void refreshFKColumnsTableData() {
        FKElement[] fkColumns = null;
        KeyObject remoteKey = (KeyObject)this.cbReferencedConstraint.getSelectedItem();
        if (remoteKey != null) {
            fkColumns = new AbstractViewElement[remoteKey.getElementsCollection().size()];
        }
        this.fkColumnsTableModel.init(fkColumns, remoteKey, this.chFKMandatory);
        this.fkColumnsCellEditor.init(fkColumns, remoteKey, this.getColumnList());
        this.fkColumnsTableModel.fireTableDataChanged();
    }

    private JPanel createCheckboxesPanel() {
        JPanel checkBoxesPanel = new JPanel(new GridLayout(1, 3, 10, 10));
        this.chFKMandatory = new JCheckBox();
        this.chFKMandatory.setPreferredSize(this.getDefaultSize());
        this.chFKMandatory.setEnabled(false);
        this.chFKMandatory.setText(Messages.getString("TablePropertiesDialogEx.Mandatory"));
        this.chFKMandatory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableViewPropertiesDialogEx.this.stealthChange = true;
            }
        });
        checkBoxesPanel.add(this.chFKMandatory);
        this.chFKTransferable = new JCheckBox();
        this.chFKTransferable.setPreferredSize(this.getDefaultSize());
        this.chFKTransferable.setEnabled(false);
        this.chFKTransferable.setText(Messages.getString("TablePropertiesDialogEx.Transferable"));
        this.chFKTransferable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableViewPropertiesDialogEx.this.stealthChange = true;
            }
        });
        checkBoxesPanel.add(this.chFKTransferable);
        this.chFKInArc = new JCheckBox();
        this.chFKInArc.setPreferredSize(this.getDefaultSize());
        this.chFKInArc.setEnabled(false);
        this.chFKInArc.setText(Messages.getString("TablePropertiesDialogEx.InArc"));
        this.chFKInArc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableViewPropertiesDialogEx.this.stealthChange = true;
            }
        });
        checkBoxesPanel.add(this.chFKInArc);
        return checkBoxesPanel;
    }

    protected JPanel getORDSPanel() {
        if (this.pnORDS == null) {
            this.pnORDS = this.createPage(ORDS_TAB_NAME);
            JPanel jpanel = new JPanel(new BorderLayout());
            JPanel pnGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbEnable = new JLabel(Messages.getString("SchemaPropertiesDialogEx.ORDSEnableObject"));
            lbEnable.setPreferredSize(this.getDefaultSize());
            this.chbORDSEnable = new JCheckBox();
            this.chbORDSEnable.setPreferredSize(this.getDefaultSize());
            pnGrid.add(this.createRow(lbEnable, this.chbORDSEnable));
            JLabel lbAlias = new JLabel(Messages.getString("SchemaPropertiesDialogEx.ORDSAlias"));
            lbAlias.setPreferredSize(this.getDefaultSize());
            this.tfORDSAlias = new JTextField();
            this.tfORDSAlias.setPreferredSize(this.getDefaultSize());
            pnGrid.add(this.createRow(lbAlias, this.tfORDSAlias));
            JLabel lbAuth = new JLabel(Messages.getString("SchemaPropertiesDialogEx.ORDSAuth"));
            lbAuth.setPreferredSize(this.getDefaultSize());
            this.chbORDSAuth = new JCheckBox();
            this.chbORDSAuth.setPreferredSize(this.getDefaultSize());
            pnGrid.add(this.createRow(lbAuth, this.chbORDSAuth));
            jpanel.add((Component)pnGrid, "North");
            this.pnORDS.add((Component)jpanel, "Center");
        }
        return this.pnORDS;
    }

    protected JPanel getQueryPanel() {
        if (this.pnQuery == null) {
            Dimension defaultSize = new Dimension(210, 20);
            this.pnQuery = this.createPage(Messages.getString("TableViewPropertiesDialogEx.Query"));
            JPanel pnMain = new JPanel(new BorderLayout());
            JPanel jpanel = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbQueryBuilder = new JLabel(Messages.getString("TableViewPropertiesDialogEx.QueryBuilder"));
            lbQueryBuilder.setPreferredSize(defaultSize);
            this.btnQueryBuilder = new JButton(BTN_QUERY);
            this.btnQueryBuilder.setHorizontalAlignment(2);
            this.btnQueryBuilder.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String queryText = TableViewPropertiesDialogEx.this.taQueryText.getText();
                    TableViewPropertiesDialogEx.this.tableView.setUserDefinedSQL(queryText);
                    if (TableViewPropertiesDialogEx.this.queryTextChanged(queryText)) {
                        TableViewPropertiesDialogEx.this.tableView.setParsed(false);
                    }
                    TableViewPropertiesDialogEx.stopCellEditing(TableViewPropertiesDialogEx.this.tbElements);
                    QueryBuilderPanel qb = new QueryBuilderPanel(TableViewPropertiesDialogEx.this.tableView);
                    DesignPartView useDPV = null;
                    if (TableViewPropertiesDialogEx.this.cbSubViews.getSelectedIndex() > 0) {
                        useDPV = (DesignPartView)TableViewPropertiesDialogEx.this.cbSubViews.getSelectedItem();
                    }
                    qb.getDialog(TableViewPropertiesDialogEx.this.getAppView(), TableViewPropertiesDialogEx.this.chIncludeSchemaNameInQuery.isSelected() && TableViewPropertiesDialogEx.this.tableView.getSchemaObject() != null, useDPV, TableViewPropertiesDialogEx.this.chAutoJoin.isSelected()).setVisible(true);
                    TableViewPropertiesDialogEx.this.savedUserDefinedSQL = TableViewPropertiesDialogEx.this.tableView.getUserDefinedSQL();
                    TableViewPropertiesDialogEx.this.taQueryText.setText(TableViewPropertiesDialogEx.this.savedUserDefinedSQL);
                    TableViewPropertiesDialogEx.this.taQueryText.setCaretPosition(0);
                    TableViewPropertiesDialogEx.this.updateElementsList();
                }
            });
            jpanel.add(this.createRow(lbQueryBuilder, this.btnQueryBuilder));
            JLabel lbIncludeSchemaNameInQuery = new JLabel(Messages.getString("TableViewPropertiesDialogEx.IncludeSchemaNameInQuery"));
            lbIncludeSchemaNameInQuery.setPreferredSize(defaultSize);
            this.chIncludeSchemaNameInQuery = new JCheckBox();
            this.chIncludeSchemaNameInQuery.setPreferredSize(this.getDefaultSize());
            jpanel.add(this.createRow(lbIncludeSchemaNameInQuery, this.chIncludeSchemaNameInQuery));
            JLabel lbAutoJoin = new JLabel(Messages.getString("TableViewPropertiesDialogEx.AutoJoinOnFKs"));
            lbAutoJoin.setPreferredSize(defaultSize);
            this.chAutoJoin = new JCheckBox();
            this.chAutoJoin.setPreferredSize(this.getDefaultSize());
            this.chAutoJoin.setSelected(ApplicationView.getInstance().getSettings().isAutoJoinOnFK());
            this.chAutoJoin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationView.getInstance().getSettings().setAutoJoinOnFK(TableViewPropertiesDialogEx.this.chAutoJoin.isSelected());
                }
            });
            jpanel.add(this.createRow(lbAutoJoin, this.chAutoJoin));
            JLabel lbUseObjectsFrom = new JLabel(Messages.getString("TableViewPropertiesDialogEx.UseObjectsFrom"));
            lbUseObjectsFrom.setPreferredSize(defaultSize);
            this.cbSubViews = new JComboBox();
            this.cbSubViews.setPreferredSize(this.getDefaultSize());
            jpanel.add(this.createRow(lbUseObjectsFrom, this.cbSubViews));
            JPanel pnQueryText = new JPanel(new BorderLayout());
            pnQueryText.setBorder(BorderFactory.createTitledBorder(BTN_QUERY));
            this.taQueryText = new RSyntaxTextArea();
            this.taQueryText.setSyntaxEditingStyle("text/sql");
            this.taQueryText.setEditable(false);
            this.taQueryText.setAntiAliasingEnabled(true);
            this.taQueryText.setCodeFoldingEnabled(true);
            this.taQueryText.setCurrentLineHighlightColor(new Color(225, 236, 255));
            this.taQueryText.setEditable(this.isEditable());
            pnQueryText.add((Component)new RTextScrollPane((RTextArea)this.taQueryText));
            pnQueryText.setPreferredSize(new Dimension(325, 100));
            JPanel pnTestQueryPanel = new JPanel();
            this.btnTestQuery = new JButton(Messages.getString("TableViewPropertiesDialogEx.TestQuery"));
            this.btnTestQuery.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DMSQLQueryTester.registerComponent(ResultTesterComponent.class);
                    DMSQLQueryTester qt = new DMSQLQueryTester(TableViewPropertiesDialogEx.this.getDatabase());
                    qt.showDialog(TableViewPropertiesDialogEx.this, QBUtils.getSQL(TableViewPropertiesDialogEx.this.taQueryText.getText()));
                }
            });
            pnTestQueryPanel.add((Component)this.btnTestQuery, "East");
            pnMain.add((Component)jpanel, "North");
            pnMain.add(pnQueryText);
            pnMain.add((Component)pnTestQueryPanel, "South");
            this.pnQuery.add(pnMain);
        }
        return this.pnQuery;
    }

    private boolean queryTextChanged(String queryText) {
        if (queryText.equals(this.savedUserDefinedSQL)) {
            return false;
        }
        String formattedQueryText = DDLStatementHandler.clearCR(queryText);
        return !formattedQueryText.equals(DDLStatementHandler.clearCR(this.savedUserDefinedSQL));
    }

    private void enableQueryPanelFields(boolean enabled) {
        this.btnQueryBuilder.setEnabled(enabled);
        this.chIncludeSchemaNameInQuery.setEnabled(enabled);
        this.chAutoJoin.setEnabled(enabled);
        this.cbSubViews.setEnabled(enabled);
        this.taQueryText.setEnabled(enabled);
        this.btnTestQuery.setEnabled(enabled);
    }

    class FKDeleteRuleCB
    extends DefaultCellEditor {
        JComboBox cbox;

        FKDeleteRuleCB() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            FKIndexAssociation.FKMemento mem = (FKIndexAssociation.FKMemento)TableViewPropertiesDialogEx.this.fkList.get(row);
            if (this.hasColumnWithAllowNulls(mem)) {
                this.cbox.setModel(new DefaultComboBoxModel<String>(mem.fk.getDeleteRuleChoices()));
            } else {
                this.cbox.setModel(new DefaultComboBoxModel<String>(FKIndexAssociation.DELETE_RULES_WITHOUT_NULL));
            }
            this.cbox.setSelectedItem(mem.deleteRule);
            return this.cbox;
        }

        private boolean hasColumnWithAllowNulls(FKIndexAssociation.FKMemento mem) {
            for (String colid : mem.columns) {
                FKElement col = (FKElement)mem.table.getElementByID(colid);
                if (col == null || !col.getNullsAllowed()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            TableViewPropertiesDialogEx.this.stealthChange = true;
            return super.stopCellEditing();
        }
    }

    class ForeignKeyTable
    extends JTable {
        ForeignKeyTable(TableModel fkModel) {
            super(fkModel);
        }
    }

    class StealthCBCellEditor
    extends DefaultCellEditor {
        StealthCBCellEditor() {
            super(new StealthCheckBox());
        }

        @Override
        public boolean stopCellEditing() {
            TableViewPropertiesDialogEx.this.stealthChange = true;
            return super.stopCellEditing();
        }
    }

    class StealthCheckBox
    extends JCheckBox {
        public StealthCheckBox() {
            this.setHorizontalAlignment(0);
        }
    }

    public class ElementHelper {
        AbstractViewElement element;
        String comments;
        String commentsInRDBMS;
        String notes;
        boolean pkElement = false;

        public ElementHelper(AbstractViewElement element) {
            this.element = element;
            this.comments = element.getComment();
            this.commentsInRDBMS = element.getCommentInRDBMS();
            this.notes = element.getNotes();
            this.pkElement = element.isPKElement();
        }

        public AbstractViewElement getElement() {
            return this.element;
        }

        public String getName() {
            if (!"".equals(this.element.getAlias())) {
                return this.element.getAlias();
            }
            return this.element.getName();
        }

        public String getRefContainerName() {
            if (this.element.getReferencedContainer() != null) {
                return this.element.getReferencedContainer().getName();
            }
            return "";
        }

        public String getHeaderAlias() {
            return this.element.getHeaderAlias();
        }

        public void setHeaderAlias(String headerAlias) {
            this.element.setHeaderAlias(headerAlias);
        }

        public void applyComments() {
            this.element.setComment(this.comments);
        }

        public void applyCommentsInRDBMS() {
            this.element.setCommentInRDBMS(this.commentsInRDBMS);
        }

        public void applyNotes() {
            this.element.setNotes(this.notes);
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String comments) {
            this.comments = comments;
        }

        public String getCommentsInRDBMS() {
            return this.commentsInRDBMS;
        }

        public void setCommentsInRDBMS(String commentsInRDBMS) {
            this.commentsInRDBMS = commentsInRDBMS;
        }

        public String getNotes() {
            return this.notes;
        }

        public void setNotes(String notes) {
            this.notes = notes;
        }

        public boolean isMandatory() {
            return this.element.isMandatory();
        }

        public boolean isFKElement() {
            return this.element.isFKElement();
        }

        public boolean isPKElement() {
            return this.pkElement;
        }

        public void setPKElement(boolean value) {
            this.pkElement = value;
        }

        public boolean isRemotePKElement() {
            return this.element.getReferencedColumn() != null && this.element.getReferencedColumn().isPKElement();
        }
    }

    public class ComboModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TableViewPropertiesDialogEx.Column");
            }
            if (column == 1) {
                return Messages.getString("TableViewPropertiesDialogEx.Table");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!TableViewPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return columnIndex != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class ComboTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox combo;

        ComboTableCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.combo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.combo = (JComboBox)value;
            this.combo.setOpaque(true);
            return this.combo;
        }
    }

    public class ElementsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return TableViewPropertiesDialogEx.this.lsElements.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TableViewPropertiesDialogEx.Column");
            }
            if (column == 1) {
                return Messages.getString("TableViewPropertiesDialogEx.HeaderAlias");
            }
            if (column == 2) {
                return Messages.getString("TableViewPropertiesDialogEx.ReferencedContainer");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ElementHelper helper = (ElementHelper)TableViewPropertiesDialogEx.this.lsElements.get(row);
            if (col == 0) {
                return helper.getName();
            }
            if (col == 1) {
                return helper.getHeaderAlias();
            }
            if (col == 2) {
                return helper.getRefContainerName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                ElementHelper helper = (ElementHelper)TableViewPropertiesDialogEx.this.lsElements.get(rowIndex);
                helper.setHeaderAlias(obj.toString());
            }
        }
    }

    class ColumnTable
    extends JTable {
        ComboModel dataModel;

        public ColumnTable() {
            this.dataModel = new ComboModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0) {
                return super.getCellRenderer(row, col);
            }
            return new LNComboTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            return new ComboTableCellEditor();
        }
    }

    static class FKMementoNameComparator
    implements Comparator {
        FKMementoNameComparator() {
        }

        public int compare(Object one, Object two) {
            return ((FKIndexAssociation.FKMemento)one).name.compareTo(((FKIndexAssociation.FKMemento)two).name);
        }
    }
}

