/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.AddChangeRequestDialog;
import oracle.dbtools.crest.swingui.editor.ChangeRequestPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.MeasurementPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.editor.UDPLibrary;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.editor.UserDefinedPropertyGroup;
import oracle.dbtools.crest.swingui.editor.businessinfo.AbstractAddObjectDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddDocumentDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddPartyDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.DocumentPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.businessinfo.ResponsiblePartyPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.relational.ColumnPropertiesDialogEx;
import oracle.dbtools.crest.util.HelpManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.OSEnvironment;
import oracle.dbtools.crest.util.TreeUtils;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.SQLSyntaxTextArea;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public abstract class AbstractPropertiesDialog
extends JDialog
implements AbstractEditorConstants,
TreeWillExpandListener {
    public static final String EMPTY_STRING = "";
    public static final String YES = Messages.getString("AbstractPropertiesDialog.YES");
    public static final String NO = Messages.getString("AbstractPropertiesDialog.NO");
    protected static final String[] YES_NO = new String[]{YES, NO};
    protected static final String[] YES_NO_INTERNAL = new String[]{"YES", "NO"};
    protected static final String[] EMPTY_STRING_YES_NO = new String[]{"", YES, NO};
    public static final String NONE = Messages.getString("AbstractPropertiesDialog.NONE");
    public static final String BTN_PROPERTIES = Messages.getString("AbstractPropertiesDialog.Properties");
    public static final String BTN_ADD = Messages.getString("AbstractPropertiesDialog.Add");
    public static final String BTN_REMOVE = Messages.getString("AbstractPropertiesDialog.Remove");
    public static final String BTN_MOVE_UP = Messages.getString("AbstractPropertiesDialog.MoveUp");
    public static final String BTN_MOVE_DOWN = Messages.getString("AbstractPropertiesDialog.MoveDown");
    public static final String NAME_IS_FROZEN = Messages.getString("AbstractPropertiesDialog.NameFrozen");
    protected final String generalPanelName = Messages.getString("AbstractPropertiesDialog.General");
    protected static final int FIELD_WIDTH = OSEnvironment.isMacOS() ? 200 : 180;
    protected static final int FIELD_HEIGHT = 20;
    private static final String ATTRIBUTES_TAB = Messages.getString("AbstractPropertiesDialog.Attributes");
    private static final String COLUMNS_TAB = Messages.getString("AbstractPropertiesDialog.Columns");
    protected static final String IMPACT_ANALYSIS = Messages.getString("AbstractPropertiesDialog.ImpactAnalysis");
    protected boolean impAnInitialized = false;
    private ApplicationView appView;
    private DesignObject designObject;
    private JTabbedPane tabbedPane;
    protected JPanel pnButtons;
    protected JLabel lbName;
    protected JTextField tfName;
    private JButton bnCancel;
    private JTree tree;
    private JPanel pnMain;
    private CardLayout cardLayout = new CardLayout(10, 10);
    protected JPanel pnGeneral;
    protected JPanel contentPanel;
    private JPanel pnComments;
    private JPanel pnCommentsInRDBMS;
    private JPanel pnNotes;
    private JPanel pnUsedIn;
    private JPanel pnSummary;
    private JPanel pnAttributes;
    private JPanel pnColumns;
    private JPanel pnDynamicProperties;
    private JPanel pnUserDefinedProperties;
    protected RSyntaxTextArea taComments;
    protected RSyntaxTextArea taCommentsInRDBMS;
    protected RSyntaxTextArea taNotes;
    protected JTextArea taUsedIn;
    private JPanel pnGeneralGrid;
    protected JPanel pnAdditionalPanel;
    private Dimension defaultSize = new Dimension(FIELD_WIDTH, 20);
    private int summaryPanelMinHeight = 460;
    private int summaryPanelMinWidth = 650;
    private JPanel pnSummaryGrid;
    protected JTextField tfComment;
    protected JTextField tfObjectID;
    protected JTextField tfCreator;
    protected JTextField tfCreationTime;
    protected JTextField tfLastChangedBy;
    protected JTextField tfLastChangedTime;
    protected JTextField tfGeneratorName;
    protected JTextField tfRepositoryOID;
    protected JTextField tfDesign;
    private int summaryCount = 8;
    private JPanel pnDataDictConnection;
    private JPanel pnDataDictSchema;
    private JPanel pnDataDictObject;
    private JPanel pnDDLFileName;
    protected JTextField tfDataDictConnection;
    protected JTextField tfDataDictSchema;
    protected JTextField tfDataDictObject;
    protected JTextField tfDDLFileName;
    private JPanel pnRemoteDesign;
    private JPanel pnRemoteModel;
    private JPanel pnRemoteObject;
    private JTextField tfRemoteDesign;
    private JTextField tfRemoteModel;
    private JTextField tfRemoteObject;
    private JPanel pnMeasurements;
    protected JTable mTable;
    protected List mList;
    private int mCounter = 0;
    private JPanel pnChangeRequests;
    protected JTable reqTable;
    protected List reqList;
    private JPanel pnResParties;
    protected JTable rpTable;
    protected List rpList;
    private JPanel pnDocuments;
    protected JTable docTable;
    protected List docList;
    private JPanel pnScript;
    private JTabbedPane tpane;
    protected RSyntaxTextArea taBeforeDrop;
    protected RSyntaxTextArea taBeforeCreate;
    protected RSyntaxTextArea taAfterCreate;
    protected RSyntaxTextArea taEndOfScript;
    protected JCheckBox chGenerateScript;
    protected String oldObjectStatus;
    private boolean oldGenerateInDDL;
    protected List<DynamicProperty> dynamicPropertiesList;
    protected JTable dynamicPropertiesTable;
    private int cgCounter = 0;
    protected List allUDPList;
    protected JTable userDefinedPropertiesTable;
    protected List groupUDPTables;
    private String treePath = "";
    protected TableModel mModel;
    protected TableModel reqModel;
    protected TableModel rpModel;
    protected TableModel docModel;
    protected DesignLevelSettings dlSettings;
    protected boolean applyMode = false;
    protected boolean okMode = false;
    protected JSplitPane splitPane;
    GUIConfiguration configuration = GUIConfiguration.getInstance();
    private static final Logger LOGGER = new Logger(AbstractPropertiesDialog.class);
    private Action actF1 = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractPropertiesDialog.this.showHelp();
        }
    };
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractPropertiesDialog.this.bnCancel.doClick();
        }
    };

    public AbstractPropertiesDialog(ApplicationView view, DesignObject object) {
        super(view.getFrame());
        this.init(view, object);
    }

    public AbstractPropertiesDialog(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner);
        this.init(view, object);
    }

    private void init(ApplicationView view, DesignObject object) {
        this.designObject = object;
        this.appView = view;
        this.dlSettings = this.getDesignObject().getDesign().getDesignLevelSettings();
        this.oldObjectStatus = this.appView.getXMLTransformationManager().getFilteredXMLString(object);
        this.oldGenerateInDDL = object.isMarkedGenerate();
        this.initCaption(object.getName());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractPropertiesDialog.this.onCancel();
                AbstractPropertiesDialog.this.designObject.setDialogVisible(false, null);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                AbstractPropertiesDialog.this.designObject.setDialogVisible(false, null);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = AbstractPropertiesDialog.this.getWidth();
                int h = AbstractPropertiesDialog.this.getHeight();
                w = Math.max(AbstractPropertiesDialog.this.getMinimumWidth(), w);
                h = Math.max(AbstractPropertiesDialog.this.getMinimumHeight(), h);
                AbstractPropertiesDialog.this.setSize(w, h);
            }
        });
        this.initLayout();
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escapeAction);
        KeyStroke ksF1 = KeyStroke.getKeyStroke(112, 0, false);
        c.getInputMap(condition).put(ksF1, "KEY_F1");
        c.getActionMap().put("KEY_F1", this.actF1);
        this.pack();
        Settings.DialogSettings ds = this.getAppView().getSettings().getDialogSettings(this.getClass().getName());
        if (ds == null) {
            int w = Math.max(this.getMinimumWidth(), this.summaryPanelMinWidth);
            int h = Math.max(this.getMinimumHeight(), this.summaryPanelMinHeight);
            this.setSize(w, h);
            CommonUtil.centerOnScreen(this);
            this.splitPane.setDividerLocation(this.getMinimumTreeWidth());
        } else {
            int w = Math.max(this.getMinimumWidth(), (int)ds.rec.getSize().getWidth());
            int h = Math.max(this.getMinimumHeight(), (int)ds.rec.getSize().getHeight());
            this.setSize(w, h);
            this.setLocation(ds.rec.getLocation());
            this.treePath = ds.treePath;
            if (ds.dividerLocation > 0) {
                this.splitPane.setDividerLocation(ds.dividerLocation);
            } else {
                this.splitPane.setDividerLocation(this.getMinimumTreeWidth());
            }
        }
    }

    protected void showHelp() {
        HelpManager.showTopic(this, this.getHelpIndex());
    }

    public abstract String getCaption();

    public abstract void initProperties(DesignObject var1);

    protected abstract void setProperties();

    protected abstract void initTree(DefaultMutableTreeNode var1);

    protected abstract String getHelpIndex();

    protected ApplicationView getAppView() {
        return this.appView;
    }

    protected DesignObject getDesignObject() {
        return this.designObject;
    }

    protected void setDesignObject(DesignObject desObject) {
        this.designObject = desObject;
    }

    protected void initCaption(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getCaption()).append(" - ").append(name);
        this.setTitle(buffer.toString());
    }

    protected void selectName() {
        this.tfName.requestFocus();
        this.tfName.selectAll();
    }

    @Override
    public void show() {
        if (this.designObject.showModal || this.designObject.showForFirstTime()) {
            this.setModal(true);
        }
        this.selectName();
        if (!this.isEditable()) {
            this.disableControls(this);
            this.getTree().requestFocus();
        }
        if (!this.designObject.showForFirstTime() && this.treePath.length() > 0) {
            String[] names = this.treePath.split("/");
            TreePath tp = TreeUtils.findByName(this.getTree(), names);
            if (tp != null) {
                this.getTree().setSelectionPath(tp);
            }
        }
        this.designObject.setDialogVisible(true, this);
        super.show();
    }

    private void disableControls(Container container) {
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            if (c == this.getTree() || c == this.pnButtons || c instanceof JTable || c instanceof JButton || c instanceof JList || c instanceof JScrollPane) continue;
            if (!(c instanceof JTabbedPane) && !(c instanceof JLabel)) {
                c.setEnabled(false);
            }
            if (!(c instanceof Container)) continue;
            this.disableControls((Container)c);
        }
    }

    protected void manageControlsState(Container container, boolean enable, boolean clearContents) {
        try {
            Component[] components = container.getComponents();
            for (int i = 0; i < components.length; ++i) {
                Component c = components[i];
                c.setEnabled(enable);
                if (clearContents) {
                    if (c instanceof JTextField) {
                        ((JTextField)c).setText(EMPTY_STRING);
                    }
                    if (c instanceof JTextArea) {
                        ((JTextArea)c).setText(EMPTY_STRING);
                    }
                    if (c instanceof RSyntaxTextArea) {
                        ((RSyntaxTextArea)c).setText(EMPTY_STRING);
                    }
                    if (c instanceof JRadioButton) {
                        ((JRadioButton)c).setSelected(false);
                    }
                    if (c instanceof JCheckBox) {
                        ((JCheckBox)c).setSelected(false);
                    }
                }
                if (!(c instanceof Container)) continue;
                this.manageControlsState((Container)c, enable, clearContents);
            }
        }
        catch (Exception e) {
            LOGGER.error("AbstractPropertiesDialog.manageControlsState ", e);
        }
    }

    protected int getMinimumWidth() {
        return this.summaryPanelMinWidth;
    }

    protected int getMinimumHeight() {
        return this.summaryPanelMinHeight;
    }

    protected JPanel getMainPanel() {
        if (this.pnMain == null) {
            this.pnMain = new JPanel(this.cardLayout);
            this.pnMain.setMinimumSize(new Dimension(400, 0));
        }
        return this.pnMain;
    }

    protected void fillComboItems(Object[] items, JComboBox comboBox, boolean addNull) {
        comboBox.removeAllItems();
        if (addNull) {
            comboBox.addItem(null);
        }
        for (int i = 0; i < items.length; ++i) {
            comboBox.addItem(items[i]);
        }
    }

    protected JPanel createPage(String title) {
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        panel.setName(title);
        JPanel caption = new JPanel();
        caption.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        caption.setBackground(Color.WHITE);
        JLabel lb = new JLabel(title);
        lb.setPreferredSize(new Dimension((int)lb.getPreferredSize().getWidth(), 22));
        caption.add(lb);
        panel.add((Component)caption, "North");
        return panel;
    }

    protected void addRowToGeneralPanel(JPanel newRow) {
        this.pnGeneralGrid.add(newRow);
    }

    protected void addRowToPanel(JPanel panel, String labelText, JComponent rightComp) {
        this.addRowToPanel(panel, labelText, rightComp, null);
    }

    protected void addRowToPanel(JPanel panel, String labelText, JComponent rightComp, String toolTipText) {
        this.addRowToPanel(panel, labelText, rightComp, toolTipText, null);
    }

    protected void addRowToPanel(JPanel panel, String labelText, JComponent rightComp, String toolTipText, Object constraints) {
        JLabel label = new JLabel(labelText);
        label.setLabelFor(rightComp);
        label.setPreferredSize(this.getDefaultSize());
        if (toolTipText != null) {
            label.setToolTipText(toolTipText);
            rightComp.setToolTipText(toolTipText);
        }
        panel.add((Component)this.createRow(label, rightComp), constraints);
    }

    protected Dimension getDefaultSize() {
        return this.defaultSize;
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(this.generalPanelName);
            JPanel jpanel = new JPanel(new BorderLayout());
            this.pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            this.pnAdditionalPanel = new JPanel(new GridLayout(0, 1, 10, 10));
            this.lbName = new JLabel(LB_NAME);
            this.lbName.setPreferredSize(this.defaultSize);
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.defaultSize);
            this.tfName.setEnabled(this.isEditable());
            this.pnGeneralGrid.add(this.createRow(this.lbName, this.tfName));
            jpanel.add((Component)this.pnGeneralGrid, "North");
            jpanel.add((Component)this.pnAdditionalPanel, "Center");
            this.pnGeneral.add((Component)jpanel, "Center");
        }
        return this.pnGeneral;
    }

    protected JPanel getCommentsPanel() {
        if (this.pnComments == null) {
            this.pnComments = this.createPage(Messages.getString("AbstractPropertiesDialog.Comments"));
            this.taComments = new RSyntaxTextArea();
            this.taComments.setEditable(this.isEditable());
            this.taComments.setEnabled(this.isEditable());
            if (!this.isEditable()) {
                this.taComments.setBackground(this.tfName.getBackground());
                this.taComments.setForeground(this.tfName.getDisabledTextColor());
                this.taComments.setHighlightCurrentLine(false);
            }
            this.taComments.setLineWrap(true);
            this.taComments.setWrapStyleWord(true);
            this.taComments.setBorder(null);
            this.taComments.setAntiAliasingEnabled(true);
            this.taComments.setFont(this.tfName.getFont());
            this.pnComments.add(new JScrollPane((Component)this.taComments));
        }
        return this.pnComments;
    }

    protected JPanel getCommentsInRDBMSPanel() {
        if (this.pnCommentsInRDBMS == null) {
            this.pnCommentsInRDBMS = this.createPage(Messages.getString("AbstractPropertiesDialog.CommentsInRDBMS"));
            this.taCommentsInRDBMS = new RSyntaxTextArea();
            this.taCommentsInRDBMS.setEditable(this.isEditable());
            this.taCommentsInRDBMS.setLineWrap(true);
            this.taCommentsInRDBMS.setWrapStyleWord(true);
            this.taCommentsInRDBMS.setBorder(null);
            this.taCommentsInRDBMS.setAntiAliasingEnabled(true);
            this.taCommentsInRDBMS.setFont(this.tfName.getFont());
            this.pnCommentsInRDBMS.add(new JScrollPane((Component)this.taCommentsInRDBMS));
        }
        return this.pnCommentsInRDBMS;
    }

    protected JPanel getNotesPanel() {
        if (this.pnNotes == null) {
            this.pnNotes = this.createPage(Messages.getString("AbstractPropertiesDialog.Notes"));
            this.taNotes = new RSyntaxTextArea();
            this.taNotes.setEditable(this.isEditable());
            this.taNotes.setLineWrap(true);
            this.taNotes.setWrapStyleWord(true);
            this.taNotes.setBorder(null);
            this.taNotes.setAntiAliasingEnabled(true);
            this.taNotes.setFont(this.tfName.getFont());
            this.pnNotes.add(new JScrollPane((Component)this.taNotes));
        }
        return this.pnNotes;
    }

    protected JPanel getUsedInPanel() {
        if (this.pnUsedIn == null) {
            this.pnUsedIn = this.createPage(Messages.getString("AbstractPropertiesDialog.UsedIn"));
            this.taUsedIn = new JTextArea();
            this.taUsedIn.setEnabled(this.isEditable());
            this.pnUsedIn.add(new JScrollPane(this.taUsedIn));
            this.pnAttributes = new JPanel(new BorderLayout());
            this.pnColumns = new JPanel(new BorderLayout());
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab(ATTRIBUTES_TAB, this.pnAttributes);
            this.tabbedPane.addTab(COLUMNS_TAB, this.pnColumns);
            this.pnUsedIn.add(this.tabbedPane);
        }
        return this.pnUsedIn;
    }

    protected JPanel getSummaryPanel() {
        if (this.pnSummary == null) {
            this.pnSummary = this.createPage(Messages.getString("AbstractPropertiesDialog.Summary"));
            JPanel jpanel = new JPanel(new BorderLayout());
            this.pnSummaryGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbObjectID = new JLabel(LB_OBJECT_ID);
            lbObjectID.setPreferredSize(this.getDefaultSize());
            this.tfObjectID = new JTextField();
            this.tfObjectID.setPreferredSize(this.getDefaultSize());
            this.tfObjectID.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbObjectID, this.tfObjectID));
            JLabel lbCreator = new JLabel(LB_CREATOR);
            lbCreator.setPreferredSize(this.getDefaultSize());
            this.tfCreator = new JTextField();
            this.tfCreator.setPreferredSize(this.getDefaultSize());
            this.tfCreator.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbCreator, this.tfCreator));
            JLabel lbCreationTime = new JLabel(LB_CREATION_TIME);
            lbCreationTime.setPreferredSize(this.getDefaultSize());
            this.tfCreationTime = new JTextField();
            this.tfCreationTime.setPreferredSize(this.getDefaultSize());
            this.tfCreationTime.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbCreationTime, this.tfCreationTime));
            JLabel lbLastChangedBy = new JLabel(LB_LAST_CHANGED_BY);
            lbLastChangedBy.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedBy = new JTextField();
            this.tfLastChangedBy.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedBy.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbLastChangedBy, this.tfLastChangedBy));
            JLabel lbLastChangedTime = new JLabel(LB_LAST_CHANGED_TIME);
            lbLastChangedTime.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedTime = new JTextField();
            this.tfLastChangedTime.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedTime.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbLastChangedTime, this.tfLastChangedTime));
            JLabel lbGeneratorName = new JLabel(LB_GENERATOR_NAME);
            lbGeneratorName.setPreferredSize(this.getDefaultSize());
            this.tfGeneratorName = new JTextField();
            this.tfGeneratorName.setPreferredSize(this.getDefaultSize());
            this.tfGeneratorName.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbGeneratorName, this.tfGeneratorName));
            JLabel lbDesign = new JLabel(LB_DESIGN);
            lbDesign.setPreferredSize(this.getDefaultSize());
            this.tfDesign = new JTextField();
            this.tfDesign.setPreferredSize(this.getDefaultSize());
            this.tfDesign.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbDesign, this.tfDesign));
            this.summaryCount = this.pnSummaryGrid.getComponentCount();
            JLabel lbDataDictConnection = new JLabel(LB_SOURCE_DB_CONNECTION);
            lbDataDictConnection.setPreferredSize(this.getDefaultSize());
            this.tfDataDictConnection = new JTextField();
            this.tfDataDictConnection.setPreferredSize(this.getDefaultSize());
            this.tfDataDictConnection.setEditable(false);
            this.pnDataDictConnection = this.createRow(lbDataDictConnection, this.tfDataDictConnection);
            JLabel lbDataDictSchema = new JLabel(LB_SOURCE_DB_SCHEMA);
            if (this instanceof ColumnPropertiesDialogEx) {
                lbDataDictSchema = new JLabel(LB_SOURCE_DB_TABLE);
            }
            lbDataDictSchema.setPreferredSize(this.getDefaultSize());
            this.tfDataDictSchema = new JTextField();
            this.tfDataDictSchema.setPreferredSize(this.getDefaultSize());
            this.tfDataDictSchema.setEditable(false);
            this.pnDataDictSchema = this.createRow(lbDataDictSchema, this.tfDataDictSchema);
            JLabel lbDataDictObject = new JLabel(LB_SOURCE_DB_OBJECT);
            lbDataDictObject.setPreferredSize(this.getDefaultSize());
            this.tfDataDictObject = new JTextField();
            this.tfDataDictObject.setPreferredSize(this.getDefaultSize());
            this.tfDataDictObject.setEditable(false);
            this.pnDataDictObject = this.createRow(lbDataDictObject, this.tfDataDictObject);
            JLabel lbDDLFileName = new JLabel(LB_SOURCE_DDL_FILE);
            lbDDLFileName.setPreferredSize(this.getDefaultSize());
            this.tfDDLFileName = new JTextField();
            this.tfDDLFileName.setPreferredSize(this.getDefaultSize());
            this.tfDDLFileName.setEditable(false);
            this.pnDDLFileName = this.createRow(lbDDLFileName, this.tfDDLFileName);
            JLabel lbRemoteDesign = new JLabel(LB_REMOTE_DESIGN);
            lbRemoteDesign.setPreferredSize(this.getDefaultSize());
            this.tfRemoteDesign = new JTextField();
            this.tfRemoteDesign.setPreferredSize(this.getDefaultSize());
            this.tfRemoteDesign.setEditable(false);
            this.pnRemoteDesign = this.createRow(lbRemoteDesign, this.tfRemoteDesign);
            JLabel lbRemoteModel = new JLabel(LB_REMOTE_MODEL);
            lbRemoteModel.setPreferredSize(this.getDefaultSize());
            this.tfRemoteModel = new JTextField();
            this.tfRemoteModel.setPreferredSize(this.getDefaultSize());
            this.tfRemoteModel.setEditable(false);
            this.pnRemoteModel = this.createRow(lbRemoteModel, this.tfRemoteModel);
            JLabel lbRemoteObject = new JLabel(LB_REMOTE_OBJECT);
            lbRemoteObject.setPreferredSize(this.getDefaultSize());
            this.tfRemoteObject = new JTextField();
            this.tfRemoteObject.setPreferredSize(this.getDefaultSize());
            this.tfRemoteObject.setEditable(false);
            this.pnRemoteObject = this.createRow(lbRemoteObject, this.tfRemoteObject);
            jpanel.add((Component)this.pnSummaryGrid, "North");
            this.pnSummary.add((Component)jpanel, "Center");
        }
        return this.pnSummary;
    }

    protected JPanel getDynamicPropertiesPanel() {
        if (this.pnDynamicProperties == null) {
            JPanel jp = new JPanel(new BorderLayout());
            JButton btnAdd = new JButton(this.configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            final JButton btnRemove = new JButton(this.configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            btnRemove.setEnabled(false);
            this.pnDynamicProperties = this.createPage(Messages.getString("AbstractPropertiesDialog.DynamicProperties"));
            this.dynamicPropertiesList = new ArrayList<DynamicProperty>();
            this.dynamicPropertiesTable = new JTable(new DynamicPropertiesModel()){

                @Override
                public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                    super.changeSelection(row, column, toggle, extend);
                    if (this.editCellAt(row, column)) {
                        Component editor = this.getEditorComponent();
                        editor.requestFocusInWindow();
                    }
                }
            };
            this.dynamicPropertiesTable.setSelectionMode(0);
            this.dynamicPropertiesTable.getTableHeader().setReorderingAllowed(false);
            this.dynamicPropertiesTable.setCellSelectionEnabled(true);
            ListSelectionModel cellSelectionModel = this.dynamicPropertiesTable.getSelectionModel();
            cellSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    String selectedData = null;
                    int[] selectedRow = AbstractPropertiesDialog.this.dynamicPropertiesTable.getSelectedRows();
                    int[] selectedColumns = AbstractPropertiesDialog.this.dynamicPropertiesTable.getSelectedColumns();
                    for (int i = 0; i < selectedRow.length; ++i) {
                        for (int j = 0; j < selectedColumns.length; ++j) {
                            selectedData = (String)AbstractPropertiesDialog.this.dynamicPropertiesTable.getValueAt(selectedRow[i], selectedColumns[j]);
                            if (selectedData != null) {
                                btnRemove.setEnabled(true);
                                continue;
                            }
                            btnRemove.setEnabled(false);
                        }
                    }
                }
            });
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            btnAdd.setToolTipText(BTN_ADD);
            btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AbstractPropertiesDialog.this.dynamicPropertiesTable.getRowSorter() != null) {
                        AbstractPropertiesDialog.this.dynamicPropertiesTable.getRowSorter().setSortKeys(null);
                    }
                    AbstractPropertiesDialog.this.createAndAddDynamicProperty(AbstractPropertiesDialog.this.generateDynamicProperyName(), AbstractPropertiesDialog.EMPTY_STRING);
                    if (AbstractPropertiesDialog.this.dynamicPropertiesList.size() == 1) {
                        AbstractPropertiesDialog.this.initDynamicPropertiesTableSorter();
                    }
                    WindowsTableHeader.setSortedHeader(AbstractPropertiesDialog.this.dynamicPropertiesTable, 0);
                    int lastRow = AbstractPropertiesDialog.this.dynamicPropertiesTable.convertRowIndexToView(AbstractPropertiesDialog.this.dynamicPropertiesList.size() - 1);
                    AbstractPropertiesDialog.this.dynamicPropertiesTable.setRowSelectionInterval(lastRow, lastRow);
                    AbstractPropertiesDialog.this.dynamicPropertiesTable.updateUI();
                }
            });
            btnRemove.setToolTipText(BTN_REMOVE);
            btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractPropertiesDialog.stopCellEditing(AbstractPropertiesDialog.this.dynamicPropertiesTable);
                    int objectNumber = AbstractPropertiesDialog.this.dynamicPropertiesTable.convertRowIndexToModel(AbstractPropertiesDialog.this.dynamicPropertiesTable.getSelectedRow());
                    if (objectNumber != -1) {
                        AbstractPropertiesDialog.this.dynamicPropertiesList.remove(objectNumber);
                        if (AbstractPropertiesDialog.this.dynamicPropertiesTable.getRowSorter() != null) {
                            if (AbstractPropertiesDialog.this.dynamicPropertiesList.size() >= 1) {
                                AbstractPropertiesDialog.this.dynamicPropertiesTable.getRowSorter().setSortKeys(null);
                            } else {
                                AbstractPropertiesDialog.this.dynamicPropertiesTable.setAutoCreateRowSorter(false);
                                AbstractPropertiesDialog.this.dynamicPropertiesTable.setRowSorter(null);
                            }
                        }
                        AbstractPropertiesDialog.this.dynamicPropertiesTable.updateUI();
                    }
                    if (AbstractPropertiesDialog.this.dynamicPropertiesList.size() >= 1) {
                        WindowsTableHeader.setSortedHeader(AbstractPropertiesDialog.this.dynamicPropertiesTable, 0);
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            if (this.isEditable()) {
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            jp.add((Component)buttonGeneral, "North");
            jp.add((Component)new JScrollPane(this.dynamicPropertiesTable), "Center");
            this.pnDynamicProperties.add((Component)jp, "Center");
        }
        return this.pnDynamicProperties;
    }

    protected JPanel getUserDefinedPropertiesPanel() {
        if (this.pnUserDefinedProperties == null) {
            JPanel jpUDPs = new JPanel(new BorderLayout());
            jpUDPs.setBorder(BorderFactory.createTitledBorder(Messages.getString("AbstractPropertiesDialog.Properties")));
            this.allUDPList = new ArrayList();
            this.userDefinedPropertiesTable = new JTable(new UserDefinedPropertiesModel(this.allUDPList));
            this.userDefinedPropertiesTable.setSelectionMode(0);
            this.userDefinedPropertiesTable.getTableHeader().setReorderingAllowed(false);
            this.userDefinedPropertiesTable.setCellSelectionEnabled(true);
            TableColumn col0 = this.userDefinedPropertiesTable.getColumnModel().getColumn(0);
            col0.setCellRenderer(new UDPPropertyCellRenderer());
            TableColumn col1 = this.userDefinedPropertiesTable.getColumnModel().getColumn(1);
            col1.setCellEditor(new UDPPropertyValueCellEditor(this.allUDPList, false));
            jpUDPs.add((Component)new JScrollPane(this.userDefinedPropertiesTable), "Center");
            this.pnUserDefinedProperties = this.createPage(Messages.getString("AbstractPropertiesDialog.UserDefindProperties"));
            this.pnUserDefinedProperties.add((Component)jpUDPs, "Center");
        }
        return this.pnUserDefinedProperties;
    }

    protected JPanel createRow(Component leftComp, Component rightComp) {
        return this.createRow(leftComp, rightComp, false);
    }

    protected JPanel createRow(Component leftComp, Component rightComp, boolean leftIsCentered) {
        JPanel newRow = new JPanel(new BorderLayout());
        if (leftIsCentered) {
            newRow.add(leftComp, "Center");
            newRow.add(rightComp, "East");
        } else {
            newRow.add(leftComp, "West");
            newRow.add(rightComp, "Center");
        }
        return newRow;
    }

    protected void showComponent(Component component) {
        String componentName = component.getName();
        if (IMPACT_ANALYSIS.equalsIgnoreCase(componentName) && !this.impAnInitialized) {
            this.initImpactAnalysisTreeModel();
            this.impAnInitialized = true;
        }
        this.cardLayout.show(this.getMainPanel(), componentName);
    }

    protected DefaultMutableTreeNode addToTree(DefaultMutableTreeNode node, JPanel panel) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(panel);
        node.add(newNode);
        this.getMainPanel().add((Component)panel, panel.getName());
        return newNode;
    }

    protected JTree getTree() {
        if (this.tree == null) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(EMPTY_STRING);
            this.tree = new JTree(root);
            this.tree.setCellRenderer(new TreeRenderer());
            this.tree.addTreeSelectionListener(new TreeListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.initTree(root);
            this.tree.expandRow(0);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.setShowsRootHandles(true);
            this.tree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyChar() == '\u001b') {
                        AbstractPropertiesDialog.this.bnCancel.doClick();
                    } else if (e.getKeyCode() == 112) {
                        AbstractPropertiesDialog.this.showHelp();
                    }
                }
            });
        }
        return this.tree;
    }

    private void close() {
        Rectangle rectangle = new Rectangle(this.getLocation(), this.getSize());
        String treePath = TreeUtils.createFilePath(this.getTree().getSelectionPath());
        this.getAppView().getSettings().setDialogSettings(this.getClass().getName(), rectangle, treePath, this.splitPane.getDividerLocation());
        this.dispose();
    }

    protected void onOK() {
        if (this.canExit()) {
            this.applyMode = false;
            this.okMode = true;
            this.setProperties();
            if (this.oldGenerateInDDL != this.designObject.isMarkedGenerate()) {
                this.designObject.setMarkedGenerate(this.designObject.isMarkedGenerate());
            }
            String status = this.appView.getXMLTransformationManager().getFilteredXMLString(this.designObject);
            if (this.oldObjectStatus != null) {
                if (!this.oldObjectStatus.equals(status)) {
                    this.designObject.setDirty(true);
                }
            } else {
                this.designObject.setDirty(true);
            }
            this.designObject.setShowForFirstTime(false);
            this.close();
        }
    }

    protected void onApply() {
        if (this.canExit()) {
            this.applyMode = true;
            this.okMode = false;
            this.setProperties();
            if (this.oldGenerateInDDL != this.designObject.isMarkedGenerate()) {
                this.designObject.setMarkedGenerate(this.designObject.isMarkedGenerate());
            }
            String status = this.appView.getXMLTransformationManager().getFilteredXMLString(this.designObject);
            if (this.oldObjectStatus != null) {
                if (!this.oldObjectStatus.equals(status)) {
                    this.designObject.setDirty(true);
                    this.oldObjectStatus = status;
                }
            } else {
                this.designObject.setDirty(true);
            }
            this.designObject.setShowForFirstTime(false);
            DesignPartView dpv = this.designObject.getAppView().getCurrentDPV();
            if (dpv != null) {
                for (TopView tv : this.designObject.getViewsForDPV(dpv)) {
                    if (tv == null) continue;
                    Rectangle r = tv.getBounds();
                    if (tv.getCellView() == null) continue;
                    r = tv.getCellView().getBounds().getBounds();
                    dpv.getWorkSpace().repaint(r);
                }
            }
        }
    }

    protected void onCancel() {
        if (this.designObject.showForFirstTime()) {
            this.designObject.remove();
        }
    }

    protected boolean canExit() {
        if (StringUtilities.isNotEmpty(this.tfName.getText())) {
            return true;
        }
        MessageDialogs.showErrorMessage(this, Messages.getString("AbstractPropertiesDialog.NameCanNotBeEmpty"));
        this.tfName.requestFocus();
        return false;
    }

    protected void initLayout() {
        JScrollPane scrollPane = new JScrollPane(this.getTree());
        scrollPane.setMinimumSize(new Dimension(this.getMinimumTreeWidth(), 0));
        this.splitPane = new JSplitPane(1, scrollPane, this.getMainPanel());
        this.splitPane.setDividerSize(3);
        FlowLayout flowLayout = new FlowLayout(2);
        this.pnButtons = new JPanel(flowLayout);
        String cancelStr = Messages.getString("AbstractPropertiesDialog.Close");
        if (this.isEditable()) {
            JButton bnOK = new JButton(new AbstractAction(Messages.getString("AbstractPropertiesDialog.OK")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractPropertiesDialog.this.onOK();
                }
            });
            bnOK.setMnemonic(79);
            bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.getRootPane().setDefaultButton(bnOK);
            JButton bnApply = new JButton(new AbstractAction(Messages.getString("AbstractPropertiesDialog.Apply")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractPropertiesDialog.this.onApply();
                }
            });
            bnApply.setMnemonic(65);
            bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.pnButtons.add(bnOK);
            this.pnButtons.add(bnApply);
            cancelStr = Messages.getString("AbstractPropertiesDialog.Cancel");
            this.addEditModeButtons();
        }
        this.bnCancel = new JButton(new AbstractAction(cancelStr){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractPropertiesDialog.this.onCancel();
                AbstractPropertiesDialog.this.close();
            }
        });
        this.bnCancel.setMnemonic(67);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JButton bnHelp = new JButton(new AbstractAction(Messages.getString("AbstractPropertiesDialog.Help")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractPropertiesDialog.this.showHelp();
            }
        });
        bnHelp.setMnemonic(72);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.pnButtons.add(this.bnCancel);
        this.pnButtons.add(bnHelp);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.getContentPane().add((Component)this.pnButtons, "South");
    }

    protected JPanel getMeasurementsPanel() {
        if (this.pnMeasurements == null) {
            this.pnMeasurements = this.createPage(Messages.getString("AbstractPropertiesDialog.Measurements"));
            this.mList = new ArrayList();
            this.mModel = new MeasurementModel();
            this.mTable = new JTable(this.mModel);
            this.mTable.setSelectionMode(0);
            this.mTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Measurement m;
                    int row;
                    if (e.getClickCount() == 2 && (row = AbstractPropertiesDialog.this.mTable.convertRowIndexToModel(AbstractPropertiesDialog.this.mTable.getSelectedRow())) != -1 && AbstractPropertiesDialog.this.mList.size() > 0 && row < AbstractPropertiesDialog.this.mList.size() && !(m = (Measurement)AbstractPropertiesDialog.this.mList.get(row)).isDialogVisible()) {
                        MeasurementPropertiesDialog dialog = new MeasurementPropertiesDialog((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), m, AbstractPropertiesDialog.this.mTable);
                        dialog.initProperties(m);
                        dialog.setModal(((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime());
                        dialog.show();
                        AbstractPropertiesDialog.this.mTable.updateUI();
                    }
                }
            });
            JScrollPane mpane = new JScrollPane(this.mTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            final JButton btnProperties = new JButton(this.configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setEnabled(false);
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Measurement m;
                    int row = AbstractPropertiesDialog.this.mTable.convertRowIndexToModel(AbstractPropertiesDialog.this.mTable.getSelectedRow());
                    if (row != -1 && AbstractPropertiesDialog.this.mList.size() > 0 && row < AbstractPropertiesDialog.this.mList.size() && !(m = (Measurement)AbstractPropertiesDialog.this.mList.get(row)).isDialogVisible()) {
                        MeasurementPropertiesDialog dialog = new MeasurementPropertiesDialog((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), m, AbstractPropertiesDialog.this.mTable);
                        dialog.initProperties(m);
                        dialog.setModal(((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime());
                        dialog.show();
                        AbstractPropertiesDialog.this.mTable.updateUI();
                    }
                }
            });
            JButton btnAdd = new JButton(this.configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            btnAdd.setToolTipText(BTN_ADD);
            btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Measurement m = new Measurement(AbstractPropertiesDialog.this.designObject.getDesignPart());
                    m.setName(AbstractPropertiesDialog.this.generateMeasurementName());
                    m.setDesign(AbstractPropertiesDialog.this.designObject.getDesign());
                    m.setObject(AbstractPropertiesDialog.this.designObject);
                    if (AbstractPropertiesDialog.this.mTable.getRowSorter() != null) {
                        AbstractPropertiesDialog.this.mTable.getRowSorter().setSortKeys(null);
                    }
                    AbstractPropertiesDialog.this.mList.add(m);
                    if (AbstractPropertiesDialog.this.mList.size() == 1) {
                        AbstractPropertiesDialog.this.initMeasurementsSorter();
                    }
                    WindowsTableHeader.setSortedHeader(AbstractPropertiesDialog.this.mTable, 0);
                    int lastRow = AbstractPropertiesDialog.this.mTable.convertRowIndexToView(AbstractPropertiesDialog.this.mList.size() - 1);
                    AbstractPropertiesDialog.this.mTable.setRowSelectionInterval(lastRow, lastRow);
                    AbstractPropertiesDialog.this.mTable.updateUI();
                }
            });
            final JButton btnRemove = new JButton(this.configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            btnRemove.setToolTipText(BTN_REMOVE);
            btnRemove.setEnabled(false);
            btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int objectNumber = AbstractPropertiesDialog.this.mTable.convertRowIndexToModel(AbstractPropertiesDialog.this.mTable.getSelectedRow());
                    if (objectNumber != -1) {
                        if (AbstractPropertiesDialog.this.mList.size() > 0 && objectNumber < AbstractPropertiesDialog.this.mList.size()) {
                            AbstractPropertiesDialog.this.mList.remove(objectNumber);
                            if (AbstractPropertiesDialog.this.mTable.getRowSorter() != null) {
                                if (AbstractPropertiesDialog.this.mList.size() >= 1) {
                                    AbstractPropertiesDialog.this.mTable.getRowSorter().setSortKeys(null);
                                } else {
                                    AbstractPropertiesDialog.this.mTable.setAutoCreateRowSorter(false);
                                    AbstractPropertiesDialog.this.mTable.setRowSorter(null);
                                }
                            }
                            AbstractPropertiesDialog.this.mTable.updateUI();
                        }
                        if (AbstractPropertiesDialog.this.mList.size() >= 1) {
                            WindowsTableHeader.setSortedHeader(AbstractPropertiesDialog.this.mTable, 0);
                        }
                    }
                }
            });
            this.mTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (AbstractPropertiesDialog.this.mList.isEmpty()) {
                        btnRemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                    } else if (AbstractPropertiesDialog.this.mTable.getSelectedRow() > -1) {
                        btnRemove.setEnabled(true);
                        btnProperties.setEnabled(true);
                    } else {
                        btnRemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            JPanel mPanel = new JPanel(new BorderLayout());
            mPanel.add((Component)buttonGeneral, "North");
            mPanel.add((Component)mpane, "Center");
            this.pnMeasurements.add((Component)mPanel, "Center");
            this.mTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int objectNumber;
                    if (AbstractPropertiesDialog.this.isEditable() && e.getKeyCode() == 127 && (objectNumber = AbstractPropertiesDialog.this.mTable.getSelectedRow()) != -1 && AbstractPropertiesDialog.this.mList.size() > 0 && objectNumber < AbstractPropertiesDialog.this.mList.size()) {
                        AbstractPropertiesDialog.this.mList.remove(objectNumber);
                        AbstractPropertiesDialog.this.mTable.updateUI();
                    }
                }
            });
        }
        return this.pnMeasurements;
    }

    protected String generateMeasurementName() {
        String m = Messages.getString("AbstractPropertiesDialog.Measurement");
        int newNumber = 0;
        int lastNumber = this.mList.size();
        if (lastNumber != 0) {
            newNumber = this.mCounter = lastNumber + 1;
        } else {
            ++this.mCounter;
            newNumber = this.mCounter;
        }
        String mName = m.concat("_").concat(Integer.toString(newNumber));
        while (this.measurementExists(mName)) {
            newNumber = ++this.mCounter;
            mName = m.concat("_").concat(Integer.toString(newNumber));
        }
        return mName;
    }

    private boolean measurementExists(String name) {
        for (int i = 0; i < this.mList.size(); ++i) {
            Measurement m = (Measurement)this.mList.get(i);
            if (!name.equalsIgnoreCase(m.getName())) continue;
            return true;
        }
        return false;
    }

    protected void initMeasurements() {
        this.mList.addAll(this.designObject.getMeasurements());
        this.initMeasurementsSorter();
    }

    protected void setMeasurements() {
        this.setMeasurements(this.designObject);
    }

    protected void setMeasurements(DesignObject object) {
        ArrayList<Measurement> delList = new ArrayList<Measurement>();
        List measurements = object.getMeasurements();
        for (int i = 0; i < measurements.size(); ++i) {
            Measurement m = (Measurement)measurements.get(i);
            if (this.mList.contains(m)) continue;
            delList.add(m);
        }
        Iterator it = delList.iterator();
        while (it.hasNext()) {
            object.removeMeasurement((Measurement)it.next());
        }
        Object[] mSet = this.mList.toArray();
        for (int i = 0; i < mSet.length; ++i) {
            Object ob = mSet[i];
            if (!(ob instanceof Measurement) || object.getMeasurements().contains(ob)) continue;
            object.addMeasurement((Measurement)ob);
        }
    }

    protected void initChangeRequests() {
        this.reqList.addAll(this.designObject.getRequests());
        this.initChangeRequestsSorter();
    }

    protected void setChangeRequests() {
        this.setChangeRequests(this.designObject);
    }

    protected void setChangeRequests(DesignObject object) {
        object.clearRequests();
        for (ChangeRequest request : this.reqList) {
            object.addRequest(request);
        }
    }

    protected JPanel getChangeRequestsPanel() {
        if (this.pnChangeRequests == null) {
            this.pnChangeRequests = this.createPage(Messages.getString("AbstractPropertiesDialog.ChangeRequests"));
            this.reqList = new ArrayList();
            this.reqModel = new ChangeRequestModel();
            this.reqTable = new JTable(this.reqModel);
            this.reqTable.setSelectionMode(0);
            this.reqTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = AbstractPropertiesDialog.this.reqTable.convertRowIndexToModel(AbstractPropertiesDialog.this.reqTable.getSelectedRow())) != -1 && AbstractPropertiesDialog.this.reqList.size() > 0 && row < AbstractPropertiesDialog.this.reqList.size()) {
                        ChangeRequest request = (ChangeRequest)AbstractPropertiesDialog.this.reqList.get(row);
                        ChangeRequestPropertiesDialog dialog = new ChangeRequestPropertiesDialog((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), request, AbstractPropertiesDialog.this.reqTable);
                        dialog.initProperties(request);
                        dialog.setModal(((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime());
                        dialog.show();
                        AbstractPropertiesDialog.this.reqTable.updateUI();
                    }
                }
            });
            JScrollPane reqPane = new JScrollPane(this.reqTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            final JButton btnProperties = new JButton(this.configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AbstractPropertiesDialog.this.reqTable.convertRowIndexToModel(AbstractPropertiesDialog.this.reqTable.getSelectedRow());
                    if (row != -1 && AbstractPropertiesDialog.this.reqList.size() > 0 && row < AbstractPropertiesDialog.this.reqList.size()) {
                        ChangeRequest request = (ChangeRequest)AbstractPropertiesDialog.this.reqList.get(row);
                        ChangeRequestPropertiesDialog dialog = new ChangeRequestPropertiesDialog((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), request, AbstractPropertiesDialog.this.reqTable);
                        dialog.initProperties(request);
                        dialog.setModal(((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime());
                        dialog.show();
                        AbstractPropertiesDialog.this.reqTable.updateUI();
                    }
                }
            });
            JButton btnAdd = new JButton(this.configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            btnAdd.setToolTipText(BTN_ADD);
            btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddChangeRequestDialog dialog = new AddChangeRequestDialog(AbstractPropertiesDialog.this.getAppView(), AbstractPropertiesDialog.this.designObject, AbstractPropertiesDialog.this.reqList);
                    dialog.showDialog();
                    if (AddChangeRequestDialog.isChangeRequestAdded()) {
                        if (AbstractPropertiesDialog.this.reqTable.getRowSorter() != null) {
                            AbstractPropertiesDialog.this.reqTable.getRowSorter().setSortKeys(null);
                        }
                        if (AbstractPropertiesDialog.this.reqList.size() == 1) {
                            AbstractPropertiesDialog.this.initChangeRequestsSorter();
                        }
                        WindowsTableHeader.setSortedHeader(AbstractPropertiesDialog.this.reqTable, 0);
                        int lastRow = AbstractPropertiesDialog.this.reqTable.convertRowIndexToView(AbstractPropertiesDialog.this.reqList.size() - 1);
                        AbstractPropertiesDialog.this.reqTable.setRowSelectionInterval(lastRow, lastRow);
                    }
                    AbstractPropertiesDialog.this.reqTable.updateUI();
                }
            });
            final JButton btnRemove = new JButton(this.configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            btnRemove.setToolTipText(BTN_REMOVE);
            btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int objectNumber = AbstractPropertiesDialog.this.reqTable.convertRowIndexToModel(AbstractPropertiesDialog.this.reqTable.getSelectedRow());
                    if (objectNumber != -1) {
                        if (AbstractPropertiesDialog.this.reqList.size() > 0 && objectNumber < AbstractPropertiesDialog.this.reqList.size()) {
                            ChangeRequest request = (ChangeRequest)AbstractPropertiesDialog.this.reqList.get(objectNumber);
                            request.removeObject(AbstractPropertiesDialog.this.designObject);
                            AbstractPropertiesDialog.this.reqList.remove(objectNumber);
                            if (AbstractPropertiesDialog.this.reqTable.getRowSorter() != null) {
                                if (AbstractPropertiesDialog.this.reqList.size() >= 1) {
                                    AbstractPropertiesDialog.this.reqTable.getRowSorter().setSortKeys(null);
                                } else {
                                    AbstractPropertiesDialog.this.reqTable.setAutoCreateRowSorter(false);
                                    AbstractPropertiesDialog.this.reqTable.setRowSorter(null);
                                }
                            }
                            AbstractPropertiesDialog.this.reqTable.updateUI();
                        }
                        if (AbstractPropertiesDialog.this.reqList.size() >= 1) {
                            WindowsTableHeader.setSortedHeader(AbstractPropertiesDialog.this.reqTable, 0);
                        }
                    }
                }
            });
            this.reqTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (AbstractPropertiesDialog.this.reqList.isEmpty()) {
                        btnRemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                    } else {
                        btnRemove.setEnabled(true);
                        btnProperties.setEnabled(true);
                    }
                }
            });
            this.reqTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (AbstractPropertiesDialog.this.reqList.isEmpty()) {
                        btnRemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                    } else {
                        btnRemove.setEnabled(true);
                        btnProperties.setEnabled(true);
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            JPanel reqPanel = new JPanel(new BorderLayout());
            reqPanel.add((Component)buttonGeneral, "North");
            reqPanel.add((Component)reqPane, "Center");
            this.pnChangeRequests.add((Component)reqPanel, "Center");
            this.reqTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int objectNumber;
                    if (AbstractPropertiesDialog.this.isEditable() && e.getKeyCode() == 127 && (objectNumber = AbstractPropertiesDialog.this.reqTable.getSelectedRow()) != -1 && AbstractPropertiesDialog.this.reqList.size() > 0 && objectNumber < AbstractPropertiesDialog.this.reqList.size()) {
                        ChangeRequest request = (ChangeRequest)AbstractPropertiesDialog.this.reqList.get(objectNumber);
                        request.removeObject(AbstractPropertiesDialog.this.designObject);
                        AbstractPropertiesDialog.this.reqList.remove(objectNumber);
                        AbstractPropertiesDialog.this.reqTable.updateUI();
                    }
                }
            });
        }
        return this.pnChangeRequests;
    }

    protected void initResponsibleParties() {
        this.rpList.addAll(this.designObject.getResponsibleParties());
        this.initResponsiblePartiesSorter();
    }

    protected void setResponsibleParties() {
        this.setResponsibleParties(this.designObject);
    }

    protected void setResponsibleParties(DesignObject object) {
        object.clearResponsibleParties();
        for (BIResponsibleParty party : this.rpList) {
            object.addResponsibleParty(party);
        }
    }

    protected JPanel getResPartiesPanel() {
        if (this.pnResParties == null) {
            this.pnResParties = this.createPage(Messages.getString("AbstractPropertiesDialog.ResponsibleParties"));
            this.rpList = new ArrayList();
            this.rpModel = new ResPartyModel();
            this.rpTable = new JTable(this.rpModel);
            this.rpTable.setSelectionMode(0);
            this.rpTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = AbstractPropertiesDialog.this.rpTable.convertRowIndexToModel(AbstractPropertiesDialog.this.rpTable.getSelectedRow())) != -1 && AbstractPropertiesDialog.this.rpList.size() > 0 && row < AbstractPropertiesDialog.this.rpList.size()) {
                        DesignObject object = (DesignObject)AbstractPropertiesDialog.this.rpList.get(row);
                        object.showModal = ((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime();
                        ResponsiblePartyPropertiesDialogEx dialog = new ResponsiblePartyPropertiesDialogEx((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), object, AbstractPropertiesDialog.this.rpTable);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JScrollPane rpPane = new JScrollPane(this.rpTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            final JButton btnProperties = new JButton(this.configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AbstractPropertiesDialog.this.rpTable.convertRowIndexToModel(AbstractPropertiesDialog.this.rpTable.getSelectedRow());
                    if (row != -1 && AbstractPropertiesDialog.this.rpList.size() > 0 && row < AbstractPropertiesDialog.this.rpList.size()) {
                        DesignObject object = (DesignObject)AbstractPropertiesDialog.this.rpList.get(row);
                        object.showModal = ((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime();
                        ResponsiblePartyPropertiesDialogEx dialog = new ResponsiblePartyPropertiesDialogEx((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), object, AbstractPropertiesDialog.this.rpTable);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JButton btnAdd = new JButton(this.configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            btnAdd.setToolTipText(BTN_ADD);
            btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddPartyDialog dialog = new AddPartyDialog(AbstractPropertiesDialog.this.getAppView(), AbstractPropertiesDialog.this.designObject.getDesign(), AbstractPropertiesDialog.this.rpList);
                    dialog.setVisible(true);
                    if (AbstractAddObjectDialog.isObjectAdded()) {
                        if (AbstractPropertiesDialog.this.rpTable.getRowSorter() != null) {
                            AbstractPropertiesDialog.this.rpTable.getRowSorter().setSortKeys(null);
                        }
                        if (AbstractPropertiesDialog.this.rpList.size() == 1) {
                            AbstractPropertiesDialog.this.initResponsiblePartiesSorter();
                        }
                        WindowsTableHeader.setSortedHeader(AbstractPropertiesDialog.this.rpTable, 0);
                        int lastRow = AbstractPropertiesDialog.this.rpTable.convertRowIndexToView(AbstractPropertiesDialog.this.rpList.size() - 1);
                        AbstractPropertiesDialog.this.rpTable.setRowSelectionInterval(lastRow, lastRow);
                    }
                    AbstractPropertiesDialog.this.rpTable.updateUI();
                }
            });
            final JButton btnRemove = new JButton(this.configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            btnRemove.setToolTipText(BTN_REMOVE);
            btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int objectNumber = AbstractPropertiesDialog.this.rpTable.getSelectedRow();
                    if (objectNumber != -1) {
                        if (AbstractPropertiesDialog.this.rpList.size() > 0 && objectNumber < AbstractPropertiesDialog.this.rpList.size()) {
                            AbstractPropertiesDialog.this.rpList.remove(objectNumber);
                            if (AbstractPropertiesDialog.this.rpTable.getRowSorter() != null) {
                                if (AbstractPropertiesDialog.this.rpList.size() >= 1) {
                                    AbstractPropertiesDialog.this.rpTable.getRowSorter().setSortKeys(null);
                                } else {
                                    AbstractPropertiesDialog.this.rpTable.setAutoCreateRowSorter(false);
                                    AbstractPropertiesDialog.this.rpTable.setRowSorter(null);
                                }
                            }
                            AbstractPropertiesDialog.this.rpTable.updateUI();
                        }
                        if (AbstractPropertiesDialog.this.rpList.size() >= 1) {
                            WindowsTableHeader.setSortedHeader(AbstractPropertiesDialog.this.rpTable, 0);
                        }
                    }
                }
            });
            this.rpTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (AbstractPropertiesDialog.this.rpList.isEmpty()) {
                        btnRemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                    } else {
                        btnRemove.setEnabled(true);
                        btnProperties.setEnabled(true);
                    }
                }
            });
            this.rpTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (AbstractPropertiesDialog.this.rpList.isEmpty()) {
                        btnRemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                    } else {
                        btnRemove.setEnabled(true);
                        btnProperties.setEnabled(true);
                    }
                }
            });
            JPanel rpPanel = new JPanel(new BorderLayout());
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            rpPanel.add((Component)buttonGeneral, "North");
            rpPanel.add((Component)rpPane, "Center");
            this.pnResParties.add((Component)rpPanel, "Center");
            this.rpTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int objectNumber;
                    if (AbstractPropertiesDialog.this.isEditable() && e.getKeyCode() == 127 && (objectNumber = AbstractPropertiesDialog.this.rpTable.getSelectedRow()) != -1 && AbstractPropertiesDialog.this.rpList.size() > 0 && objectNumber < AbstractPropertiesDialog.this.rpList.size()) {
                        AbstractPropertiesDialog.this.rpList.remove(objectNumber);
                        AbstractPropertiesDialog.this.rpTable.updateUI();
                    }
                }
            });
        }
        return this.pnResParties;
    }

    protected void initDefaults() {
        this.initDefaults(true);
    }

    protected void initDefaults(boolean initCommentsInRDBMS) {
        this.tfName.setText(this.designObject.getName());
        if (this.designObject.isNameFixed()) {
            this.tfName.setEnabled(false);
            this.tfName.setToolTipText(NAME_IS_FROZEN);
        }
        this.taComments.setText(this.designObject.getComment());
        if (initCommentsInRDBMS) {
            this.taCommentsInRDBMS.setText(this.designObject.getCommentInRDBMS());
        }
        this.taNotes.setText(this.designObject.getNotes());
        this.tfObjectID.setText(this.designObject.getObjectID());
        this.tfCreationTime.setText(this.designObject.getCreationTime());
        this.tfCreator.setText(this.designObject.getCreator().getName());
        this.tfDesign.setText(this.designObject.getOwnerDesignName());
        if (this.designObject.getGenerator() != null) {
            this.tfGeneratorName.setText(this.designObject.getGeneratorLongName());
        } else {
            this.tfGeneratorName.setText(NONE);
        }
        this.tfLastChangedBy.setText(this.designObject.getChanger().getName());
        this.tfLastChangedTime.setText(this.designObject.getChangeTime());
        this.initSummaryExtras();
    }

    protected void initSummaryExtras() {
        for (int i = this.pnSummaryGrid.getComponentCount(); i > this.summaryCount; --i) {
            this.pnSummaryGrid.remove(i - 1);
        }
        if (!EMPTY_STRING.equals(this.designObject.getSourceConnName())) {
            this.pnSummaryGrid.add(this.pnDataDictConnection);
            this.pnSummaryGrid.add(this.pnDataDictSchema);
            this.pnSummaryGrid.add(this.pnDataDictObject);
            this.tfDataDictConnection.setText(this.designObject.getSourceConnName());
            this.tfDataDictSchema.setText(this.designObject.getSourceObjSchema());
            this.tfDataDictObject.setText(this.designObject.getSourceObjName());
        }
        if (!EMPTY_STRING.equals(this.designObject.getSourceDDLFile())) {
            this.pnSummaryGrid.add(this.pnDDLFileName);
            this.tfDDLFileName.setText(this.designObject.getSourceDDLFile());
        }
        if (this.designObject.isRemoteObject()) {
            Design des;
            Design.DesignStorageDesc desc = this.designObject.getDesign().getDesignStorageDesc(this.designObject.getRemoteDesignID());
            if (desc != null && !desc.getDesignID().equals(this.designObject.getDesign().getObjectID())) {
                this.pnSummaryGrid.add(this.pnRemoteDesign);
                this.tfRemoteDesign.setText(desc.getDesignStoragePath());
            }
            RelationalDesign rd = null;
            LogicalDesign ld = null;
            DesignObject remoteObj = null;
            if (desc != null && (des = (Design)this.designObject.getAppView().getDesigns().getObjectByID(desc.getDesignID())) != null) {
                if (this.designObject.getDesignPart() instanceof RelationalDesign) {
                    rd = (RelationalDesign)des.getRelationalDesigns().getObjectByID(this.designObject.getRemoteModelID());
                } else if (this.designObject.getDesignPart() instanceof LogicalDesign) {
                    ld = des.getLogicalDesign();
                }
                remoteObj = des.getDesignObject(this.designObject.getRemoteObjectID());
            }
            if (rd == null) {
                rd = (RelationalDesign)this.designObject.getDesign().getRelationalDesigns().getObjectByID(this.designObject.getRemoteModelID());
            }
            this.pnSummaryGrid.add(this.pnRemoteModel);
            if (rd != null) {
                this.tfRemoteModel.setText(rd.getName());
            } else if (ld != null) {
                this.tfRemoteModel.setText(ld.getName());
            } else {
                this.tfRemoteModel.setText(this.designObject.getRemoteModelID());
            }
            this.pnSummaryGrid.add(this.pnRemoteObject);
            if (remoteObj != null) {
                this.tfRemoteObject.setText(remoteObj.getName());
            } else {
                this.tfRemoteObject.setText(this.designObject.getRemoteObjectID());
            }
        }
        this.pnSummaryGrid.validate();
    }

    protected void initDocuments() {
        this.docList.addAll(this.designObject.getDocuments());
        this.initDocumentsSorter();
    }

    protected void setDocuments() {
        this.setDocuments(this.designObject);
    }

    protected void setDocuments(DesignObject object) {
        object.clearDocuments();
        for (BIDocument doc : this.docList) {
            object.addDocument(doc);
        }
    }

    protected JPanel getDocumentsPanel() {
        if (this.pnDocuments == null) {
            this.pnDocuments = this.createPage(Messages.getString("AbstractPropertiesDialog.Documents"));
            this.docList = new ArrayList();
            this.docModel = new DocumentTableModel();
            this.docTable = new JTable(this.docModel);
            this.docTable.setSelectionMode(0);
            this.docTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = AbstractPropertiesDialog.this.docTable.convertRowIndexToModel(AbstractPropertiesDialog.this.docTable.getSelectedRow())) != -1 && AbstractPropertiesDialog.this.docList.size() > 0 && row < AbstractPropertiesDialog.this.docList.size()) {
                        DesignObject object = (DesignObject)AbstractPropertiesDialog.this.docList.get(row);
                        object.showModal = ((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime();
                        DocumentPropertiesDialogEx dialog = new DocumentPropertiesDialogEx((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), object, AbstractPropertiesDialog.this.docTable);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JScrollPane docPane = new JScrollPane(this.docTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            final JButton btnProperties = new JButton(this.configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AbstractPropertiesDialog.this.docTable.convertRowIndexToModel(AbstractPropertiesDialog.this.docTable.getSelectedRow());
                    if (row != -1 && AbstractPropertiesDialog.this.docList.size() > 0 && row < AbstractPropertiesDialog.this.docList.size()) {
                        DesignObject object = (DesignObject)AbstractPropertiesDialog.this.docList.get(row);
                        object.showModal = ((AbstractPropertiesDialog)AbstractPropertiesDialog.this).designObject.showModal || AbstractPropertiesDialog.this.designObject.showForFirstTime();
                        DocumentPropertiesDialogEx dialog = new DocumentPropertiesDialogEx((Dialog)AbstractPropertiesDialog.this, AbstractPropertiesDialog.this.getAppView(), object, AbstractPropertiesDialog.this.docTable);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JButton btnAdd = new JButton(this.configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            btnAdd.setToolTipText(BTN_ADD);
            btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddDocumentDialog dialog = new AddDocumentDialog(AbstractPropertiesDialog.this.getAppView(), AbstractPropertiesDialog.this.designObject.getDesign(), AbstractPropertiesDialog.this.docList);
                    dialog.setVisible(true);
                    if (AbstractAddObjectDialog.isObjectAdded()) {
                        if (AbstractPropertiesDialog.this.docTable.getRowSorter() != null) {
                            AbstractPropertiesDialog.this.docTable.getRowSorter().setSortKeys(null);
                        }
                        if (AbstractPropertiesDialog.this.docList.size() == 1) {
                            AbstractPropertiesDialog.this.initDocumentsSorter();
                        }
                        WindowsTableHeader.setSortedHeader(AbstractPropertiesDialog.this.docTable, 0);
                        int lastRow = AbstractPropertiesDialog.this.docTable.convertRowIndexToView(AbstractPropertiesDialog.this.docList.size() - 1);
                        AbstractPropertiesDialog.this.docTable.setRowSelectionInterval(lastRow, lastRow);
                    }
                    AbstractPropertiesDialog.this.docTable.updateUI();
                }
            });
            final JButton btnRemove = new JButton(this.configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            btnRemove.setToolTipText(BTN_REMOVE);
            btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int objectNumber = AbstractPropertiesDialog.this.docTable.convertRowIndexToModel(AbstractPropertiesDialog.this.docTable.getSelectedRow());
                    if (objectNumber != -1) {
                        if (AbstractPropertiesDialog.this.docList.size() > 0 && objectNumber < AbstractPropertiesDialog.this.docList.size()) {
                            AbstractPropertiesDialog.this.docList.remove(objectNumber);
                            if (AbstractPropertiesDialog.this.docTable.getRowSorter() != null) {
                                if (AbstractPropertiesDialog.this.docList.size() >= 1) {
                                    AbstractPropertiesDialog.this.docTable.getRowSorter().setSortKeys(null);
                                } else {
                                    AbstractPropertiesDialog.this.docTable.setAutoCreateRowSorter(false);
                                    AbstractPropertiesDialog.this.docTable.setRowSorter(null);
                                }
                            }
                            AbstractPropertiesDialog.this.docTable.updateUI();
                        }
                        if (AbstractPropertiesDialog.this.docList.size() >= 1) {
                            WindowsTableHeader.setSortedHeader(AbstractPropertiesDialog.this.docTable, 0);
                        }
                    }
                }
            });
            this.docTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (AbstractPropertiesDialog.this.docList.isEmpty()) {
                        btnRemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                    } else {
                        btnRemove.setEnabled(true);
                        btnProperties.setEnabled(true);
                    }
                }
            });
            this.docTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (AbstractPropertiesDialog.this.docList.isEmpty()) {
                        btnRemove.setEnabled(false);
                        btnProperties.setEnabled(false);
                    } else {
                        btnRemove.setEnabled(true);
                        btnProperties.setEnabled(true);
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            JPanel docPanel = new JPanel(new BorderLayout());
            docPanel.add((Component)buttonGeneral, "North");
            docPanel.add((Component)docPane, "Center");
            this.pnDocuments.add((Component)docPanel, "Center");
            this.docTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int objectNumber;
                    if (AbstractPropertiesDialog.this.isEditable() && e.getKeyCode() == 127 && (objectNumber = AbstractPropertiesDialog.this.docTable.getSelectedRow()) != -1 && AbstractPropertiesDialog.this.docList.size() > 0 && objectNumber < AbstractPropertiesDialog.this.docList.size()) {
                        AbstractPropertiesDialog.this.docList.remove(objectNumber);
                        AbstractPropertiesDialog.this.docTable.updateUI();
                    }
                }
            });
        }
        return this.pnDocuments;
    }

    protected JPanel getScriptPanel() {
        if (this.pnScript == null) {
            this.pnScript = this.createPage(Messages.getString("AbstractPropertiesDialog.Scripts"));
            JPanel jpanel = new JPanel(new BorderLayout());
            this.taBeforeDrop = new SQLSyntaxTextArea(false);
            this.taBeforeDrop.setEditable(this.isEditable());
            this.taBeforeCreate = new SQLSyntaxTextArea(false);
            this.taBeforeCreate.setEditable(this.isEditable());
            this.taAfterCreate = new SQLSyntaxTextArea(false);
            this.taAfterCreate.setEditable(this.isEditable());
            this.taEndOfScript = new SQLSyntaxTextArea(false);
            this.taEndOfScript.setEditable(this.isEditable());
            this.addTab(this.taBeforeDrop, Messages.getString("AbstractPropertiesDialog.BeforeDropRename"));
            this.addTab(this.taBeforeCreate, Messages.getString("AbstractPropertiesDialog.BeforeCreate"));
            this.addTab(this.taAfterCreate, Messages.getString("AbstractPropertiesDialog.AfterCreate"));
            this.addTab(this.taEndOfScript, Messages.getString("AbstractPropertiesDialog.EndOfScript"));
            jpanel.add((Component)this.tpane, "Center");
            JPanel jpanelBottom = new JPanel(new BorderLayout());
            JLabel lbGenerateScript = new JLabel(LB_GENERATE);
            this.chGenerateScript = new JCheckBox();
            this.chGenerateScript.setPreferredSize(new Dimension(20, 20));
            this.chGenerateScript.setSelected(false);
            this.chGenerateScript.setEnabled(this.isEditable());
            jpanelBottom.add((Component)this.chGenerateScript, "West");
            jpanelBottom.add(lbGenerateScript);
            if (this.designObject instanceof Table || this.designObject instanceof TableView) {
                JButton bnAddVariables = new JButton(Messages.getString("AbstractPropertiesDialog.AddVariable"));
                bnAddVariables.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (AbstractPropertiesDialog.this.designObject instanceof Table) {
                            String[][] variables = new String[][]{{"{table}", Messages.getString("AbstractPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("AbstractPropertiesDialog.TableAbbreviation")}, {"{schema}", Messages.getString("AbstractPropertiesDialog.SchemaName")}, {"{long name}", Messages.getString("AbstractPropertiesDialog.LongName")}, {"{pk name}", Messages.getString("AbstractPropertiesDialog.PKName")}};
                            AbstractPropertiesDialog.this.addVariableDialog(variables);
                        } else {
                            String[][] variables = new String[][]{{"{view}", Messages.getString("AbstractPropertiesDialog.ViewName")}, {"{schema}", Messages.getString("AbstractPropertiesDialog.SchemaName")}, {"{long name}", Messages.getString("AbstractPropertiesDialog.LongName")}};
                            AbstractPropertiesDialog.this.addVariableDialog(variables);
                        }
                    }
                });
                jpanelBottom.add((Component)bnAddVariables, "East");
            }
            jpanel.add((Component)jpanelBottom, "South");
            this.pnScript.add(jpanel);
        }
        return this.pnScript;
    }

    private void addTab(RSyntaxTextArea textArea, String label) {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane();
        }
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.add((Component)new RTextScrollPane((RTextArea)textArea));
        this.tpane.add((Component)panel, label);
    }

    protected void addVariableDialog(String[][] variables) {
        RTextArea textArea;
        Component scrollPane;
        AbstractPP.KeyDialog keyDialog = new AbstractPP.KeyDialog(this.designObject.getAppView(), null);
        keyDialog.setValues(variables);
        keyDialog.setVisible(true);
        String variable = keyDialog.getProviderName();
        Component tabPanel = this.tpane.getSelectedComponent();
        if (tabPanel != null && (scrollPane = tabPanel.getComponentAt(0, 0)) instanceof RTextScrollPane && (textArea = ((RTextScrollPane)scrollPane).getTextArea()) != null) {
            if (variable.length() > 0) {
                textArea.replaceSelection(variable);
            }
            textArea.requestFocusInWindow();
        }
    }

    protected int getMinimumTreeWidth() {
        return 190;
    }

    protected boolean isEditable() {
        if (this.getDesignObject().getDesign().isHidden()) {
            return false;
        }
        if (this.getDesignObject().isReadOnly()) {
            return false;
        }
        if (this.getDesignObject().isRemoteObject()) {
            return false;
        }
        if (ApplicationView.IS_VIEWER) {
            return false;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            return this.designObject.getDesignPart() instanceof LogicalDesign;
        }
        return true;
    }

    protected void addEditModeButtons() {
    }

    protected JTree initImpactAnalysisTreeModel() {
        return null;
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent arg0) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent arg0) throws ExpandVetoException {
        ModelIdObjectSelection sel;
        Object object = arg0.getPath().getLastPathComponent();
        if (object instanceof ModelIdObjectSelection && !(sel = (ModelIdObjectSelection)object).isLoaded()) {
            sel.load();
        }
    }

    protected void checkDesignRule(DesignRule designRule, DesignObject object) {
        designRule.init();
        CheckResult result = designRule.doCheck(object);
        if (!result.isOk()) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), object.getName() + ": " + result.getMessage(), Messages.getString("AbstractPropertiesDialog.NamingOptions"), 2);
        }
    }

    private DynamicProperty createAndAddDynamicProperty(String name, String value) {
        DynamicProperty dp = new DynamicProperty(EMPTY_STRING, EMPTY_STRING);
        dp.setName(name);
        dp.setValue(value);
        this.getDynamicPropertiesList().add(dp);
        return dp;
    }

    public List getDynamicPropertiesList() {
        if (this.dynamicPropertiesList == null) {
            this.dynamicPropertiesList = new ArrayList<DynamicProperty>();
        }
        return this.dynamicPropertiesList;
    }

    protected String generateDynamicProperyName() {
        String name = "DynamicProperty";
        int newNumber = 0;
        int lastNumber = this.dynamicPropertiesList.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String dpName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.dynamicProperyExists(dpName)) {
            newNumber = ++this.cgCounter;
            dpName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return dpName;
    }

    private boolean dynamicProperyExists(String name) {
        for (int i = 0; i < this.dynamicPropertiesList.size(); ++i) {
            DynamicProperty dp = this.dynamicPropertiesList.get(i);
            if (!name.equalsIgnoreCase(dp.getName())) continue;
            return true;
        }
        return false;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    protected String translate(String value, String[] inputValues, String[] outputValues) {
        for (int i = 0; i < inputValues.length; ++i) {
            if (!inputValues[i].equals(value)) continue;
            return outputValues[i];
        }
        return EMPTY_STRING;
    }

    protected String translateWithPassThrough(String value, String[] inputValues, String[] outputValues) {
        for (int i = 0; i < inputValues.length; ++i) {
            if (!inputValues[i].equals(value)) continue;
            return outputValues[i];
        }
        return value;
    }

    public void initDynamicProperties() {
        try {
            this.dynamicPropertiesList.clear();
            Iterator it = this.designObject.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                boolean notUDP = false;
                for (UserDefinedProperty p : this.designObject.getDesign().getUserDefinedProperties()) {
                    if (!propName.equals(p.getName())) continue;
                    notUDP = true;
                    break;
                }
                if (notUDP) continue;
                String value = this.designObject.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
            this.initDynamicPropertiesTableSorter();
        }
        catch (Exception e) {
            LOGGER.error("AbstractPropertiesDialog. Unable to init dynamic properties for : " + this.designObject.getName(), e);
        }
    }

    public void initUserDefinedProperties() {
        try {
            for (UserDefinedProperty p : this.designObject.getDesign().getUserDefinedProperties()) {
                for (Map.Entry<Class, Boolean> pairs : p.getObjectsVisibilityMap().entrySet()) {
                    Class clz = pairs.getKey();
                    if (this.designObject.getClass() != clz) continue;
                    UDProperty ud = new UDProperty();
                    ud.setUserDefinedProperty(p);
                    Iterator itV = this.designObject.getPropertyNames();
                    while (itV.hasNext()) {
                        String propName = (String)itV.next();
                        if (!propName.equals(p.getName())) continue;
                        String value = this.designObject.getProperty(propName);
                        ud.setValue(value);
                        break;
                    }
                    this.allUDPList.add(ud);
                }
            }
            this.initUDPropertiesTableSorter(this.allUDPList, this.userDefinedPropertiesTable);
        }
        catch (Exception e) {
            LOGGER.error("AbstractPropertiesDialog. Unable to init user defined properties for : " + this.designObject.getName(), e);
        }
    }

    protected void initUDPGroupsTree(DefaultMutableTreeNode udpNode) {
        for (UDPLibrary library : this.getAppView().getCurrentDesign().getUserDefinedLibraries()) {
            for (UserDefinedPropertyGroup group : library.getUDPGroups()) {
                boolean addGroup = false;
                JPanel jpUDPs = new JPanel(new BorderLayout());
                jpUDPs.setBorder(BorderFactory.createTitledBorder(Messages.getString("AbstractPropertiesDialog.Properties")));
                ArrayList<UDProperty> groupUDPList = new ArrayList<UDProperty>();
                for (UDProperty ud : this.allUDPList) {
                    UserDefinedProperty p = ud.getUserDefinedProperty();
                    if (p.getGroup() == null || !p.getGroup().getId().equals(group.getId())) continue;
                    groupUDPList.add(ud);
                    addGroup = true;
                }
                if (!addGroup) continue;
                JPanel jp = this.createPage(group.getName());
                jp.add((Component)jpUDPs, "Center");
                this.addToTree(udpNode, jp);
                JTable udpTable = new JTable(new UserDefinedPropertiesModel(groupUDPList));
                udpTable.setSelectionMode(0);
                udpTable.getTableHeader().setReorderingAllowed(false);
                udpTable.setCellSelectionEnabled(true);
                TableColumn col0 = udpTable.getColumnModel().getColumn(0);
                col0.setCellRenderer(new UDPPropertyCellRenderer());
                TableColumn col1 = udpTable.getColumnModel().getColumn(1);
                col1.setCellEditor(new UDPPropertyValueCellEditor(groupUDPList, false));
                jpUDPs.add((Component)new JScrollPane(udpTable), "Center");
                this.getGroupUDPTables().add(udpTable);
                this.initUDPropertiesTableSorter(groupUDPList, udpTable);
            }
        }
    }

    private void initMeasurementsSorter() {
        if (this.mList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.mModel);
            sorter.setSortsOnUpdates(true);
            this.mTable.setRowSorter(sorter);
            this.mTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.mTable, 0);
        }
    }

    private void initChangeRequestsSorter() {
        if (this.reqList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.reqModel);
            sorter.setSortsOnUpdates(true);
            this.reqTable.setRowSorter(sorter);
            this.reqTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.reqTable, 0);
        }
    }

    private void initResponsiblePartiesSorter() {
        if (this.rpList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.rpModel);
            sorter.setSortsOnUpdates(true);
            this.rpTable.setRowSorter(sorter);
            this.rpTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.rpTable, 0);
        }
    }

    private void initDocumentsSorter() {
        if (this.docList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.docModel);
            sorter.setSortsOnUpdates(true);
            this.docTable.setRowSorter(sorter);
            this.docTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.docTable, 0);
        }
    }

    private void initDynamicPropertiesTableSorter() {
        if (this.dynamicPropertiesList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.dynamicPropertiesTable.getModel());
            sorter.setSortsOnUpdates(true);
            this.dynamicPropertiesTable.setRowSorter(sorter);
            this.dynamicPropertiesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.dynamicPropertiesTable, 0);
        }
    }

    private void initUDPropertiesTableSorter(List list, JTable table) {
        if (list.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(table.getModel());
            sorter.setSortsOnUpdates(true);
            table.setRowSorter(sorter);
            table.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(table, 0);
        }
    }

    public List getGroupUDPTables() {
        if (this.groupUDPTables == null) {
            this.groupUDPTables = new ArrayList();
        }
        return this.groupUDPTables;
    }

    public class UDProperty {
        UserDefinedProperty userDefinedProperty;
        String value;

        public UDProperty() {
        }

        public UDProperty(UserDefinedProperty userDefinedProperty, String value) {
            this.userDefinedProperty = userDefinedProperty;
            this.value = value;
        }

        public UserDefinedProperty getUserDefinedProperty() {
            return this.userDefinedProperty;
        }

        public void setUserDefinedProperty(UserDefinedProperty userDefinedProperty) {
            this.userDefinedProperty = userDefinedProperty;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    class DateButtonEditor
    extends DefaultCellEditor {
        final DateFormat dateFormat;
        private JPanel jp;
        private Date[] dat;
        private CalendarPopupButton calendarButton;
        private JButton clearValueButton;
        private Date dDate;
        private Date dDefault;
        private CalendarPanel cpDate;

        public DateButtonEditor(final JTable table, final int row, final int col, String defaultDate) {
            super(new JTextField());
            this.dateFormat = new SimpleDateFormat(MDConfiguration.getDefaultInstance().get("dateonlyformat"));
            this.dat = null;
            this.dDefault = new Date();
            this.dDate = new Date();
            String cellDate = (String)table.getValueAt(row, col);
            if (cellDate != null && !AbstractPropertiesDialog.EMPTY_STRING.equals(cellDate)) {
                try {
                    this.dDate = this.dateFormat.parse(cellDate);
                }
                catch (ParseException e) {
                    this.dDate = new Date();
                }
            } else if (defaultDate != null && !AbstractPropertiesDialog.EMPTY_STRING.equals(defaultDate)) {
                try {
                    this.dDate = this.dateFormat.parse(defaultDate);
                }
                catch (ParseException e) {
                    this.dDate = new Date();
                }
            }
            this.jp = new JPanel(new BorderLayout());
            this.calendarButton = new CalendarPopupButton();
            this.calendarButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DateButtonEditor.this.dDate != null) {
                        DateButtonEditor.this.cpDate.setSelectedDate(DateButtonEditor.this.dDate);
                        DateButtonEditor.this.cpDate.makeDateVisible(DateButtonEditor.this.dDate);
                    } else {
                        DateButtonEditor.this.cpDate.setSelectedDate(DateButtonEditor.this.dDefault);
                        DateButtonEditor.this.cpDate.makeDateVisible(DateButtonEditor.this.dDefault);
                    }
                }
            });
            this.cpDate = this.calendarButton.getCalendarPanel();
            this.cpDate.setSelectedDate(this.dDate);
            this.cpDate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase("SELECTION_CHANGED_COMMAND")) {
                        DateButtonEditor.access$1902(DateButtonEditor.this, DateButtonEditor.this.cpDate.getSelectedDates());
                        if (DateButtonEditor.this.dat.length > 0) {
                            DateButtonEditor.this.dDate = DateButtonEditor.this.dat[0];
                            DateButtonEditor.this.calendarButton.setText(DateButtonEditor.this.dateFormat.format(DateButtonEditor.this.dat[0]));
                        } else {
                            DateButtonEditor.this.dDate = null;
                            DateButtonEditor.this.calendarButton.setText(AbstractPropertiesDialog.EMPTY_STRING);
                        }
                    }
                }
            });
            this.clearValueButton = new JButton(AbstractPropertiesDialog.this.configuration.getIcon("REMOVE_ICON", AbstractPropertiesDialog.this.getPreferredIconSize()));
            this.clearValueButton.setPreferredSize(new Dimension(18, 18));
            this.clearValueButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int icol = table.getEditingColumn();
                    int irow = table.getEditingRow();
                    if (icol > -1 && irow > -1) {
                        table.getCellEditor(irow, icol).stopCellEditing();
                    }
                    DateButtonEditor.this.dDate = null;
                    DateButtonEditor.this.calendarButton.setText(AbstractPropertiesDialog.EMPTY_STRING);
                    table.getModel().setValueAt(AbstractPropertiesDialog.EMPTY_STRING, row, col);
                }
            });
            this.jp.add((Component)this.calendarButton, "Center");
            this.jp.add((Component)this.clearValueButton, "East");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                this.calendarButton.setForeground(table.getSelectionForeground());
                this.calendarButton.setBackground(table.getSelectionBackground());
            } else {
                this.calendarButton.setForeground(table.getForeground());
                this.calendarButton.setBackground(table.getBackground());
            }
            return this.jp;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.dat != null) {
                return this.dateFormat.format(this.dat[0]);
            }
            return AbstractPropertiesDialog.EMPTY_STRING;
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        static /* synthetic */ Date[] access$1902(DateButtonEditor x0, Date[] x1) {
            x0.dat = x1;
            return x1;
        }
    }

    class DateButtonRenderer
    extends JButton
    implements TableCellRenderer {
        public DateButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(UIManager.getColor("Button.background"));
            }
            this.setText(value == null ? AbstractPropertiesDialog.EMPTY_STRING : value.toString());
            return this;
        }
    }

    public class UDPPropertyValueCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private List list;
        private boolean columnOriented;
        private TableCellEditor editor;
        String type = "";

        public UDPPropertyValueCellEditor(List list, boolean columnOriented) {
            this.list = list;
            this.columnOriented = columnOriented;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.editor != null) {
                return this.editor.getCellEditorValue();
            }
            return null;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.type.equals(UserDefinedProperty.NUMBER)) {
                String value = (String)this.editor.getCellEditorValue();
                try {
                    if (value != null && !value.trim().equals(AbstractPropertiesDialog.EMPTY_STRING)) {
                        Double v = Double.valueOf(value);
                    }
                }
                catch (Exception e) {
                    MessageDialogs.showErrorMessage(Messages.getString("AbstractPropertiesDialog.PropertyTypeMustBeNumber"));
                    return false;
                }
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            UDProperty udp = null;
            udp = this.columnOriented ? (UDProperty)this.list.get(column) : (UDProperty)this.list.get(table.convertRowIndexToModel(row));
            if (udp != null && udp.getUserDefinedProperty() != null) {
                this.type = udp.getUserDefinedProperty().getType();
                if (this.type.equals(UserDefinedProperty.TEXT)) {
                    this.editor = new DefaultCellEditor(new JTextField());
                } else if (this.type.equals(UserDefinedProperty.DATE)) {
                    this.editor = new DateButtonEditor(table, row, column, udp.getUserDefinedProperty().getDefaultValue());
                } else if (this.type.equals(UserDefinedProperty.LIST)) {
                    ArrayList<String> lovs = new ArrayList<String>();
                    String defLOV = AbstractPropertiesDialog.EMPTY_STRING;
                    for (Map.Entry<String, Boolean> pairs : udp.getUserDefinedProperty().getLovMap().entrySet()) {
                        String val = pairs.getKey();
                        Boolean def = pairs.getValue();
                        if (def.booleanValue()) {
                            defLOV = val;
                        }
                        lovs.add(val);
                    }
                    if (defLOV.equals(AbstractPropertiesDialog.EMPTY_STRING)) {
                        lovs.add(0, AbstractPropertiesDialog.EMPTY_STRING);
                    }
                    JComboBox<Object> cb = new JComboBox<Object>(lovs.toArray());
                    if (!defLOV.equals(AbstractPropertiesDialog.EMPTY_STRING)) {
                        cb.setSelectedItem(defLOV);
                    }
                    this.editor = new DefaultCellEditor(cb);
                } else if (this.type.equals(UserDefinedProperty.NUMBER)) {
                    this.editor = new DefaultCellEditor(new JTextField());
                }
            }
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    protected class UDPPropertyCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public UDPPropertyCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            String name = AbstractPropertiesDialog.EMPTY_STRING;
            if (value != null) {
                UserDefinedProperty udp = (UserDefinedProperty)value;
                name = udp.getName();
            }
            this.setText(name);
            return this;
        }
    }

    private class UserDefinedPropertiesModel
    extends AbstractTableModel {
        private List list;

        UserDefinedPropertiesModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractPropertiesDialog.Property");
            }
            return Messages.getString("AbstractPropertiesDialog.PropertyValue");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return UserDefinedProperty.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            UDProperty udp = (UDProperty)this.list.get(row);
            if (udp != null) {
                if (col == 0) {
                    return udp.getUserDefinedProperty();
                }
                if (col == 1) {
                    return udp.getValue();
                }
            }
            return AbstractPropertiesDialog.EMPTY_STRING;
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            UDProperty udp = (UDProperty)this.list.get(rowIndex);
            if (columnIndex == 0) {
                if (obj != null) {
                    udp.setUserDefinedProperty((UserDefinedProperty)obj);
                }
            } else if (columnIndex == 1) {
                if (obj != null) {
                    udp.setValue(obj.toString());
                } else {
                    udp.setValue(AbstractPropertiesDialog.EMPTY_STRING);
                }
            }
        }
    }

    private class DynamicPropertiesModel
    extends AbstractTableModel {
        private DynamicPropertiesModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AbstractPropertiesDialog.this.dynamicPropertiesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractPropertiesDialog.PropertyName");
            }
            return Messages.getString("AbstractPropertiesDialog.PropertyValue");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DynamicProperty object = AbstractPropertiesDialog.this.dynamicPropertiesList.get(row);
            if (col == 0) {
                return object.getName();
            }
            if (col == 1) {
                return object.getValue();
            }
            return AbstractPropertiesDialog.EMPTY_STRING;
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            DynamicProperty dp = AbstractPropertiesDialog.this.dynamicPropertiesList.get(rowIndex);
            if (columnIndex == 0) {
                dp.setName(obj.toString());
            } else if (columnIndex == 1) {
                dp.setValue(obj.toString());
            }
        }
    }

    private class DocumentTableModel
    extends AbstractTableModel {
        private DocumentTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractPropertiesDialog.this.docList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractPropertiesDialog.Documents");
            }
            return AbstractPropertiesDialog.EMPTY_STRING;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)AbstractPropertiesDialog.this.docList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class ResPartyModel
    extends AbstractTableModel {
        private ResPartyModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractPropertiesDialog.this.rpList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractPropertiesDialog.ResponsibleParties");
            }
            return AbstractPropertiesDialog.EMPTY_STRING;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)AbstractPropertiesDialog.this.rpList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class ChangeRequestModel
    extends AbstractTableModel {
        private ChangeRequestModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractPropertiesDialog.this.reqList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractPropertiesDialog.ChangeRequests");
            }
            return AbstractPropertiesDialog.EMPTY_STRING;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ChangeRequest request = (ChangeRequest)AbstractPropertiesDialog.this.reqList.get(row);
            if (col == 0) {
                return request.getName();
            }
            return new Integer(row * col);
        }
    }

    public class MeasurementModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractPropertiesDialog.this.mList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractPropertiesDialog.Measurements");
            }
            return AbstractPropertiesDialog.EMPTY_STRING;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Measurement m = (Measurement)AbstractPropertiesDialog.this.mList.get(row);
            if (col == 0) {
                return m.getName();
            }
            return null;
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)AbstractPropertiesDialog.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object obj = node.getUserObject();
            if (obj instanceof Component) {
                AbstractPropertiesDialog.this.showComponent((Component)obj);
            }
        }
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        TreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof Component) {
                Component c = (Component)node.getUserObject();
                this.setText(c.getName());
            }
            return this;
        }
    }
}

