/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.LabelView;

public class LabelDiagramCell
extends DefaultDiagramCell {
    private JPopupMenu menu;
    private Label label;
    DefaultEdge edge;

    public LabelDiagramCell(Label label) {
        this(label, DiagramConstants.createMap());
    }

    public LabelDiagramCell(Label label, Map attributeMap) {
        this.label = label;
        this.setAttributes(attributeMap);
        DiagramConstants.setValue(this.getAttributes(), label.getName());
    }

    @Override
    public void doubleClick() {
        TVConnector tv;
        if (this.label.isRelationshipAttributesLabel() && (tv = this.label.getTVConnector()) != null) {
            tv.getModel().showPropertyDialog();
        }
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabelDiagramCell.this.format();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(RESET_LABEL_SIZE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabelDiagramCell.this.resetLabelSize();
                }
            });
            this.menu.add(new AbstractAction(SEND_TO_BACK){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabelDiagramCell.this.getTopView().sendToBack();
                }
            });
        }
        return this.menu;
    }

    public Label getLabel() {
        return this.label;
    }

    private void resetLabelSize() {
        ((LabelView)this.getCellView()).resetLabelSize(true);
    }

    public DefaultEdge getEdge() {
        return this.edge;
    }

    public void setEdge(DefaultEdge edge) {
        this.edge = edge;
    }
}

