/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.datatypes;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypes;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.datatypes.DTDiagramCell;

public class StructuredTypeDiagramCell
extends DTDiagramCell {
    private JMenuItem miPaste;
    private JPopupMenu menu;
    private JMenuItem miSelectNeighbors;

    public StructuredTypeDiagramCell(AbstractDTObject dtObject) {
        super(dtObject);
    }

    public StructuredTypeDiagramCell(AbstractDTObject dtObject, Map attributeMap) {
        super(dtObject, attributeMap);
    }

    private void showProperty() {
        this.getDTObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(CREATE_SUBVIEW_FROM_SELECTED){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StructuredTypeDiagramCell.this.getTopView().getDesignPartView().createSubViewFromSelected();
                    }
                });
                this.menu.addSeparator();
                this.miSelectNeighbors = this.menu.add(new AbstractAction(SELECT_NEIGHBORS){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((DPVDataTypes)StructuredTypeDiagramCell.this.getTopView().getDesignPartView()).selectNeighbors(StructuredTypeDiagramCell.this.getDTObject());
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(COPY){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StructuredTypeDiagramCell.this.getDiagram().getAppView().clearCopiedObjects();
                        StructuredTypeDiagramCell.this.getTopView().getDesignPartView().addSelectedToCopied();
                    }
                });
                this.miPaste = this.menu.add(new AbstractAction(PASTE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StructuredTypeDiagramCell.access$002(StructuredTypeDiagramCell.this, StructuredTypeDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                        for (int i = 0; i < StructuredTypeDiagramCell.this.selectedObjects.length; ++i) {
                            ((ContainerObject)StructuredTypeDiagramCell.this.selectedObjects[i]).paste();
                        }
                    }
                });
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StructuredTypeDiagramCell.this.deleteStructuredType();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StructuredTypeDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StructuredTypeDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StructuredTypeDiagramCell.this.showProperty();
                }
            });
        }
        if (this.isEditable()) {
            this.miPaste.setEnabled(this.getDTObject().canPaste());
            this.miSelectNeighbors.setEnabled(this.enableSelectNeighbors());
        }
        return this.menu;
    }

    private boolean enableSelectNeighbors() {
        StructuredType structuredType = (StructuredType)this.getDTObject();
        DTRelation.Connection[] connections = structuredType.getAllLinks();
        for (int i = 0; i < connections.length; ++i) {
            DTRelation.Connection connection = connections[i];
            if (connection.getDTRelation() instanceof DTInheritance || connection.getDTRelation().getSourceDTObject() == connection.getDTRelation().getTargetDTObject()) continue;
            return true;
        }
        return false;
    }

    public void deleteStructuredType() {
        TVStructuredType tv = (TVStructuredType)this.getTopView();
        ApplicationView.log(MessageFormat.format(Messages.getString("StructuredTypeDiagramCell.DeleteStructuredType"), this.getDTObject().getName()));
        tv.remove(true);
    }

    @Override
    public void deleteSelected() {
        this.deleteStructuredType();
    }

    static /* synthetic */ Object[] access$002(StructuredTypeDiagramCell x0, Object[] x1) {
        x0.selectedObjects = x1;
        return x1;
    }
}

