/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.objects;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.RecordStructure;
import oracle.dbtools.crest.model.design.process.Role;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.CustomDialogML;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class ChangeRequestsAdmin
extends CustomDialogML {
    final String GROUPEDOBJECTS = "GroupedObjects";
    final String OBJECTSLIST = "ObjectsList";
    final String RMODEL = "RMODEL";
    final String LMODEL = "LMODEL";
    final String PMODEL = "PMODEL";
    private final String TABLES = "Tables";
    private final String COLUMNS = "Columns";
    private final String PKUK_CONSTRAINT = "PK and UK Constraints";
    private final String INDEXES = "Indexes";
    private final String FOREIGN_KEYS = "Foreign Keys";
    private final String TABLES_VIEWS = "Views";
    private final String SCHEMA_OBJECTS = "Schemas";
    private final String ENTITIES = "Entities";
    private final String ATTRIBUTES = "Attributes";
    private final String RELATIONS = "Relations";
    private final String IDENTIFIERS = "Identifiers";
    private final String ENTITIES_VIEWS = "Views";
    private final String EXTERNAL_AGENTS = "External Agent";
    private final String EVENTS = "Events";
    private final String FLOWS = "Flows";
    private final String INFORMATION_STRUCTURES = "Information Structures";
    private final String PROCESSES = "Processes";
    private final String RECORD_STRUCTURE = "Record Structure";
    private final String ROLES = "Roles";
    private final String INFORMATION_STORES = "Information Stores";
    private final String TRANSFORMATIONS = "Transformations";
    private JDialog dialog;
    private boolean result = false;
    private ApplicationView appView;
    private JButton btnSave;
    private JPanel buttonsPanel;
    private JPanel objectsCLPanel;
    private JPanel tabbedCLPanel;
    private JTable crTable;
    private List crList;
    private AbstractTableModel crTableModel;
    private JSearchTextField crFilter;
    private TableRowSorter crTableSorter;
    private List availableObjectsTableList;
    private AvailableObjectsTableModel availableObjectsTableModel;
    private JTable availableObjectsTable;
    private TableRowSorter availableObjectsTableSorter;
    private JTable refObjectsTable;
    private List refObjectsList;
    private AbstractTableModel refObjectsTableModel;
    private TableRowSorter refObjectsTableSorter;
    private JSearchTextField refObjectsFilter;
    private JRadioButton rbObjectType;
    private JRadioButton rbAllObjects;
    private JSearchTextField availableObjectsFilter;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private JTabbedPane relationalTpane;
    private JTabbedPane logicalTpane;
    private JTabbedPane processTpane;
    private JPanel tablesPanel;
    private List tablesList;
    private JTable tablesTable;
    private JSearchTextField tableNameFilter;
    private List columnsList;
    private JTable columnsTable;
    private JPanel columnsPanel;
    private JSearchTextField columnNameFilter;
    private JPanel pkukPanel;
    private JSearchTextField pkukNameFilter;
    private List pkukList;
    private JTable pkukTable;
    private JPanel indexesPanel;
    private JSearchTextField indexNameFilter;
    private List indexesList;
    private JTable indexesTable;
    private JPanel tableViewsPanel;
    private JSearchTextField tableViewNameFilter;
    private List tableViewsList;
    private JTable tableViewsTable;
    private JPanel soPanel;
    private JSearchTextField soNameFilter;
    private List schemaObjectList;
    private JTable soTable;
    private JPanel entitiesPanel;
    private JSearchTextField entityNameFilter;
    private List entitiesList;
    private JTable entitiesTable;
    private JPanel attributesPanel;
    private JSearchTextField attributeNameFilter;
    private List attributesList;
    private JTable attributesTable;
    private JPanel relationsPanel;
    private JSearchTextField relationNameFilter;
    private List relationsList;
    private JTable relationsTable;
    private JPanel identifiersPanel;
    private JSearchTextField identifierNameFilter;
    private List identifiersList;
    private JTable identifiersTable;
    private JPanel entityViewsPanel;
    private JSearchTextField entityViewNameFilter;
    private List entityViewsList;
    private JTable entityViewsTable;
    private JPanel agentsPanel;
    private JSearchTextField agentNameFilter;
    private List agentsList;
    private JTable agentsTable;
    private JPanel eventsPanel;
    private JSearchTextField eventNameFilter;
    private List eventsList;
    private JTable eventsTable;
    private JPanel flowsPanel;
    private JSearchTextField flowNameFilter;
    private List flowsList;
    private JTable flowsTable;
    private JPanel infoStructuresPanel;
    private JSearchTextField infoStructureNameFilter;
    private List infoStructuresList;
    private JTable infoStructuresTable;
    private JPanel processesPanel;
    private JSearchTextField processNameFilter;
    private List processesList;
    private JTable processesTable;
    private JPanel recordStructuresPanel;
    private JSearchTextField recordStructuresNameFilter;
    private List recordStructuresList;
    private JTable recordStructuresTable;
    private JPanel rolesPanel;
    private JSearchTextField roleNameFilter;
    private List rolesList;
    private JTable rolesTable;
    private JPanel infoStoresPanel;
    private JSearchTextField infoStoreNameFilter;
    private List infoStoresList;
    private JTable infoStoresTable;
    private JPanel transformationsPanel;
    private JSearchTextField transformationNameFilter;
    private List transformationsList;
    private JTable transformationsTable;
    private TableRowSorter<SingleColumnsTableModel> singleCSorter;
    private TableRowSorter<TwoColumnsTableModel> twoCSorter;
    private TableRowSorter<ThreeColumnsTableModel> threeCSorter;
    private TableRowSorter<FourColumnsTableModel> fourCSorter;
    private boolean crIsSelected;
    private boolean objectIsSelected;
    private JTable currentTable;
    private List currentList;
    private JTabbedPane currentPane;
    private DesignPart currentModel;
    private ChangeRequest currentCR;
    private Design design;
    private static final Logger LOGGER = new Logger(ChangeRequestsAdmin.class);

    public ChangeRequestsAdmin(ApplicationView appView) {
        super(appView);
        this.appView = appView;
        this.design = appView.getCurrentDesign();
        this.setLayout((LayoutManager)new MigLayout("", "[190]0[grow]", "[grow]0[]0[grow]"));
        this.init();
        this.loadCRs();
    }

    private void init() {
        JPanel crPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        crPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ChangeRequestsAdmin.ChangeRequests")));
        this.crFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.crFilter.setEnabled(false);
        this.crFilter.setPreferredSize(new Dimension(150, 20));
        this.crFilter.setMinimumSize(new Dimension(150, 20));
        this.crFilter.setMaximumSize(new Dimension(150, 20));
        this.crFilter.getDocument().addDocumentListener(new CRFilterListener());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setPreferredSize(new Dimension(130, 25));
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.crFilter);
        this.crList = new ArrayList();
        this.crTableModel = new CRTableModel();
        this.crTable = new JTable(this.crTableModel);
        this.crTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane crSP = new JScrollPane(this.crTable);
        TableColumn col0 = this.crTable.getColumnModel().getColumn(0);
        col0.setPreferredWidth(120);
        TableColumn col1 = this.crTable.getColumnModel().getColumn(1);
        col1.setPreferredWidth(80);
        this.crTable.setSelectionMode(0);
        this.crTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int selected = ChangeRequestsAdmin.this.crTable.getSelectedRow();
                    if (selected > -1) {
                        if (ChangeRequestsAdmin.this.currentCR != null) {
                            ChangeRequestsAdmin.this.currentCR.getObjects().clear();
                            Iterator it = ChangeRequestsAdmin.this.refObjectsList.iterator();
                            while (it.hasNext()) {
                                ChangeRequestsAdmin.this.currentCR.addObject((DesignObject)it.next());
                            }
                        }
                        ChangeRequestsAdmin.this.currentCR = (ChangeRequest)ChangeRequestsAdmin.this.crList.get(ChangeRequestsAdmin.this.crTable.convertRowIndexToModel(selected));
                        ChangeRequestsAdmin.this.refObjectsList.clear();
                        ChangeRequestsAdmin.this.refObjectsTable.setAutoCreateRowSorter(false);
                        ChangeRequestsAdmin.this.refObjectsTable.setRowSorter(null);
                        ChangeRequestsAdmin.this.refObjectsFilter.setEnabled(false);
                        ChangeRequestsAdmin.this.refObjectsTable.clearSelection();
                        ChangeRequestsAdmin.this.refObjectsTable.updateUI();
                        ChangeRequestsAdmin.this.refObjectsList.addAll(ChangeRequestsAdmin.this.currentCR.getObjects());
                        ChangeRequestsAdmin.this.refObjectsTable.updateUI();
                        if (ChangeRequestsAdmin.this.refObjectsList.size() > 0) {
                            ChangeRequestsAdmin.this.refObjectsFilter.setEnabled(true);
                            ChangeRequestsAdmin.this.refObjectsTable.setRowSorter(null);
                            ChangeRequestsAdmin.this.refObjectsTable.setRowSorter(ChangeRequestsAdmin.this.refObjectsTableSorter);
                            ChangeRequestsAdmin.this.refObjectsTable.setAutoCreateRowSorter(true);
                            WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.refObjectsTable, 0);
                        }
                        if (ChangeRequestsAdmin.this.objectIsSelected) {
                            ChangeRequestsAdmin.this.buttonAdd.setEnabled(true);
                        } else {
                            ChangeRequestsAdmin.this.buttonAdd.setEnabled(false);
                        }
                        ChangeRequestsAdmin.this.crIsSelected = true;
                    } else {
                        if (ChangeRequestsAdmin.this.currentCR != null) {
                            ChangeRequestsAdmin.this.currentCR.getObjects().clear();
                            Iterator it = ChangeRequestsAdmin.this.refObjectsList.iterator();
                            while (it.hasNext()) {
                                ChangeRequestsAdmin.this.currentCR.addObject((DesignObject)it.next());
                            }
                        }
                        ChangeRequestsAdmin.this.currentCR = null;
                        ChangeRequestsAdmin.this.refObjectsList.clear();
                        ChangeRequestsAdmin.this.refObjectsTable.setAutoCreateRowSorter(false);
                        ChangeRequestsAdmin.this.refObjectsTable.setRowSorter(null);
                        ChangeRequestsAdmin.this.refObjectsFilter.setEnabled(false);
                        ChangeRequestsAdmin.this.refObjectsTable.clearSelection();
                        ChangeRequestsAdmin.this.refObjectsTable.updateUI();
                        ChangeRequestsAdmin.this.buttonAdd.setEnabled(false);
                        ChangeRequestsAdmin.this.crIsSelected = false;
                    }
                    ChangeRequestsAdmin.this.loadModelData(ChangeRequestsAdmin.this.currentModel);
                    ChangeRequestsAdmin.this.adjustContent();
                }
            }
        });
        this.crTableSorter = new TableRowSorter<TableModel>(this.crTable.getModel());
        this.crTableSorter.setSortsOnUpdates(true);
        crPanel.add((Component)toolBar, new CC().gapLeft("5"));
        crPanel.add((Component)crSP, new CC().grow());
        JPanel allObjectsPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[25!]0[25!]0[250:250:]0"));
        this.tabbedCLPanel = new JPanel(new CardLayout());
        allObjectsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ChangeRequestsAdmin.AvailableObjects")));
        this.relationalTpane = new JTabbedPane();
        this.relationalTpane.setPreferredSize(new Dimension(200, 300));
        this.logicalTpane = new JTabbedPane();
        this.logicalTpane.setPreferredSize(new Dimension(200, 300));
        this.processTpane = new JTabbedPane();
        this.processTpane.setPreferredSize(new Dimension(200, 300));
        this.initTablesPanel();
        this.initColumnsPanel();
        this.initPKUKPanel();
        this.initIndexesPanel();
        this.initTableViewsPanel();
        this.initSchemaObjectsPanel();
        this.initEntitiesPanel();
        this.initAttributesPanel();
        this.initRelationsPanel();
        this.initIdentifiersPanel();
        this.initEntityViewsPanel();
        this.initExternalAgentsPanel();
        this.initEventsPanel();
        this.initFlowsPanel();
        this.initInfoStructurePanel();
        this.initProcessPanel();
        this.initRecordStructuresPanel();
        this.initRolesPanel();
        this.initStoresPanel();
        this.initTransformationsPanel();
        this.relationalTpane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                ChangeRequestsAdmin.this.clearTableSelections();
                ChangeRequestsAdmin.this.currentPane = ChangeRequestsAdmin.this.relationalTpane;
                if (ChangeRequestsAdmin.this.crTable.getSelectedRow() > -1) {
                    ChangeRequestsAdmin.this.adjustContent();
                }
            }
        });
        this.logicalTpane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                ChangeRequestsAdmin.this.clearTableSelections();
                ChangeRequestsAdmin.this.currentPane = ChangeRequestsAdmin.this.logicalTpane;
                if (ChangeRequestsAdmin.this.crTable.getSelectedRow() > -1) {
                    ChangeRequestsAdmin.this.adjustContent();
                }
            }
        });
        this.processTpane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                ChangeRequestsAdmin.this.clearTableSelections();
                ChangeRequestsAdmin.this.currentPane = ChangeRequestsAdmin.this.processTpane;
                if (ChangeRequestsAdmin.this.crTable.getSelectedRow() > -1) {
                    ChangeRequestsAdmin.this.adjustContent();
                }
            }
        });
        JLabel viewMode = new JLabel(Messages.getString("ChangeRequestsAdmin.ViewMode"));
        viewMode.setMinimumSize(new Dimension(100, 20));
        viewMode.setMaximumSize(new Dimension(100, 20));
        viewMode.setPreferredSize(new Dimension(100, 20));
        this.rbObjectType = new JRadioButton(Messages.getString("ChangeRequestsAdmin.GroupByType"));
        this.rbObjectType.setSelected(true);
        this.rbObjectType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                CardLayout cl = (CardLayout)ChangeRequestsAdmin.this.objectsCLPanel.getLayout();
                cl.show(ChangeRequestsAdmin.this.objectsCLPanel, "GroupedObjects");
            }
        });
        this.rbAllObjects = new JRadioButton(Messages.getString("ChangeRequestsAdmin.ObjectsList"));
        this.rbAllObjects.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                CardLayout cl = (CardLayout)ChangeRequestsAdmin.this.objectsCLPanel.getLayout();
                cl.show(ChangeRequestsAdmin.this.objectsCLPanel, "ObjectsList");
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbObjectType);
        group.add(this.rbAllObjects);
        JPanel rbPanel = new JPanel((LayoutManager)new MigLayout("", "[0]0[]0[]0", "0[25]0"));
        rbPanel.add(viewMode);
        rbPanel.add(this.rbObjectType);
        rbPanel.add(this.rbAllObjects);
        JPanel clGroupedObjects = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[]0"));
        clGroupedObjects.setBorder(BorderFactory.createTitledBorder(Messages.getString("ChangeRequestsAdmin.Objects")));
        JPanel modelsPanel = new JPanel((LayoutManager)new MigLayout("", "[0]0[]0", "0[25]0"));
        JLabel lbModel = new JLabel(Messages.getString("ChangeRequestsAdmin.Model"));
        lbModel.setMinimumSize(new Dimension(100, 20));
        lbModel.setMaximumSize(new Dimension(100, 20));
        lbModel.setPreferredSize(new Dimension(100, 20));
        JComboBox<Object> cmbModels = new JComboBox<Object>(this.getModels().toArray());
        cmbModels.setRenderer(new CmbModelsRenderer());
        cmbModels.setMinimumSize(new Dimension(200, 20));
        cmbModels.setMaximumSize(new Dimension(200, 20));
        cmbModels.setPreferredSize(new Dimension(200, 20));
        modelsPanel.add(lbModel);
        modelsPanel.add(cmbModels);
        cmbModels.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    CardLayout cl = (CardLayout)ChangeRequestsAdmin.this.tabbedCLPanel.getLayout();
                    ChangeRequestsAdmin.this.currentModel = (DesignPart)evt.getItem();
                    if (ChangeRequestsAdmin.this.currentModel instanceof RelationalDesign) {
                        cl.show(ChangeRequestsAdmin.this.tabbedCLPanel, "RMODEL");
                        int idx = ChangeRequestsAdmin.this.relationalTpane.getSelectedIndex();
                        ChangeRequestsAdmin.this.relationalTpane.setSelectedIndex(-1);
                        ChangeRequestsAdmin.this.relationalTpane.setSelectedIndex(idx);
                    } else if (ChangeRequestsAdmin.this.currentModel instanceof LogicalDesign) {
                        cl.show(ChangeRequestsAdmin.this.tabbedCLPanel, "LMODEL");
                    }
                    if (ChangeRequestsAdmin.this.currentModel instanceof ProcessModel) {
                        cl.show(ChangeRequestsAdmin.this.tabbedCLPanel, "PMODEL");
                    }
                    ChangeRequestsAdmin.this.loadModelData(ChangeRequestsAdmin.this.currentModel);
                    if (ChangeRequestsAdmin.this.crTable.getSelectedRow() > -1) {
                        ChangeRequestsAdmin.this.adjustContent();
                    }
                }
            }
        });
        this.tabbedCLPanel.setPreferredSize(new Dimension(200, 200));
        this.tabbedCLPanel.add((Component)this.relationalTpane, "RMODEL");
        this.tabbedCLPanel.add((Component)this.logicalTpane, "LMODEL");
        this.tabbedCLPanel.add((Component)this.processTpane, "PMODEL");
        clGroupedObjects.add((Component)this.tabbedCLPanel, new CC().grow());
        JPanel clObjectsList = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        clObjectsList.setBorder(BorderFactory.createTitledBorder(Messages.getString("ChangeRequestsAdmin.Objects")));
        this.availableObjectsFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.availableObjectsFilter.setEnabled(false);
        this.availableObjectsFilter.setPreferredSize(new Dimension(200, 20));
        this.availableObjectsFilter.setMinimumSize(new Dimension(200, 20));
        this.availableObjectsFilter.setMaximumSize(new Dimension(200, 20));
        this.availableObjectsFilter.getDocument().addDocumentListener(new AllObjFilterListener());
        this.availableObjectsTableList = new ArrayList();
        this.availableObjectsTableModel = new AvailableObjectsTableModel();
        this.availableObjectsTable = new JTable(this.availableObjectsTableModel);
        this.availableObjectsTable.getTableHeader().setReorderingAllowed(false);
        this.availableObjectsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (ChangeRequestsAdmin.this.availableObjectsTable.getSelectedRow() > -1) {
                        if (ChangeRequestsAdmin.this.crIsSelected) {
                            ChangeRequestsAdmin.this.buttonAdd.setEnabled(true);
                        } else {
                            ChangeRequestsAdmin.this.buttonAdd.setEnabled(false);
                        }
                        ChangeRequestsAdmin.this.objectIsSelected = true;
                    } else {
                        ChangeRequestsAdmin.this.buttonAdd.setEnabled(false);
                        ChangeRequestsAdmin.this.objectIsSelected = false;
                    }
                    ChangeRequestsAdmin.this.currentTable = ChangeRequestsAdmin.this.availableObjectsTable;
                    ChangeRequestsAdmin.this.currentList = ChangeRequestsAdmin.this.availableObjectsTableList;
                }
            }
        });
        this.availableObjectsTableSorter = new TableRowSorter<TableModel>(this.availableObjectsTable.getModel());
        this.availableObjectsTableSorter.setSortsOnUpdates(true);
        JScrollPane availableObjectsSP = new JScrollPane(this.availableObjectsTable);
        availableObjectsSP.setPreferredSize(new Dimension(200, 300));
        clObjectsList.add((Component)this.availableObjectsFilter, new CC().gapLeft("5"));
        clObjectsList.add((Component)availableObjectsSP, new CC().grow());
        this.objectsCLPanel = new JPanel(new CardLayout());
        this.objectsCLPanel.add((Component)clGroupedObjects, "GroupedObjects");
        this.objectsCLPanel.add((Component)clObjectsList, "ObjectsList");
        allObjectsPanel.add(modelsPanel);
        allObjectsPanel.add(rbPanel);
        allObjectsPanel.add((Component)this.objectsCLPanel, new CC().grow());
        this.buttonAdd = new JButton(this.getConfiguration().getIcon("MOVE_DOWN_ICON", 16));
        this.buttonAdd.addActionListener(new AddObjectActionListener());
        this.buttonAdd.setEnabled(false);
        this.buttonAdd.setToolTipText(Messages.getString("ChangeRequestsAdmin.Add"));
        this.buttonAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonRemove = new JButton(this.getConfiguration().getIcon("MOVE_UP_ICON", 16));
        this.buttonRemove.addActionListener(new RemoveObjectActionListener());
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.setToolTipText(Messages.getString("ChangeRequestsAdmin.Remove"));
        this.buttonRemove.setPreferredSize(new Dimension(32, 32));
        Box horizontalBox = Box.createHorizontalBox();
        horizontalBox.add(Box.createHorizontalGlue());
        horizontalBox.add(this.buttonAdd);
        horizontalBox.add(this.buttonRemove);
        horizontalBox.add(Box.createHorizontalGlue());
        JPanel refObjectsPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[200:200:]0"));
        refObjectsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ChangeRequestsAdmin.ReferencedObjects")));
        this.refObjectsFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.refObjectsFilter.setEnabled(false);
        this.refObjectsFilter.setPreferredSize(new Dimension(200, 20));
        this.refObjectsFilter.setMinimumSize(new Dimension(200, 20));
        this.refObjectsFilter.setMaximumSize(new Dimension(200, 20));
        this.refObjectsFilter.getDocument().addDocumentListener(new RefObjFilterListener());
        this.refObjectsList = new ArrayList();
        this.refObjectsTableModel = new RefObjectsTableModel();
        this.refObjectsTable = new JTable(this.refObjectsTableModel);
        this.refObjectsTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane refObjectsSP = new JScrollPane(this.refObjectsTable);
        refObjectsSP.setPreferredSize(new Dimension(200, 200));
        this.refObjectsTableSorter = new TableRowSorter<TableModel>(this.refObjectsTable.getModel());
        this.refObjectsTableSorter.setSortsOnUpdates(true);
        this.refObjectsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                int selected = ChangeRequestsAdmin.this.refObjectsTable.getSelectedRow();
                if (selected == -1) {
                    ChangeRequestsAdmin.this.buttonRemove.setEnabled(false);
                } else {
                    ChangeRequestsAdmin.this.buttonRemove.setEnabled(true);
                }
            }
        });
        JToolBar refObjToolBar = new JToolBar(0);
        refObjToolBar.setFloatable(false);
        refObjToolBar.setRollover(true);
        refObjToolBar.setBorder(null);
        refObjToolBar.add(this.refObjectsFilter);
        refObjectsPanel.add((Component)refObjToolBar, new CC().gapLeft("5"));
        refObjectsPanel.add((Component)refObjectsSP, new CC().grow());
        this.initButtons();
        this.add((Component)crPanel, new CC().minWidth("20").maxWidth("200").grow().spanY(3));
        this.add((Component)allObjectsPanel, new CC().grow().gapTop("0").wrap());
        this.add((Component)horizontalBox, new CC().growX().wrap());
        this.add((Component)refObjectsPanel, new CC().grow());
        this.add((Component)this.buttonsPanel, new CC().height("50").dockSouth());
        cmbModels.setSelectedIndex(-1);
        cmbModels.setSelectedIndex(0);
    }

    private void loadCRs() {
        Iterator it = this.design.getChangeRequestSet().iterator();
        while (it.hasNext()) {
            ChangeRequest cr = (ChangeRequest)it.next();
            ChangeRequest changeRequest = new ChangeRequest(this.currentModel);
            changeRequest.setName(cr.getName());
            changeRequest.setObjectID(cr.getObjectID());
            changeRequest.setStatus(cr.getStatus());
            Iterator it1 = cr.getObjects().iterator();
            while (it1.hasNext()) {
                changeRequest.addObject((DesignObject)it1.next());
            }
            this.crList.add(changeRequest);
        }
        if (this.crList.size() > 0) {
            this.crTable.setRowSorter(null);
            this.crTable.setRowSorter(this.crTableSorter);
            this.crTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.crTable, 0);
            this.crFilter.setEnabled(true);
        } else {
            this.crTable.setAutoCreateRowSorter(false);
            this.crTable.setRowSorter(null);
            this.crFilter.setEnabled(false);
        }
    }

    private void loadModelData(DesignPart model) {
        this.tablesList.clear();
        this.columnsList.clear();
        this.indexesList.clear();
        this.pkukList.clear();
        this.tableViewsList.clear();
        this.schemaObjectList.clear();
        this.entitiesList.clear();
        this.attributesList.clear();
        this.relationsList.clear();
        this.identifiersList.clear();
        this.entityViewsList.clear();
        this.eventsList.clear();
        this.flowsList.clear();
        this.agentsList.clear();
        this.infoStructuresList.clear();
        this.processesList.clear();
        this.recordStructuresList.clear();
        this.rolesList.clear();
        this.infoStoresList.clear();
        this.transformationsList.clear();
        if (this.availableObjectsTable.getRowSorter() != null) {
            this.availableObjectsTable.getRowSorter().setSortKeys(null);
        }
        this.availableObjectsTableList.clear();
        if (model instanceof RelationalDesign) {
            for (RelationalDesign rd : this.design.getRelationalDesigns()) {
                Iterator itTables = rd.getTableSet().iterator();
                while (itTables.hasNext()) {
                    Table t = (Table)itTables.next();
                    this.tablesList.add(t);
                    this.availableObjectsTableList.add(t);
                    for (ContainedObject containedObject : Arrays.asList(t.getElements())) {
                        this.columnsList.add(containedObject);
                        this.availableObjectsTableList.add(containedObject);
                    }
                    Iterator iterator = t.getPKeys().iterator();
                    while (iterator.hasNext()) {
                        Index obj = (Index)((ContainerObjectPlaceHolder)iterator.next()).getObject();
                        this.pkukList.add(obj);
                        this.availableObjectsTableList.add(obj);
                    }
                    Iterator itUK = t.getUKeys().iterator();
                    while (itUK.hasNext()) {
                        Index obj = (Index)((ContainerObjectPlaceHolder)itUK.next()).getObject();
                        this.pkukList.add(obj);
                        this.availableObjectsTableList.add(obj);
                    }
                    Iterator itIndexes = t.getIndexes().iterator();
                    while (itIndexes.hasNext()) {
                        Index obj = (Index)((ContainerObjectPlaceHolder)itIndexes.next()).getObject();
                        this.indexesList.add(obj);
                        this.availableObjectsTableList.add(obj);
                    }
                }
                Iterator itTableViews = rd.getTableViewSet().iterator();
                while (itTableViews.hasNext()) {
                    Object obj = itTableViews.next();
                    this.tableViewsList.add(obj);
                    this.availableObjectsTableList.add(obj);
                }
                Iterator itSchemas = rd.getSchemaObjectSet().iterator();
                while (itSchemas.hasNext()) {
                    Object e = itSchemas.next();
                    this.schemaObjectList.add(e);
                    this.availableObjectsTableList.add(e);
                }
            }
            this.tablesTable.updateUI();
            this.columnsTable.updateUI();
            this.indexesTable.updateUI();
            this.tableViewsTable.updateUI();
            this.soTable.updateUI();
            if (this.tablesList.size() > 0) {
                this.tablesTable.setRowSorter(this.twoCSorter);
                this.tablesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.tablesTable, 1);
                this.tableNameFilter.setEnabled(true);
            }
            if (this.columnsList.size() > 0) {
                this.columnsTable.setRowSorter(this.threeCSorter);
                this.columnsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.columnsTable, 2);
                this.columnNameFilter.setEnabled(true);
            }
            if (this.indexesList.size() > 0) {
                this.indexesTable.setRowSorter(this.fourCSorter);
                this.indexesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.indexesTable, 3);
                this.indexNameFilter.setEnabled(true);
            }
            if (this.tableViewsList.size() > 0) {
                this.tableViewsTable.setRowSorter(this.twoCSorter);
                this.tableViewsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.tableViewsTable, 1);
                this.tableViewNameFilter.setEnabled(true);
            }
            if (this.pkukList.size() > 0) {
                this.pkukTable.setRowSorter(this.threeCSorter);
                this.pkukTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.pkukTable, 2);
                this.pkukNameFilter.setEnabled(true);
            }
            if (this.schemaObjectList.size() > 0) {
                this.soTable.setRowSorter(this.singleCSorter);
                this.soTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.soTable, 0);
                this.soNameFilter.setEnabled(true);
            }
        } else if (model instanceof LogicalDesign) {
            LogicalDesign ld = this.design.getLogicalDesign();
            Iterator itEntities = ld.getEntitySet().iterator();
            while (itEntities.hasNext()) {
                Entity e = (Entity)itEntities.next();
                this.entitiesList.add(e);
                this.availableObjectsTableList.add(e);
                for (Object obj : e.getAttributes()) {
                    this.attributesList.add(obj);
                    this.availableObjectsTableList.add(obj);
                }
                Iterator itKeySet = e.getKeySet().iterator();
                while (itKeySet.hasNext()) {
                    Object e2 = itKeySet.next();
                    this.identifiersList.add(e2);
                    this.availableObjectsTableList.add(e2);
                }
                for (Object obj : this.design.getLogicalDesign().getRelationSet().getRelationsTo(e)) {
                    this.relationsList.add(obj);
                    this.availableObjectsTableList.add(obj);
                }
            }
            Iterator itEntityViews = ld.getEntityViewSet().iterator();
            while (itEntityViews.hasNext()) {
                Object obj = itEntityViews.next();
                this.entityViewsList.add(obj);
                this.availableObjectsTableList.add(obj);
            }
            this.entitiesTable.updateUI();
            this.attributesTable.updateUI();
            this.relationsTable.updateUI();
            this.identifiersTable.updateUI();
            this.entityViewsTable.updateUI();
            if (this.entitiesList.size() > 0) {
                this.entitiesTable.setRowSorter(this.singleCSorter);
                this.entitiesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.entitiesTable, 0);
                this.entityNameFilter.setEnabled(true);
            }
            if (this.attributesList.size() > 0) {
                this.attributesTable.setRowSorter(this.twoCSorter);
                this.attributesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.attributesTable, 1);
                this.attributeNameFilter.setEnabled(true);
            }
            if (this.relationsList.size() > 0) {
                this.relationsTable.setRowSorter(this.twoCSorter);
                this.relationsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.relationsTable, 1);
                this.relationNameFilter.setEnabled(true);
            }
            if (this.identifiersList.size() > 0) {
                this.identifiersTable.setRowSorter(this.twoCSorter);
                this.identifiersTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.identifiersTable, 1);
                this.identifierNameFilter.setEnabled(true);
            }
            if (this.entityViewsList.size() > 0) {
                this.entityViewsTable.setRowSorter(this.singleCSorter);
                this.entityViewsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.entityViewsTable, 0);
                this.entityViewNameFilter.setEnabled(true);
            }
        } else if (model instanceof ProcessModel) {
            Object obj2;
            ProcessModel pm = this.design.getProcessModel();
            Iterator it = pm.getEventSet().iterator();
            while (it.hasNext()) {
                Object obj2 = it.next();
                this.eventsList.add(obj2);
                this.availableObjectsTableList.add(obj2);
            }
            for (Object obj2 : pm.getFlows_AllLevels()) {
                this.flowsList.add(obj2);
                this.availableObjectsTableList.add(obj2);
            }
            for (Object obj2 : pm.getAgents_AllLevels()) {
                this.agentsList.add(obj2);
                this.availableObjectsTableList.add(obj2);
            }
            it = pm.getInfoStructureSet().iterator();
            while (it.hasNext()) {
                obj2 = it.next();
                this.infoStructuresList.add(obj2);
                this.availableObjectsTableList.add(obj2);
            }
            for (Object obj2 : pm.getProcesses_AllLevels()) {
                this.processesList.add(obj2);
                this.availableObjectsTableList.add(obj2);
            }
            it = pm.getRecordStructureSet().iterator();
            while (it.hasNext()) {
                obj2 = it.next();
                this.recordStructuresList.add(obj2);
                this.availableObjectsTableList.add(obj2);
            }
            it = pm.getRoleSet().iterator();
            while (it.hasNext()) {
                obj2 = it.next();
                this.rolesList.add(obj2);
                this.availableObjectsTableList.add(obj2);
            }
            it = pm.getInfoStoreSet().iterator();
            while (it.hasNext()) {
                obj2 = it.next();
                this.infoStoresList.add(obj2);
                this.availableObjectsTableList.add(obj2);
            }
            for (Object obj2 : pm.getTransformationSet()) {
                this.transformationsList.add(obj2);
                this.availableObjectsTableList.add(obj2);
            }
            this.eventsTable.updateUI();
            this.flowsTable.updateUI();
            this.agentsTable.updateUI();
            this.infoStructuresTable.updateUI();
            this.processesTable.updateUI();
            this.recordStructuresTable.updateUI();
            this.rolesTable.updateUI();
            this.infoStoresTable.updateUI();
            this.transformationsTable.updateUI();
            if (this.eventsList.size() > 0) {
                this.eventsTable.setRowSorter(this.singleCSorter);
                this.eventsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.eventsTable, 0);
                this.eventNameFilter.setEnabled(true);
            }
            if (this.flowsList.size() > 0) {
                this.flowsTable.setRowSorter(this.singleCSorter);
                this.flowsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.flowsTable, 0);
                this.flowNameFilter.setEnabled(true);
            }
            if (this.agentsList.size() > 0) {
                this.agentsTable.setRowSorter(this.singleCSorter);
                this.agentsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.agentsTable, 0);
                this.agentNameFilter.setEnabled(true);
            }
            if (this.infoStructuresList.size() > 0) {
                this.infoStructuresTable.setRowSorter(this.singleCSorter);
                this.infoStructuresTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.infoStructuresTable, 0);
                this.infoStructureNameFilter.setEnabled(true);
            }
            if (this.processesList.size() > 0) {
                this.processesTable.setRowSorter(this.singleCSorter);
                this.processesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.processesTable, 0);
                this.processNameFilter.setEnabled(true);
            }
            if (this.recordStructuresList.size() > 0) {
                this.recordStructuresTable.setRowSorter(this.singleCSorter);
                this.recordStructuresTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.recordStructuresTable, 0);
                this.recordStructuresNameFilter.setEnabled(true);
            }
            if (this.rolesList.size() > 0) {
                this.rolesTable.setRowSorter(this.singleCSorter);
                this.rolesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.rolesTable, 0);
                this.roleNameFilter.setEnabled(true);
            }
            if (this.infoStoresList.size() > 0) {
                this.infoStoresTable.setRowSorter(this.singleCSorter);
                this.infoStoresTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.infoStoresTable, 0);
                this.infoStoreNameFilter.setEnabled(true);
            }
            if (this.transformationsList.size() > 0) {
                this.transformationsTable.setRowSorter(this.singleCSorter);
                this.transformationsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.transformationsTable, 0);
                this.transformationNameFilter.setEnabled(true);
            }
        }
        if (this.availableObjectsTableList.size() > 0) {
            this.availableObjectsTable.setRowSorter(this.availableObjectsTableSorter);
            this.availableObjectsTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.availableObjectsTable, 0);
            this.availableObjectsFilter.setEnabled(true);
        } else {
            this.availableObjectsTable.setAutoCreateRowSorter(false);
            this.availableObjectsTable.setRowSorter(null);
            this.availableObjectsFilter.setEnabled(false);
        }
        this.availableObjectsTable.updateUI();
    }

    private void adjustContent() {
        try {
            ArrayList<DesignObject> l = new ArrayList<DesignObject>();
            if (this.currentPane == this.relationalTpane) {
                if (this.relationalTpane.getSelectedComponent() == this.tablesPanel) {
                    if (this.tablesTable.getRowSorter() != null) {
                        this.tablesTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.tablesList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.tablesList.removeAll(l);
                    if (this.tablesList.size() > 0) {
                        this.tablesTable.setRowSorter(null);
                        this.tablesTable.setRowSorter(this.twoCSorter);
                        this.tablesTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.tablesTable, 1);
                    }
                    this.tablesTable.updateUI();
                } else if (this.relationalTpane.getSelectedComponent() == this.columnsPanel) {
                    if (this.columnsTable.getRowSorter() != null) {
                        this.columnsTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.columnsList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.columnsList.removeAll(l);
                    if (this.columnsList.size() > 0) {
                        this.columnsTable.setRowSorter(null);
                        this.columnsTable.setRowSorter(this.threeCSorter);
                        this.columnsTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.columnsTable, 2);
                    }
                    this.columnsTable.updateUI();
                } else if (this.relationalTpane.getSelectedComponent() == this.pkukPanel) {
                    if (this.pkukTable.getRowSorter() != null) {
                        this.pkukTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.pkukList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.pkukList.removeAll(l);
                    if (this.pkukList.size() > 0) {
                        this.pkukTable.setRowSorter(null);
                        this.pkukTable.setRowSorter(this.threeCSorter);
                        this.pkukTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.pkukTable, 2);
                    }
                    this.pkukTable.updateUI();
                } else if (this.relationalTpane.getSelectedComponent() == this.indexesPanel) {
                    if (this.indexesTable.getRowSorter() != null) {
                        this.indexesTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.indexesList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.indexesList.removeAll(l);
                    if (this.indexesList.size() > 0) {
                        this.indexesTable.setRowSorter(null);
                        this.indexesTable.setRowSorter(this.fourCSorter);
                        this.indexesTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.indexesTable, 3);
                    }
                    this.indexesTable.updateUI();
                } else if (this.relationalTpane.getSelectedComponent() == this.tableViewsPanel) {
                    if (this.tableViewsTable.getRowSorter() != null) {
                        this.tableViewsTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.tableViewsList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.tableViewsList.removeAll(l);
                    if (this.tableViewsList.size() > 0) {
                        this.tableViewsTable.setRowSorter(null);
                        this.tableViewsTable.setRowSorter(this.twoCSorter);
                        this.tableViewsTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.tableViewsTable, 1);
                    }
                    this.tableViewsTable.updateUI();
                } else if (this.relationalTpane.getSelectedComponent() == this.soPanel) {
                    if (this.soTable.getRowSorter() != null) {
                        this.soTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.schemaObjectList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.schemaObjectList.removeAll(l);
                    if (this.schemaObjectList.size() > 0) {
                        this.soTable.setRowSorter(null);
                        this.soTable.setRowSorter(this.singleCSorter);
                        this.soTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.soTable, 0);
                    }
                    this.soTable.updateUI();
                }
            } else if (this.currentPane == this.logicalTpane) {
                if (this.logicalTpane.getSelectedComponent() == this.entitiesPanel) {
                    if (this.entitiesTable.getRowSorter() != null) {
                        this.entitiesTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.entitiesList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.entitiesList.removeAll(l);
                    if (this.entitiesList.size() > 0) {
                        this.entitiesTable.setRowSorter(null);
                        this.entitiesTable.setRowSorter(this.singleCSorter);
                        this.entitiesTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.entitiesTable, 0);
                    }
                    this.entitiesTable.updateUI();
                } else if (this.logicalTpane.getSelectedComponent() == this.attributesPanel) {
                    if (this.attributesTable.getRowSorter() != null) {
                        this.attributesTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.attributesList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.attributesList.removeAll(l);
                    if (this.attributesList.size() > 0) {
                        this.attributesTable.setRowSorter(null);
                        this.attributesTable.setRowSorter(this.twoCSorter);
                        this.attributesTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.attributesTable, 1);
                    }
                    this.attributesTable.updateUI();
                } else if (this.logicalTpane.getSelectedComponent() == this.relationsPanel) {
                    if (this.relationsTable.getRowSorter() != null) {
                        this.relationsTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.relationsList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.relationsList.removeAll(l);
                    if (this.relationsList.size() > 0) {
                        this.relationsTable.setRowSorter(null);
                        this.relationsTable.setRowSorter(this.twoCSorter);
                        this.relationsTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.relationsTable, 1);
                    }
                    this.relationsTable.updateUI();
                } else if (this.logicalTpane.getSelectedComponent() == this.identifiersPanel) {
                    if (this.identifiersTable.getRowSorter() != null) {
                        this.identifiersTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.identifiersList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.identifiersList.removeAll(l);
                    if (this.identifiersList.size() > 0) {
                        this.identifiersTable.setRowSorter(null);
                        this.identifiersTable.setRowSorter(this.twoCSorter);
                        this.identifiersTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.identifiersTable, 1);
                    }
                    this.identifiersTable.updateUI();
                } else if (this.logicalTpane.getSelectedComponent() == this.entityViewsPanel) {
                    if (this.entityViewsTable.getRowSorter() != null) {
                        this.entityViewsTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.entityViewsList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.entityViewsList.removeAll(l);
                    if (this.entityViewsList.size() > 0) {
                        this.entityViewsTable.setRowSorter(null);
                        this.entityViewsTable.setRowSorter(this.singleCSorter);
                        this.entityViewsTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.entityViewsTable, 0);
                    }
                    this.entityViewsTable.updateUI();
                }
            } else if (this.currentPane == this.processTpane) {
                if (this.processTpane.getSelectedComponent() == this.agentsPanel) {
                    if (this.agentsTable.getRowSorter() != null) {
                        this.agentsTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.agentsList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.agentsList.removeAll(l);
                    if (this.agentsList.size() > 0) {
                        this.agentsTable.setRowSorter(null);
                        this.agentsTable.setRowSorter(this.singleCSorter);
                        this.agentsTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.agentsTable, 0);
                    }
                    this.agentsTable.updateUI();
                } else if (this.processTpane.getSelectedComponent() == this.eventsPanel) {
                    if (this.eventsTable.getRowSorter() != null) {
                        this.eventsTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.eventsList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.eventsList.removeAll(l);
                    if (this.eventsList.size() > 0) {
                        this.eventsTable.setRowSorter(null);
                        this.eventsTable.setRowSorter(this.singleCSorter);
                        this.eventsTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.eventsTable, 0);
                    }
                    this.eventsTable.updateUI();
                } else if (this.processTpane.getSelectedComponent() == this.flowsPanel) {
                    if (this.flowsTable.getRowSorter() != null) {
                        this.flowsTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.flowsList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.flowsList.removeAll(l);
                    if (this.flowsList.size() > 0) {
                        this.flowsTable.setRowSorter(null);
                        this.flowsTable.setRowSorter(this.singleCSorter);
                        this.flowsTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.flowsTable, 0);
                    }
                    this.flowsTable.updateUI();
                } else if (this.processTpane.getSelectedComponent() == this.infoStructuresPanel) {
                    if (this.infoStructuresTable.getRowSorter() != null) {
                        this.infoStructuresTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.infoStructuresList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.infoStructuresList.removeAll(l);
                    if (this.infoStructuresList.size() > 0) {
                        this.infoStructuresTable.setRowSorter(null);
                        this.infoStructuresTable.setRowSorter(this.singleCSorter);
                        this.infoStructuresTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.infoStructuresTable, 0);
                    }
                    this.infoStructuresTable.updateUI();
                } else if (this.processTpane.getSelectedComponent() == this.processesPanel) {
                    if (this.processesTable.getRowSorter() != null) {
                        this.processesTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.processesList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.processesList.removeAll(l);
                    if (this.processesList.size() > 0) {
                        this.processesTable.setRowSorter(null);
                        this.processesTable.setRowSorter(this.singleCSorter);
                        this.processesTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.processesTable, 0);
                    }
                    this.processesTable.updateUI();
                } else if (this.processTpane.getSelectedComponent() == this.recordStructuresPanel) {
                    if (this.recordStructuresTable.getRowSorter() != null) {
                        this.recordStructuresTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.recordStructuresList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.recordStructuresList.removeAll(l);
                    if (this.recordStructuresList.size() > 0) {
                        this.recordStructuresTable.setRowSorter(null);
                        this.recordStructuresTable.setRowSorter(this.singleCSorter);
                        this.recordStructuresTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.recordStructuresTable, 0);
                    }
                    this.recordStructuresTable.updateUI();
                } else if (this.processTpane.getSelectedComponent() == this.rolesPanel) {
                    if (this.rolesTable.getRowSorter() != null) {
                        this.rolesTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.rolesList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.rolesList.removeAll(l);
                    if (this.rolesList.size() > 0) {
                        this.rolesTable.setRowSorter(null);
                        this.rolesTable.setRowSorter(this.singleCSorter);
                        this.rolesTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.rolesTable, 0);
                    }
                    this.rolesTable.updateUI();
                } else if (this.processTpane.getSelectedComponent() == this.infoStoresPanel) {
                    if (this.infoStoresTable.getRowSorter() != null) {
                        this.infoStoresTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.infoStoresList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.infoStoresList.removeAll(l);
                    if (this.infoStoresList.size() > 0) {
                        this.infoStoresTable.setRowSorter(null);
                        this.infoStoresTable.setRowSorter(this.singleCSorter);
                        this.infoStoresTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.infoStoresTable, 0);
                    }
                    this.infoStoresTable.updateUI();
                } else if (this.processTpane.getSelectedComponent() == this.transformationsPanel) {
                    if (this.transformationsTable.getRowSorter() != null) {
                        this.transformationsTable.getRowSorter().setSortKeys(null);
                    }
                    for (DesignObject obj : this.refObjectsList) {
                        if (!this.transformationsList.contains(obj)) continue;
                        l.add(obj);
                    }
                    this.transformationsList.removeAll(l);
                    if (this.transformationsList.size() > 0) {
                        this.transformationsTable.setRowSorter(null);
                        this.transformationsTable.setRowSorter(this.singleCSorter);
                        this.transformationsTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(this.transformationsTable, 0);
                    }
                    this.transformationsTable.updateUI();
                }
            }
            l.clear();
            this.availableObjectsTable.getRowSorter().setSortKeys(null);
            for (DesignObject obj : this.refObjectsList) {
                if (!this.availableObjectsTableList.contains(obj)) continue;
                l.add(obj);
            }
            this.availableObjectsTableList.removeAll(l);
            if (this.availableObjectsTableList.size() > 0) {
                this.availableObjectsTable.setRowSorter(null);
                this.availableObjectsTable.setRowSorter(this.availableObjectsTableSorter);
                this.availableObjectsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.availableObjectsTable, 0);
            }
            this.availableObjectsTable.updateUI();
        }
        catch (Exception e) {
            LOGGER.error("ChangeRequestsAdmin.adjustContent()", e);
        }
    }

    private void initButtons() {
        this.buttonsPanel = new JPanel((LayoutManager)new MigLayout(new LC(), new AC().grow().align("center")));
        this.btnSave = new JButton(Messages.getString("ChangeRequestsAdmin.Save"));
        this.btnSave.setEnabled(false);
        this.btnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnSave.addActionListener(new SaveAction());
        this.btnSave.setMnemonic(79);
        JButton btnClose = new JButton(Messages.getString("ChangeRequestsAdmin.Close"));
        btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChangeRequestsAdmin.this.canClose()) {
                    ChangeRequestsAdmin.this.close();
                }
            }
        });
        btnClose.setMnemonic(67);
        JButton btnHelp = new JButton(this.getHelpAction());
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnHelp.setMnemonic(72);
        JPanel bPanel = new JPanel();
        bPanel.add(this.btnSave);
        bPanel.add(btnClose);
        bPanel.add(btnHelp);
        this.buttonsPanel.add(bPanel);
    }

    @Override
    protected boolean canClose() {
        if (this.btnSave.isEnabled()) {
            String s1 = Messages.getString("ChangeRequestsAdmin.Yes");
            String s2 = Messages.getString("ChangeRequestsAdmin.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("ChangeRequestsAdmin.ChReqNotSaved"), Messages.getString("ChangeRequestsAdmin.CloseConfirm"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    private void initTablesPanel() {
        this.tablesPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.tableNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.tableNameFilter.setEnabled(false);
        this.tableNameFilter.setPreferredSize(new Dimension(200, 20));
        this.tableNameFilter.setMinimumSize(new Dimension(200, 20));
        this.tableNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.tableNameFilter);
        this.tablesList = new ArrayList();
        TwoColumnsTableModel model = new TwoColumnsTableModel(this.tablesList, "Tables");
        this.tablesTable = new JTable(model);
        this.tablesTable.getTableHeader().setReorderingAllowed(false);
        this.tableNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.tableNameFilter, this.tablesTable, 1));
        this.addTableSelectionListener(this.tablesTable, this.tablesList);
        TableColumn col0 = this.tablesTable.getColumnModel().getColumn(0);
        col0.setWidth(250);
        this.twoCSorter = new TableRowSorter<TwoColumnsTableModel>(model);
        this.twoCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.tablesTable);
        this.tablesPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.tablesPanel.add((Component)sp, new CC().grow());
        this.relationalTpane.addTab("Tables", this.getConfiguration().getIcon("TABLE_ICON"), this.tablesPanel);
    }

    private void initColumnsPanel() {
        this.columnsPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.columnNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.columnNameFilter.setEnabled(false);
        this.columnNameFilter.setPreferredSize(new Dimension(200, 20));
        this.columnNameFilter.setMinimumSize(new Dimension(200, 20));
        this.columnNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.columnNameFilter);
        this.columnsList = new ArrayList();
        ThreeColumnsTableModel model = new ThreeColumnsTableModel(this.columnsList, "Columns");
        this.columnsTable = new JTable(model);
        this.columnsTable.getTableHeader().setReorderingAllowed(false);
        this.columnNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.columnNameFilter, this.columnsTable, 2));
        this.addTableSelectionListener(this.columnsTable, this.columnsList);
        TableColumn col0 = this.columnsTable.getColumnModel().getColumn(0);
        col0.setWidth(166);
        TableColumn col1 = this.columnsTable.getColumnModel().getColumn(1);
        col1.setWidth(166);
        TableColumn col2 = this.columnsTable.getColumnModel().getColumn(2);
        col2.setWidth(168);
        this.threeCSorter = new TableRowSorter<ThreeColumnsTableModel>(model);
        this.threeCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.columnsTable);
        this.columnsPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.columnsPanel.add((Component)sp, new CC().grow());
        this.relationalTpane.addTab("Columns", this.getConfiguration().getIcon("COLUMN_ICON"), this.columnsPanel);
    }

    private void initPKUKPanel() {
        this.pkukPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.pkukNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.pkukNameFilter.setEnabled(false);
        this.pkukNameFilter.setPreferredSize(new Dimension(200, 20));
        this.pkukNameFilter.setMinimumSize(new Dimension(200, 20));
        this.pkukNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.pkukNameFilter);
        this.pkukList = new ArrayList();
        ThreeColumnsTableModel model = new ThreeColumnsTableModel(this.pkukList, "PK and UK Constraints");
        this.pkukTable = new JTable(model);
        this.pkukTable.getTableHeader().setReorderingAllowed(false);
        this.pkukNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.pkukNameFilter, this.pkukTable, 2));
        this.addTableSelectionListener(this.pkukTable, this.pkukList);
        TableColumn col0 = this.pkukTable.getColumnModel().getColumn(0);
        col0.setWidth(166);
        TableColumn col1 = this.pkukTable.getColumnModel().getColumn(1);
        col1.setWidth(166);
        TableColumn col2 = this.pkukTable.getColumnModel().getColumn(2);
        col2.setWidth(168);
        this.threeCSorter = new TableRowSorter<ThreeColumnsTableModel>(model);
        this.threeCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.pkukTable);
        this.pkukPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.pkukPanel.add((Component)sp, new CC().grow());
        this.relationalTpane.addTab("PK and UK Constraints", this.getConfiguration().getIcon("PK_ICON"), this.pkukPanel);
    }

    private void initIndexesPanel() {
        this.indexesPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.indexNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.indexNameFilter.setEnabled(false);
        this.indexNameFilter.setPreferredSize(new Dimension(200, 20));
        this.indexNameFilter.setMinimumSize(new Dimension(200, 20));
        this.indexNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.indexNameFilter);
        this.indexesList = new ArrayList();
        FourColumnsTableModel model = new FourColumnsTableModel(this.indexesList, "Indexes");
        this.indexesTable = new JTable(model);
        this.indexesTable.getTableHeader().setReorderingAllowed(false);
        this.indexNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.indexNameFilter, this.indexesTable, 3));
        this.addTableSelectionListener(this.indexesTable, this.indexesList);
        TableColumn col0 = this.indexesTable.getColumnModel().getColumn(0);
        col0.setWidth(125);
        TableColumn col1 = this.indexesTable.getColumnModel().getColumn(1);
        col1.setWidth(125);
        TableColumn col2 = this.indexesTable.getColumnModel().getColumn(2);
        col2.setWidth(125);
        TableColumn col3 = this.indexesTable.getColumnModel().getColumn(3);
        col3.setWidth(125);
        this.fourCSorter = new TableRowSorter<FourColumnsTableModel>(model);
        this.fourCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.indexesTable);
        this.indexesPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.indexesPanel.add((Component)sp, new CC().grow());
        this.relationalTpane.addTab("Indexes", this.getConfiguration().getIcon("INDEX_ICON"), this.indexesPanel);
    }

    private void initTableViewsPanel() {
        this.tableViewsPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.tableViewNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.tableViewNameFilter.setEnabled(false);
        this.tableViewNameFilter.setPreferredSize(new Dimension(200, 20));
        this.tableViewNameFilter.setMinimumSize(new Dimension(200, 20));
        this.tableViewNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.tableViewNameFilter);
        this.tableViewsList = new ArrayList();
        TwoColumnsTableModel model = new TwoColumnsTableModel(this.tableViewsList, "Views");
        this.tableViewsTable = new JTable(model);
        this.tableViewsTable.getTableHeader().setReorderingAllowed(false);
        this.tableViewNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.tableViewNameFilter, this.tableViewsTable, 1));
        this.addTableSelectionListener(this.tableViewsTable, this.tableViewsList);
        TableColumn col0 = this.tableViewsTable.getColumnModel().getColumn(0);
        col0.setWidth(250);
        TableColumn col1 = this.tableViewsTable.getColumnModel().getColumn(1);
        col1.setWidth(250);
        this.twoCSorter = new TableRowSorter<TwoColumnsTableModel>(model);
        this.twoCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.tableViewsTable);
        this.tableViewsPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.tableViewsPanel.add((Component)sp, new CC().grow());
        this.relationalTpane.addTab("Views", this.getConfiguration().getIcon("VIEW_ICON"), this.tableViewsPanel);
    }

    private void initSchemaObjectsPanel() {
        this.soPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.soNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.soNameFilter.setEnabled(false);
        this.soNameFilter.setPreferredSize(new Dimension(200, 20));
        this.soNameFilter.setMinimumSize(new Dimension(200, 20));
        this.soNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.soNameFilter);
        this.schemaObjectList = new ArrayList();
        SingleColumnsTableModel model = new SingleColumnsTableModel(this.schemaObjectList);
        this.soTable = new JTable(model);
        this.soTable.getTableHeader().setReorderingAllowed(false);
        this.soNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.soNameFilter, this.soTable, 0));
        this.addTableSelectionListener(this.soTable, this.schemaObjectList);
        TableColumn col0 = this.soTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        this.singleCSorter = new TableRowSorter<SingleColumnsTableModel>(model);
        this.singleCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.soTable);
        this.soPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.soPanel.add((Component)sp, new CC().grow());
        this.relationalTpane.addTab("Schemas", this.getConfiguration().getIcon("SCHEMA_ICON"), this.soPanel);
    }

    private void initEntitiesPanel() {
        this.entitiesPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.entityNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.entityNameFilter.setEnabled(false);
        this.entityNameFilter.setPreferredSize(new Dimension(200, 20));
        this.entityNameFilter.setMinimumSize(new Dimension(200, 20));
        this.entityNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.entityNameFilter);
        this.entitiesList = new ArrayList();
        SingleColumnsTableModel model = new SingleColumnsTableModel(this.entitiesList);
        this.entitiesTable = new JTable(model);
        this.entitiesTable.getTableHeader().setReorderingAllowed(false);
        this.entityNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.entityNameFilter, this.entitiesTable, 0));
        this.addTableSelectionListener(this.entitiesTable, this.entitiesList);
        TableColumn col0 = this.entitiesTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        this.singleCSorter = new TableRowSorter<SingleColumnsTableModel>(model);
        this.singleCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.entitiesTable);
        this.entitiesPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.entitiesPanel.add((Component)sp, new CC().grow());
        this.logicalTpane.addTab("Entities", this.getConfiguration().getIcon("ENTITY_ICON"), this.entitiesPanel);
    }

    private void initAttributesPanel() {
        this.attributesPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.attributeNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.attributeNameFilter.setEnabled(false);
        this.attributeNameFilter.setPreferredSize(new Dimension(200, 20));
        this.attributeNameFilter.setMinimumSize(new Dimension(200, 20));
        this.attributeNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.attributeNameFilter);
        this.attributesList = new ArrayList();
        TwoColumnsTableModel model = new TwoColumnsTableModel(this.attributesList, "Attributes");
        this.attributesTable = new JTable(model);
        this.attributesTable.getTableHeader().setReorderingAllowed(false);
        this.attributeNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.attributeNameFilter, this.attributesTable, 1));
        this.addTableSelectionListener(this.attributesTable, this.attributesList);
        TableColumn col0 = this.attributesTable.getColumnModel().getColumn(0);
        col0.setWidth(250);
        TableColumn col1 = this.attributesTable.getColumnModel().getColumn(1);
        col1.setWidth(250);
        this.twoCSorter = new TableRowSorter<TwoColumnsTableModel>(model);
        this.twoCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.attributesTable);
        this.attributesPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.attributesPanel.add((Component)sp, new CC().grow());
        this.logicalTpane.addTab("Attributes", this.getConfiguration().getIcon("ATTRIBUTE_ICON"), this.attributesPanel);
    }

    private void initRelationsPanel() {
        this.relationsPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.relationNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.relationNameFilter.setEnabled(false);
        this.relationNameFilter.setPreferredSize(new Dimension(200, 20));
        this.relationNameFilter.setMinimumSize(new Dimension(200, 20));
        this.relationNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.relationNameFilter);
        this.relationsList = new ArrayList();
        TwoColumnsTableModel model = new TwoColumnsTableModel(this.relationsList, "Relations");
        this.relationsTable = new JTable(model);
        this.relationsTable.getTableHeader().setReorderingAllowed(false);
        this.relationNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.relationNameFilter, this.relationsTable, 1));
        this.addTableSelectionListener(this.relationsTable, this.relationsList);
        TableColumn col0 = this.relationsTable.getColumnModel().getColumn(0);
        col0.setWidth(250);
        TableColumn col1 = this.relationsTable.getColumnModel().getColumn(1);
        col1.setWidth(250);
        this.twoCSorter = new TableRowSorter<TwoColumnsTableModel>(model);
        this.twoCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.relationsTable);
        this.relationsPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.relationsPanel.add((Component)sp, new CC().grow());
        this.logicalTpane.addTab("Relations", this.getConfiguration().getIcon("KEY_ICON"), this.relationsPanel);
    }

    private void initIdentifiersPanel() {
        this.identifiersPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.identifierNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.identifierNameFilter.setEnabled(false);
        this.identifierNameFilter.setPreferredSize(new Dimension(200, 20));
        this.identifierNameFilter.setMinimumSize(new Dimension(200, 20));
        this.identifierNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.identifierNameFilter);
        this.identifiersList = new ArrayList();
        TwoColumnsTableModel model = new TwoColumnsTableModel(this.identifiersList, "Identifiers");
        this.identifiersTable = new JTable(model);
        this.identifiersTable.getTableHeader().setReorderingAllowed(false);
        this.identifierNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.identifierNameFilter, this.identifiersTable, 0));
        this.addTableSelectionListener(this.identifiersTable, this.identifiersList);
        TableColumn col0 = this.identifiersTable.getColumnModel().getColumn(0);
        col0.setWidth(250);
        TableColumn col1 = this.identifiersTable.getColumnModel().getColumn(1);
        col1.setWidth(250);
        this.twoCSorter = new TableRowSorter<TwoColumnsTableModel>(model);
        this.twoCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.identifiersTable);
        this.identifiersPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.identifiersPanel.add((Component)sp, new CC().grow());
        this.logicalTpane.addTab("Identifiers", this.getConfiguration().getIcon("INDEX_ICON"), this.identifiersPanel);
    }

    private void initEntityViewsPanel() {
        this.entityViewsPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.entityViewNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.entityViewNameFilter.setEnabled(false);
        this.entityViewNameFilter.setPreferredSize(new Dimension(200, 20));
        this.entityViewNameFilter.setMinimumSize(new Dimension(200, 20));
        this.entityViewNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.entityViewNameFilter);
        this.entityViewsList = new ArrayList();
        SingleColumnsTableModel model = new SingleColumnsTableModel(this.entityViewsList);
        this.entityViewsTable = new JTable(model);
        this.entityViewsTable.getTableHeader().setReorderingAllowed(false);
        this.entityViewNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.entityViewNameFilter, this.entityViewsTable, 0));
        this.addTableSelectionListener(this.entityViewsTable, this.entityViewsList);
        TableColumn col0 = this.entityViewsTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        this.singleCSorter = new TableRowSorter<SingleColumnsTableModel>(model);
        this.singleCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.entityViewsTable);
        this.entityViewsPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.entityViewsPanel.add((Component)sp, new CC().grow());
        this.logicalTpane.addTab("Views", this.getConfiguration().getIcon("VIEW_ICON"), this.entityViewsPanel);
    }

    private void initExternalAgentsPanel() {
        this.agentsPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.agentNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.agentNameFilter.setEnabled(false);
        this.agentNameFilter.setPreferredSize(new Dimension(200, 20));
        this.agentNameFilter.setMinimumSize(new Dimension(200, 20));
        this.agentNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.agentNameFilter);
        this.agentsList = new ArrayList();
        SingleColumnsTableModel model = new SingleColumnsTableModel(this.agentsList);
        this.agentsTable = new JTable(model);
        this.agentsTable.getTableHeader().setReorderingAllowed(false);
        this.agentNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.agentNameFilter, this.agentsTable, 0));
        this.addTableSelectionListener(this.agentsTable, this.agentsList);
        TableColumn col0 = this.agentsTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        this.singleCSorter = new TableRowSorter<SingleColumnsTableModel>(model);
        this.singleCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.agentsTable);
        this.agentsPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.agentsPanel.add((Component)sp, new CC().grow());
        this.processTpane.addTab("External Agent", this.getConfiguration().getIcon("AGENT_ICON"), this.agentsPanel);
    }

    private void initEventsPanel() {
        this.eventsPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.eventNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.eventNameFilter.setEnabled(false);
        this.eventNameFilter.setPreferredSize(new Dimension(200, 20));
        this.eventNameFilter.setMinimumSize(new Dimension(200, 20));
        this.eventNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.eventNameFilter);
        this.eventsList = new ArrayList();
        SingleColumnsTableModel model = new SingleColumnsTableModel(this.eventsList);
        this.eventsTable = new JTable(model);
        this.eventsTable.getTableHeader().setReorderingAllowed(false);
        this.eventNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.eventNameFilter, this.eventsTable, 0));
        this.addTableSelectionListener(this.eventsTable, this.eventsList);
        TableColumn col0 = this.eventsTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        this.singleCSorter = new TableRowSorter<SingleColumnsTableModel>(model);
        this.singleCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.eventsTable);
        this.eventsPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.eventsPanel.add((Component)sp, new CC().grow());
        this.processTpane.addTab("Events", this.getConfiguration().getIcon("EVENT_ICON"), this.eventsPanel);
    }

    private void initFlowsPanel() {
        this.flowsPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.flowNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.flowNameFilter.setEnabled(false);
        this.flowNameFilter.setPreferredSize(new Dimension(200, 20));
        this.flowNameFilter.setMinimumSize(new Dimension(200, 20));
        this.flowNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.flowNameFilter);
        this.flowsList = new ArrayList();
        SingleColumnsTableModel model = new SingleColumnsTableModel(this.flowsList);
        this.flowsTable = new JTable(model);
        this.flowsTable.getTableHeader().setReorderingAllowed(false);
        this.flowNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.flowNameFilter, this.flowsTable, 0));
        this.addTableSelectionListener(this.flowsTable, this.flowsList);
        TableColumn col0 = this.flowsTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        this.singleCSorter = new TableRowSorter<SingleColumnsTableModel>(model);
        this.singleCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.flowsTable);
        this.flowsPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.flowsPanel.add((Component)sp, new CC().grow());
        this.processTpane.addTab("Flows", this.getConfiguration().getIcon("FLOW_ICON"), this.flowsPanel);
    }

    private void initInfoStructurePanel() {
        this.infoStructuresPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.infoStructureNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.infoStructureNameFilter.setEnabled(false);
        this.infoStructureNameFilter.setPreferredSize(new Dimension(200, 20));
        this.infoStructureNameFilter.setMinimumSize(new Dimension(200, 20));
        this.infoStructureNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.infoStructureNameFilter);
        this.infoStructuresList = new ArrayList();
        SingleColumnsTableModel model = new SingleColumnsTableModel(this.infoStructuresList);
        this.infoStructuresTable = new JTable(model);
        this.infoStructuresTable.getTableHeader().setReorderingAllowed(false);
        this.infoStructureNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.infoStructureNameFilter, this.infoStructuresTable, 0));
        this.addTableSelectionListener(this.infoStructuresTable, this.infoStructuresList);
        TableColumn col0 = this.infoStructuresTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        this.singleCSorter = new TableRowSorter<SingleColumnsTableModel>(model);
        this.singleCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.infoStructuresTable);
        this.infoStructuresPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.infoStructuresPanel.add((Component)sp, new CC().grow());
        this.processTpane.addTab("Information Structures", this.getConfiguration().getIcon("INFO_ICON"), this.infoStructuresPanel);
    }

    private void initProcessPanel() {
        this.processesPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.processNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.processNameFilter.setEnabled(false);
        this.processNameFilter.setPreferredSize(new Dimension(200, 20));
        this.processNameFilter.setMinimumSize(new Dimension(200, 20));
        this.processNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.processNameFilter);
        this.processesList = new ArrayList();
        SingleColumnsTableModel model = new SingleColumnsTableModel(this.processesList);
        this.processesTable = new JTable(model);
        this.processesTable.getTableHeader().setReorderingAllowed(false);
        this.processNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.processNameFilter, this.processesTable, 0));
        this.addTableSelectionListener(this.processesTable, this.processesList);
        TableColumn col0 = this.processesTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        this.singleCSorter = new TableRowSorter<SingleColumnsTableModel>(model);
        this.singleCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.processesTable);
        this.processesPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.processesPanel.add((Component)sp, new CC().grow());
        this.processTpane.addTab("Processes", this.getConfiguration().getIcon("PROCESS_ICON"), this.processesPanel);
    }

    private void initRecordStructuresPanel() {
        this.recordStructuresPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.recordStructuresNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.recordStructuresNameFilter.setEnabled(false);
        this.recordStructuresNameFilter.setPreferredSize(new Dimension(200, 20));
        this.recordStructuresNameFilter.setMinimumSize(new Dimension(200, 20));
        this.recordStructuresNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.recordStructuresNameFilter);
        this.recordStructuresList = new ArrayList();
        SingleColumnsTableModel model = new SingleColumnsTableModel(this.recordStructuresList);
        this.recordStructuresTable = new JTable(model);
        this.recordStructuresTable.getTableHeader().setReorderingAllowed(false);
        this.recordStructuresNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.recordStructuresNameFilter, this.recordStructuresTable, 0));
        this.addTableSelectionListener(this.recordStructuresTable, this.recordStructuresList);
        TableColumn col0 = this.recordStructuresTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        this.singleCSorter = new TableRowSorter<SingleColumnsTableModel>(model);
        this.singleCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.recordStructuresTable);
        this.recordStructuresPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.recordStructuresPanel.add((Component)sp, new CC().grow());
        this.processTpane.addTab("Record Structure", this.getConfiguration().getIcon("RECORD_STRUCTURE_ICON"), this.recordStructuresPanel);
    }

    private void initRolesPanel() {
        this.rolesPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.roleNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.roleNameFilter.setEnabled(false);
        this.roleNameFilter.setPreferredSize(new Dimension(200, 20));
        this.roleNameFilter.setMinimumSize(new Dimension(200, 20));
        this.roleNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.roleNameFilter);
        this.rolesList = new ArrayList();
        SingleColumnsTableModel model = new SingleColumnsTableModel(this.rolesList);
        this.rolesTable = new JTable(model);
        this.rolesTable.getTableHeader().setReorderingAllowed(false);
        this.roleNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.roleNameFilter, this.rolesTable, 0));
        this.addTableSelectionListener(this.rolesTable, this.rolesList);
        TableColumn col0 = this.rolesTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        this.singleCSorter = new TableRowSorter<SingleColumnsTableModel>(model);
        this.singleCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.rolesTable);
        this.rolesPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.rolesPanel.add((Component)sp, new CC().grow());
        this.processTpane.addTab("Roles", this.getConfiguration().getIcon("ROLE_ICON"), this.rolesPanel);
    }

    private void initStoresPanel() {
        this.infoStoresPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.infoStoreNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.infoStoreNameFilter.setEnabled(false);
        this.infoStoreNameFilter.setPreferredSize(new Dimension(200, 20));
        this.infoStoreNameFilter.setMinimumSize(new Dimension(200, 20));
        this.infoStoreNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.infoStoreNameFilter);
        this.infoStoresList = new ArrayList();
        SingleColumnsTableModel model = new SingleColumnsTableModel(this.infoStoresList);
        this.infoStoresTable = new JTable(model);
        this.infoStoresTable.getTableHeader().setReorderingAllowed(false);
        this.infoStoreNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.infoStoreNameFilter, this.infoStoresTable, 0));
        this.addTableSelectionListener(this.infoStoresTable, this.infoStoresList);
        TableColumn col0 = this.infoStoresTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        this.singleCSorter = new TableRowSorter<SingleColumnsTableModel>(model);
        this.singleCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.infoStoresTable);
        this.infoStoresPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.infoStoresPanel.add((Component)sp, new CC().grow());
        this.processTpane.addTab("Information Stores", this.getConfiguration().getIcon("INFO_STORE_ICON"), this.infoStoresPanel);
    }

    private void initTransformationsPanel() {
        this.transformationsPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[]0", "0[30!]0[grow]0"));
        this.transformationNameFilter = new JSearchTextField(true, true, Messages.getString("ChangeRequestsAdmin.Name"));
        this.transformationNameFilter.setEnabled(false);
        this.transformationNameFilter.setPreferredSize(new Dimension(200, 20));
        this.transformationNameFilter.setMinimumSize(new Dimension(200, 20));
        this.transformationNameFilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.transformationNameFilter);
        this.transformationsList = new ArrayList();
        SingleColumnsTableModel model = new SingleColumnsTableModel(this.transformationsList);
        this.transformationsTable = new JTable(model);
        this.transformationsTable.getTableHeader().setReorderingAllowed(false);
        this.transformationNameFilter.getDocument().addDocumentListener(new FilterObjectListener(this.transformationNameFilter, this.transformationsTable, 0));
        this.addTableSelectionListener(this.transformationsTable, this.transformationsList);
        TableColumn col0 = this.transformationsTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        this.singleCSorter = new TableRowSorter<SingleColumnsTableModel>(model);
        this.singleCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.transformationsTable);
        this.transformationsPanel.add((Component)toolBar, new CC().gapLeft("5"));
        this.transformationsPanel.add((Component)sp, new CC().grow());
        this.processTpane.addTab("Transformations", this.getConfiguration().getIcon("TRANSFORMATION_ICON"), this.transformationsPanel);
    }

    private void crFilter() {
        RowFilter rf = null;
        if (this.crTable != null) {
            if (!"".equals(this.crFilter.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.crFilter.getText(), this.crTable.convertColumnIndexToModel(0));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)this.crTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)this.crTable.getRowSorter()).setRowFilter(null);
                this.crTable.clearSelection();
            }
        }
    }

    private void refObjFilter() {
        RowFilter rf = null;
        if (this.refObjectsTable != null) {
            if (!"".equals(this.refObjectsFilter.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.refObjectsFilter.getText(), this.refObjectsTable.convertColumnIndexToModel(0));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)this.refObjectsTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)this.refObjectsTable.getRowSorter()).setRowFilter(null);
                this.refObjectsTable.clearSelection();
            }
        }
    }

    private void allObjFilter() {
        RowFilter rf = null;
        if (this.availableObjectsTable != null) {
            if (!"".equals(this.availableObjectsFilter.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.availableObjectsFilter.getText(), this.availableObjectsTable.convertColumnIndexToModel(0));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)this.availableObjectsTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)this.availableObjectsTable.getRowSorter()).setRowFilter(null);
                this.availableObjectsTable.clearSelection();
            }
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ChangeRequestsAdmin.ChangeRequestAdministration"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(true);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    private List getModels() {
        ArrayList<DesignPart> models = new ArrayList<DesignPart>();
        for (RelationalDesign rd : this.appView.getCurrentDesign().getRelationalDesigns()) {
            models.add(rd);
        }
        models.add(this.appView.getCurrentDesign().getLogicalDesign());
        models.add(this.appView.getCurrentDesign().getProcessModel());
        return models;
    }

    private void availableobjectsFilter(JTextField filterText, JTable currentTable, int column) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), currentTable.convertColumnIndexToModel(column));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    private void addTableSelectionListener(final JTable table, final List list) {
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (table.getSelectedRow() > -1) {
                        if (ChangeRequestsAdmin.this.crIsSelected) {
                            ChangeRequestsAdmin.this.buttonAdd.setEnabled(true);
                        } else {
                            ChangeRequestsAdmin.this.buttonAdd.setEnabled(false);
                        }
                        ChangeRequestsAdmin.this.objectIsSelected = true;
                    } else {
                        ChangeRequestsAdmin.this.buttonAdd.setEnabled(false);
                        ChangeRequestsAdmin.this.objectIsSelected = false;
                    }
                    ChangeRequestsAdmin.this.currentTable = table;
                    ChangeRequestsAdmin.this.currentList = list;
                }
            }
        });
    }

    private void clearTableSelections() {
        this.tablesTable.clearSelection();
        this.columnsTable.clearSelection();
        this.pkukTable.clearSelection();
        this.indexesTable.clearSelection();
        this.tableViewsTable.clearSelection();
        this.soTable.clearSelection();
        this.entitiesTable.clearSelection();
        this.attributesTable.clearSelection();
        this.relationsTable.clearSelection();
        this.identifiersTable.clearSelection();
        this.entityViewsTable.clearSelection();
        this.agentsTable.clearSelection();
        this.eventsTable.clearSelection();
        this.flowsTable.clearSelection();
        this.infoStructuresTable.clearSelection();
        this.processesTable.clearSelection();
        this.recordStructuresTable.clearSelection();
        this.rolesTable.clearSelection();
        this.infoStoresTable.clearSelection();
        this.transformationsTable.clearSelection();
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    @Override
    protected String getHelpIndex() {
        return "CHANGE_REQUESTS_ADMIN_DIALOG";
    }

    @Override
    protected int getMinimumWidth() {
        return 720;
    }

    @Override
    protected int getMinimumHeight() {
        return 690;
    }

    private class FilterObjectListener
    implements DocumentListener {
        JTextField objectsFilter;
        JTable objectsTable;
        int column;

        FilterObjectListener(JTextField objectsFilter, JTable objectsTable, int column) {
            this.objectsFilter = objectsFilter;
            this.objectsTable = objectsTable;
            this.column = column;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ChangeRequestsAdmin.this.availableobjectsFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ChangeRequestsAdmin.this.availableobjectsFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ChangeRequestsAdmin.this.availableobjectsFilter(this.objectsFilter, this.objectsTable, this.column);
        }
    }

    class CmbModelsRenderer
    extends JLabel
    implements ListCellRenderer {
        CmbModelsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            this.setText(((DesignPart)value).getName());
            return this;
        }
    }

    private class RemoveObjectActionListener
    implements ActionListener {
        private RemoveObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ChangeRequestsAdmin.this.refObjectsTable.getRowSorter().setSortKeys(null);
            int[] selected = ChangeRequestsAdmin.this.refObjectsTable.getSelectedRows();
            ArrayList tempList = new ArrayList();
            for (int i = 0; i < selected.length; ++i) {
                Object current = ChangeRequestsAdmin.this.refObjectsList.get(ChangeRequestsAdmin.this.refObjectsTable.convertRowIndexToModel(selected[i]));
                tempList.add(current);
            }
            ChangeRequestsAdmin.this.refObjectsList.removeAll(tempList);
            if (ChangeRequestsAdmin.this.refObjectsList.size() > 0) {
                ChangeRequestsAdmin.this.refObjectsTable.setRowSorter(null);
                ChangeRequestsAdmin.this.refObjectsTable.setRowSorter(ChangeRequestsAdmin.this.refObjectsTableSorter);
                ChangeRequestsAdmin.this.refObjectsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.refObjectsTable, 0);
            }
            ChangeRequestsAdmin.this.refObjectsTable.updateUI();
            for (Object obj : tempList) {
                if (obj instanceof Table) {
                    if (ChangeRequestsAdmin.this.tablesTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.tablesTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.tablesList.add(obj);
                    ChangeRequestsAdmin.this.tablesTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.tablesTable.setRowSorter(ChangeRequestsAdmin.this.twoCSorter);
                    ChangeRequestsAdmin.this.tablesTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.tablesTable, 1);
                    ChangeRequestsAdmin.this.tablesTable.updateUI();
                    continue;
                }
                if (obj instanceof Column) {
                    if (ChangeRequestsAdmin.this.columnsTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.columnsTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.columnsList.add(obj);
                    ChangeRequestsAdmin.this.columnsTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.columnsTable.setRowSorter(ChangeRequestsAdmin.this.threeCSorter);
                    ChangeRequestsAdmin.this.columnsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.columnsTable, 2);
                    ChangeRequestsAdmin.this.columnsTable.updateUI();
                    continue;
                }
                if (obj instanceof Index) {
                    if (ChangeRequestsAdmin.this.pkukTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.pkukTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.pkukList.add(obj);
                    ChangeRequestsAdmin.this.pkukTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.pkukTable.setRowSorter(ChangeRequestsAdmin.this.threeCSorter);
                    ChangeRequestsAdmin.this.pkukTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.pkukTable, 2);
                    ChangeRequestsAdmin.this.pkukTable.updateUI();
                    if (ChangeRequestsAdmin.this.indexesTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.indexesTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.indexesList.add(obj);
                    ChangeRequestsAdmin.this.indexesTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.indexesTable.setRowSorter(ChangeRequestsAdmin.this.fourCSorter);
                    ChangeRequestsAdmin.this.indexesTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.indexesTable, 3);
                    ChangeRequestsAdmin.this.indexesTable.updateUI();
                    continue;
                }
                if (obj instanceof TableView) {
                    if (ChangeRequestsAdmin.this.tableViewsTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.tableViewsTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.tableViewsList.add(obj);
                    ChangeRequestsAdmin.this.tableViewsTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.tableViewsTable.setRowSorter(ChangeRequestsAdmin.this.twoCSorter);
                    ChangeRequestsAdmin.this.tableViewsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.tableViewsTable, 1);
                    ChangeRequestsAdmin.this.tableViewsTable.updateUI();
                    continue;
                }
                if (obj instanceof Entity) {
                    if (ChangeRequestsAdmin.this.entitiesTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.entitiesTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.entitiesList.add(obj);
                    ChangeRequestsAdmin.this.entitiesTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.entitiesTable.setRowSorter(ChangeRequestsAdmin.this.singleCSorter);
                    ChangeRequestsAdmin.this.entitiesTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.entitiesTable, 0);
                    ChangeRequestsAdmin.this.entitiesTable.updateUI();
                    continue;
                }
                if (obj instanceof Attribute) {
                    if (ChangeRequestsAdmin.this.attributesTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.attributesTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.attributesList.add(obj);
                    ChangeRequestsAdmin.this.attributesTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.attributesTable.setRowSorter(ChangeRequestsAdmin.this.twoCSorter);
                    ChangeRequestsAdmin.this.attributesTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.attributesTable, 1);
                    ChangeRequestsAdmin.this.attributesTable.updateUI();
                    continue;
                }
                if (obj instanceof Relation) {
                    if (ChangeRequestsAdmin.this.relationsTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.relationsTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.relationsList.add(obj);
                    ChangeRequestsAdmin.this.relationsTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.relationsTable.setRowSorter(ChangeRequestsAdmin.this.twoCSorter);
                    ChangeRequestsAdmin.this.relationsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.relationsTable, 1);
                    ChangeRequestsAdmin.this.relationsTable.updateUI();
                    continue;
                }
                if (obj instanceof CandidateKey) {
                    if (ChangeRequestsAdmin.this.identifiersTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.identifiersTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.identifiersList.add(obj);
                    ChangeRequestsAdmin.this.identifiersTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.identifiersTable.setRowSorter(ChangeRequestsAdmin.this.twoCSorter);
                    ChangeRequestsAdmin.this.identifiersTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.identifiersTable, 1);
                    ChangeRequestsAdmin.this.identifiersTable.updateUI();
                    continue;
                }
                if (obj instanceof EntityView) {
                    if (ChangeRequestsAdmin.this.entityViewsTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.entityViewsTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.entityViewsList.add(obj);
                    ChangeRequestsAdmin.this.entityViewsTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.entityViewsTable.setRowSorter(ChangeRequestsAdmin.this.singleCSorter);
                    ChangeRequestsAdmin.this.entityViewsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.entityViewsTable, 0);
                    ChangeRequestsAdmin.this.entityViewsTable.updateUI();
                    continue;
                }
                if (obj instanceof ExternalAgent) {
                    if (ChangeRequestsAdmin.this.agentsTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.agentsTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.agentsList.add(obj);
                    ChangeRequestsAdmin.this.agentsTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.agentsTable.setRowSorter(ChangeRequestsAdmin.this.singleCSorter);
                    ChangeRequestsAdmin.this.agentsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.agentsTable, 0);
                    ChangeRequestsAdmin.this.agentsTable.updateUI();
                    continue;
                }
                if (obj instanceof Flow) {
                    if (ChangeRequestsAdmin.this.flowsTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.flowsTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.flowsList.add(obj);
                    ChangeRequestsAdmin.this.flowsTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.flowsTable.setRowSorter(ChangeRequestsAdmin.this.singleCSorter);
                    ChangeRequestsAdmin.this.flowsTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.flowsTable, 0);
                    ChangeRequestsAdmin.this.flowsTable.updateUI();
                    continue;
                }
                if (obj instanceof Event) {
                    if (ChangeRequestsAdmin.this.eventsTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.eventsTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.eventsList.add(obj);
                    ChangeRequestsAdmin.this.eventsTable.updateUI();
                    continue;
                }
                if (obj instanceof InfoStructure) {
                    if (ChangeRequestsAdmin.this.infoStructuresTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.infoStructuresTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.infoStructuresList.add(obj);
                    ChangeRequestsAdmin.this.infoStructuresTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.infoStructuresTable.setRowSorter(ChangeRequestsAdmin.this.singleCSorter);
                    ChangeRequestsAdmin.this.infoStructuresTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.infoStructuresTable, 0);
                    ChangeRequestsAdmin.this.infoStructuresTable.updateUI();
                    continue;
                }
                if (obj instanceof Process) {
                    if (ChangeRequestsAdmin.this.processesTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.processesTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.processesList.add(obj);
                    ChangeRequestsAdmin.this.processesTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.processesTable.setRowSorter(ChangeRequestsAdmin.this.singleCSorter);
                    ChangeRequestsAdmin.this.processesTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.processesTable, 0);
                    ChangeRequestsAdmin.this.processesTable.updateUI();
                    continue;
                }
                if (obj instanceof RecordStructure) {
                    if (ChangeRequestsAdmin.this.recordStructuresTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.recordStructuresTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.recordStructuresList.add(obj);
                    ChangeRequestsAdmin.this.recordStructuresTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.recordStructuresTable.setRowSorter(ChangeRequestsAdmin.this.singleCSorter);
                    ChangeRequestsAdmin.this.recordStructuresTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.recordStructuresTable, 0);
                    ChangeRequestsAdmin.this.recordStructuresTable.updateUI();
                    continue;
                }
                if (obj instanceof Role) {
                    if (ChangeRequestsAdmin.this.rolesTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.rolesTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.rolesList.add(obj);
                    ChangeRequestsAdmin.this.rolesTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.rolesTable.setRowSorter(ChangeRequestsAdmin.this.singleCSorter);
                    ChangeRequestsAdmin.this.rolesTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.rolesTable, 0);
                    ChangeRequestsAdmin.this.rolesTable.updateUI();
                    continue;
                }
                if (obj instanceof InfoStore) {
                    if (ChangeRequestsAdmin.this.infoStoresTable.getRowSorter() != null) {
                        ChangeRequestsAdmin.this.infoStoresTable.getRowSorter().setSortKeys(null);
                    }
                    ChangeRequestsAdmin.this.infoStoresList.add(obj);
                    ChangeRequestsAdmin.this.infoStoresTable.setRowSorter(null);
                    ChangeRequestsAdmin.this.infoStoresTable.setRowSorter(ChangeRequestsAdmin.this.singleCSorter);
                    ChangeRequestsAdmin.this.infoStoresTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.infoStoresTable, 0);
                    ChangeRequestsAdmin.this.infoStoresTable.updateUI();
                    continue;
                }
                if (!(obj instanceof Transformation)) continue;
                if (ChangeRequestsAdmin.this.transformationsTable.getRowSorter() != null) {
                    ChangeRequestsAdmin.this.transformationsTable.getRowSorter().setSortKeys(null);
                }
                ChangeRequestsAdmin.this.transformationsList.add(obj);
                ChangeRequestsAdmin.this.transformationsTable.setRowSorter(null);
                ChangeRequestsAdmin.this.transformationsTable.setRowSorter(ChangeRequestsAdmin.this.singleCSorter);
                ChangeRequestsAdmin.this.transformationsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.transformationsTable, 0);
                ChangeRequestsAdmin.this.transformationsTable.updateUI();
            }
            ChangeRequestsAdmin.this.btnSave.setEnabled(true);
        }
    }

    private class AddObjectActionListener
    implements ActionListener {
        private AddObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            RowSorter<? extends TableModel> currentTableSorter = null;
            if (ChangeRequestsAdmin.this.currentTable.getRowSorter() != null) {
                currentTableSorter = ChangeRequestsAdmin.this.currentTable.getRowSorter();
                ChangeRequestsAdmin.this.currentTable.getRowSorter().setSortKeys(null);
            }
            if (ChangeRequestsAdmin.this.refObjectsTable.getRowSorter() != null && ChangeRequestsAdmin.this.refObjectsList.size() >= 1) {
                ChangeRequestsAdmin.this.refObjectsTable.getRowSorter().setSortKeys(null);
            }
            int[] selected = ChangeRequestsAdmin.this.currentTable.getSelectedRows();
            ArrayList<DesignObject> tempList = new ArrayList<DesignObject>();
            for (int i = 0; i < selected.length; ++i) {
                DesignObject current = (DesignObject)ChangeRequestsAdmin.this.currentList.get(ChangeRequestsAdmin.this.currentTable.convertRowIndexToModel(selected[i]));
                if (ChangeRequestsAdmin.this.refObjectsList.contains(current)) continue;
                tempList.add(current);
                ChangeRequestsAdmin.this.refObjectsList.add(current);
            }
            ChangeRequestsAdmin.this.currentList.removeAll(tempList);
            if (currentTableSorter != null) {
                ChangeRequestsAdmin.this.currentTable.setRowSorter(null);
                ChangeRequestsAdmin.this.currentTable.setRowSorter(currentTableSorter);
                ChangeRequestsAdmin.this.currentTable.setAutoCreateRowSorter(true);
            }
            ChangeRequestsAdmin.this.currentTable.updateUI();
            ChangeRequestsAdmin.this.refObjectsTable.setRowSorter(null);
            ChangeRequestsAdmin.this.refObjectsTable.setRowSorter(ChangeRequestsAdmin.this.refObjectsTableSorter);
            ChangeRequestsAdmin.this.refObjectsTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(ChangeRequestsAdmin.this.refObjectsTable, 0);
            ChangeRequestsAdmin.this.refObjectsTable.updateUI();
            ChangeRequestsAdmin.this.btnSave.setEnabled(true);
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (ChangeRequestsAdmin.this.currentCR != null) {
                ChangeRequestsAdmin.this.currentCR.getObjects().clear();
                Iterator it = ChangeRequestsAdmin.this.refObjectsList.iterator();
                while (it.hasNext()) {
                    ChangeRequestsAdmin.this.currentCR.addObject((DesignObject)it.next());
                }
            }
            block1: for (ChangeRequest cr : ChangeRequestsAdmin.this.crList) {
                Iterator it1 = ChangeRequestsAdmin.this.design.getChangeRequestSet().iterator();
                while (it1.hasNext()) {
                    ChangeRequest cr1 = (ChangeRequest)it1.next();
                    if (!cr.getObjectID().equals(cr1.getObjectID())) continue;
                    for (DesignObject obj : cr1.getObjects()) {
                        obj.removeRequest(cr1);
                    }
                    cr1.getObjects().clear();
                    for (DesignObject obj : cr.getObjects()) {
                        obj.addRequest(cr1);
                        cr1.addObject(obj);
                        obj.setDirty(true);
                    }
                    continue block1;
                }
            }
            ChangeRequestsAdmin.this.btnSave.setEnabled(false);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ChangeRequestsAdmin.ChangeRequestsAreSaved"), Messages.getString("ChangeRequestsAdmin.ChangeRequestAdministration"), 1);
        }
    }

    private class AllObjFilterListener
    implements DocumentListener {
        private AllObjFilterListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            ChangeRequestsAdmin.this.allObjFilter();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            ChangeRequestsAdmin.this.allObjFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            ChangeRequestsAdmin.this.allObjFilter();
        }
    }

    private class RefObjFilterListener
    implements DocumentListener {
        private RefObjFilterListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            ChangeRequestsAdmin.this.refObjFilter();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            ChangeRequestsAdmin.this.refObjFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            ChangeRequestsAdmin.this.refObjFilter();
        }
    }

    private class CRFilterListener
    implements DocumentListener {
        private CRFilterListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            ChangeRequestsAdmin.this.crFilter();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            ChangeRequestsAdmin.this.crFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            ChangeRequestsAdmin.this.crFilter();
        }
    }

    private class FourColumnsTableModel
    extends AbstractTableModel {
        private List modelList;
        private String type;

        public FourColumnsTableModel(List modelList, String type) {
            this.modelList = modelList;
            this.type = type;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ChangeRequestsAdmin.TSchema");
            }
            if (column == 1) {
                return Messages.getString("ChangeRequestsAdmin.ISchema");
            }
            if (column == 2) {
                return Messages.getString("ChangeRequestsAdmin.Table");
            }
            if (column == 3) {
                return Messages.getString("ChangeRequestsAdmin.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Index index = (Index)this.modelList.get(rowIndex);
            Table table = (Table)index.getContainerObject();
            SchemaObject tableSchemaObj = table.getSchemaObject();
            SchemaObject indexSchemaObj = index.getSchemaObject();
            if (columnIndex == 0) {
                return tableSchemaObj != null ? tableSchemaObj.getName() : "";
            }
            if (columnIndex == 1) {
                return indexSchemaObj != null ? indexSchemaObj.getName() : "";
            }
            if (columnIndex == 2) {
                return table.getName();
            }
            if (columnIndex == 3) {
                return index.getName();
            }
            return "";
        }
    }

    private class ThreeColumnsTableModel
    extends AbstractTableModel {
        private List modelList;
        private String type;

        public ThreeColumnsTableModel(List modelList, String type) {
            this.modelList = modelList;
            this.type = type;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ChangeRequestsAdmin.Schema");
            }
            if (column == 1) {
                return Messages.getString("ChangeRequestsAdmin.Table");
            }
            if (column == 2) {
                return Messages.getString("ChangeRequestsAdmin.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DesignObject obj = (DesignObject)this.modelList.get(rowIndex);
            SchemaObject schemaObj = null;
            Table table = null;
            if (obj instanceof Column) {
                table = (Table)((Column)obj).getContainer();
                schemaObj = table.getSchemaObject();
            } else if (obj instanceof FKIndexAssociation) {
                table = (Table)((FKIndexAssociation)obj).getContainerWithKeyObject();
                schemaObj = table.getSchemaObject();
            } else if (obj instanceof Index) {
                table = (Table)((Index)obj).getContainerWithKeyObject();
                schemaObj = table.getSchemaObject();
            }
            if (columnIndex == 0) {
                return schemaObj != null ? schemaObj.getName() : "";
            }
            if (columnIndex == 1) {
                return table.getName();
            }
            if (columnIndex == 2) {
                return obj.getName();
            }
            return "";
        }
    }

    private class TwoColumnsTableModel
    extends AbstractTableModel {
        private List modelList;
        private String type;

        public TwoColumnsTableModel(List modelList, String type) {
            this.modelList = modelList;
            this.type = type;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                if (this.type.equals("Tables") || this.type.equals("Views") || this.type.equals("Indexes")) {
                    return Messages.getString("ChangeRequestsAdmin.Schema");
                }
                if (this.type.equals("Columns")) {
                    return Messages.getString("ChangeRequestsAdmin.Table");
                }
                if (this.type.equals("Attributes") || this.type.equals("Relations") || this.type.equals("Identifiers")) {
                    return Messages.getString("ChangeRequestsAdmin.Entity");
                }
                return "";
            }
            if (column == 1) {
                return Messages.getString("ChangeRequestsAdmin.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.modelList.size()) {
                return "";
            }
            DesignObject obj = (DesignObject)this.modelList.get(rowIndex);
            if (columnIndex == 0) {
                if (obj instanceof Table || obj instanceof Index || obj instanceof TableView) {
                    SchemaObject schemaObj = ((ContainerObject)obj).getSchemaObject();
                    return schemaObj != null ? schemaObj.getName() : "";
                }
                if (obj instanceof ContainedObjectWithDomain) {
                    return ((DesignObject)((ContainedObjectWithDomain)obj).getParent()).getName();
                }
                if (obj instanceof Relation) {
                    return ((Relation)obj).getSourceEntity().getName();
                }
                if (obj instanceof CandidateKey) {
                    return ((CandidateKey)obj).getContainerObject().getName();
                }
                if (obj instanceof TypeElement) {
                    return ((TypeElement)obj).getStructuredType().getName();
                }
                return "";
            }
            if (columnIndex == 1) {
                return obj.getName();
            }
            return "";
        }
    }

    private class SingleColumnsTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("ChangeRequestsAdmin.Name")};
        private List modelList;

        public SingleColumnsTableModel(List modelList) {
            this.modelList = modelList;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DesignObject o = (DesignObject)this.modelList.get(rowIndex);
            if (columnIndex == 0) {
                return o.getName();
            }
            return "";
        }
    }

    private class AvailableObjectsTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("ChangeRequestsAdmin.Name"), Messages.getString("ChangeRequestsAdmin.Type")};

        private AvailableObjectsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return ChangeRequestsAdmin.this.availableObjectsTableList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DesignObject obj = (DesignObject)ChangeRequestsAdmin.this.availableObjectsTableList.get(rowIndex);
            if (columnIndex == 0) {
                return obj.getName();
            }
            if (columnIndex == 1) {
                return obj.getObjectTypeName();
            }
            return "";
        }
    }

    private class RefObjectsTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("ChangeRequestsAdmin.Name"), Messages.getString("ChangeRequestsAdmin.Type")};

        private RefObjectsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return ChangeRequestsAdmin.this.refObjectsList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DesignObject obj = (DesignObject)ChangeRequestsAdmin.this.refObjectsList.get(rowIndex);
            if (columnIndex == 0) {
                return obj.getName();
            }
            if (columnIndex == 1) {
                if (obj instanceof Index) {
                    return ((Index)obj).getIndexState();
                }
                return obj.getObjectTypeName();
            }
            return "";
        }
    }

    private class CRTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("ChangeRequestsAdmin.Name"), Messages.getString("ChangeRequestsAdmin.Status")};

        private CRTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return ChangeRequestsAdmin.this.crList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ChangeRequest cr = (ChangeRequest)ChangeRequestsAdmin.this.crList.get(rowIndex);
            if (columnIndex == 0) {
                return cr.getName();
            }
            if (columnIndex == 1) {
                return cr.getStatus();
            }
            return "";
        }
    }
}

