/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.xtdmapping;

import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.xtdmapping.ContainerMapping;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class RelMapping {
    XtdMapping mapping;
    RMExtendedMap xmap;
    DesignObject lob;
    DesignObject rob;
    boolean log_rel = true;
    ContainerMapping containerMapping;

    public RelMapping(XtdMapping mapping, RMExtendedMap xmap) {
        this.mapping = mapping;
        this.xmap = xmap;
        this.lob = mapping.getLogicalObject();
        this.rob = mapping.getRelationalObject();
        if (this.rob != null) {
            if (this.rob != mapping.getTargetObject()) {
                this.log_rel = false;
            }
        } else if (!xmap.getRelationalModel().getObjectID().equals(mapping.getTargetDesignPartID())) {
            this.log_rel = false;
        }
    }

    public String getID() {
        return this.mapping.getID();
    }

    public void setID(String id) {
        this.mapping.setID(id);
    }

    public String getLogID() {
        if (this.lob != null) {
            return this.lob.getObjectID();
        }
        if (this.log_rel) {
            return this.mapping.getOwnerID();
        }
        return this.mapping.getTargetID();
    }

    public void setLogID(String id) {
        this.mapping.setOwnerID(id);
    }

    public String getRelID() {
        if (this.rob != null) {
            return this.rob.getObjectID();
        }
        if (this.log_rel) {
            return this.mapping.getTargetID();
        }
        return this.mapping.getOwnerID();
    }

    public void setRelID(String id) {
        this.mapping.setTargetID(id);
    }

    public String getLogContainerID() {
        String id = this.getLogicalContainerID();
        if (this.containerMapping != null && id != null && !id.equals(this.containerMapping.getLogID())) {
            return id;
        }
        return null;
    }

    private String getLogicalContainerID() {
        if (this.lob != null) {
            DesignObject co = RelMapping.getContainer(this.lob);
            if (co != null) {
                return co.getObjectID();
            }
            return null;
        }
        if (this.log_rel) {
            return this.mapping.getOwnerContainerID();
        }
        return this.mapping.getTargetContainerID();
    }

    public void setLogContainerID(String id) {
        this.mapping.setOwnerContainerID(id);
    }

    public String getRelContainerID() {
        return null;
    }

    public String getRelationalContainerID() {
        if (this.rob != null) {
            DesignObject co = RelMapping.getContainer(this.rob);
            if (co != null) {
                return co.getObjectID();
            }
            return null;
        }
        if (this.log_rel) {
            return this.mapping.getTargetContainerID();
        }
        return this.mapping.getOwnerContainerID();
    }

    public void setRelContainerID(String id) {
        this.mapping.setTargetContainerID(id);
    }

    public static DesignObject getContainer(DesignObject obj) {
        if (obj instanceof Attribute) {
            Attribute attr = (Attribute)obj;
            if (attr.getContainerRelation() != null) {
                return attr.getContainerRelation().getObject();
            }
            return attr.getContainer();
        }
        if (obj instanceof Column) {
            Column col = (Column)obj;
            FKIndexAssociation fk = col.getDependOnForeignKey();
            if (fk != null) {
                return fk;
            }
            return col.getContainer();
        }
        if (obj instanceof KeyObject) {
            return ((KeyObject)obj).getContainerWithKeyObject();
        }
        return null;
    }

    public int getLogType() {
        if (this.lob != null) {
            return XtdMapping.getTypeFor(this.lob);
        }
        if (this.log_rel) {
            return this.mapping.getOwnerType();
        }
        return this.mapping.getTargetType();
    }

    public void setLogType(int type) {
        this.mapping.setOwnerType(type);
    }

    public int getRelType() {
        if (this.rob != null) {
            return XtdMapping.getTypeFor(this.rob);
        }
        if (this.log_rel) {
            return this.mapping.getTargetType();
        }
        return this.mapping.getOwnerType();
    }

    public void setRelType(int type) {
        this.mapping.setTargetType(type);
    }

    public int getInheritanceType() {
        return this.mapping.getInheritanceType();
    }

    public void setInheritanceType(int inheritanceType) {
        this.mapping.setInheritanceType(inheritanceType);
    }

    public long getCreationTime() {
        return this.mapping.getCreationTime();
    }

    public void setCreationTime(long creationTime) {
        this.mapping.setCreationTime(creationTime);
    }

    public XtdMapping getXtdMapping() {
        return this.mapping;
    }

    public void setContainerMapping(ContainerMapping containerMapping) {
        this.containerMapping = containerMapping;
    }

    public String getRealSourceEntityID() {
        return this.mapping.getRealSourceEntityID();
    }

    public void setRealSourceEntityID(String realSourceEntityID) {
        this.mapping.setRealSourceEntityID(realSourceEntityID);
    }

    public String getRealTargetEntityID() {
        return this.mapping.getRealTargetEntityID();
    }

    public void setRealTargetEntityID(String realTargetEntityID) {
        this.mapping.setRealTargetEntityID(realTargetEntityID);
    }

    public String getColumnsSelection() {
        return this.mapping.getColumnsSelection();
    }

    public void setColumnsSelection(String columnsSelection) {
        this.mapping.setColumnsSelection(columnsSelection);
    }

    public String getAttributesSelection() {
        return this.mapping.getAttributesSelection();
    }

    public void setAttributesSelection(String attributesSelection) {
        this.mapping.setAttributesSelection(attributesSelection);
    }

    public String getKeysSelection() {
        return this.mapping.getKeysSelection();
    }

    public void setKeysSelection(String keysSelection) {
        this.mapping.setKeysSelection(keysSelection);
    }

    public String getIndexesSelections() {
        return this.mapping.getIndexesSelections();
    }

    public void setIndexesSelections(String indexesSelections) {
        this.mapping.setIndexesSelections(indexesSelections);
    }
}

