/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.placeholder;

import java.awt.Component;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.fcp.DMDiagramEditor;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.ide.editor.Editor;

public class DesignPartViewPlaceHolder
extends PlaceHolder {
    private DesignPartView dpv;

    public DesignPartViewPlaceHolder(DesignPart designPart) {
        super(designPart);
    }

    public DesignPartViewPlaceHolder(DesignPart designPart, String name) {
        super(designPart);
        this.setName(name);
    }

    public DesignPartViewPlaceHolder(DesignPart designPart, DesignPartView dpv) {
        super(designPart);
        this.setObject(dpv);
        if (dpv != null) {
            this.setObjectID(dpv.getDPVId());
        }
        this.dpv = dpv;
        if (dpv != null) {
            dpv.setPlaceHolder(this);
        }
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return false;
    }

    public void setDesignPartView(DesignPartView dpv) {
        this.setObject(dpv);
        this.dpv = dpv;
        if (dpv != null) {
            dpv.setPlaceHolder(this);
            this.setObjectID(dpv.getDPVId());
        }
    }

    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    @Override
    public String getName() {
        return this.dpv.getName();
    }

    @Override
    public boolean setName(String name) {
        if (!this.getName().equals(name)) {
            this.dpv.setName(name);
            if (this.containerSet != null) {
                this.containerSet.sort();
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
        return true;
    }

    private void doSetVisible(boolean visible) {
        if (this.getDesignPartView().isMasterDPV()) {
            this.getDesignPartView().setVisible(visible);
            if (visible) {
                if (!this.getVisible()) {
                    DesignPartView dpv = this.getDesignPartView();
                    int ind = dpv.getTabbedPane().indexOfComponent(dpv);
                    if (ind < 0) {
                        dpv.getTabbedPane().setName(dpv.getName());
                        dpv.getTabbedPane().add((Component)dpv, 0);
                    }
                    dpv.getTabbedPane().setSelectedComponent(dpv);
                    Editor editor = DMDiagramEditor.openNewDiagram(dpv.getTabbedPane());
                    dpv.setContext(editor.getContext());
                    dpv.getTabbedPane().addChangeListener(this.getAppView());
                    if (dpv.showLabels()) {
                        dpv.refreshLabels();
                    }
                } else {
                    this.getDesignPartView().activateEditor();
                }
            } else {
                this.getDesignPartView().closeEditor();
            }
        }
    }

    public void setVisibleNoLater(boolean visible, boolean clearDirty) {
        this.doSetVisible(visible);
        if (clearDirty) {
            this.setDirty(false);
        }
    }

    public void setVisible(final boolean visible, final boolean clearDirty) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetVisible(visible);
            if (clearDirty) {
                this.setDirty(false);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DesignPartViewPlaceHolder.this.doSetVisible(visible);
                    if (clearDirty) {
                        DesignPartViewPlaceHolder.this.setDirty(false);
                    }
                }
            });
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.setVisible(visible, false);
    }

    public void setVisibleNoLater(boolean visible) {
        this.setVisibleNoLater(visible, false);
    }

    private void doSetVisible(boolean visible, ProgressDialog monitor, DesignObject dobj) {
        if (this.getDesignPartView().isMasterDPV()) {
            if (visible) {
                ContainerView cv;
                if (!this.getVisible()) {
                    Editor editor = DMDiagramEditor.openNewDiagram(this.getDesignPartView().getTabbedPane());
                    this.getDesignPartView().setContext(editor.getContext());
                    this.getAppView().updateIdeToolbar(this.getDesignPartView().getToolbarName());
                } else {
                    this.getDesignPartView().activateEditor();
                }
                this.getDesignPartView().setVisible(visible, monitor);
                if (dobj != null && (cv = (ContainerView)dobj.getFirstViewForDPV(this.dpv)) != null) {
                    cv.setCurrentSelectionToContainer();
                    if (cv.getCellView() != null) {
                        this.dpv.getWorkSpace().scrollCellToVisible(cv.getCellView().getCell());
                    }
                }
            } else {
                this.getDesignPartView().closeEditor();
            }
        }
    }

    public void setVisible(boolean visible, ProgressDialog monitor) {
        this.setVisible(visible, monitor, null);
    }

    public void setVisible(final boolean visible, final ProgressDialog monitor, final DesignObject dobj) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetVisible(visible, monitor, dobj);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DesignPartViewPlaceHolder.this.doSetVisible(visible, monitor, dobj);
                }
            });
        }
    }

    public boolean getVisible() {
        if (this.getDesignPartView().isMasterDPV()) {
            return this.getDesignPartView().isEditorVisible();
        }
        return true;
    }

    @Override
    public String getObjectTypeName() {
        return "DesignPartViewPlaceHolder";
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("DesignPartViewPlaceHolder");
    }

    @Override
    public int getNumberOfChildren() {
        if (this.dpv.isMasterDPV()) {
            return this.dpv.getNumberOfChildren();
        }
        return 0;
    }

    @Override
    public ModelObject getChild(int index) {
        return this.dpv.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        return this.dpv.getIndexForChild(child);
    }

    @Override
    public boolean isLeaf() {
        if (this.dpv.isMasterDPV()) {
            return this.dpv.isLeaf();
        }
        return true;
    }

    @Override
    public Object getParent() {
        return this.getDesignObjectSet();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ModelPropertiesDialogEx dialog = new ModelPropertiesDialogEx(this.getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public XtdMapping getDeletedMapping(String designPartID) {
        List list = this.getDesign().getExtendedMap().getDeletedMappingsForDesignPart(this, designPartID);
        if (list.size() > 0) {
            XtdMapping mapping = (XtdMapping)list.get(0);
            return mapping;
        }
        return null;
    }

    public DPVLogicalSubView getEngEntSubView(LogicalDesign ldes) {
        DPVLogical entSubView;
        DesignPartViewPlaceHolder holder;
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, ldes.getObjectID());
        if (list.size() > 0) {
            DPVLogical entSubView2;
            XtdMapping mapping = (XtdMapping)list.get(0);
            DesignObject obj = mapping.getObjectMappedTo(this);
            DesignPartViewPlaceHolder tabHolder = null;
            if (obj != null && obj instanceof DesignPartViewPlaceHolder && (tabHolder = (DesignPartViewPlaceHolder)obj) != null && (entSubView2 = (DPVLogical)tabHolder.getDesignPartView()) != null && entSubView2 instanceof DPVLogicalSubView) {
                return (DPVLogicalSubView)entSubView2;
            }
        }
        if ((holder = (DesignPartViewPlaceHolder)ldes.getLogicalDesignSubviews().getObjectByID(this.getGeneratorID())) == null) {
            holder = (DesignPartViewPlaceHolder)ldes.getLogicalDesignSubviews().getObjectGeneratedBy(this.getObjectID());
        }
        if (holder != null && holder.getDesignPart() == ldes && (entSubView = (DPVLogical)holder.getDesignPartView()) != null && entSubView instanceof DPVLogicalSubView) {
            return (DPVLogicalSubView)entSubView;
        }
        return null;
    }

    public DPVRelationalSubView getEngTabSubView(RelationalDesign pdes) {
        DPVRelational tabSubView;
        DesignPartViewPlaceHolder holder;
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        if (list.size() > 0) {
            DPVRelational tabSubView2;
            XtdMapping mapping = (XtdMapping)list.get(0);
            DesignObject obj = mapping.getObjectMappedTo(this);
            DesignPartViewPlaceHolder tabHolder = null;
            if (obj != null && obj instanceof DesignPartViewPlaceHolder && (tabHolder = (DesignPartViewPlaceHolder)obj) != null && (tabSubView2 = (DPVRelational)tabHolder.getDesignPartView()) != null && tabSubView2 instanceof DPVRelationalSubView) {
                return (DPVRelationalSubView)tabSubView2;
            }
        }
        if ((holder = (DesignPartViewPlaceHolder)pdes.getPhysicalDesignSubviews().getObjectByID(this.getGeneratorID())) == null) {
            holder = (DesignPartViewPlaceHolder)pdes.getPhysicalDesignSubviews().getObjectByID(this.getDesignPartView().getGeneratorId());
        }
        if (holder == null) {
            holder = (DesignPartViewPlaceHolder)pdes.getPhysicalDesignSubviews().getObjectGeneratedBy(this.getObjectID());
        }
        if (holder != null && holder.getDesignPart() == pdes && (tabSubView = (DPVRelational)holder.getDesignPartView()) != null && tabSubView instanceof DPVRelationalSubView) {
            return (DPVRelationalSubView)tabSubView;
        }
        return null;
    }

    @Override
    public String getObjectID() {
        if (this.dpv != null) {
            return this.dpv.getDPVId();
        }
        String id = super.getObjectID();
        this.setObjectID(id);
        return id;
    }

    @Override
    public boolean isCheckedOut() {
        if (this.dpv != null) {
            return this.dpv.isCheckedOut();
        }
        return super.isCheckedOut();
    }

    @Override
    public boolean isDirty() {
        if (this.dpv != null) {
            return this.dpv.isDirty() || super.isDirty();
        }
        return super.isDirty();
    }

    @Override
    public void setDirty(boolean dirty) {
        if (this.dpv != null && dirty) {
            this.dpv.setDirty(dirty);
        }
        super.setDirty(dirty);
    }

    @Override
    public String getRepositoryOID() {
        if (this.dpv != null) {
            return this.dpv.getRepositoryOID();
        }
        return super.getRepositoryOID();
    }

    @Override
    public String getRepositoryOVID() {
        if (this.dpv != null) {
            return this.dpv.getRepositoryOVID();
        }
        return super.getRepositoryOVID();
    }

    @Override
    public String getFilePath() {
        if (this.dpv != null) {
            return this.dpv.getFilePath();
        }
        return super.getFilePath();
    }

    @Override
    public void setFilePath(String filePath) {
        if (this.dpv != null) {
            this.dpv.setFilePath(filePath);
        }
        super.setFilePath(filePath);
    }

    @Override
    public String getStorageName() {
        if (this.dpv != null) {
            return this.dpv.getStorageName();
        }
        return super.getStorageName();
    }
}

