/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.RecordStructure;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLExternalData
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLExternalData(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getProcessModel().getExternalDataSet().createExternalData(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        DesignObject obj;
        ExternalData extData = (ExternalData)super.recreateObject(objInfo, design, tryReadWriteLocking);
        String synonym = objInfo.getAttribute("synonym");
        if (synonym != null) {
            extData.setSynonym(synonym);
        }
        Map map = this.getProperties(objInfo, "attributes");
        extData.setStructured(new Boolean((String)map.get("structured")));
        if (extData.isStructured()) {
            String recStructure = (String)map.get("recordstructure");
            RecordStructure rs = (RecordStructure)extData.getDesign().getProcessModel().getRecordStructureSet().getObjectByID(recStructure);
            if (rs != null) {
                extData.setRecordStructure(rs);
            }
        } else {
            String type = (String)map.get("type");
            LogicalDatatype logType = (LogicalDatatype)extData.getDesign().getLogicalDatatypeSet().getObjectByID(type);
            if (logType != null) {
                extData.setType(logType);
            }
        }
        try {
            int value = Integer.parseInt((String)map.get("startingpos"));
            extData.setStartingPos(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        extData.setDescription((String)map.get("description"));
        String mappedID = (String)map.get("mappedobject");
        if (mappedID != null && !"".equalsIgnoreCase(mappedID) && (obj = design.getLogicalDesign().getAttributeSet().getObjectByID(mappedID)) != null) {
            extData.setMappedDesignObject(obj);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(extData.getObjectID())).append(".dmd");
        extData.setFilePath(buffer.toString());
        return extData;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            if (this.isOldDesign()) {
                buffer.append(designName).append('/').append("processmodel").append('/');
            } else {
                buffer.append(designName).append('/').append("pm").append('/');
            }
        }
        buffer.append(this.getConfiguration().get("extDataPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == ExternalData.class;
    }
}

