/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLMultidimensionalDesign
extends AbstractXMLWriter {
    private MultidimensionalDesign design = null;

    public WXMLMultidimensionalDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof MultidimensionalDesign;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (MultidimensionalDesign)object;
        if (this.design.getAppView().isSelectedForSave(object)) {
            Document doc = this.createDocument("design");
            Element designElm = doc.getDocumentElement();
            designElm.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
            Element referenced = doc.createElement("ref");
            designElm.appendChild(referenced);
            Element vLinks = doc.createElement("view_links");
            designElm.appendChild(vLinks);
            Element compactDiagram = doc.createElement("compact_diagram");
            designElm.appendChild(compactDiagram);
            Collection all = this.design.getStorableDesignObjects();
            Iterator it = all.iterator();
            DesignObject designObject = null;
            while (it.hasNext()) {
                designObject = (DesignObject)it.next();
                this.handleDesignObject(referenced, designObject);
            }
            this.handleLinks(this.design, vLinks);
            this.handleRHLinks(this.design, vLinks);
            this.handleCompactDiagram(this.design, compactDiagram);
            this.appendDocumentsInfo(doc, designElm, this.design);
            this.appendPartiesInfo(doc, designElm, this.design);
            this.appendDisplayProperties(designElm, this.design.getMainView());
            this.appendDiagramViews(doc, designElm, this.design);
            this.design.setDirty(false);
            return doc;
        }
        return null;
    }

    private void appendDocumentsInfo(Document doc, Element designElm, MultidimensionalDesign design) {
        this.appendObjects(designElm, design.getDocuments().toArray(), "documents");
    }

    private void appendPartiesInfo(Document doc, Element docElement, MultidimensionalDesign design) {
        this.appendObjects(docElement, design.getResponsibleParties().toArray(), "parties");
    }

    protected void appendObjects(Element objectInfoNode, Object[] objects, String id) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < objects.length; ++i) {
            DesignObject desObj = (DesignObject)objects[i];
            map.put(String.valueOf(i + 1), StringUtilities.encodeAttributeValue(desObj.getObjectID()));
        }
        this.appendProperties(objectInfoNode, id, map);
    }

    @Override
    protected void appendProperties(Element objectInfoNode, String id, Map map) {
        Element propertiesList = objectInfoNode.getOwnerDocument().createElement(id);
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = (String)map.get(key);
            if (key.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element param = objectInfoNode.getOwnerDocument().createElement("parameter");
            propertiesList.appendChild(param);
            this.appendProperty(param, key, value);
        }
        objectInfoNode.appendChild(propertiesList);
    }

    private void handleDesignObject(Element referenced, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            if (this.getPersistenceManager().isCheckDirty()) {
                if (designObject.isDirty()) {
                    this.getPersistenceManager().write(designObject);
                }
            } else {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(referenced, designObject);
    }

    private void appendReferencedObjectElement(Element parentNode, DesignObject designObject) {
        if (designObject instanceof Note && designObject.getFirstViewForDPV(this.design.getMainView()) == null) {
            return;
        }
        Document doc = parentNode.getOwnerDocument();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", designObject.belongsToDesign() ? OBJECT_CONTAINS : OBJECT_USES);
        objInfo.setAttribute("type", designObject.getObjectTypeName());
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        this.appendGraphicalInfo(objInfo, designObject);
        parentNode.appendChild(objInfo);
    }

    public void appendGraphicalInfo(Element objInfo, DesignObject designObject) {
        ApplicationView view = designObject.getDesign().getAppView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(designObject);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }

    public void handleLinks(MultidimensionalDesign dsn, Element designElm) {
        if (dsn.getAppView() != null) {
            DesignPartView dpv = dsn.getMainView();
            Iterator it = dsn.getLinkSet().iterator();
            while (it.hasNext()) {
                Link link = (Link)it.next();
                if (link.getSourceTV(dpv) == null && link.getTargetTV(dpv) == null) continue;
                this.appendLinkObjectElement(dsn, designElm, link);
            }
        }
    }

    private void appendLinkObjectElement(MultidimensionalDesign dsn, Element parentNode, Link link) {
        EdgeView edgeView;
        Document doc = parentNode.getOwnerDocument();
        DesignPartView dpv = dsn.getMainView();
        TVLink tv = (TVLink)link.getViewFor(dpv);
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(link.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(link.getObjectID()));
        objInfo.setAttribute("viewid_source", link.getSourceTV(dpv) != null ? link.getSourceTV(dpv).getViewID() : NULL_STR);
        objInfo.setAttribute("viewid_target", link.getTargetTV(dpv) != null ? link.getTargetTV(dpv).getViewID() : NULL_STR);
        Element points = doc.createElement("points");
        if (tv != null) {
            EdgeView acv = (EdgeView)((DefaultEdge)tv.getCellView().getCell()).getCellView();
            List edgePoints = acv.getPoints();
            for (int i = 0; i < edgePoints.size(); ++i) {
                Object obj = edgePoints.get(i);
                Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                if (p == null) continue;
                Element point = doc.createElement("point");
                point.setAttribute("x_coordinate", Double.toString(p.getX()));
                point.setAttribute("y_coordinate", Double.toString(p.getY()));
                points.appendChild(point);
            }
        }
        objInfo.appendChild(points);
        if (link.getRollupLink() != null && link.getRollupLink().isRolePlaying() && (edgeView = (EdgeView)tv.getCellView()) != null) {
            Element labels = doc.createElement("labels");
            Element lbl = doc.createElement("main_label");
            lbl.setAttribute("x_coordinate", Double.toString(tv.getLabelBounds().getX()));
            lbl.setAttribute("y_coordinate", Double.toString(tv.getLabelBounds().getY()));
            lbl.setAttribute("width", Double.toString(tv.getLabelBounds().getWidth()));
            lbl.setAttribute("height", Double.toString(tv.getLabelBounds().getHeight()));
            labels.appendChild(lbl);
            objInfo.appendChild(labels);
        }
        if (tv != null) {
            Element graphycal = doc.createElement("graphical");
            Element param = objInfo.getOwnerDocument().createElement("parameter");
            graphycal.appendChild(param);
            param.setAttribute("name", "use_default_color");
            param.setAttribute("value", Boolean.toString(tv.useDefaultColor()));
            if (!tv.useDefaultColor()) {
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "color");
                param.setAttribute("value", tv.getBackgroundColor() != null ? Integer.toString(tv.getBackgroundColor().getRGB()) : NULL_STR);
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "width");
                param.setAttribute("value", Integer.toString(tv.getLineWidth()));
            }
            objInfo.appendChild(graphycal);
        }
        parentNode.appendChild(objInfo);
    }

    public void handleRHLinks(MultidimensionalDesign dsn, Element designElm) {
        if (dsn.getAppView() != null) {
            Iterator it = dsn.getRaggedHLinkSet().iterator();
            while (it.hasNext()) {
                RaggedHLink link = (RaggedHLink)it.next();
                if (link.getChildLevel().getTopView() == null || link.getParentLevel().getTopView() == null) continue;
                this.appendRHLinkObjectElement(dsn, designElm, link);
            }
        }
    }

    private void appendRHLinkObjectElement(MultidimensionalDesign dsn, Element parentNode, RaggedHLink link) {
        Document doc = parentNode.getOwnerDocument();
        TVRaggedHLink tv = (TVRaggedHLink)link.getTopView();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(link.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(link.getObjectID()));
        objInfo.setAttribute("viewid_source", link.getSourceTV() != null ? link.getSourceTV().getViewID() : NULL_STR);
        objInfo.setAttribute("viewid_target", link.getTargetTV() != null ? link.getTargetTV().getViewID() : NULL_STR);
        Element points = doc.createElement("points");
        if (tv != null) {
            EdgeView acv = (EdgeView)((DefaultEdge)tv.getCellView().getCell()).getCellView();
            List edgePoints = acv.getPoints();
            for (int i = 0; i < edgePoints.size(); ++i) {
                Object obj = edgePoints.get(i);
                Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                if (p == null) continue;
                Element point = doc.createElement("point");
                point.setAttribute("x_coordinate", Double.toString(p.getX()));
                point.setAttribute("y_coordinate", Double.toString(p.getY()));
                points.appendChild(point);
            }
        }
        objInfo.appendChild(points);
        if (tv != null) {
            Element graphycal = doc.createElement("graphical");
            Element param = objInfo.getOwnerDocument().createElement("parameter");
            graphycal.appendChild(param);
            param.setAttribute("name", "use_default_color");
            param.setAttribute("value", Boolean.toString(tv.useDefaultColor()));
            if (!tv.useDefaultColor()) {
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "color");
                param.setAttribute("value", tv.getBackgroundColor() != null ? Integer.toString(tv.getBackgroundColor().getRGB()) : NULL_STR);
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "width");
                param.setAttribute("value", Integer.toString(tv.getLineWidth()));
            }
            objInfo.appendChild(graphycal);
        }
        parentNode.appendChild(objInfo);
    }

    @Override
    public String getFilenameFor(Object object) {
        MultidimensionalDesign dsn = (MultidimensionalDesign)object;
        return StringUtilities.encodeAttributeValue(dsn.getObjectID());
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String designName = this.design.getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append('/').append(designName).append('/').append("multidimensional");
            return buffer.toString();
        }
        return "multidimensional";
    }

    public void handleCompactDiagram(MultidimensionalDesign mdd, Element compactDiagram) {
        if (mdd.getAppView() != null) {
            AbstractMDObject link;
            DesignPartViewPlaceHolder dpvPH = mdd.getCompactDiagramPlaceHolder();
            DPVCompactMultidimentional dpv = mdd.getCompactDiagram();
            compactDiagram.setAttribute("name", dpv.getName());
            compactDiagram.setAttribute("id", dpv.getDPVId());
            compactDiagram.setAttribute("generator", dpv.getGeneratorId());
            compactDiagram.setAttribute("visible", dpvPH.getVisible() ? "true" : "false");
            compactDiagram.setAttribute("comment", StringUtilities.encodeAttributeValue(dpvPH.getComment()));
            compactDiagram.setAttribute("notes", StringUtilities.encodeAttributeValue(dpvPH.getNotes()));
            this.addCubesInDPV(mdd, compactDiagram, dpv);
            this.addDimensionsInDPV(mdd, compactDiagram, dpv);
            this.addLevelsInDPV(mdd, compactDiagram, dpv);
            this.addNotesInDPV(mdd, compactDiagram, dpv);
            Iterator it = mdd.getLinkSet().iterator();
            while (it.hasNext()) {
                link = (Link)it.next();
                this.appendSubViewLinkInfo(compactDiagram, dpv, (Link)link);
            }
            it = mdd.getRaggedHLinkSet().iterator();
            while (it.hasNext()) {
                link = (RaggedHLink)it.next();
                this.appendSubViewRaggedHLinkInfo(compactDiagram, dpv, (RaggedHLink)link);
            }
            this.appendDisplayProperties(compactDiagram, dpv);
        }
    }

    private void appendSubViewLinkInfo(Element parentNode, DesignPartView dpv, Link link) {
        block8: {
            try {
                EdgeView edgeView;
                Document doc = parentNode.getOwnerDocument();
                TVLink tv = (TVLink)link.getViewFor(dpv);
                if (tv == null || link.getSourceTV(dpv) == null || link.getTargetTV(dpv) == null) break block8;
                Element objInfo = doc.createElement("objectid");
                objInfo.setAttribute("role", "represents");
                objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(link.getObjectTypeName()));
                objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(link.getObjectID()));
                objInfo.setAttribute("viewid_source", link.getSourceTV(dpv) != null ? link.getSourceTV(dpv).getViewID() : NULL_STR);
                objInfo.setAttribute("viewid_target", link.getTargetTV(dpv) != null ? link.getTargetTV(dpv).getViewID() : NULL_STR);
                Element points = doc.createElement("points");
                if (tv != null) {
                    if (tv.getCellView() != null) {
                        EdgeView acv = (EdgeView)((DefaultEdge)tv.getCellView().getCell()).getCellView();
                        List edgePoints = acv.getPoints();
                        for (int i = 0; i < edgePoints.size(); ++i) {
                            Object obj = edgePoints.get(i);
                            Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                            if (p == null) continue;
                            Element point = doc.createElement("point");
                            point.setAttribute("x_coordinate", Double.toString(p.getX()));
                            point.setAttribute("y_coordinate", Double.toString(p.getY()));
                            points.appendChild(point);
                        }
                    } else {
                        List edgePoints = tv.getEdgePoints();
                        for (int i = 0; i < edgePoints.size(); ++i) {
                            Object obj = edgePoints.get(i);
                            Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                            if (p == null) continue;
                            Element point = doc.createElement("point");
                            point.setAttribute("x_coordinate", Double.toString(p.getX()));
                            point.setAttribute("y_coordinate", Double.toString(p.getY()));
                            points.appendChild(point);
                        }
                    }
                }
                objInfo.appendChild(points);
                if (link.getRollupLink() != null && link.getRollupLink().isRolePlaying() && (edgeView = (EdgeView)tv.getCellView()) != null) {
                    Element labels = doc.createElement("labels");
                    Element lbl = doc.createElement("main_label");
                    lbl.setAttribute("x_coordinate", Double.toString(tv.getLabelBounds().getX()));
                    lbl.setAttribute("y_coordinate", Double.toString(tv.getLabelBounds().getY()));
                    lbl.setAttribute("width", Double.toString(tv.getLabelBounds().getWidth()));
                    lbl.setAttribute("height", Double.toString(tv.getLabelBounds().getHeight()));
                    labels.appendChild(lbl);
                    objInfo.appendChild(labels);
                }
                parentNode.appendChild(objInfo);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void appendSubViewRaggedHLinkInfo(Element parentNode, DesignPartView dpv, RaggedHLink link) {
        block7: {
            try {
                Document doc = parentNode.getOwnerDocument();
                TVRaggedHLink tv = (TVRaggedHLink)link.getViewFor(dpv);
                if (tv == null || link.getSourceTV(dpv) == null || link.getTargetTV(dpv) == null) break block7;
                Element objInfo = doc.createElement("objectid");
                objInfo.setAttribute("role", "represents");
                objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(link.getObjectTypeName()));
                objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(link.getObjectID()));
                objInfo.setAttribute("viewid_source", link.getSourceTV(dpv) != null ? link.getSourceTV(dpv).getViewID() : NULL_STR);
                objInfo.setAttribute("viewid_target", link.getTargetTV(dpv) != null ? link.getTargetTV(dpv).getViewID() : NULL_STR);
                Element points = doc.createElement("points");
                if (tv != null) {
                    if (tv.getCellView() != null) {
                        EdgeView acv = (EdgeView)((DefaultEdge)tv.getCellView().getCell()).getCellView();
                        List edgePoints = acv.getPoints();
                        for (int i = 0; i < edgePoints.size(); ++i) {
                            Object obj = edgePoints.get(i);
                            Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                            if (p == null) continue;
                            Element point = doc.createElement("point");
                            point.setAttribute("x_coordinate", Double.toString(p.getX()));
                            point.setAttribute("y_coordinate", Double.toString(p.getY()));
                            points.appendChild(point);
                        }
                    } else {
                        List edgePoints = tv.getEdgePoints();
                        for (int i = 0; i < edgePoints.size(); ++i) {
                            Object obj = edgePoints.get(i);
                            Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                            if (p == null) continue;
                            Element point = doc.createElement("point");
                            point.setAttribute("x_coordinate", Double.toString(p.getX()));
                            point.setAttribute("y_coordinate", Double.toString(p.getY()));
                            points.appendChild(point);
                        }
                    }
                }
                objInfo.appendChild(points);
                parentNode.appendChild(objInfo);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void addCubesInDPV(MultidimensionalDesign mdd, Element compactDiagram, DPVCompactMultidimentional dpv) {
        Iterator it = mdd.getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            for (TopView tv : cube.getViewsForDPV(dpv)) {
                this.appendReferencedObjectReprElement(compactDiagram, tv);
            }
        }
    }

    private void addDimensionsInDPV(MultidimensionalDesign mdd, Element compactDiagram, DPVCompactMultidimentional dpv) {
        Iterator it = mdd.getDimensionSet().iterator();
        while (it.hasNext()) {
            Dimension dim = (Dimension)it.next();
            for (TopView tv : dim.getViewsForDPV(dpv)) {
                this.appendReferencedObjectReprElement(compactDiagram, tv);
            }
        }
    }

    private void addLevelsInDPV(MultidimensionalDesign mdd, Element compactDiagram, DPVCompactMultidimentional dpv) {
        Iterator it = mdd.getLevelSet().iterator();
        while (it.hasNext()) {
            Level level = (Level)it.next();
            for (TopView tv : level.getViewsForDPV(dpv)) {
                this.appendReferencedObjectReprElement(compactDiagram, tv);
            }
        }
    }

    private void appendReferencedObjectReprElement(Element parentNode, TopView tv) {
        Document doc = parentNode.getOwnerDocument();
        DesignObject designObject = tv.getModel();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        objInfo.setAttribute("viewid", tv.getViewID());
        objInfo.setAttribute("tv_generator_id", tv.getGeneratorID());
        this.appendGraphicalInfo(objInfo, tv);
        parentNode.appendChild(objInfo);
    }

    public void appendGraphicalInfo(Element objInfo, TopView tv) {
        DesignObject designObject = tv.getModel();
        ApplicationView view = designObject.getDesign().getAppView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(tv);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }

    private void addNotesInDPV(MultidimensionalDesign mdd, Element compactDiagram, DPVCompactMultidimentional dpv) {
        Iterator it = mdd.getNoteSet().iterator();
        while (it.hasNext()) {
            Note note = (Note)it.next();
            TopView tv = note.getFirstViewForDPV(dpv);
            if (tv == null) continue;
            this.appendReferencedObjectReprElement(compactDiagram, tv);
        }
    }
}

