/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;
import oracle.dbtools.crest.swingui.multidimensional.TVCube;
import oracle.dbtools.crest.swingui.multidimensional.TVDimension;
import oracle.dbtools.crest.swingui.multidimensional.TVLevel;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLMultidimensionalDesign
extends AbstractXMLReader {
    private boolean xmlFromDB = false;
    private static float NFS = 2.4f;
    private float loadedVersion = NFS;
    private static Logger LOGGER = new Logger(RXMLMultidimensionalDesign.class);

    public RXMLMultidimensionalDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        String aID;
        int i;
        this.loadedVersion = design.getDesign().getLoadedVersion();
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        Element root = doc.getDocumentElement();
        String id = root.getAttribute("id");
        if (!"".equalsIgnoreCase(id)) {
            design.setObjectID(StringUtilities.decodeAttributeValue(id));
        }
        NodeList objectElements = RXMLMultidimensionalDesign.getFirstChildByTagName(root, "ref").getElementsByTagName("objectid");
        int length = objectElements.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Element elm = (Element)objectElements.item(i2);
            String role = elm.getAttribute("role");
            String oid = elm.getAttribute("oid");
            boolean getlock = "contains".equalsIgnoreCase(role) && tryReadWriteLocking;
            DesignObject object = null;
            object = !this.xmlFromDB ? (DesignObject)this.getPersistenceManager().read((Object)oid, design.getDesign(), getlock) : design.getDesign().getDesignObject(oid);
            if (object != null) {
                object.setTemporaryWriteable(true);
                if (!object.belongsToDesign(design.getDesign())) {
                    object.setReadOnly(true);
                }
                this.readGraphicalInfo(elm, object);
                object.setTemporaryWriteable(false);
                continue;
            }
            LOGGER.error("RXMLMultidimensionalDesign: Read object returns null (objectID: " + oid);
        }
        Map objMap = this.getProperties(root, "documents");
        Object[] objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            DesignObject object = design.getDesign().getDesignObject(aID);
            if (object == null) continue;
            design.addDocument((BIDocument)object);
        }
        objMap = this.getProperties(root, "parties");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            DesignObject object = design.getDesign().getDesignObject(aID);
            if (object == null) continue;
            design.addResponsibleParty((BIResponsibleParty)object);
        }
        if (!this.xmlFromDB) {
            this.readLinks(root, (MultidimensionalDesign)design);
        }
        if (design.getDesign().getLoadedVersion() <= 2.1f) {
            ((MultidimensionalDesign)design).getCompactDiagram().generateDiagram();
        } else {
            this.readCompactDiagram(root, (MultidimensionalDesign)design);
        }
        this.readDisplayProperties(root, design.getMainView());
        design.getMainView().getWorkSpace().updateSettings();
        this.readDiagramViews(root, design);
        design.getMainView().setDirty(false);
        ((MultidimensionalDesign)design).getCompactDiagram().setDirty(false);
        design.setLoaded(true);
        return design;
    }

    @Override
    protected Map getProperties(Element objInfo, String id) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Element propertiesElm = RXMLMultidimensionalDesign.getFirstChildByTagName(objInfo, id);
        if (propertiesElm != null) {
            NodeList propList = propertiesElm.getElementsByTagName("parameter");
            int length = propList.getLength();
            for (int j = 0; j < length; ++j) {
                Element param = (Element)propList.item(j);
                map.put(param.getAttribute("name"), param.getAttribute("value"));
            }
        }
        return map;
    }

    private void readLinks(Element root, MultidimensionalDesign design) {
        Element fklist;
        ApplicationView.log(Messages.getString("RXMLMultidimensionalDesign.ReadLinks"));
        DesignPartView dpv = design.getMainView();
        if (design.getAppView() != null && (fklist = RXMLMultidimensionalDesign.getFirstChildByTagName(root, "view_links")) != null) {
            NodeList objectElements = fklist.getElementsByTagName("objectid");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                int lineWidth;
                String width;
                Color backgroundColor;
                String color;
                boolean useDef;
                String useDefault;
                HashMap<String, String> map;
                NodeList paramList;
                Element graphical;
                Element lbl;
                Element labels;
                String y;
                String x;
                Element point;
                TVConnector tv;
                int plLength;
                NodeList plist;
                Element points;
                TopView tv2;
                TopViewCollection col;
                String tvid;
                String svid;
                AbstractMDObject link;
                Element elm = (Element)objectElements.item(i);
                String oid = elm.getAttribute("oid");
                String type = elm.getAttribute("type");
                if (type.equalsIgnoreCase("Link")) {
                    link = (Link)design.getLinkSet().getObjectByID(oid);
                    svid = elm.getAttribute("viewid_source");
                    tvid = elm.getAttribute("viewid_target");
                    if (!svid.equals("null") && (col = ((Link)link).getSourceMDObject().getViewsForDPV(dpv)).size() == 1) {
                        tv2 = (TopView)col.get(0);
                        ((Link)link).setSourceTV((AbstractMDTV)tv2);
                    }
                    if (!tvid.equals("null") && (col = ((Link)link).getTargetMDObject().getViewsForDPV(dpv)).size() == 1) {
                        tv2 = (TopView)col.get(0);
                        ((Link)link).setTargetTV((AbstractMDTV)tv2);
                    }
                    points = RXMLMultidimensionalDesign.getFirstChildByTagName(elm, "points");
                    plist = points.getElementsByTagName("point");
                    plLength = plist.getLength();
                    tv = (TVLink)((Link)link).getTopView();
                    for (int kk = 0; kk < plLength; ++kk) {
                        point = (Element)plist.item(kk);
                        x = point.getAttribute("x_coordinate");
                        y = point.getAttribute("y_coordinate");
                        tv.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                    }
                    labels = RXMLMultidimensionalDesign.getFirstChildByTagName(elm, "labels");
                    if (labels != null && (lbl = RXMLMultidimensionalDesign.getFirstChildByTagName(labels, "main_label")) != null) {
                        x = lbl.getAttribute("x_coordinate");
                        y = lbl.getAttribute("y_coordinate");
                        String w = lbl.getAttribute("width");
                        String h = lbl.getAttribute("height");
                        if (x != null && !"".equals(x)) {
                            if (w == null || "".equalsIgnoreCase(w)) {
                                w = "-1";
                            }
                            if (h == null || "".equalsIgnoreCase(h)) {
                                h = "-1";
                            }
                            tv.setLabelBounds(new Rectangle((int)Double.parseDouble(x), (int)Double.parseDouble(y), (int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                        }
                    }
                    if ((graphical = RXMLMultidimensionalDesign.getFirstChildByTagName(elm, "graphical")) == null) continue;
                    paramList = graphical.getElementsByTagName("parameter");
                    map = new HashMap<String, String>();
                    int plength = paramList.getLength();
                    for (int l = 0; l < plength; ++l) {
                        Element param = (Element)paramList.item(l);
                        map.put(param.getAttribute("name"), param.getAttribute("value"));
                    }
                    useDefault = (String)map.get("use_default_color");
                    useDef = true;
                    if (useDefault != null) {
                        useDef = Boolean.valueOf(useDefault);
                    }
                    tv.setUseDefaultColor(useDef);
                    if (useDef) continue;
                    color = (String)map.get("color");
                    if (color != null && !"null".equalsIgnoreCase(color)) {
                        backgroundColor = new Color(Integer.parseInt(color));
                        tv.setBackgroundColor(backgroundColor);
                    }
                    if ((width = (String)map.get("width")) == null || "null".equalsIgnoreCase(width)) continue;
                    lineWidth = Integer.parseInt(width);
                    tv.setLineWidth(lineWidth);
                    continue;
                }
                if (!type.equalsIgnoreCase("RaggedHLink")) continue;
                link = (RaggedHLink)design.getRaggedHLinkSet().getObjectByID(oid);
                svid = elm.getAttribute("viewid_source");
                tvid = elm.getAttribute("viewid_target");
                if (!svid.equals("null") && (col = ((RaggedHLink)link).getSourceMDObject().getViewsForDPV(dpv)).size() == 1) {
                    tv2 = (TopView)col.get(0);
                    ((RaggedHLink)link).setSourceTV((AbstractMDTV)tv2);
                }
                if (!tvid.equals("null") && (col = ((RaggedHLink)link).getTargetMDObject().getViewsForDPV(dpv)).size() == 1) {
                    tv2 = (TopView)col.get(0);
                    ((RaggedHLink)link).setTargetTV((AbstractMDTV)tv2);
                }
                points = RXMLMultidimensionalDesign.getFirstChildByTagName(elm, "points");
                plist = points.getElementsByTagName("point");
                plLength = plist.getLength();
                tv = (TVRaggedHLink)((RaggedHLink)link).getTopView();
                for (int kk = 0; kk < plLength; ++kk) {
                    point = (Element)plist.item(kk);
                    x = point.getAttribute("x_coordinate");
                    y = point.getAttribute("y_coordinate");
                    tv.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                }
                labels = RXMLMultidimensionalDesign.getFirstChildByTagName(elm, "labels");
                if (labels == null || (lbl = RXMLMultidimensionalDesign.getFirstChildByTagName(labels, "main_label")) != null) {
                    // empty if block
                }
                if ((graphical = RXMLMultidimensionalDesign.getFirstChildByTagName(elm, "graphical")) == null) continue;
                paramList = graphical.getElementsByTagName("parameter");
                map = new HashMap();
                int plength = paramList.getLength();
                for (int l = 0; l < plength; ++l) {
                    Element param = (Element)paramList.item(l);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                useDefault = (String)map.get("use_default_color");
                useDef = true;
                if (useDefault != null) {
                    useDef = Boolean.valueOf(useDefault);
                }
                tv.setUseDefaultColor(useDef);
                if (useDef) continue;
                color = (String)map.get("color");
                if (color != null && !"null".equalsIgnoreCase(color)) {
                    backgroundColor = new Color(Integer.parseInt(color));
                    tv.setBackgroundColor(backgroundColor);
                }
                if ((width = (String)map.get("width")) == null || "null".equalsIgnoreCase(width)) continue;
                lineWidth = Integer.parseInt(width);
                tv.setLineWidth(lineWidth);
            }
        }
    }

    public void readGraphicalInfo(Element objInfo, DesignObject object) {
        if (object == null || object.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView view = object.getDesign().getAppView();
        if (view != null) {
            NodeList list = objInfo.getElementsByTagName("graphical");
            HashMap<String, String> map = null;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)list.item(i);
                map = new HashMap<String, String>();
                NodeList paramList = elm.getElementsByTagName("parameter");
                int plength = paramList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)paramList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                view.setGraphicalPropsFor(object, map);
            }
        }
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(designName).append('/').append("multidimensional");
            return buffer.toString();
        }
        return "multidimensional";
    }

    private void readCompactDiagram(Element root, MultidimensionalDesign design) {
        Element elm;
        ApplicationView.log(Messages.getString("RXMLMultidimensionalDesign.ReadMultidimensionalCompactDiagram"));
        if (design.getAppView() != null && (elm = RXMLMultidimensionalDesign.getFirstChildByTagName(root, "compact_diagram")) != null) {
            String dpvName = elm.getAttribute("name");
            String dpvId = elm.getAttribute("id");
            String generatorId = elm.getAttribute("generator");
            DPVCompactMultidimentional dpv = design.getCompactDiagram();
            this.readDisplayProperties(elm, dpv);
            dpv.setName(dpvName);
            ((DesignPartView)dpv).setVisible(false);
            if (dpvId != null && !"".equalsIgnoreCase(dpvId) && !"null".equalsIgnoreCase(dpvId)) {
                dpv.setDPVId(dpvId);
            }
            if (generatorId != null && !"".equalsIgnoreCase(generatorId) && !"null".equalsIgnoreCase(generatorId)) {
                dpv.setGeneratorId(generatorId);
            }
            String visible = elm.getAttribute("visible");
            NodeList elements = elm.getElementsByTagName("objectid");
            int ln = elements.getLength();
            for (int k = 0; k < ln; ++k) {
                Element lbl;
                Element labels;
                String y;
                String x;
                Element point;
                TVConnector tvLink;
                int plLength;
                NodeList plist;
                Element points;
                String tvid;
                String svid;
                AbstractMDObject link;
                String tvgenId;
                String vid;
                ContainerView tvt;
                Element tv = (Element)elements.item(k);
                String type = tv.getAttribute("type");
                String oid = tv.getAttribute("oid");
                if (type.equalsIgnoreCase("Cube")) {
                    Cube cube = (Cube)design.getCubeSet().getObjectByID(oid);
                    tvt = (TVCube)((TVCube)cube.getTopView()).createViewSynonim(dpv);
                    vid = tv.getAttribute("viewid");
                    tvgenId = tv.getAttribute("tv_generator_id");
                    tvt.setViewID(vid);
                    if (tvgenId != null && !"".equalsIgnoreCase(tvgenId) && !"null".equalsIgnoreCase(tvgenId)) {
                        tvt.setGeneratorID(tvgenId);
                    }
                    this.readGraphicalInfo(tv, tvt);
                }
                if (type.equalsIgnoreCase("Dimension")) {
                    Dimension dim = (Dimension)design.getDimensionSet().getObjectByID(oid);
                    tvt = (TVDimension)((TVDimension)dim.getTopView()).createViewSynonim(dpv);
                    vid = tv.getAttribute("viewid");
                    tvgenId = tv.getAttribute("tv_generator_id");
                    tvt.setViewID(vid);
                    if (tvgenId != null && !"".equalsIgnoreCase(tvgenId) && !"null".equalsIgnoreCase(tvgenId)) {
                        tvt.setGeneratorID(tvgenId);
                    }
                    this.readGraphicalInfo(tv, tvt);
                }
                if (type.equalsIgnoreCase("Level")) {
                    Level level = (Level)design.getLevelSet().getObjectByID(oid);
                    tvt = (TVLevel)((TVLevel)level.getTopView()).createViewSynonim(dpv);
                    vid = tv.getAttribute("viewid");
                    tvgenId = tv.getAttribute("tv_generator_id");
                    tvt.setViewID(vid);
                    if (tvgenId != null && !"".equalsIgnoreCase(tvgenId) && !"null".equalsIgnoreCase(tvgenId)) {
                        tvt.setGeneratorID(tvgenId);
                    }
                    this.readGraphicalInfo(tv, tvt);
                }
                if (type.equalsIgnoreCase("Note")) {
                    Note note = (Note)this.getPersistenceManager().read((Object)oid, design.getDesign(), true);
                    tvt = (TVNote)((TVNote)note.getTopView()).createViewSynonim(dpv);
                    note.removeTopView(note.getTopView());
                    vid = tv.getAttribute("viewid");
                    tvt.setViewID(vid);
                    this.readGraphicalInfo(tv, tvt);
                }
                if (type.equalsIgnoreCase("Link") && (link = (Link)design.getLinkSet().getObjectByID(oid)) != null) {
                    svid = tv.getAttribute("viewid_source");
                    tvid = tv.getAttribute("viewid_target");
                    if (!svid.equals("null")) {
                        ((Link)link).setSourceTV((AbstractMDTV)((Link)link).getSourceMDObject().getTopViewByID(dpv, svid));
                    }
                    if (!tvid.equals("null")) {
                        ((Link)link).setTargetTV((AbstractMDTV)((Link)link).getTargetMDObject().getTopViewByID(dpv, tvid));
                    }
                    if ((points = RXMLMultidimensionalDesign.getFirstChildByTagName(tv, "points")) != null) {
                        plist = points.getElementsByTagName("point");
                        plLength = plist.getLength();
                        tvLink = (TVLink)((Link)link).getViewFor(dpv);
                        if (tvLink != null) {
                            for (int kk = 0; kk < plLength; ++kk) {
                                point = (Element)plist.item(kk);
                                x = point.getAttribute("x_coordinate");
                                y = point.getAttribute("y_coordinate");
                                tvLink.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                            }
                            labels = RXMLMultidimensionalDesign.getFirstChildByTagName(tv, "labels");
                            if (labels != null && (lbl = RXMLMultidimensionalDesign.getFirstChildByTagName(labels, "main_label")) != null) {
                                x = lbl.getAttribute("x_coordinate");
                                y = lbl.getAttribute("y_coordinate");
                                String w = lbl.getAttribute("width");
                                String h = lbl.getAttribute("height");
                                if (x != null && !"".equals(x)) {
                                    if (w == null || "".equalsIgnoreCase(w)) {
                                        w = "-1";
                                    }
                                    if (h == null || "".equalsIgnoreCase(h)) {
                                        h = "-1";
                                    }
                                    tvLink.setLabelBounds(new Rectangle((int)Double.parseDouble(x), (int)Double.parseDouble(y), (int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                                }
                            }
                        }
                    }
                }
                if (!type.equalsIgnoreCase("RaggedHLink") || (link = (RaggedHLink)design.getRaggedHLinkSet().getObjectByID(oid)) == null) continue;
                svid = tv.getAttribute("viewid_source");
                tvid = tv.getAttribute("viewid_target");
                if (!svid.equals("null")) {
                    ((RaggedHLink)link).setSourceTV((AbstractMDTV)((RaggedHLink)link).getSourceMDObject().getTopViewByID(dpv, svid));
                }
                if (!tvid.equals("null")) {
                    ((RaggedHLink)link).setTargetTV((AbstractMDTV)((RaggedHLink)link).getTargetMDObject().getTopViewByID(dpv, tvid));
                }
                if ((points = RXMLMultidimensionalDesign.getFirstChildByTagName(tv, "points")) == null) continue;
                plist = points.getElementsByTagName("point");
                plLength = plist.getLength();
                tvLink = (TVRaggedHLink)((RaggedHLink)link).getViewFor(dpv);
                if (tvLink == null) continue;
                for (int kk = 0; kk < plLength; ++kk) {
                    point = (Element)plist.item(kk);
                    x = point.getAttribute("x_coordinate");
                    y = point.getAttribute("y_coordinate");
                    tvLink.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                }
                labels = RXMLMultidimensionalDesign.getFirstChildByTagName(elm, "labels");
                if (labels != null && (lbl = RXMLMultidimensionalDesign.getFirstChildByTagName(labels, "main_label")) == null) continue;
            }
            dpv.setMustBeVisible(visible.equalsIgnoreCase("true"));
            String comment = elm.getAttribute("comment");
            ((DesignPartViewPlaceHolder)dpv.getPlaceHolder()).setComment(StringUtilities.decodeAttributeValue(comment));
            String notes = elm.getAttribute("notes");
            ((DesignPartViewPlaceHolder)dpv.getPlaceHolder()).setNotes(StringUtilities.decodeAttributeValue(notes));
            dpv.getWorkSpace().updateSettings();
        }
    }

    public void readGraphicalInfo(Element objInfo, TopView tv) {
        DesignObject object = tv.getModel();
        ApplicationView view = object.getDesign().getAppView();
        if (view != null) {
            NodeList list = objInfo.getElementsByTagName("graphical");
            HashMap<String, String> map = null;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)list.item(i);
                map = new HashMap<String, String>();
                NodeList paramList = elm.getElementsByTagName("parameter");
                int plength = paramList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)paramList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                view.setGraphicalPropsFor(tv, map);
            }
        }
    }
}

