/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RXMLRDBMSSiteSet
extends AbstractXMLReader {
    private static final Logger LOGGER = new Logger(RXMLRDBMSSiteSet.class);

    public RXMLRDBMSSiteSet(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canRead(String objectID) {
        return objectID.endsWith("RDBMSSites");
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        String designName = this.getPersistenceManager().getAppView().getDesignName();
        buffer.append(designName).append('/').append(this.getConfiguration().get("rdbmsSitePath"));
        return buffer.toString();
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean tryReadWriteLocking) {
        RDBMSTypeSet typeSet = Design.getDefaultRDBMSTypeSet();
        Element root = doc.getDocumentElement();
        RDBMSSiteSet set = design.getRDBMSSiteSet();
        this.process(design, typeSet, set, root);
        return set;
    }

    private void process(Design design, RDBMSTypeSet typeSet, RDBMSSiteSet set, Element root) {
        HashMap<String, String> map = new HashMap<String, String>();
        NodeList siteList = root.getElementsByTagName("site");
        int length = siteList.getLength();
        for (int i = 0; i < length; ++i) {
            RDBMSSite site = this.recreateSite((Element)siteList.item(i), set, typeSet);
            if (site == null) continue;
            map.put(site.getObjectID(), site.getName());
        }
        Object[] sites = set.toArray();
        for (int i = 0; i < sites.length; ++i) {
            RDBMSSite site = (RDBMSSite)sites[i];
            if (!site.isDesignLevel() || map.get(site.getObjectID()) != null) continue;
            set.remove(site);
        }
    }

    public RDBMSSite recreateSite(Element siteElm, RDBMSSiteSet set, RDBMSTypeSet typeSet) {
        String name = this.getEncoded(siteElm, "name");
        String typeStr = siteElm.getAttribute("type");
        String siteID = this.getEncoded(siteElm, "oid");
        String pathIDStr = siteElm.getAttribute("pathid");
        RDBMSSite site = set.getByObjectID(siteID);
        if (site != null) {
            site.setName(name);
            return site;
        }
        site = set.createSite(name, set.getDesign());
        site.setIsDefault(false);
        site.setDesignLevel(true);
        int type = 8;
        try {
            type = Integer.parseInt(typeStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        RDBMSType rdbmsType = typeSet.get(type);
        site.setType(rdbmsType);
        site.setObjectID(siteID);
        int pathID = 0;
        try {
            pathID = Integer.parseInt(pathIDStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            type = Integer.parseInt(typeStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pathID > 0) {
            site.setPathID(pathID);
            set.updateMaxIndex(pathID);
        } else {
            site.setPathID(set.nextIndex());
        }
        if (rdbmsType == null) {
            LOGGER.error("Unknown RDBMS type: " + type);
        }
        return site;
    }

    private String getEncoded(Element siteElement, String name) {
        return StringUtilities.decodeAttributeValue(siteElement.getAttribute(name));
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == RDBMSSiteSet.class;
    }

    public Object readNoneDefaultRDBMSSites(String path, Design design, RDBMSSiteSet set) {
        File file = new File(path);
        try {
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputSource inputSource = new InputSource(new InputStreamReader((InputStream)fis, "UTF-8"));
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                RDBMSTypeSet typeSet = Design.getDefaultRDBMSTypeSet();
                Element root = doc.getDocumentElement();
                this.process(design, typeSet, set, root);
                return set;
            }
        }
        catch (Exception e) {
            LOGGER.error(e);
        }
        return set;
    }
}

