/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RXMLDesign
extends AbstractXMLReader {
    private boolean xmlFromDB = false;

    public RXMLDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public Object recreateObject(Document doc, Design design, ProgressDialog monitor) {
        this.readVersion(doc, design);
        design.setNewDesign(false);
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        List designParts = design.getStorableDesignParts();
        NodeList domainFiles = doc.getDocumentElement().getElementsByTagName("domain");
        int length = domainFiles.getLength();
        Collection domfiles = design.getDomainFileNames();
        domfiles.clear();
        for (int i = 0; i < length; ++i) {
            Element elm = (Element)domainFiles.item(i);
            String file = StringUtilities.decodeAttributeValue(elm.getAttribute("name"));
            domfiles.add(file);
        }
        Element root = doc.getDocumentElement();
        NodeList designs = root.getElementsByTagName("design");
        if (!this.xmlFromDB) {
            design.getRelationalDesigns().removeAll();
        }
        int p = 40;
        length = designs.getLength();
        for (int i = 0; i < length; ++i) {
            p += 40 / length;
            Element elm = (Element)designs.item(i);
            String type = StringUtilities.decodeAttributeValue(elm.getAttribute("type"));
            String id = StringUtilities.decodeAttributeValue(elm.getAttribute("id"));
            DesignPart dp = this.getDesignPart(designParts, id);
            String mainViewId = StringUtilities.decodeAttributeValue(elm.getAttribute("main_view_id"));
            String name = StringUtilities.decodeAttributeValue(RXMLDesign.getFirstChildByTagName(elm, "name").getFirstChild().getNodeValue());
            String comment = "";
            String notes = "";
            String shouldOpen = elm.getAttribute("should_be_open");
            String isVisible = elm.getAttribute("is_visible");
            String topLevelDFD = elm.getAttribute("top_level_dfd_design");
            if (RXMLDesign.getFirstChildByTagName(elm, "comment").getFirstChild() != null) {
                comment = RXMLDesign.getFirstChildByTagName(elm, "comment").getFirstChild().getNodeValue();
            }
            if (RXMLDesign.getFirstChildByTagName(elm, "notes") != null && RXMLDesign.getFirstChildByTagName(elm, "notes").getFirstChild() != null) {
                notes = RXMLDesign.getFirstChildByTagName(elm, "notes").getFirstChild().getNodeValue();
            }
            if ("Data Types".equalsIgnoreCase(type)) {
                DataTypesDesign dtDesign = (DataTypesDesign)dp;
                if (dp == null) {
                    dtDesign = design.getDataTypesDesign();
                }
                dtDesign.setNewModel(false);
                dtDesign.setName(name);
                dtDesign.setObjectID(id);
                dtDesign.setComment(StringUtilities.decodeAttributeValue(comment));
                dtDesign.setNotes(StringUtilities.decodeAttributeValue(notes));
                dtDesign.setVisible("true".equalsIgnoreCase(isVisible));
                if (!this.xmlFromDB) {
                    dtDesign.setLoaded(false);
                }
                if (mainViewId == null || "".equalsIgnoreCase(mainViewId) || "null".equalsIgnoreCase(mainViewId)) continue;
                dtDesign.getMainView().setDPVId(mainViewId);
                continue;
            }
            if ("LogicalDesign".equalsIgnoreCase(type)) {
                LogicalDesign logical = (LogicalDesign)dp;
                if (dp == null) {
                    logical = design.getLogicalDesign();
                }
                logical.setNewModel(false);
                logical.setName(name);
                logical.setObjectID(id);
                logical.setComment(StringUtilities.decodeAttributeValue(comment));
                logical.setNotes(StringUtilities.decodeAttributeValue(notes));
                logical.setVisible("true".equalsIgnoreCase(isVisible));
                if (!this.xmlFromDB) {
                    logical.setLoaded(false);
                }
                if (mainViewId == null || "".equalsIgnoreCase(mainViewId) || "null".equalsIgnoreCase(mainViewId)) continue;
                logical.getMainView().setDPVId(mainViewId);
                continue;
            }
            if ("RelationalModel".equalsIgnoreCase(type)) {
                RelationalDesign relational = (RelationalDesign)dp;
                if (dp == null) {
                    relational = design.addRelationalDesign(name);
                }
                relational.setObjectID(id);
                if (design.getLoadedVersion() >= 3.2f) {
                    String path_id_str = StringUtilities.decodeAttributeValue(elm.getAttribute("path_id"));
                    try {
                        int path_id = Integer.parseInt(path_id_str);
                        relational.setPathID(path_id);
                        design.getRelationalDesigns().updateMaxIndex(path_id);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                relational.setNewModel(false);
                relational.setComment(StringUtilities.decodeAttributeValue(comment));
                relational.setNotes(StringUtilities.decodeAttributeValue(notes));
                relational.setShouldBeOpen("true".equalsIgnoreCase(shouldOpen));
                relational.setVisible("true".equalsIgnoreCase(isVisible));
                if (!this.xmlFromDB) {
                    relational.setLoaded(false);
                }
                if (mainViewId == null || "".equalsIgnoreCase(mainViewId) || "null".equalsIgnoreCase(mainViewId)) continue;
                relational.getMainView().setDPVId(mainViewId);
                continue;
            }
            if ("Dimensional Model".equalsIgnoreCase(type) || "Multidimensional Diagram".equalsIgnoreCase(type)) {
                MultidimensionalDesign mdDesign = (MultidimensionalDesign)dp;
                if (dp == null) {
                    mdDesign = design.addMultidimensionalDesign(name);
                    design.setMultidimensionalDesign(mdDesign);
                }
                mdDesign.setNewModel(false);
                mdDesign.setObjectID(id);
                mdDesign.setComment(StringUtilities.decodeAttributeValue(comment));
                mdDesign.setNotes(StringUtilities.decodeAttributeValue(notes));
                mdDesign.setShouldBeOpen("true".equalsIgnoreCase(shouldOpen));
                mdDesign.setVisible("true".equalsIgnoreCase(isVisible));
                if (!this.xmlFromDB) {
                    mdDesign.setLoaded(false);
                }
                if (mainViewId == null || "".equalsIgnoreCase(mainViewId) || "null".equalsIgnoreCase(mainViewId)) continue;
                mdDesign.getMainView().setDPVId(mainViewId);
                continue;
            }
            if ("Process Model".equalsIgnoreCase(type)) {
                ProcessModel processModel = (ProcessModel)dp;
                if (dp == null) {
                    processModel = design.getProcessModel();
                }
                processModel.setObjectID(id);
                processModel.setComment(StringUtilities.decodeAttributeValue(comment));
                processModel.setNotes(StringUtilities.decodeAttributeValue(notes));
                if (this.xmlFromDB) continue;
                processModel.setLoaded(false);
                continue;
            }
            if ("Data Flow Diagram".equalsIgnoreCase(type)) {
                DataFlowDesign dfDesign = (DataFlowDesign)dp;
                if (dp == null) {
                    dfDesign = "true".equalsIgnoreCase(topLevelDFD) ? design.getProcessModel().addDataFlowDesign(name) : design.getProcessModel().addDataFlowDesign(name, false);
                }
                dfDesign.setNewModel(false);
                design.getProcessModel().setDataFlowDesign(dfDesign);
                dfDesign.setObjectID(id);
                dfDesign.setComment(StringUtilities.decodeAttributeValue(comment));
                dfDesign.setNotes(StringUtilities.decodeAttributeValue(notes));
                dfDesign.setShouldBeOpen("true".equalsIgnoreCase(shouldOpen));
                dfDesign.setVisible("true".equalsIgnoreCase(isVisible));
                if (!this.xmlFromDB) {
                    dfDesign.setLoaded(false);
                }
                design.getProcessModel().setHasOpenedDFDesigns(true);
                if (mainViewId == null || "".equalsIgnoreCase(mainViewId) || "null".equalsIgnoreCase(mainViewId)) continue;
                dfDesign.getMainView().setDPVId(mainViewId);
                continue;
            }
            if (!"Business Information".equalsIgnoreCase(type)) continue;
            BusinessInfoDesign biDesign = design.getBusinessInfoDesign();
            biDesign.setName(name);
            biDesign.setObjectID(id);
            biDesign.setComment(StringUtilities.decodeAttributeValue(comment));
            if (this.xmlFromDB) continue;
            biDesign.setLoaded(false);
        }
        if (!this.xmlFromDB) {
            NodeList reqInfo = doc.getDocumentElement().getElementsByTagName("changerequests");
            length = reqInfo.getLength();
            for (int i = 0; i < length; ++i) {
                if (i != 0) continue;
                Element elm = (Element)reqInfo.item(i);
                String ids = StringUtilities.decodeAttributeValue(elm.getAttribute("id"));
                StringTokenizer tokenizer = new StringTokenizer(ids, ",");
                while (tokenizer.hasMoreTokens()) {
                    String id = tokenizer.nextToken().trim();
                    this.getPersistenceManager().read((Object)id, design, true);
                }
            }
        }
        this.readDesignProperties(doc, design);
        return design;
    }

    private void readDesignProperties(Document doc, Design design) {
        NodeList list = doc.getDocumentElement().getElementsByTagName("object");
        if (list != null && list.getLength() > 0) {
            String notes;
            Node textNode;
            Element notesElm;
            String comment;
            Node textNode2;
            Element objInfo = (Element)list.item(0);
            Element commentElm = RXMLDesign.getFirstChildByTagName(objInfo, "comment");
            if (commentElm != null && (textNode2 = commentElm.getFirstChild()) != null && (comment = textNode2.getNodeValue()) != null) {
                design.setComment(StringUtilities.decodeAttributeValue(comment));
            }
            if ((notesElm = RXMLDesign.getFirstChildByTagName(objInfo, "notes")) != null && (textNode = notesElm.getFirstChild()) != null && (notes = textNode.getNodeValue()) != null) {
                design.setNotes(StringUtilities.decodeAttributeValue(notes));
            }
            NodeList changes = objInfo.getElementsByTagName("alter");
            int length = changes.getLength();
            for (int i = 0; i < length; ++i) {
                Element changeElm = (Element)changes.item(i);
                if (!changeElm.getParentNode().equals(objInfo)) continue;
                String label = StringUtilities.decodeAttributeValue(changeElm.getAttribute("type"));
                this.readChange(changeElm, design, label);
            }
        }
    }

    public void readVersion(Document doc, Design design) {
        NodeList list = doc.getDocumentElement().getElementsByTagName("version");
        if (list != null && list.getLength() > 0) {
            Element versionElm = (Element)list.item(0);
            String value = StringUtilities.decodeAttributeValue(versionElm.getAttribute("version"));
            if (value != null) {
                try {
                    float version = Float.parseFloat(value);
                    design.setLoadedVersion(version);
                }
                catch (NumberFormatException e) {
                    design.setLoadedVersion(0.0f);
                }
            } else {
                design.setLoadedVersion(0.0f);
            }
            String designID = StringUtilities.decodeAttributeValue(versionElm.getAttribute("design_id"));
            if (designID != null && !"".equalsIgnoreCase(designID)) {
                design.setDesignID(designID);
            } else {
                design.setDesignID(new GUID().toString());
            }
        } else {
            design.setLoadedVersion(0.0f);
        }
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean readOnlyDomains) {
        NodeList domainFiles = doc.getDocumentElement().getElementsByTagName("domain");
        int length = domainFiles.getLength();
        for (int i = 0; i < length; ++i) {
            Element elm = (Element)domainFiles.item(i);
            String file = StringUtilities.decodeAttributeValue(elm.getAttribute("name"));
            if ("defaultdomains".equals(file)) continue;
            boolean attemptLocking = false;
            this.getPersistenceManager().read((Object)file, design, attemptLocking);
        }
        if (!readOnlyDomains) {
            Element root = doc.getDocumentElement();
            NodeList designs = root.getElementsByTagName("design");
            design.getRelationalDesigns().removeAll();
            length = designs.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)designs.item(i);
                String type = StringUtilities.decodeAttributeValue(elm.getAttribute("type"));
                String id = StringUtilities.decodeAttributeValue(elm.getAttribute("id"));
                String name = StringUtilities.decodeAttributeValue(RXMLDesign.getFirstChildByTagName(elm, "name").getFirstChild().getNodeValue());
                String comment = "";
                if (RXMLDesign.getFirstChildByTagName(elm, "comment").getFirstChild() != null) {
                    comment = RXMLDesign.getFirstChildByTagName(elm, "comment").getFirstChild().getNodeValue();
                }
                if ("Data Types".equalsIgnoreCase(type)) {
                    DataTypesDesign dtDesign = design.getDataTypesDesign();
                    dtDesign.setName(name);
                    dtDesign.setObjectID(id);
                    dtDesign.setComment(comment);
                    this.getPersistenceManager().read((Object)name, dtDesign, false);
                    continue;
                }
                if ("LogicalDesign".equalsIgnoreCase(type)) {
                    LogicalDesign logical = design.getLogicalDesign();
                    logical.setName(name);
                    logical.setObjectID(id);
                    logical.setComment(comment);
                    this.getPersistenceManager().read((Object)name, logical, false);
                    continue;
                }
                if ("RelationalModel".equalsIgnoreCase(type)) {
                    RelationalDesign relational = design.addRelationalDesign(name);
                    relational.setObjectID(id);
                    relational.setComment(comment);
                    design.setRelationalDesign(relational);
                    this.getPersistenceManager().read((Object)id, relational, false);
                    continue;
                }
                if ("Process Model".equalsIgnoreCase(type)) {
                    ProcessModel processModel = design.getProcessModel();
                    processModel.setObjectID(id);
                    processModel.setComment(comment);
                    this.getPersistenceManager().read((Object)id, processModel, false);
                    continue;
                }
                if ("Data Flow Diagram".equalsIgnoreCase(type)) {
                    DataFlowDesign dfDesign = design.getProcessModel().addDataFlowDesign(name);
                    dfDesign.setObjectID(id);
                    dfDesign.setComment(comment);
                    design.getProcessModel().setDataFlowDesign(dfDesign);
                    this.getPersistenceManager().read((Object)id, dfDesign, false);
                    continue;
                }
                if (!"Business Information".equalsIgnoreCase(type)) continue;
                BusinessInfoDesign biDesign = design.getBusinessInfoDesign();
                biDesign.setName(name);
                biDesign.setObjectID(id);
                biDesign.setComment(comment);
                this.getPersistenceManager().read((Object)name, biDesign, false);
            }
        }
        return design;
    }

    @Override
    public String getRelativePath() {
        return "";
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    private DesignPart getDesignPart(List designParts, String id) {
        DesignPart dp2 = null;
        for (DesignPart dp2 : designParts) {
            if (!dp2.getObjectID().equalsIgnoreCase(id)) continue;
            return dp2;
        }
        return null;
    }
}

