/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class XMLObjToStringBuilderTransformer
extends MDTransformer
implements MDXMLConstants {
    private static final String OPEN_CHAR_SLASH = "</";
    private static final String NEWLINE_OPENCHAR_SLASH = "\n</";
    private static final String NEWLINE_OPENCHAR = "\n<";
    private static final String EQUAL_SLASH = "=\"";
    private static final String INNER_CLASS = "innerClass";
    private static final String XML_VERSION_1_0_ENCODING_UTF_8 = "<?xml version = '1.0' encoding = 'UTF-8'?>";
    public static boolean includeLoggingProps = true;
    public static boolean includeID = true;
    private static StringBuilder sb = new StringBuilder(4096);

    public StringBuilder transformFromObject(Object object) {
        return this.transformFromObject(object, false);
    }

    public StringBuilder transformFromObject(Object object, boolean processExternals) {
        sb.delete(0, sb.length());
        sb.append(XML_VERSION_1_0_ENCODING_UTF_8);
        this.transformFromObject(object, null, sb, processExternals);
        return sb;
    }

    public void transformFromObject(Object object, String tagName, StringBuilder sb) {
        this.transformFromObject(object, tagName, sb, false);
    }

    public void transformFromObject(Object object, String tagName, StringBuilder sb, boolean processExternals) {
        String name = this.transformFromObject(object, tagName, sb, processExternals, false);
        this.addCloseTag(name, sb);
    }

    public String transformFromObject(Object object, String tagName, StringBuilder sb, boolean processExternals, boolean skipClassName) {
        String name = "";
        try {
            ClassDescription cd = this.getClassDescription();
            String xmlName = "";
            if (tagName != null) {
                this.addOpenTag(tagName, sb);
            } else {
                boolean innerClass = false;
                xmlName = cd.getXmlName();
                while (xmlName.indexOf(36) > -1) {
                    xmlName = xmlName.replace('$', '.');
                    innerClass = true;
                }
                this.addOpenTag(xmlName, sb);
                if (innerClass) {
                    this.addAttribute(INNER_CLASS, "true", sb);
                }
            }
            if (!SKP_CLASS_NAME && !skipClassName) {
                this.addAttribute("class", cd.getClassName(), sb);
            }
            this.invokeMethod(object, cd.beforeTransform);
            if (processExternals) {
                this.invokeMethod(object, cd.beforeTransformExt);
            }
            this.processProperties(object, sb, cd, processExternals);
            this.processClassPropertyMap(object, sb, cd);
            this.processCollections(object, sb, cd, processExternals);
            name = tagName != null ? tagName : xmlName;
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }

    private void addAttribute(String name, String value, StringBuilder sb) {
        sb.append(' ').append(name).append(EQUAL_SLASH).append(value).append('\"');
    }

    private void addOpenTag(String tagname, StringBuilder sb) {
        sb.append(NEWLINE_OPENCHAR).append(tagname);
    }

    private void addCloseTag(String tagname, StringBuilder sb) {
        sb.append(NEWLINE_OPENCHAR_SLASH).append(tagname).append('>');
    }

    private void addElement(String tagname, String value, StringBuilder sb) {
        sb.append(NEWLINE_OPENCHAR).append(tagname).append('>').append(value).append(OPEN_CHAR_SLASH).append(tagname).append('>');
    }

    private void addCloseChar(StringBuilder sb) {
        sb.append('>');
    }

    private void processProperties(Object object, StringBuilder sb, ClassDescription cd) {
        this.processProperties(object, sb, cd, false);
    }

    private void processProperties(Object object, StringBuilder sb, ClassDescription cd, boolean processExternals) {
        String value;
        for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
            if (!pd.isAttribute() || pd.isLoggingProp && !includeLoggingProps || !includeID && "id".equalsIgnoreCase(pd.xmlName) || pd.isExternalProperty && !processExternals || (value = this.getProperty(object, pd)) == null || SKP_DEFAULTS && value.equalsIgnoreCase(pd.defaultValue)) continue;
            value = StringUtilities.encodeAttributeValue(value);
            this.addAttribute(pd.xmlName, value, sb);
        }
        this.addTopViewAttributes(sb, object);
        sb.append('>');
        for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
            MDTransformationManager.TrObjects tr;
            if (pd.isLoggingProp && !includeLoggingProps || !includeID && "id".equalsIgnoreCase(pd.xmlName) || pd.isExternalProperty && !processExternals) continue;
            if (pd.isRectangle) {
                Object obj = XMLObjToStringBuilderTransformer.getObjectForProperty(object, pd);
                if (obj == null || !(obj instanceof Rectangle)) continue;
                this.appendBounds(sb, pd.xmlName, (Rectangle)obj);
                continue;
            }
            if (pd.isPropertyMap) {
                this.processPropertyAsPropertyMap(object, sb, pd);
                continue;
            }
            if (pd.isMap) {
                this.processMapProperty(object, sb, pd);
                continue;
            }
            if (pd.isSimpleClass() || pd.isStringClass() || pd.isReferred()) {
                value = this.getProperty(object, pd);
                if (value == null || SKP_DEFAULTS && value.equalsIgnoreCase(pd.defaultValue)) continue;
                value = StringUtilities.encodeAttributeValue(value);
                if (pd.isAttribute()) continue;
                this.addElement(pd.xmlName, value, sb);
                continue;
            }
            Object nested = XMLObjToStringBuilderTransformer.getObjectForProperty(object, pd);
            if (nested == null || (tr = this.getTransformationManager().getTransformersFor(nested.getClass())) == null || tr.getFromObjectTransformer() == null || !(tr.getFromObjectTransformer() instanceof XMLObjToStringBuilderTransformer)) continue;
            XMLObjToStringBuilderTransformer xmltr = (XMLObjToStringBuilderTransformer)tr.getFromObjectTransformer();
            xmltr.transformFromObject(nested, pd.xmlName, sb, processExternals);
        }
    }

    private void processPropertyAsPropertyMap(Object object, StringBuilder sb, ClassDescription.PropertyDescription pd) {
        Object obj;
        if (pd.isPropertyMap && (obj = XMLObjToStringBuilderTransformer.getObjectForProperty(object, pd)) != null && obj instanceof PropertyMap) {
            PropertyMap pm = (PropertyMap)obj;
            boolean pmadded = false;
            Iterator it = pm.getPropertyNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = pm.getProperty(key);
                if (value == null) continue;
                if (!pmadded) {
                    this.addOpenTag(pd.xmlName, sb);
                    sb.append('>');
                    pmadded = true;
                }
                this.addOpenTag(pd.pmItemName, sb);
                this.addAttribute(pd.pmKeyName, StringUtilities.encodeAttributeValue(key), sb);
                this.addAttribute(pd.pmValueName, StringUtilities.encodeAttributeValue(value), sb);
                sb.append("/>");
            }
            if (pmadded) {
                this.addCloseTag(pd.xmlName, sb);
            }
        }
    }

    private void processMapProperty(Object object, StringBuilder sb, ClassDescription.PropertyDescription pd) {
        Object obj;
        if (pd.isMap && (obj = XMLObjToStringBuilderTransformer.getObjectForProperty(object, pd)) != null && obj instanceof Map) {
            Map map = (Map)obj;
            boolean pmadded = false;
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (value == null) continue;
                if (!pmadded) {
                    this.addOpenTag(pd.xmlName, sb);
                    sb.append('>');
                    pmadded = true;
                }
                this.addOpenTag(pd.pmItemName, sb);
                this.addAttribute("key", StringUtilities.encodeAttributeValue(key), sb);
                this.addAttribute("value", StringUtilities.encodeAttributeValue(value.toString()), sb);
                sb.append("/>");
            }
            if (pmadded) {
                this.addCloseTag(pd.xmlName, sb);
            }
        }
    }

    private void processClassPropertyMap(Object object, StringBuilder sb, ClassDescription cd) {
        if (cd.isPropertyMap && object instanceof PropertyMap) {
            PropertyMap pmap = (PropertyMap)object;
            Iterator it = pmap.getPropertyNames();
            boolean pmadded = false;
            while (it.hasNext()) {
                String key = (String)it.next();
                if (this.skipProperty(key)) continue;
                String value = pmap.getProperty(key);
                if (!pmadded) {
                    this.addOpenTag("propertyMap", sb);
                    sb.append('>');
                    pmadded = true;
                }
                this.addOpenTag("property", sb);
                this.addAttribute("name", StringUtilities.encodeAttributeValue(key), sb);
                this.addAttribute("value", StringUtilities.encodeAttributeValue(value), sb);
                sb.append("/>");
            }
            if (pmadded) {
                this.addCloseTag("propertyMap", sb);
            }
        }
    }

    private boolean skipProperty(String name) {
        return false;
    }

    private void processCollections(Object object, StringBuilder sb, ClassDescription cd) {
        this.processCollections(object, sb, cd, false);
    }

    private void processCollections(Object object, StringBuilder sb, ClassDescription cd, boolean processExternals) {
        for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
            Object sourceCol;
            Collection col;
            if (cold.isExternalCollection && !processExternals || (col = this.getObjectList(sourceCol = XMLObjToStringBuilderTransformer.getCollection(object, cold), cold)) == null || !(col instanceof Collection) || SKP_DEFAULTS && col.size() <= 0) continue;
            if (cold.itemIsRef) {
                this.processCollectionWithRefs(object, col, sb, cold, processExternals);
                continue;
            }
            this.processCollectionWithContained(col, sb, cold, processExternals);
        }
    }

    private void processCollectionWithRefs(Object object, Collection col, StringBuilder sb, ClassDescription.CollectionDescription cold) {
        this.processCollectionWithRefs(object, col, sb, cold, false);
    }

    private void processCollectionWithRefs(Object object, Collection col, StringBuilder sb, ClassDescription.CollectionDescription cold, boolean processExternals) {
        if (cold.isExternalCollection && !processExternals) {
            return;
        }
        this.addOpenTag(cold.xmlName, sb);
        if (!cold.listOfRefs) {
            sb.append('>');
            for (Object item : col) {
                if (item == null) continue;
                String id = null;
                if (item instanceof ModelIDObject) {
                    id = ((ModelIDObject)item).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    id = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, item);
                } else {
                    int k = 0;
                    ++k;
                }
                this.addElement(cold.itemXmlName, id, sb);
            }
            this.addCloseTag(cold.xmlName, sb);
        } else {
            StringBuffer sbi = new StringBuffer();
            boolean first = true;
            for (Object item : col) {
                String id = null;
                if (item instanceof ModelIDObject) {
                    id = ((ModelIDObject)item).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    id = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, item);
                } else {
                    int k = 0;
                    ++k;
                }
                if (id == null) continue;
                if (first) {
                    sbi.append(id);
                    first = false;
                    continue;
                }
                sbi.append(' ').append(id);
            }
            String idrefs = sbi.toString();
            this.addAttribute(cold.refsXMLName, idrefs, sb);
            sb.append("/>");
        }
    }

    private void processCollectionWithContained(Collection col, StringBuilder sb, ClassDescription.CollectionDescription cold) {
        this.processCollectionWithContained(col, sb, cold, false);
    }

    private void processCollectionWithContained(Collection col, StringBuilder sb, ClassDescription.CollectionDescription cold, boolean processExternals) {
        if (cold.isExternalCollection && !processExternals) {
            return;
        }
        this.addOpenTag(cold.xmlName, sb);
        boolean skipClassName = false;
        if (!ApplicationView.INCLUDE_CLASS_NAME_IN_ITEM_XML && cold.itemClassName != null && !"".equals(cold.itemClassName)) {
            skipClassName = true;
            this.addAttribute("itemClass", cold.itemClassName, sb);
        }
        sb.append('>');
        if (cold.isEngPropertyHolderItem) {
            for (Object item : col) {
                if (!(item instanceof EngPropertyHolder)) continue;
                EngPropertyHolder ph = (EngPropertyHolder)item;
                this.addOpenTag(cold.itemXmlName, sb);
                this.addAttribute("name", ph.getName(), sb);
                this.addAttribute("selected", String.valueOf(ph.isSelected()), sb);
                sb.append("/>");
            }
        }
        boolean first = true;
        boolean mapItem = cold.isMapItem;
        MDTransformationManager.TrObjects tr = null;
        Class<?> currentClass = null;
        if (!mapItem) {
            for (Object item : col) {
                if (item instanceof Map) {
                    mapItem = true;
                    continue;
                }
                if (first || currentClass != null && !item.getClass().equals(currentClass)) {
                    tr = this.getTransformationManager().getTransformersFor(item.getClass());
                    first = false;
                    currentClass = item.getClass();
                }
                String name = null;
                if (tr != null && tr.getFromObjectTransformer() != null && tr.getFromObjectTransformer() instanceof XMLObjToStringBuilderTransformer) {
                    XMLObjToStringBuilderTransformer xmltr = (XMLObjToStringBuilderTransformer)tr.getFromObjectTransformer();
                    name = xmltr.transformFromObject(item, cold.itemXmlName, sb, processExternals, skipClassName);
                }
                if (name == null) continue;
                this.addConnectorPoints(sb, item);
                this.addCloseTag(name, sb);
            }
        }
        if (mapItem) {
            for (Object item : col) {
                if (!(item instanceof Map)) continue;
                mapItem = true;
                Map map = (Map)item;
                if (map.entrySet().size() <= 0) continue;
                this.addOpenTag(cold.itemXmlName, sb);
                for (Map.Entry entry : map.entrySet()) {
                    Object value = entry.getValue();
                    Object key = entry.getKey();
                    if (value == null || key == null || !(value instanceof String) || !(key instanceof String)) continue;
                    this.addAttribute(StringUtilities.encodeAttributeValue((String)key), StringUtilities.encodeAttributeValue((String)value), sb);
                }
                sb.append("/>");
            }
        }
        this.addCloseTag(cold.xmlName, sb);
    }

    private void processTopView(Element element, Object item) {
        TopView tv;
        DesignObject designObject;
        if (item instanceof TopView && (designObject = (tv = (TopView)item).getModel()) != null) {
            TVConnector tvc;
            ConnectionInterface ci;
            element.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
            if (designObject instanceof DiagramView) {
                DiagramView dv = (DiagramView)designObject;
                element.setAttribute("dpv_id", StringUtilities.encodeAttributeValue(dv.getDpvID()));
            } else {
                element.setAttribute("otype", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
            }
            if (tv instanceof ContainerView) {
                element.setAttribute("vid", StringUtilities.encodeAttributeValue(tv.getViewID()));
                if (tv.getViewNumber() != 0) {
                    element.setAttribute("vnum", String.valueOf(tv.getViewNumber()));
                }
            } else if (tv instanceof TVConnector && (ci = (ConnectionInterface)((Object)(tvc = (TVConnector)tv).getModel())).getSourceObject() != null && ci.getTargetObject() != null && tvc.getSourceTopView() != null && tvc.getTargetTopView() != null) {
                element.setAttribute("vid_source", StringUtilities.encodeAttributeValue(tvc.getSourceTopView().getViewID()));
                element.setAttribute("vid_target", StringUtilities.encodeAttributeValue(tvc.getTargetTopView().getViewID()));
            }
        }
    }

    private void addConnectorPoints(StringBuilder sb, Object item) {
        if (item instanceof TVConnector) {
            TVConnector tvc = (TVConnector)item;
            this.addCollectionOfPoints(sb, "points", tvc.getActualPoints());
        }
    }

    private void addTopViewAttributes(StringBuilder sb, Object item) {
        TopView tv;
        DesignObject designObject;
        if (item instanceof TopView && (designObject = (tv = (TopView)item).getModel()) != null) {
            TVConnector tvc;
            ConnectionInterface ci;
            this.addAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()), sb);
            if (designObject instanceof DiagramView) {
                DiagramView dv = (DiagramView)designObject;
                this.addAttribute("dpv_id", StringUtilities.encodeAttributeValue(dv.getDpvID()), sb);
            } else {
                this.addAttribute("otype", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()), sb);
            }
            if (designObject instanceof ImageObject) {
                this.addAttribute("imageFileName", StringUtilities.encodeAttributeValue(((ImageObject)designObject).getImageFileName()), sb);
            }
            if (tv instanceof ContainerView) {
                this.addAttribute("vid", StringUtilities.encodeAttributeValue(tv.getViewID()), sb);
                if (tv.getViewNumber() != 0) {
                    this.addAttribute("vnum", String.valueOf(tv.getViewNumber()), sb);
                }
            } else if (tv instanceof TVConnector && (ci = (ConnectionInterface)((Object)(tvc = (TVConnector)tv).getModel())).getSourceObject() != null && ci.getTargetObject() != null && tvc.getSourceTopView() != null && tvc.getTargetTopView() != null) {
                this.addAttribute("vid_source", StringUtilities.encodeAttributeValue(tvc.getSourceTopView().getViewID()), sb);
                this.addAttribute("vid_target", StringUtilities.encodeAttributeValue(tvc.getTargetTopView().getViewID()), sb);
            }
        }
    }

    private void appendBounds(StringBuilder sb, String elemName, Rectangle bounds) {
        this.addOpenTag(elemName, sb);
        this.addAttribute("x", String.valueOf(bounds.x), sb);
        this.addAttribute("y", String.valueOf(bounds.y), sb);
        this.addAttribute("width", String.valueOf(bounds.width), sb);
        this.addAttribute("height", String.valueOf(bounds.height), sb);
        sb.append("/>");
    }

    private void addCollectionOfPoints(StringBuilder sb, String elemName, Collection points) {
        if (points.size() > 0) {
            this.addOpenTag(elemName, sb);
            sb.append('>');
            for (Object obj : points) {
                if (!(obj instanceof Point2D)) continue;
                this.addOpenTag("point", sb);
                Point2D p = (Point2D)obj;
                this.addAttribute("x", String.valueOf((int)p.getX()), sb);
                this.addAttribute("y", String.valueOf((int)p.getY()), sb);
                sb.append("/>");
            }
            this.addCloseTag(elemName, sb);
        }
    }

    @Override
    public String transformFromObjectToString(Object object, List excludeProps) {
        return this.transformFromObjectToString(object, false);
    }

    public String transformFromObjectToString(Object object, boolean processExternals) {
        StringBuilder doc = this.transformFromObject(object, processExternals);
        return doc.toString();
    }
}

