/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.SegmentNameManager;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ReadRequest;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageSet;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubject;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubjectImpl;
import oracle.dbtools.crest.swingui.ApplicationView;

public class RelationalObjectProxySet
extends ModelObject
implements SetListener,
UpdateSubject,
StorageSet,
ElementSet {
    private Map idMap = new TreeMap();
    protected Map undoRecycleMap = new TreeMap();
    private UpdateSubjectImpl updateDelegate = new UpdateSubjectImpl();
    private StorageDesign storageDesign;
    protected List elements = new ArrayList();
    private Set listeners = new HashSet();
    private SegmentNameManager segManager = new SegmentNameManager();
    private Boolean containsTopLevelStorableObjects = null;
    private Map longNameMap;
    protected String _map = "_map";

    public RelationalObjectProxySet(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public void doAfterAdd(RelationalObjectProxy addedProxy) {
    }

    @Override
    public ModelIDObject getObjectGeneratedBy(String generatorID) {
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            RelationalObjectProxy object = (RelationalObjectProxy)it.next();
            if (!generatorID.equals(object.getObject().getObjectID())) continue;
            it = null;
            return object;
        }
        it = null;
        return null;
    }

    @Override
    public ModelIDObject getObjectGeneratedBy(DesignObject object) {
        return this.getObjectGeneratedBy(object.getObjectID());
    }

    @Override
    public Collection getObjectsGeneratedBy(String generatorId, Collection collection) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            StorageObject object = (StorageObject)it.next();
            if (!generatorId.equals(object.getGeneratorID())) continue;
            collection.add(object);
        }
        return collection;
    }

    public void add(DesignObject object) {
        if (!this.isBackupObject(object)) {
            String id = object.getObjectID();
            RelationalObjectProxy proxy = this.getProxy(id);
            if (proxy == null && (proxy = this.restoreProxyFromRecycleMap(object)) != null) {
                this.add(proxy);
                this.fireUpdate();
                return;
            }
            if (proxy != null) {
                if (!proxy.isLoaded()) {
                    proxy.loadDesignObject();
                }
            } else {
                proxy = this.createProxy(object);
                this.add(proxy);
                this.fireUpdate();
            }
        }
    }

    protected boolean isBackupObject(DesignObject object) {
        return object.isBackup();
    }

    @Override
    public void sort() {
        Collections.sort(this.elements, ModelObjectSet.NAME_COMPARATOR);
    }

    public void remove(ModelIDObject object) {
        this.remove(object.getObjectID());
    }

    public void remove(String id) {
        ModelIDObject object = (ModelIDObject)this.idMap.remove(id);
        if (object != null) {
            int childIndex = this.elements.indexOf(object);
            this.elements.remove(object);
            if (this.getStorageDesign() != null && object != null) {
                this.getStorageDesign().unregisterModelIDObject(object);
            }
            Map map = null;
            try {
                if (!this.getDesign().getAppView().isImporting()) {
                    map = this.getAppView().getXMLTransformationManager().transformFromObjectToMap(object, null, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            object.remove();
            if (this.getStorageDesign().isOpen() && map != null) {
                this.undoRecycleMap.put(id, object);
                if (map != null) {
                    this.undoRecycleMap.put(id + this._map, map);
                }
            }
            this.fireUpdate();
            this.fireRemoved(object, childIndex);
        }
    }

    public void updateProxyID(String oldID, String newID) {
        ModelIDObject object = (ModelIDObject)this.idMap.remove(oldID);
        if (object != null) {
            this.idMap.put(newID, object);
        }
    }

    public void add(String id, String longName) {
        if (!this.idMap.containsKey(id)) {
            RelationalObjectProxy proxy = this.createProxy(this.getDesign(), id, longName);
            this.add(proxy);
        }
    }

    public void addSetListener(RelationalObjectProxySetListener listener) {
        this.listeners.add(listener);
    }

    public void removeSetListener(RelationalObjectProxySetListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireAdded(ModelObject affected, int childIndex) {
        this.fireChange(affected, 1, childIndex);
    }

    protected void fireRemoved(ModelObject affected, int childIndex) {
        this.fireChange(affected, 0, childIndex);
    }

    protected void fireChange(ModelObject affected, int type, int childIndex) {
        Iterator it = this.listeners.iterator();
        ModelObjectSetEvent event = new ModelObjectSetEvent(affected, type);
        event.childIndex = childIndex;
        while (it.hasNext()) {
            ((RelationalObjectProxySetListener)it.next()).changed(this, event);
        }
    }

    public void createReadRequest(RelationalObjectProxy proxy) {
        if (this.shouldCreateRequest(proxy)) {
            ReadRequest readRequest = this.getStorageDesign().getReadRequestFor(proxy.getObjectID());
            readRequest.setObjectSet(this);
            readRequest.setStorageObject(proxy);
        }
    }

    public void reloadExistingData(RelationalObjectProxy proxy) {
        ReadRequest readRequest = this.getStorageDesign().getReadRequestFor(proxy.getObjectID());
        readRequest.setObjectSet(this);
        readRequest.setStorageObject(proxy);
        this.getDesign().getAppView().getPersistenceManager().read((Object)readRequest, this.getDesign(), true);
    }

    private boolean shouldCreateRequest(RelationalObjectProxy proxy) {
        DesignObject object = proxy.getObject();
        return !(object instanceof Column) && !(object instanceof Index) && !(object instanceof FKIndexAssociation);
    }

    protected RelationalObjectProxy createProxy(DesignObject object) {
        return new RelationalObjectProxy(object, this.getStorageDesign());
    }

    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        return new RelationalObjectProxy(design, id, longName, this.getStorageDesign());
    }

    public void add(RelationalObjectProxy proxy) {
        this.idMap.put(proxy.getObjectID(), proxy);
        this.elements.add(proxy);
        int childIndex = this.elements.size() - 1;
        proxy.setParent(this);
        proxy.setProxySet(this);
        if (this.getStorageDesign() != null) {
            this.getStorageDesign().registerModelIDObject(proxy);
            try {
                this.createReadRequest(proxy);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.doAfterAdd(proxy);
        }
        this.fireUpdate();
        this.fireAdded(proxy, childIndex);
    }

    public void justAdd(RelationalObjectProxy proxy) {
        this.idMap.put(proxy.getObjectID(), proxy);
        this.elements.add(proxy);
        int childIndex = this.elements.indexOf(proxy);
        proxy.setParent(this);
        this.fireAdded(proxy, childIndex);
    }

    public RelationalObjectProxy getProxy(String id) {
        return (RelationalObjectProxy)this.idMap.get(id);
    }

    public Collection getObjectCollection() {
        return this.idMap.values();
    }

    @Override
    public int size() {
        return this.idMap.size();
    }

    public List getObjectList() {
        ArrayList list = new ArrayList();
        list.addAll(this.getObjectCollection());
        return list;
    }

    public boolean containsId(String id) {
        return this.idMap.containsKey(id);
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (event.getAffected() != null) {
            if (event.isAdded()) {
                this.add(event.getAffected());
            } else if (event.isRemoved()) {
                this.remove(event.getAffected());
            }
        }
    }

    @Override
    public void addUpdateListener(UpdateListener listener) {
        this.updateDelegate.addUpdateListener(listener);
    }

    @Override
    public void removeUpdateListener(UpdateListener listener) {
        this.updateDelegate.removeUpdateListener(listener);
    }

    public void fireUpdate() {
        this.updateDelegate.fireChange();
    }

    public void dumpContents(PrintStream out) {
        Iterator it = this.idMap.keySet().iterator();
        out.println("PhysicalObjectProxy.dumpContents(): -------------------------");
        while (it.hasNext()) {
            String id = (String)it.next();
            RelationalObjectProxy proxy = this.getProxy(id);
            out.print("--");
            out.print(proxy.getLongName());
            out.print("\t");
            out.print(proxy.getObjectID());
            out.print("\tloaded: ");
            out.println(proxy.isLoaded());
        }
        out.println("end PhysicalObjectProxy.dumpContents() ----------------------");
    }

    public RelationalObjectProxy[] toProxyArray() {
        return (RelationalObjectProxy[])this.getObjectCollection().toArray(this.getElementsPrototype());
    }

    @Override
    public Object[] toArray() {
        return this.toProxyArray();
    }

    protected Object[] getElementsPrototype() {
        return new RelationalObjectProxy[0];
    }

    @Override
    public boolean containsSiteStorageObjects() {
        return false;
    }

    @Override
    public boolean containsDesignStorageObjects() {
        return !this.containsSiteStorageObjects();
    }

    @Override
    public boolean contains(ModelObject object) {
        return object instanceof RelationalObjectProxy && this.idMap.containsValue(object);
    }

    @Override
    public Iterator iterator() {
        return Collections.unmodifiableCollection(this.elements).iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.idMap.isEmpty();
    }

    public void clearAll() {
        Object[] objects = this.elements.toArray();
        for (int i = 0; i < objects.length; ++i) {
            this.remove((ModelIDObject)objects[i]);
        }
        this.idMap.clear();
        this.undoRecycleMap.clear();
        this.elements.clear();
        this.unregisterFromDesignObjectSet();
    }

    protected void unregisterFromDesignObjectSet() {
    }

    @Override
    public int getNumberOfChildren() {
        return this.elements.size();
    }

    @Override
    public ModelObject getChild(int index) {
        return (ModelObject)this.elements.get(index);
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        return this.elements.indexOf(child);
    }

    @Override
    public int getIndexForChild(Object child) {
        return this.elements.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return this.elements.size() == 0;
    }

    public List getElements() {
        return this.elements;
    }

    public String getSegmentName(ModelIDObject object) {
        if (this.isContainsTopLevelStorableObjects()) {
            return this.segManager.getSegmentName(object);
        }
        return "";
    }

    public String getSegmentName(String id) {
        if (this.isContainsTopLevelStorableObjects()) {
            return this.segManager.getSegmentName(id);
        }
        return "";
    }

    public void addSegmentEntry(String segment, String id) {
        this.addSegmentEntry(segment, id, false);
    }

    public void addSegmentEntry(String segment, String id, boolean clear) {
        if (this.isContainsTopLevelStorableObjects()) {
            if (clear) {
                this.segManager.removeID(id);
            }
            this.segManager.add(segment, id);
        }
    }

    public boolean isContainsTopLevelStorableObjects() {
        if (this.containsTopLevelStorableObjects == null) {
            this.containsTopLevelStorableObjects = this.getStorageDesign().getStorableSetsList().contains(this) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.containsTopLevelStorableObjects;
    }

    @Override
    public ModelObject getByName(String name) {
        if (name != null) {
            String trimedName = name.trim();
            for (ModelObject mo : this.elements) {
                if (mo.getName() == null || !mo.getName().trim().equalsIgnoreCase(trimedName)) continue;
                return mo;
            }
        }
        return null;
    }

    @Override
    public ModelIDObject getObjectByID(String objectID) {
        return this.getProxy(objectID);
    }

    @Override
    public void addAllElementsTo(Collection collection) {
        collection.addAll(this.elements);
    }

    @Override
    public boolean canSort() {
        return this.getStorageDesign() != null && !this.getStorageDesign().isLoading() && ApplicationView.canLogging;
    }

    public void refreshLongNameMap() {
        Map map = this.getLongNameMap();
        map.clear();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ModelIDObject obj = (ModelIDObject)it.next();
            String lname = obj.getLongName();
            map.put(lname.toUpperCase(), obj);
        }
    }

    public Map getLongNameMap() {
        if (this.longNameMap == null) {
            this.longNameMap = new HashMap(10000);
        }
        return this.longNameMap;
    }

    public ModelIDObject getObjectFromLongNameMap(String longName) {
        return (ModelIDObject)this.getLongNameMap().get(longName.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationalObjectProxy restoreProxyFromRecycleMap(DesignObject object) {
        RelationalObjectProxy proxy = null;
        if (this.getStorageDesign().isOpen()) {
            String id = object.getObjectID();
            proxy = (RelationalObjectProxy)this.undoRecycleMap.get(id);
            if (proxy != null) {
                proxy.setObject(object);
                Map map = (Map)this.undoRecycleMap.get(id + this._map);
                if (map != null) {
                    this.getAppView().getXMLTransformationManager().transformFromMapToObject(proxy, map);
                    if (!this.getStorageDesign().existsInFilesMap(id)) {
                        proxy.setRestoredFromSavedDelete(true);
                    }
                }
                proxy.setObject(object);
            } else {
                StorageDesign sd = this.getStorageDesign();
                XMLTransformationManager.ObjectHelper oh = sd.getNotLoadedObjectHelpersMap().get(id);
                if (oh != null && oh.file != null && oh.file.exists()) {
                    try {
                        this.getStorageDesign().setLoading(true);
                        proxy = this.createProxy(object);
                        this.getAppView().getXMLTransformationManager().transformFromXMLToObject(proxy, oh.file, this.getDesign().isCompressedDesign(), false, null);
                        proxy.setDirectorySegmentName(oh.seq_name, true);
                        proxy.setDirty(true);
                        String storageName = proxy.getSegmentedStorageName();
                        sd.addToFilesMap(id, storageName);
                        sd.setObjectListChanged(true);
                    }
                    finally {
                        this.getStorageDesign().setLoading(false);
                    }
                }
            }
        }
        return proxy;
    }
}

