/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;

public class Oracle_CSV_CTLFileGenerator {
    private RelationalDesign phdes;
    private String directory = "d:/rep_load_ctl/";
    private String filemap = "";
    private Map tableMap = new TreeMap();
    private String dataDir = "e:/CSVFiles_Test/";
    private char delimiter = (char)59;
    int typePos = 45;
    int positionPos = 22;
    int current_length = 0;
    List sortedTables = new ArrayList();
    List tracedTables = new ArrayList();
    boolean cyclicRef = false;

    public Oracle_CSV_CTLFileGenerator(RelationalDesign phdes) {
        this.phdes = phdes;
        RDBMSSite site = phdes.getDesign().getFirstOfType(StorageDesignDB2v80.RDBMS_TYPE);
        phdes.setSelectedRDBMSSite(site);
    }

    public Oracle_CSV_CTLFileGenerator(RelationalDesign phdes, String ctlDir, String dataDir, String fileMapFile, char delimiter) {
        this.phdes = phdes;
        RDBMSSite site = phdes.getDesign().getFirstOfType(StorageDesignDB2v80.RDBMS_TYPE);
        phdes.setSelectedRDBMSSite(site);
        phdes.getStorageDesign(site);
        this.directory = ctlDir;
        this.dataDir = dataDir;
        this.filemap = fileMapFile;
        this.delimiter = delimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFileMap(String fileName) throws IOException {
        this.tableMap.clear();
        if (fileName == null || "".equals(fileName)) {
            return;
        }
        File file = new File(fileName);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(MessageFormat.format(Messages.getString("Oracle_CSV_CTLFileGenerator.FileCanNotBeCreated"), fileName));
        }
        try (BufferedReader fin = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line = null;
            while ((line = fin.readLine()) != null) {
                int k;
                int ind;
                int l = line.length();
                if (line.charAt(l - 1) == this.delimiter) {
                    line = line.substring(0, l - 1);
                }
                if ((ind = line.indexOf(this.delimiter)) <= 0) continue;
                String tablename = line.substring(0, ind);
                String filename = line.substring(ind + 1);
                if (filename.charAt(0) == '\'') {
                    filename = filename.substring(1);
                }
                if (filename.charAt((k = filename.length()) - 1) == '\'') {
                    filename = filename.substring(0, k - 1);
                }
                this.tableMap.put(tablename.toUpperCase(), filename);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToFile(String fileName, Table table) throws IOException {
        File file = new File(fileName);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(Messages.getString("Oracle_CSV_CTLFileGenerator.FileCanNotBeCreated") + fileName + " cannot be created");
        }
        Writer fout = null;
        try {
            fout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            StringBuffer sb = new StringBuffer();
            StringBuffer columnSB = new StringBuffer();
            int recSize = this.createColumnPart(table, columnSB);
            this.addFixedPart(sb, table.getName().toUpperCase(), table, recSize);
            sb.append(columnSB);
            fout.write(sb.toString());
        }
        catch (FileNotFoundException e) {
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private int createColumnPart(Table table, StringBuffer sb) {
        int pos = 1;
        Column[] cols = (Column[])table.getElements();
        int lastCol = cols.length - 1;
        String row = "";
        sb.append("(\n");
        for (int i = 0; i < cols.length; ++i) {
            Column col = cols[i];
            row = col.getName().toUpperCase();
            String dataType = col.getDatatypeString("Oracle Database 10g");
            int ind = dataType.indexOf(40);
            if (ind > -1) {
                dataType = dataType.substring(0, ind).trim();
            }
            String size = col.getSize();
            String precision = col.getPrecision();
            String scale = col.getScale();
            String dt = this.makeDatatype(dataType, size, precision, scale);
            row = this.addWithSpacesAtPos(row, this.typePos, dt);
            pos += this.current_length;
            if (i != lastCol) {
                row = row + ",";
            }
            row = row + "\n";
            sb.append(row);
        }
        sb.append(")\n");
        return pos - 1;
    }

    private String makeDatatype(String type, String size, String precision, String scale) {
        String result = "";
        if (type.equalsIgnoreCase("VARCHAR2")) {
            this.current_length = Integer.valueOf(size) + 2;
            result = "CHAR(" + size + ")";
        } else if (type.equalsIgnoreCase("SMALLINT")) {
            this.current_length = 2;
            result = "INTEGER(" + String.valueOf(2) + ")";
        } else if (type.equalsIgnoreCase("INTEGER")) {
            this.current_length = 4;
            result = "INTEGER(" + String.valueOf(4) + ")";
        } else if (type.equalsIgnoreCase("DECIMAL") || type.equalsIgnoreCase("NUMBER")) {
            result = "DECIMAL EXTERNAL";
        } else if (type.equalsIgnoreCase("CHAR")) {
            this.current_length = Integer.valueOf(size);
            result = "CHAR(" + size + ")";
        } else if (type.equalsIgnoreCase("DATE")) {
            this.current_length = 10;
            result = "DATE EXTERNAL(10) \"YYYY-MM-DD\"";
        } else if (type.equalsIgnoreCase("TIME")) {
            this.current_length = 8;
            result = "DATE EXTERNAL(8) \"HH24.MI.SS\"";
        } else if (type.equalsIgnoreCase("TIMESTAMP")) {
            this.current_length = 26;
            result = "TIMESTAMP \"YYYY-MM-DD-HH24.MI.SS.FF6 \"";
        }
        return result;
    }

    private void addFixedPart(StringBuffer sb, String tableName, Table table, int recSize) {
        sb.append("OPTIONS(SILENT=(FEEDBACK),DIRECT=YES,SKIP=1)\n");
        sb.append("LOAD DATA \n");
        String filename = (String)this.tableMap.get(tableName);
        filename = filename != null ? (filename.charAt(0) == '\'' ? "''" + new File(this.dataDir, filename).getAbsolutePath() + ".csv''" : "'" + new File(this.dataDir, filename).getAbsolutePath() + ".csv'") : "'" + new File(this.dataDir, tableName).getAbsolutePath() + ".csv'";
        sb.append("INFILE ").append(filename).append(" \n");
        sb.append("BADFILE ").append(tableName).append(".bad\n");
        sb.append("DISCARDFILE ").append(tableName).append(".dis\n");
        sb.append("INTO TABLE ").append(tableName).append("\n");
        sb.append("FIELDS TERMINATED BY \",\" OPTIONALLY ENCLOSED BY '\"'\n");
    }

    private String addWithSpacesAtPos(String result, int pos, String addition) {
        int k;
        for (int i = k = result.length() - 1; i < pos; ++i) {
            result = result + ' ';
        }
        result = result + addition;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFiles() {
        File dir = new File(this.directory, this.phdes.getName());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.directory = dir.getAbsolutePath();
        this.sortedTables.clear();
        this.phdes.getTableSet().addAllElementsTo(this.sortedTables);
        try {
            this.loadFileMap(this.filemap);
        }
        catch (IOException e1) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Rem Usage:\n");
        sb.append("Rem sqlplus scott/tiger@ora102db @load_all.sql scott tiger\n\n\n");
        sb.append("DEFINE user_ = &1\n");
        sb.append("DEFINE pass = &2\n\n\n");
        for (int i = 0; i < this.sortedTables.size(); ++i) {
            Table table = (Table)this.sortedTables.get(i);
            String fname = table.getName().toUpperCase() + ".ctl";
            String fileName = new File(this.directory, fname).getAbsolutePath();
            try {
                this.exportToFile(fileName, table);
                sb.append("prompt\n");
                sb.append("prompt loading " + table.getName().toUpperCase() + " \n\n");
                sb.append("HOST sqlldr &user_/&pass - \n   silent=(HEADER,FEEDBACK) - \n   control=" + fileName + " \n");
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        sb.append("prompt\n");
        sb.append("prompt end loading \n");
        sb.append("exit \n");
        String fileName = new File(this.directory, "load_all.sql").getAbsolutePath();
        File file = new File(fileName);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(Messages.getString("Oracle_CSV_CTLFileGenerator.FileCanNotBeCreated") + fileName + " cannot be created");
        }
        Writer fout = null;
        try {
            fout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            fout.write(sb.toString());
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void main(String[] args) {
    }
}

