/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryStatistics;
import com.adbs.querybuilder.StatisticsColumn;
import com.adbs.querybuilder.StatisticsDatabaseObject;
import com.adbs.querybuilder.StatisticsOutputColumn;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public abstract class FKContainer
extends ContainerWithKeyObject {
    protected List arcs;
    private static final int ARC_SIZE_INDEX = 20;
    protected List<FKIndexAssociation> fkList = new ArrayList<FKIndexAssociation>();

    public FKContainer(DesignPart designPart) {
        super(designPart);
        this.arcs = new ArrayList();
    }

    public abstract String getAbbreviation();

    public abstract RelationalDesign getRelationalModel();

    public abstract List getCheckConstraints();

    public abstract FKElement getFKColumn(FKIndexAssociation var1, FKElement var2);

    public abstract FKElement getColumnForDelegate(FKIndexAssociation var1, FKElement var2);

    public abstract FKElement createColumnFK(FKElement var1, FKIndexAssociation var2);

    public abstract Column createRefToStructuredType(StructuredType var1, FKIndexAssociation var2);

    public abstract List<FKIndexAssociation> getFKAssociationsList();

    public abstract void addRecreateFKAssociation(FKIndexAssociation var1);

    public abstract void restoreFKAssociation(FKIndexAssociation var1, String var2);

    public abstract FKIndexAssociation[] getFKAssociations();

    public abstract KeyObject createIndexFK(FKIndexAssociation var1);

    public abstract FKElement[] getAllFKColumns(FKIndexAssociation var1);

    public abstract void removeFKAssociationFromList(FKIndexAssociation var1);

    public abstract List getColumnsDependinOn(FKIndexAssociation var1);

    public abstract KeyObject getIndexByID(String var1);

    public abstract List getPK_UKList();

    public abstract FKIndexAssociation addFK(KeyObject var1);

    public abstract List getPKandUKConstraints();

    public abstract FKIndexAssociation addForeignKey(KeyObject var1, List var2);

    public void addArc(FKArc arc) {
        if (!this.arcExists(arc)) {
            this.arcs.add(arc);
            arc.setTable(this);
            arc.addObjectListener(this);
            this.updateArcSizeIndexes();
        }
    }

    public boolean arcExists(FKArc arc) {
        if (this.arcs.contains(arc)) {
            return true;
        }
        for (FKArc next : this.arcs) {
            if (next.getFkeys().size() <= 0 || next.getFkeys().size() != arc.getFkeys().size() || !next.getFkeys().containsAll(arc.getFkeys())) continue;
            return true;
        }
        return false;
    }

    public boolean arcExists(List fkeys) {
        for (FKArc next : this.arcs) {
            if (!next.getFkeys().containsAll(fkeys)) continue;
            return true;
        }
        return false;
    }

    public void removeArc(FKArc arc) {
        this.arcs.remove(arc);
        arc.removeObjectListener(this);
        this.updateArcSizeIndexes();
    }

    public void deleteAllArcs() {
        Object[] allArcs = this.arcs.toArray();
        for (int i = allArcs.length - 1; i >= 0; --i) {
            FKArc arc = (FKArc)allArcs[i];
            arc.remove();
        }
    }

    public List getArcs() {
        return this.arcs;
    }

    public void clearArcs() {
        this.arcs.clear();
    }

    private void updateArcSizeIndexes() {
        Object[] allArcs = this.arcs.toArray();
        for (int i = 0; i < allArcs.length; ++i) {
            FKArc arc = (FKArc)allArcs[i];
            arc.setSizeIndex((i + 1) * 20);
        }
    }

    public boolean inArc(FKIndexAssociation fkey) {
        for (FKArc next : this.arcs) {
            if (!next.containsFKey(fkey)) continue;
            return true;
        }
        return false;
    }

    public void showArcs(boolean show) {
        for (FKArc next : this.arcs) {
            next.setVisible(show);
            if (show) {
                this.getDesignPart().getMainView().getWorkSpace().addFKArc(next, new Rectangle());
                continue;
            }
            this.getDesignPart().getMainView().getWorkSpace().removeFKArc(next);
        }
    }

    public List getAllFKeysEndingToTable() {
        return ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().getFKeysEndingTo(this);
    }

    public String createFKColumnName(FKElement referencedColumn) {
        NamingStandardRule nsr = this.getDesign().getNamingStandardRule();
        String fkColName = ApplyNamingStandards.createFKColumnName(referencedColumn, null, nsr, this);
        return fkColName;
    }

    public FKElement getEquivelentColumn(FKElement extColumn, String name, boolean inOneFKOnly) {
        for (FKElement column : this.getElementsCollection()) {
            if (column == extColumn || column.isFKColumn() && inOneFKOnly || (name == null || "".equals(name) ? !extColumn.getName().equalsIgnoreCase(column.getName()) : !name.equalsIgnoreCase(column.getName()))) continue;
            if ((this.getAppView().getSettings().isAllowSimilarTypesFK() || !column.hasEqulaDataType(extColumn)) && (!this.getAppView().getSettings().isAllowSimilarTypesFK() || !column.hasSimilarDataType(extColumn)) || column.isReferingTo(extColumn)) continue;
            return column;
        }
        return null;
    }

    public abstract String getUserDefinedSQL();

    public abstract void setUserDefinedSQL(String var1);

    public abstract String getLayoutSQL();

    public abstract List getSQLNames();

    public List getDeletedSQLNames() {
        ArrayList<SQLNameHelper> deletedSQLNames = new ArrayList<SQLNameHelper>();
        for (SQLNameHelper helper : this.getSQLNames()) {
            DesignObject desObj = this.getDesign().getDesignObject(helper.getID());
            if (desObj != null) continue;
            deletedSQLNames.add(helper);
        }
        return deletedSQLNames;
    }

    public abstract boolean isValidSQL();

    public abstract void setValidSQL(boolean var1);

    public abstract boolean isParsed();

    public abstract void setParsed(boolean var1);

    public abstract boolean isIncorrectSQL();

    public abstract void setIncorrectSQL(boolean var1);

    public abstract String getSyntaxProvider();

    public abstract void setSyntaxProvider(String var1);

    public boolean sqlNameExists(String id) {
        for (SQLNameHelper helper : this.getSQLNames()) {
            if (!helper.getID().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    protected void addToSQLNames(String schema, String containerName, String columnName) {
        boolean isView = false;
        DesignObject desObj = null;
        if (this.getDesignPart() instanceof RelationalDesign) {
            desObj = schema != null ? ((RelationalDesign)this.getDesignPart()).getTableSet().getByLongName(schema + "." + containerName) : ((RelationalDesign)this.getDesignPart()).getTableSet().getByName(containerName);
            if (desObj == null) {
                desObj = schema != null ? ((RelationalDesign)this.getDesignPart()).getTableViewSet().getByLongName(schema + "." + containerName) : ((RelationalDesign)this.getDesignPart()).getTableViewSet().getByName(containerName);
                isView = true;
            }
        } else if (this.getDesignPart() instanceof LogicalDesign && (desObj = schema != null ? ((LogicalDesign)this.getDesignPart()).getEntitySet().getByLongName(schema + "." + containerName) : ((LogicalDesign)this.getDesignPart()).getEntitySet().getByName(containerName)) == null) {
            desObj = schema != null ? ((LogicalDesign)this.getDesignPart()).getEntityViewSet().getByLongName(schema + "." + containerName) : ((LogicalDesign)this.getDesignPart()).getEntityViewSet().getByName(containerName);
            isView = true;
        }
        if (desObj != null) {
            if (columnName != null) {
                ContainedObject column = ((ContainerObject)desObj).getElementByName(columnName);
                if (column != null) {
                    if (!this.sqlNameExists(column.getObjectID())) {
                        SQLNameHelper helper = new SQLNameHelper(false, false);
                        helper.setID(column.getObjectID());
                        helper.setSchema(schema);
                        helper.setTableName(containerName);
                        helper.setColumnName(columnName);
                        this.getSQLNames().add(helper);
                    }
                    column.addObjectListener(this);
                }
            } else {
                if (!this.sqlNameExists(desObj.getObjectID())) {
                    SQLNameHelper helper = new SQLNameHelper(true, isView);
                    helper.setID(desObj.getObjectID());
                    helper.setSchema(schema);
                    helper.setTableName(containerName);
                    helper.setDeprecated(desObj.isDeprecated());
                    this.getSQLNames().add(helper);
                }
                desObj.addObjectListener(this);
            }
        }
    }

    public DesignObject addToSQLNames(String schema, String containerName, String columnName, Map relModelContainers) {
        boolean isView = false;
        DesignObject desObj = null;
        if (schema != null && !schema.isEmpty() && containerName != null) {
            desObj = (DesignObject)relModelContainers.get(schema + "." + containerName);
        } else if (containerName != null) {
            desObj = (DesignObject)relModelContainers.get(containerName);
        }
        if (desObj != null) {
            isView = desObj instanceof TableView;
            if (columnName != null) {
                ContainedObject column = ((ContainerObject)desObj).getElementByName(columnName);
                if (column != null) {
                    if (!this.sqlNameExists(column.getObjectID())) {
                        SQLNameHelper helper = new SQLNameHelper(false, false);
                        helper.setID(column.getObjectID());
                        helper.setSchema(schema);
                        helper.setTableName(containerName);
                        helper.setColumnName(columnName);
                        this.getSQLNames().add(helper);
                    }
                    column.addObjectListener(this);
                }
                return column;
            }
            if (!this.sqlNameExists(desObj.getObjectID())) {
                SQLNameHelper helper = new SQLNameHelper(true, isView);
                helper.setID(desObj.getObjectID());
                helper.setSchema(schema);
                helper.setTableName(containerName);
                helper.setDeprecated(desObj.isDeprecated());
                this.getSQLNames().add(helper);
            }
            desObj.addObjectListener(this);
        }
        return desObj;
    }

    public boolean isSQLNamesChanged() {
        for (SQLNameHelper helper : this.getSQLNames()) {
            DesignObject desObj = this.getDesign().getDesignObject(helper.getID());
            if (desObj != null) {
                String oldName = helper.isContainer() ? helper.getTableName() : helper.getColumnName();
                if (!desObj.getName().equalsIgnoreCase(oldName)) {
                    return true;
                }
                if (!helper.isContainer() || !(desObj instanceof ContainerObject)) continue;
                SchemaObject schema = ((ContainerObject)desObj).getSchemaObject();
                String schemaName = null;
                if (schema != null) {
                    schemaName = schema.getName();
                }
                if (!(helper.getSchema() != null && schemaName != null ? !helper.getSchema().equalsIgnoreCase(schemaName) : helper.getSchema() != schemaName)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public void updateSQLNames(QueryBuilder queryBuilder) {
        String schema;
        String colName;
        String tbName;
        int i;
        this.getSQLNames().clear();
        QueryStatistics qs = queryBuilder.getQueryStatistics();
        for (i = 0; i < qs.getUsedDatabaseObjects().getCount(); ++i) {
            StatisticsDatabaseObject sdb = qs.getUsedDatabaseObjects().get(i);
            if (sdb.getMetadataObject() == null) continue;
            tbName = sdb.getMetadataObject().getNameStrNotQuoted();
            String schema2 = sdb.getMetadataObject().getSchemaStrNotQuoted();
            if (schema2 != null && schema2.length() > 0) {
                this.addToSQLNames(schema2, tbName, null);
                continue;
            }
            this.addToSQLNames(null, tbName, null);
        }
        for (i = 0; i < qs.getUsedDatabaseObjectColumns().getCount(); ++i) {
            StatisticsColumn sc = qs.getUsedDatabaseObjectColumns().get(i);
            if (sc.getMetadataObject() == null || sc.getMetadataField().getAltName() == null) continue;
            tbName = sc.getMetadataObject().getNameStrNotQuoted();
            colName = sc.getMetadataField().getNameStrNotQuoted();
            schema = sc.getMetadataObject().getSchemaStrNotQuoted();
            if (schema != null && schema.length() > 0) {
                this.addToSQLNames(schema, tbName, colName);
                continue;
            }
            this.addToSQLNames(null, tbName, colName);
        }
        for (i = 0; i < qs.getOutputColumns().getCount(); ++i) {
            StatisticsOutputColumn soc = qs.getOutputColumns().get(i);
            if (soc.getMetadataObject() == null || soc.getMetadataField() == null) continue;
            tbName = soc.getMetadataObject().getNameStrNotQuoted();
            colName = soc.getMetadataField().getNameStrNotQuoted();
            schema = soc.getMetadataObject().getSchemaStrNotQuoted();
            if (schema != null && schema.length() > 0) {
                this.addToSQLNames(schema, tbName, colName);
                continue;
            }
            this.addToSQLNames(null, tbName, colName);
        }
    }

    public FKIndexAssociation getFKIndexAssociationByName(String fkName) {
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk;
            KeyObject ind = (KeyObject)it.next();
            if (!ind.isFK() || !(fk = ind.getFKAssociation()).getName().equalsIgnoreCase(fkName)) continue;
            return fk;
        }
        return null;
    }

    public List<FKIndexAssociation> copyForeignKeys(FKContainer table, Map copyMap) {
        if (copyMap == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        FKIndexAssociation[] fkeys = this.getFKAssociations();
        for (int i = 0; i < fkeys.length; ++i) {
            FKIndexAssociation oldFK = fkeys[i];
            KeyObject oldRemoteIndex = oldFK.getRemoteIndex();
            if (oldRemoteIndex == null) continue;
            boolean copyWithinSameModel = this.getDesignPart() == table.getDesignPart();
            Object remoteKeyCopy = copyMap.get(oldRemoteIndex.getObjectID());
            if (!copyWithinSameModel && remoteKeyCopy == null) continue;
            FKIndexAssociation newFK = new FKIndexAssociation(table.getDesignPart());
            newFK.setBackup(this.isBackup());
            this.assignLocalID(newFK);
            KeyObject newRemoteKey = remoteKeyCopy != null ? (KeyObject)remoteKeyCopy : oldRemoteIndex;
            newFK.setKeyObject(newRemoteKey);
            KeyObject oldLocalIndex = oldFK.getLocalFKIndex();
            KeyObject newLocalIndex = table.createIndexFK(newFK);
            for (FKElement oldColumn : oldLocalIndex.getElementsCollection()) {
                Object newCol = copyMap.get(oldColumn.getObjectID());
                FKElement oldRefColumn = oldColumn.getReferencedColumn(oldFK);
                FKElement newRefCol = remoteKeyCopy != null ? copyMap.get(oldRefColumn.getObjectID()) : oldRefColumn;
                if (!(newCol instanceof FKElement) || !(newRefCol instanceof FKElement)) continue;
                FKElement newColumn = (FKElement)newCol;
                newColumn.addFKAssociation(newRefCol, newFK);
                newLocalIndex.add(newColumn);
            }
            oldLocalIndex.copy(newLocalIndex);
            table.recreateFK(newFK, newRemoteKey, newLocalIndex.getObjectID(), null);
            oldFK.copy(newFK);
            if (copyWithinSameModel) {
                String newname = FKUtilities.generateFKName(table, newFK.getRemoteTable(), newFK.getRemoteIndex());
                newFK.setName(newname);
            }
            newFK.resetEdgeParams();
            if (copyMap != null) {
                copyMap.put(oldFK.getObjectID(), newFK);
            }
            list.add(newFK);
        }
        return list;
    }

    public void copy(DesignObject desObject, Map copyMap) {
        this.copy(desObject, copyMap, false);
    }

    public abstract FKIndexAssociation recreateFK(FKIndexAssociation var1, KeyObject var2, String var3, String var4);

    public String getRelatedSingularName() {
        String pl = this.getProperty("singularName");
        if (pl != null && !"".equals(pl)) {
            return pl;
        }
        pl = this.getRelationalModel().getSingularName(this.getName());
        return pl;
    }
}

