/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.AbstractConstraint;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class EngCOPropertiesComparator
extends EngPropertiesComparator {
    private static final Logger LOGGER = new Logger(EngCOPropertiesComparator.class);
    private ContainedObjectWithDomain left_co;
    private ContainedObjectWithDomain right_co;
    private static String INTEGER = "INTEGER";
    private static String SMALLINT = "SMALLINT";
    private static String INT = "INT";
    private static String NUMERIC = "NUMERIC";
    private static String DECIMAL = "DECIMAL";
    private static String DEC = "DEC";
    private static String NUMBER = "NUMBER";
    private static String FLOAT = "FLOAT";
    private static String REAL = "REAL";
    private static String DOUBLE = "DOUBLE PRECISION";

    public EngCOPropertiesComparator(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        super(left_co, right_co);
        this.left_co = left_co;
        this.right_co = right_co;
    }

    public static String decodeDataTypeKindToString(ContainedObjectWithDomain co) {
        short use = co.getUse();
        if (use == 0) {
            return "Domain(" + co.getDomain().getName() + ")";
        }
        if (use == 1) {
            return "Logical Type(" + co.getLogicalDatatype().getName() + ")";
        }
        if (use == 2) {
            if (co.getDistinctType() != null) {
                return "Distinct Type(" + co.getDistinctType().getName() + ")";
            }
            return "Missing Distinct Type";
        }
        if (use == 3) {
            return "Structured Type";
        }
        if (use == 4) {
            return "Collection Type";
        }
        return "";
    }

    public static String getType(ContainedObjectWithDomain co) {
        String type = "";
        RDBMSType dbtype = co.getDesignPart().getSelectedRDBMSType();
        String dbtypeName = dbtype != null ? dbtype.getName() : StorageDesignOraclev11g.RDBMS_TYPE.getName();
        try {
            type = co.getDesign().getDomainSet().getDefaultDomain().getDataType().toString();
        }
        catch (Exception e) {
            LOGGER.error("EngCOPropertiesComparator: Unable to get default domain: ", e);
        }
        short use = co.getUse();
        if (use == 0 && co.getDomain() != null) {
            type = co.getDataType().toString();
        } else if (use == 1) {
            type = co.getDataType().toString();
        } else if (use == 2) {
            if (co.getDistinctType() != null) {
                type = co.getDatatypeString(dbtypeName);
            }
        } else if (use == 3) {
            if (co.getStructuredType() != null) {
                type = co.isReference() ? "REF " + co.getStructuredType().getName() : co.getStructuredType().getName();
            }
        } else if (use == 4 && co.getCollectionType() != null) {
            type = co.getCollectionType().getName();
        }
        return type;
    }

    private static boolean isDatatypeCompatible(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        String rightSize;
        String leftSize;
        Datatype leftDataType = left_co.getDataType();
        Datatype rightDataType = right_co.getDataType();
        if (leftDataType.getName().equalsIgnoreCase(rightDataType.getName()) && leftDataType.getName().equalsIgnoreCase("VARCHAR2") && (leftSize = left_co.getSizeOnly()).equalsIgnoreCase(rightSize = right_co.getSizeOnly())) {
            String rightUnit;
            String leftUnit = left_co.getUnits();
            return leftUnit.equalsIgnoreCase(rightUnit = right_co.getUnits()) || !"CHAR".equals(leftUnit) && !"CHAR".equals(rightUnit);
        }
        return false;
    }

    public static void processDataTypeAndUse(List propertiesList, ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        String left_type = left_co != null ? EngCOPropertiesComparator.getType(left_co) : "";
        String right_type = right_co != null ? EngCOPropertiesComparator.getType(right_co) : "";
        StorageDesign sd = null;
        if (left_co != null && left_co.getDesignPart() instanceof RelationalDesign) {
            sd = ((RelationalDesign)left_co.getDesignPart()).getStorageDesign();
        } else if (right_co != null && right_co.getDesignPart() instanceof RelationalDesign) {
            sd = ((RelationalDesign)right_co.getDesignPart()).getStorageDesign();
        }
        if (PropertiesComparator.HIVE_DATA_TYPES) {
            if (left_co != null && left_co instanceof Column) {
                left_type = left_co.getDataTypePresentationForHive();
            }
            if (right_co != null && right_co instanceof Column) {
                right_type = right_co.getDataTypePresentationForHive();
            }
        }
        String left_datatype_kind = left_co != null ? EngCOPropertiesComparator.decodeDataTypeKindToString(left_co) : "";
        String right_datatype_kind = right_co != null ? EngCOPropertiesComparator.decodeDataTypeKindToString(right_co) : "";
        EngPropertyHolder ph = new EngPropertyHolder(DATA_TYPE);
        ph.setDDLHolder(true);
        ph.setLeftValue(left_type);
        ph.setRightValue(right_type);
        if (left_co != null && right_co != null && !left_type.equals(right_type)) {
            boolean synonyms = EngCOPropertiesComparator.isEqualToNumberDataType(sd, left_co, right_co);
            if (!synonyms) {
                synonyms = EngCOPropertiesComparator.isEqualToFloatDataType(sd, left_co, right_co);
            }
            if (!synonyms) {
                ph.setModified(true);
                ph.setSelected(true);
                if (EngCOPropertiesComparator.isDatatypeCompatible(left_co, right_co)) {
                    ph.setSelected(false);
                }
            }
        }
        propertiesList.add(ph);
        boolean useDataTypeKind = false;
        if (left_co != null) {
            useDataTypeKind = left_co.getDesignPart().getAppView().getSettings().isUseDataTypeKindInCompare();
        } else if (right_co != null) {
            useDataTypeKind = right_co.getDesignPart().getAppView().getSettings().isUseDataTypeKindInCompare();
        }
        ph = new EngPropertyHolder(DATA_TYPE_KIND);
        ph.setLeftValue(left_datatype_kind);
        ph.setRightValue(right_datatype_kind);
        if (left_co != null && right_co != null && !left_datatype_kind.equals(right_datatype_kind)) {
            ph.setModified(true);
            if (useDataTypeKind && !PropertiesComparator.DDL_ONLY) {
                ph.setSelected(true);
            } else {
                ph.setEditable(false);
                ph.setFiltered(true);
            }
        }
        propertiesList.add(ph);
    }

    private static boolean isEqualToNumberDataType(StorageDesign sd, ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        if (sd != null && sd instanceof StorageDesignOracle) {
            String rdbmsName = sd.getRDBMSType().getName();
            ContainedObjectWithDomain co = right_co;
            Datatype leftDataType = left_co.getDataType();
            Datatype rightDataType = right_co.getDataType();
            String rightName = rightDataType.getName();
            String leftName = leftDataType.getName();
            if (NUMBER.equalsIgnoreCase(leftName) && (NUMERIC.equalsIgnoreCase(rightName) || DECIMAL.equalsIgnoreCase(rightName) || DEC.equalsIgnoreCase(rightName) || NUMBER.equalsIgnoreCase(rightName)) || NUMBER.equalsIgnoreCase(rightName) && (NUMERIC.equalsIgnoreCase(leftName) || DECIMAL.equalsIgnoreCase(leftName) || DEC.equalsIgnoreCase(leftName) || NUMBER.equalsIgnoreCase(leftName))) {
                String pdf;
                String rpr = right_co.getPrecision();
                String rsc = right_co.getScale();
                if (right_co.getUse() == 0 && right_co.getDomain() != null) {
                    rpr = right_co.getDomain().getPrecision();
                    rsc = right_co.getDomain().getScale();
                }
                String lpr = left_co.getPrecision();
                String lsc = left_co.getScale();
                if (left_co.getUse() == 0 && left_co.getDomain() != null) {
                    lpr = left_co.getDomain().getPrecision();
                }
                Map map = (Map)left_co.getLogicalDatatype().getDefaultValues().get(rdbmsName);
                if ("".equals(lpr) && (pdf = (String)map.get("precision_default_value")) != null && !"".equals(pdf)) {
                    lpr = pdf;
                }
                if ("".equals(lsc) && (pdf = (String)map.get("scale_default_value")) != null && !"".equals(pdf)) {
                    lsc = pdf;
                }
                map = (Map)right_co.getLogicalDatatype().getDefaultValues().get(rdbmsName);
                if ("".equals(rpr) && (pdf = (String)map.get("precision_default_value")) != null && !"".equals(pdf)) {
                    rpr = pdf;
                }
                if ("".equals(rsc) && (pdf = (String)map.get("scale_default_value")) != null && !"".equals(pdf)) {
                    rpr = pdf;
                }
                if (rpr.equalsIgnoreCase(lpr) && rsc.equalsIgnoreCase(lsc)) {
                    return true;
                }
                if ("".equals(lpr) && "38".equals(rpr) || "".equals(rpr) && "38".equals(lpr)) {
                    return true;
                }
            }
            if (rightName.equalsIgnoreCase(INTEGER) || rightName.equalsIgnoreCase(INT) || rightName.equalsIgnoreCase(SMALLINT)) {
                leftDataType = right_co.getDataType();
                rightDataType = left_co.getDataType();
                co = left_co;
            } else if (!(leftName.equalsIgnoreCase(INTEGER) || leftName.equalsIgnoreCase(INT) || leftName.equalsIgnoreCase(SMALLINT))) {
                return false;
            }
            rightName = rightDataType.getName();
            if ((rightName.equalsIgnoreCase(NUMBER) || rightName.equalsIgnoreCase(NUMERIC)) && "38".equals(co.getPrecision())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isEqualToFloatDataType(StorageDesign sd, ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        if (sd != null && sd instanceof StorageDesignOracle) {
            String rdbmsName = sd.getRDBMSType().getName();
            ContainedObjectWithDomain co = right_co;
            Datatype leftDataType = left_co.getDataType();
            Datatype rightDataType = right_co.getDataType();
            String rightName = rightDataType.getName();
            String leftName = leftDataType.getName();
            if (FLOAT.equalsIgnoreCase(leftName) && (FLOAT.equalsIgnoreCase(rightName) || REAL.equalsIgnoreCase(rightName) || DOUBLE.equalsIgnoreCase(rightName)) || FLOAT.equalsIgnoreCase(rightName) && (FLOAT.equalsIgnoreCase(leftName) || REAL.equalsIgnoreCase(leftName) || DOUBLE.equalsIgnoreCase(leftName))) {
                Map map;
                String pdf;
                String rpr = right_co.getPrecision();
                if (right_co.getUse() == 0 && right_co.getDomain() != null) {
                    rpr = right_co.getDomain().getPrecision();
                }
                String lpr = left_co.getPrecision();
                if (left_co.getUse() == 0 && left_co.getDomain() != null) {
                    lpr = left_co.getDomain().getPrecision();
                }
                if ("".equals(lpr) && (pdf = (String)(map = (Map)left_co.getLogicalDatatype().getDefaultValues().get(rdbmsName)).get("precision_default_value")) != null && !"".equals(pdf)) {
                    lpr = pdf;
                }
                if ("".equals(rpr) && (pdf = (String)(map = (Map)right_co.getLogicalDatatype().getDefaultValues().get(rdbmsName)).get("precision_default_value")) != null && !"".equals(pdf)) {
                    rpr = pdf;
                }
                if (rpr.equalsIgnoreCase(lpr)) {
                    return true;
                }
                if ("".equals(lpr) && "126".equals(rpr) || "".equals(rpr) && "126".equals(lpr)) {
                    return true;
                }
                if ("".equals(lpr) && "63".equals(rpr) || "".equals(rpr) && "63".equals(lpr)) {
                    return true;
                }
            }
            if (rightName.equalsIgnoreCase(INTEGER) || rightName.equalsIgnoreCase(INT) || rightName.equalsIgnoreCase(SMALLINT)) {
                leftDataType = right_co.getDataType();
                rightDataType = left_co.getDataType();
                co = left_co;
            } else if (!(leftName.equalsIgnoreCase(INTEGER) || leftName.equalsIgnoreCase(INT) || leftName.equalsIgnoreCase(SMALLINT))) {
                return false;
            }
            rightName = rightDataType.getName();
            if ((rightName.equalsIgnoreCase(NUMBER) || rightName.equalsIgnoreCase(NUMERIC)) && "38".equals(co.getPrecision())) {
                return true;
            }
        }
        return false;
    }

    protected void initPropertiesList() {
        String right;
        String left;
        this.initNameProperty();
        if (this.getDesign().isApplyNameStandardization()) {
            this.initNameTranslationProperty();
        }
        this.initDeprecated();
        EngCOPropertiesComparator.processDataTypeAndUse(this.propertiesList, this.left_co, this.right_co);
        EngPropertyHolder ph = new EngPropertyHolder(MANDATORY);
        ph.setDDLHolder(true);
        String string = this.left_co != null ? String.valueOf(!this.left_co.getNullsAllowed()) : (left = "");
        String string2 = this.right_co != null ? String.valueOf(!this.right_co.getNullsAllowed()) : (right = "");
        if (this.left_co != null && this.right_co != null) {
            FKIndexAssociation fk;
            if (this.left_co instanceof Column && ((Column)this.left_co).getDependOnForeignKey() != null && !this.left_co.isMandatory()) {
                fk = ((Column)this.left_co).getDependOnForeignKey();
                if (!fk.isMandatory()) {
                    left = String.valueOf(((Column)this.left_co).isDependOnFK_AsMandatory());
                }
            } else if (this.right_co instanceof Column && ((Column)this.right_co).getDependOnForeignKey() != null) {
                fk = ((Column)this.right_co).getDependOnForeignKey();
                if (!fk.isMandatory()) {
                    right = String.valueOf(((Column)this.right_co).isDependOnFK_AsMandatory());
                }
            } else if (this.right_co instanceof Column && ((Column)this.right_co).getDependOnForeignKey() == null && this.left_co instanceof Attribute) {
                Entity ent;
                Attribute attribute = (Attribute)this.left_co;
                Column col = (Column)this.right_co;
                XtdMapping mapping = col.getRelationalModel().getRMExtendedMap().getMapping(attribute, col);
                if (1 == mapping.getInheritanceType() && (ent = (Entity)attribute.getContainerWithKeyObject()).isHierarchicalEntityType() && !ent.isHierarchicalRoot()) {
                    left = "false";
                }
            }
            if (!left.equalsIgnoreCase(right)) {
                if (this.left_co.isFKElement() && this.right_co.isFKElement()) {
                    ph.setEditable(false);
                    ph.setSelected(false);
                    ph.setRightValue(ph.getRightValue() + "(FK)");
                } else {
                    ph.setSelected(true);
                    ph.setModified(true);
                }
            }
        }
        ph.setLeftValue(left);
        ph.setRightValue(right);
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(DEFAULT_VALUE);
        ph.setDDLHolder(true);
        String leftValue = this.left_co != null ? this.left_co.getDefaultValue().replaceAll("'", "") : "";
        String rightValue = this.right_co != null ? this.right_co.getDefaultValue().replaceAll("'", "") : "";
        ph.setLeftValue(leftValue);
        ph.setRightValue(rightValue);
        if (this.left_co != null && this.right_co != null && !leftValue.trim().equals(rightValue.trim())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        this.propertiesList.add(EngCOPropertiesComparator.createCheckConstrNamePH(this.left_co, this.right_co));
        ph = new EngPropertyHolder(USE_DOMAIN_CONSTRAINT);
        ph.setLeftValue(this.left_co != null ? String.valueOf(this.left_co.getUseDomainConstraints()) : "");
        ph.setRightValue(this.right_co != null ? String.valueOf(this.right_co.getUseDomainConstraints()) : "");
        if (this.left_co != null && this.right_co != null && this.left_co.getUseDomainConstraints() != this.right_co.getUseDomainConstraints()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (this.left_co != null && !this.left_co.getUseDomainConstraints() || this.right_co != null && !this.right_co.getUseDomainConstraints()) {
            this.propertiesList.add(EngCOPropertiesComparator.createCheckConstrPH(this.left_co, this.right_co));
            this.propertiesList.add(EngCOPropertiesComparator.createRangeConstrPH(this.left_co, this.right_co));
            this.propertiesList.add(EngCOPropertiesComparator.createLOVConstraintPH(this.left_co, this.right_co));
        }
        this.initCommentsAndNotes();
        ph = new EngPropertyHolder(SOURCE_TYPE);
        String sourceTypeLeftValue = "";
        if (this.left_co != null) {
            sourceTypeLeftValue = this.left_co.getSourceType();
            if (this.left_co.getFormulaDesc().length() > 0 && !sourceTypeLeftValue.equalsIgnoreCase("Aggregate")) {
                sourceTypeLeftValue = "Derived";
            }
        }
        ph.setLeftValue(sourceTypeLeftValue);
        ph.setRightValue(this.right_co != null ? this.right_co.getSourceType() : "");
        if (this.left_co != null && this.right_co != null && !sourceTypeLeftValue.equals(this.right_co.getSourceType())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(FORMULA_DESC);
        ph.setLeftValue(this.left_co != null ? this.left_co.getFormulaDesc() : "");
        ph.setRightValue(this.right_co != null ? this.right_co.getFormulaDesc() : "");
        if (this.left_co != null && this.right_co != null && !this.left_co.getFormulaDesc().equals(this.right_co.getFormulaDesc())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(TYPE_SUBSTITUTION);
        String left_sub = "ALL";
        if (this.left_co != null) {
            if (this.left_co.isAllowSubtypeSubstitution() && this.left_co.isRestrictedTypeSubstitution()) {
                left_sub = "RESTRICTED";
            } else if (!this.left_co.isAllowSubtypeSubstitution() && !this.left_co.isRestrictedTypeSubstitution()) {
                left_sub = "NONE";
            }
        }
        String right_sub = "ALL";
        if (this.right_co != null) {
            if (this.right_co.isAllowSubtypeSubstitution() && this.right_co.isRestrictedTypeSubstitution()) {
                right_sub = "RESTRICTED";
            } else if (!this.right_co.isAllowSubtypeSubstitution() && !this.right_co.isRestrictedTypeSubstitution()) {
                right_sub = "NONE";
            }
        }
        ph.setLeftValue(left_sub);
        ph.setRightValue(right_sub);
        if (this.left_co != null && this.right_co != null && !left_sub.equals(right_sub)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    @Override
    protected void copyPropertiesFromLeftToRight() {
        if (this.left_co != null && this.right_co != null) {
            this.right_co.setTemporaryWriteable(true);
            super.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(DATA_TYPE) || ph.getName().equals(DATA_TYPE_KIND)) {
                    this.right_co.setUse(this.left_co.getUse());
                    this.right_co.setSensitiveType(this.left_co.getSensitiveType());
                    this.right_co.setSensitiveTypeDescription(this.left_co.getSensitiveTypeDescription());
                    this.right_co.setReference(this.left_co.isReference());
                    this.right_co.setDomain(this.left_co.getDomain());
                    this.right_co.setLogicalDatatype(this.left_co.getLogicalDatatype());
                    this.right_co.copyParametersFrom(this.left_co);
                    this.right_co.setStructuredType(this.left_co.getStructuredType());
                    this.right_co.setDistinctType(this.left_co.getDistinctType());
                    continue;
                }
                if (ph.getName().equals(TYPE_SUBSTITUTION)) {
                    this.right_co.setAllowSubtypeSubstitution(this.left_co.isAllowSubtypeSubstitution());
                    this.right_co.setRestrictedTypeSubstitution(this.left_co.isRestrictedTypeSubstitution());
                    continue;
                }
                if (ph.getName().equals(MANDATORY)) {
                    FKIndexAssociation fk;
                    if (this.left_co instanceof Column && ((Column)this.left_co).getDependOnForeignKey() != null && !this.left_co.isMandatory()) {
                        fk = ((Column)this.left_co).getDependOnForeignKey();
                        if (!fk.isMandatory()) {
                            this.right_co.setMandatory(((Column)this.left_co).isDependOnFK_AsMandatory());
                            continue;
                        }
                        this.right_co.setMandatory(this.left_co.isMandatory());
                        continue;
                    }
                    if (this.right_co instanceof Column && ((Column)this.right_co).getDependOnForeignKey() != null) {
                        if (this.left_co.isMandatory()) {
                            fk = ((Column)this.right_co).getDependOnForeignKey();
                            if (!fk.isMandatory()) {
                                this.right_co.setMandatory(false);
                            } else {
                                this.right_co.setMandatory(true);
                            }
                            ((Column)this.right_co).setDependOnFK_AsMandatory(true);
                            continue;
                        }
                        this.right_co.setMandatory(this.left_co.isMandatory());
                        ((Column)this.right_co).setDependOnFK_AsMandatory(false);
                        continue;
                    }
                    this.right_co.setNullsAllowed(this.left_co.getNullsAllowed());
                    continue;
                }
                if (ph.getName().equals(DEFAULT_VALUE)) {
                    this.right_co.setDefaultValue(this.left_co.getDefaultValue());
                    continue;
                }
                if (ph.getName().equals(SOURCE_TYPE)) {
                    this.right_co.setSourceType(ph.getLeftValue());
                    continue;
                }
                if (ph.getName().equals(FORMULA_DESC)) {
                    this.right_co.setFormulaDesc(this.left_co.getFormulaDesc());
                    if (!(this.right_co instanceof Attribute) || this.right_co.getFormulaDesc().length() <= 0 || this.right_co.getSourceType().equalsIgnoreCase("Aggregate")) continue;
                    this.right_co.setSourceType("Derived");
                    continue;
                }
                if (ph.getName().equals(CHECK_CONSTRAINT_NAME)) {
                    this.right_co.setConstraintName(this.left_co.getConstraintName());
                    continue;
                }
                if (ph.getName().equals(USE_DOMAIN_CONSTRAINT)) {
                    this.right_co.setUseDomainConstraints(this.left_co.getUseDomainConstraints());
                    continue;
                }
                if (ph.getName().equals(CHECK_CONSTRAINT)) {
                    EngCOPropertiesComparator.copyCheckConstraint(this.left_co, this.right_co);
                    continue;
                }
                if (ph.getName().equals(RANGE_CONSTRAINT)) {
                    EngCOPropertiesComparator.copyRangeConstraint(this.left_co, this.right_co);
                    continue;
                }
                if (!ph.getName().equals(LOV_CONSTRAINT)) continue;
                EngCOPropertiesComparator.copyLOVConstraint(this.left_co, this.right_co);
            }
            this.right_co.setTemporaryWriteable(false);
        }
    }

    public static EngPropertyHolder createCheckConstrNamePH(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        EngPropertyHolder ph = new EngPropertyHolder(CHECK_CONSTRAINT_NAME);
        ph.setDDLHolder(true);
        String leftName = "";
        String leftName2 = "";
        if (left_co != null) {
            leftName = left_co.getConstraintName();
            if (PropertiesComparator.DDL_ONLY && !leftName.toUpperCase().startsWith("SYS_")) {
                leftName2 = leftName;
            }
        }
        String rightName = "";
        String rightName2 = "";
        if (right_co != null) {
            rightName = right_co.getConstraintName();
            if (PropertiesComparator.DDL_ONLY && !rightName.toUpperCase().startsWith("SYS_")) {
                rightName2 = rightName;
            }
        }
        ph.setLeftValue(leftName);
        ph.setRightValue(rightName);
        if (left_co != null && right_co != null && !leftName.equalsIgnoreCase(rightName)) {
            ph.setModified(true);
            ph.setSelected(true);
            if (PropertiesComparator.DDL_ONLY && rightName2.equalsIgnoreCase(leftName2)) {
                ph.setEditable(true);
                ph.setSelected(false);
                ph.setFiltered(true);
            }
        }
        return ph;
    }

    public static EngPropertyHolder createCheckConstrPH(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        EngPropertyHolder ph = new EngPropertyHolder(CHECK_CONSTRAINT);
        ph.setDDLHolder(true);
        if (left_co != null && left_co.getCheck() != null) {
            CheckConstraint left_check = left_co.getCheck();
            RDBMSType left_type = left_co.getDesignPart().getSelectedRDBMSSite().getType();
            String left_text = left_check.getImplementation(left_type);
            left_text = left_text.replaceAll("%COLUMN%", left_co.getName());
            left_text = left_text.replaceAll("%column%", left_co.getName());
            ph.setLeftValue(left_text.trim());
        } else {
            ph.setLeftValue("");
        }
        if (right_co != null && right_co.getCheck() != null) {
            CheckConstraint right_check = right_co.getCheck();
            RDBMSType right_type = right_co.getDesignPart().getSelectedRDBMSSite().getType();
            String right_text = right_check.getImplementation(right_type);
            right_text = right_text.replaceAll("%COLUMN%", right_co.getName());
            right_text = right_text.replaceAll("%column%", right_co.getName());
            ph.setRightValue(right_text.trim());
        } else {
            ph.setRightValue("");
        }
        if (left_co != null && right_co != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        return ph;
    }

    public static EngPropertyHolder createLOVConstraintPH(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        EngPropertyHolder ph = new EngPropertyHolder(LOV_CONSTRAINT);
        ph.setDDLHolder(true);
        String leftValue = "";
        if (left_co != null && left_co.getValueList() != null) {
            ConstraintEnumeration left_check = left_co.getValueList();
            leftValue = left_check.getValuesAsString().replaceAll("'", "");
        }
        ph.setLeftValue(leftValue);
        String rightValue = "";
        if (right_co != null && right_co.getValueList() != null) {
            ConstraintEnumeration right_check = right_co.getValueList();
            rightValue = right_check.getValuesAsString().replaceAll("'", "");
        }
        ph.setRightValue(rightValue);
        if (left_co != null && right_co != null && !leftValue.equals(rightValue)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        return ph;
    }

    public static EngPropertyHolder createRangeConstrPH(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        EngPropertyHolder ph = new EngPropertyHolder(RANGE_CONSTRAINT);
        ph.setDDLHolder(true);
        if (left_co != null) {
            ph.setLeftValue(EngCOPropertiesComparator.getAVTsToString(left_co));
        } else {
            ph.setLeftValue("");
        }
        if (right_co != null) {
            ph.setRightValue(EngCOPropertiesComparator.getAVTsToString(right_co));
        } else {
            ph.setRightValue("");
        }
        if (left_co != null && right_co != null && !EngCOPropertiesComparator.haveEqualAVTs(left_co, right_co)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        return ph;
    }

    public static boolean isConstrCondConsistent(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        String left_text = "";
        String right_text = "";
        if (left_co != null) {
            left_text = left_co.getConstraintsText(left_co.getName().toUpperCase());
        }
        if (right_co != null) {
            right_text = right_co.getConstraintsText(right_co.getName().toUpperCase());
        }
        return left_text.equals(right_text);
    }

    private static String getAVTsToString(ContainedObject co) {
        StringBuffer sb = new StringBuffer();
        for (AVT avt : co.getAVTs()) {
            sb.append(avt.getValuesAsString()).append(",").append("\n ");
        }
        int i = sb.lastIndexOf(",");
        if (i > 0) {
            return sb.substring(0, i).trim();
        }
        return sb.toString().trim();
    }

    private static boolean haveEqualAVTs(ContainedObject left_co, ContainedObject right_co) {
        Object[] right_ar;
        Object[] left_ar = left_co.getAVTs().toArray();
        if (left_ar.length != (right_ar = right_co.getAVTs().toArray()).length) {
            return false;
        }
        for (int i = 0; i < left_ar.length; ++i) {
            if (!(left_ar[i] instanceof AVT) || !(right_ar[i] instanceof AVT)) {
                return false;
            }
            AVT left_avt = (AVT)left_ar[i];
            AVT right_avt = (AVT)right_ar[i];
            if (left_avt.getBeginValue().equals(right_avt.getBeginValue()) && left_avt.getEndValue().equals(right_avt.getEndValue())) continue;
            return false;
        }
        return true;
    }

    public static void copyCheckConstraint(ContainedObject left_co, ContainedObject right_co) {
        if (PropertiesComparator.DDL_ONLY) {
            right_co.setUseDomainConstraints(false);
        }
        if (right_co.getUseDomainConstraints()) {
            return;
        }
        CheckConstraint left_c = left_co.getCheck();
        if (left_c == null) {
            right_co.setCheck(null);
            return;
        }
        CheckConstraint right_c = right_co.getCheck();
        if (right_c == null) {
            right_c = new CheckConstraint();
            right_c.setDesign(left_co.getDesign());
        }
        right_co.setCheck(right_c);
        if (right_c != left_c) {
            left_c.copyTo(right_c);
        }
    }

    public static void copyLOVConstraint(ContainedObjectWithDomain left_co, ContainedObjectWithDomain right_co) {
        if (PropertiesComparator.DDL_ONLY) {
            right_co.setUseDomainConstraints(false);
        }
        if (right_co.getUseDomainConstraints()) {
            return;
        }
        ConstraintEnumeration left_c = left_co.getOwnValueList();
        if (left_c == null) {
            right_co.setOwnValueList(null);
            return;
        }
        ConstraintEnumeration right_c = right_co.getOwnValueList();
        if (right_c == null) {
            right_c = new ConstraintEnumeration();
            right_c.setDesign(right_co.getDesign());
        }
        right_co.setValueList(right_c);
        if (right_c != left_c) {
            ((AbstractConstraint)left_c).copyTo(right_c);
        }
    }

    public static void copyRangeConstraint(ContainedObject left_co, ContainedObject right_co) {
        if (PropertiesComparator.DDL_ONLY) {
            right_co.setUseDomainConstraints(false);
        }
        if (right_co.getUseDomainConstraints()) {
            return;
        }
        Iterator it = left_co.getAVTs().iterator();
        right_co.clearAVTs();
        while (it.hasNext()) {
            AVT avt = (AVT)it.next();
            AVT newAVT = new AVT(avt.getBeginValue(), avt.getEndValue(), avt.getDescription());
            right_co.addAVT(newAVT);
        }
    }
}

