/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionTypeSet;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.editor.datatypes.CollectionTypePropertiesDialogEx;

public class CollectionType
extends AbstractDTObject
implements Datatype,
SetListener {
    public static String TYPE_ARRAY = "ARRAY";
    public static String TYPE_COLLECTION = "COLLECTION";
    private String[] TYPES = new String[]{TYPE_ARRAY, TYPE_COLLECTION};
    private String type = this.TYPES[0];
    private TypeElement elementType = null;
    private int maxElement = 1;
    DataTypeWrapper dataTypeWrapper;
    private int maxLengthAsString = 0;
    public static final String TYPE_NAME = "CollectionType";

    public CollectionType(DesignPart designPart) {
        super(designPart);
        ((DataTypesDesign)designPart).getCollectionTypeSet().addSetListener(this);
    }

    @Override
    public int getByteSize() {
        return 0;
    }

    @Override
    public String getSize() {
        return "";
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public String getType() {
        return this.type;
    }

    public void setDataTypeID(String parentTypeID) {
        this.getElementType().setTypeID(parentTypeID);
    }

    public void setType(String type) {
        this.type = type;
    }

    public TypeElement getElementType() {
        if (this.elementType == null) {
            this.elementType = new TypeElement(this.getDesignPart(), null);
            this.elementType.setDesign(this.getDesign());
            this.elementType.setType(this.getDesign().getDomainSet().getDefaultDomain());
            this.elementType.setParent(this);
        }
        return this.elementType;
    }

    public DesignObject getDataType() {
        return this.getElementType().getType();
    }

    public void setElementType(TypeElement elementType) {
        this.elementType = elementType;
    }

    public void addElementType(DesignObject object) {
        this.getElementType().setType(object);
    }

    public int getMaxElement() {
        return this.maxElement;
    }

    public void setMaxElement(int maxElement) {
        this.maxElement = maxElement;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            CollectionTypePropertiesDialogEx dialog = new CollectionTypePropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (set instanceof CollectionTypeSet && event.isRemoved()) {
            CollectionType ct = (CollectionType)event.getAffected();
            if (this.getElementType().getType() == ct) {
                this.setElementType(null);
            }
        }
    }

    public boolean isArrayType() {
        return this.type.equalsIgnoreCase(this.TYPES[0]);
    }

    public void setArrayType() {
        this.setType(this.TYPES[0]);
    }

    public void setCollectionType() {
        this.setType(this.TYPES[1]);
    }

    public void copy(DesignObject desObject, Map copyMap) {
        this.copy(desObject, copyMap, false);
    }

    @Override
    public void copy(DesignObject desObject) {
        CollectionType collection = (CollectionType)desObject;
        super.copy(collection);
        collection.setType(this.getType());
        collection.setMaxElement(this.getMaxElement());
        collection.setDataTypeID(this.getElementType().getObjectID());
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "collectiontype" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public DataTypeWrapper getDataTypeWrapper() {
        if (this.dataTypeWrapper == null) {
            this.dataTypeWrapper = new DataTypeWrapper(this.getElementType());
        }
        return this.dataTypeWrapper;
    }

    @Override
    public boolean hasProxyToDelete() {
        return true;
    }

    public int getMaxLengthAsString() {
        return this.maxLengthAsString;
    }

    public void setMaxLengthAsString(int maxLengthAsString) {
        this.maxLengthAsString = maxLengthAsString;
    }

    public String getDataTypePresentationForHive() {
        String type = "String";
        if (this.getElementType() != null) {
            type = "ARRAY<" + this.getElementType().getDataTypePresentationForHive() + ">";
        }
        return type;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public boolean canPaste() {
        for (Object obj : this.getDesign().getAppView().getCopiedObjects()) {
            if (obj == null || !(obj instanceof CollectionType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void paste() {
        for (Object obj : this.getDesign().getAppView().getCopiedObjects()) {
            DesignObject copied = (DesignObject)obj;
            CollectionType newObj = this.getDesign().getDataTypesDesign().createCollectionType();
            copied.copy(newObj);
        }
    }

    public class DataTypeWrapper {
        TypeElement te;

        private DataTypeWrapper(TypeElement te) {
            this.te = te;
        }

        public int getPrecision() {
            return this.te.getPrecision();
        }

        public void setPrecision(int precision) {
            this.te.setPrecision(precision);
        }

        public int getScale() {
            return this.te.getScale();
        }

        public void setScale(int scale) {
            this.te.setScale(scale);
        }

        public String getSize() {
            return this.te.getSize();
        }

        public void setSize(String size) {
            this.te.setSize(size);
        }

        public void setTypeID(String typeID) {
            this.te.setTypeID(typeID);
        }

        public String getTypeID() {
            return this.te.getTypeID();
        }

        public boolean isReference() {
            return this.te.isReference();
        }

        public void setReference(boolean isReference) {
            this.te.setReference(isReference);
        }
    }
}

