/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.compare.AbstractMerging;
import oracle.dbtools.crest.model.design.compare.PropertyFilter;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;

public class StorageTemplateComparator
extends StoragePropertiesComparator {
    private SegmentOracle sourceStorageTemplate;
    private SegmentOracle targetStorageTemplate;
    private TableSpaceOracle sourceTableSpace;
    private TableSpaceOracle targetTableSpace;
    private StorageObject sourceObject;
    private StorageObject targetObject;
    private Method templateSetter;
    private Method tableSpaceSetter;

    public StorageTemplateComparator(StorageObject sourceObject, StorageObject targetObject, StorageObject sourceStorageTemplate, StorageObject targetStorageTemplate, TableSpaceOracle sourceTableSpace, TableSpaceOracle targetTableSpace, Method templateSetter, Method tableSpaceSetter) {
        super(sourceStorageTemplate, targetStorageTemplate);
        this.sourceStorageTemplate = (SegmentOracle)sourceStorageTemplate;
        this.targetStorageTemplate = (SegmentOracle)targetStorageTemplate;
        this.sourceTableSpace = sourceTableSpace;
        this.targetTableSpace = targetTableSpace;
        this.sourceObject = sourceObject;
        this.targetObject = targetObject;
        this.templateSetter = templateSetter;
        this.tableSpaceSetter = tableSpaceSetter;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        PropertyHolder ph = new PropertyHolder(TABLESPACE);
        String sourceTS = "";
        String targetTS = "";
        if (this.sourceTableSpace != null) {
            sourceTS = this.sourceTableSpace.getName();
        } else if (this.sourceStorageTemplate != null && this.sourceStorageTemplate.getTableSpace() != null) {
            sourceTS = this.sourceStorageTemplate.getTableSpace().getName();
        }
        if (this.targetTableSpace != null) {
            targetTS = this.targetTableSpace.getName();
        } else if (this.targetStorageTemplate != null && this.targetStorageTemplate.getTableSpace() != null) {
            targetTS = this.targetStorageTemplate.getTableSpace().getName();
        }
        ph.setLeftValue(sourceTS);
        ph.setRightValue(targetTS);
        if (this.isExcludedFromComparison(TABLESPACE)) {
            ph.setExcluded(true);
        } else if (!sourceTS.equalsIgnoreCase(targetTS)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(PCT_FREE);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getPCTFree()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getPCTFree()) : "");
        if (this.isExcludedFromComparison(PCT_FREE)) {
            ph.setExcluded(true);
        } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(PCT_USED);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getPCTUsed()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getPCTUsed()) : "");
        if (this.isExcludedFromComparison(PCT_USED)) {
            ph.setExcluded(true);
        } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(INIT_TRANS);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getInitrans()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getInitrans()) : "");
        if (this.isExcludedFromComparison(INIT_TRANS)) {
            ph.setExcluded(true);
        } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (this.sourceStorageTemplate instanceof SegmentOraclev9i || this.targetStorageTemplate instanceof SegmentOraclev9i) {
            ph = new PropertyHolder(MAX_TRANS);
            ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getMaxTrans()) : "");
            ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getMaxTrans()) : "");
            if (this.isExcludedFromComparison(MAX_TRANS)) {
                ph.setExcluded(true);
            } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        ph = new PropertyHolder(SC_INITIAL_EXTENT);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getSCInitialExtent()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getSCInitialExtent()) : "");
        if (this.isExcludedFromComparison(SC_INITIAL_EXTENT)) {
            ph.setExcluded(true);
        } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_NEXT_EXTENT);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getSCNextExtent()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getSCNextExtent()) : "");
        if (this.isExcludedFromComparison(SC_NEXT_EXTENT)) {
            ph.setExcluded(true);
        } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_MIN_EXTENTS);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getSCMinExtents()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getSCMinExtents()) : "");
        if (this.isExcludedFromComparison(SC_MIN_EXTENTS)) {
            ph.setExcluded(true);
        } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_MAX_EXTENTS);
        ph.setLeftValue(this.sourceStorageTemplate != null ? this.sourceStorageTemplate.getSCMaxExtents() : "");
        ph.setRightValue(this.targetStorageTemplate != null ? this.targetStorageTemplate.getSCMaxExtents() : "");
        if (this.isExcludedFromComparison(SC_MAX_EXTENTS)) {
            ph.setExcluded(true);
        } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_PCT_INCREASE);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getSCPctIncrease()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getSCPctIncrease()) : "");
        if (this.isExcludedFromComparison(SC_PCT_INCREASE)) {
            ph.setExcluded(true);
        } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_BUFFER_POOL);
        ph.setLeftValue(this.sourceStorageTemplate != null ? this.sourceStorageTemplate.getSCBufferPool() : "");
        ph.setRightValue(this.targetStorageTemplate != null ? this.targetStorageTemplate.getSCBufferPool() : "");
        if (this.isExcludedFromComparison(SC_BUFFER_POOL)) {
            ph.setExcluded(true);
        } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_FREE_LISTS);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getSCFreeLists()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getSCFreeLists()) : "");
        if (this.isExcludedFromComparison(SC_FREE_LISTS)) {
            ph.setExcluded(true);
        } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SC_FREE_LISTS_GRPS);
        ph.setLeftValue(this.sourceStorageTemplate != null ? String.valueOf(this.sourceStorageTemplate.getSCFreelistGroups()) : "");
        ph.setRightValue(this.targetStorageTemplate != null ? String.valueOf(this.targetStorageTemplate.getSCFreelistGroups()) : "");
        if (this.isExcludedFromComparison(SC_FREE_LISTS_GRPS)) {
            ph.setExcluded(true);
        } else if (!ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    public void filterStoragePropertiesList(List filterList) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            EngPropertyHolder ph = (EngPropertyHolder)this.propertiesList.get(i);
            if (!this.isExcludedFromStorageComparison(ph.getName(), filterList)) continue;
            ph.setExcluded(true);
            ph.setModified(false);
            ph.setSelected(false);
        }
    }

    private boolean isExcludedFromStorageComparison(String propertyName, List filterList) {
        for (int j = 0; j < filterList.size(); ++j) {
            PropertyFilter st_pf = (PropertyFilter)filterList.get(j);
            if (!propertyName.equalsIgnoreCase(st_pf.getName())) continue;
            return !st_pf.isSelected();
        }
        return false;
    }

    @Override
    public void copySelectedProperties() {
        if (this.sourceObject != null && this.targetObject != null && this.sourceObject.shouldBeMerge()) {
            SegmentOracle newTargetStorageTemplate = null;
            boolean allStoTemplatePropsSelected = true;
            for (EngPropertyHolder ph : this.propertiesList) {
                if (ph.isSelected()) {
                    if (ph.getName().equals(TABLESPACE)) {
                        Map objectsMap;
                        TableSpaceOracle newTargetTableSpace = null;
                        if (this.sourceTableSpace != null && (objectsMap = AbstractMerging.getObjectsMap()) != null) {
                            newTargetTableSpace = (TableSpaceOracle)objectsMap.get(this.sourceTableSpace.getObjectID());
                        }
                        try {
                            this.tableSpaceSetter.invoke((Object)this.targetObject, newTargetTableSpace);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    if (this.sourceStorageTemplate == null) continue;
                    if (newTargetStorageTemplate == null) {
                        newTargetStorageTemplate = ((StorageDesignOracle)this.targetObject.getStorageDesign()).createSegmentOracle();
                        if (this.targetStorageTemplate != null) {
                            newTargetStorageTemplate.setTableSpace(this.targetStorageTemplate.getTableSpace());
                            this.targetStorageTemplate.copySegmentProperties(newTargetStorageTemplate);
                        }
                    }
                    if (ph.getName().equals(PCT_FREE)) {
                        newTargetStorageTemplate.setPCTFree(this.sourceStorageTemplate.getPCTFree());
                        continue;
                    }
                    if (ph.getName().equals(PCT_USED)) {
                        newTargetStorageTemplate.setPCTUsed(this.sourceStorageTemplate.getPCTUsed());
                        continue;
                    }
                    if (ph.getName().equals(INIT_TRANS)) {
                        newTargetStorageTemplate.setInitrans(this.sourceStorageTemplate.getInitrans());
                        continue;
                    }
                    if (ph.getName().equals(MAX_TRANS)) {
                        newTargetStorageTemplate.setMaxTrans(this.sourceStorageTemplate.getMaxTrans());
                        continue;
                    }
                    if (ph.getName().equals(SC_INITIAL_EXTENT)) {
                        newTargetStorageTemplate.setSCInitialExtent(this.sourceStorageTemplate.getSCInitialExtent());
                        continue;
                    }
                    if (ph.getName().equals(SC_NEXT_EXTENT)) {
                        newTargetStorageTemplate.setSCNextExtent(this.sourceStorageTemplate.getSCNextExtent());
                        continue;
                    }
                    if (ph.getName().equals(SC_MIN_EXTENTS)) {
                        newTargetStorageTemplate.setSCMinExtents(this.sourceStorageTemplate.getSCMinExtents());
                        continue;
                    }
                    if (ph.getName().equals(SC_MAX_EXTENTS)) {
                        newTargetStorageTemplate.setSCMaxExtents(this.sourceStorageTemplate.getSCMaxExtents());
                        continue;
                    }
                    if (ph.getName().equals(SC_PCT_INCREASE)) {
                        newTargetStorageTemplate.setSCPctIncrease(this.sourceStorageTemplate.getSCPctIncrease());
                        continue;
                    }
                    if (ph.getName().equals(SC_BUFFER_POOL)) {
                        newTargetStorageTemplate.setSCBufferPool(this.sourceStorageTemplate.getSCBufferPool());
                        continue;
                    }
                    if (ph.getName().equals(SC_FREE_LISTS)) {
                        newTargetStorageTemplate.setSCFreeLists(this.sourceStorageTemplate.getSCFreeLists());
                        continue;
                    }
                    if (!ph.getName().equals(SC_FREE_LISTS_GRPS)) continue;
                    newTargetStorageTemplate.setSCFreelistGroups(this.sourceStorageTemplate.getSCFreelistGroups());
                    continue;
                }
                if (ph.getName().equals(TABLESPACE)) continue;
                allStoTemplatePropsSelected = false;
            }
            try {
                if (newTargetStorageTemplate != null) {
                    newTargetStorageTemplate = ((StorageDesignOracle)this.targetObject.getStorageDesign()).getSegmentSet().findEqual(newTargetStorageTemplate);
                    this.templateSetter.invoke((Object)this.targetObject, newTargetStorageTemplate);
                } else if (allStoTemplatePropsSelected) {
                    this.templateSetter.invoke((Object)this.targetObject, newTargetStorageTemplate);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

