/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.AbstractMerging;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.NullStoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.metadata.ClassDescription;

public class LevelComparatorOracle
extends StoragePropertiesComparator {
    public static final String TABLE = LevelComparatorOracle.getPropertyNameOracle("LevelPropertyDialogOracle.Table");
    public static final String LEVEL_KEY = LevelComparatorOracle.getPropertyNameOracle("LevelPropertyDialogOracle.LevelKey");
    public static final String ATTRIBUTE_NAME = LevelComparatorOracle.getPropertyNameOracle("LevelPropertyDialogOracle.AttributeName");
    public static final String DETERMINED_COLUMNS = LevelComparatorOracle.getPropertyNameOracle("LevelPropertyDialogOracle.DeterminedColumns");
    private LevelOracle sourceLevel;
    private LevelOracle targetLevel;

    public LevelComparatorOracle(LevelOracle sourceLevel, LevelOracle targetLevel) {
        super(sourceLevel, targetLevel);
        this.sourceLevel = sourceLevel;
        this.targetLevel = targetLevel;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentProperty();
        this.initProperty(TABLE, "levelTable");
        PropertyHolder ph = new PropertyHolder(LEVEL_KEY);
        String leftColumnNames = this.getColumnNames(this.sourceLevel);
        String rightColumnNames = this.getColumnNames(this.targetLevel);
        ph.setLeftValue(leftColumnNames);
        ph.setRightValue(rightColumnNames);
        if (this.isExcludedFromComparison(LEVEL_KEY)) {
            ph.setExcluded(true);
        } else if (this.sourceLevel != null && this.targetLevel != null && !leftColumnNames.equals(rightColumnNames)) {
            ph.setModified(true);
            ph.setSelected(true);
            if (this.classDescr != null) {
                ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("columns");
                ph.setPropertyDescription(propDescr);
            }
        }
        this.propertiesList.add(ph);
        this.initAttributeProperties();
    }

    private void initAttributeProperties() {
        DimensionAttributeOracle sourceAtt;
        DimensionAttributeOracle targetAtt = this.targetLevel != null ? this.targetLevel.getLevelAttribute() : null;
        DimensionAttributeOracle dimensionAttributeOracle = sourceAtt = this.sourceLevel != null ? this.sourceLevel.getLevelAttribute() : null;
        if (targetAtt != null) {
            new NullStoragePropertiesComparator(sourceAtt, targetAtt);
        }
        PropertyHolder ph = new PropertyHolder(ATTRIBUTE_NAME);
        String leftAttributeName = sourceAtt != null ? sourceAtt.getName() : "";
        String rightAttributeName = targetAtt != null ? targetAtt.getName() : "";
        ph.setLeftValue(leftAttributeName);
        ph.setRightValue(rightAttributeName);
        if (this.isExcludedFromComparison(ATTRIBUTE_NAME)) {
            ph.setExcluded(true);
        } else if (this.sourceLevel != null && this.targetLevel != null && !leftAttributeName.equals(rightAttributeName)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(DETERMINED_COLUMNS);
        String leftColumns = this.getDeterminedColumnNames(sourceAtt);
        String rightColumns = this.getDeterminedColumnNames(targetAtt);
        ph.setLeftValue(leftColumns);
        ph.setRightValue(rightColumns);
        if (this.isExcludedFromComparison(DETERMINED_COLUMNS)) {
            ph.setExcluded(true);
        } else if (this.sourceLevel != null && this.targetLevel != null && !leftColumns.equals(rightColumns)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    private String getDeterminedColumnNames(DimensionAttributeOracle att) {
        String names = "";
        if (att != null) {
            boolean first = true;
            for (String columnId : att.getColumnSet()) {
                RelationalObjectProxy columnProxy = att.getStorageDesign().getColumnProxySet().getProxy(columnId);
                if (columnProxy == null) continue;
                if (first) {
                    first = false;
                    names = columnProxy.getName();
                    continue;
                }
                names = names + ", " + columnProxy.getName();
            }
        }
        return names;
    }

    private String getColumnNames(LevelOracle level) {
        String columnNames = "";
        if (level != null) {
            boolean first = true;
            for (String columnId : level.getColumnSet()) {
                RelationalObjectProxy colProxy = level.getStorageDesign().getColumnProxySet().getProxy(columnId);
                if (colProxy == null) continue;
                if (first) {
                    first = false;
                    columnNames = colProxy.getName();
                    continue;
                }
                columnNames = columnNames + ", " + colProxy.getName();
            }
        }
        return columnNames;
    }

    @Override
    public List<ClassDescription.PropertyDescription> getPropsToMerge() {
        if (this.targetLevel != null) {
            for (EngPropertyHolder ph : this.getPropertiesList()) {
                DimensionAttributeOracle sourceAtt;
                if (!ph.isSelected() || !ph.getName().equals(ATTRIBUTE_NAME) && !ph.getName().equals(DETERMINED_COLUMNS) || (sourceAtt = this.sourceLevel.getLevelAttribute()) == null) continue;
                DimensionAttributeOracle targetAtt = this.targetLevel.getLevelAttribute();
                if (targetAtt == null) {
                    targetAtt = this.targetLevel.getStorageDesignOracle().getDimensionAttributeSet().createDimensionAttribute();
                    targetAtt.setLevel(this.targetLevel);
                }
                if (ph.getName().equals(ATTRIBUTE_NAME)) {
                    targetAtt.setName(sourceAtt.getName());
                    targetAtt.setNameHasQuotes(sourceAtt.getNameHasQuotes());
                    continue;
                }
                String targetColumnIds = "";
                Iterator colIt = sourceAtt.getColumnSet().iterator();
                while (colIt.hasNext()) {
                    RelationalObjectProxy columnProxy;
                    Object targetCol = AbstractMerging.getObjectsMap().get(colIt.next());
                    if (targetCol == null || (columnProxy = this.targetLevel.getStorageDesign().getColumnProxySet().getProxy(((ModelIDObject)targetCol).getObjectID())) == null) continue;
                    String columnProxyId = columnProxy.getObjectID();
                    if (targetColumnIds.isEmpty()) {
                        targetColumnIds = columnProxyId;
                        continue;
                    }
                    targetColumnIds = targetColumnIds + "," + columnProxyId;
                }
                targetAtt.recreateColumnSet(targetColumnIds);
            }
        }
        return super.getPropsToMerge();
    }
}

