/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBSnapshotOraclev10g;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBTableOraclev10g;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SnapshotOraclev10g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class CSSBSnapshotOraclev10g
extends AbstractCSSBOracle {
    protected Map fkList;
    protected SSBSnapshotOraclev10g ssbSnapshotOracle;

    public CSSBSnapshotOraclev10g(Map fkList) {
        this.fkList = fkList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        PropertiesComparator propsComp;
        CompareObjectSelection topNode;
        CompareObjectSelection tablesNode;
        CompareObjectSelection tTableSel;
        Table tTable;
        CompareObjectSelection sSnapSel = (CompareObjectSelection)object;
        CompareObjectSelection tSnapSel = sSnapSel.getCorrespondentNode();
        SnapshotOraclev10g tSnapshot = (SnapshotOraclev10g)tSnapSel.getObject();
        TableProxyOracle tTableProxy = null;
        if (tSnapshot != null && (tTableProxy = tSnapshot.getOnPrebuildTable()) == null) {
            tTableProxy = tSnapshot.getImplementedTable();
        }
        CompareObjectSelection sTableSel = null;
        Table table = tTable = tTableProxy != null ? (Table)tTableProxy.getObject() : null;
        if (tTable != null && (tTableSel = (tablesNode = (CompareObjectSelection)(topNode = tSnapSel.getTableNode()).getChild(1)).getChild(tTable)) != null) {
            sTableSel = (TableSelection)tTableSel.getCorrespondentNode();
        }
        boolean snapshotDropped = false;
        if (sTableSel != null && (propsComp = sTableSel.getPropertiesComparator()) instanceof TableComparator) {
            snapshotDropped = ((TableComparator)propsComp).isSnapshotDropped();
        }
        boolean recreateMV = snapshotDropped;
        if (sSnapSel.isSelected() && (sSnapSel.canBeCreate() || sSnapSel.isDDLModified())) {
            recreateMV = true;
        } else if (sTableSel != null && sTableSel.isSelected()) {
            List tableChildNodes;
            PropertiesComparator tableComp = sTableSel.getPropertiesComparator();
            if (tableComp != null) {
                for (EngPropertyHolder ph : tableComp.getPropertiesList()) {
                    if (!ph.isSelected() || !ph.getName().equals(PropertyNames.NAME) && !ph.getName().equals(PropertyNames.STRUCTURED_TYPE) && !ph.getName().equals(PropertyNames.COLUMNS_ORDER) && !ph.getName().equals(PropertyNames.MATERIALIZED_QUERY) && !ph.getName().equals(PropertyNames.ON_PREBUILT_TABLE) && !ph.getName().equals(PropertyNames.MATERIALIZED_QUERY_TABLE)) continue;
                    recreateMV = true;
                    break;
                }
            }
            if (!recreateMV && (tableChildNodes = sTableSel.getChilds()).size() > 0) {
                CompareObjectSelection columnsSel = (CompareObjectSelection)tableChildNodes.get(0);
                block4: for (CompareObjectSelection columnSel : columnsSel.getChilds()) {
                    PropertiesComparator propsComp2;
                    if (!columnSel.isSelected() || (propsComp2 = columnSel.getPropertiesComparator()) == null) continue;
                    for (EngPropertyHolder ph : propsComp2.getPropertiesList()) {
                        if (!ph.getName().equals(PropertyNames.NAME)) continue;
                        if (!ph.isSelected()) continue block4;
                        recreateMV = true;
                        continue block4;
                    }
                }
            }
        }
        if (recreateMV) {
            SnapshotOraclev10g sSnapshot = (SnapshotOraclev10g)sSnapSel.getObject();
            if (!sSnapSel.canBeCreate() && tSnapshot != null) {
                String advancedComment;
                StorageDesignOracle tStorageDesign = (StorageDesignOracle)tSnapshot.getStorageDesign();
                StringBuffer dropbuffer = new StringBuffer();
                if (!snapshotDropped) {
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "DROP");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "MATERIALIZED");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "VIEW");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, tStorageDesign.getFormatedLongNameDDL(tSnapshot));
                    advancedComment = dropbuffer.toString();
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "PRESERVE TABLE");
                    this.appendToBuffer(oldbuffer, dropbuffer, advancedComment);
                    CSSBSnapshotOraclev10g.appendNewLine(dropbuffer, prettyPrint, 0);
                    CSSBSnapshotOraclev10g.appendLineFinisher(dropbuffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, dropbuffer, advancedComment);
                    CDDLFileMaker.incrementDropSnapshot();
                }
                if (sSnapshot.getOnPrebuildTable() == null) {
                    this.appendDropFKs(tTableProxy, tStorageDesign, dropbuffer, prettyPrint);
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "DROP");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "TABLE");
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, tStorageDesign.getFormatedLongNameDDL(tSnapshot));
                    advancedComment = dropbuffer.toString();
                    CSSBSnapshotOraclev10g.appendStringWithSpace(dropbuffer, "CASCADE CONSTRAINTS");
                    this.appendToBuffer(oldbuffer, dropbuffer, advancedComment);
                    CSSBSnapshotOraclev10g.appendNewLine(dropbuffer, prettyPrint, 0);
                    CSSBSnapshotOraclev10g.appendLineFinisher(dropbuffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, dropbuffer, advancedComment);
                    CDDLFileMaker.incrementDropTable();
                }
            }
            boolean oldMarkedGen = sSnapshot.isMarkedGenerate();
            DDLAdvancedGenerator oldGen = DDLFileMaker.getddlAdvancedGenenerator();
            try {
                sSnapshot.setMarkedGenerate(true);
                DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                SSBSnapshotOraclev10g ssbSnapshotOracle = this.getSSBSnapshotOracle();
                ssbSnapshotOracle.doAppend(oldbuffer, sSnapshot, prettyPrint);
            }
            finally {
                sSnapshot.setMarkedGenerate(oldMarkedGen);
                DDLFileMaker.setddlAdvancedGenenerator(oldGen);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof SnapshotOraclev10g;
    }

    private void appendDropFKs(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, StringBuffer oldbuffer, boolean prettyPrint) {
        Table table = (Table)tableProxy.getObject();
        Iterator it = storageDesign.getFKProxySet().iterator();
        while (it.hasNext()) {
            FKProxyOracle fk = (FKProxyOracle)it.next();
            FKIndexAssociation fkind = fk.getIndex().getFKAssociation();
            if (this.fkList.get(fkind.getObjectID()) != null || this.fkList.get(fk.getObjectID()) != null || fk.getFKTable() != table && fk.getTable() != table) continue;
            this.appendDropObject((TableProxyOracle)fk.getTableProxy(), storageDesign.getFormatedName(fk), storageDesign, oldbuffer, prettyPrint);
            this.fkList.put(fkind.getObjectID(), tableProxy);
        }
    }

    private void appendDropObject(TableProxyOracle tableProxy, String name, StorageDesignOracle storageDesign, StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "ALTER");
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "TABLE");
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(tableProxy));
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "DROP");
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, name);
        String advancedComment = buffer.toString();
        CSSBSnapshotOraclev10g.appendStringWithSpace(buffer, "CASCADE");
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBSnapshotOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        CSSBSnapshotOraclev10g.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendAfterAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
        CDDLFileMaker.incrementAlterTable();
    }

    protected SSBSnapshotOraclev10g getSSBSnapshotOracle() {
        if (this.ssbSnapshotOracle == null) {
            this.ssbSnapshotOracle = new SSBSnapshotOraclev10g();
            this.ssbSnapshotOracle.setSSBTableOraclev10g(new SSBTableOraclev10g());
        }
        return this.ssbSnapshotOracle;
    }
}

