/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.Collection;
import javax.swing.JDialog;
import oracle.dbtools.crest.model.MDUser;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChange;
import oracle.dbtools.crest.model.persistence.PersistenceManager;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;

public abstract class AbstractDesign
extends ModelIDObject {
    private boolean visible = false;
    private boolean isDialogVisible = false;
    private JDialog propsDialog = null;
    private String notes = "";
    private ObjectChange creation = new ObjectChange();
    private ObjectChange change = new ObjectChange();

    public boolean existsInRepository() {
        XMLPersistenceManager pm = this.getAppView().getPersistenceManager();
        String[] array = ((PersistenceManager)pm).getLocationAndNameFor(this);
        String location = array[0];
        String name = array[1];
        return ((PersistenceManager)pm).exists(location, name);
    }

    public abstract String getFileName();

    public abstract Collection getAllTopLevelObjects();

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void closePropertiesDialog() {
        if (this.propsDialog != null) {
            try {
                this.propsDialog.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public JDialog getPropertiesDialog() {
        return this.propsDialog;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isDesign() {
        return false;
    }

    public final boolean isStorageDesign() {
        return !this.isDesign();
    }

    public abstract String[] getImportedDesignNames();

    @Override
    public boolean isDialogVisible() {
        if (this.isDialogVisible && this.propsDialog != null) {
            this.propsDialog.toFront();
        }
        return this.isDialogVisible;
    }

    @Override
    public void setDialogVisible(boolean isDialogVisible, JDialog dialog) {
        this.isDialogVisible = isDialogVisible;
        this.propsDialog = dialog;
    }

    @Override
    public void setNotes(String notes) {
        if (this.isWriteable()) {
            this.notes = notes != null ? notes : "";
        }
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public String getObjectID() {
        return this.id;
    }

    @Override
    public void setObjectID(String id) {
        this.id = id;
    }

    @Override
    public ObjectChange getCreation() {
        return this.creation;
    }

    @Override
    public String getCreationTime() {
        return this.getCreation().getTimeString();
    }

    @Override
    public MDUser getCreator() {
        return this.getCreation().getUser();
    }

    @Override
    public ObjectChange getChange() {
        return this.change;
    }

    @Override
    public MDUser getChanger() {
        return this.getChange().getUser();
    }

    @Override
    public String getChangeTime() {
        return this.getChange().getTimeString();
    }
}

