/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOType
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "TYPE";
    public static final String OBJECT_TYPE_COLLECTION = "COLLECTION TYPE";
    public static final String OBJECT_TYPE_STRUCTURE = "STRUCTURED TYPE";
    public List collectionTypes = new ArrayList();
    public List structuredTypes = new ArrayList();
    private static final Logger LOGGER = new Logger(ODOType.class);
    PreparedStatement attr_statement;
    PreparedStatement m_statement;
    PreparedStatement ma_statement;
    PreparedStatement mb_statement;

    public ODOType(ODExtractionHandler odExtractionHandler, ApplicationView view) {
        super(odExtractionHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List appSystems) throws Exception {
        ArrayList list = new ArrayList();
        list.addAll(this.extractCollectionTypes(sqlConnection, appSystems));
        list.addAll(this.extractStructuredTypes(sqlConnection, appSystems));
        return list;
    }

    public List extractCollectionTypes(Connection sqlConnection, List appSystems) throws Exception {
        Statement nvstatement = null;
        Statement statement = null;
        ArrayList<ODObject> list = new ArrayList<ODObject>();
        for (ODObject odNext : appSystems) {
            ODObject odTable;
            String ivid;
            String id;
            String tableName;
            StringBuffer buffer;
            ResultSet rs;
            if (!odNext.isSelected()) continue;
            if (odNext.branches.size() == 0) {
                rs = null;
                if (nvstatement == null) {
                    buffer = new StringBuffer();
                    buffer.append("select  a.NAME,a.ID,a.ivid    ");
                    buffer.append("from CI_ORACLE_COLLECTION_TYPES a,sdd_folder_members b , i$sdd_wa_context cc ");
                    buffer.append("where ");
                    buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                    buffer.append(" and b.PARENT_IVID = ? ");
                    buffer.append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    buffer.append(" order by name ");
                    nvstatement = sqlConnection.prepareStatement(buffer.toString());
                }
                try {
                    nvstatement.setString(1, odNext.getIrid());
                    nvstatement.setString(2, odNext.ivid);
                    nvstatement.setString(3, odNext.wa_irid);
                    rs = nvstatement.executeQuery();
                }
                catch (SQLException e) {
                    LOGGER.error("ODOCollectionType.extract(): " + e.getMessage());
                }
                if (rs == null) continue;
                while (rs.next()) {
                    tableName = rs.getString(1);
                    id = rs.getString(2);
                    ivid = rs.getString(3);
                    odTable = new ODObject(true, tableName, OBJECT_TYPE_COLLECTION, id);
                    odTable.ivid = ivid;
                    odTable.setParentName(odNext.getName());
                    odTable.setParentID(odNext.getIrid());
                    list.add(odTable);
                }
                rs.close();
                continue;
            }
            if (odNext.branch == null) continue;
            rs = null;
            if (statement == null) {
                buffer = new StringBuffer();
                buffer.append("select  a.NAME,a.ID,a.ivid ");
                buffer.append("from CI_ORACLE_COLLECTION_TYPES a,sdd_folder_members b ");
                buffer.append("where ");
                buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                buffer.append(" and b.PARENT_IVID = ? ");
                buffer.append("AND EXISTS \n");
                buffer.append("(SELECT 1 \n");
                buffer.append("FROM CI_ORACLE_COLLECTION_TYPES F, \n");
                buffer.append("  I$sdd_Wa_Context C \n");
                buffer.append("WHERE a.Irid        = F.Irid \n");
                buffer.append("AND F.Ivid          = C.Object_Ivid \n");
                buffer.append("AND C.Workarea_Irid = ? \n");
                buffer.append(")");
                buffer.append(" and a.ivid = ");
                buffer.append(" (select ivid from i$sdd_object_versions v ");
                buffer.append("  where ");
                buffer.append("  a.id = v.irid and ");
                buffer.append("  branch_id = ? ");
                buffer.append("  and sequence_in_branch  is not null");
                buffer.append("  and wastebasket='N' ");
                buffer.append("  and sequence_in_branch = ");
                buffer.append("   ( ");
                buffer.append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                buffer.append("     where ");
                buffer.append("     v2.irid = a.id");
                buffer.append("     and branch_id = ? ");
                buffer.append("     and sequence_in_branch  is not null ");
                buffer.append("     and wastebasket='N' ");
                buffer.append("   ) ");
                buffer.append("  )");
                buffer.append(" order by name ");
                statement = sqlConnection.prepareStatement(buffer.toString());
            }
            try {
                statement.setString(1, odNext.getIrid());
                statement.setString(2, odNext.ivid);
                statement.setString(3, odNext.wa_irid);
                statement.setString(4, odNext.branch.getId());
                statement.setString(5, odNext.branch.getId());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOCollectionType.extract(): " + e.getMessage());
            }
            if (rs == null) continue;
            while (rs.next()) {
                tableName = rs.getString(1);
                id = rs.getString(2);
                ivid = rs.getString(3);
                odTable = new ODObject(true, tableName, OBJECT_TYPE_COLLECTION, id);
                odTable.ivid = ivid;
                odTable.branch = odNext.branch;
                odTable.setParentName(odNext.getName());
                odTable.setParentID(odNext.getIrid());
                list.add(odTable);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (nvstatement != null) {
            nvstatement.close();
        }
        return list;
    }

    public List extractStructuredTypes(Connection sqlConnection, List appSystems) throws Exception {
        Statement statement = null;
        ArrayList<ODObject> list = new ArrayList<ODObject>();
        for (ODObject odNext : appSystems) {
            ODObject odTable;
            String ivid;
            String id;
            String tableName;
            StringBuffer buffer;
            ResultSet rs;
            if (!odNext.isSelected()) continue;
            if (odNext.branches.size() == 0) {
                rs = null;
                if (statement == null) {
                    buffer = new StringBuffer();
                    buffer.append("select  a.NAME,a.ID,a.ivid    ");
                    buffer.append("from ci_oracle_object_types a,sdd_folder_members b , i$sdd_wa_context cc ");
                    buffer.append("where ");
                    buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                    buffer.append(" and b.PARENT_IVID = ? ");
                    buffer.append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    buffer.append(" order by name ");
                    statement = sqlConnection.prepareStatement(buffer.toString());
                }
                try {
                    statement.setString(1, odNext.getIrid());
                    statement.setString(2, odNext.ivid);
                    statement.setString(3, odNext.wa_irid);
                    rs = statement.executeQuery();
                }
                catch (SQLException e) {
                    LOGGER.error("ODOStructuredType.extract(): " + e.getMessage());
                }
                if (rs == null) continue;
                while (rs.next()) {
                    tableName = rs.getString(1);
                    id = rs.getString(2);
                    ivid = rs.getString(3);
                    odTable = new ODObject(true, tableName, OBJECT_TYPE_STRUCTURE, id);
                    odTable.ivid = ivid;
                    odTable.setParentName(odNext.getName());
                    odTable.setParentID(odNext.getIrid());
                    list.add(odTable);
                }
                rs.close();
                continue;
            }
            if (odNext.branch == null) continue;
            rs = null;
            if (statement == null) {
                buffer = new StringBuffer();
                buffer.append("select  a.NAME,a.ID,a.ivid ");
                buffer.append("from ci_oracle_object_types a,sdd_folder_members b ");
                buffer.append("where ");
                buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                buffer.append(" and b.PARENT_IVID = ? ");
                buffer.append("AND EXISTS \n");
                buffer.append("(SELECT 1 \n");
                buffer.append("FROM ci_oracle_object_types F, \n");
                buffer.append("  I$sdd_Wa_Context C \n");
                buffer.append("WHERE a.Irid        = F.Irid \n");
                buffer.append("AND F.Ivid          = C.Object_Ivid \n");
                buffer.append("AND C.Workarea_Irid = ? \n");
                buffer.append(")");
                buffer.append(" and a.ivid = ");
                buffer.append(" (select ivid from i$sdd_object_versions v ");
                buffer.append("  where ");
                buffer.append("  a.id = v.irid and ");
                buffer.append("  branch_id = ? ");
                buffer.append("  and sequence_in_branch  is not null");
                buffer.append("  and wastebasket='N' ");
                buffer.append("  and sequence_in_branch = ");
                buffer.append("   ( ");
                buffer.append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                buffer.append("     where ");
                buffer.append("     v2.irid = a.id");
                buffer.append("     and branch_id = ? ");
                buffer.append("     and sequence_in_branch  is not null ");
                buffer.append("     and wastebasket='N' ");
                buffer.append("   ) ");
                buffer.append("  )");
                buffer.append(" order by name ");
                statement = sqlConnection.prepareStatement(buffer.toString());
            }
            try {
                statement.setString(1, odNext.getIrid());
                statement.setString(2, odNext.ivid);
                statement.setString(3, odNext.wa_irid);
                statement.setString(4, odNext.branch.getId());
                statement.setString(5, odNext.branch.getId());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOStructuredType.extract(): " + e.getMessage());
            }
            if (rs == null) continue;
            while (rs.next()) {
                tableName = rs.getString(1);
                id = rs.getString(2);
                ivid = rs.getString(3);
                odTable = new ODObject(true, tableName, OBJECT_TYPE_STRUCTURE, id);
                odTable.ivid = ivid;
                odTable.branch = odNext.branch;
                odTable.setParentName(odNext.getName());
                odTable.setParentID(odNext.getIrid());
                list.add(odTable);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        this.attr_statement = null;
        this.m_statement = null;
        this.ma_statement = null;
        this.mb_statement = null;
        this.generateCollectionTypes(sqlConnection, selectedObjects, importLog);
        this.generateStructuredTypes(sqlConnection, selectedObjects, importLog);
        this.createCollectionTypes();
        this.createStructuredTypes();
        this.initCollectionTypesProperties(sqlConnection);
        this.initStructuredTypesProperties(sqlConnection, importLog);
        if (this.attr_statement != null) {
            this.attr_statement.close();
        }
        if (this.m_statement != null) {
            this.m_statement.close();
        }
        if (this.ma_statement != null) {
            this.ma_statement.close();
        }
        if (this.mb_statement != null) {
            this.mb_statement.close();
        }
    }

    private void createCollectionTypes() {
        for (DummyObject dummyObject : this.collectionTypes) {
            String id = (String)dummyObject.getProperty("ID");
            CollectionType collectionType = null;
            DesignObject obj = this.getDesign().getDesignObject(id);
            if (obj instanceof CollectionType) {
                collectionType = (CollectionType)obj;
            }
            if (collectionType == null) {
                collectionType = this.getDesign().getDataTypesDesign().createCollectionType();
                if (obj == null) {
                    collectionType.setObjectID(id);
                }
            }
            collectionType.setName((String)dummyObject.getProperty("NAME"));
            this.getExtractionHandler().addToImportedObjects(id, collectionType);
        }
    }

    private void createStructuredTypes() {
        for (DummyObject dummyObject : this.structuredTypes) {
            String id = (String)dummyObject.getProperty("ID");
            StructuredType structuredType = null;
            DesignObject obj = this.getDesign().getDesignObject(id);
            if (obj instanceof StructuredType) {
                structuredType = (StructuredType)obj;
            }
            if (structuredType == null) {
                structuredType = this.getDesign().getDataTypesDesign().createStructuredType();
                if (obj == null) {
                    structuredType.setObjectID(id);
                }
            }
            structuredType.setName((String)dummyObject.getProperty("NAME"));
            this.getExtractionHandler().addToImportedObjects(id, structuredType);
        }
    }

    private void initCollectionTypesProperties(Connection sqlConnection) throws Exception {
        for (DummyObject dummyObject : this.collectionTypes) {
            StructuredType st;
            CollectionType collectionType = (CollectionType)this.getExtractionHandler().getImportedObject((String)dummyObject.getProperty("ID"));
            String collectionOf = (String)dummyObject.getProperty("COLLECTION_OF");
            String colType = (String)dummyObject.getProperty("COLLECTION_TYPE");
            String objectRefFlag = (String)dummyObject.getProperty("OBJECT_REF_FLAG");
            String objectTypeRef = (String)dummyObject.getProperty("ORACLE_OBJECT_TYPE_REFERENCE");
            String scalarDatatype = (String)dummyObject.getProperty("SCALAR_DATATYPE");
            int scalarDecimalPlaces = (Integer)dummyObject.getProperty("SCALAR_DECIMAL_PLACES");
            int scalarMaxLength = (Integer)dummyObject.getProperty("SCALAR_MAXIMUM_LENGTH");
            int varrayLimit = (Integer)dummyObject.getProperty("VARRAY_LIMIT");
            if ("NESTED TABLE".equalsIgnoreCase(colType)) {
                collectionType.setCollectionType();
            } else {
                collectionType.setArrayType();
                collectionType.setMaxElement(varrayLimit);
            }
            if ("SCALAR".equalsIgnoreCase(collectionOf)) {
                String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(scalarDatatype);
                LogicalDatatype logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), nameDatatype);
                if (logDatatype != null) {
                    collectionType.getElementType().setType(logDatatype);
                    if (scalarDecimalPlaces > 0) {
                        collectionType.getElementType().setPrecision(scalarMaxLength);
                        collectionType.getElementType().setScale(scalarDecimalPlaces);
                    } else {
                        collectionType.getElementType().setSize(Integer.toString(scalarMaxLength));
                    }
                }
            } else if (objectTypeRef != null && (st = (StructuredType)this.getExtractionHandler().getImportedObject(objectTypeRef)) != null) {
                collectionType.getElementType().setType(st);
                if ("Y".equalsIgnoreCase(objectRefFlag)) {
                    collectionType.getElementType().setReference(true);
                }
            }
            this.setNotesAndComments(sqlConnection, collectionType, (String)dummyObject.getProperty("ID"), (String)dummyObject.getProperty("ivid"));
        }
    }

    private void initStructuredTypesProperties(Connection sqlConnection, ImportLogger importLog) throws Exception {
        for (DummyObject dummyObject : this.structuredTypes) {
            String stID = (String)dummyObject.getProperty("ID");
            String ivid = (String)dummyObject.getProperty("ivid");
            StructuredType st = (StructuredType)this.getExtractionHandler().getImportedObject(stID);
            this.setNotesAndComments(sqlConnection, st, stID, ivid);
            this.initStructuredTypeAttributes(sqlConnection, st, stID, importLog, ivid);
            this.initStructuredTypeMethods(sqlConnection, st, stID, ivid, (ODExtractionHandler.Branch)dummyObject.getProperty("branch"));
        }
    }

    private void initStructuredTypeAttributes(Connection sqlConnection, StructuredType st, String stID, ImportLogger importLog, String ivid) throws Exception {
        if (this.attr_statement == null) {
            String query = "SELECT c.name,c.id, c.DATATYPE, DECIMAL_PLACES,NULL_INDICATOR,c.MAXIMUM_LENGTH, OBJECT_TYPE_INCLUSION,ORACLE_TYPE_REFERENCE,c.REMARK from ci_columns c where c.parent_ivid = ?  order by  c.SEQUENCE_NUMBER";
            this.attr_statement = sqlConnection.prepareStatement(query);
        }
        ResultSet rs = null;
        try {
            this.attr_statement.setString(1, ivid);
            rs = this.attr_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOType.initStructuredTypeAttributes():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("NAME");
                String elmID = rs.getString("ID");
                String dataType = rs.getString("DATATYPE");
                String decimalPlaces = rs.getString("DECIMAL_PLACES");
                String maxLength = rs.getString("MAXIMUM_LENGTH");
                String objectTypeInclusion = rs.getString("OBJECT_TYPE_INCLUSION");
                String typeRef = rs.getString("ORACLE_TYPE_REFERENCE");
                String remark = rs.getString("REMARK");
                String mandatory = rs.getString("NULL_INDICATOR");
                int intMaxLength = 0;
                try {
                    intMaxLength = Integer.valueOf(maxLength);
                }
                catch (Exception e) {
                    // empty catch block
                }
                int intDecimalPlaces = 0;
                try {
                    intDecimalPlaces = Integer.valueOf(decimalPlaces);
                }
                catch (Exception e) {
                    // empty catch block
                }
                DesignObject objc = this.getDesign().getDesignObject(elmID);
                TypeElement typeElement = null;
                if (objc instanceof TypeElement) {
                    typeElement = (TypeElement)objc;
                }
                if (typeElement == null || typeElement.getStructuredType() != st) {
                    typeElement = new TypeElement(st.getDesignPart(), st);
                    if (objc == null) {
                        typeElement.setObjectID(elmID);
                    }
                }
                typeElement.setName(name);
                typeElement.setDesign(st.getDesign());
                typeElement.setComment(remark);
                st.add(typeElement);
                if (typeRef != null) {
                    DesignObject type = (DesignObject)this.getExtractionHandler().getImportedObject(typeRef);
                    if (type != null) {
                        typeElement.setType(type);
                        if ("REF".equalsIgnoreCase(objectTypeInclusion)) {
                            typeElement.setReference(true);
                        }
                    } else {
                        importLog.addWarning("Oracle Type: '" + typeRef + "' is not imported");
                    }
                } else if (dataType != null) {
                    String datatype;
                    LogicalDatatype logDatatype;
                    String datatype2;
                    String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(dataType);
                    if ("UNKNOWN".equalsIgnoreCase(nameDatatype) && (datatype2 = MappingDatatypeNameLogicalDataType.getDesignerMappedName(dataType)) != null) {
                        nameDatatype = datatype2;
                        dataType = datatype2;
                    }
                    if ((logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), nameDatatype)) == null && (datatype = MappingDatatypeNameLogicalDataType.getDesignerMappedName(nameDatatype)) != null) {
                        nameDatatype = datatype;
                        dataType = datatype;
                        logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), nameDatatype.toUpperCase());
                    }
                    if (logDatatype != null) {
                        typeElement.setType(logDatatype);
                        if (dataType.toUpperCase().indexOf("CHAR") <= -1) {
                            if (dataType.toUpperCase().indexOf("TIMESTAMP") > -1) {
                                if (decimalPlaces != null) {
                                    typeElement.setPrecision(intDecimalPlaces);
                                }
                            } else {
                                if (maxLength != null) {
                                    typeElement.setPrecision(intMaxLength);
                                }
                                if (decimalPlaces != null) {
                                    typeElement.setScale(intDecimalPlaces);
                                }
                            }
                        } else if (maxLength != null) {
                            typeElement.setSize(maxLength);
                        }
                    } else {
                        LOGGER.warn("ODOType.initStructuredTypeAttributes() - Unable to find Logical DataType for: " + dataType);
                    }
                }
                typeElement.updateReference();
                if ("NOT NULL".equalsIgnoreCase(mandatory)) {
                    typeElement.setMandatory(true);
                }
                this.setNotesAndComments(sqlConnection, typeElement, elmID, ivid);
            }
            rs.close();
        }
    }

    private void initStructuredTypeMethods(Connection sqlConnection, StructuredType st, String stID, String ivid, ODExtractionHandler.Branch branch) throws Exception {
        ResultSet rs = null;
        try {
            String query;
            if (branch == null) {
                if (this.m_statement == null) {
                    query = "SELECT  m.NAME, m.ID, RETURN_TYPE,m.ivid from CI_MODULE_NETWORKS b, ci_modules m where b.CHILD_MODULE_REFERENCE = m.id and b.parent_ivid = ? ";
                    this.m_statement = sqlConnection.prepareStatement(query);
                }
                this.m_statement.setString(1, ivid);
            } else {
                if (this.m_statement == null) {
                    query = "SELECT  m.NAME, m.ID, RETURN_TYPE,m.ivid from CI_MODULE_NETWORKS b, ci_modules m where b.CHILD_MODULE_REFERENCE = m.id and b.parent_ivid = ? ";
                    StringBuffer buffer = new StringBuffer(query);
                    buffer.append("  and m.ivid = ");
                    buffer.append("(select ivid from i$sdd_object_versions v ");
                    buffer.append("  where ");
                    buffer.append("  v.irid = m.id");
                    buffer.append("  and branch_id = ? ");
                    buffer.append("  and sequence_in_branch  is not null ");
                    buffer.append("  and wastebasket='N' ");
                    buffer.append("  and sequence_in_branch = ");
                    buffer.append("   ( ");
                    buffer.append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                    buffer.append("     where ");
                    buffer.append("     v2.irid = m.id");
                    buffer.append("     and branch_id = ? ");
                    buffer.append("     and sequence_in_branch  is not null ");
                    buffer.append("     and wastebasket='N' ");
                    buffer.append("   ) )");
                    this.m_statement = sqlConnection.prepareStatement(buffer.toString());
                }
                this.m_statement.setString(1, ivid);
                this.m_statement.setString(2, branch.getId());
                this.m_statement.setString(3, branch.getId());
            }
            rs = this.m_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOType.initStructuredTypeMethods():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("NAME");
                String returnType = rs.getString("RETURN_TYPE");
                String methodID = rs.getString("ID");
                String methodIVID = rs.getString("ivid");
                DesignObject objc = this.getDesign().getDesignObject(methodID);
                Method method = null;
                if (objc instanceof Method) {
                    method = (Method)objc;
                }
                if (method == null || method.getStructuredType() != st) {
                    method = new Method(st.getDesignPart(), st);
                    if (objc == null) {
                        method.setObjectID(methodID);
                    }
                }
                method.setName(name);
                method.setDesign(st.getDesign());
                st.addMethod(method);
                if (returnType != null) {
                    String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(returnType);
                    LogicalDatatype logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), nameDatatype);
                    if (logDatatype != null) {
                        MethodParam param = new MethodParam(st.getDesignPart());
                        param.setType(logDatatype);
                        method.setReturnValue(param);
                    } else {
                        LOGGER.warn("ODOType.initStructuredTypeMethods() - Unable to find Logical DataType for: " + returnType);
                    }
                }
                this.initMethodArguments(sqlConnection, method, methodID, methodIVID);
                this.setMethodBody(sqlConnection, method, methodID, methodIVID);
                this.setNotesAndComments(sqlConnection, method, methodID, methodIVID);
            }
            rs.close();
        }
    }

    private void initMethodArguments(Connection sqlConnection, Method method, String methodID, String mivid) throws Exception {
        if (this.ma_statement == null) {
            String query = "SELECT a.NAME,a.DATATYPE, DOMAIN_REFERENCE, LENGTH, SCALE from ci_module_arguments a where PLSQL_MODULE_REFERENCE = ?  and parent_ivid = ? order by position";
            this.ma_statement = sqlConnection.prepareStatement(query);
        }
        ResultSet rs = null;
        try {
            this.ma_statement.setString(1, methodID);
            this.ma_statement.setString(2, mivid);
            rs = this.ma_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOType.initMethodArguments():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("NAME");
                String dataType = rs.getString("DATATYPE");
                String domainRef = rs.getString("domain_reference");
                int length = rs.getInt("LENGTH");
                int scale = rs.getInt("SCALE");
                MethodParam mp = new MethodParam(method.getDesignPart());
                mp.setName(name);
                mp.setDesign(method.getDesign());
                if (domainRef != null) {
                    Domain domain = (Domain)this.getExtractionHandler().getImportedObject(domainRef);
                    mp.setType(domain.getLogicalDatatype());
                    mp.setSize(domain.getSize());
                    try {
                        mp.setScale(Integer.parseInt(domain.getScale()));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    try {
                        mp.setPrecision(Integer.parseInt(domain.getPrecision()));
                    }
                    catch (NumberFormatException e) {}
                } else {
                    String datatype;
                    LogicalDatatype logDatatype;
                    String datatype2;
                    String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(dataType);
                    if ("UNKNOWN".equalsIgnoreCase(nameDatatype) && (datatype2 = MappingDatatypeNameLogicalDataType.getDesignerMappedName(dataType)) != null) {
                        nameDatatype = datatype2;
                        dataType = datatype2;
                    }
                    if ((logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), nameDatatype)) == null && (datatype = MappingDatatypeNameLogicalDataType.getDesignerMappedName(nameDatatype)) != null) {
                        nameDatatype = datatype;
                        dataType = datatype;
                        logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), nameDatatype);
                    }
                    if (logDatatype != null) {
                        mp.setType(logDatatype);
                        if (dataType.toUpperCase().indexOf("CHAR") <= -1) {
                            if (scale >= 0) {
                                mp.setPrecision(length);
                            }
                            mp.setScale(scale);
                        } else {
                            mp.setSize(Integer.toString(length));
                        }
                    } else {
                        LOGGER.warn("ODOType.initMethodArguments() - Unable to find Logical DataType for: " + dataType);
                    }
                }
                method.addParameter(mp);
            }
            rs.close();
        }
    }

    public void generateCollectionTypes(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Statement statement = null;
        for (ODObject odObject : selectedObjects) {
            if (!OBJECT_TYPE_COLLECTION.equalsIgnoreCase(odObject.getType())) continue;
            String ivid = odObject.ivid;
            if (statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("NAME").append(',');
                buffer.append("COLLECTION_OF").append(',');
                buffer.append("COLLECTION_TYPE").append(',');
                buffer.append("a.").append("ID").append(',');
                buffer.append("OBJECT_REF_FLAG").append(',');
                buffer.append("ORACLE_OBJECT_TYPE_REFERENCE").append(',');
                buffer.append("SCALAR_DATATYPE").append(',');
                buffer.append("SCALAR_DECIMAL_PLACES").append(',');
                buffer.append("SCALAR_MAXIMUM_LENGTH").append(',');
                buffer.append("VARRAY_LIMIT").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append("CI_ORACLE_COLLECTION_TYPES").append(' ').append("a").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("a.").append("ivid").append('=').append(" ? ");
                statement = sqlConnection.prepareStatement(buffer.toString());
            }
            ResultSet rs = null;
            try {
                statement.setString(1, ivid);
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOType.generateCollectionTypes():", e);
            }
            if (rs != null && rs.next()) {
                String collectionOf = rs.getString("COLLECTION_OF");
                String collectionType = rs.getString("COLLECTION_TYPE");
                String objectRefFlag = rs.getString("OBJECT_REF_FLAG");
                String objectTypeRef = rs.getString("ORACLE_OBJECT_TYPE_REFERENCE");
                String scalarDatatype = rs.getString("SCALAR_DATATYPE");
                int scalarDecimalPlaces = rs.getInt("SCALAR_DECIMAL_PLACES");
                int scalarMaxLength = rs.getInt("SCALAR_MAXIMUM_LENGTH");
                int varrayLimit = rs.getInt("VARRAY_LIMIT");
                DummyObject dummyObject = new DummyObject();
                dummyObject.setProperty("NAME", odObject.getName());
                dummyObject.setProperty("ID", odObject.getIrid());
                dummyObject.setProperty("ivid", ivid);
                dummyObject.setProperty("COLLECTION_OF", collectionOf);
                dummyObject.setProperty("COLLECTION_TYPE", collectionType);
                dummyObject.setProperty("OBJECT_REF_FLAG", objectRefFlag);
                dummyObject.setProperty("ORACLE_OBJECT_TYPE_REFERENCE", objectTypeRef);
                dummyObject.setProperty("SCALAR_DATATYPE", scalarDatatype);
                dummyObject.setProperty("SCALAR_DECIMAL_PLACES", new Integer(scalarDecimalPlaces));
                dummyObject.setProperty("SCALAR_MAXIMUM_LENGTH", new Integer(scalarMaxLength));
                dummyObject.setProperty("VARRAY_LIMIT", new Integer(varrayLimit));
                this.collectionTypes.add(dummyObject);
            }
            importLog.incrementImportedStatements();
        }
        if (statement != null) {
            statement.close();
        }
    }

    public void generateStructuredTypes(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (ODObject odObject : selectedObjects) {
            if (!OBJECT_TYPE_STRUCTURE.equalsIgnoreCase(odObject.getType())) continue;
            DummyObject dummyObject = new DummyObject();
            dummyObject.setProperty("NAME", odObject.getName());
            dummyObject.setProperty("ID", odObject.getIrid());
            dummyObject.setProperty("ivid", odObject.ivid);
            if (odObject.branch != null) {
                dummyObject.setProperty("branch", odObject.branch);
            }
            this.structuredTypes.add(dummyObject);
            importLog.incrementImportedStatements();
        }
    }

    protected void setMethodBody(Connection sqlConnection, Method method, String methodID, String mivid) throws Exception {
        if (this.mb_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_type").append(',');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TXT_REF").append(" = ? ");
            buffer.append(" and parent_ivid = ? ");
            buffer.append(" and txt_type = 'CDIPLS'");
            buffer.append(" order by txt_seq");
            this.mb_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.mb_statement.setString(1, methodID);
            this.mb_statement.setString(2, mivid);
            rs = this.mb_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOType.setMethodBody():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String txtType = rs.getString("txt_type");
                String txtText = rs.getString("txt_text");
                if (!"CDIPLS".equalsIgnoreCase(txtType)) continue;
                String body = method.getBody();
                if (body == null || "".equalsIgnoreCase(body)) {
                    method.setBody(txtText);
                    continue;
                }
                method.setBody(body + txtText);
            }
            rs.close();
        }
    }

    private class DummyObject {
        private Map map = new TreeMap();

        private DummyObject() {
        }

        public void setProperty(Object key, Object value) {
            this.map.put(key, value);
        }

        public Object getProperty(Object key) {
            return this.map.get(key);
        }
    }
}

