/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSynonymOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SYNONYM";
    private static final Logger LOGGER = new Logger(MOHSynonymOracle.class);
    protected boolean dbaUser;

    public MOHSynonymOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHSynonymOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract Synonym begin");
        Statement statement = null;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        TreeMap<String, DBObject> map = new TreeMap<String, DBObject>();
        ArrayList cschemas = new ArrayList(schemas);
        for (DBObject dboNext : cschemas) {
            if (!dboNext.isSelected()) continue;
            if (statement == null) {
                String filterCondition = this.getFilterConditionOracle("SYNONYM_NAME");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("SYNONYM_NAME").append(',');
                buffer.append("TABLE_OWNER").append(',');
                buffer.append("TABLE_NAME").append(',');
                buffer.append("DB_LINK").append(',');
                buffer.append("OWNER").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? DBA_SYNONYMS : ALL_SYNONYMS).append(' ');
                buffer.append("WHERE").append(' ').append('(').append("OWNER").append('=').append('?').append(' ');
                buffer.append("OR").append(' ').append("TABLE_OWNER").append('=').append('?').append(')').append(' ');
                if (filterCondition != null) {
                    buffer.append("AND").append(' ').append(filterCondition).append(' ');
                }
                buffer.append("ORDER BY").append(' ').append("SYNONYM_NAME");
                String sql = buffer.toString();
                statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, dboNext.getName());
                statement.setString(2, dboNext.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                System.out.println("MOHSynonymOracle.extract(): " + e.getMessage());
                LOGGER.error("MOHSynonymOracle.extract():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                String sName = rs.getString(1);
                String table_owner = rs.getString(2);
                String table_name = rs.getString(3);
                String db_link = rs.getString(4);
                String syn_owner = rs.getString(5);
                DBObject dboSynonym = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), sName, OBJECT_TYPE, syn_owner);
                String key = dboSynonym.toString();
                Object dbo = map.get(key);
                if (dbo != null) continue;
                map.put(key, dboSynonym);
                DescSyn ds = new DescSyn();
                ds.tablename = table_name;
                ds.tableowner = table_owner;
                ds.dblink = db_link;
                dboSynonym.setDescrptiveObject(ds);
                list.add(dboSynonym);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        map.clear();
        TimeLog.log("Extract Synonym end");
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
        TimeLog.log("Synonyms begin");
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            if (storageDesign != null) {
                UserOracle user;
                SynonymOracle synonym = storageDesign.getSynonymSet().createSynonym();
                String name = dbo.getName();
                String owner = dbo.getSchema();
                if ("PUBLIC".equalsIgnoreCase(owner)) {
                    synonym.setPublic("YES");
                }
                this.setUser(synonym, storageDesign, owner);
                synonym.setName(name);
                if (!name.equals(name.toUpperCase())) {
                    synonym.setNameHasQuotes(true);
                }
                DescSyn ds = (DescSyn)dbo.getDescrptiveObject();
                synonym.setDBLink(ds.dblink);
                synonym.setObject(ds.tablename);
                if (!ds.tablename.equals(ds.tablename.toUpperCase())) {
                    synonym.setObjNameHasQuotes(true);
                }
                if ((user = (UserOracle)storageDesign.getUserSet().getByName(ds.tableowner)) == null) {
                    user = (UserOracle)storageDesign.getUserSet().createElement(null);
                    user.setName(ds.tableowner);
                    this.stampModelObject((ModelObject)user, "", ds.tableowner);
                }
                synonym.setObjectUser(user);
                this.stampModelObject(synonym, dbo);
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        TimeLog.log("Synonyms end");
    }

    private void setUser(SynonymOracle synonym, StorageDesignOracle storageDesign, String userName) {
        UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(userName);
        if (user == null && !"PUBLIC".equalsIgnoreCase(userName)) {
            user = (UserOracle)storageDesign.getUserSet().createElement(null);
            user.setName(userName);
            this.stampModelObject((ModelObject)user, "", userName);
        }
        synonym.setUser(user);
    }

    public static String getSynonymObjectName(DBObject dbo) {
        DescSyn ds = (DescSyn)dbo.getDescrptiveObject();
        if (ds != null) {
            return ds.tablename;
        }
        return "";
    }

    public static String getSynonymObjectOwner(DBObject dbo) {
        DescSyn ds = (DescSyn)dbo.getDescrptiveObject();
        if (ds != null) {
            return ds.tableowner;
        }
        return "";
    }

    static class DescSyn {
        String dblink;
        String tablename;
        String tableowner;

        DescSyn() {
        }
    }
}

