/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHClusterOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "CLUSTER";
    private static final Logger LOGGER = new Logger(MOHClusterOracle.class);
    protected boolean dbaUser;
    PreparedStatement col_statement = null;
    PreparedStatement ind_statement = null;

    public MOHClusterOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHClusterOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        Statement statement = null;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            if (statement == null) {
                String filterCondition = this.getFilterConditionOracle("CLUSTER_NAME");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("CLUSTER_NAME").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? DBA_CLUSTERS : ALL_CLUSTERS).append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("OWNER").append('=').append('?').append(' ');
                if (filterCondition != null) {
                    buffer.append("AND").append(' ').append(filterCondition).append(' ');
                }
                buffer.append("ORDER BY").append(' ');
                buffer.append("CLUSTER_NAME");
                String sql = buffer.toString();
                statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, dboNext.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                System.out.println("MOHClusterOracle.extract(): " + e.getMessage());
                LOGGER.error("MOHClusterOracle.extract():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                String clusterName = rs.getString(1);
                DBObject dboCluster = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), clusterName, OBJECT_TYPE, dboNext.getName());
                list.add(dboCluster);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesign storageDesign = this.getStorageDesign();
        if (storageDesign != null && storageDesign instanceof StorageDesignOracle) {
            Statement statement = null;
            this.col_statement = null;
            this.ind_statement = null;
            for (int i = 0; i < selectedObjects.size(); ++i) {
                DBObject dbo = (DBObject)selectedObjects.get(i);
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                if (statement == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("a.").append("CLUSTER_NAME").append(',');
                    buffer.append("TABLESPACE_NAME").append(',');
                    buffer.append("PCT_FREE").append(',');
                    buffer.append("PCT_USED").append(',');
                    buffer.append("KEY_SIZE").append(',');
                    buffer.append("INI_TRANS").append(',');
                    buffer.append("MAX_TRANS").append(',');
                    buffer.append("INITIAL_EXTENT").append(',');
                    buffer.append("NEXT_EXTENT").append(',');
                    buffer.append("MIN_EXTENTS").append(',');
                    buffer.append("MAX_EXTENTS").append(',');
                    buffer.append("PCT_INCREASE").append(',');
                    buffer.append("FREELISTS").append(',');
                    buffer.append("FREELIST_GROUPS").append(',');
                    buffer.append("CLUSTER_TYPE").append(',');
                    buffer.append("FUNCTION").append(',');
                    buffer.append("HASHKEYS").append(',');
                    buffer.append("DEGREE").append(',');
                    buffer.append("CACHE").append(',');
                    buffer.append("BUFFER_POOL").append(',');
                    buffer.append("SINGLE_TABLE").append(',');
                    if (storageDesign instanceof StorageDesignOraclev9i) {
                        buffer.append("NULL").append(' ').append("AS").append(' ').append("DEPENDENCIES").append(',');
                    } else {
                        buffer.append("DEPENDENCIES").append(',');
                    }
                    buffer.append("b.").append("HASH_EXPRESSION").append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser ? DBA_CLUSTERS : ALL_CLUSTERS).append(' ').append("a").append(',');
                    buffer.append(this.dbaUser ? DBA_CLUSTER_HASH_EXPRESSIONS : ALL_CLUSTER_HASH_EXPRESSIONS).append(' ').append("b").append(' ');
                    buffer.append("WHERE").append(' ');
                    buffer.append("a.").append("CLUSTER_NAME").append('=').append(' ').append('?').append(' ');
                    buffer.append("AND").append(' ');
                    buffer.append("a.").append("OWNER").append('=').append(' ').append('?').append(' ');
                    buffer.append("AND").append(' ');
                    buffer.append("a.").append("OWNER").append('=').append("b.").append("OWNER").append(' ').append("(+)").append(' ');
                    buffer.append("AND").append(' ');
                    buffer.append("a.").append("CLUSTER_NAME").append('=').append("b.").append("CLUSTER_NAME").append("(+)").append(' ');
                    buffer.append("ORDER BY").append(' ');
                    buffer.append("a.").append("OWNER").append(',');
                    buffer.append("a.").append("CLUSTER_NAME");
                    String sql = buffer.toString();
                    statement = sqlConnection.prepareStatement(sql);
                }
                ResultSet rs = null;
                try {
                    statement.setString(1, dbo.getName());
                    statement.setString(2, dbo.getSchema());
                    rs = statement.executeQuery();
                    if (rs != null) {
                        if (rs.next()) {
                            ClusterOracle cluster = ((StorageDesignOracle)storageDesign).getClusterSet().createCluster();
                            String name = dbo.getName();
                            cluster.setName(name);
                            if (!name.equals(name.toUpperCase())) {
                                cluster.setNameHasQuotes(true);
                            }
                            this.setUser(cluster, (StorageDesignOracle)storageDesign, dbo.getSchema());
                            this.setTableSpace(cluster, (StorageDesignOracle)storageDesign, rs, dbo.getSchema());
                            this.setProperties(cluster, (StorageDesignOracle)storageDesign, rs);
                            this.stampModelObject(cluster, dbo);
                        }
                        rs.close();
                    }
                    this.setClusterColumns(sqlConnection, dbo.getName(), dbo.getSchema(), (StorageDesignOracle)storageDesign);
                    if (this.dbaUser) {
                        this.setClusterIndexes(sqlConnection, dbo.getName(), dbo.getSchema(), statement, (StorageDesignOracle)storageDesign);
                    } else {
                        this.setClusterIndexesBasic(sqlConnection, dbo.getName(), dbo.getSchema(), statement, (StorageDesignOracle)storageDesign);
                    }
                }
                catch (Exception e) {
                    System.out.println("MOHClusterOracle.generate(): " + e.getMessage());
                    LOGGER.error("MOHClusterOracle.generate():", e);
                }
                importLog.incrementImportedStatements();
                this.addToHandledObjects(dbo);
            }
            if (statement != null) {
                statement.close();
            }
            if (this.col_statement != null) {
                this.col_statement.close();
            }
            if (this.ind_statement != null) {
                this.ind_statement.close();
            }
        } else {
            LOGGER.error("Unable to find Storage Design!");
        }
    }

    private void setUser(ClusterOracle cluster, StorageDesignOracle storageDesign, String userName) {
        UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(userName);
        cluster.setUser(user);
    }

    private void setTableSpace(ClusterOracle cluster, StorageDesignOracle storageDesign, ResultSet resultSet, String schemaName) throws Exception {
        String tsName = resultSet.getString("TABLESPACE_NAME");
        if (tsName != null && !"".equalsIgnoreCase(tsName)) {
            TableSpaceOracle tableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
            if (tableSpace == null) {
                tableSpace = storageDesign.getTableSpaceSet().createTableSpace();
                tableSpace.setName(tsName);
                this.stampModelObject((ModelObject)tableSpace, schemaName, tsName);
            }
            cluster.setTableSpace(tableSpace);
        }
    }

    private void setProperties(ClusterOracle cluster, StorageDesignOracle storageDesign, ResultSet rs) throws Exception {
        SegmentOracle tsegment;
        SegmentOracle segment;
        int pct_free = rs.getInt("PCT_FREE");
        String pctUsed = rs.getString("PCT_USED");
        int pct_used = 40;
        if (pctUsed != null) {
            try {
                pct_used = Integer.parseInt(pctUsed);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int key_size = rs.getInt("KEY_SIZE");
        int ini_trans = rs.getInt("INI_TRANS");
        int max_trans = rs.getInt("MAX_TRANS");
        long initial_extent = rs.getLong("INITIAL_EXTENT");
        long next_extent = rs.getLong("NEXT_EXTENT");
        int min_extents = rs.getInt("MIN_EXTENTS");
        String max_extents = rs.getString("MAX_EXTENTS");
        int pct_increase = rs.getInt("PCT_INCREASE");
        int freelists = rs.getInt("FREELISTS");
        int freelist_groups = rs.getInt("FREELIST_GROUPS");
        int hashkeys = rs.getInt("HASHKEYS");
        String bufferPool = rs.getString("BUFFER_POOL");
        String degree = rs.getString("DEGREE");
        String cache = rs.getString("CACHE");
        String singleTable = rs.getString("SINGLE_TABLE");
        String dependencies = rs.getString("DEPENDENCIES");
        String hash_expression = rs.getString("HASH_EXPRESSION");
        String cluster_type = rs.getString("CLUSTER_TYPE");
        cluster.setSize(key_size);
        if ("INDEX".equalsIgnoreCase(cluster_type)) {
            cluster.setIndexed("YES");
        } else {
            cluster.setIndexed("NO");
        }
        if (singleTable != null) {
            if ("Y".equalsIgnoreCase(singleTable.trim())) {
                cluster.setSingleTable("YES");
            } else {
                cluster.setSingleTable("NO");
            }
        }
        cluster.setHashKeys(hashkeys);
        if (hash_expression != null) {
            cluster.setHashExpression(hash_expression);
        }
        if ("DEFAULT".equalsIgnoreCase(degree.trim())) {
            cluster.setParallel("YES");
        } else {
            try {
                int degreeValue = Integer.parseInt(degree);
                if (degreeValue == 1) {
                    cluster.setParallel("NO");
                }
                cluster.setDegree(degreeValue);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ("Y".equalsIgnoreCase(cache)) {
            cluster.setCache("YES");
        } else {
            cluster.setCache("NO");
        }
        if ("ENABLED".equalsIgnoreCase(dependencies)) {
            cluster.setRowDependency("YES");
        }
        if ((segment = storageDesign.getSegmentSet().createSegment()).getAppView().getSettings().isIncludePctFreeInDDL()) {
            segment.setPCTFree(pct_free);
        }
        if (segment.getAppView().getSettings().isIncludePctUsedInDDL()) {
            segment.setPCTUsed(pct_used);
        }
        if (segment.getAppView().getSettings().isIncludeInitransInDDL()) {
            segment.setInitrans(ini_trans);
            segment.setMaxTrans(max_trans);
        }
        if (segment.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
            segment.setSCInitialExtent(initial_extent);
        }
        if (segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
            segment.setSCNextExtent(next_extent);
        }
        if (segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
            segment.setSCMinExtents(min_extents);
        }
        if (segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
            segment.setSCMaxExtents(String.valueOf(max_extents));
        }
        if (segment.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
            segment.setSCPctIncrease(pct_increase);
        }
        if (segment.getAppView().getSettings().isIncludeFreeListsInDDL()) {
            segment.setSCFreeLists(freelists);
        }
        if (segment.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
            segment.setSCFreelistGroups(freelist_groups);
        }
        if (segment.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
            segment.setSCBufferPool(bufferPool);
        }
        if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
            segment.remove(true);
        }
        segment = tsegment;
        cluster.setSegment(segment);
    }

    private void setClusterColumns(Connection sqlConnection, String clusterName, String owner, StorageDesignOracle storageDesign) throws Exception {
        if (this.col_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("a.").append("OWNER").append(',');
            buffer.append("a.").append("TABLE_NAME").append(',');
            buffer.append("a.").append("COLUMN_NAME").append(',');
            buffer.append("DATA_TYPE").append(',');
            buffer.append("DATA_TYPE_MOD").append(',');
            buffer.append("DATA_TYPE_OWNER").append(',');
            buffer.append("DATA_LENGTH").append(',');
            buffer.append("DATA_PRECISION").append(',');
            buffer.append("DATA_SCALE").append(',');
            buffer.append("CHAR_USED").append(',');
            buffer.append("CHAR_LENGTH").append(',');
            buffer.append("NULLABLE").append(',');
            buffer.append("COLUMN_ID").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? DBA_TAB_COLUMNS : ALL_TAB_COLUMNS).append(' ').append("a").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("a.").append("OWNER").append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("a.").append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("COLUMN_ID");
            String sql = buffer.toString();
            this.col_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.col_statement.setString(1, owner);
            this.col_statement.setString(2, clusterName);
            rs = this.col_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    ClusterOracle cluster = (ClusterOracle)storageDesign.getClusterSet().getByName(clusterName);
                    if (cluster == null) continue;
                    String name = rs.getString("COLUMN_NAME");
                    String dataType = rs.getString("DATA_TYPE");
                    int length = rs.getInt("DATA_LENGTH");
                    int precision = rs.getInt("DATA_PRECISION");
                    int scale = rs.getInt("DATA_SCALE");
                    String char_used = rs.getString("CHAR_USED");
                    int charLength = rs.getInt("CHAR_LENGTH");
                    int id = rs.getInt("COLUMN_ID");
                    ClusterColumnOracle clusterColumn = storageDesign.getClusterColumnSet().createClusterColumn();
                    clusterColumn.setName(name);
                    if (!name.equals(name.toUpperCase())) {
                        clusterColumn.setNameHasQuotes(true);
                    }
                    this.stampModelObject((ModelObject)clusterColumn, clusterName, name);
                    dataType = this.removeBrackets(dataType);
                    clusterColumn.setDataType(dataType);
                    clusterColumn.setPosition(id);
                    clusterColumn.setCluster(cluster);
                    if (dataType.indexOf("CHAR") >= 0) {
                        int relevantLength = charLength;
                        String suffix = "";
                        if (dataType.equals("CHAR") || dataType.equals("VARCHAR2")) {
                            if (char_used.equalsIgnoreCase("B")) {
                                relevantLength = length;
                                suffix = " BYTE";
                            } else {
                                suffix = " CHAR";
                            }
                        }
                        clusterColumn.setLengthPrecision(relevantLength + suffix);
                        continue;
                    }
                    if (dataType.equals("RAW") || dataType.equals("UROWID")) {
                        clusterColumn.setLengthPrecision(Integer.toString(length));
                        continue;
                    }
                    if (dataType.startsWith("TIMESTAMP")) {
                        if (scale == 0) continue;
                        clusterColumn.setLengthPrecision(Integer.toString(scale));
                        continue;
                    }
                    if (precision != 0) {
                        clusterColumn.setLengthPrecision(Integer.toString(precision));
                    }
                    clusterColumn.setScale(scale);
                }
                rs.close();
            }
        }
        catch (Exception e) {
            System.out.println("MOHClusterOracle.setClusterColumns(): " + e.getMessage());
            LOGGER.error("MOHClusterOracle.setClusterColumns():", e);
        }
    }

    private String removeBrackets(String dataType) {
        int closeIndex;
        int openIndex = dataType.indexOf(40);
        if (openIndex >= 0 && (closeIndex = dataType.indexOf(41, openIndex)) >= 0) {
            dataType = this.removeBrackets(dataType.substring(0, openIndex) + dataType.substring(closeIndex + 1));
        }
        return dataType;
    }

    private void setClusterIndexes(Connection sqlConnection, String clusterName, String clusterOwner, Statement statement, StorageDesignOracle storageDesign) throws Exception {
        block28: {
            if (this.ind_statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("OWNER").append(',');
                buffer.append("INDEX_NAME").append(',');
                buffer.append("TABLESPACE_NAME").append(',');
                buffer.append("INI_TRANS").append(',');
                buffer.append("MAX_TRANS").append(',');
                buffer.append("INITIAL_EXTENT").append(',');
                buffer.append("NEXT_EXTENT").append(',');
                buffer.append("MIN_EXTENTS").append(',');
                buffer.append("MAX_EXTENTS").append(',');
                buffer.append("PCT_INCREASE").append(',');
                buffer.append("FREELISTS").append(',');
                buffer.append("FREELIST_GROUPS").append(',');
                buffer.append("PCT_FREE").append(',');
                buffer.append("LOGGING").append(',');
                buffer.append("DEGREE").append(',');
                buffer.append("BUFFER_POOL").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? DBA_INDEXES : ALL_INDEXES).append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("TABLE_TYPE").append('=').append('\'');
                buffer.append(OBJECT_TYPE).append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("TABLE_OWNER").append('=').append('?').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("TABLE_NAME").append('=').append('?').append(' ');
                buffer.append("ORDER BY").append(' ');
                buffer.append("INDEX_NAME");
                String sql = buffer.toString();
                this.ind_statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                this.ind_statement.setString(1, clusterOwner);
                this.ind_statement.setString(2, clusterName);
                rs = this.ind_statement.executeQuery();
                if (rs == null) break block28;
                while (rs.next()) {
                    SegmentOracle tsegment;
                    SegmentOracle segment;
                    ClusterOracle cluster = (ClusterOracle)storageDesign.getClusterSet().getByName(clusterName);
                    if (cluster == null) continue;
                    String owner = rs.getString("OWNER");
                    String name = rs.getString("INDEX_NAME");
                    String tsName = rs.getString("TABLESPACE_NAME");
                    int pct_free = rs.getInt("PCT_FREE");
                    int ini_trans = rs.getInt("INI_TRANS");
                    int max_trans = rs.getInt("MAX_TRANS");
                    long initial_extent = rs.getLong("INITIAL_EXTENT");
                    long next_extent = rs.getLong("NEXT_EXTENT");
                    int minExtents = Integer.MAX_VALUE;
                    int maxExtents = Integer.MAX_VALUE;
                    try {
                        minExtents = rs.getInt("MIN_EXTENTS");
                    }
                    catch (Exception e) {
                        LOGGER.error("error in min_extent", e);
                    }
                    try {
                        maxExtents = rs.getInt("MAX_EXTENTS");
                    }
                    catch (Exception e) {
                        LOGGER.error("error in max_extent", e);
                    }
                    int pct_increase = rs.getInt("PCT_INCREASE");
                    int freelists = rs.getInt("FREELISTS");
                    int freelist_groups = rs.getInt("FREELIST_GROUPS");
                    String bufferPool = rs.getString("BUFFER_POOL");
                    String logging = rs.getString("LOGGING");
                    String degree = rs.getString("DEGREE");
                    ClusterIndexOracle clusterIndex = storageDesign.getClusterIndexSet().createClusterIndex();
                    clusterIndex.setCluster(cluster);
                    clusterIndex.setName(name);
                    if (!name.equals(name.toUpperCase())) {
                        clusterIndex.setNameHasQuotes(true);
                    }
                    this.stampModelObject((ModelObject)clusterIndex, owner, name);
                    if (tsName != null && !"".equalsIgnoreCase(tsName)) {
                        TableSpaceOracle tableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
                        if (tableSpace == null) {
                            tableSpace = storageDesign.getTableSpaceSet().createTableSpace();
                            tableSpace.setName(tsName);
                            this.stampModelObject((ModelObject)tableSpace, owner, tsName);
                        }
                        clusterIndex.setTableSpace(tableSpace);
                    }
                    UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(owner);
                    clusterIndex.setUser(user);
                    if ("YES".equalsIgnoreCase(logging)) {
                        clusterIndex.setLogging("YES");
                    } else {
                        clusterIndex.setLogging("NO");
                    }
                    if ("DEFAULT".equalsIgnoreCase(degree.trim())) {
                        cluster.setParallel("YES");
                    }
                    if ((segment = storageDesign.getSegmentSet().createSegment()).getAppView().getSettings().isIncludePctFreeInDDL()) {
                        segment.setPCTFree(pct_free);
                    }
                    if (segment.getAppView().getSettings().isIncludeInitransInDDL()) {
                        segment.setInitrans(ini_trans);
                        segment.setMaxTrans(max_trans);
                    }
                    if (segment.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                        segment.setSCInitialExtent(initial_extent);
                    }
                    if (segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                        segment.setSCNextExtent(next_extent);
                    }
                    if (segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                        segment.setSCMinExtents(minExtents);
                    }
                    if (segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                        segment.setSCMaxExtents(String.valueOf(maxExtents));
                    }
                    if (segment.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                        segment.setSCPctIncrease(pct_increase);
                    }
                    if (segment.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                        segment.setSCFreeLists(freelists);
                    }
                    if (segment.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                        segment.setSCFreelistGroups(freelist_groups);
                    }
                    if (segment.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                        segment.setSCBufferPool(bufferPool);
                    }
                    if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
                        segment.remove(true);
                    }
                    segment = tsegment;
                    clusterIndex.setSegment(segment);
                }
                rs.close();
            }
            catch (SQLException se) {
                if (se.getMessage().startsWith("ORA-00942")) {
                    System.out.println("MOHClusterOracle.setClusterIndexes(): " + se.getMessage());
                    LOGGER.error("MOHClusterOracle.setClusterIndexes(): current connection user has no SELECT privilege on " + (this.dbaUser ? "dba_indexes" : "all_indexes"));
                } else {
                    System.out.println("MOHClusterOracle.setClusterIndexes(): " + se.getMessage());
                    LOGGER.error("MOHClusterOracle.setClusterIndexes():", se);
                }
            }
            catch (Exception e) {
                System.out.println("MOHClusterOracle.setClusterIndexes(): " + e.getMessage());
                LOGGER.error("MOHClusterOracle.setClusterIndexes():", e);
            }
        }
    }

    private void setClusterIndexesBasic(Connection sqlConnection, String clusterName, String owner, Statement statement, StorageDesignOracle storageDesign) throws Exception {
        if (this.ind_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("DISTINCT").append(' ');
            buffer.append("a.").append("INDEX_OWNER").append(',');
            buffer.append("a.").append("INDEX_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("all_ind_columns").append(' ').append("a").append(',');
            buffer.append("all_clusters").append(' ').append("b").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("a.").append("TABLE_OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("a.").append("TABLE_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("b.").append("OWNER").append('=').append("a.").append("TABLE_OWNER").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("b.").append("CLUSTER_NAME").append('=').append("a.").append("TABLE_NAME").append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("INDEX_NAME");
            String sql = buffer.toString();
            this.ind_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.ind_statement.setString(1, owner);
            this.ind_statement.setString(2, clusterName);
            rs = this.ind_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    ClusterOracle cluster = (ClusterOracle)storageDesign.getClusterSet().getByName(clusterName);
                    if (cluster == null) continue;
                    String index_owner = rs.getString("INDEX_OWNER");
                    String index_name = rs.getString("INDEX_NAME");
                    ClusterIndexOracle clusterIndex = storageDesign.getClusterIndexSet().createClusterIndex();
                    clusterIndex.setCluster(cluster);
                    clusterIndex.setName(index_name);
                    if (!index_name.equals(index_name.toUpperCase())) {
                        clusterIndex.setNameHasQuotes(true);
                    }
                    this.stampModelObject((ModelObject)clusterIndex, owner, index_name);
                    UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(index_owner);
                    clusterIndex.setUser(user);
                }
                rs.close();
            }
        }
        catch (Exception e) {
            System.out.println("MOHClusterOracle.setClusterIndexesBasic(): " + e.getMessage());
            LOGGER.error("MOHClusterOracle.setClusterIndexesBasic():", e);
        }
    }
}

