/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.util.logging.Logger;

public class SHColumnElementsSqlServer
extends DDLStatementHandlerSqlServer
implements SectionConstants {
    private static final String ZERO = "0";
    private static final String[] CONSTRAINT_NAMES = new String[]{"CONSTRAINT", "PRIMARY", "UNIQUE", "FOREIGN", "CHECK"};
    private Map mapElementsColumn;
    private String statement;
    private Set constraints = new HashSet<String>(Arrays.asList(CONSTRAINT_NAMES));
    private static final Logger LOGGER = new Logger(SHColumnElementsSqlServer.class);

    public SHColumnElementsSqlServer(Design design) {
        super(design);
    }

    public void parseColumns(String columnStatement) {
        this.statement = columnStatement;
        this.mapElementsColumn = new HashMap();
        try {
            if (this.initColumnName()) {
                this.initDatatype();
                this.initCollate();
                this.initDefault();
                this.initIdentity();
                this.initRowguidcol();
                this.initNotNull();
                this.initPrimaryKeyOrUnique();
                this.initReferences();
                this.initConstraintCheck();
            } else {
                this.initAnyConstraint();
            }
        }
        catch (Exception e) {
            LOGGER.error(" Parsing " + this.statement + " for SQL Server failed!", e);
        }
    }

    private void initRowguidcol() {
        boolean rowguid = Token.hasToken(this.statement, "ROWGUIDCOL");
        if (rowguid) {
            this.mapElementsColumn.put("ROWGUIDCOL", rowguid ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private void initIdentity() {
        String identityString;
        boolean identity = Token.hasToken(this.statement, "IDENTITY");
        if (identity && Token.hasCloseAndOpenBrackets(identityString = Token.getStringAfterToken(this.statement, "IDENTITY"))) {
            identityString = Token.getValBetweenBrackets(identityString);
            String seed = Token.getValBeforeCharacter(identityString, ',').trim();
            String increment = Token.getValAfterCharacter(identityString, ',').trim();
            this.mapElementsColumn.put("SEED", seed);
            this.mapElementsColumn.put("INCREMENT", increment);
            boolean notForReplication = Token.hasString(this.statement, "NOT FOR REPLICATION");
            this.mapElementsColumn.put("NOT FOR REPLICATION", notForReplication ? Boolean.TRUE : Boolean.FALSE);
        }
        this.mapElementsColumn.put("IDENTITY", identity ? Boolean.TRUE : Boolean.FALSE);
    }

    private void initDefault() {
        if (Token.hasToken(this.statement, "DEFAULT")) {
            String defaultValue = Token.getStringAfter(this.statement, "DEFAULT");
            if (defaultValue.startsWith("'")) {
                defaultValue = Token.getFirstTextLiteral(defaultValue);
            } else {
                if (Token.hasToken(defaultValue, "PRIMARY")) {
                    defaultValue = Token.getStringBefore(defaultValue, "PRIMARY");
                }
                if (Token.hasToken(defaultValue, "UNIQUE")) {
                    defaultValue = Token.getStringBefore(defaultValue, "UNIQUE");
                }
                if (Token.hasToken(defaultValue, "FOREIGN")) {
                    defaultValue = Token.getStringBefore(defaultValue, "FOREIGN");
                }
                if (Token.hasToken(defaultValue, "REFERENCES")) {
                    defaultValue = Token.getStringBefore(defaultValue, "REFERENCES");
                }
                if (Token.hasToken(defaultValue, "COLLATE")) {
                    defaultValue = Token.getStringBefore(defaultValue, "COLLATE");
                }
                if (Token.hasToken(defaultValue, "ROWGUIDCOL")) {
                    defaultValue = Token.getStringBefore(defaultValue, "ROWGUIDCOL");
                }
                if (Token.hasToken(defaultValue, "NULL")) {
                    defaultValue = Token.getStringBefore(defaultValue, "NULL");
                }
                defaultValue = Token.hasToken(defaultValue, "NOT") ? Token.getStringBefore(defaultValue, "NOT") : Token.getFirstToken(defaultValue);
            }
            this.mapElementsColumn.put(NameElements.COL_DEFAULT, defaultValue);
        }
    }

    private void initCollate() {
        if (Token.hasToken(this.statement, "COLLATE")) {
            String collationName = Token.getTokenAfter(this.statement, "COLLATE");
            this.mapElementsColumn.put("collate", collationName);
        }
    }

    private void initNotNull() {
        if (Token.hasString(this.statement, "NOT NULL")) {
            this.mapElementsColumn.put("nulls", Boolean.FALSE);
        } else if (Token.hasToken(this.statement, "NULL") && !Token.hasString(this.statement.toUpperCase(), "NOT NULL")) {
            this.mapElementsColumn.put("nulls", Boolean.TRUE);
        }
    }

    private boolean initColumnName() {
        String firstToken = Token.getFirstName(this.statement, '[', ']');
        if (this.constraints.contains(firstToken.toUpperCase())) {
            this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.TRUE);
            return false;
        }
        this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.FALSE);
        this.mapElementsColumn.put("columnname", firstToken);
        this.statement = Token.getStringAfter(this.statement, firstToken);
        if (this.statement.trim().startsWith("]")) {
            this.statement = this.statement.substring(1).trim();
        }
        return true;
    }

    protected String searchWhichDatatype(String statement) {
        String[] names = StandardDatatypeNames.getAllPossibleDatatypes("SQL Server 2000");
        for (int number = 0; number < names.length; ++number) {
            String name = names[number];
            boolean isTrue = statement.toUpperCase().startsWith(name);
            if (!isTrue) continue;
            try {
                char nextChar = statement.charAt(name.length());
                isTrue = nextChar == '(' || nextChar == ' ' || nextChar == '\n' || nextChar == '\t';
            }
            catch (StringIndexOutOfBoundsException e) {
                isTrue = true;
            }
            if (!isTrue) continue;
            return name;
        }
        return null;
    }

    private void initDatatype() {
        String type = Token.getFirstToken(this.statement);
        if (!type.equalsIgnoreCase("AS")) {
            String dtype;
            int index;
            if (this.statement.indexOf(32) > -1) {
                String afterFirstToken = this.statement.substring(this.statement.indexOf(32)).trim();
                if (afterFirstToken.startsWith("(")) {
                    type = type + Token.getFirstToken(afterFirstToken);
                } else {
                    afterFirstToken = this.statement.substring(type.length()).trim();
                    if (afterFirstToken.startsWith("(")) {
                        type = type + Token.getFirstToken(afterFirstToken);
                    }
                }
            } else {
                String afterType = Token.getStringAfter(this.statement, type);
                if (afterType.startsWith("(")) {
                    type = type + Token.getFirstToken(afterType);
                }
            }
            if (Token.hasOpenBracketNoClose(type)) {
                type = this.statement.substring(0, this.statement.indexOf(")") + 1);
            }
            if (Token.hasCloseAndOpenBrackets(type) && (index = type.indexOf(")")) > -1) {
                type = type.substring(0, index + 1);
            }
            if (Token.hasString(type, "[") && Token.hasString(type, "]")) {
                if (Token.hasCloseAndOpenBrackets(type)) {
                    String datatypeBrackets = type.substring(0, type.indexOf("(")).trim();
                    datatypeBrackets = this.getValBetween(datatypeBrackets);
                    type = datatypeBrackets = datatypeBrackets.concat(type.substring(type.indexOf("(")));
                } else {
                    String datatypeBrackets;
                    type = datatypeBrackets = this.getValBetween(type);
                }
            }
            if ((dtype = this.searchWhichDatatype(type)) == null) {
                dtype = this.searchNotStandartDatatypes(type);
                this.mapElementsColumn.put("typename", type);
            }
            if (dtype != null) {
                String datatype = StandardDatatypeNames.getUsedDatatypeName(dtype = dtype.trim());
                if (Token.hasCloseAndOpenBrackets(datatype)) {
                    type = datatype;
                    dtype = datatype = Token.getValBeforeBrackets(datatype).trim();
                }
                if (datatype != null) {
                    boolean hasBrackets;
                    type = Token.cutTokenFromFront(type, dtype);
                    this.mapElementsColumn.put("datatype", datatype);
                    if (!type.equalsIgnoreCase("") && (hasBrackets = Token.hasCloseAndOpenBrackets(type))) {
                        String parameters = Token.getValBetweenBrackets(type, 1);
                        int positionKomma = parameters.indexOf(",");
                        if (positionKomma != -1) {
                            this.mapElementsColumn.put("size", ZERO);
                            this.mapElementsColumn.put("precision", parameters.substring(0, positionKomma).trim());
                            this.mapElementsColumn.put("scale", parameters.substring(positionKomma + 1).trim());
                        } else if (datatype.equals("DECIMAL")) {
                            this.mapElementsColumn.put("size", ZERO);
                            this.mapElementsColumn.put("scale", ZERO);
                            this.mapElementsColumn.put("precision", parameters.trim());
                        } else if (datatype.equalsIgnoreCase("NUMERIC")) {
                            if (positionKomma != -1) {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("precision", parameters.substring(0, positionKomma).trim());
                                this.mapElementsColumn.put("scale", parameters.substring(positionKomma + 1).trim());
                            } else {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("precision", parameters.trim());
                                this.mapElementsColumn.put("scale", ZERO);
                            }
                        } else {
                            this.mapElementsColumn.put("scale", ZERO);
                            this.mapElementsColumn.put("precision", ZERO);
                            this.mapElementsColumn.put("size", parameters.trim());
                        }
                        this.statement = Token.cutFirstToken(this.statement);
                    }
                } else {
                    LOGGER.error("datatype is unknown in SHColumnElements.initDatatype: ");
                    this.importLog.addError("Unknown dataype " + dtype);
                }
            }
        } else {
            this.mapElementsColumn.put("COMPUTED", Boolean.TRUE);
            String formula = Token.cutTokenFromFront(this.statement, "AS");
            if (Token.hasToken(formula, "PERSISTED")) {
                this.mapElementsColumn.put("PERSISTED", Boolean.TRUE);
                formula = Token.getStringBefore(formula, "PERSISTED");
            }
            this.mapElementsColumn.put("FORMULA", formula);
        }
    }

    private String searchNotStandartDatatypes(String string) {
        String[] names = NotStandartDataTypeNames.getAllNewTypes();
        for (int number = 0; number < names.length; ++number) {
            String name = names[number];
            boolean isTrue = string.equalsIgnoreCase(name);
            if (!isTrue) continue;
            return name;
        }
        return null;
    }

    public String getValBetween(String string) {
        if (string != null && string.indexOf(91) == 0 && string.indexOf(93, 1) == string.length() - 1) {
            return string.substring(1, string.length() - 1);
        }
        return "";
    }

    public Map getElementsColumn(String statement) {
        this.parseColumns(statement.replaceAll("\"", ""));
        return this.mapElementsColumn;
    }

    private void initConstraintCheck() {
        boolean isCheck;
        boolean isConstraint = Token.hasToken(this.statement, "CONSTRAINT");
        if (isConstraint) {
            this.statement = Token.getStringAfter(this.statement, "CONSTRAINT");
            String constraint = Token.getFirstToken(this.statement).trim();
            this.mapElementsColumn.put("CONSTRAINT", constraint);
            this.statement = Token.cutTokenFromFront(this.statement, constraint);
        }
        if (isCheck = Token.hasToken(this.statement, "CHECK")) {
            this.statement = Token.getStringAfter(this.statement, "CHECK");
            String check = this.statement;
            if (Token.hasOpenBracketNoClose(check)) {
                String check2;
                StringBuffer checkSB = new StringBuffer(check);
                while (!Token.hasCloseBracket(Token.getFirstToken(this.statement)) && !(check2 = Token.getFirstToken(this.statement)).equals("")) {
                    checkSB.append(" ").append(check2);
                    this.statement = Token.cutTokenFromFront(this.statement, check2);
                }
                checkSB.append(" )");
                checkSB.append(" )");
                check = checkSB.toString();
                this.statement = Token.cutTokenFromFront(this.statement, ")");
            }
            check = Token.getValBetweenBrackets(check);
            this.mapElementsColumn.put("CHECK", check);
        }
    }

    private void initAnyConstraint() {
        String value = Token.getFirstToken(this.statement);
        if (value.equalsIgnoreCase("CONSTRAINT")) {
            String name = Token.getNameAfterToken(this.statement, "CONSTRAINT", '[', ']').trim();
            this.statement = Token.getStringAfter(this.statement, name);
            if (this.statement.startsWith("]")) {
                this.statement = this.statement.substring(1).trim();
            }
            this.mapElementsColumn.put("CONSTRAINT_NAME", name);
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        } else if (value.equalsIgnoreCase("FOREIGN")) {
            this.mapElementsColumn.put("CONSTRAINT_NAME", "");
            this.mapElementsColumn.put("FOREIGN", Boolean.TRUE);
            if (Token.hasToken(this.statement, "DELETE")) {
                if (Token.hasToken(this.statement, "CASCADE")) {
                    this.mapElementsColumn.put("ON DELETE", "CASCADE");
                } else {
                    this.mapElementsColumn.put("ON DELETE", "NO ACTION");
                }
            }
            if (Token.hasToken(this.statement, "UPDATE")) {
                if (Token.hasToken(this.statement, "CASCADE")) {
                    this.mapElementsColumn.put("ON UPDATE", "CASCADE");
                } else {
                    this.mapElementsColumn.put("ON UPDATE", "NO ACTION");
                }
            }
            if (Token.hasString(this.statement, "NOT FOR REPLICATION")) {
                this.mapElementsColumn.put("NOT FOR REPLICATION", Boolean.TRUE);
            }
        } else {
            this.mapElementsColumn.put("CONSTRAINT_NAME", "");
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        }
    }

    private void initPrimaryKeyOrUnique() {
        boolean isPrimary = Token.hasToken(this.statement, "PRIMARY");
        boolean isKey = Token.hasToken(this.statement, "KEY");
        boolean isForeign = Token.hasToken(this.statement, "FOREIGN");
        if (isPrimary && isKey) {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.TRUE);
            this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            this.mapElementsColumn.put("FOREIGN", Boolean.FALSE);
            if (Token.hasToken(this.statement, "CLUSTERED")) {
                this.mapElementsColumn.put("CLUSTERED", Boolean.TRUE);
            } else if (Token.hasToken(this.statement, "NONCLUSTERED")) {
                this.mapElementsColumn.put("NONCLUSTERED", Boolean.TRUE);
            }
            this.initIndexOption("FILLFACTOR");
            if (Token.hasToken(this.statement, "ON")) {
                String fileGroupValue = Token.getTokenAfter(this.statement, "ON");
                fileGroupValue = Token.getValBetweenDoubleQuotes(fileGroupValue).trim();
                fileGroupValue = Token.getValBetweenSquareBrackets(fileGroupValue).trim();
                this.mapElementsColumn.put("FILEGROUP", fileGroupValue);
            }
        } else if (isForeign && isKey) {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.FALSE);
            this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            this.mapElementsColumn.put("FOREIGN", Boolean.TRUE);
        } else {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.FALSE);
            this.mapElementsColumn.put("FOREIGN", Boolean.FALSE);
            boolean isUnique = Token.hasToken(this.statement, "UNIQUE");
            if (isUnique) {
                this.mapElementsColumn.put("UNIQUE", Boolean.TRUE);
                if (Token.hasToken(this.statement, "CLUSTERED")) {
                    this.mapElementsColumn.put("CLUSTERED", Boolean.TRUE);
                } else if (Token.hasToken(this.statement, "NONCLUSTERED")) {
                    this.mapElementsColumn.put("NONCLUSTERED", Boolean.TRUE);
                }
                this.initIndexOption("FILLFACTOR");
                if (Token.hasToken(this.statement, "ON")) {
                    String fileGroupValue = Token.getTokenAfter(this.statement, "ON");
                    fileGroupValue = Token.getValBetweenDoubleQuotes(fileGroupValue).trim();
                    fileGroupValue = Token.getValBetweenSquareBrackets(fileGroupValue).trim();
                    this.mapElementsColumn.put("FILEGROUP", fileGroupValue);
                }
            } else {
                this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            }
        }
    }

    private void initIndexOption(String optionName) {
        String afterOptionName = Token.getStringAfter(this.statement, optionName);
        if (afterOptionName.startsWith("=")) {
            String optionValue = Token.getFirstToken(afterOptionName.substring(1).trim());
            int commaInd = optionValue.indexOf(44);
            if (commaInd > -1) {
                optionValue = optionValue.substring(0, commaInd);
            }
            this.mapElementsColumn.put(optionName, optionValue);
        }
    }

    private void initValue() {
        if (Token.hasCloseAndOpenBrackets(this.statement)) {
            String value = Token.getValBetweenBrackets(this.statement, 1);
            this.mapElementsColumn.put("CONSTRAINT_VALUE", value);
        } else {
            this.mapElementsColumn.put("CONSTRAINT_VALUE", "");
        }
    }

    private void initTableConstraints() {
        boolean isCheck = Token.isTokenEqualTo(this.statement, 1, "CHECK");
        if (isCheck) {
            this.mapElementsColumn.put("CHECK", Boolean.TRUE);
        } else {
            this.mapElementsColumn.put("CHECK", Boolean.FALSE);
        }
    }

    private void initReferences() {
        boolean isReferences = Token.isTokenEqualTo(this.statement, 1, "REFERENCES");
        if (isReferences) {
            boolean isOn;
            this.statement = Token.cutTokenFromFront(this.statement, "REFERENCES");
            String references = Token.getFirstToken(this.statement);
            this.mapElementsColumn.put("REFERENCES", references);
            this.statement = Token.cutTokenFromFront(this.statement, references);
            boolean hasBrackets = Token.hasString(this.statement, "(");
            if (hasBrackets) {
                String columnReferenced = Token.getValBetweenBrackets(this.statement);
                this.mapElementsColumn.put("REFERENCED_COLUMN", columnReferenced);
            }
            if (isOn = Token.isTokenEqualTo(this.statement, 1, "ON")) {
                this.statement = Token.cutTokenFromFront(this.statement, "ON DELETE");
                String onDelete = Token.getFirstToken(this.statement).trim();
                this.mapElementsColumn.put("ON DELETE", onDelete);
                this.statement = Token.cutTokenFromFront(this.statement, onDelete);
            }
        }
    }
}

