/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.Locale;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTablespaceOraclev10g
extends DDLStatementHandler {
    private TableSpaceOraclev10g tableSpace;
    private RDBMSSite site;
    private StorageDesignOraclev10g stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateTablespaceOraclev10g.class);

    public SHCreateTablespaceOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateTablespaceOraclev10g.clearCR(line);
        if (Token.startsWithString(statement, "CREATE TABLESPACE") || Token.startsWithString(statement, "CREATE SMALLFILE TABLESPACE") || Token.startsWithString(statement, "CREATE BIGFILE TABLESPACE")) {
            try {
                this.parseTablespace(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for Oracle 10g failed!", e);
                this.importLog.addFailedStatement(SHCreateTablespaceOraclev10g.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseTablespace(String statement) {
        this.statement = statement;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            this.tableSpace = (TableSpaceOraclev10g)this.stoDesign.getTableSpaceSet().createTableSpace();
            if (this.tableSpace != null) {
                this.initFileType();
                this.initName();
                this.initDataFiles();
                this.initMinimumExtent();
                this.initBlockSize();
                this.initLogging();
                this.initForceLogging();
                this.initEncryption();
                this.initStatus();
                this.initContents();
                this.initDefaultStorage();
                this.initExtManagement();
                this.initSegmentManagement();
                this.initFlashBack();
                this.design.getRelationalDesign().stampModelObjectDDL(this.tableSpace);
            }
        }
    }

    private void initFlashBack() {
        String flashbackMode = Token.getTokenAfter(this.statement, "FLASHBACK");
        if (!flashbackMode.isEmpty()) {
            this.tableSpace.setFlashBack(flashbackMode.toUpperCase(Locale.ROOT));
        }
    }

    private void initFileType() {
        String fileType = Token.getTokenAfter(this.statement, "CREATE");
        if (fileType.equalsIgnoreCase("BIGFILE")) {
            this.tableSpace.setFileType("BIGFILE");
        } else if (fileType.equalsIgnoreCase("SMALLFILE")) {
            this.tableSpace.setFileType("SMALLFILE");
        } else {
            this.tableSpace.setFileType("");
        }
    }

    private void initBlockSize() {
        if (Token.hasToken(this.statement, "BLOCKSIZE")) {
            String blockSize = this.getNumberOnly(Token.getTokenAfter(this.statement, "BLOCKSIZE").trim());
            try {
                int size = Integer.parseInt(blockSize);
                this.tableSpace.setBlockSize(size);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initBlockSize() : " + e.getMessage());
            }
        }
    }

    private void initName() {
        String name = Token.getQuotedNameAfterToken(this.statement, "TABLESPACE").trim();
        this.tableSpace.setName(name);
    }

    public TableSpaceOraclev10g getTablespace() {
        return this.tableSpace;
    }

    private void initDataFiles() {
        if (Token.hasToken(this.statement, "DATAFILE")) {
            String[] match = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
            String dataFiles = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE"), match);
            StringTokenizer tokenizer = new StringTokenizer(dataFiles, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                this.initDataFile(token);
            }
        }
    }

    private void initDataFile(String dfInfo) {
        if (!"".equalsIgnoreCase(dfInfo)) {
            DataFileOraclev10g dataFile = (DataFileOraclev10g)this.stoDesign.getDataFileSet().createDataFile();
            this.design.getRelationalDesign().stampModelObjectDDL(dataFile);
            dataFile.setTableSpace(this.tableSpace);
            String fileName = Token.getValBetweenQuotes(dfInfo);
            dataFile.setFileName(fileName);
            if (Token.hasToken(dfInfo, "SIZE")) {
                String afterSize = Token.getStringAfter(dfInfo, "SIZE");
                String sizeStr = Token.getFirstToken(afterSize);
                try {
                    long size = Long.parseLong(this.removeMeasureUnit(sizeStr));
                    dataFile.setSize(size);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("wrong SIZE format in SHCreateTablespaceOracle.initDataFile", e);
                    this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                }
                String measureUnit = this.getMeasureUnit(sizeStr, afterSize);
                dataFile.setMeasureUnit(measureUnit);
            }
            if (Token.hasToken(dfInfo, "REUSE")) {
                dataFile.setReuse("YES");
            } else {
                dataFile.setReuse("NO");
            }
            if (Token.hasToken(dfInfo, "AUTOEXTEND")) {
                String autoextend = Token.getTokenAfter(dfInfo, "AUTOEXTEND").trim();
                if ("ON".equalsIgnoreCase(autoextend)) {
                    dataFile.setAutoextend("ON");
                    if (Token.hasToken(dfInfo, "NEXT")) {
                        String afterNext = Token.getStringAfter(dfInfo, "NEXT");
                        String nextStr = Token.getFirstToken(afterNext);
                        try {
                            int size = Integer.parseInt(this.removeMeasureUnit(nextStr));
                            dataFile.setNextBlockSize(size);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("wrong NEXT format in SHCreateTablespaceOracle.initDataFile", e);
                            this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                        }
                        String nextUnit = this.getMeasureUnit(nextStr, afterNext);
                        dataFile.setNextBlockSizeUnit(nextUnit);
                    }
                    if (Token.hasToken(dfInfo, "MAXSIZE")) {
                        String afterMaxsize = Token.getStringAfter(dfInfo, "MAXSIZE");
                        String maxsizeStr = Token.getFirstToken(afterMaxsize);
                        if (maxsizeStr.equalsIgnoreCase("UNLIMITED")) {
                            dataFile.setMaxSize("UNLIMITED");
                        } else {
                            try {
                                String noUnit = this.removeMeasureUnit(maxsizeStr);
                                Long.parseLong(noUnit);
                                dataFile.setMaxSize(noUnit);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("wrong MAXSIZE format in SHCreateTablespaceOracle.initDataFile", e);
                                this.importLog.addWarning("Wrong MAXSIZE format in statement " + this.statement);
                            }
                            String maxsizeUnit = this.getMeasureUnit(maxsizeStr, afterMaxsize);
                            dataFile.setMaxSizeUnit(maxsizeUnit);
                        }
                    }
                } else if ("OFF".equalsIgnoreCase(autoextend)) {
                    dataFile.setAutoextend("OFF");
                }
            }
        }
    }

    private String getMeasureUnit(String value, String dfInfo) {
        String sizeStr = value.toUpperCase(Locale.ROOT);
        if (sizeStr.endsWith("K") || sizeStr.endsWith("M") || sizeStr.endsWith("G") || sizeStr.endsWith("T") || sizeStr.endsWith("P") || sizeStr.endsWith("E")) {
            return sizeStr.substring(sizeStr.length() - 1);
        }
        sizeStr = Token.getTokenAfter(dfInfo, value).toUpperCase(Locale.ROOT);
        if (sizeStr.equals("K") || sizeStr.equals("M") || sizeStr.equals("G") || sizeStr.equals("T") || sizeStr.equals("P") || sizeStr.equals("E")) {
            return sizeStr;
        }
        return "";
    }

    private String removeMeasureUnit(String value) {
        String sizeStr = value.toUpperCase(Locale.ROOT);
        if (sizeStr.endsWith("K") || sizeStr.endsWith("M") || sizeStr.endsWith("G") || sizeStr.endsWith("T") || sizeStr.endsWith("P") || sizeStr.endsWith("E")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private void initMinimumExtent() {
        String line;
        if (Token.hasToken(this.statement, "MINIMUM") && "EXTENT".equalsIgnoreCase(Token.getFirstToken(line = Token.getStringAfter(this.statement, "MINIMUM")).trim())) {
            String minExtLen = this.getNumberOnly(Token.getTokenAfter(line, "EXTENT").trim());
            try {
                int minExtent = Integer.parseInt(minExtLen);
                this.tableSpace.setMinExtLen(minExtent);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initMinimumExtent : " + e.getMessage());
            }
        }
    }

    private void initLogging() {
        if (Token.hasToken(this.statement, "NOLOGGING")) {
            this.tableSpace.setLogging("NOLOGGING");
        } else {
            this.tableSpace.setLogging("LOGGING");
        }
    }

    private void initForceLogging() {
        if (this.statement.toUpperCase(Locale.ROOT).indexOf("FORCE LOGGING") > -1) {
            this.tableSpace.setForceLogging("YES");
        }
    }

    private void initEncryption() {
        if (Token.hasToken(this.statement, "ENCRYPTION")) {
            int endQuoteIndex;
            String afterUsing;
            this.tableSpace.setEncrypt("YES");
            String afterEncryption = Token.getStringAfterToken(this.statement, "ENCRYPTION");
            if (Token.getFirstToken(afterEncryption).equalsIgnoreCase("USING") && (afterUsing = Token.cutTokenFromFront(afterEncryption, "USING")).startsWith("'") && (endQuoteIndex = afterUsing.indexOf("'", 1)) > 0) {
                this.tableSpace.setEncryptionAlgorithm(afterUsing.substring(1, endQuoteIndex));
            }
        }
    }

    private void initStatus() {
        if (Token.hasToken(this.statement, "OFFLINE")) {
            this.tableSpace.setStatus("OFFLINE");
        } else {
            this.tableSpace.setStatus("ONLINE");
        }
    }

    private void initContents() {
        if (Token.hasToken(this.statement, "TEMPORARY")) {
            this.tableSpace.setContents("TEMPORARY");
        }
    }

    private void initDefaultStorage() {
        String afterDefault = Token.getStringAfter(this.statement, "DEFAULT");
        if (!afterDefault.isEmpty()) {
            String line;
            this.initCompression(afterDefault);
            this.initInMemory(afterDefault);
            if (Token.hasToken(afterDefault, "STORAGE") && Token.hasCloseAndOpenBrackets(line = Token.getStringAfter(afterDefault, "STORAGE"))) {
                line = Token.getValBetweenBrackets(line, 1).trim();
                this.initInitialExtent(line);
                this.initMinExtents(line);
                this.initNextExtents(line);
                this.initMaxExtents(line);
                this.initPctIncrease(line);
                this.initEncrypt(line);
            }
        }
    }

    private void initCompression(String text) {
        if (Token.getFirstToken(text).equalsIgnoreCase("NOCOMPRESS")) {
            this.tableSpace.setDSCompression("NOCOMPRESS");
        } else if (Token.hasToken(text, "COMPRESS")) {
            this.tableSpace.setDSCompression("COMPRESS");
            if (this.stoDesign instanceof StorageDesignOraclev11g) {
                String afterCompress = Token.getStringAfter(text, "COMPRESS");
                String nextToken = Token.getFirstToken(afterCompress);
                if (nextToken.equalsIgnoreCase("BASIC")) {
                    this.tableSpace.setCompressionType("BASIC");
                } else if (nextToken.equalsIgnoreCase("ADVANCED")) {
                    this.tableSpace.setCompressionType("ADVANCED");
                } else if (nextToken.equalsIgnoreCase("FOR")) {
                    String afterFor = Token.cutTokenFromFront(afterCompress, "FOR");
                    nextToken = Token.getFirstToken(afterFor);
                    if (nextToken.equalsIgnoreCase("OLTP")) {
                        this.tableSpace.setCompressionType("OLTP");
                    } else {
                        String secondToken = Token.getToken(afterFor, 2);
                        if (nextToken.equalsIgnoreCase("QUERY")) {
                            if (secondToken.equalsIgnoreCase("LOW")) {
                                this.tableSpace.setCompressionType("QUERY LOW");
                            } else {
                                this.tableSpace.setCompressionType("QUERY HIGH");
                            }
                        } else if (nextToken.equalsIgnoreCase("ARCHIVE")) {
                            if (secondToken.equalsIgnoreCase("HIGH")) {
                                this.tableSpace.setCompressionType("ARCHIVE HIGH");
                            } else {
                                this.tableSpace.setCompressionType("ARCHIVE LOW");
                            }
                        }
                    }
                } else if (text.toUpperCase(Locale.ROOT).indexOf("COLUMN STORE COMPRESS") > -1) {
                    this.tableSpace.setCompressionType("QUERY HIGH");
                }
            }
        }
    }

    private void initInMemory(String text) {
        if (Token.hasToken(text, "INMEMORY")) {
            if (Token.getTokenBefore(text, "INMEMORY").equalsIgnoreCase("NO")) {
                this.tableSpace.setInMemory("NO");
            } else {
                String afterPriority;
                this.tableSpace.setInMemory("YES");
                String afterInMemory = Token.getStringAfter(text, "INMEMORY");
                if (Token.hasToken(afterInMemory, "MEMCOMPRESS")) {
                    if (Token.getTokenBefore(afterInMemory, "MEMCOMPRESS").equalsIgnoreCase("NO")) {
                        this.tableSpace.setInMemoryCompression("NO MEMCOMPRESS");
                    } else {
                        String afterMemCompress = Token.getStringAfter(afterInMemory, "MEMCOMPRESS");
                        if (Token.getFirstToken(afterMemCompress).equalsIgnoreCase("FOR")) {
                            String afterFor = Token.cutTokenFromFront(afterMemCompress, "FOR");
                            String compressType = Token.getFirstToken(afterFor);
                            if (compressType.equalsIgnoreCase("DML")) {
                                this.tableSpace.setInMemoryCompression("FOR DML");
                            } else {
                                String afterType = Token.cutTokenFromFront(afterFor, compressType);
                                String wordAfterType = Token.getFirstToken(afterType);
                                if (compressType.equalsIgnoreCase("QUERY")) {
                                    if (wordAfterType.equalsIgnoreCase("LOW")) {
                                        this.tableSpace.setInMemoryCompression("FOR QUERY LOW");
                                    } else if (wordAfterType.equalsIgnoreCase("HIGH")) {
                                        this.tableSpace.setInMemoryCompression("FOR QUERY HIGH");
                                    } else {
                                        this.tableSpace.setInMemoryCompression("FOR QUERY");
                                    }
                                } else if (compressType.equalsIgnoreCase("CAPACITY")) {
                                    if (wordAfterType.equalsIgnoreCase("LOW")) {
                                        this.tableSpace.setInMemoryCompression("FOR CAPACITY LOW");
                                    } else if (wordAfterType.equalsIgnoreCase("HIGH")) {
                                        this.tableSpace.setInMemoryCompression("FOR CAPACITY HIGH");
                                    } else {
                                        this.tableSpace.setInMemoryCompression("FOR CAPACITY");
                                    }
                                }
                            }
                        }
                    }
                }
                if (!(afterPriority = Token.getStringAfter(afterInMemory, "PRIORITY")).isEmpty()) {
                    String priority = Token.getFirstToken(afterPriority).toUpperCase(Locale.ROOT);
                    this.tableSpace.setInMemoryPriority(priority);
                }
                if (Token.hasToken(afterInMemory, "DISTRIBUTE")) {
                    String afterDistribute = Token.getStringAfter(afterInMemory, "DISTRIBUTE");
                    if (Token.getFirstToken(afterDistribute).equalsIgnoreCase("BY")) {
                        String afterBy = Token.cutTokenFromFront(afterDistribute, "BY");
                        if ((afterBy = Token.getFirstToken(afterBy)).equalsIgnoreCase("ROWID")) {
                            this.tableSpace.setInMemoryDistribute("BY ROWID RANGE");
                        } else if (afterBy.equalsIgnoreCase("PARTITION")) {
                            this.tableSpace.setInMemoryDistribute("BY PARTITION");
                        } else if (afterBy.equalsIgnoreCase("SUBPARTITION")) {
                            this.tableSpace.setInMemoryDistribute("BY SUBPARTITION");
                        } else {
                            this.tableSpace.setInMemoryDistribute("BY PARTITION");
                        }
                    } else {
                        this.tableSpace.setInMemoryDistribute("AUTO");
                    }
                }
                if (Token.hasToken(afterInMemory, "DUPLICATE")) {
                    if (Token.getTokenBefore(afterInMemory, "DUPLICATE").equalsIgnoreCase("NO")) {
                        this.tableSpace.setInMemoryDuplicate("NO DUPLICATE");
                    } else {
                        String afterDuplicate = Token.getStringAfter(afterInMemory, "DUPLICATE");
                        if (Token.getFirstToken(afterDuplicate).equalsIgnoreCase("ALL")) {
                            this.tableSpace.setInMemoryDuplicate("DUPLICATE ALL");
                        } else {
                            this.tableSpace.setInMemoryDuplicate("DUPLICATE");
                        }
                    }
                }
            }
        }
    }

    private void initInitialExtent(String line) {
        if (Token.hasToken(line, "INITIAL")) {
            String initExtentStr = this.getNumberOnly(Token.getTokenAfter(line, "INITIAL").trim());
            try {
                long initExtent = Long.parseLong(initExtentStr);
                this.tableSpace.setDSInitialExtent(initExtent);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initInitialExtent : " + e.getMessage());
            }
        }
    }

    private void initMinExtents(String line) {
        if (Token.hasToken(line, "MINEXTENTS")) {
            String initMinExtentsStr = this.getNumberOnly(Token.getTokenAfter(line, "MINEXTENTS").trim());
            try {
                int initMinExtents = Integer.parseInt(initMinExtentsStr);
                this.tableSpace.setDSMinExtents(initMinExtents);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initMinExtents : " + e.getMessage());
            }
        }
    }

    private void initNextExtents(String line) {
        if (Token.hasToken(line, "NEXT")) {
            String initNextExtentsStr = this.getNumberOnly(Token.getTokenAfter(line, "NEXT").trim());
            try {
                long initNextExtents = Long.parseLong(initNextExtentsStr);
                this.tableSpace.setDSNextExtent(initNextExtents);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initNextExtents : " + e.getMessage());
            }
        }
    }

    private void initMaxExtents(String line) {
        if (Token.hasToken(line, "MAXEXTENTS")) {
            String initMaxExtentsStr = this.getNumberOnly(Token.getTokenAfter(line, "MAXEXTENTS").trim());
            this.tableSpace.setDSMaxExtents(initMaxExtentsStr);
        }
    }

    private void initPctIncrease(String line) {
        if (Token.hasToken(line, "PCTINCREASE")) {
            String initPctIncStr = this.getNumberOnly(Token.getTokenAfter(line, "PCTINCREASE").trim());
            try {
                int initPctInc = Integer.parseInt(initPctIncStr);
                this.tableSpace.setDSPctIncrease(initPctInc);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initPctIncrease : " + e.getMessage());
            }
        }
    }

    private void initEncrypt(String line) {
        if (Token.hasToken(line, "ENCRYPT")) {
            this.tableSpace.setEncrypt("YES");
        }
    }

    private void initExtManagement() {
        String line = Token.getStringAfter(this.statement, "EXTENT MANAGEMENT");
        if (!line.isEmpty()) {
            if (Token.getFirstToken(line).equalsIgnoreCase("LOCAL")) {
                this.tableSpace.setExtentManagement("LOCAL");
                String localSubType = Token.getTokenAfter(line, "LOCAL").trim();
                if (localSubType.equalsIgnoreCase("UNIFORM")) {
                    this.tableSpace.setEMLocalSubtype("UNIFORM");
                    String sizeStr = this.getNumberOnly(Token.getTokenAfter(line, "SIZE").trim());
                    if (!sizeStr.equals("")) {
                        try {
                            int size = Integer.parseInt(sizeStr);
                            this.tableSpace.setEMUniformSize(size);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("wrong format in SHCreateTablespaceOracle.initExtManagement : " + e.getMessage());
                            this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                        }
                    }
                }
            } else if (Token.getFirstToken(line).equalsIgnoreCase("DICTIONARY")) {
                this.tableSpace.setExtentManagement("DICTIONARY");
            }
        }
    }

    private void initSegmentManagement() {
        String line = Token.getStringAfter(this.statement, "SEGMENT SPACE MANAGEMENT");
        if (!line.isEmpty()) {
            this.tableSpace.setSegmentManagement(Token.getFirstToken(line).toUpperCase(Locale.ROOT));
        }
    }
}

