/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.compare.Messages;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.util.HelpManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;
import oracle.jdeveloper.db.DatabaseConnections;

public class SyncConnectionDialog
extends JDialog
implements AbstractEditorConstants {
    private static final String KEY_ESCAPE = "ESCAPE";
    private DBConnectionStamp[] sourceConns;
    private List<Properties> redirectConns;
    private String[] redirectNames;
    private DBConnectionStamp prevRedirectConn = null;
    private List<String> selectedObjectStamps;
    private DBConnectionStamp[] result = new DBConnectionStamp[0];
    private JTable connTable;
    private JButton bnOK;
    private JComboBox cbRedirect;
    private JCheckBox chbUseSourceConnection;
    private JCheckBox chbUseSourceSchema;
    private JCheckBox chbUseSourceObject;
    private JCheckBox chbSyncWholeSchema;
    private JCheckBox chbExcludeRemoteObjects;
    private JCheckBox chbUserFromConnection;
    private Settings settings;
    private boolean syncToDB;
    private RelationalDesign relModel;
    private Action actF1 = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SyncConnectionDialog.this.showHelp();
        }
    };
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SyncConnectionDialog.access$102(SyncConnectionDialog.this, new DBConnectionStamp[0]);
            SyncConnectionDialog.this.dispose();
        }
    };

    public SyncConnectionDialog(Frame owner, RelationalDesign relModel, String title, String message, Object[] sourceConnections, Object prevRedirect, List<String> selectedObjStamps, boolean syncToDB) {
        super(owner, title, true);
        this.relModel = relModel;
        this.syncToDB = syncToDB;
        this.settings = ApplicationView.getInstance().getSettings();
        this.sourceConns = new DBConnectionStamp[sourceConnections.length];
        for (int i = 0; i < sourceConnections.length; ++i) {
            this.sourceConns[i] = ((DBConnectionStamp)sourceConnections[i]).getCopy();
        }
        this.prevRedirectConn = (DBConnectionStamp)prevRedirect;
        this.redirectConns = ConnectionInfo.getAllConnections(DatabaseConnections.getInstance(), false);
        this.selectedObjectStamps = selectedObjStamps;
        this.getContentPane().add((Component)this.init(message), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        KeyStroke ksF1 = KeyStroke.getKeyStroke(112, 0, false);
        c.getInputMap(condition).put(ksF1, "KEY_F1");
        c.getActionMap().put("KEY_F1", this.actF1);
        this.setMinimumSize(new Dimension(450, 420));
        this.setResizable(true);
        CommonUtil.centerOnScreen(this);
        if (this.sourceConns.length == 1) {
            this.connTable.setValueAt(Boolean.TRUE, 0, 1);
            if (this.prevRedirectConn != null) {
                this.cbRedirect.setSelectedItem(this.prevRedirectConn.getConnName());
                this.setSelectedColor();
                this.cbRedirect.updateUI();
            }
            this.setOkEnabled();
            this.bnOK.requestFocusInWindow();
        }
    }

    private void showHelp() {
        HelpManager.showTopic(this, "f1_connection_info_html");
    }

    private JPanel init(String message) {
        JPanel jpanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(message, 0);
        label.setPreferredSize(new Dimension(300, 20));
        jpanel.add((Component)label, "North");
        this.connTable = new JTable(new SyncConnectionModel());
        this.connTable.setSelectionMode(0);
        this.connTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    SyncConnectionDialog.this.setOkEnabled();
                }
            }
        });
        this.connTable.getColumnModel().getColumn(0).setCellRenderer(new SyncConnectionRenderer());
        this.connTable.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.connTable.getColumnModel().getColumn(1).setWidth(60);
        this.connTable.getColumnModel().getColumn(1).setMaxWidth(70);
        JScrollPane sp = new JScrollPane(this.connTable);
        jpanel.add((Component)sp, "Center");
        jpanel.add((Component)this.getRedirectOption(), "South");
        return jpanel;
    }

    protected void setSelectedColor() {
        block8: {
            try {
                int selected = this.cbRedirect.getSelectedIndex();
                if (selected > 0) {
                    Properties cd = this.redirectConns.get(this.cbRedirect.getSelectedIndex() - 1);
                    String sColor = cd.getProperty("Connection-Color-For-Editors");
                    if (sColor != null) {
                        Color color = null;
                        try {
                            color = new Color(Integer.parseInt(sColor));
                        }
                        catch (NumberFormatException nbe) {
                            // empty catch block
                        }
                        if (color != null) {
                            this.cbRedirect.setForeground(color);
                        } else {
                            this.cbRedirect.setForeground(UIManager.getColor("ComboBox.foreground"));
                        }
                        break block8;
                    }
                    this.cbRedirect.setForeground(UIManager.getColor("ComboBox.foreground"));
                    break block8;
                }
                this.cbRedirect.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private JPanel getRedirectOption() {
        JPanel pnRedirect = new JPanel(new GridBagLayout());
        JPanel jpanel2 = new JPanel(new GridLayout(2, 1));
        JPanel jpanel = new JPanel(new FlowLayout(0));
        JPanel connUserpanel = new JPanel(new FlowLayout(0));
        JLabel lbRedirect = new JLabel(" " + oracle.dbtools.crest.swingui.relational.Messages.getString("ControllerRelational.RedirectConnection"), 0);
        jpanel.add((Component)lbRedirect, "West");
        this.redirectNames = new String[this.redirectConns.size() + 1];
        this.redirectNames[0] = "";
        for (int i = 0; i < this.redirectConns.size(); ++i) {
            this.redirectNames[i + 1] = ConnectionInfo.getConnectionName(this.redirectConns.get(i));
        }
        this.cbRedirect = new JComboBox<String>(this.redirectNames);
        this.cbRedirect.setPreferredSize(new Dimension(160, 20));
        this.cbRedirect.setRenderer(new ComboBoxRenderer());
        this.cbRedirect.setMaximumRowCount(10);
        this.cbRedirect.setEnabled(true);
        this.setBG(this.cbRedirect);
        boolean found = false;
        if (this.prevRedirectConn != null) {
            String prevRedirectName = this.prevRedirectConn.getConnName();
            for (int j = 0; j < this.redirectNames.length; ++j) {
                if (!prevRedirectName.equalsIgnoreCase(this.redirectNames[j])) continue;
                this.cbRedirect.setSelectedItem(prevRedirectName);
                this.setSelectedColor();
                found = true;
                break;
            }
        }
        if (!found) {
            this.cbRedirect.setSelectedItem("");
        }
        this.cbRedirect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String conn = (String)SyncConnectionDialog.this.cbRedirect.getSelectedItem();
                if (!"".equals(conn)) {
                    for (int i = 0; i < SyncConnectionDialog.this.sourceConns.length; ++i) {
                        if (!conn.equalsIgnoreCase(SyncConnectionDialog.this.sourceConns[i].getConnName())) continue;
                        SyncConnectionDialog.this.connTable.setValueAt(Boolean.TRUE, i, 1);
                        SyncConnectionDialog.this.connTable.updateUI();
                        break;
                    }
                }
                SyncConnectionDialog.this.setOkEnabled();
                SyncConnectionDialog.this.setSelectedColor();
            }
        });
        jpanel.add((Component)this.cbRedirect, "Center");
        this.chbUserFromConnection = new JCheckBox("Use the connection user");
        connUserpanel.add(this.chbUserFromConnection);
        jpanel2.add(jpanel);
        jpanel2.add(connUserpanel);
        jpanel2.setBorder(BorderFactory.createTitledBorder(""));
        JPanel syncDBPanel = new JPanel(new GridLayout(5, 1));
        syncDBPanel.setBorder(BorderFactory.createTitledBorder(oracle.dbtools.crest.util.Messages.getString("ModelRelationallPP.DBSync")));
        this.chbUseSourceConnection = new JCheckBox(oracle.dbtools.crest.util.Messages.getString("ModelRelationallPP.UseSrcConnection"));
        syncDBPanel.add(this.chbUseSourceConnection);
        this.chbUseSourceSchema = new JCheckBox(oracle.dbtools.crest.util.Messages.getString("ModelRelationallPP.UseSrcSchema"));
        syncDBPanel.add(this.chbUseSourceSchema);
        this.chbUseSourceObject = new JCheckBox(oracle.dbtools.crest.util.Messages.getString("ModelRelationallPP.UseSrcObject"));
        syncDBPanel.add(this.chbUseSourceObject);
        this.chbSyncWholeSchema = new JCheckBox(oracle.dbtools.crest.util.Messages.getString("ModelRelationallPP.SyncWholeSchema"));
        syncDBPanel.add(this.chbSyncWholeSchema);
        this.chbExcludeRemoteObjects = new JCheckBox(oracle.dbtools.crest.util.Messages.getString("ModelRelationallPP.ExcludeRemoteObjectsFromSync"));
        this.chbExcludeRemoteObjects.setToolTipText(oracle.dbtools.crest.util.Messages.getString("ModelRelationallPP.RemoteObjectsAreExcludedFromSync"));
        syncDBPanel.add(this.chbExcludeRemoteObjects);
        JPanel butPanel = new JPanel(new FlowLayout(1));
        JButton jbut = new JButton(oracle.dbtools.crest.swingui.relational.Messages.getString("ControllerRelational.Preferences"));
        jbut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncConnectionDialog.this.saveSettings();
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), new String[]{"ModelingPreferences", "ModelPreferences", "ModelSynchronizationPhysicalPreferences", "ModelSynchronizationPhysicalOraclePreferences"});
                SyncConnectionDialog.this.applySettingsToUI();
            }
        });
        this.chbUseSourceConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncConnectionDialog.this.setOkEnabled();
            }
        });
        butPanel.add(jbut);
        pnRedirect.add((Component)jpanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        pnRedirect.add((Component)syncDBPanel, new GridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        pnRedirect.add((Component)butPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.applySettingsToUI();
        return pnRedirect;
    }

    public void setBG(Component c) {
        c.setBackground(Color.WHITE);
        if (!c.getFont().isPlain()) {
            c.setFont(new Font(c.getFont().getName(), 0, c.getFont().getSize()));
        }
    }

    private JPanel getRedirectOptionOld() {
        JPanel pnRedirect = new JPanel(new BorderLayout(10, 10));
        pnRedirect.add((Component)new JSeparator(), "North");
        JLabel lbRedirect = new JLabel(" " + oracle.dbtools.crest.swingui.relational.Messages.getString("ControllerRelational.RedirectConnection"), 0);
        pnRedirect.add((Component)lbRedirect, "West");
        this.redirectNames = new String[this.redirectConns.size() + 1];
        this.redirectNames[0] = "";
        for (int i = 0; i < this.redirectConns.size(); ++i) {
            this.redirectNames[i + 1] = ConnectionInfo.getConnectionName(this.redirectConns.get(i));
        }
        this.cbRedirect = new JComboBox<String>(this.redirectNames);
        this.cbRedirect.setRenderer(new ComboBoxRenderer());
        this.cbRedirect.setMaximumRowCount(10);
        this.cbRedirect.setEnabled(true);
        boolean found = false;
        if (this.prevRedirectConn != null) {
            String prevRedirectName = this.prevRedirectConn.getConnName();
            for (int j = 0; j < this.redirectNames.length; ++j) {
                if (!prevRedirectName.equalsIgnoreCase(this.redirectNames[j])) continue;
                this.cbRedirect.setSelectedItem(prevRedirectName);
                this.setSelectedColor();
                found = true;
                break;
            }
        }
        if (!found) {
            this.cbRedirect.setSelectedItem("");
        }
        this.cbRedirect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String conn = (String)SyncConnectionDialog.this.cbRedirect.getSelectedItem();
                if (!"".equals(conn)) {
                    for (int i = 0; i < SyncConnectionDialog.this.sourceConns.length; ++i) {
                        if (!conn.equalsIgnoreCase(SyncConnectionDialog.this.sourceConns[i].getConnName())) continue;
                        SyncConnectionDialog.this.connTable.setValueAt(Boolean.TRUE, i, 1);
                        SyncConnectionDialog.this.connTable.updateUI();
                        break;
                    }
                }
                SyncConnectionDialog.this.setOkEnabled();
                SyncConnectionDialog.this.setSelectedColor();
            }
        });
        pnRedirect.add((Component)this.cbRedirect, "Center");
        pnRedirect.add((Component)new JSeparator(), "South");
        return pnRedirect;
    }

    private void saveSettings() {
        this.settings.setUseDBSyncSourceConnection(this.chbUseSourceConnection.isSelected());
        this.settings.setUseDBSyncSourceSchema(this.chbUseSourceSchema.isSelected());
        this.settings.setUseDBSyncSourceObject(this.chbUseSourceObject.isSelected());
        this.settings.setSyncWholeSchema(this.chbSyncWholeSchema.isSelected());
        this.settings.setExcludeRemoteObjectsFromSync(this.chbExcludeRemoteObjects.isSelected());
        this.relModel.setUseConnectionUser(this.chbUserFromConnection.isSelected());
        if (this.chbUserFromConnection.isSelected()) {
            this.settings.setUseSchemaPropertyInCompare(false);
        }
    }

    private void applySettingsToUI() {
        this.chbUseSourceConnection.setSelected(this.settings.isUseDBSyncSourceConnection());
        this.chbUseSourceSchema.setSelected(this.settings.isUseDBSyncSourceSchema());
        this.chbUseSourceObject.setSelected(this.settings.isUseDBSyncSourceObject());
        this.chbSyncWholeSchema.setSelected(this.settings.isSyncWholeSchema());
        this.chbExcludeRemoteObjects.setSelected(this.settings.isExcludeRemoteObjectsFromSync());
        this.chbUserFromConnection.setSelected(this.relModel.isUseConnectionUser());
        if (!this.syncToDB) {
            this.chbExcludeRemoteObjects.setEnabled(false);
        }
    }

    public JPanel getBottomPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(oracle.dbtools.crest.util.Messages.getString("JListDialog.OK"));
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncConnectionDialog.this.saveSettings();
                if (SyncConnectionDialog.this.getSourceSelected() > 0 || SyncConnectionDialog.this.cbRedirect.getSelectedIndex() > -1) {
                    SyncConnectionDialog.this.setResult();
                } else {
                    SyncConnectionDialog.access$102(SyncConnectionDialog.this, new DBConnectionStamp[0]);
                }
                SyncConnectionDialog.this.dispose();
            }
        });
        this.setOkEnabled();
        this.bnOK.setFocusable(true);
        this.getRootPane().setDefaultButton(this.bnOK);
        bottomPanel.add(this.bnOK);
        JButton bnCancel = new JButton(oracle.dbtools.crest.util.Messages.getString("JListDialog.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncConnectionDialog.access$102(SyncConnectionDialog.this, new DBConnectionStamp[0]);
                SyncConnectionDialog.this.dispose();
            }
        });
        bottomPanel.add(bnCancel);
        JButton bnHelp = new JButton(oracle.dbtools.crest.util.Messages.getString("CustomDialog.Help"));
        bnHelp.setMnemonic(72);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncConnectionDialog.this.showHelp();
            }
        });
        bottomPanel.add(bnHelp);
        return bottomPanel;
    }

    private void setOkEnabled() {
        boolean useSC = this.chbUseSourceConnection.isSelected();
        boolean enable = false;
        if (this.getSourceSelected() == 1) {
            enable = true;
        } else if (!(this.getSourceSelected() <= 0 && useSC && this.sourceConns.length != 0 || this.cbRedirect.getSelectedIndex() <= 0)) {
            enable = true;
        }
        this.bnOK.setEnabled(enable);
    }

    private int getSourceSelected() {
        int count = 0;
        for (int i = 0; i < this.sourceConns.length; ++i) {
            if (this.sourceConns[i].getSyncSelected() != 1) continue;
            ++count;
        }
        return count;
    }

    public void setResult() {
        if (this.cbRedirect.getSelectedIndex() > -1) {
            DBConnectionStamp redirect = new DBConnectionStamp();
            if (this.cbRedirect.getSelectedIndex() > 0) {
                Properties cd = this.redirectConns.get(this.cbRedirect.getSelectedIndex() - 1);
                redirect.setConnName(ConnectionInfo.getConnectionName(cd));
                redirect.setConnUrl(cd.getProperty("customUrl"));
                redirect.setConnUser(cd.getProperty("user"));
                redirect.setConnType(ConnectionInfo.getConnectionType(cd));
                redirect.setSyncSelected(-1);
            } else if (this.getSourceSelected() == 1) {
                redirect.setSyncSelected(-1);
            } else {
                redirect = null;
            }
            if (redirect != null) {
                this.result = new DBConnectionStamp[this.sourceConns.length + 1];
                this.result[0] = redirect;
                for (int i = 0; i < this.sourceConns.length; ++i) {
                    this.result[i + 1] = this.sourceConns[i];
                }
            } else {
                this.result = new DBConnectionStamp[0];
            }
        } else {
            this.result = new DBConnectionStamp[0];
        }
    }

    public Object[] getResult() {
        return this.result;
    }

    public static Object showDialog(Frame owner, RelationalDesign relModel, String title, String message, Object[] sourceConnections, Object prevRedirect, List<String> selectedObjStamps, boolean syncToDB) {
        SyncConnectionDialog dialog = new SyncConnectionDialog(owner, relModel, title, message, sourceConnections, prevRedirect, selectedObjStamps, syncToDB);
        dialog.setVisible(true);
        return dialog.getResult();
    }

    static /* synthetic */ DBConnectionStamp[] access$102(SyncConnectionDialog x0, DBConnectionStamp[] x1) {
        x0.result = x1;
        return x1;
    }

    public class SyncConnectionRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            block11: {
                if (col == 0 && value != null && value instanceof String) {
                    this.setText((String)value);
                    if (!this.isValidConnectionName((String)value)) {
                        Map<TextAttribute, ?> attributes = this.getFont().getAttributes();
                        attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                        Font newFont = new Font(attributes);
                        this.setFont(newFont);
                    } else {
                        try {
                            if (isSelected) break block11;
                            Properties cd = DatabaseConnections.getInstance().getProperties((String)value);
                            if (cd != null) {
                                String sColor = cd.getProperty("Connection-Color-For-Editors");
                                if (sColor != null) {
                                    Color color = null;
                                    try {
                                        color = new Color(Integer.parseInt(sColor));
                                    }
                                    catch (NumberFormatException nbe) {
                                        // empty catch block
                                    }
                                    if (color != null) {
                                        this.setForeground(color);
                                    } else {
                                        this.setForeground(UIManager.getColor("Table.foreground"));
                                    }
                                    break block11;
                                }
                                this.setForeground(UIManager.getColor("Table.foreground"));
                                break block11;
                            }
                            this.setForeground(UIManager.getColor("Table.foreground"));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
            return this;
        }

        private boolean isValidConnectionName(String connName) {
            for (int i = 0; i < SyncConnectionDialog.this.redirectNames.length; ++i) {
                if (!connName.equalsIgnoreCase(SyncConnectionDialog.this.redirectNames[i])) continue;
                return true;
            }
            return false;
        }
    }

    public class SyncConnectionModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return SyncConnectionDialog.this.sourceConns.length;
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return oracle.dbtools.crest.swingui.relational.Messages.getString("ControllerRelational.SourceConnection");
            }
            if (column == 1) {
                return Messages.getString("CompareModelsDialog.Included");
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            DBConnectionStamp stamp = SyncConnectionDialog.this.sourceConns[row];
            if (col == 0) {
                return stamp.getConnName();
            }
            if (col == 1) {
                if (stamp.getSyncSelected() == 1) {
                    return true;
                }
                if (SyncConnectionDialog.this.selectedObjectStamps.contains(stamp.getConnName())) {
                    stamp.setSyncSelected(1);
                    return true;
                }
                return false;
            }
            return new Integer(row * col);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            DBConnectionStamp stamp = SyncConnectionDialog.this.sourceConns[row];
            if (col == 1) {
                if (((Boolean)aValue).booleanValue()) {
                    stamp.setSyncSelected(1);
                } else {
                    stamp.setSyncSelected(0);
                }
            }
        }
    }

    class ComboBoxRenderer
    extends DefaultListCellRenderer {
        ComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component ret;
            block8: {
                ret = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index == 0) {
                    ret.setPreferredSize(new Dimension(37, 16));
                }
                try {
                    Properties cd;
                    if (index <= 0 || (cd = (Properties)SyncConnectionDialog.this.redirectConns.get(index - 1)) == null || isSelected) break block8;
                    String sColor = cd.getProperty("Connection-Color-For-Editors");
                    if (sColor != null) {
                        Color color = null;
                        try {
                            color = new Color(Integer.parseInt(sColor));
                        }
                        catch (NumberFormatException nbe) {
                            // empty catch block
                        }
                        if (color != null) {
                            ret.setForeground(color);
                        } else {
                            ret.setForeground(UIManager.getColor("ComboBox.foreground"));
                        }
                        break block8;
                    }
                    ret.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }
    }
}

