/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import javax.swing.DefaultComboBoxModel;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNIncomingChangesChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.SVNOutgoingChangesChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.SVNUnversionedFilesChangeList;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.ide.layout.ViewId;
import oracle.jdeveloper.vcs.changelist.ChangeList;

public class SVNChangeListWindow
extends DataModelerChangeListWindow {
    public static final String WINDOW_ID = "SVNStatusCommandWindow";
    public static final ViewId VIEW_ID = new ViewId("EXTDockable", "SVNStatusCommandWindow");
    private static final SVNOutgoingChangesChangeList OUTGOING_CHANGES_CHANGELIST = new SVNOutgoingChangesChangeList();
    private static final SVNIncomingChangesChangeList INCOMING_CHANGES_CHANGE_LIST = new SVNIncomingChangesChangeList();
    private static final SVNUnversionedFilesChangeList UNVERSIONED_FILES_CHANGE_LIST = new SVNUnversionedFilesChangeList();
    private static final DefaultComboBoxModel SCOPE_COMBO_BOX_MODEL = new DefaultComboBoxModel();
    private static boolean openedOnStart = false;

    public SVNChangeListWindow() {
        super(new ChangeList[]{INCOMING_CHANGES_CHANGE_LIST, OUTGOING_CHANGES_CHANGELIST, UNVERSIONED_FILES_CHANGE_LIST}, VIEW_ID.getId());
        INCOMING_CHANGES_CHANGE_LIST.setWindow(this);
        INCOMING_CHANGES_CHANGE_LIST.setDependantChangeList(OUTGOING_CHANGES_CHANGELIST);
        INCOMING_CHANGES_CHANGE_LIST.setAutoRefreshDependantChangeList(true);
        INCOMING_CHANGES_CHANGE_LIST.getScopeComboBox().setModel(SCOPE_COMBO_BOX_MODEL);
        OUTGOING_CHANGES_CHANGELIST.setWindow(this);
        OUTGOING_CHANGES_CHANGELIST.setRefreshWhenNotVisible(true);
        OUTGOING_CHANGES_CHANGELIST.setDependantChangeList(INCOMING_CHANGES_CHANGE_LIST);
        OUTGOING_CHANGES_CHANGELIST.setAutoRefreshDependantChangeList(false);
        OUTGOING_CHANGES_CHANGELIST.setSecondDependantChangeList(UNVERSIONED_FILES_CHANGE_LIST);
        OUTGOING_CHANGES_CHANGELIST.setAutoRefreshSecondDependantChangeList(true);
        OUTGOING_CHANGES_CHANGELIST.getScopeComboBox().setModel(SCOPE_COMBO_BOX_MODEL);
        UNVERSIONED_FILES_CHANGE_LIST.setWindow(this);
        UNVERSIONED_FILES_CHANGE_LIST.setRefreshWhenNotVisible(true);
        UNVERSIONED_FILES_CHANGE_LIST.setVersionedOnly(false);
        SVNChangeListWindow.addToScope(ApplicationView.getInstance().getDesigns());
    }

    public static void addToScope(DesignSet designSet) {
        for (Design design : designSet) {
            if (!design.isVersioned()) continue;
            SVNChangeListWindow.addToScope(design);
        }
    }

    public static void addToScope(Design design) {
        if (SCOPE_COMBO_BOX_MODEL != null && (design.isVersioned() || SVNClientHelper.getInstance().isVersioned(design.getAppView().getSettings().getDefaultSystemTypesPath())) && SCOPE_COMBO_BOX_MODEL.getIndexOf(design) == -1) {
            SCOPE_COMBO_BOX_MODEL.addElement(design);
            if (design.isVersioned()) {
                SCOPE_COMBO_BOX_MODEL.setSelectedItem(design);
            }
        }
    }

    public static void removeFromScope(Design design) {
        if (SCOPE_COMBO_BOX_MODEL != null) {
            Design des;
            Object obj = SCOPE_COMBO_BOX_MODEL.getSelectedItem();
            SCOPE_COMBO_BOX_MODEL.removeElement(design);
            INCOMING_CHANGES_CHANGE_LIST.getScopeComboBox().updateUI();
            OUTGOING_CHANGES_CHANGELIST.getScopeComboBox().updateUI();
            UNVERSIONED_FILES_CHANGE_LIST.getScopeComboBox().updateUI();
            if (obj == design && SCOPE_COMBO_BOX_MODEL.getSize() > 0) {
                SCOPE_COMBO_BOX_MODEL.setSelectedItem(SCOPE_COMBO_BOX_MODEL.getElementAt(0));
            } else if (SCOPE_COMBO_BOX_MODEL.getSize() == 0 && (des = ApplicationView.getInstance().getCurrentDesign()) != null && design != des && !des.isLoading() && (des.isVersioned() || SVNClientHelper.getInstance().isVersioned(des.getAppView().getSettings().getDefaultSystemTypesPath()))) {
                SCOPE_COMBO_BOX_MODEL.addElement(des);
                SCOPE_COMBO_BOX_MODEL.setSelectedItem(des);
            }
        }
    }

    public static void clearScopeComboBox() {
        if (SCOPE_COMBO_BOX_MODEL != null) {
            Design des;
            Object obj = SCOPE_COMBO_BOX_MODEL.getSelectedItem();
            SCOPE_COMBO_BOX_MODEL.removeAllElements();
            if (SCOPE_COMBO_BOX_MODEL.getSize() == 0 && (des = ApplicationView.getInstance().getCurrentDesign()) != null && des.isVersioned()) {
                SCOPE_COMBO_BOX_MODEL.addElement(des);
                SCOPE_COMBO_BOX_MODEL.setSelectedItem(des);
            }
        }
    }

    public static SVNOutgoingChangesChangeList getSVNOutgoingChangesChangeList() {
        return OUTGOING_CHANGES_CHANGELIST;
    }

    public static SVNIncomingChangesChangeList getSVNIncomingChangesChangeList() {
        return INCOMING_CHANGES_CHANGE_LIST;
    }

    public static SVNUnversionedFilesChangeList getSVNUnversionedFilesChangeList() {
        return UNVERSIONED_FILES_CHANGE_LIST;
    }

    @Override
    public void refresh() {
        if (SVNChangeListWindow.getSelectedElementInScopeCB() != null && !SVNChangeListWindow.getSVNOutgoingChangesChangeList().isBusy()) {
            try {
                SVNChangeListWindow.getSVNOutgoingChangesChangeList().setBusy(true);
                SVNChangeListWindow.getSVNOutgoingChangesChangeList().refresh();
                this.first = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                SVNChangeListWindow.getSVNOutgoingChangesChangeList().setBusy(false);
            }
        }
    }

    public void setOpenedOnStart(boolean isOpened) {
        openedOnStart = isOpened;
    }

    public static boolean isOpenedOnStart() {
        return openedOnStart;
    }

    public static void clearPendingChangesLists() {
        OUTGOING_CHANGES_CHANGELIST.clear();
        INCOMING_CHANGES_CHANGE_LIST.clear();
        UNVERSIONED_FILES_CHANGE_LIST.clear();
    }

    public static Object getSelectedElementInScopeCB() {
        return SCOPE_COMBO_BOX_MODEL.getSelectedItem();
    }

    public void test() {
    }
}

