/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalUDBPreferences;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.panels.TraversableContext;

final class ModelPhysicalUDBPP
extends AbstractPP {
    private static final long serialVersionUID = -7817875659635446538L;
    private JTextField defaultUDBOwner;
    private JPanel pn;
    private JTextField defaultUDBTriggerName;
    private JTextField defaultUDBSequenceName;
    private JComboBox defaultUDBAutoIncDDL;
    private JComboBox defaultUDBIdentityDDL;
    private static final String NONE = Messages.getString("OptionsDialog.NONE");
    private static final String TRIGGER = Messages.getString("OptionsDialog.TRIGGER");
    private static final String IDENTITYClause = Messages.getString("OptionsDialog.IDENTITYClause");
    private static final String[] defaultAutoIncDDLChoices = new String[]{NONE, TRIGGER};
    private static final String[] defaultIdentityDDLChoices = new String[]{NONE, TRIGGER, IDENTITYClause};

    public ModelPhysicalUDBPP() {
        this.setHelpID("MODEL_PHYSICAL_UDB_PREFS_PANEL");
        this.pn = new JPanel(new GridBagLayout());
        this.pn.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.Defaults")));
        JLabel label = new JLabel(Messages.getString("OptionsDialog.DefaultOwner"));
        label.setPreferredSize(new Dimension(200, 20));
        this.addItem(this.pn, label, 0, 0, 1, 1, 17, 0, 100);
        this.defaultUDBOwner = new JTextField();
        this.defaultUDBOwner.setPreferredSize(new Dimension(260, 20));
        this.addItem(this.pn, this.defaultUDBOwner, 1, 0, 1, 1, 17, 100, 100);
        JPanel pnAutoIncrementColumnTemplates = new JPanel(new GridBagLayout());
        pnAutoIncrementColumnTemplates.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.AutoIncrementColumnTemplates")));
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.TriggerName")), 0, 0, 1, 1, 17, 0, 100);
        this.defaultUDBTriggerName = new JTextField();
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultUDBTriggerName, 1, 0, 1, 1, 17, 100, 100);
        JButton btnAddVariable = new JButton(Messages.getString("OptionsDialog.AddVariable"));
        this.addItem(pnAutoIncrementColumnTemplates, btnAddVariable, 2, 0, 1, 1, 17, 0, 100);
        btnAddVariable.addActionListener(new AddVariableActionListener(this.defaultUDBTriggerName));
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.SequenceName")), 0, 1, 1, 1, 17, 0, 100);
        this.defaultUDBSequenceName = new JTextField();
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultUDBSequenceName, 1, 1, 1, 1, 17, 100, 100);
        btnAddVariable = new JButton(Messages.getString("OptionsDialog.AddVariable"));
        this.addItem(pnAutoIncrementColumnTemplates, btnAddVariable, 2, 1, 1, 1, 17, 0, 100);
        btnAddVariable.addActionListener(new AddVariableActionListener(this.defaultUDBSequenceName));
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.DefaultAutoIncrementDDL")), 0, 2, 1, 1, 17, 0, 100);
        this.defaultUDBAutoIncDDL = new JComboBox<String>(defaultAutoIncDDLChoices);
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultUDBAutoIncDDL, 1, 2, 1, 1, 17, 100, 100);
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.DefaultIdentityDDL")), 0, 3, 1, 1, 17, 0, 100);
        this.defaultUDBIdentityDDL = new JComboBox<String>(defaultIdentityDDLChoices);
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultUDBIdentityDDL, 1, 3, 1, 1, 17, 100, 100);
        this.add(this.pn, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.add(pnAutoIncrementColumnTemplates, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    protected String translate(String value, String[] inputValues, String[] outputValues) {
        for (int i = 0; i < inputValues.length; ++i) {
            if (!inputValues[i].equals(value)) continue;
            return outputValues[i];
        }
        return "";
    }

    public void onEntry(TraversableContext tc) {
        this.defaultUDBOwner.setText(settings.getDefaultUDBOwner());
        this.defaultUDBTriggerName.setText(settings.getDefaultUDBTriggerName());
        this.defaultUDBSequenceName.setText(settings.getDefaultUDBSequenceName());
        this.defaultUDBAutoIncDDL.setSelectedItem(this.translate(settings.getDefaultUDBAutoIncDDL(), Settings.AUTOINCREMENT_DDL_UDB, defaultAutoIncDDLChoices));
        this.defaultUDBIdentityDDL.setSelectedItem(this.translate(settings.getDefaultUDBIdentityDDL(), Settings.IDENTITY_DDL_UDB, defaultIdentityDDLChoices));
    }

    public void onExit(TraversableContext tc) {
        settings.setDefaultUDBOwner(this.defaultUDBOwner.getText());
        settings.setDefaultUDBTriggerName(this.defaultUDBTriggerName.getText());
        settings.setDefaultUDBSequenceName(this.defaultUDBSequenceName.getText());
        settings.setDefaultUDBAutoIncDDL(this.translate((String)this.defaultUDBAutoIncDDL.getSelectedItem(), defaultAutoIncDDLChoices, Settings.AUTOINCREMENT_DDL_UDB));
        settings.setDefaultUDBIdentityDDL(this.translate((String)this.defaultUDBIdentityDDL.getSelectedItem(), defaultIdentityDDLChoices, Settings.IDENTITY_DDL_UDB));
        ModelPhysicalUDBPreferences preferences = this.getModelPhysicalUDBPreferences(tc);
        preferences.setDefaultUDBOwner(this.defaultUDBOwner.getText());
        preferences.setDefaultUDBTriggerName(this.defaultUDBTriggerName.getText());
        preferences.setDefaultUDBSequenceName(this.defaultUDBSequenceName.getText());
        preferences.setDefaultUDBAutoIncDDL(settings.getDefaultUDBAutoIncDDL());
        preferences.setDefaultUDBIdentityDDL(settings.getDefaultUDBIdentityDDL());
    }

    private ModelPhysicalUDBPreferences getModelPhysicalUDBPreferences(TraversableContext tc) {
        return ModelPhysicalUDBPreferences.getInstance(tc.getPropertyStorage());
    }

    private class AddVariableActionListener
    implements ActionListener {
        private JTextField textField;

        private AddVariableActionListener(JTextField textField) {
            this.textField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[][] tablespaceName = new String[][]{{"{table}", Messages.getString("ModelPhysicalUDBPP.TableName")}, {"{table abbr}", Messages.getString("ModelPhysicalUDBPP.TableAbbreviation")}, {"{column}", Messages.getString("ModelPhysicalUDBPP.ColumnName")}, {"{column abbr}", Messages.getString("ModelPhysicalUDBPP.ColumnAbbreviation")}};
            ModelPhysicalUDBPP.this.createDialog(tablespaceName, this.textField);
        }
    }
}

